/*
 * Decompiled with CFR 0.152.
 */
package quadbase.queryproc;

import java.sql.Timestamp;
import quadbase.queryproc.DateRECProvider;
import quadbase.queryproc.IRECProvider;
import quadbase.queryproc.QueryProc;

public class DateQueryProc
extends QueryProc {
    int mainColType;
    int intervalUnit;
    int numUnits;

    public DateQueryProc(boolean useObjectBuffer) {
        super(useObjectBuffer);
        this.setRounded(true);
    }

    @Override
    public int getRoundingIntervalUnit() {
        return this.intervalUnit;
    }

    @Override
    public Number getRoundingIntervalSize() {
        return this.numUnits;
    }

    @Override
    public void setRoundingIntervalUnit(int unit) {
        this.intervalUnit = unit;
        if (this.intervalUnit < 0 || this.intervalUnit >= 7) {
            throw new IllegalArgumentException("Invalid date/time interval unit :" + this.intervalUnit);
        }
    }

    @Override
    public void setRoundingIntervalSize(Number value) {
        this.numUnits = value.intValue();
    }

    @Override
    void verifyInput() throws Exception {
        super.verifyInput();
        this.mainColType = this.md.getColumnType(this.mainCol);
        if (this.mainColType != 91 && this.mainColType != 92 && this.mainColType != 93) {
            throw new IllegalArgumentException("Invalid date/time column :" + this.mainCol);
        }
    }

    @Override
    IRECProvider newRECProvider() {
        return new DateRECProvider((Timestamp)this.lBoundVal, (Timestamp)this.uBoundVal, this.intervalUnit, this.numUnits, this.mainColType);
    }
}

