/*
 * Decompiled with CFR 0.152.
 */
package quadbase.queryproc;

import java.util.Enumeration;
import java.util.Vector;
import quadbase.queryproc.ATreeNode;
import quadbase.queryproc.ICollationKey;
import quadbase.queryproc.ICollator;
import quadbase.queryproc.TreeLevelInfo;

public class VecTreeNode
extends ATreeNode {
    static final int DEFAULT_SIZE = 10;
    static final int DEFAULT_INCR = 10;
    Vector childNodes;
    ICollator collator;

    public VecTreeNode(TreeLevelInfo nodeInfo, ICollationKey key, boolean drawNullColumn, String nullHandleName) throws Exception {
        super(nodeInfo, key, drawNullColumn, nullHandleName);
        if (!this.info.isLeaf()) {
            this.childNodes = new Vector(10, 10);
            this.collator = this.info.getChildInfo().getCollator();
        }
    }

    @Override
    public int getChildCount() {
        return this.childNodes.size();
    }

    @Override
    public int getSubTreeCount() {
        if (this.info.isLeaf()) {
            return 0;
        }
        int size = this.childNodes.size();
        Enumeration e = this.childNodes.elements();
        while (e.hasMoreElements()) {
            ATreeNode node = (ATreeNode)e.nextElement();
            size += node.getSubTreeCount();
        }
        return size;
    }

    @Override
    protected ATreeNode getChild(Object childId) throws Exception {
        ATreeNode node;
        ICollationKey childKey = this.collator.getCollationKey(childId);
        int index = this.binarySearch(childKey);
        if (index < this.childNodes.size() && (node = (ATreeNode)this.childNodes.elementAt(index)).getKey().equals(childKey)) {
            return node;
        }
        TreeLevelInfo childInfo = this.info.getChildInfo();
        if (childInfo.getMaxChildren() <= this.childNodes.size()) {
            return null;
        }
        node = VecTreeNode.getNodeFactory().createATreeNode(childInfo, childKey, this.drawNullColumn, this.nullHandleName);
        if (index < this.childNodes.size()) {
            this.childNodes.insertElementAt(node, index);
        } else {
            this.childNodes.addElement(node);
        }
        return node;
    }

    protected int binarySearch(ICollationKey key) {
        int csize = 0;
        int lsize = 0;
        int rsize = this.childNodes.size() - 1;
        while (lsize <= rsize) {
            csize = (lsize + rsize) / 2;
            ATreeNode candidate = (ATreeNode)this.childNodes.elementAt(csize);
            int value = candidate.getKey().compareTo(key);
            if (value == 0) {
                return csize;
            }
            if (value > 0) {
                rsize = csize - 1;
                continue;
            }
            lsize = csize + 1;
        }
        return lsize;
    }

    @Override
    public Enumeration sortedChildren() {
        return this.childNodes.elements();
    }

    @Override
    public ATreeNode getSmallestChild() {
        if (this.childNodes.isEmpty()) {
            return null;
        }
        return (ATreeNode)this.childNodes.firstElement();
    }

    @Override
    public ATreeNode getLargestChild() {
        if (this.childNodes.isEmpty()) {
            return null;
        }
        return (ATreeNode)this.childNodes.lastElement();
    }
}

