/*
 * Decompiled with CFR 0.152.
 */
package quadbase.queryproc.filter;

import java.util.Vector;
import quadbase.queryproc.IQueryProc;
import quadbase.queryproc.filter.AFilterNode;
import quadbase.util.IRSMetaData;
import quadbase.util.IResultSet;

public class FilterResultSet
implements IResultSet {
    AFilterNode filterGraph;
    IResultSet inputRS;
    IQueryProc queryProc;
    int[] indexMap;

    public FilterResultSet(IResultSet rs, AFilterNode filterGraph) {
        this.inputRS = rs;
        if (filterGraph == null) {
            throw new IllegalArgumentException("Filter graph may not be null");
        }
        this.filterGraph = filterGraph;
    }

    @Override
    public boolean next() throws Exception {
        while (this.inputRS.next()) {
            if (this.queryProc != null) {
                this.makeObjectBuffer();
            }
            if (!this.filterGraph.pass(this.inputRS)) continue;
            return true;
        }
        this.indexMap = null;
        return false;
    }

    @Override
    public void close() throws Exception {
        this.inputRS.close();
    }

    @Override
    public IRSMetaData getMetaData() throws Exception {
        return this.inputRS.getMetaData();
    }

    @Override
    public Object getObject(int colNo) throws Exception {
        return this.inputRS.getObject(colNo);
    }

    public void setIQueryProc(IQueryProc queryProc) {
        this.queryProc = queryProc;
    }

    private void makeIndexMap() {
        int i;
        int[] queryProcArray = this.queryProc.getSortedColIndex();
        Vector colVector = this.filterGraph.getColumnVector(new Vector());
        int queryProcSize = queryProcArray.length;
        int vectorSize = colVector.size();
        int size = queryProcArray.length + vectorSize;
        this.indexMap = new int[size];
        for (i = 0; i < queryProcSize; ++i) {
            this.indexMap[i] = queryProcArray[i];
        }
        for (i = 0; i < vectorSize; ++i) {
            this.indexMap[i + queryProcSize] = (Integer)colVector.elementAt(i);
        }
        int bufferSize = this.indexMap.length;
        for (int i2 = 0; i2 < bufferSize - 1; ++i2) {
            for (int j = i2 + 1; j < bufferSize; ++j) {
                int value1 = this.indexMap[i2];
                int value2 = this.indexMap[j];
                if (value1 <= value2) continue;
                int temp = value1;
                this.indexMap[i2] = value2;
                this.indexMap[j] = temp;
            }
        }
    }

    private void makeObjectBuffer() throws Exception {
        if (this.indexMap == null) {
            this.makeIndexMap();
        }
        int size = this.indexMap.length;
        int lastValue = this.indexMap[0];
        this.inputRS.getObject(lastValue);
        for (int i = 1; i < size; ++i) {
            int curValue = this.indexMap[i];
            if (curValue <= lastValue) continue;
            this.inputRS.getObject(curValue);
            lastValue = curValue;
        }
    }
}

