/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.PageViewer;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.PrintJob;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.common.client.ServerMessage;
import quadbase.reportdesigner.PageViewer.Report;
import quadbase.reportdesigner.PageViewer.ReportInfo;

public class PrintReport
extends Report {
    private static final Logger LOGGER = Logger.getLogger(PrintReport.class.getName());
    private PrintJob printJob;
    private ReportInfo reportInfo;

    public PrintReport(Component comp, ReportInfo reportInfo) throws Exception {
        this(comp, reportInfo, PrintReport.getPrintJob(comp));
    }

    public PrintReport(Component component, ReportInfo reportInfo, PrintJob printJob) throws Exception {
        super(component, reportInfo);
        this.reportInfo = reportInfo;
        this.printJob = printJob;
    }

    public void print() throws Exception {
        Frame frame = this.reportInfo.getParent();
        if (frame == null) {
            frame = new Frame();
        }
        for (int i = 1; i <= this.reportInfo.getAllAvailPages(); ++i) {
            for (int j = 1; j <= this.getTotalSections(); ++j) {
                Graphics page = this.printJob.getGraphics();
                this.print(page, this.reportInfo, i, j);
                page.dispose();
            }
        }
        this.printJob.end();
    }

    private static PrintJob getPrintJob(Component component) {
        Frame frame = ServerMessage.getFrame();
        if (frame == null) {
            frame = component instanceof Frame ? (Frame)component : new Frame();
        }
        return frame.getToolkit().getPrintJob(frame, "report", null);
    }

    public static void printUsingSwing(Component comp, ReportInfo reportInfo) throws Exception {
        Constructor<?> objCons;
        Class<?> objClass;
        try {
            objClass = Class.forName("quadbase.reportdesigner.PageViewer.PrintReportForSwing");
            objCons = objClass.getConstructor(Component.class, ReportInfo.class);
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Failed to use PageViewer.PrintReportForSwing, trying PageViewer.swing.PrintReportForSwing", ex);
            objClass = Class.forName("quadbase.reportdesigner.PageViewer.swing.PrintReportForSwing");
            objCons = objClass.getConstructor(Component.class, ReportInfo.class);
        }
        Object printSwing = objCons.newInstance(comp, reportInfo);
        Method objMethod = objClass.getMethod("print", new Class[0]);
        objMethod.invoke(printSwing, new Object[0]);
    }
}

