/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.PageViewer;

import java.applet.Applet;
import java.awt.Adjustable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.net.URL;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.common.client.ServerMessage;
import quadbase.common.util.BrowseDirectories;
import quadbase.common.util.internal.FontTable;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.QbBrowseDirectories;
import quadbase.reportdesigner.PageViewer.CCanvas;
import quadbase.reportdesigner.PageViewer.CMessageDialog;
import quadbase.reportdesigner.PageViewer.CPanel;
import quadbase.reportdesigner.PageViewer.CScrollPane;
import quadbase.reportdesigner.PageViewer.CServerPortDialog;
import quadbase.reportdesigner.PageViewer.MouseThread;
import quadbase.reportdesigner.PageViewer.OpenSaveDialog;
import quadbase.reportdesigner.PageViewer.PopupMenuForReport;
import quadbase.reportdesigner.PageViewer.PrintReport;
import quadbase.reportdesigner.PageViewer.Report;
import quadbase.reportdesigner.PageViewer.ReportInfo;
import quadbase.reportdesigner.PageViewer.ReportToolBar;
import quadbase.reportdesigner.report.ImageMapNode;

public class ReportCanvas
extends CCanvas
implements Runnable,
MouseListener,
MouseMotionListener {
    private static final Logger LOGGER = Logger.getLogger(ReportCanvas.class.getName());
    String exportServlet = "http://localhost:8080/servlet/ViewerExportServlet";
    boolean exportTarget = true;
    BrowseDirectories browseDir;
    ReportInfo reportInfo;
    Report report;
    Image offScreenImage;
    Image offScreenImage2;
    Graphics backBuffer;
    Graphics backBuffer2;
    Color dataBgColor = new Color(253, 250, 217);
    Color dataFontColor = Color.black;
    Font dataFont = FontTable.newFont("TimesRoman", 0, 10);
    int hintX = 0;
    int hintY = 0;
    int prefWidth = 400;
    int prefHeight = 300;
    CScrollPane scrollPane;
    private boolean showScrollPane = true;
    boolean showDataHint = true;
    boolean showLinkHint = true;
    int selectedObject;
    boolean isDataPointSelected;
    boolean isPopupMenuOp;
    boolean isPopupTrigger;
    private int backLinkMask = IOUtil.getRightMouseClickMask();
    private int forwLinkMask = 0;
    private int forwLinkClickCount = 1;
    private int backLinkClickCount = 2;
    private int lastx;
    private int lasty;
    boolean isPopupMenuEnabled = true;
    String[] invisibleMenuItemList = null;
    Vector<Object> linkHistory = new Vector(10);
    MouseThread mouseThread = null;
    Cursor currentCursor;
    boolean printing = true;
    boolean refreshEnabled = true;
    int curPage = 1;
    int curSection = 1;
    boolean isExportEnabled = true;
    private MouseListener mouseListener = null;
    private MouseMotionListener mouseMotionListener = null;
    private ReportToolBar reportToolBar;
    private Container toolbarContainer;
    private boolean doMultiDrillDown;
    private Color canvasBackgroundColor = Color.white;
    public boolean menuVisible = true;
    public boolean sectionMenuVisible = true;
    public boolean pageMenuVisible = true;
    public boolean outputMenuVisible = true;
    public boolean backMenuItemVisible = true;
    public boolean refreshMenuItemVisible = true;
    public boolean goToMenuItemVisible = true;
    public boolean sortMenuVisible = true;
    public boolean multiDrillDownVisible = true;
    public boolean toolbarMenuVisible = true;
    public boolean zoomMenuItemVisible = true;
    public Vector<String> invisibleSectionMenuItem;
    public Vector<String> invisiblePageMenuItem;
    public Vector<String> invisibleOutputMenuItem;
    private float zoomFactor = 1.0f;
    private boolean hasDefaultDynamicExportParam = false;

    public ReportCanvas(ReportInfo iFile) {
        try {
            this.browseDir = new QbBrowseDirectories();
            this.reportInfo = iFile;
            this.report = new Report(this, iFile);
            this.scrollPane = new CScrollPane(this, 0);
            Adjustable vAdjust = this.scrollPane.getVAdjustable();
            Adjustable hAdjust = this.scrollPane.getHAdjustable();
            vAdjust.setUnitIncrement(5 * vAdjust.getUnitIncrement());
            hAdjust.setUnitIncrement(5 * hAdjust.getUnitIncrement());
            this.reportToolBar = new ReportToolBar(this);
            this.setSize((float)iFile.width * this.zoomFactor, (float)iFile.height * this.zoomFactor);
            CPanel mainPanel = new CPanel();
            if (this.showScrollPane) {
                mainPanel.add("Center", this.scrollPane);
            } else {
                mainPanel.add("Center", this);
            }
            this.toolbarContainer = mainPanel;
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.mouseThread = new MouseThread(this);
            this.addMouseMotionListener(this.mouseThread);
            this.mouseThread.setPriority(1);
            this.mouseThread.start();
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Cannot create new ReportCanvas", ex);
        }
    }

    public ReportToolBar getReportToolBar() {
        return this.reportToolBar;
    }

    public void setReportToolBarVisible(boolean b) {
        if (this.toolbarContainer == null) {
            return;
        }
        if (!b) {
            this.toolbarContainer.remove(this.reportToolBar);
            this.toolbarContainer.validate();
        } else {
            this.toolbarContainer.add("South", this.reportToolBar);
            this.toolbarContainer.validate();
        }
    }

    public boolean isReportToolBarVisible() {
        if (this.toolbarContainer == null) {
            return false;
        }
        for (int i = 0; i < this.toolbarContainer.getComponentCount(); ++i) {
            if (this.toolbarContainer.getComponent(i) != this.reportToolBar) continue;
            return true;
        }
        return false;
    }

    protected Container getToolbarContainer() {
        return this.toolbarContainer;
    }

    public void setParent(Frame frame) {
        this.reportInfo.setParent(frame);
    }

    private void removeCanvasListener() {
        if (this.mouseThread != null) {
            try {
                this.removeMouseMotionListener(this.mouseThread);
                this.mouseThread.pleaseStop();
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Failed to remove mouse motion listener", ex);
            }
            this.mouseThread = null;
        }
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
    }

    public void setMouseListener(MouseListener listener) {
        this.mouseListener = listener;
    }

    public void setMouseMotionListener(MouseMotionListener listener) {
        this.mouseMotionListener = listener;
    }

    protected void finalize() throws Throwable {
        this.removeCanvasListener();
    }

    public Report getReport() {
        return this.report;
    }

    public ReportInfo getReportInfo() {
        return this.reportInfo;
    }

    public Component getReportComponent() {
        return this.toolbarContainer;
    }

    public boolean isPopupMenuEnabled() {
        return this.isPopupMenuEnabled;
    }

    public void setPopupMenuEnabled(boolean b) {
        this.isPopupMenuEnabled = b;
    }

    public String[] getInvisibleMenuItemList() {
        return this.invisibleMenuItemList;
    }

    public void setInvisibleMenuItemList(String[] list) {
        this.invisibleMenuItemList = list;
    }

    public void setShowDataHint(boolean b) {
        this.showDataHint = b;
    }

    public boolean isShowDataHint() {
        return this.showDataHint;
    }

    public Dimension getDataHintOffset() {
        return new Dimension(this.hintX, this.hintY);
    }

    public void setDataHintOffset(Dimension dimension) {
        this.hintX = dimension.width;
        this.hintY = dimension.height;
    }

    public Color getDataHintBgColor() {
        return this.dataBgColor;
    }

    public void setDataHintBgColor(Color c) {
        this.dataBgColor = c;
    }

    public Color getDataHintFontColor() {
        return this.dataFontColor;
    }

    public void setDataHintFontColor(Color c) {
        this.dataFontColor = c;
    }

    public Font getDataHintFont() {
        return this.dataFont;
    }

    public void setDataHintFont(Font f) {
        this.dataFont = f;
    }

    public int getForwardLinkModifier() {
        return this.forwLinkMask;
    }

    public void setForwardLinkModifier(int m) {
        this.forwLinkMask = m;
    }

    public int getForwardLinkClickCount() {
        return this.forwLinkClickCount;
    }

    public void setForwardLinkClickCount(int c) {
        this.forwLinkClickCount = c;
    }

    public int getBackwardLinkModifier() {
        return this.backLinkMask;
    }

    public void setBackwardLinkModifier(int m) {
        this.backLinkMask = m;
    }

    public int getBackwardLinkClickCount() {
        return this.backLinkClickCount;
    }

    public void setBackwardLinkClickCount(int c) {
        this.backLinkClickCount = c;
    }

    public boolean isPrintKeyEnabled() {
        return this.printing;
    }

    public void setPrintKeyEnabled(boolean p) {
        this.printing = p;
    }

    public boolean isRefreshEnabled() {
        if (this.reportInfo != null) {
            return this.reportInfo.refreshData && this.refreshEnabled;
        }
        return this.refreshEnabled;
    }

    public void setRefreshEnabled(boolean r) {
        this.refreshEnabled = r;
    }

    public void setExportEnabled(boolean b) {
        this.isExportEnabled = b;
    }

    public boolean isExportEnabled() {
        if (this.reportInfo != null) {
            return this.reportInfo.refreshData && this.isExportEnabled;
        }
        return this.isExportEnabled;
    }

    @Override
    public void setSize(Dimension d) {
        this.setSize(d.width, d.height);
    }

    public void setSize(double w, double h) {
        this.setSize((int)Math.ceil(w), (int)Math.ceil(h));
    }

    @Override
    public void setSize(int w, int h) {
        if (!this.showScrollPane) {
            super.setSize(w, h);
            return;
        }
        if (this.scrollPane != null) {
            Dimension size = this.scrollPane.getViewSize();
            this.prefWidth = Math.max(size.width, w);
            this.prefHeight = Math.max(size.height, h);
        } else {
            this.prefWidth = w;
            this.prefHeight = h;
        }
        super.setSize(this.prefWidth, this.prefHeight);
    }

    @Override
    public Dimension getPreferredSize() {
        if (!this.showScrollPane) {
            return super.getPreferredSize();
        }
        if (this.report == null) {
            return new Dimension(this.prefWidth, this.prefHeight);
        }
        return new Dimension(Math.max(this.report.getWidth(), this.prefWidth), Math.max(this.report.getHeight(), this.prefHeight));
    }

    @Override
    public Dimension getMinimumSize() {
        if (!this.showScrollPane) {
            return super.getPreferredSize();
        }
        return new Dimension(this.prefWidth, this.prefHeight);
    }

    @Override
    public void run() {
    }

    @Override
    public void paint(Graphics g) {
        if (this.report == null) {
            super.paint(g);
            return;
        }
        this.update(g);
    }

    private void updateReportInfo() {
        if (this.report.needToUpdate(this.curPage, this.curSection)) {
            this.currentCursor = this.getCursor();
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.report.update(this.reportInfo, this.curPage, this.curSection);
            this.resetOffScreenImage();
            this.setCursor(this.currentCursor);
            if (this.reportToolBar != null) {
                this.reportToolBar.setEnabled();
            }
        }
    }

    @Override
    public void update(Graphics g) {
        if (this.showScrollPane) {
            this.scrollPane.doLayout();
            g = this.scrollPane.getClippedGraphics(g);
        }
        try {
            this.updateReportInfo();
            if (this.offScreenImage == null) {
                this.updateReportInfo();
                this.flushImage();
                this.offScreenImage = this.createImage(this.getSize().width, this.getSize().height);
                this.backBuffer = this.offScreenImage.getGraphics();
                this.report.zoomZoomZOOM(this.zoomFactor);
                this.report.draw(this.reportInfo, this.backBuffer, this.report.getWidth(), this.report.getHeight(), this.curPage, this.curSection);
            }
            Dimension d = this.getSize();
            g.setColor(this.canvasBackgroundColor);
            g.fillRect(0, 0, (int)d.getWidth(), (int)d.getHeight());
            g.drawImage(this.offScreenImage, 0, 0, this);
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Failed to update report canvas", ex);
        }
    }

    public int getZoomFactor() {
        return (int)Math.rint(this.zoomFactor * 100.0f);
    }

    public void setZoomFactor(int in) {
        if (in <= 0) {
            in = 100;
        }
        if (in > 200) {
            in = 200;
        }
        this.zoomFactor = (float)in / 100.0f;
        this.zoomResize();
        if (this.reportToolBar != null) {
            this.reportToolBar.updateZoomFactor();
        }
    }

    public void setPage(int page) {
        this.curPage = page;
    }

    public void setSection(int section) {
        this.curSection = section;
    }

    public void goToPreviousAvailPage() {
        if (!this.isPrevAvailPageEnabled()) {
            return;
        }
        if (this.curSection == 1) {
            this.setSection(this.report.getTotalSections());
            this.setPage(this.curPage - 1);
        } else {
            this.setSection(this.curSection - 1);
        }
    }

    public void goToNextAvailPage() {
        if (!this.isNextAvailPageEnabled()) {
            return;
        }
        int selPage = this.curPage;
        int selSec = this.curSection;
        if (this.curSection == this.report.getTotalSections()) {
            selSec = 1;
            selPage = this.curPage + 1;
        } else {
            selSec = this.curSection + 1;
        }
        if (this.reportInfo.isSelectedPageReady(selPage, selSec)) {
            this.setSection(selSec);
            this.setPage(selPage);
        } else {
            String err = "The page that you requested is currently unavailable.  Please wait a few second and try again.";
            CMessageDialog.showWarning(this, true, err);
        }
    }

    public boolean isPrevAvailPageEnabled() {
        return this.isPrevPageEnabled() || this.isPrevSectionEnabled();
    }

    public boolean isNextAvailPageEnabled() {
        if (!this.reportInfo.isTotalPagesReady()) {
            return true;
        }
        boolean isNextSecEn = this.isNextSectionEnabled();
        boolean isNextPageEn = this.isNextPageEnabled();
        boolean isFirstFileEn = this.isFirstFileAvail();
        return isFirstFileEn && (isNextPageEn || isNextSecEn);
    }

    public void setOrder(boolean isAsc, String sortColumn) {
        try {
            this.reportInfo.setOrder(sortColumn, isAsc);
            this.reportInfo.refresh(-1);
            this.curSection = 1;
            this.curPage = 1;
            this.report.update(this.reportInfo, 1, 1);
            this.setReport(this.reportInfo, this.report);
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Column ordering failed", ex);
        }
    }

    public void do_Reload() {
        try {
            if (this.countLinkHistory() == 0) {
                this.reportInfo.resetParameters();
            }
            this.reportInfo.resetSortKeys();
            this.reportInfo.refresh();
            this.curSection = 1;
            this.curPage = 1;
            this.report.update(this.reportInfo, 1, 1);
            this.setReport(this.reportInfo, this.report);
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Cannot reload report", ex);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.reportToolBar != null) {
            this.reportToolBar.setEnabled();
        }
        if (this.mouseListener != null) {
            this.mouseListener.mousePressed(e);
            return;
        }
        try {
            this.isPopupTrigger = false;
            this.isPopupMenuOp = false;
            this.currentCursor = this.getCursor();
            int xpos = this.lastx = e.getX();
            int ypos = this.lasty = e.getY();
            int mouseMask = e.getModifiers() & 0xFFFFFFEF;
            if (mouseMask == this.backLinkMask && e.getClickCount() == this.backLinkClickCount && this.goBackHyperLink()) {
                return;
            }
            ImageMapNode selectedData = this.report.selectDataMap(xpos, ypos);
            if (selectedData != null) {
                this.setCursor(Cursor.getPredefinedCursor(12));
                if (mouseMask == this.forwLinkMask && e.getClickCount() == this.forwLinkClickCount) {
                    if (selectedData.isDrillDownLink() && this.goToDrillDownLink(selectedData.getByteArray(), selectedData.getLink(), selectedData.getParameters(), selectedData.getDrillDownNodeIndex())) {
                        return;
                    }
                    if (this.gotoHyperLink(selectedData.getTarget(), selectedData.getLink())) {
                        return;
                    }
                    if (selectedData.isBookmark()) {
                        this.gotoBookmark(selectedData.getPageNumber(), selectedData.getSection(), selectedData.getY());
                        return;
                    }
                }
                if (e.getClickCount() == 1 && this.showLinkHint) {
                    this.isDataPointSelected = this.displayHint(selectedData.getHint(), xpos, ypos);
                }
            }
            if (mouseMask == IOUtil.getRightMouseClickMask() && e.getClickCount() == 1 && this.isPopupMenuEnabled()) {
                this.isPopupMenuOp = true;
                if (!this.isPopupTrigger) {
                    this.isPopupTrigger = e.isPopupTrigger();
                }
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Failed to perform an action", ex);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.mouseMotionListener != null) {
            this.mouseMotionListener.mouseDragged(e);
            return;
        }
        this.isPopupMenuOp = false;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.menuVisible) {
            if (this.mouseListener != null) {
                this.mouseListener.mouseReleased(e);
                return;
            }
            this.setCursor(this.currentCursor);
            int x = e.getX();
            int y = e.getY();
            if (!this.isPopupTrigger) {
                this.isPopupTrigger = e.isPopupTrigger();
            }
            if (this.isPopupMenuOp && x == this.lastx && y == this.lasty && this.isPopupTrigger) {
                try {
                    this.removeDataBox(x, y);
                    PopupMenuForReport popupMenu = new PopupMenuForReport(this);
                    if (popupMenu.getItemCount() > 0) {
                        this.add(popupMenu);
                        popupMenu.show(this, x, y);
                    }
                }
                catch (Exception ex) {
                    LOGGER.log(Level.WARNING, "REPORT CANVAS: cannot display popup menu", ex);
                }
                return;
            }
        }
        if (this.isDataPointSelected) {
            this.initBackImage(true);
            Graphics graphics = this.getGraphics();
            if (this.showScrollPane) {
                graphics = this.scrollPane.getClippedGraphics(graphics);
            }
            graphics.drawImage(this.offScreenImage2, 0, 0, this);
            this.isDataPointSelected = false;
            return;
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.mouseListener != null) {
            this.mouseListener.mouseClicked(e);
            return;
        }
        if (!this.isPopupTrigger) {
            this.isPopupTrigger = e.isPopupTrigger();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.mouseListener != null) {
            this.mouseListener.mouseEntered(e);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.mouseListener != null) {
            this.mouseListener.mouseExited(e);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.mouseMotionListener != null) {
            this.mouseMotionListener.mouseMoved(e);
            return;
        }
    }

    public void print() {
        try {
            this.currentCursor = this.getCursor();
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (IOUtil.isJava2D()) {
                PrintReport.printUsingSwing(this, this.reportInfo);
            } else {
                new PrintReport(this, this.reportInfo).print();
            }
            this.setCursor(this.currentCursor);
        }
        catch (Exception ex) {
            this.setCursor(this.currentCursor);
            LOGGER.log(Level.WARNING, "Print job cancelled", ex);
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private boolean setupDynamicExport(int format) {
        if (this.report.isDrillDownReport() && (format == 4 || format == 2 || format == 6) && !this.hasDefaultDynamicExportParam) {
            CServerPortDialog sDialog = new CServerPortDialog((Object)ServerMessage.getFrame());
            sDialog.setVisible(true);
            if (sDialog.isModified()) {
                String serverName = sDialog.getServerName();
                int serverPort = sDialog.getPortNumber();
                String servletDir = sDialog.getServletDirectory();
                this.setDynamicExport(this.reportInfo.isDynamicExport, serverName, serverPort, servletDir);
                this.hasDefaultDynamicExportParam = true;
                LOGGER.fine("dynamic export [" + serverName + ":" + serverPort + "," + servletDir + "]");
            } else {
                return false;
            }
        }
        return true;
    }

    void export(int format) {
        this.export(format, false);
    }

    void export(int format, boolean exportToMultiPages) {
        this.export(format, exportToMultiPages, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void export(int format, boolean exportToMultiPages, boolean paginatedSinglePage) {
        String ext = ".html";
        if (format == 2) {
            ext = ".pdf";
        } else if (format == 3) {
            ext = ".csv";
        } else if (format == 5) {
            ext = ".txt";
        } else if (format == 9) {
            ext = ".xls";
        } else if (format == 17) {
            ext = ".xlsx";
        } else if (format == 13) {
            ext = ".rtf";
        } else if (format == 6 || format == 7) {
            ext = ".xml";
        }
        try {
            if (!this.setupDynamicExport(format)) {
                return;
            }
            this.reportInfo.setExportTarget(this.getExportTarget());
            if (this.getExportTarget()) {
                String templatesDir = this.browseDir.getReportTemplatesDirectory();
                if (!templatesDir.endsWith("/") && !templatesDir.endsWith("\\")) {
                    templatesDir = templatesDir + "/";
                }
                OpenSaveDialog dialog = new OpenSaveDialog((Object)this.reportInfo.getParent(), "Please specify the file name :", templatesDir + "Untitled" + ext, ext);
                dialog.setCurrentDirectory(templatesDir);
                dialog.pack();
                dialog.setVisible(true);
                this.currentCursor = this.getCursor();
                this.setCursor(Cursor.getPredefinedCursor(3));
                if (dialog.getSelectedFile() != null) {
                    this.browseDir.setReportTemplatesDirectory(dialog.getCurrentDirectory());
                    this.reportInfo.export(format, dialog.getSelectedFile(), exportToMultiPages, paginatedSinglePage);
                }
            } else {
                this.currentCursor = this.getCursor();
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.reportInfo.setExportServlet(this.exportServlet);
                int key = this.reportInfo.export(format, null, exportToMultiPages, paginatedSinglePage);
                this.showExportInBrowser(key);
            }
            this.setCursor(this.currentCursor);
        }
        catch (Exception ex) {
            this.setCursor(this.currentCursor);
            LOGGER.log(Level.WARNING, "Failed to export report", ex);
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    void showDataBox(int xpos, int ypos) throws Exception {
        if (!this.showDataHint) {
            return;
        }
        if (this.report == null) {
            this.removeCanvasListener();
            return;
        }
        ImageMapNode selectedData = this.report.selectDataMap(xpos, ypos);
        if (selectedData != null) {
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.isDataPointSelected = this.displayHint(selectedData.getHint(), xpos, ypos);
        }
    }

    void removeDataBox(int xpos, int ypos) throws Exception {
        if (this.report == null) {
            this.removeCanvasListener();
            return;
        }
        ImageMapNode selectedData = this.report.selectDataMap(xpos, ypos);
        if (selectedData == null && this.isDataPointSelected) {
            this.initBackImage(true);
            Graphics graphics = this.getGraphics();
            if (this.showScrollPane) {
                graphics = this.scrollPane.getClippedGraphics(graphics);
            }
            graphics.drawImage(this.offScreenImage2, 0, 0, this);
            this.isDataPointSelected = false;
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    boolean isBackButtonVisible() {
        if (this.countLinkHistory() > 0) {
            return true;
        }
        Vector imageMap = this.report.getDataMap();
        if (imageMap == null) {
            return false;
        }
        for (int i = 0; i < imageMap.size(); ++i) {
            ImageMapNode node = (ImageMapNode)imageMap.elementAt(i);
            if (!node.isDrillDownLink()) continue;
            return true;
        }
        return false;
    }

    private boolean displayHint(String str, int x, int y) {
        return this.displayHint(str, this.dataBgColor, this.dataFontColor, this.dataFont, x + this.hintX, y + this.hintY);
    }

    private boolean displayHint(String str, Color bgColor, Color fnColor, Font font, int x, int y) {
        if (str == null || str.trim().equals("")) {
            return false;
        }
        this.initBackImage(true);
        FontMetrics fm = this.backBuffer2.getFontMetrics(font);
        int cw = fm.stringWidth("A");
        int w = fm.stringWidth(str);
        int txtheight = fm.getMaxAscent() + fm.getMaxDescent();
        int h = txtheight + 4;
        if (x + (w += 2 * cw) > this.report.getWidth()) {
            x = this.report.getWidth() - w;
        }
        if (y + h > this.report.getHeight()) {
            y = this.report.getHeight() - h;
        }
        this.backBuffer2.setColor(bgColor);
        this.backBuffer2.fill3DRect(x - 2, y, w, h, true);
        this.backBuffer2.setColor(fnColor);
        this.backBuffer2.setFont(font);
        this.backBuffer2.drawString(str, x + cw, y + txtheight);
        Graphics graphics = this.getGraphics();
        if (this.showScrollPane) {
            graphics = this.scrollPane.getClippedGraphics(graphics);
        }
        graphics.drawImage(this.offScreenImage2, 0, 0, this);
        return true;
    }

    boolean doMultiDrillDown(String link, Object[] params, int nodeIndex) {
        this.doMultiDrillDown = true;
        boolean val = this.goToDrillDownLink(null, link, params, nodeIndex);
        this.doMultiDrillDown = false;
        return val;
    }

    private boolean goToDrillDownLink(byte[] bytearray, String link, Object[] params, int nodeIndex) {
        if (link == null || link.trim().equals("") || link.trim().equals("http://") || link.trim().equals("https://")) {
            return false;
        }
        if (bytearray != null) {
            try {
                Vector<Object[]> vect = new Vector<Object[]>();
                vect.addElement(params);
                ReportInfo object = this.reportInfo;
                object.backupInfo(this.curPage, this.curSection);
                ReportInfo rptInfo = new ReportInfo(link, bytearray, params, -1L, this.reportInfo.parent, this.reportInfo.securityLevel, this.report.getFileName());
                Report cht = this.newReport(rptInfo);
                this.linkHistory.addElement(object);
                this.setReport(rptInfo, cht);
                this.repaint();
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Cannot go to drilldown link", ex);
                return false;
            }
        } else {
            Object obj = this.do_openReport(link, "", params);
            if (obj != null) {
                this.linkHistory.addElement(obj);
                if (this.reportToolBar != null) {
                    this.reportToolBar.setEnabled();
                }
            }
        }
        return true;
    }

    private boolean gotoHyperLink(String target, String link) {
        if (link == null || link.trim().equals("") || link.trim().equals("http://") || link.trim().equals("https://")) {
            return false;
        }
        Object obj = this.do_openReport(link, target);
        if (obj != null) {
            this.linkHistory.addElement(obj);
        }
        return true;
    }

    private void gotoBookmark(int pageNumber, int section, double y) {
        this.setPage(pageNumber);
        this.setSection(section);
        int xPos = 0;
        int yPos = (int)Math.rint(y / (double)this.reportInfo.height * (double)this.report.height * (double)this.report.propy);
        this.scrollPane.setScrollPosition(new Point(xPos, yPos));
        this.repaint();
    }

    boolean goBackHyperLink() {
        if (this.linkHistory.size() <= 0) {
            return false;
        }
        Object obj = this.linkHistory.lastElement();
        this.linkHistory.removeElement(obj);
        this.do_openReport((ReportInfo)obj);
        return true;
    }

    public boolean isNextPageEnabled() {
        return !this.reportInfo.isTotalPagesReady() || this.curPage < this.reportInfo.getTotalPages();
    }

    public boolean isPrevPageEnabled() {
        return this.curPage > 1;
    }

    public boolean isNextSectionEnabled() {
        return this.curSection < this.report.getTotalSections();
    }

    public boolean isPrevSectionEnabled() {
        return this.curSection > 1;
    }

    int getPage() {
        return this.curPage;
    }

    int getSection() {
        return this.curSection;
    }

    boolean isFirstFileAvail() {
        return this.reportInfo.isFirstFileAvail();
    }

    boolean isTotalPagesReady() {
        return this.reportInfo.isTotalPagesReady();
    }

    public int getTotalPages() {
        return this.reportInfo.getTotalPages();
    }

    public int getTotalSections() {
        return this.report.getTotalSections();
    }

    int getAllAvailPages() {
        return this.reportInfo.getAllAvailPages();
    }

    int countLinkHistory() {
        return this.linkHistory.size();
    }

    private Object do_openReport(String s, String target) {
        return this.do_openReport(s, target, null);
    }

    private Object do_openReport(String s, String target, Object[] params) {
        ReportInfo object = this.reportInfo;
        object.backupInfo(this.curPage, this.curSection);
        if (s.endsWith(".pak") || s.endsWith(".rpt") || s.endsWith(".xml")) {
            Report cht;
            ReportInfo rptInfo;
            try {
                this.currentCursor = Cursor.getPredefinedCursor(0);
                this.setCursor(Cursor.getPredefinedCursor(3));
                if (this.doMultiDrillDown && params == null) {
                    params = this.reportInfo.promptMultiDrillDownDialog();
                    this.doMultiDrillDown = false;
                }
                rptInfo = new ReportInfo(s, null, params, -1L, this.reportInfo.parent, this.reportInfo.securityLevel, this.reportInfo.rootFileName == null ? this.reportInfo.fileName : this.reportInfo.rootFileName);
                if (rptInfo.cancelled) {
                    this.setCursor(this.currentCursor);
                    return null;
                }
                cht = this.newReport(rptInfo);
                this.setCursor(this.currentCursor);
            }
            catch (Exception ex) {
                this.setCursor(this.currentCursor);
                LOGGER.log(Level.WARNING, "Cannot open report", ex);
                return null;
            }
            this.setReport(rptInfo, cht);
            return object;
        }
        Applet applet = ServerMessage.getApplet();
        if (applet == null) {
            LOGGER.warning("Cannot open link - applet is null: " + s);
            return null;
        }
        try {
            if (s.startsWith("http:") || s.startsWith("https:")) {
                applet.getAppletContext().showDocument(new URL(s), target);
            } else {
                applet.getAppletContext().showDocument(new URL(applet.getDocumentBase(), s), target);
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Cannot open link", ex);
        }
        return null;
    }

    private void do_openReport(ReportInfo backInfo) {
        try {
            this.currentCursor = Cursor.getPredefinedCursor(0);
            this.setCursor(Cursor.getPredefinedCursor(3));
            Report rpt = this.newReport(backInfo, backInfo.getLastBrowsePage(), backInfo.getLastBrowseSection());
            this.setCursor(this.currentCursor);
            this.setReport(backInfo, rpt);
        }
        catch (Exception ex) {
            this.setCursor(this.currentCursor);
            LOGGER.log(Level.WARNING, "Cannot open report", ex);
        }
    }

    private void zoomResize() {
        if (this.showScrollPane) {
            this.setSize((float)this.report.getWidth() * this.zoomFactor, (float)this.report.getHeight() * this.zoomFactor);
        }
    }

    private void setReport(ReportInfo rptInfo, Report report) {
        this.reportInfo = rptInfo;
        this.report = report;
        if (this.showScrollPane) {
            this.setSize((float)report.getWidth() * this.zoomFactor, (float)report.getHeight() * this.zoomFactor);
        }
        if (this.isReportToolBarVisible()) {
            boolean showBackBut = false;
            if (this.reportToolBar != null) {
                showBackBut = this.reportToolBar.isBackButtonVisible();
            }
            this.setReportToolBarVisible(false);
            this.reportToolBar = new ReportToolBar(this, showBackBut);
            this.setReportToolBarVisible(true);
            this.reportToolBar.setEnabled();
        }
        this.resetOffScreenImage();
        this.repaint();
    }

    private Report newReport(ReportInfo reportInfo) {
        return this.newReport(reportInfo, 1, 1);
    }

    private Report newReport(ReportInfo reportInfo, int p, int s) {
        this.curPage = p;
        this.curSection = s;
        return new Report(this, reportInfo, this.curPage, this.curSection);
    }

    private void initBackImage(boolean copy) {
        try {
            if (this.offScreenImage2 == null || this.offScreenImage2.getHeight(null) != this.report.getHeight() || this.offScreenImage2.getWidth(null) != this.report.getWidth()) {
                this.flushImage2();
                this.offScreenImage2 = this.createImage(this.report.getWidth(), this.report.getHeight());
                this.backBuffer2 = this.offScreenImage2.getGraphics();
            }
            Dimension d = this.getSize();
            this.backBuffer2.setColor(this.canvasBackgroundColor);
            this.backBuffer2.fillRect(0, 0, (int)d.getWidth(), (int)d.getHeight());
            if (copy && this.offScreenImage != null) {
                this.backBuffer2.drawImage(this.offScreenImage, 0, 0, this);
            } else {
                this.report.draw(this.reportInfo, this.backBuffer2);
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Cannot initialize background image", ex);
        }
    }

    private void flushImage() {
        if (this.offScreenImage != null) {
            this.offScreenImage.flush();
            this.offScreenImage = null;
        }
    }

    private void flushImage2() {
        if (this.offScreenImage2 != null) {
            this.offScreenImage2.flush();
            this.offScreenImage2 = null;
        }
    }

    public void resetOffScreenImage() {
        this.offScreenImage = null;
    }

    public void setBrowseDirectories(BrowseDirectories dir) {
        this.browseDir = dir;
    }

    public void setCanvasBackgroundColor(Color color) {
        this.canvasBackgroundColor = color != null ? color : Color.white;
    }

    public void setPageMenuItemVisible(String[] menuItem, boolean b) {
        if (menuItem == null) {
            return;
        }
        if (!b) {
            if (this.invisiblePageMenuItem == null) {
                this.invisiblePageMenuItem = new Vector();
            }
            for (String element : menuItem) {
                this.invisiblePageMenuItem.addElement(element);
            }
        } else {
            if (this.invisiblePageMenuItem == null) {
                return;
            }
            for (String element : menuItem) {
                this.invisiblePageMenuItem.remove(element);
            }
        }
    }

    public void setOutputMenuItemVisible(String[] menuItem, boolean b) {
        if (menuItem == null) {
            return;
        }
        if (!b) {
            if (this.invisibleOutputMenuItem == null) {
                this.invisibleOutputMenuItem = new Vector();
            }
            for (String element : menuItem) {
                this.invisibleOutputMenuItem.addElement(element);
            }
        } else {
            if (this.invisibleOutputMenuItem == null) {
                return;
            }
            for (String element : menuItem) {
                this.invisibleOutputMenuItem.remove(element);
            }
        }
    }

    public void setSectionMenuItemVisible(String[] menuItem, boolean b) {
        if (menuItem == null) {
            return;
        }
        if (!b) {
            if (this.invisibleSectionMenuItem == null) {
                this.invisibleSectionMenuItem = new Vector();
            }
            for (String element : menuItem) {
                this.invisibleSectionMenuItem.addElement(element);
            }
        } else {
            if (this.invisibleSectionMenuItem == null) {
                return;
            }
            for (String element : menuItem) {
                this.invisibleSectionMenuItem.remove(element);
            }
        }
    }

    boolean getExportTarget() {
        return this.exportTarget;
    }

    void setExportTarget(boolean server) {
        this.exportTarget = server;
    }

    private void showExportInBrowser(int key) {
        try {
            Applet applet = ServerMessage.getApplet();
            if (applet == null) {
                LOGGER.warning("Cannot show browser in non Applet");
                return;
            }
            URL url = new URL(this.exportServlet + "?key=" + key);
            applet.getAppletContext().showDocument(url, "ExportReport");
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Can't open report in browser", ex);
        }
    }

    public void setExportServlet(String url) {
        this.exportServlet = url;
    }

    public String getExportServlet() {
        return this.exportServlet;
    }

    public void setDynamicExport(boolean state, String serverName, int serverPort, String servletDirectory) {
        this.reportInfo.setDynamicExport(state, serverName, serverPort, servletDirectory);
        this.hasDefaultDynamicExportParam = true;
    }
}

