/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.PageViewer;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jnlp.ServiceManager;
import javax.jnlp.SingleInstanceListener;
import javax.jnlp.SingleInstanceService;
import javax.jnlp.UnavailableServiceException;
import quadbase.common.client.ServerMessage;
import quadbase.common.util.internal.FontTable;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbUtil;
import quadbase.reportdesigner.PageViewer.CApplet;
import quadbase.reportdesigner.PageViewer.CFrame;
import quadbase.reportdesigner.PageViewer.ReportCanvas;
import quadbase.reportdesigner.PageViewer.ReportInfo;

public class Viewer
extends CApplet {
    private static final Logger LOGGER = Logger.getLogger(Viewer.class.getName());
    boolean initialized = false;
    ReportCanvas reportCanvas;

    @Override
    public void init() {
        String hosts;
        String portno;
        String address;
        String servletContext;
        String comm_url;
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        Viewer.initJNLP();
        ServerMessage.setCheckMachineName(false);
        ServerMessage.useServer = this.getBoolean("EspressManagerUsed", true);
        String c_proto = this.getParameter("comm_protocol");
        if (c_proto != null) {
            if (c_proto.equalsIgnoreCase("http")) {
                ServerMessage.useHttp();
            } else if (c_proto.equalsIgnoreCase("servlet")) {
                ServerMessage.useServlet();
            }
        }
        if ((comm_url = this.getParameter("comm_url")) != null) {
            if (ServerMessage.isServlet()) {
                ServerMessage.setConnectServlet(comm_url);
            } else {
                ServerMessage.setConnectURL(comm_url);
            }
        }
        if ((servletContext = this.getParameter("servlet_context")) != null) {
            ServerMessage.setServletContext(servletContext);
        }
        if ((address = this.getParameter("server_address")) != null) {
            try {
                ServerMessage.setAddress(address);
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Can't set server address", ex);
            }
        }
        if ((portno = this.getParameter("server_port_number")) != null) {
            try {
                int portnumber = Integer.parseInt(portno);
                ServerMessage.setPortNumber(portnumber);
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Can't set port number", ex);
            }
        }
        if ((hosts = this.getParameter("server_hosts")) != null) {
            ServerMessage.setHosts(QbUtil.readMultiValues(hosts));
        }
        String filename = this.getParameter("file");
        String enc = this.getParameter("enc");
        if (filename != null && enc != null) {
            try {
                LanguageEncoder.loadFromServer(filename, enc);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Can't set encoding", e);
            }
        }
        ServerMessage.setApplet(this);
        ReportInfo reportFile = this.createReportInfo();
        this.reportCanvas = new ReportCanvas(reportFile);
        this.setParameters(this.reportCanvas);
        this.setBorderLayout();
        this.add("Center", this.reportCanvas.getReportComponent());
        this.reportCanvas.setReportToolBarVisible(true);
    }

    public static void main(String[] argv) {
        if (argv.length <= 0) {
            LOGGER.severe("Please specify file name");
            return;
        }
        ServerMessage.setApplet(null);
        CFrame frame = new CFrame("Viewer");
        WindowAdapter windowListener = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(1);
            }
        };
        frame.addWindowListener(windowListener);
        ServerMessage.setFrame(frame);
        LOGGER.finest("Use server: " + (argv.length > 1));
        ServerMessage.useServer = argv.length > 1;
        long bufferTime = 86400000L;
        if (argv.length > 1) {
            bufferTime = Viewer.getTime(argv[1]);
        }
        String securitylevel = null;
        if (argv.length > 2) {
            securitylevel = argv[2];
        }
        frame.setBorderLayout();
        ReportInfo reportFile = new ReportInfo(argv[0], bufferTime, securitylevel);
        ReportCanvas reportCanvas = new ReportCanvas(reportFile);
        frame.add("Center", reportCanvas.getReportComponent());
        reportCanvas.setReportToolBarVisible(true);
        frame.pack();
        frame.setSize(500, 500);
        frame.setVisible(true);
    }

    public static Component getComponent(Applet applet, String fileName, long bufferTimeInSec) {
        if (applet != null) {
            ServerMessage.setApplet(applet);
        }
        return Viewer.getComponent(fileName, bufferTimeInSec, null);
    }

    public static Component getComponent(Frame frame, String fileName, long bufferTimeInSec) {
        if (frame != null) {
            ServerMessage.setFrame(frame);
        }
        return Viewer.getComponent(fileName, bufferTimeInSec, null);
    }

    public static Component getComponent(Applet applet, String fileName, long bufferTimeInSec, String securityLevel) {
        if (applet != null) {
            ServerMessage.setApplet(applet);
        }
        return Viewer.getComponent(fileName, bufferTimeInSec, securityLevel);
    }

    public static Component getComponent(Frame frame, String fileName, long bufferTimeInSec, String securityLevel) {
        if (frame != null) {
            ServerMessage.setFrame(frame);
        }
        return Viewer.getComponent(fileName, bufferTimeInSec, securityLevel);
    }

    private static Component getComponent(String fileName, long bufferInSec, String securityLevel) {
        if (bufferInSec < 0L) {
            bufferInSec = 0L;
        }
        long bufferTime = bufferInSec * 1000L;
        ReportInfo reportFile = new ReportInfo(fileName, bufferTime, securityLevel);
        return new ReportCanvas(reportFile).getReportComponent();
    }

    public ReportCanvas getReportCanvas() {
        return this.reportCanvas;
    }

    public static ReportCanvas getReportCanvas(Applet applet, String fileName, long bufferTimeInSec) {
        return Viewer.getReportCanvas(applet, fileName, bufferTimeInSec, null);
    }

    public static ReportCanvas getReportCanvas(Frame frame, String fileName, long bufferTimeInSec) {
        return Viewer.getReportCanvas(frame, fileName, bufferTimeInSec, null);
    }

    public static ReportCanvas getReportCanvas(Applet applet, String fileName, long bufferTimeInSec, String securityLevel) {
        if (applet != null) {
            ServerMessage.setApplet(applet);
        }
        return Viewer.getReportCanvas(fileName, bufferTimeInSec, securityLevel);
    }

    public static ReportCanvas getReportCanvas(Frame frame, String fileName, long bufferTimeInSec, String securityLevel) {
        if (frame != null) {
            ServerMessage.setFrame(frame);
        }
        return Viewer.getReportCanvas(fileName, bufferTimeInSec, securityLevel);
    }

    private static ReportCanvas getReportCanvas(String fileName, long bufferInSec, String securityLevel) {
        if (bufferInSec < 0L) {
            bufferInSec = 0L;
        }
        long bufferTime = bufferInSec * 1000L;
        ReportInfo reportFile = new ReportInfo(fileName, bufferTime, securityLevel);
        return new ReportCanvas(reportFile);
    }

    private ReportInfo createReportInfo() {
        try {
            String tpl = this.getParameter("FileName");
            long bufferTime = Viewer.getTime(this.getParameter("BufferTime"));
            String securityLevel = this.getParameter("SecurityLevel");
            if (tpl != null) {
                return new ReportInfo(tpl, bufferTime, securityLevel);
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Failed to create ReportInfo", ex);
        }
        return null;
    }

    private void setParameters(ReportCanvas reportCanvas) {
        String hintX = this.getParameter("DataHintOffsetX");
        String hintY = this.getParameter("DataHintOffsetY");
        if (hintX != null && hintY != null) {
            reportCanvas.setDataHintOffset(new Dimension(Integer.parseInt(hintX), Integer.parseInt(hintY)));
        }
        reportCanvas.dataBgColor = this.getColor("DataHintBgColor", reportCanvas.dataBgColor);
        reportCanvas.dataFontColor = this.getColor("DataHintFontColor", reportCanvas.dataFontColor);
        reportCanvas.dataFont = this.getFont("DataHintFont", reportCanvas.dataFont);
        reportCanvas.printing = this.getBoolean("Printing", reportCanvas.printing);
        reportCanvas.refreshEnabled = this.getBoolean("RefreshData", reportCanvas.refreshEnabled);
        reportCanvas.isPopupMenuEnabled = this.getBoolean("PopupMenu", reportCanvas.isPopupMenuEnabled);
        reportCanvas.isExportEnabled = this.getBoolean("EnableExport", reportCanvas.isExportEnabled);
        reportCanvas.showDataHint = this.getBoolean("ShowDataHint", reportCanvas.showDataHint);
        reportCanvas.showLinkHint = this.getBoolean("ShowLinkHint", reportCanvas.showLinkHint);
    }

    private Font getFont(String s, Font f) {
        try {
            s = this.getParameter(s);
            if (s == null) {
                return f;
            }
            int idx1 = s.indexOf(44);
            int idx2 = s.lastIndexOf(44);
            return FontTable.newFont(s.substring(0, idx1).trim(), Integer.parseInt(s.substring(idx1 + 1, idx2).trim()), Integer.parseInt(s.substring(idx2 + 1).trim()));
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Can't get font", ex);
            return f;
        }
    }

    private boolean getBoolean(String s, boolean b) {
        if ((s = this.getParameter(s)) == null) {
            return b;
        }
        return s.equalsIgnoreCase("true");
    }

    private Color getColor(String s, Color c) {
        try {
            s = this.getParameter(s);
            if (s == null) {
                return c;
            }
            return new Color(Integer.parseInt(s, 16));
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Can't get color", ex);
            return c;
        }
    }

    private static long getTime(String Time2) {
        int interval;
        if (Time2 == null) {
            return 86400000L;
        }
        int len = Time2.length();
        try {
            switch (len) {
                case 1: 
                case 2: {
                    int minute;
                    interval = minute = Integer.valueOf(Time2).intValue();
                    break;
                }
                case 3: {
                    int hour = Integer.valueOf(Time2.substring(0, 1));
                    int minute = Integer.valueOf(Time2.substring(1, 3));
                    interval = hour * 60 + minute;
                    break;
                }
                case 4: {
                    int hour = Integer.valueOf(Time2.substring(0, 2));
                    int minute = Integer.valueOf(Time2.substring(2, 4));
                    interval = hour * 60 + minute;
                    break;
                }
                case 5: {
                    int day = Integer.valueOf(Time2.substring(0, 1));
                    int hour = Integer.valueOf(Time2.substring(1, 3));
                    int minute = Integer.valueOf(Time2.substring(3, 5));
                    interval = day * 60 * 24 + hour * 60 + minute;
                    break;
                }
                case 6: {
                    int day = Integer.valueOf(Time2.substring(0, 2));
                    int hour = Integer.valueOf(Time2.substring(2, 4));
                    int minute = Integer.valueOf(Time2.substring(4, 6));
                    interval = day * 60 * 24 + hour * 60 + minute;
                    break;
                }
                default: {
                    interval = 1440;
                    break;
                }
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Invalid time interval, using 24 * 60", ex);
            interval = 1440;
        }
        return interval * 60 * 1000;
    }

    public static void setServletRunner(String comm_url) {
        ServerMessage.setConnectServlet(comm_url);
    }

    public static void useServlet(boolean b) {
        if (b) {
            ServerMessage.useServlet();
        } else {
            ServerMessage.useSocket();
        }
    }

    public static void setServletContext(String context) {
        ServerMessage.setServletContext(context);
    }

    public static String getServletContext() {
        return ServerMessage.getServletContext();
    }

    public void setMenuVisible(boolean b) {
        this.reportCanvas.menuVisible = b;
    }

    public void setSectionMenuVisible(boolean b) {
        this.reportCanvas.sectionMenuVisible = b;
    }

    public void setSectionMenuItemVisible(String[] menuItem, boolean b) {
        this.reportCanvas.setSectionMenuItemVisible(menuItem, b);
    }

    public void setPageMenuVisible(boolean b) {
        this.reportCanvas.pageMenuVisible = b;
    }

    public void setPageMenuItemVisible(String[] menuItem, boolean b) {
        this.reportCanvas.setPageMenuItemVisible(menuItem, b);
    }

    public void setOutputMenuVisible(boolean b) {
        this.reportCanvas.outputMenuVisible = b;
    }

    public void setOutputMenuItemVisible(String[] menuItem, boolean b) {
        this.reportCanvas.setOutputMenuItemVisible(menuItem, b);
    }

    public void setBackMenuItemVisible(boolean b) {
        this.reportCanvas.backMenuItemVisible = b;
    }

    public void setRefreshMenuItemVisible(boolean b) {
        this.reportCanvas.refreshMenuItemVisible = b;
    }

    public void setGoToMenuItemVisible(boolean b) {
        this.reportCanvas.goToMenuItemVisible = b;
    }

    public void setSortMenuVisible(boolean b) {
        this.reportCanvas.sortMenuVisible = b;
    }

    public void setMultiDrillDownVisible(boolean b) {
        this.reportCanvas.multiDrillDownVisible = b;
    }

    public void setToolBarMenuVisible(boolean b) {
        this.reportCanvas.toolbarMenuVisible = b;
    }

    public void setExportServlet(String url) {
        this.reportCanvas.setExportServlet(url);
    }

    public void setDynamicExport(boolean state, String serverName, int serverPort, String servletDirectory) {
        this.reportCanvas.setDynamicExport(state, serverName, serverPort, servletDirectory);
    }

    private static void initJNLP() {
        if (ServerMessage.isJnlp()) {
            Viewer.deleteJNLPFile();
            Viewer.registerJNLPSingleton();
        }
    }

    private static void deleteJNLPFile() {
        File jnlpFile;
        String jnlpPath = System.getProperty("jnlpx.origFilenameArg");
        if (jnlpPath != null && !(jnlpFile = new File(jnlpPath)).delete()) {
            LOGGER.warning("Failed to delete JNLP file " + jnlpPath);
        }
    }

    private static void registerJNLPSingleton() {
        try {
            SingleInstanceService singleInstanceService = (SingleInstanceService)ServiceManager.lookup((String)"javax.jnlp.SingleInstanceService");
            singleInstanceService.addSingleInstanceListener(new SingleInstanceListener(){

                public void newActivation(String[] strings) {
                    Viewer.deleteJNLPFile();
                }
            });
        }
        catch (UnavailableServiceException e) {
            LOGGER.log(Level.WARNING, "Failed to register SingleInstanceService", e);
        }
    }
}

