/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.PageViewer;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Frame;
import java.util.Properties;
import java.util.Vector;
import quadbase.common.client.ServerMessage;
import quadbase.common.util.internal.LCKey;
import quadbase.reportdesigner.PageViewer.ReportCanvas;
import quadbase.reportdesigner.PageViewer.ReportInfo;
import quadbase.reportdesigner.ReportAPI.QbReport;
import quadbase.reportdesigner.report.Parameter;

public class ViewerAPI {
    ReportCanvas reportCanvas = null;

    public Component getComponent(Applet applet, QbReport report, long bufferTimeInSec, String securityLevel) throws Exception {
        if (applet != null) {
            ServerMessage.setApplet(applet);
        }
        return this.getComponent(report, bufferTimeInSec, securityLevel);
    }

    public Component getComponent(Frame frame, QbReport report, long bufferTimeInSec, String securityLevel) throws Exception {
        if (frame != null) {
            ServerMessage.setFrame(frame);
        }
        return this.getComponent(report, bufferTimeInSec, securityLevel);
    }

    private Component getComponent(QbReport report, long bufferInSec, String securityLevel) throws Exception {
        if (bufferInSec < 0L) {
            bufferInSec = 0L;
        }
        long bufferTime = bufferInSec * 1000L;
        String reportName = null;
        String pakFile = null;
        Properties props = new Properties();
        props.put("pageViewer", "true");
        if (LCKey.isDashboardOnly()) {
            reportName = System.currentTimeMillis() + "_QRP";
            pakFile = ReportInfo.getFileName(reportName, null) + ".qrp";
            report.export(1, pakFile, props, null);
        } else {
            reportName = System.currentTimeMillis() + "_PAK";
            pakFile = ReportInfo.getFileName(reportName, null) + ".pak";
            report.export(10, pakFile, props, null);
        }
        boolean paramValueSet = false;
        Vector<Parameter> queryParams = report.getQueryParameters();
        Object[] qParams = new Object[queryParams.size()];
        for (int i = 0; i < queryParams.size(); ++i) {
            if (queryParams.elementAt(i).getValue() == null) continue;
            qParams[i] = queryParams.elementAt(i).getValue();
            paramValueSet = true;
        }
        Vector<Parameter> formulaParams = report.getFormulaParameters();
        Object[] fParams = new Object[formulaParams.size()];
        for (int i = 0; i < formulaParams.size(); ++i) {
            if (formulaParams.elementAt(i).getValue() == null) continue;
            fParams[i] = formulaParams.elementAt(i).getValue();
            paramValueSet = true;
        }
        ReportInfo reportFile = paramValueSet ? new ReportInfo(pakFile, null, qParams, bufferTime, null, securityLevel, null) : new ReportInfo(pakFile, bufferTime, securityLevel);
        this.reportCanvas = new ReportCanvas(reportFile);
        return this.reportCanvas.getReportComponent();
    }

    public ReportCanvas getReportCanvas() {
        return this.reportCanvas;
    }

    public void setMenuVisible(boolean b) {
        this.reportCanvas.menuVisible = b;
    }

    public void setSectionMenuVisible(boolean b) {
        this.reportCanvas.sectionMenuVisible = b;
    }

    public void setSectionMenuItemVisible(String[] menuItem, boolean b) {
        this.reportCanvas.setSectionMenuItemVisible(menuItem, b);
    }

    public void setPageMenuVisible(boolean b) {
        this.reportCanvas.pageMenuVisible = b;
    }

    public void setPageMenuItemVisible(String[] menuItem, boolean b) {
        this.reportCanvas.setPageMenuItemVisible(menuItem, b);
    }

    public void setOutputMenuVisible(boolean b) {
        this.reportCanvas.outputMenuVisible = b;
    }

    public void setOutputMenuItemVisible(String[] menuItem, boolean b) {
        this.reportCanvas.setOutputMenuItemVisible(menuItem, b);
    }

    public void setBackMenuItemVisible(boolean b) {
        this.reportCanvas.backMenuItemVisible = b;
    }

    public void setRefreshMenuItemVisible(boolean b) {
        this.reportCanvas.refreshMenuItemVisible = b;
    }

    public void setGoToMenuItemVisible(boolean b) {
        this.reportCanvas.goToMenuItemVisible = b;
    }

    public void setSortMenuVisible(boolean b) {
        this.reportCanvas.sortMenuVisible = b;
    }

    public void setMultiDrillDownVisible(boolean b) {
        this.reportCanvas.multiDrillDownVisible = b;
    }

    public void setZoomMenuItemVisible(boolean b) {
        this.reportCanvas.zoomMenuItemVisible = b;
    }

    public void setToolBarMenuVisible(boolean b) {
        this.reportCanvas.toolbarMenuVisible = b;
    }

    public void setExportServlet(String url) {
        this.reportCanvas.setExportServlet(url);
    }

    public void setDynamicExport(boolean state, String serverName, int serverPort, String servletDirectory) {
        this.reportCanvas.setDynamicExport(state, serverName, serverPort, servletDirectory);
    }
}

