/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.PageViewer.swing;

import java.awt.Button;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.reportdesigner.PageViewer.swing.CDialog;

public class CServerPortDialog
extends CDialog
implements ActionListener {
    private static final Logger LOGGER = Logger.getLogger(CServerPortDialog.class.getName());
    private Button okButton;
    private Button cancelButton;
    private TextField serverText;
    private TextField portText;
    private TextField directoryText;
    private String server = "";
    private String servletDirectory = "";
    private int port = -1;
    private boolean modified = false;

    public CServerPortDialog(Object frame) {
        super(frame, "Servlet Location", true);
        this.init();
        this.setPosition();
    }

    private void init() {
        this.setBackground(Color.lightGray);
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.setLayout(this, gbl);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        Label comp = new Label("Please specify the location of the drill-down servlet:");
        gbl.setConstraints(comp, gbc);
        this.add(comp);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 13;
        comp = new Label("Server Name: ");
        gbl.setConstraints(comp, gbc);
        this.add(comp);
        gbc.gridx = 0;
        gbc.gridy = 2;
        comp = new Label("Port Number: ");
        gbl.setConstraints(comp, gbc);
        this.add(comp);
        gbc.gridx = 0;
        gbc.gridy = 3;
        comp = new Label("Servlet Directory: ");
        gbl.setConstraints(comp, gbc);
        this.add(comp);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 17;
        this.serverText = new TextField("127.0.0.1", 15);
        Dimension d = this.serverText.getPreferredSize();
        d.setSize(5.0, d.getHeight());
        gbl.setConstraints(this.serverText, gbc);
        this.add(this.serverText);
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.anchor = 17;
        this.portText = new TextField("8080", 15);
        d = this.portText.getPreferredSize();
        d.setSize(5.0, d.getHeight());
        gbl.setConstraints(this.portText, gbc);
        this.add(this.portText);
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.anchor = 17;
        this.directoryText = new TextField("servlet/", 15);
        d = this.directoryText.getPreferredSize();
        d.setSize(5.0, d.getHeight());
        gbl.setConstraints(this.directoryText, gbc);
        this.add(this.directoryText);
        Panel okpanel = new Panel();
        okpanel.setLayout(new FlowLayout());
        this.okButton = new Button("OK");
        this.okButton.addActionListener(this);
        okpanel.add(this.okButton);
        this.cancelButton = new Button("Cancel");
        this.cancelButton.addActionListener(this);
        okpanel.add(this.cancelButton);
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 2;
        gbc.anchor = 10;
        gbl.setConstraints(okpanel, gbc);
        this.add(okpanel);
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            this.server = this.serverText.getText().trim();
            this.servletDirectory = this.directoryText.getText().trim();
            try {
                this.port = Integer.parseInt(this.portText.getText().trim());
            }
            catch (NumberFormatException ex) {
                LOGGER.log(Level.FINEST, "Port number: Invalid numer", ex);
            }
            if (this.server == null || this.server.equals("") || this.port < 0 || this.port > 50000) {
                return;
            }
            this.modified = true;
            this.setVisible(false);
            this.dispose();
        } else if (e.getSource() == this.cancelButton) {
            this.modified = false;
            this.setVisible(false);
            this.dispose();
        }
    }

    public String getServerName() {
        return this.server;
    }

    public int getPortNumber() {
        return this.port;
    }

    public String getServletDirectory() {
        return this.servletDirectory;
    }

    public boolean isModified() {
        return this.modified;
    }
}

