/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.PageViewer.swing;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.List;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.Date;
import java.util.EventListener;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import quadbase.common.client.ServerMessage;
import quadbase.common.paramquery.OurPanel;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.QbDateFormat;
import quadbase.reportdesigner.PageViewer.swing.CButton;
import quadbase.reportdesigner.PageViewer.swing.CCalendarDialog;
import quadbase.reportdesigner.PageViewer.swing.CChoice;
import quadbase.reportdesigner.PageViewer.swing.CDialog;
import quadbase.reportdesigner.PageViewer.swing.CLabel;
import quadbase.reportdesigner.PageViewer.swing.CMessageDialog;
import quadbase.reportdesigner.PageViewer.swing.CPanel;
import quadbase.reportdesigner.PageViewer.swing.CTextField;
import quadbase.reportdesigner.PageViewer.swing.ReportInfo;

public class EnterParamDialog
extends CDialog
implements ActionListener,
ItemListener {
    private static final Logger LOGGER = Logger.getLogger(EnterParamDialog.class.getName());
    public static final int DIALOG_SIZE_INCREMENT = 50;
    JButton[] allButton;
    JButton[] noneButton;
    boolean[] isAllOptionEnabled;
    String[] allOptionLabel;
    String[] columnName;
    Object[][] choice;
    boolean[] isMultiValue;
    boolean[] useComboBox;
    int[] sqlType;
    CButton okButton;
    CButton resetButton;
    CChoice[] choiceArray;
    CTextField[] textArray;
    List[] listArray;
    Component parent;
    Object[] outputObj;
    Object[] defaultValue;
    boolean[] isSecParamMapped;
    String[] dateFormat;
    CButton[] dateButArray;
    Object[] prevParamVal;
    ReportInfo reportInfo;
    int[] seq;
    CPanel paramPanel;
    GridBagLayout gbl;
    GridBagConstraints gbc;
    int[] mapping;
    int[] reorderedMapping;

    public EnterParamDialog(ReportInfo reportInfo, Frame frame, String[] columnName, Object[][] choice, boolean[] isMultiValue, boolean[] useComboBox, int[] sqlType, Object[] defaultValue, boolean[] isSecParamMapped, String[] dateFormat, Object[] prevParamVal, int[] seq, int[] mapping, int[] reorderedMapping, boolean[] isAllOptionEnabled, String[] allOptionLabel) {
        super((Object)frame, "Enter Dialog", true);
        this.reportInfo = reportInfo;
        this.columnName = columnName;
        this.choice = choice;
        this.isMultiValue = isMultiValue;
        this.useComboBox = useComboBox;
        this.sqlType = sqlType;
        this.defaultValue = defaultValue;
        this.isSecParamMapped = isSecParamMapped;
        this.dateFormat = dateFormat;
        this.prevParamVal = prevParamVal;
        this.seq = seq;
        this.mapping = mapping;
        this.reorderedMapping = reorderedMapping;
        this.isAllOptionEnabled = isAllOptionEnabled;
        this.allOptionLabel = allOptionLabel;
        this.init();
    }

    private void init() {
        this.setBackground(Color.lightGray);
        if (this.columnName.length > 1) {
            this.setBorder("Please enter values");
        } else {
            this.setBorder("Please enter value");
        }
        this.add("Center", this.getPanel());
        Dimension screensize = this.getToolkit().getScreenSize();
        this.pack();
        int width = this.getSize().width;
        int height = this.getSize().height;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                EnterParamDialog.this.setVisible(false);
                EnterParamDialog.this.dispose();
            }
        });
        this.setDefaultCloseOperation(DO_NOTHING_ONCLOSE);
        this.setBounds((screensize.width - width) / 2, (screensize.height - height) / 2, width + 50, height + 50);
    }

    private CPanel getPanel() {
        this.gbl = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.paramPanel = new CPanel(this.gbl);
        this.gbc.anchor = 17;
        this.choiceArray = new CChoice[this.columnName.length];
        this.textArray = new CTextField[this.columnName.length];
        this.dateButArray = new CButton[this.columnName.length];
        this.listArray = new List[this.columnName.length];
        this.allButton = new JButton[this.columnName.length];
        this.noneButton = new JButton[this.columnName.length];
        for (int j = 0; j < this.columnName.length; ++j) {
            if (this.reorderedMapping != null && j < this.reorderedMapping.length && this.reorderedMapping[j] > -1 || this.useComboBox[j] || !DataType.isDateTime(DataType.mapType(this.sqlType[j]))) continue;
            this.dateButArray[j] = new CButton("Calendar");
        }
        int gridy = 0;
        for (int i = 0; i < this.columnName.length; ++i) {
            Component comp;
            CLabel labelComp = new CLabel(this.columnName[i]);
            if (this.useComboBox[i]) {
                Component[] array = this.choiceArray;
                if (this.isMultiValue[i]) {
                    array = this.listArray;
                    OurPanel selectionPanel = this.makeSelectionPanel(i);
                    this.gbc.gridx = 2;
                    this.gbc.gridy = gridy++;
                    this.gbc.fill = 2;
                    this.gbc.anchor = 22;
                    this.gbc.insets = i > 0 ? new Insets(12, 0, 0, 0) : new Insets(0, 0, 0, 0);
                    this.gbc.weightx = 0.5;
                    this.gbc.weighty = 0.0;
                    this.gbc.gridwidth = 1;
                    this.gbl.setConstraints(selectionPanel, this.gbc);
                    this.paramPanel.add(selectionPanel);
                }
                comp = this.createComponent(this.isMultiValue[i], this.choice[i], array, i);
            } else if (this.dateButArray[i] != null) {
                CPanel panel = new CPanel(new BorderLayout());
                this.textArray[i] = new CTextField("To be filled in", 20);
                this.textArray[i].addActionListener(this);
                panel.add("Center", this.textArray[i]);
                OurPanel panel2 = new OurPanel(new GridLayout(1, 2, 0, 0));
                panel2.add(this.dateButArray[i]);
                this.dateButArray[i].addActionListener(this);
                panel.add("East", panel2);
                comp = panel;
            } else {
                this.textArray[i] = new CTextField("To be filled in", 20);
                this.textArray[i].addActionListener(this);
                comp = this.textArray[i];
            }
            this.gbc.gridy = gridy++;
            this.gbc.gridx = 0;
            this.gbc.fill = 0;
            this.gbc.insets = new Insets(1, 1, 1, 1);
            this.gbc.weightx = 0.0;
            this.gbc.weighty = 0.0;
            this.gbc.gridwidth = 1;
            this.gbl.setConstraints(labelComp, this.gbc);
            if (!(this.reorderedMapping != null && i < this.reorderedMapping.length && this.reorderedMapping[i] > -1 || this.isSecParamMapped[i])) {
                this.paramPanel.add(labelComp);
            }
            this.gbc.gridx = 1;
            this.gbc.fill = 2;
            this.gbc.insets = new Insets(1, 1, 1, 1);
            this.gbc.weightx = 0.0;
            this.gbc.weighty = 0.0;
            this.gbc.gridwidth = 2;
            this.gbl.setConstraints(comp, this.gbc);
            if (this.reorderedMapping != null && i < this.reorderedMapping.length && this.reorderedMapping[i] > -1 || this.isSecParamMapped[i]) continue;
            this.paramPanel.add(comp);
        }
        CPanel mainPanel = new CPanel();
        this.resetPanel();
        mainPanel.add("Center", this.paramPanel);
        CPanel buttonPanel = new CPanel(new FlowLayout(2));
        this.resetButton = new CButton("Reset");
        buttonPanel.add(this.resetButton);
        this.okButton = new CButton("OK");
        buttonPanel.add(this.okButton);
        this.okButton.addActionListener(this);
        this.resetButton.addActionListener(this);
        mainPanel.add("South", buttonPanel);
        return mainPanel;
    }

    Object[] getValues() {
        return this.outputObj;
    }

    private void resetPanel() {
        for (int i = 0; i < this.columnName.length; ++i) {
            Object defaultStr;
            int orderIndex = this.getOrderIndex(i);
            if (this.useComboBox[i]) {
                int j;
                if (this.isMultiValue[i]) {
                    defaultStr = new Vector();
                    if (this.prevParamVal != null && i < this.prevParamVal.length && !this.prevParamVal[i].equals("UnMapped")) {
                        ((Vector)defaultStr).add(DataType.toString(this.prevParamVal[i], this.dateFormat[i]));
                    } else {
                        for (Object o : (Vector)this.defaultValue[i]) {
                            ((Vector)defaultStr).add(DataType.toString(o, this.dateFormat[i]));
                        }
                    }
                    for (j = 0; j < this.listArray[i].getItemCount(); ++j) {
                        Iterator iterator = ((Vector)defaultStr).iterator();
                        while (iterator.hasNext()) {
                            Object def = iterator.next();
                            if (def.equals(this.listArray[i].getItem(j))) {
                                this.listArray[i].select(j);
                                this.listArray[i].makeVisible(j);
                                continue;
                            }
                            this.listArray[i].deselect(j);
                        }
                    }
                    if (orderIndex == this.getFirstIndex()) {
                        this.listArray[i].setEnabled(true);
                    } else {
                        this.listArray[i].setEnabled(false);
                    }
                } else {
                    defaultStr = "";
                    defaultStr = this.prevParamVal != null && i < this.prevParamVal.length && !this.prevParamVal[i].equals("UnMapped") ? DataType.toString(this.prevParamVal[i], this.dateFormat[i]) : DataType.toString(this.defaultValue[i], this.dateFormat[i]);
                    for (j = 0; j < this.choiceArray[i].getItemCount(); ++j) {
                        if (!((String)defaultStr).equals(this.choiceArray[i].getItem(j))) continue;
                        this.choiceArray[i].select(j);
                    }
                    if (orderIndex == this.getFirstIndex()) {
                        this.choiceArray[i].setEnabled(true);
                    } else {
                        this.choiceArray[i].setEnabled(false);
                    }
                }
            } else {
                if (this.defaultValue[i] == null || this.defaultValue[i].toString().equals("[null]")) {
                    this.textArray[i].setText("To be filled in");
                } else {
                    defaultStr = DataType.toString(this.defaultValue[i], this.dateFormat[i]);
                    this.textArray[i].setText((String)defaultStr);
                }
                if (orderIndex == this.getFirstIndex()) {
                    this.textArray[i].setEnabled(true);
                } else {
                    this.textArray[i].setEnabled(false);
                }
            }
            if (this.textArray[i] != null && this.textArray[i].getText().equals("To be filled in")) {
                this.textArray[i].selectAll();
            }
            if (i != 0) continue;
            if (this.textArray[i] != null) {
                this.textArray[i].requestFocusInWindow();
                continue;
            }
            if (this.choiceArray[i] != null) {
                this.choiceArray[i].requestFocusInWindow();
                continue;
            }
            if (this.listArray[i] == null) continue;
            this.listArray[i].requestFocusInWindow();
        }
    }

    private int getParamIndex(int order) {
        if (this.seq == null) {
            return 0;
        }
        int ct = 0;
        for (int i = 0; i < order; ++i) {
            ct += this.seq[i];
        }
        return ct;
    }

    private int getOrderIndex(int index) {
        if (this.seq == null) {
            return 0;
        }
        int ct = 0;
        for (int i = 0; i < this.seq.length; ++i) {
            if (index < ct + this.seq[i]) {
                return i;
            }
            ct += this.seq[i];
        }
        return 0;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.valueChanged(e.getSource());
    }

    public void valueChanged(Object source) {
        try {
            for (int i = 0; i < this.listArray.length; ++i) {
                if (this.listArray[i] == null || source != this.listArray[i] || i < this.getFirstIndex()) continue;
                int order = this.getOrderIndex(i);
                if (this.seq == null || order == this.seq.length - 1) {
                    return;
                }
                int index = this.getParamIndex(order + 1);
                Object[] values = this.getSelectedValues(index);
                Vector nextLevelParams = this.reportInfo.getNextParamOrderValues(order + 1, values, this.mapping);
                Object[][] paramChoice = (Object[][])nextLevelParams.get(0);
                Object[][] defaultVals = (Object[][])nextLevelParams.get(1);
                for (int j = 0; j < paramChoice.length; ++j) {
                    if (this.useComboBox[index + j]) {
                        EventListener[] il;
                        if (this.isMultiValue[index + j]) {
                            for (EventListener element : il = this.listArray[index + j].getItemListeners()) {
                                this.listArray[index + j].removeItemListener((ItemListener)element);
                            }
                            this.listArray[index + j].removeAll();
                            if (paramChoice[j] != null) {
                                for (int k = 0; k < paramChoice[j].length; ++k) {
                                    if (this.sqlType[index + j] == 91 || this.sqlType[index + j] == 92 || this.sqlType[index + j] == 93) {
                                        this.listArray[index + j].add(QbDateFormat.getFormattedDateTime((Date)paramChoice[j][k], this.dateFormat[index + j]));
                                        continue;
                                    }
                                    this.listArray[index + j].add(paramChoice[j][k].toString());
                                }
                            }
                            for (EventListener element : il) {
                                this.listArray[index + j].addItemListener((ItemListener)element);
                            }
                            this.listArray[index + j].setEnabled(true);
                        } else {
                            for (EventListener element : il = this.choiceArray[index + j].getActionListeners()) {
                                this.choiceArray[index + j].removeActionListener((ActionListener)element);
                            }
                            this.choiceArray[index + j].removeAllItems();
                            if (paramChoice[j] != null) {
                                for (int k = 0; k < paramChoice[j].length; ++k) {
                                    this.choiceArray[index + j].add(paramChoice[j][k].toString());
                                    for (int l = 0; l < defaultVals[j].length; ++l) {
                                        if (!paramChoice[j][k].equals(defaultVals[j][l])) continue;
                                        this.choiceArray[index + j].setSelectedIndex(k);
                                    }
                                }
                            }
                            for (EventListener element : il) {
                                this.choiceArray[index + j].addActionListener((ActionListener)element);
                            }
                            this.choiceArray[index + j].setEnabled(true);
                        }
                        this.choice[index + j] = paramChoice[j];
                        continue;
                    }
                    this.textArray[index + j].setEnabled(true);
                    if (this.textArray[index + j].getText().equals("To be filled in")) {
                        this.textArray[index + j].selectAll();
                    }
                    this.textArray[index + j].requestFocusInWindow();
                }
            }
            this.paramPanel.validate();
            this.paramPanel.repaint();
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Failed to perform action", ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int i;
        Object source = e.getSource();
        if (source == this.okButton) {
            if (this.areAllValid()) {
                this.setVisible(false);
                this.dispose();
            } else {
                this.showError();
            }
        } else if (source == this.resetButton) {
            this.resetPanel();
        }
        for (i = 0; i < this.allButton.length; ++i) {
            int j;
            int cnt;
            if (source == this.allButton[i]) {
                cnt = this.listArray[i].getItemCount();
                for (j = 0; j < cnt; ++j) {
                    this.listArray[i].select(j);
                }
                this.valueChanged(this.listArray[i]);
                continue;
            }
            if (source != this.noneButton[i]) continue;
            cnt = this.listArray[i].getItemCount();
            for (j = 1; j < cnt; ++j) {
                this.listArray[i].deselect(j);
            }
            this.valueChanged(this.listArray[i]);
        }
        try {
            int l;
            int k;
            int j;
            Object[][] defaultVals;
            Object[][] paramChoice;
            Vector nextLevelParams;
            Object[] values;
            int index;
            int order;
            for (i = 0; i < this.textArray.length; ++i) {
                if (this.textArray[i] == null || source != this.textArray[i] || i < this.getFirstIndex()) continue;
                order = this.getOrderIndex(i);
                if (this.seq == null || order == this.seq.length - 1) {
                    return;
                }
                index = this.getParamIndex(order + 1);
                values = this.getSelectedValues(index);
                nextLevelParams = this.reportInfo.getNextParamOrderValues(order + 1, values, this.mapping);
                paramChoice = (Object[][])nextLevelParams.get(0);
                defaultVals = (Object[][])nextLevelParams.get(1);
                for (j = 0; j < paramChoice.length; ++j) {
                    if (this.useComboBox[index + j]) {
                        if (this.isMultiValue[index + j]) {
                            this.listArray[index + j].removeAll();
                            if (paramChoice[j] != null) {
                                for (k = 0; k < paramChoice[j].length; ++k) {
                                    this.listArray[index + j].add(paramChoice[j][k].toString());
                                    for (l = 0; l < defaultVals[j].length; ++l) {
                                        if (!paramChoice[j][k].equals(defaultVals[j][l])) continue;
                                        this.listArray[index + j].select(k);
                                    }
                                }
                            }
                            this.listArray[index + j].setEnabled(true);
                        } else {
                            this.choiceArray[index + j].removeAll();
                            if (paramChoice[j] != null) {
                                for (k = 0; k < paramChoice[j].length; ++k) {
                                    this.choiceArray[index + j].add(paramChoice[j][k].toString());
                                    for (l = 0; l < defaultVals[j].length; ++l) {
                                        if (!paramChoice[j][k].equals(defaultVals[j][l])) continue;
                                        this.choiceArray[index + j].setSelectedIndex(k);
                                    }
                                }
                            }
                            this.choiceArray[index + j].setEnabled(true);
                        }
                        this.choice[index + j] = paramChoice[j];
                        continue;
                    }
                    this.textArray[index + j].setEnabled(true);
                    if (this.textArray[index + j].getText().equals("To be filled in")) {
                        this.textArray[index + i].selectAll();
                    }
                    this.textArray[index + i].requestFocusInWindow();
                }
            }
            for (i = 0; i < this.choiceArray.length; ++i) {
                if (this.choiceArray[i] == null || source != this.choiceArray[i] || i < this.getFirstIndex()) continue;
                order = this.getOrderIndex(i);
                if (this.seq == null || order == this.seq.length - 1) {
                    return;
                }
                index = this.getParamIndex(order + 1);
                values = this.getSelectedValues(index);
                nextLevelParams = this.reportInfo.getNextParamOrderValues(order + 1, values, this.mapping);
                paramChoice = (Object[][])nextLevelParams.get(0);
                defaultVals = (Object[][])nextLevelParams.get(1);
                for (j = 0; j < paramChoice.length; ++j) {
                    if (this.useComboBox[index + j]) {
                        if (this.isMultiValue[index + j]) {
                            this.listArray[index + j].removeAll();
                            if (paramChoice[j] != null) {
                                for (k = 0; k < paramChoice[j].length; ++k) {
                                    this.listArray[index + j].add(paramChoice[j][k].toString());
                                    for (l = 0; l < defaultVals[j].length; ++l) {
                                        if (!paramChoice[j][k].equals(defaultVals[j][l])) continue;
                                        this.listArray[index + j].select(k);
                                    }
                                }
                            }
                            this.listArray[index + j].setEnabled(true);
                            this.listArray[index + j].addItemListener(this);
                        } else {
                            this.choiceArray[index + j].removeAllItems();
                            if (paramChoice[j] != null) {
                                for (k = 0; k < paramChoice[j].length; ++k) {
                                    this.choiceArray[index + j].add(paramChoice[j][k].toString());
                                    for (l = 0; l < defaultVals[j].length; ++l) {
                                        if (!paramChoice[j][k].equals(defaultVals[j][l])) continue;
                                        this.choiceArray[index + j].setSelectedIndex(k);
                                    }
                                }
                            }
                            this.choiceArray[index + j].setEnabled(true);
                        }
                        this.choice[index + j] = paramChoice[j];
                        continue;
                    }
                    this.textArray[index + j].setEnabled(true);
                    if (this.textArray[index + j].getText().equals("To be filled in")) {
                        this.textArray[index + j].selectAll();
                    }
                    this.textArray[index + j].requestFocusInWindow();
                }
            }
            this.paramPanel.validate();
            this.paramPanel.repaint();
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Failed to perform action", ex);
        }
        for (int i2 = 0; i2 < this.dateButArray.length; ++i2) {
            if (this.dateButArray[i2] == null || source != this.dateButArray[i2]) continue;
            CCalendarDialog calendarDialog = new CCalendarDialog((Dialog)this, this.sqlType[i2]);
            Date curTime = null;
            try {
                curTime = (Date)DataType.createObject(this.textArray[i2].getText(), DataType.mapType(this.sqlType[i2]), this.dateFormat[i2]);
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Failed to get current time", ex);
            }
            if (curTime != null) {
                calendarDialog.setTime(curTime);
            }
            calendarDialog.setVisible(true);
            if (calendarDialog.isCancelled()) {
                return;
            }
            this.textArray[i2].setText(DataType.toString(calendarDialog.getTime(), this.dateFormat[i2]));
            this.textArray[i2].selectAll();
            this.textArray[i2].requestFocusInWindow();
            this.actionPerformed(new ActionEvent(this.textArray[i2], 1001, null));
            return;
        }
    }

    private int getFirstIndex() {
        if (this.reorderedMapping == null || this.reorderedMapping.length == 0) {
            return 0;
        }
        for (int i = 0; i < this.reorderedMapping.length; ++i) {
            if (this.reorderedMapping[i] > -1) continue;
            return i;
        }
        return 0;
    }

    private Object[] getSelectedValues(int index) {
        Object[] values = new Object[index];
        try {
            for (int i = 0; i < index; ++i) {
                Vector<Object> vec;
                if (this.isSecParamMapped[i]) {
                    values[i] = "USE_SECURITY_OPTION";
                    continue;
                }
                if (this.useComboBox[i]) {
                    if (this.isMultiValue[i]) {
                        int[] idx = this.listArray[i].getSelectedIndexes();
                        vec = new Vector<Object>();
                        for (int element : idx) {
                            vec.addElement(this.choice[i][element]);
                        }
                        values[i] = vec.size() == 0 ? null : vec;
                        continue;
                    }
                    values[i] = this.choice[i][this.choiceArray[i].getSelectedIndex()];
                    continue;
                }
                if (this.isMultiValue[i]) {
                    String[] tmpStr = this.readMultiValues(this.textArray[i].getText());
                    vec = new Vector();
                    for (String element : tmpStr) {
                        vec.addElement(DataType.createObject(element, DataType.mapType(this.sqlType[i]), this.dateFormat[i]));
                    }
                    values[i] = vec.size() == 0 ? null : vec;
                    continue;
                }
                values[i] = DataType.createObject(this.textArray[i].getText(), DataType.mapType(this.sqlType[i]), this.dateFormat[i]);
            }
            return values;
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Cannot get selected values", ex);
            return null;
        }
    }

    private boolean areAllValid() {
        this.outputObj = new Object[this.columnName.length];
        try {
            for (int i = 0; i < this.columnName.length; ++i) {
                Vector<Object> vec;
                if (this.isSecParamMapped[i]) {
                    this.outputObj[i] = "USE_SECURITY_OPTION";
                    continue;
                }
                if (this.useComboBox[i]) {
                    if (this.isMultiValue[i]) {
                        int[] idx = this.listArray[i].getSelectedIndexes();
                        if (idx == null || idx.length == 0) {
                            return false;
                        }
                        vec = new Vector();
                        for (int element : idx) {
                            vec.addElement(this.choice[i][element]);
                        }
                        this.outputObj[i] = vec.size() == 0 ? null : vec;
                        continue;
                    }
                    this.outputObj[i] = this.choice[i][this.choiceArray[i].getSelectedIndex()];
                    continue;
                }
                if (this.isMultiValue[i]) {
                    String[] tmpStr = this.readMultiValues(this.textArray[i].getText());
                    vec = new Vector<Object>();
                    for (String element : tmpStr) {
                        vec.addElement(DataType.createObject(element, DataType.mapType(this.sqlType[i]), this.dateFormat[i]));
                    }
                    this.outputObj[i] = vec.size() == 0 ? null : vec;
                    continue;
                }
                this.outputObj[i] = this.isAllOptionEnabled[i] && this.textArray[i].getText().equals(this.allOptionLabel[i]) ? this.textArray[i].getText() : DataType.createObject(this.textArray[i].getText(), DataType.mapType(this.sqlType[i]), this.dateFormat[i]);
            }
            return true;
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Failed to check validity", ex);
            return false;
        }
    }

    private Component createComponent(boolean isMultiValue, Object[] values, Object[] array, int index) {
        if (isMultiValue) {
            List list = new List(5, true);
            if (values != null) {
                for (Object value : values) {
                    if (value == null) continue;
                    list.add(value.toString());
                }
            }
            array[index] = list;
            list.addItemListener(this);
            return list;
        }
        CChoice choice = new CChoice();
        if (values != null) {
            for (Object value : values) {
                if (value == null) continue;
                choice.add(value.toString());
            }
        }
        array[index] = choice;
        choice.addActionListener(this);
        return choice;
    }

    private String[] readMultiValues(String valueString) {
        if (valueString == null) {
            return null;
        }
        try {
            Vector<String> vect = new Vector<String>();
            StreamTokenizer st = new StreamTokenizer(new StringReader(valueString));
            int ttype = st.nextToken();
            while (ttype != -1) {
                if (ttype == -2) {
                    vect.addElement(st.nval + "");
                } else if (st.sval != null) {
                    vect.addElement(st.sval);
                }
                ttype = st.nextToken();
            }
            if (vect.size() == 0) {
                return null;
            }
            String[] ret = new String[vect.size()];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (String)vect.elementAt(i);
            }
            return ret;
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Cannot read multi values", ex);
            return null;
        }
    }

    private void showError() {
        String paramString = "";
        for (int i = 0; i < this.columnName.length; ++i) {
            if (this.outputObj[i] != null) continue;
            paramString = paramString + "Type of " + this.columnName[i] + " should be " + DataType.getTypeName(this.sqlType[i]) + " \n   ";
        }
        String message = "Parameter value doesn't match its data type: \n \n   " + paramString;
        CMessageDialog.showError(this, message);
    }

    private OurPanel makeSelectionPanel(int paramIndex) {
        OurPanel selectionPanel = new OurPanel(new FlowLayout(2));
        Applet applet = ServerMessage.getApplet();
        String allStr = ServerMessage.imagesPath + "selectAll.png";
        String noneStr = ServerMessage.imagesPath + "unselectAll.png";
        this.allButton[paramIndex] = new JButton(IOUtil.getImageIcon(allStr));
        selectionPanel.add(this.allButton[paramIndex]);
        this.noneButton[paramIndex] = new JButton(IOUtil.getImageIcon(noneStr));
        selectionPanel.add(this.noneButton[paramIndex]);
        this.allButton[paramIndex].setBorder(BorderFactory.createEmptyBorder());
        this.allButton[paramIndex].setContentAreaFilled(false);
        this.allButton[paramIndex].addActionListener(this);
        this.noneButton[paramIndex].setBorder(BorderFactory.createEmptyBorder());
        this.noneButton[paramIndex].setContentAreaFilled(false);
        this.noneButton[paramIndex].addActionListener(this);
        selectionPanel.add(this.allButton[paramIndex]);
        selectionPanel.add(this.noneButton[paramIndex]);
        return selectionPanel;
    }
}

