/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.PageViewer.swing;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.reportdesigner.PageViewer.swing.CButton;
import quadbase.reportdesigner.PageViewer.swing.CDialog;
import quadbase.reportdesigner.PageViewer.swing.CLabel;
import quadbase.reportdesigner.PageViewer.swing.CMessageDialog;
import quadbase.reportdesigner.PageViewer.swing.CPanel;
import quadbase.reportdesigner.PageViewer.swing.CTextField;
import quadbase.reportdesigner.PageViewer.swing.ReportCanvas;

public class GoToDialog
extends CDialog
implements ActionListener {
    private static final Logger LOGGER = Logger.getLogger(GoToDialog.class.getName());
    CTextField pageField;
    CTextField sectionField;
    CButton okButton;
    CButton cancelButton;
    ReportCanvas canvas;

    public GoToDialog(Object frame, ReportCanvas canvas) {
        super(frame, "Go To ...", true);
        this.canvas = canvas;
        this.init();
        this.setPosition();
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void init() {
        this.setBackground(Color.lightGray);
        CPanel p1 = new CPanel();
        p1.setLayout(new FlowLayout(0));
        p1.add(new CLabel(" Page "));
        this.pageField = new CTextField(this.canvas.getPage() + "", 3);
        p1.add(this.pageField);
        this.sectionField = new CTextField(this.canvas.getSection() + "", 3);
        if (this.canvas.getTotalSections() > 1) {
            p1.add(new CLabel(" Section "));
            p1.add(this.sectionField);
        }
        this.okButton = new CButton("OK");
        this.okButton.addActionListener(this);
        this.cancelButton = new CButton("Cancel");
        this.cancelButton.addActionListener(this);
        CPanel p2 = new CPanel();
        p2.setLayout(new FlowLayout(2));
        p2.add(this.okButton);
        p2.add(this.cancelButton);
        this.add("Center", p1);
        this.add("South", p2);
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            int page = this.canvas.getPage();
            int section = this.canvas.getSection();
            String msg = null;
            try {
                page = Integer.parseInt(this.pageField.getText());
                if (page <= 0) {
                    page = 1;
                }
                if (this.canvas.isTotalPagesReady() && page > this.canvas.getTotalPages()) {
                    page = this.canvas.getTotalPages();
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINE, "Page Field : Invalid Input", ex);
                msg = "Page Field : Invalid Input!";
            }
            try {
                section = Integer.parseInt(this.sectionField.getText());
                if (section <= 0) {
                    section = 1;
                }
                if (section > this.canvas.getTotalSections()) {
                    section = this.canvas.getTotalSections();
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINE, "Section Field : Invalid Input", ex);
                msg = "Section Field : Invalid Input!";
            }
            if (msg == null && !this.canvas.reportInfo.isSelectedPageReady(page, section)) {
                msg = "The page that you requested is currently unavailable.  Please wait a few second and try again.";
            }
            if (msg != null) {
                CMessageDialog.showWarning(this, msg);
                return;
            }
            this.canvas.setPage(page);
            this.canvas.setSection(section);
            this.canvas.repaint();
        }
        this.setVisible(false);
        this.dispose();
    }
}

