/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.PageViewer.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPopupMenu;
import quadbase.common.client.ServerMessage;
import quadbase.reportdesigner.PageViewer.swing.CMenu;
import quadbase.reportdesigner.PageViewer.swing.CMenuItem;
import quadbase.reportdesigner.PageViewer.swing.GoToDialog;
import quadbase.reportdesigner.PageViewer.swing.ReportCanvas;
import quadbase.reportdesigner.PageViewer.swing.ZoomDialog;

class PopupMenuForReport
extends JPopupMenu
implements ActionListener {
    ReportCanvas reportCanvas;
    CMenu pageMenu;
    CMenu sectionMenu;
    CMenu sortMenu;
    CMenu sortMenu2;
    CMenu outputMenu;
    CMenu serverMenu;
    CMenu clientMenu;
    private boolean isReady = false;
    private boolean isNextPageEnabled = false;
    private boolean isTotalPagesReady = false;

    public PopupMenuForReport(ReportCanvas reportCanvas) {
        this.reportCanvas = reportCanvas;
        this.addMenu();
    }

    private void addMenu() {
        this.isTotalPagesReady = this.reportCanvas.isTotalPagesReady();
        this.isNextPageEnabled = !this.isTotalPagesReady ? true : this.reportCanvas.isNextPageEnabled();
        this.isReady = false;
        if (this.reportCanvas.sectionMenuVisible) {
            this.addSectionMenu();
        }
        if (this.reportCanvas.pageMenuVisible) {
            this.addPageMenu();
        }
        if (ServerMessage.useServer && this.reportCanvas.isExportEnabled() && this.reportCanvas.outputMenuVisible) {
            this.addOutputMenu();
        }
        if (ServerMessage.useServer && this.reportCanvas.isRefreshEnabled() && this.reportCanvas.refreshMenuItemVisible) {
            this.addRefreshMenuItem();
        }
        if (this.reportCanvas.backMenuItemVisible) {
            this.addBackMenuItem();
        }
        if (this.reportCanvas.goToMenuItemVisible) {
            this.addGoToMenuItem();
        }
        if (this.reportCanvas.zoomMenuItemVisible) {
            this.addZoomMenuItem();
        }
        if (ServerMessage.useServer && this.reportCanvas.reportInfo.sortingEnabled() && this.reportCanvas.sortMenuVisible) {
            this.addSortMenu();
        }
        if (ServerMessage.useServer && this.reportCanvas.reportInfo.showMultiDrillDownSelectionOption() && this.reportCanvas.multiDrillDownVisible) {
            this.addMultiDrillDownMenuItem();
        }
        if (ServerMessage.getApplet() == null) {
            this.addSeparator();
            this.add(this.newMenuItem("Print"));
        }
        if (this.reportCanvas.getToolbarContainer() != null) {
            this.addSeparator();
            String rptToolBar = " Report Toolbar";
            rptToolBar = this.reportCanvas.isReportToolBarVisible() ? "Hide" + rptToolBar : "Show" + rptToolBar;
            if (this.reportCanvas.toolbarMenuVisible) {
                this.add(this.newMenuItem(rptToolBar));
            }
        }
        this.isReady = true;
    }

    private void addPageMenu() {
        if (!this.reportCanvas.isPrevPageEnabled() && !this.isNextPageEnabled) {
            return;
        }
        this.pageMenu = new CMenu("Page");
        CMenuItem f1 = this.newMenuItem("First Page");
        f1.setEnabled(this.reportCanvas.isPrevPageEnabled());
        if (this.reportCanvas.invisiblePageMenuItem == null || !this.reportCanvas.invisiblePageMenuItem.contains("First Page")) {
            this.add(this.pageMenu, f1);
        }
        CMenuItem c1 = this.newMenuItem("Previous Page");
        c1.setEnabled(this.reportCanvas.isPrevPageEnabled());
        if (this.reportCanvas.invisiblePageMenuItem == null || !this.reportCanvas.invisiblePageMenuItem.contains("Previous Page")) {
            this.add(this.pageMenu, c1);
        }
        CMenuItem c2 = this.newMenuItem("Next Page");
        c2.setEnabled(this.reportCanvas.isFirstFileAvail() && this.isNextPageEnabled);
        if (this.reportCanvas.invisiblePageMenuItem == null || !this.reportCanvas.invisiblePageMenuItem.contains("Next Page")) {
            this.add(this.pageMenu, c2);
        }
        CMenuItem f2 = this.newMenuItem("Last Page");
        f2.setEnabled(this.isTotalPagesReady && this.isNextPageEnabled);
        if (this.reportCanvas.invisiblePageMenuItem == null || !this.reportCanvas.invisiblePageMenuItem.contains("Last Page")) {
            this.add(this.pageMenu, f2);
        }
        this.add(this.pageMenu);
    }

    private void addSectionMenu() {
        if (!this.reportCanvas.isPrevSectionEnabled() && !this.reportCanvas.isNextSectionEnabled()) {
            return;
        }
        this.sectionMenu = new CMenu("Section");
        CMenuItem f1 = this.newMenuItem("First Section");
        f1.setEnabled(this.reportCanvas.isPrevSectionEnabled());
        if (this.reportCanvas.invisibleSectionMenuItem == null || !this.reportCanvas.invisibleSectionMenuItem.contains("First Section")) {
            this.add(this.sectionMenu, f1);
        }
        CMenuItem c1 = this.newMenuItem("Previous Section");
        c1.setEnabled(this.reportCanvas.isPrevSectionEnabled());
        if (this.reportCanvas.invisibleSectionMenuItem == null || !this.reportCanvas.invisibleSectionMenuItem.contains("Previous Section")) {
            this.add(this.sectionMenu, c1);
        }
        CMenuItem c2 = this.newMenuItem("Next Section");
        c2.setEnabled(this.reportCanvas.isNextSectionEnabled());
        if (this.reportCanvas.invisibleSectionMenuItem == null || !this.reportCanvas.invisibleSectionMenuItem.contains("Next Section")) {
            this.add(this.sectionMenu, c2);
        }
        CMenuItem f2 = this.newMenuItem("Last Section");
        f2.setEnabled(this.reportCanvas.isNextSectionEnabled());
        if (this.reportCanvas.invisibleSectionMenuItem == null || !this.reportCanvas.invisibleSectionMenuItem.contains("Last Section")) {
            this.add(this.sectionMenu, f2);
        }
        this.add(this.sectionMenu);
    }

    private void addSortMenu() {
        this.sortMenu = new CMenu("Sort by (ascend)");
        this.sortMenu2 = new CMenu("Sort by (descend)");
        for (int i = 0; i < 2; ++i) {
            String[] colList;
            String actionCmd;
            CMenu menu;
            if (i == 0) {
                menu = this.sortMenu;
                actionCmd = "asc";
            } else {
                menu = this.sortMenu2;
                actionCmd = "des";
            }
            menu.removeAll();
            for (String element : colList = this.reportCanvas.reportInfo.columnList) {
                this.add(menu, this.newMenuItem(element + " Column", actionCmd + " " + element + " Column"));
            }
        }
        this.sortMenu.addActionListener(this);
        this.sortMenu2.addActionListener(this);
        this.add(this.sortMenu);
        this.add(this.sortMenu2);
    }

    private void addOutputMenu() {
        this.outputMenu = new CMenu("Output");
        this.add(this.outputMenu);
        this.serverMenu = new CMenu("Server");
        this.addOutputMenu(this.serverMenu, " [Server]");
        this.outputMenu.add(this.serverMenu);
        if (ServerMessage.getApplet() != null && this.reportCanvas.getExportServlet() != null && this.reportCanvas.reportInfo.isDynamicExport) {
            this.clientMenu = new CMenu("Client");
            this.addOutputMenu(this.clientMenu, " [Client]");
            this.outputMenu.add(this.clientMenu);
        }
    }

    private void addOutputMenu(CMenu outputMenu, String appendCommand) {
        if (this.reportCanvas.invisibleOutputMenuItem == null || !this.reportCanvas.invisibleOutputMenuItem.contains("Generate DHTML (Single Page)")) {
            this.add(outputMenu, this.newMenuItem("Generate DHTML (Single Page)", "Generate DHTML (Single Page)" + appendCommand));
        }
        if (this.reportCanvas.invisibleOutputMenuItem == null || !this.reportCanvas.invisibleOutputMenuItem.contains("Generate DHTML (Multiple Pages)")) {
            this.add(outputMenu, this.newMenuItem("Generate DHTML (Multiple Pages)", "Generate DHTML (Multiple Pages)" + appendCommand));
        }
        if (this.reportCanvas.invisibleOutputMenuItem == null || !this.reportCanvas.invisibleOutputMenuItem.contains("Generate DHTML (Paginated Single Page)" + appendCommand)) {
            this.add(outputMenu, this.newMenuItem("Generate DHTML (Paginated Single Page)", "Generate DHTML (Paginated Single Page)" + appendCommand));
        }
        if (this.reportCanvas.invisibleOutputMenuItem == null || !this.reportCanvas.invisibleOutputMenuItem.contains("Generate PDF")) {
            this.add(outputMenu, this.newMenuItem("Generate PDF", "Generate PDF" + appendCommand));
        }
        if (this.reportCanvas.invisibleOutputMenuItem == null || !this.reportCanvas.invisibleOutputMenuItem.contains("Generate CSV")) {
            this.add(outputMenu, this.newMenuItem("Generate CSV", "Generate CSV" + appendCommand));
        }
        if (this.reportCanvas.invisibleOutputMenuItem == null || !this.reportCanvas.invisibleOutputMenuItem.contains("Generate RTF")) {
            this.add(outputMenu, this.newMenuItem("Generate RTF", "Generate RTF" + appendCommand));
        }
        if (this.reportCanvas.invisibleOutputMenuItem == null || !this.reportCanvas.invisibleOutputMenuItem.contains("Generate Excel (XLS)")) {
            this.add(outputMenu, this.newMenuItem("Generate Excel (XLS)", "Generate Excel (XLS)" + appendCommand));
        }
        if (this.reportCanvas.invisibleOutputMenuItem == null || !this.reportCanvas.invisibleOutputMenuItem.contains("Generate Excel 2007 (XLSX)")) {
            this.add(outputMenu, this.newMenuItem("Generate Excel 2007 (XLSX)", "Generate Excel 2007 (XLSX)" + appendCommand));
        }
        if (this.reportCanvas.invisibleOutputMenuItem == null || !this.reportCanvas.invisibleOutputMenuItem.contains("Generate TXT")) {
            this.add(outputMenu, this.newMenuItem("Generate TXT", "Generate TXT" + appendCommand));
        }
        if (this.reportCanvas.invisibleOutputMenuItem == null || !this.reportCanvas.invisibleOutputMenuItem.contains("Generate XML (Data + Format)")) {
            this.add(outputMenu, this.newMenuItem("Generate XML (Data + Format)", "Generate XML (Data + Format)" + appendCommand));
        }
        if (this.reportCanvas.invisibleOutputMenuItem == null || !this.reportCanvas.invisibleOutputMenuItem.contains("Generate XML (Pure Data)")) {
            this.add(outputMenu, this.newMenuItem("Generate XML (Pure Data)", "Generate XML (Pure Data)" + appendCommand));
        }
    }

    private void addBackMenuItem() {
        if (this.reportCanvas.countLinkHistory() > 0) {
            this.addSeparator();
            this.add(this.newMenuItem("Back"));
        }
    }

    private void addMultiDrillDownMenuItem() {
        if (!this.reportCanvas.reportInfo.showMultiDrillDownSelectionOption()) {
            return;
        }
        this.addSeparator();
        this.add(this.newMenuItem("Select Multiple Drill-Down Values"));
    }

    private void addRefreshMenuItem() {
        if (!this.reportCanvas.isRefreshEnabled()) {
            return;
        }
        this.addSeparator();
        this.add(this.newMenuItem("Refresh"));
    }

    private void addGoToMenuItem() {
        if (!(this.reportCanvas.isPrevPageEnabled() || this.isNextPageEnabled || this.reportCanvas.isPrevSectionEnabled() || this.reportCanvas.isNextSectionEnabled())) {
            return;
        }
        this.addSeparator();
        CMenuItem f2 = this.newMenuItem("Go To ...");
        f2.setEnabled(this.isTotalPagesReady);
        this.add(f2);
    }

    private void addZoomMenuItem() {
        this.addSeparator();
        CMenuItem f2 = this.newMenuItem("Zoom ...");
        this.add(f2);
    }

    private CMenuItem newMenuItem(String s) {
        return this.newMenuItem(s, s);
    }

    private CMenuItem newMenuItem(String s, String cmd) {
        CMenuItem m = new CMenuItem(s);
        m.setActionCommand(cmd);
        m.addActionListener(this);
        return m;
    }

    public void add(CMenuItem item) {
        if (this.isItemVisible(item.getText())) {
            super.add(item);
        }
    }

    public void add(CMenu item) {
        if (this.isItemVisible(item.getText())) {
            super.add(item);
        }
    }

    public void add(CMenu menu, CMenuItem item) {
        if (this.isItemVisible(item.getText())) {
            menu.add(item);
        }
    }

    public void add(CMenu menu, CMenu item) {
        if (this.isItemVisible(item.getText())) {
            menu.add(item);
        }
    }

    private boolean isItemVisible(String str) {
        String[] list = this.reportCanvas.getInvisibleMenuItemList();
        if (list == null) {
            return true;
        }
        for (String element : list) {
            if (!str.equals(element)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isReady) {
            return;
        }
        String menustr = e.getActionCommand();
        if (menustr.endsWith(" [Server]")) {
            this.reportCanvas.setExportTarget(true);
            menustr = menustr.substring(0, menustr.length() - 9);
        } else if (menustr.endsWith(" [Client]")) {
            this.reportCanvas.setExportTarget(false);
            menustr = menustr.substring(0, menustr.length() - 9);
        }
        if (menustr.equals("Next Page")) {
            this.reportCanvas.setPage(this.reportCanvas.getPage() + 1);
        } else if (menustr.equals("Previous Page")) {
            this.reportCanvas.setPage(this.reportCanvas.getPage() - 1);
        } else if (menustr.equals("Next Section")) {
            this.reportCanvas.setSection(this.reportCanvas.getSection() + 1);
        } else if (menustr.equals("Previous Section")) {
            this.reportCanvas.setSection(this.reportCanvas.getSection() - 1);
        } else if (menustr.equals("First Page")) {
            this.reportCanvas.setPage(1);
        } else if (menustr.equals("Last Page")) {
            this.reportCanvas.setPage(this.reportCanvas.getAllAvailPages());
        } else if (menustr.equals("First Section")) {
            this.reportCanvas.setSection(1);
        } else if (menustr.equals("Last Section")) {
            this.reportCanvas.setSection(this.reportCanvas.getTotalSections());
        } else if (menustr.equals("Go To ...")) {
            new GoToDialog((Object)this.reportCanvas.reportInfo.getParent(), this.reportCanvas).setVisible(true);
        } else if (menustr.equals("Zoom ...")) {
            new ZoomDialog((Object)this.reportCanvas.reportInfo.getParent(), this.reportCanvas).setVisible(true);
        } else if (menustr.equals("Generate DHTML (Single Page)")) {
            this.reportCanvas.export(4);
        } else if (menustr.equals("Generate DHTML (Multiple Pages)")) {
            this.reportCanvas.export(4, true);
        } else if (menustr.equals("Generate DHTML (Paginated Single Page)")) {
            this.reportCanvas.export(4, false, true);
        } else if (menustr.equals("Generate PDF")) {
            this.reportCanvas.export(2);
        } else if (menustr.equals("Generate CSV")) {
            this.reportCanvas.export(3);
        } else if (menustr.equals("Generate RTF")) {
            this.reportCanvas.export(13);
        } else if (menustr.equals("Generate Excel (XLS)")) {
            this.reportCanvas.export(9);
        } else if (menustr.equals("Generate Excel 2007 (XLSX)")) {
            this.reportCanvas.export(17);
        } else if (menustr.equals("Generate TXT")) {
            this.reportCanvas.export(5);
        } else if (menustr.equals("Generate XML (Data + Format)")) {
            this.reportCanvas.export(6);
        } else if (menustr.equals("Generate XML (Pure Data)")) {
            this.reportCanvas.export(7);
        } else if (menustr.equals("Print")) {
            this.reportCanvas.print();
        } else if (menustr.equals("Refresh")) {
            this.reportCanvas.do_Reload();
        } else if (menustr.equals("Select Multiple Drill-Down Values")) {
            this.reportCanvas.doMultiDrillDown(this.reportCanvas.reportInfo.getNextLevelReport(), null, 0);
        } else if (menustr.equals("Back")) {
            if (this.reportCanvas.countLinkHistory() > 0) {
                this.reportCanvas.goBackHyperLink();
            }
        } else if (menustr.endsWith(" Column")) {
            String[] colList;
            for (String element : colList = this.reportCanvas.reportInfo.columnList) {
                if (menustr.equals("asc " + element + " Column")) {
                    this.reportCanvas.setOrder(true, element);
                    continue;
                }
                if (!menustr.equals("des " + element + " Column")) continue;
                this.reportCanvas.setOrder(false, element);
            }
        } else if (menustr.equals("Hide Report Toolbar")) {
            this.reportCanvas.setReportToolBarVisible(false);
        } else if (menustr.equals("Show Report Toolbar")) {
            this.reportCanvas.setReportToolBarVisible(true);
        }
        this.reportCanvas.repaint();
    }
}

