/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.PageViewer.swing;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.reportdesigner.PageViewer.swing.Report;
import quadbase.reportdesigner.PageViewer.swing.ReportInfo;

public class PrintReportForSwing {
    private static final Logger LOGGER = Logger.getLogger(PrintReportForSwing.class.getName());
    ReportInfo printInfo;
    Report report;

    public PrintReportForSwing(Component comp, ReportInfo reportInfo) {
        this.printInfo = reportInfo;
        this.report = new Report(comp, reportInfo);
    }

    public void print() throws Exception {
        PrinterJob job = PrinterJob.getPrinterJob();
        PageFormat pageFormat = job.defaultPage();
        if (this.printInfo.orientation == 1) {
            pageFormat.setOrientation(0);
        }
        Paper paper = pageFormat.getPaper();
        double max = pageFormat.getWidth();
        if (max < pageFormat.getHeight()) {
            max = pageFormat.getHeight();
        }
        paper.setImageableArea(0.0, 0.0, pageFormat.getWidth(), pageFormat.getHeight());
        pageFormat.setPaper(paper);
        pageFormat = job.pageDialog(pageFormat);
        paper = pageFormat.getPaper();
        max = pageFormat.getWidth();
        if (max < pageFormat.getHeight()) {
            max = pageFormat.getHeight();
        }
        paper.setImageableArea(0.0, 0.0, max, max);
        pageFormat.setPaper(paper);
        Book bk = new Book();
        int printPages = this.printInfo.getAllAvailPages();
        int totalSections = this.printInfo.totalSections;
        for (int i = 1; i <= printPages; ++i) {
            for (int j = 1; j <= totalSections; ++j) {
                bk.append(new PrintPage(i, j), pageFormat);
            }
        }
        job.setPageable(bk);
        if (job.printDialog()) {
            try {
                job.print();
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Cannot print report", ex);
            }
        }
    }

    private class PrintPage
    implements Printable {
        int page;
        int section;

        PrintPage(int page, int section) {
            this.page = page;
            this.section = section;
        }

        @Override
        public int print(Graphics g, PageFormat pf, int pageIndex) throws PrinterException {
            try {
                PrintReportForSwing.this.report.print(g, PrintReportForSwing.this.printInfo, this.page, this.section);
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Cannot print report", ex);
            }
            return 0;
        }
    }
}

