/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.PageViewer.swing;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.common.awt.Arc;
import quadbase.common.util.internal.FontTable;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.Java2DUtil;
import quadbase.common.util.internal.QbPattern;
import quadbase.miniutil.internal.ImageData;
import quadbase.miniutil.internal.RotateText;
import quadbase.reportdesigner.PageViewer.swing.ReportInfo;
import quadbase.reportdesigner.report.ImageMapNode;
import quadbase.util.internal.Composite;

public class Report {
    public static final int REPORT = 0;
    private static final Logger LOGGER = Logger.getLogger(Report.class.getName());
    String fileName;
    String fieldDrillDownLink;
    int width;
    int height;
    int reportType;
    float dx = 0.0f;
    float dy = 0.0f;
    float propx = 1.0f;
    float propy = 1.0f;
    Component component;
    boolean showReport = true;
    int curPage = 1;
    int curSection = 1;
    int totalSections = 1;
    int printPage = -1;
    int printSection = -1;
    Hashtable<Font, Font> fontTable;
    boolean printing = false;
    private Vector dataMap;
    private Vector currentVector;
    private Vector reportVector;
    private int position = 0;

    public Report(Component component, ReportInfo iFile) {
        this(component, iFile, 1, 1);
    }

    public Report(Component component, ReportInfo iFile, int p, int s) {
        this.curPage = p;
        this.curSection = s;
        this.component = component;
        this.fontTable = new Hashtable();
        this.update(iFile, this.curPage, this.curSection);
    }

    boolean needToUpdate(int p, int s) {
        return p != this.curPage || s != this.curSection;
    }

    void update(ReportInfo iFile, int p, int s) {
        try {
            this.reportVector = iFile.getSelectedPage(p, s);
            this.dataMap = iFile.getSelectedDataMap(p, s);
            this.curPage = p;
            this.curSection = s;
            this.fileName = iFile.fileName;
            this.fieldDrillDownLink = iFile.fieldDrillDownLink;
            this.reportType = iFile.reportType;
            this.width = iFile.width;
            this.height = iFile.height;
            this.totalSections = iFile.totalSections;
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Update error", ex);
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFieldDrillDownLink() {
        return this.fieldDrillDownLink;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int w) {
        this.width = w;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int h) {
        this.height = h;
    }

    public int getPage() {
        return this.curPage;
    }

    public void setPage(int h) {
        this.curPage = h;
    }

    public int getSection() {
        return this.curSection;
    }

    public void setSection(int h) {
        this.curSection = h;
    }

    public int getTotalSections() {
        return this.totalSections;
    }

    private void setProp(float propx, float propy) {
        if (propx != this.propx && propy != this.propy) {
            this.resetProp();
        }
        this.propx = propx;
        this.propy = propy;
    }

    private void resetProp() {
        this.fontTable.clear();
        this.propy = 1.0f;
        this.propx = 1.0f;
    }

    private void resetOffset() {
        this.dy = 0.0f;
        this.dx = 0.0f;
    }

    public void draw(ReportInfo info, Graphics g, int w, int h, int p, int s) throws Exception {
        this.setWidth(w);
        this.setHeight(h);
        this.setPage(p);
        this.setSection(s);
        this.draw(info, g);
    }

    public void draw(ReportInfo info, Graphics g) throws Exception {
        this.resetOffset();
        this.draw(info, g, this.reportVector);
        this.resetOffset();
    }

    public void print(Graphics g, ReportInfo reportInfo, int p, int s) throws Exception {
        Vector printVector = reportInfo.getSelectedPage(p, s);
        this.setPrintingMode(true);
        this.draw(reportInfo, g, printVector);
        this.setPrintingMode(false);
    }

    public void setPrintingMode(boolean printMode) {
        this.printing = printMode;
        if (this.printing) {
            float prop = (float)(72.0 / (double)Toolkit.getDefaultToolkit().getScreenResolution());
            this.setProp(prop, prop);
        } else {
            this.resetProp();
        }
    }

    public void zoomZoomZOOM(float zoomFactor) {
        this.setProp(zoomFactor, zoomFactor);
    }

    public void draw(ReportInfo reportInfo, Graphics g, Vector drawingMethod) throws Exception {
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (drawingMethod == null || drawingMethod.size() == 0) {
            return;
        }
        this.reset(drawingMethod);
        block42: while (this.position < drawingMethod.size()) {
            int command = this.readInt();
            switch (command) {
                case 1: {
                    g.clearRect(this.readX(), this.readY(), this.readW(), this.readH());
                    break;
                }
                case 2: {
                    g.drawArc(this.readX(), this.readY(), this.readW(), this.readH(), this.readInt(), this.readInt());
                    break;
                }
                case 3: {
                    g.drawLine(this.readX(), this.readY(), this.readX(), this.readY());
                    break;
                }
                case 4: {
                    g.drawOval(this.readX(), this.readY(), this.readW(), this.readH());
                    break;
                }
                case 5: {
                    g.drawPolygon(this.readXArray(), this.readYArray(), this.readInt());
                    break;
                }
                case 6: {
                    g.drawPolyline(this.readXArray(), this.readYArray(), this.readInt());
                    break;
                }
                case 7: {
                    g.drawRect(this.readX(), this.readY(), this.readW(), this.readH());
                    break;
                }
                case 8: {
                    g.drawRoundRect(this.readX(), this.readY(), this.readW(), this.readH(), this.readW(), this.readH());
                    break;
                }
                case 9: {
                    String str2 = reportInfo.getRunTimeValue(this.readString());
                    g.drawString(str2, this.readX(), this.readY());
                    break;
                }
                case 10: {
                    g.fillArc(this.readX(), this.readY(), this.readW(), this.readH(), this.readInt(), this.readInt());
                    break;
                }
                case 11: {
                    g.fillOval(this.readX(), this.readY(), this.readW(), this.readH());
                    break;
                }
                case 12: {
                    g.fillPolygon(this.readXArray(), this.readYArray(), this.readInt());
                    break;
                }
                case 13: {
                    g.fillRect(this.readX(), this.readY(), this.readW(), this.readH());
                    break;
                }
                case 14: {
                    g.fillRoundRect(this.readX(), this.readY(), this.readW(), this.readH(), this.readW(), this.readH());
                    break;
                }
                case 15: {
                    g.setColor(this.readColor());
                    break;
                }
                case 16: {
                    g.setFont(this.readFont(g));
                    break;
                }
                case 17: {
                    g.translate(this.readX(), this.readY());
                    break;
                }
                case 18: {
                    g.draw3DRect(this.readX(), this.readY(), this.readW(), this.readH(), this.readBoolean());
                    break;
                }
                case 19: {
                    g.fill3DRect(this.readX(), this.readY(), this.readW(), this.readH(), this.readBoolean());
                    break;
                }
                case 20: {
                    String str = reportInfo.getRunTimeValue(this.readString());
                    Font font = this.readFont(g);
                    boolean isJ2DRotate = this.readBoolean();
                    Color color = this.readColor();
                    if (this.component == null) {
                        this.component = IOUtil.getOffScreenComponent();
                    }
                    RotateText rText = new RotateText(str, this.component, this.readFloat());
                    rText.setFont(font);
                    rText.setJava2DRotateText(isJ2DRotate);
                    rText.setColor(color);
                    rText.prepareImage(g);
                    rText.setPos(this.readX(), this.readY());
                    rText.draw(g);
                    break;
                }
                case 21: {
                    String imageStr = this.readString();
                    ImageData image = new ImageData(new URL(imageStr), this.readInt());
                    if (this.component == null) {
                        this.component = IOUtil.getOffScreenComponent();
                    }
                    image.draw(g, this.readX(), this.readY(), this.readW(), this.readH(), this.component);
                    break;
                }
                case 22: {
                    float alpha = this.readFloat();
                    if (!IOUtil.isJava2D()) continue block42;
                    Composite.setCompositeSrcOver(g, alpha);
                    break;
                }
                case 23: {
                    if (!IOUtil.isJava2D()) continue block42;
                    Composite.setOriginalComposite(g);
                    break;
                }
                case 24: {
                    byte[] ba = this.readBytes();
                    ImageData idata = new ImageData(new URL("http://temp"), this.readInt());
                    Image i = Toolkit.getDefaultToolkit().createImage(ba);
                    idata.setImage(i);
                    if (this.component == null) {
                        this.component = IOUtil.getOffScreenComponent();
                    }
                    MediaTracker tracker = new MediaTracker(this.component);
                    tracker.addImage(i, 0);
                    tracker.waitForID(0);
                    if (tracker.isErrorID(0)) {
                        return;
                    }
                    idata.draw(g, this.readX(), this.readY(), this.readW(), this.readH(), this.component);
                    break;
                }
                case 25: {
                    if (!(g instanceof Graphics2D)) continue block42;
                    Graphics2D g2 = (Graphics2D)g;
                    g2.draw(new Line2D.Float(this.readFloat(), this.readFloat(), this.readFloat(), this.readFloat()));
                    break;
                }
                case 26: {
                    if (!(g instanceof Graphics2D)) continue block42;
                    Graphics2D g2 = (Graphics2D)g;
                    g2.draw(new Arc2D.Float(this.readFloat(), this.readFloat(), this.readFloat(), this.readFloat(), this.readFloat(), this.readFloat(), this.readInt()));
                    break;
                }
                case 27: {
                    if (!(g instanceof Graphics2D)) continue block42;
                    Graphics2D g2 = (Graphics2D)g;
                    float width = this.readFloat();
                    int cap = this.readInt();
                    int join = this.readInt();
                    float miterlimit = this.readFloat();
                    boolean hasArray = this.readBoolean();
                    float[] dashArray = null;
                    if (hasArray) {
                        dashArray = this.readDashArray();
                    }
                    float dash_phase = this.readFloat();
                    g2.setStroke(new BasicStroke(width, cap, join, miterlimit, dashArray, dash_phase));
                    break;
                }
                case 28: {
                    if (!(g instanceof Graphics2D)) continue block42;
                    Graphics2D g2 = (Graphics2D)g;
                    g2.draw(new RoundRectangle2D.Float(this.readFloat(), this.readFloat(), this.readFloat(), this.readFloat(), this.readFloat(), this.readFloat()));
                    break;
                }
                case 29: {
                    if (!(g instanceof Graphics2D)) continue block42;
                    Graphics2D g2 = (Graphics2D)g;
                    float x = this.readFloat();
                    float y = this.readFloat();
                    float width = this.readFloat();
                    float height = this.readFloat();
                    float r = this.readFloat();
                    float thickness = this.readFloat();
                    boolean drawTop = this.readBoolean();
                    boolean drawBottom = this.readBoolean();
                    Area rect = null;
                    if (drawTop && drawBottom) {
                        rect = new Area(new RoundRectangle2D.Float(x, y, width, height, 2.0f * r - thickness, 2.0f * r - thickness));
                    } else {
                        Area rect2;
                        if (drawTop) {
                            rect = new Area(new RoundRectangle2D.Float(x, y, width, height + r, 2.0f * r - thickness, 2.0f * r - thickness));
                            rect2 = new Area(new RoundRectangle2D.Float(x, y - r, width, r, 0.0f, 0.0f));
                            rect.subtract(rect2);
                        }
                        if (drawBottom) {
                            rect = new Area(new RoundRectangle2D.Float(x, y - r, width, height + r, 2.0f * r - thickness, 2.0f * r - thickness));
                            rect2 = new Area(new RoundRectangle2D.Float(x, y - r, width, r, 0.0f, 0.0f));
                            rect.subtract(rect2);
                        }
                        if (!drawTop && !drawBottom) {
                            rect = new Area(new RoundRectangle2D.Float(x, y, width, height, 0.0f, 0.0f));
                        }
                    }
                    if (rect == null) continue block42;
                    g2.fill(rect);
                    break;
                }
                case 30: {
                    String str3 = reportInfo.getRunTimeValue(this.readString());
                    int xPt1 = this.readX();
                    int wPt1 = this.readW();
                    short align = (short)this.readInt();
                    int yPt1 = this.readY();
                    boolean drawUnderline = this.readBoolean();
                    FontMetrics fm = g.getFontMetrics(g.getFont());
                    int strW = fm.stringWidth(str3);
                    xPt1 = this.getStringX(strW, xPt1, wPt1, align);
                    g.drawString(str3, xPt1, yPt1);
                    if (!drawUnderline || str3.trim().equals("")) continue block42;
                    int underLineY = yPt1 + fm.getDescent();
                    g.drawLine(xPt1, underLineY, strW + xPt1, underLineY);
                    break;
                }
                case 31: {
                    Object[] segment = this.readObjectArray();
                    int xPt2 = this.readX();
                    int yPt2 = this.readY();
                    for (Object element : segment) {
                        Object[] seg = (Object[])element;
                        if (seg.length == 4) {
                            String sStr = reportInfo.getRunTimeValue((String)seg[0]);
                            g.setFont(this.calcFont(seg[1], g));
                            g.setColor((Color)seg[2]);
                            boolean drawUnline = (Boolean)seg[3];
                            g.setFont(g.getFont());
                            FontMetrics fm1 = g.getFontMetrics(g.getFont());
                            int strW2 = fm1.stringWidth(sStr);
                            g.drawString(sStr, xPt2, yPt2);
                            if (drawUnline && !sStr.trim().equals("")) {
                                int underLineY = yPt2 + fm1.getDescent();
                                g.drawLine(xPt2, underLineY, strW2 + xPt2, underLineY);
                            }
                            xPt2 += strW2;
                            continue;
                        }
                        byte[] sImg = (byte[])seg[0];
                        int sW = this.calcWidth(seg[1]);
                        int sH = this.calcHeight(seg[2]);
                        if (sImg != null) {
                            ImageData idata2 = new ImageData(new URL("http://temp"), 1);
                            Image im = Toolkit.getDefaultToolkit().createImage(sImg);
                            idata2.setImage(im);
                            if (this.component == null) {
                                this.component = IOUtil.getOffScreenComponent();
                            }
                            MediaTracker tracker2 = new MediaTracker(this.component);
                            tracker2.addImage(im, 0);
                            tracker2.waitForID(0);
                            if (!tracker2.isErrorID(0)) {
                                idata2.draw(g, xPt2, yPt2 - sH, sW, sH, this.component);
                            }
                        }
                        xPt2 += sW;
                    }
                    continue block42;
                }
                case 32: {
                    Polygon poly = new Polygon(this.readXArray(), this.readYArray(), this.readInt());
                    double doubleX = this.readDoubleX();
                    double doubleY = this.readDoubleY();
                    double doubleW = this.readDoubleX();
                    if (!IOUtil.isJava2D()) continue block42;
                    Composite.fillIntersect(g, poly, doubleX, doubleY, doubleW);
                    break;
                }
                case 33: {
                    Polygon poly = new Polygon(this.readXArray(), this.readYArray(), this.readInt());
                    double doubleX = this.readDoubleX();
                    double doubleY = this.readDoubleY();
                    double doubleW = this.readDoubleX();
                    int thickness = this.readInt();
                    if (!IOUtil.isJava2D()) continue block42;
                    Composite.drawIntersect(g, poly, doubleX, doubleY, doubleW, thickness);
                    break;
                }
                case 34: {
                    int x1 = this.readX();
                    int y1 = this.readY();
                    Color color1 = this.readColor();
                    int x2 = this.readX();
                    int y2 = this.readY();
                    Color color2 = this.readColor();
                    boolean b1 = this.readBoolean();
                    if (!IOUtil.isJava2D()) continue block42;
                    Composite.setGradientPaint(g, x1, y1, color1, x2, y2, color2, b1);
                    break;
                }
                case 35: {
                    int patternStyle = this.readInt();
                    Color color5 = this.readColor();
                    QbPattern pattern = new QbPattern(color5, patternStyle);
                    this.setTexturePaint(g, pattern);
                    break;
                }
                case 36: {
                    Shape shape = this.readShape();
                    if (!(g instanceof Graphics2D)) continue block42;
                    ((Graphics2D)g).fill(shape);
                    break;
                }
                case 37: {
                    if (!(g instanceof Graphics2D)) continue block42;
                    this.drawCellWithRoundCorners((Graphics2D)g);
                    break;
                }
                case 38: {
                    if (!(g instanceof Graphics2D)) continue block42;
                    this.setClip((Graphics2D)g);
                    break;
                }
                case 39: {
                    if (!(g instanceof Graphics2D)) continue block42;
                    this.resetClip((Graphics2D)g);
                    break;
                }
                case 40: {
                    if (!(g instanceof Graphics2D)) continue block42;
                    String str = reportInfo.getRunTimeValue(this.readString());
                    Font font = this.readFont(g);
                    Color color = this.readColor();
                    short x = (short)((float)this.readShort() * this.propx);
                    short y = (short)((float)this.readShort() * this.propy);
                    int w = (int)((float)this.readInt() * this.propx);
                    int h = (int)((float)this.readInt() * this.propy);
                    short alignn = this.readShort();
                    short valign = this.readShort();
                    boolean isUnderline = this.readBoolean();
                    double rotation = this.readDouble();
                    int length = this.readInt();
                    int index = this.readInt();
                    Java2DUtil.drawRotateString(g, x, y, w, h, alignn, valign, isUnderline, rotation, font, str, length, index);
                    break;
                }
                default: {
                    LOGGER.warning("Report:  unknown drawing method: " + command);
                }
            }
        }
    }

    private void drawCellWithRoundCorners(Graphics2D g2d) throws Exception {
        float rX = this.readFloat() * this.propx;
        float rY = this.readFloat() * this.propx;
        int roundCornerRadius = this.readRadius();
        boolean[] roundCornersArray = this.readBooleans();
        float rW = this.readFloat() * this.propx;
        float rH = this.readFloat() * this.propx;
        int bc = this.readInt();
        Color borderColor = bc == 0 ? null : new Color(bc);
        int bgc = this.readInt();
        Color bgColor = bgc == 0 ? null : new Color(bgc);
        int gridStyle = this.readInt();
        int[] borderThickness = this.readIntegers(4);
        Java2DUtil.drawCellWithRoundCornersBySegments(g2d, rX, rY, roundCornerRadius, roundCornersArray, rW, rH, borderColor, bgColor, gridStyle, true, true, true, new float[]{borderThickness[0], borderThickness[1], borderThickness[2], borderThickness[3]});
    }

    private void setClip(Graphics2D g2d) throws Exception {
        int x = this.readInt();
        int y = this.readInt();
        int width = this.readInt();
        int height = this.readInt();
        g2d.setClip(x, y, width, height);
    }

    private void resetClip(Graphics2D g2d) throws Exception {
        g2d.setClip(null);
    }

    public boolean isDrillDownReport() {
        if (this.dataMap == null) {
            return false;
        }
        this.reset(this.dataMap);
        int size = this.dataMap.size();
        ImageMapNode node = null;
        for (int i = 0; i < size; ++i) {
            node = (ImageMapNode)this.dataMap.elementAt(i);
            if (!node.isDrillDownLink()) continue;
            return true;
        }
        return false;
    }

    public Vector getDataMap() {
        return this.dataMap;
    }

    public ImageMapNode selectDataMap(int xpos, int ypos) throws Exception {
        if (this.dataMap == null) {
            return null;
        }
        this.reset(this.dataMap);
        int size = this.dataMap.size();
        boolean foundIt = false;
        ImageMapNode node = null;
        xpos = (int)Math.ceil((float)xpos / this.propx);
        ypos = (int)Math.ceil((float)ypos / this.propy);
        for (int i = 0; !foundIt && i < size; ++i) {
            node = (ImageMapNode)this.dataMap.elementAt(i);
            if (node.getObject() instanceof Rectangle) {
                foundIt = ((Rectangle)node.getObject()).contains(xpos, ypos);
                continue;
            }
            if (node.getObject() instanceof Polygon) {
                foundIt = ((Polygon)node.getObject()).contains(xpos, ypos);
                continue;
            }
            if (!(node.getObject() instanceof Arc)) continue;
            foundIt = ((Arc)node.getObject()).contains(xpos, ypos);
        }
        if (!foundIt) {
            node = null;
        }
        this.resetOffset();
        return node;
    }

    private void reset(Vector vec) {
        this.position = 0;
        this.currentVector = vec;
    }

    private int[] readXArray() throws Exception {
        int count = this.readInt();
        int[] tmp = new int[count];
        for (int i = 0; i < count; ++i) {
            tmp[i] = this.readX();
        }
        return tmp;
    }

    private int[] readYArray() throws Exception {
        int count = this.readInt();
        int[] tmp = new int[count];
        for (int i = 0; i < count; ++i) {
            tmp[i] = this.readY();
        }
        return tmp;
    }

    private float[] readDashArray() throws Exception {
        int count = this.readInt();
        float[] tmp = new float[count];
        for (int i = 0; i < count; ++i) {
            tmp[i] = this.readFloat();
        }
        return tmp;
    }

    private boolean[] readBooleans() throws Exception {
        int count = this.readInt();
        boolean[] tmp = new boolean[count];
        for (int i = 0; i < count; ++i) {
            tmp[i] = this.readBoolean();
        }
        return tmp;
    }

    private float[] readFloats(int count) throws Exception {
        int size = this.readInt();
        if (size < 0) {
            return null;
        }
        float[] tmp = new float[size];
        for (int i = 0; i < count; ++i) {
            tmp[i] = this.readFloat();
        }
        return tmp;
    }

    private int[] readIntegers(int count) throws Exception {
        int[] tmp = new int[count];
        for (int i = 0; i < count; ++i) {
            tmp[i] = this.readInt();
        }
        return tmp;
    }

    private String readString() throws Exception {
        String tmp = (String)this.currentVector.elementAt(this.position);
        ++this.position;
        return tmp;
    }

    private byte[] readBytes() throws Exception {
        byte[] tmp = (byte[])this.currentVector.elementAt(this.position);
        ++this.position;
        return tmp;
    }

    private int readInt() throws Exception {
        int tmp = (Integer)this.currentVector.elementAt(this.position);
        ++this.position;
        return tmp;
    }

    private float readFloat() throws Exception {
        float tmp = ((Float)this.currentVector.elementAt(this.position)).floatValue();
        ++this.position;
        return tmp;
    }

    private short readShort() throws Exception {
        short tmp = (Short)this.currentVector.elementAt(this.position);
        ++this.position;
        return tmp;
    }

    private double readDouble() throws Exception {
        double tmp = (Double)this.currentVector.elementAt(this.position);
        ++this.position;
        return tmp;
    }

    private boolean readBoolean() throws Exception {
        boolean tmp = (Boolean)this.currentVector.elementAt(this.position);
        ++this.position;
        return tmp;
    }

    private Shape readShape() throws Exception {
        Shape tmp = (Shape)this.currentVector.elementAt(this.position);
        ++this.position;
        return tmp;
    }

    private Object[] readObjectArray() throws Exception {
        Object[] tmp = (Object[])this.currentVector.elementAt(this.position);
        ++this.position;
        return tmp;
    }

    private int calcWidth(Object xPt) {
        float tmp = ((Float)xPt).floatValue();
        return (int)Math.rint(tmp * (float)this.width * this.propx);
    }

    private int calcHeight(Object yPt) {
        float tmp = ((Float)yPt).floatValue();
        return (int)Math.rint(tmp * (float)this.height * this.propy);
    }

    private Font calcFont(Object font, Graphics g) throws Exception {
        return this.resizeFont(g, (Font)font);
    }

    private int readX() throws Exception {
        float tmp = ((Float)this.currentVector.elementAt(this.position)).floatValue();
        ++this.position;
        return (int)Math.rint((tmp += this.dx) * (float)this.width * this.propx);
    }

    private int readY() throws Exception {
        float tmp = ((Float)this.currentVector.elementAt(this.position)).floatValue();
        ++this.position;
        return (int)Math.rint((tmp += this.dy) * (float)this.height * this.propy);
    }

    private int readW() throws Exception {
        float tmp = ((Float)this.currentVector.elementAt(this.position)).floatValue();
        ++this.position;
        return (int)Math.rint(tmp * (float)this.width * this.propx);
    }

    private int readRadius() throws Exception {
        int tmp = (Integer)this.currentVector.elementAt(this.position);
        ++this.position;
        return (int)Math.rint((float)tmp * this.propx);
    }

    private int readH() throws Exception {
        float tmp = ((Float)this.currentVector.elementAt(this.position)).floatValue();
        ++this.position;
        return (int)Math.rint(tmp * (float)this.height * this.propy);
    }

    private double readDoubleX() throws Exception {
        double tmp = (Double)this.currentVector.elementAt(this.position);
        ++this.position;
        return (tmp += (double)this.dx) * (double)this.width * (double)this.propx;
    }

    private double readDoubleY() throws Exception {
        double tmp = (Double)this.currentVector.elementAt(this.position);
        ++this.position;
        return (tmp += (double)this.dy) * (double)this.height * (double)this.propy;
    }

    private Color readColor() throws Exception {
        return new Color(this.readInt());
    }

    private Font readFont(Graphics g) throws Exception {
        return this.resizeFont(g, FontTable.newFont(this.readString(), this.readInt(), this.readInt()));
    }

    private Font resizeFont(Graphics g, Font font) {
        if (this.propx == 1.0f || g == null) {
            return font;
        }
        Font newFont = this.fontTable.get(font);
        if (newFont != null) {
            return newFont;
        }
        String text = "mibrelts ESa";
        double printToScreenRatio = this.propx;
        if (printToScreenRatio == 1.0) {
            this.fontTable.put(font, font);
            return font;
        }
        FontMetrics fm = g.getFontMetrics(font);
        int orgWidth = fm.stringWidth(text);
        double newWidth = (double)orgWidth * printToScreenRatio;
        newFont = FontTable.newFont(font.getName(), font.getStyle(), font.getSize());
        if (printToScreenRatio < 1.0) {
            while ((double)orgWidth > newWidth && newFont.getSize() > 1) {
                newFont = FontTable.newFont(newFont.getName(), newFont.getStyle(), newFont.getSize() - 1);
                fm = g.getFontMetrics(newFont);
                orgWidth = fm.stringWidth(text);
            }
        } else {
            Font testFont = newFont;
            while ((double)orgWidth < newWidth) {
                newFont = testFont;
                testFont = FontTable.newFont(newFont.getName(), newFont.getStyle(), newFont.getSize() + 1);
                fm = g.getFontMetrics(testFont);
                orgWidth = fm.stringWidth(text);
            }
        }
        this.fontTable.put(font, newFont);
        return newFont;
    }

    private int getStringX(int strLen, int x, int w, short align) {
        switch (align) {
            case 2: {
                return x + w - strLen;
            }
            case 0: {
                return x + (int)Math.rint((double)(w - strLen) / 2.0);
            }
        }
        return x;
    }

    private void setTexturePaint(Graphics g, QbPattern texturePattern) {
        BufferedImage bImage;
        if (g instanceof Graphics2D) {
            bImage = texturePattern.getPatternImage();
            if (bImage == null) {
                g.setColor(texturePattern);
                return;
            }
        } else {
            g.setColor(texturePattern);
            return;
        }
        Rectangle2D.Double tr = new Rectangle2D.Double(0.0, 0.0, bImage.getWidth(), bImage.getHeight());
        TexturePaint tp = new TexturePaint(bImage, tr);
        ((Graphics2D)g).setPaint(tp);
    }
}

