/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.PageViewer.swing;

import java.awt.Color;
import java.awt.Frame;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.common.client.FileInfo;
import quadbase.common.client.ServerMessage;
import quadbase.common.network.IConnection;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.FontTable;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.ReadDataFile;
import quadbase.reportdesigner.PageViewer.swing.EnterParamDialog;
import quadbase.reportdesigner.PageViewer.swing.SortKeys;
import quadbase.reportdesigner.PageViewer.swing.ValueTable;
import quadbase.reportdesigner.report.ImageMapNode;

public class ReportInfo {
    private static final Logger LOGGER = Logger.getLogger(ReportInfo.class.getName());
    public static final int REPORTFILE = 1;
    public static final int DATAFILE = 2;
    public static final int RECEIVEDATA = 0;
    public static final int SHOWPARAMDIALOG = 1;
    public static final int EXPORTFILE = 2;
    public static final int GETFIRSTPAGE = 3;
    public static final int GETFILENAME = 4;
    public static final int GETNEXTPARAMORDERVALUES = 5;
    String fileName;
    String rootFileName;
    private byte[] reportData;
    Vector[][] report;
    Vector[][] dataMap;
    int width;
    int height;
    int reportType;
    String fieldDrillDownLink = "";
    private final int REL_TO_X = 1;
    private final int REL_TO_Y = 2;
    boolean refreshData = true;
    String baseFile;
    int curFile = -1;
    private int totalPages = -1;
    private int curMaxPage = 0;
    int totalSections = 1;
    public static final int PORTRAIT = 0;
    public static final int LANDSCAPE = 1;
    int orientation = 0;
    Object[] sqlparams;
    int lastPage = 1;
    int lastSection = 1;
    String[] columnList;
    SortKeys sortKeys;
    private boolean sortingEnabled = true;
    String[] paramName;
    Object[][] paramChoice;
    boolean isFirstFileAvail = false;
    ValueTable valueTable;
    long bufferTime = 3600000L;
    boolean showMultiDrillDownSelectionOption = false;
    String nextLevelReport = null;
    String[] mDrillColName = null;
    int[] mDrillSQLType = null;
    Object[][] mDrillColData = null;
    Frame parent = null;
    String securityLevel = null;
    boolean exportTarget = true;
    String exportServlet = "http://localhost:8080/servlet/ViewerExportServlet";
    boolean isDynamicExport = false;
    String serverName = "localhost";
    int serverPort = 8080;
    String servletDirectory = "servlet/";
    Object[] newSQLParam = null;
    Object[] newFUNParam = null;
    boolean cancelled = false;

    ReportInfo(String fileName, long bTime, String securityLevel) {
        this(fileName, null, null, bTime, null, securityLevel, null);
    }

    ReportInfo(String fileName, byte[] reportData, Object[] sqlparams, long bTime, Frame parent, String securityLevel, String rootFileName) {
        try {
            this.parent = parent;
            this.fileName = fileName;
            this.rootFileName = rootFileName;
            this.reportData = reportData;
            this.sqlparams = sqlparams;
            this.valueTable = new ValueTable(this);
            this.securityLevel = securityLevel;
            if (bTime >= 0L) {
                this.bufferTime = bTime;
            }
            if (fileName.toUpperCase().endsWith(".VIEW")) {
                this.loadViewFile(fileName);
            } else if (fileName.toUpperCase().endsWith(".RPT") || fileName.toUpperCase().endsWith(".PAK") || fileName.toUpperCase().endsWith(".QRP") || fileName.toUpperCase().endsWith(".XML")) {
                this.loadRPTFile(fileName, reportData, securityLevel);
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Cannot create new ReportInfo object", ex);
        }
    }

    public ReportInfo(String baseFile, int totalPages, int totalSections) {
        this.valueTable = new ValueTable(this);
        this.isFirstFileAvail = true;
        this.totalPages = totalPages;
        this.curMaxPage = totalPages;
        this.totalSections = totalSections;
        this.baseFile = baseFile + "_";
        this.width = 1;
        this.height = 1;
        this.report = new Vector[10][totalSections];
        this.dataMap = new Vector[10][totalSections];
    }

    private void loadRPTFile(String reportFileName, byte[] reportData, String securityLevel) throws Exception {
        this.loadRPTFile(reportFileName, reportData, securityLevel, 0);
    }

    private void loadRPTFile(String reportFileName, byte[] reportData, String securityLevel, int order) throws Exception {
        ServerMessage.useServer = true;
        this.isFirstFileAvail = false;
        this.totalPages = -1;
        this.curMaxPage = 0;
        this.baseFile = ReportInfo.getPrefixFileName(reportFileName);
        if (this.sqlparams != null) {
            for (Object sqlparam : this.sqlparams) {
                this.baseFile = this.baseFile + "_" + this.formatName(sqlparam.toString().hashCode() + "");
            }
        }
        if (securityLevel != null) {
            this.baseFile = this.baseFile + "_" + this.formatName(securityLevel);
        }
        LOGGER.finest("Load base file: " + this.baseFile);
        this.baseFile = this.getFileName(this.baseFile);
        LOGGER.finest("Base file: " + this.baseFile);
        DataInputStream in2 = this.getFirstPage(reportFileName, reportData, this.sqlparams, securityLevel, order, null);
        if (in2 == null) {
            this.loadErrorPages("This page is currently unavailable!");
            return;
        }
        this.curFile = 0;
        this.baseFile = this.baseFile + "_";
        this.report = new Vector[10][this.totalSections];
        this.dataMap = new Vector[10][this.totalSections];
        this.loadFirstPageFile(in2);
        try {
            in2.close();
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Failed to close input data stream", ex);
        }
    }

    int export(int exportType, String exportFile, boolean isExportToMultiPages, boolean paginatedSinglePage) throws Exception {
        ServerMessage.useServer = true;
        this.baseFile = ReportInfo.getPrefixFileName(this.fileName);
        if (this.sqlparams != null) {
            for (Object sqlparam : this.sqlparams) {
                this.baseFile = this.baseFile + "_" + this.formatName(sqlparam.toString().hashCode() + "");
            }
        }
        if (this.securityLevel != null) {
            this.baseFile = this.baseFile + "_" + this.formatName(this.securityLevel);
        }
        LOGGER.finest("Export base file: " + this.baseFile);
        this.baseFile = this.getFileName(this.baseFile);
        LOGGER.finest("Base file: " + this.baseFile);
        return this.export(this.fileName, this.reportData, this.sqlparams, exportType, exportFile, isExportToMultiPages, paginatedSinglePage);
    }

    void refresh() throws Exception {
        this.loadRPTFile(this.fileName, this.reportData, this.securityLevel);
    }

    void refresh(int order) throws Exception {
        this.loadRPTFile(this.fileName, this.reportData, this.securityLevel, order);
    }

    void resetParameters() throws Exception {
        this.sqlparams = null;
    }

    void resetSortKeys() throws Exception {
        if (this.sortKeys != null) {
            this.sortKeys.reset();
        }
    }

    private String formatName(String name) {
        String output = "";
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (this.isInvalid(c)) continue;
            output = output + c;
        }
        return output;
    }

    private boolean isInvalid(char c) {
        char[] invalidChar;
        for (char element : invalidChar = new char[]{' ', '\\', '/', ':', '*', '?', '\"', '<', '>', '|', '\''}) {
            if (c != element) continue;
            return true;
        }
        return false;
    }

    boolean sortingEnabled() {
        return this.sortingEnabled;
    }

    boolean showMultiDrillDownSelectionOption() {
        return this.showMultiDrillDownSelectionOption;
    }

    String getNextLevelReport() {
        return this.nextLevelReport;
    }

    void setParent(Frame frame) {
        this.parent = frame;
    }

    Frame getParent() {
        return this.parent != null ? this.parent : ServerMessage.getFrame();
    }

    private void loadViewFile(String fileName) throws Exception {
        ReadDataFile readDataFile = new ReadDataFile();
        DataInputStream in = readDataFile.getInputStream(fileName, true);
        this.loadViewFile(fileName, in);
        readDataFile.close();
    }

    private void loadViewFile(String viewFile, DataInputStream in) throws Exception {
        this.refreshData = false;
        int viewVersion = in.readInt();
        this.baseFile = IOUtil.readString(in);
        if (viewVersion >= 4 && in.readBoolean()) {
            this.securityLevel = IOUtil.readString(in);
        }
        this.baseFile = ReportInfo.getPrefixFileName(viewFile);
        boolean loadData = false;
        if (viewVersion >= 1) {
            loadData = in.readBoolean();
        }
        if (loadData) {
            String reportFileName = IOUtil.readString(in);
            this.loadRPTFile(reportFileName, null, this.securityLevel);
            this.fileName = reportFileName;
        } else {
            this.fileName = this.baseFile + ".rpt";
            this.sortingEnabled = false;
            this.fileName = null;
            this.width = in.readInt();
            this.height = in.readInt();
            if (viewVersion < 3) {
                this.totalPages = in.readInt();
            }
            LOGGER.finest("ReportInfo CP1: " + this.totalPages);
            this.totalSections = in.readInt();
            if (viewVersion >= 5) {
                this.orientation = in.readInt();
            }
            if (viewVersion >= 2) {
                this.columnList = new String[in.readInt()];
                for (int i = 0; i < this.columnList.length; ++i) {
                    this.columnList[i] = IOUtil.readString(in);
                }
                this.sortKeys = new SortKeys(in.readBoolean());
            } else {
                this.sortKeys = new SortKeys(false);
            }
            this.report = new Vector[10][this.totalSections];
            this.dataMap = new Vector[10][this.totalSections];
            this.baseFile = this.baseFile + "_";
            this.loadFirstSinglePage();
        }
    }

    private int loadPageFile(int page) throws Exception {
        int totalFiles;
        LOGGER.finest("Load page file: " + page);
        int index = (page - 1) / 10;
        if (this.getTotalPages() > 0 && index >= (totalFiles = (int)Math.ceil((double)this.totalPages / 10.0))) {
            return page;
        }
        ReadDataFile readDataFile = new ReadDataFile();
        try {
            DataInputStream in = readDataFile.getInputStream(this.baseFile + index + ".page", true);
            this.loadPageFile(in);
            this.curFile = index;
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "The page is unavailable", ex);
            this.loadErrorPages("This page is currently unavailable yet!");
        }
        try {
            readDataFile.close();
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Failed to close data input stream", ex);
        }
        return page;
    }

    private void loadPageFile(DataInputStream in) throws Exception {
        this.loadPageFile(in, 10);
        LOGGER.finest("First page is avail");
        this.isFirstFileAvail = true;
    }

    private void loadFirstPageFile(DataInputStream in) throws Exception {
        this.loadPageFile(in, 1);
        this.curFile = 0;
    }

    private void loadPageFile(DataInputStream in, int pageCount) throws Exception {
        int pageVersion = in.readInt();
        for (int i = 0; i < pageCount; ++i) {
            for (int j = 0; j < this.totalSections; ++j) {
                int drawPage = in.readInt();
                int drawSec = in.readInt();
                if (drawPage > this.curMaxPage) {
                    this.curMaxPage = drawPage;
                }
                this.report[i][j] = this.getDrawingMethod(in);
                if (pageVersion >= 1) {
                    this.dataMap[i][j] = this.getDataMap(in);
                }
                if (pageVersion < 2 || !in.readBoolean() || j != this.totalSections - 1) continue;
                this.totalPages = drawPage;
                LOGGER.finest("ReportInfo CP2: " + this.totalPages);
                return;
            }
        }
    }

    private boolean loadLastPage() throws Exception {
        FileInfo fInfo = new FileInfo(this.baseFile + "LAST.page");
        fInfo.isPageViewer = true;
        if (!fInfo.exists()) {
            return false;
        }
        ReadDataFile readDataFile = new ReadDataFile();
        DataInputStream in = readDataFile.getInputStream(this.baseFile + "LAST.page", true);
        int lastPageVersion = in.readInt();
        this.totalPages = in.readInt();
        LOGGER.finest("ReportInfo CP 3 : " + this.totalPages);
        readDataFile.close();
        return true;
    }

    boolean isFirstFileAvail() {
        if (this.isFirstFileAvail) {
            return true;
        }
        try {
            FileInfo fInfo = new FileInfo(this.baseFile + "0.page");
            fInfo.isPageViewer = true;
            if (!fInfo.exists()) {
                return false;
            }
            ReadDataFile readDataFile = new ReadDataFile();
            DataInputStream in = readDataFile.getInputStream(this.baseFile + "0.page", true);
            this.loadPageFile(in);
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Cannot read file", ex);
        }
        return this.isFirstFileAvail;
    }

    private void loadFirstSinglePage() throws Exception {
        try {
            ReadDataFile readDataFile = new ReadDataFile();
            DataInputStream in = readDataFile.getInputStream(this.baseFile + "FIRST.page", true);
            this.loadFirstPageFile(in);
            LOGGER.finest("Use first page");
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Cannot load first single page", ex);
            this.loadPageFile(0);
        }
    }

    int getAllAvailPages() {
        int tmp = this.getTotalPages();
        if (tmp > 0) {
            return tmp;
        }
        return this.curMaxPage;
    }

    int getTotalPages() {
        if (this.totalPages > 0) {
            return this.totalPages;
        }
        try {
            this.loadLastPage();
        }
        catch (Exception ex) {
            LOGGER.finest("Failed to load last page");
        }
        return this.totalPages;
    }

    boolean isTotalPagesReady() {
        return this.getTotalPages() > 0;
    }

    public boolean isSelectedPageReady(int page, int sec) {
        try {
            if (!this.isFirstFileAvail()) {
                return false;
            }
            if (this.isTotalPagesReady()) {
                return true;
            }
            int selectedFile = (page - 1) / 10;
            if (selectedFile <= this.curFile) {
                return true;
            }
            int index = (page - 1) / 10;
            FileInfo fInfo = new FileInfo(this.baseFile + index + ".page");
            fInfo.isPageViewer = true;
            return fInfo.exists();
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Failed to check if selected page is ready", ex);
            return false;
        }
    }

    public Vector getSelectedPage(int page, int sec) throws Exception {
        int selectedFile = (page - 1) / 10;
        if (selectedFile != this.curFile) {
            page = this.loadPageFile(page);
        }
        return this.report[(page - 1) % 10][sec - 1];
    }

    public boolean isPageAvailable(int page, int sec) {
        try {
            int selectedFile = (page - 1) / 10;
            if (selectedFile == this.curFile) {
                return true;
            }
            int index = (page - 1) / 10;
            FileInfo fInfo = new FileInfo(this.baseFile + index + ".page");
            fInfo.isPageViewer = true;
            return fInfo.exists();
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Failed to check if the page is available", ex);
            return false;
        }
    }

    Vector getSelectedDataMap(int page, int sec) throws Exception {
        int selectedFile = (page - 1) / 10;
        if (selectedFile != this.curFile) {
            page = this.loadPageFile(page);
        }
        return this.dataMap[(page - 1) % 10][sec - 1];
    }

    void setOrder(String sortColumn, boolean isAsc) {
        this.sortKeys.addKey(sortColumn, isAsc);
    }

    private void loadErrorPages(String errorStr) throws Exception {
        if (this.report == null) {
            this.report = new Vector[10][this.totalSections];
            this.dataMap = new Vector[10][this.totalSections];
            this.curFile = 0;
        }
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < this.totalSections; ++j) {
                this.report[i][j] = this.reportError(errorStr);
                this.dataMap[i][j] = new Vector();
            }
        }
    }

    private Vector<Object> reportError(String errorStr) {
        Vector<Object> vec = new Vector<Object>();
        vec.addElement(16);
        vec.addElement("TimesRoman");
        vec.addElement(1);
        vec.addElement(18);
        vec.addElement(9);
        vec.addElement(errorStr);
        vec.addElement(new Float(50.0 / (double)this.width));
        vec.addElement(new Float(50.0 / (double)this.height));
        return vec;
    }

    private Vector<Object> getDrawingMethod(DataInputStream in) throws Exception {
        short command = in.readShort();
        Vector<Object> list = new Vector<Object>();
        list.addElement(Integer.valueOf(command));
        while (command != 0) {
            switch (command) {
                case 1: 
                case 3: 
                case 4: 
                case 7: 
                case 11: 
                case 13: {
                    list.addElement(this.readX(in));
                    list.addElement(this.readY(in));
                    list.addElement(this.readX(in));
                    list.addElement(this.readY(in));
                    break;
                }
                case 2: 
                case 10: {
                    list.addElement(this.readX(in));
                    list.addElement(this.readY(in));
                    list.addElement(this.readX(in));
                    list.addElement(this.readY(in));
                    list.addElement(this.readShort(in));
                    list.addElement(this.readShort(in));
                    break;
                }
                case 5: 
                case 6: 
                case 12: {
                    this.readArray(list, in, 1);
                    this.readArray(list, in, 2);
                    list.addElement(this.readShort(in));
                    break;
                }
                case 9: {
                    list.addElement(IOUtil.readString(in));
                    list.addElement(this.readX(in));
                    list.addElement(this.readY(in));
                    break;
                }
                case 8: 
                case 14: {
                    list.addElement(this.readX(in));
                    list.addElement(this.readY(in));
                    list.addElement(this.readX(in));
                    list.addElement(this.readY(in));
                    list.addElement(this.readX(in));
                    list.addElement(this.readY(in));
                    break;
                }
                case 15: {
                    list.addElement(this.readInt(in));
                    break;
                }
                case 16: {
                    list.addElement(IOUtil.readString(in));
                    list.addElement(this.readShort(in));
                    list.addElement(this.readShort(in));
                    break;
                }
                case 17: {
                    list.addElement(this.readX(in));
                    list.addElement(this.readY(in));
                    break;
                }
                case 18: 
                case 19: {
                    list.addElement(this.readX(in));
                    list.addElement(this.readY(in));
                    list.addElement(this.readX(in));
                    list.addElement(this.readY(in));
                    list.addElement(this.readBoolean(in));
                    break;
                }
                case 20: {
                    list.addElement(IOUtil.readString(in));
                    list.addElement(IOUtil.readString(in));
                    list.addElement(this.readShort(in));
                    list.addElement(this.readShort(in));
                    list.addElement(this.readBoolean(in));
                    list.addElement(this.readInt(in));
                    list.addElement(this.readFloat(in));
                    list.addElement(this.readX(in));
                    list.addElement(this.readY(in));
                    break;
                }
                case 21: {
                    list.addElement(IOUtil.readString(in));
                    list.addElement(this.readShort(in));
                    list.addElement(this.readX(in));
                    list.addElement(this.readY(in));
                    list.addElement(this.readX(in));
                    list.addElement(this.readY(in));
                    break;
                }
                case 22: {
                    list.addElement(this.readFloat(in));
                    break;
                }
                case 24: {
                    int len = in.readInt();
                    byte[] ba = new byte[len];
                    in.read(ba, 0, len);
                    list.addElement(ba);
                    list.addElement(this.readShort(in));
                    list.addElement(this.readX(in));
                    list.addElement(this.readY(in));
                    list.addElement(this.readX(in));
                    list.addElement(this.readY(in));
                    break;
                }
                case 25: {
                    list.addElement(this.readFloat(in));
                    list.addElement(this.readFloat(in));
                    list.addElement(this.readFloat(in));
                    list.addElement(this.readFloat(in));
                    break;
                }
                case 26: {
                    list.addElement(this.readFloat(in));
                    list.addElement(this.readFloat(in));
                    list.addElement(this.readFloat(in));
                    list.addElement(this.readFloat(in));
                    list.addElement(this.readFloat(in));
                    list.addElement(this.readFloat(in));
                    list.addElement(this.readInt(in));
                    break;
                }
                case 27: {
                    list.addElement(this.readFloat(in));
                    list.addElement(this.readInt(in));
                    list.addElement(this.readInt(in));
                    list.addElement(this.readFloat(in));
                    boolean b = this.readBoolean(in);
                    list.addElement(b);
                    if (b) {
                        int size = this.readInt(in);
                        list.addElement(size);
                        for (int i = 0; i < size; ++i) {
                            list.addElement(this.readFloat(in));
                        }
                    }
                    list.addElement(this.readFloat(in));
                    break;
                }
                case 28: {
                    list.addElement(this.readFloat(in));
                    list.addElement(this.readFloat(in));
                    list.addElement(this.readFloat(in));
                    list.addElement(this.readFloat(in));
                    list.addElement(this.readFloat(in));
                    list.addElement(this.readFloat(in));
                    break;
                }
                case 29: {
                    list.addElement(this.readFloat(in));
                    list.addElement(this.readFloat(in));
                    list.addElement(this.readFloat(in));
                    list.addElement(this.readFloat(in));
                    list.addElement(this.readFloat(in));
                    list.addElement(this.readFloat(in));
                    list.addElement(this.readBoolean(in));
                    list.addElement(this.readBoolean(in));
                    break;
                }
                case 30: {
                    list.addElement(IOUtil.readString(in));
                    list.addElement(this.readX(in));
                    list.addElement(this.readX(in));
                    list.addElement(this.readShort(in));
                    list.addElement(this.readY(in));
                    list.addElement(this.readBoolean(in));
                    break;
                }
                case 31: {
                    Object[] seg = new Object[in.readShort()];
                    for (int i = 0; i < seg.length; ++i) {
                        if (in.readShort() == 0) {
                            Object[] objectArray = new Object[]{IOUtil.readString(in), FontTable.newFont(IOUtil.readString(in), in.readShort(), in.readShort()), new Color(in.readInt()), this.readBoolean(in)};
                            seg[i] = objectArray;
                            continue;
                        }
                        Object[] objectArray = new Object[3];
                        int imageSize = in.readInt();
                        if (imageSize >= 0) {
                            byte[] ba2 = new byte[imageSize];
                            in.read(ba2, 0, imageSize);
                            objectArray[0] = ba2;
                        }
                        objectArray[1] = this.readX(in);
                        objectArray[2] = this.readY(in);
                        seg[i] = objectArray;
                    }
                    list.addElement(seg);
                    list.addElement(this.readX(in));
                    list.addElement(this.readY(in));
                    break;
                }
                case 32: {
                    this.readArray(list, in, 1);
                    this.readArray(list, in, 2);
                    list.addElement(this.readShort(in));
                    list.addElement(this.readDoubleX(in));
                    list.addElement(this.readDoubleY(in));
                    list.addElement(this.readDoubleX(in));
                    break;
                }
                case 33: {
                    this.readArray(list, in, 1);
                    this.readArray(list, in, 2);
                    list.addElement(this.readShort(in));
                    list.addElement(this.readDoubleX(in));
                    list.addElement(this.readDoubleY(in));
                    list.addElement(this.readShort(in));
                    break;
                }
                case 34: {
                    list.addElement(this.readX(in));
                    list.addElement(this.readY(in));
                    list.addElement(this.readInt(in));
                    list.addElement(this.readX(in));
                    list.addElement(this.readY(in));
                    list.addElement(this.readInt(in));
                    list.addElement(this.readBoolean(in));
                    break;
                }
                case 35: {
                    list.addElement(this.readInt(in));
                    list.addElement(this.readInt(in));
                    break;
                }
                case 36: {
                    list.addElement(this.readShape(in));
                    break;
                }
                case 37: {
                    int[] nArray;
                    list.addElement(this.readFloat(in));
                    list.addElement(this.readFloat(in));
                    list.addElement(this.readInt(in));
                    boolean[] roundCornersArray = IOUtil.readBooleans(in);
                    list.addElement(roundCornersArray.length);
                    for (boolean element : roundCornersArray) {
                        list.addElement(element);
                    }
                    list.addElement(this.readFloat(in));
                    list.addElement(this.readFloat(in));
                    list.addElement(this.readInt(in));
                    list.addElement(this.readInt(in));
                    list.addElement(this.readInt(in));
                    for (int element : nArray = IOUtil.readInts(in, 4)) {
                        list.addElement(element);
                    }
                    break;
                }
                case 38: {
                    list.addElement(this.readInt(in));
                    list.addElement(this.readInt(in));
                    list.addElement(this.readInt(in));
                    list.addElement(this.readInt(in));
                    break;
                }
                case 23: 
                case 39: {
                    break;
                }
                case 40: {
                    list.addElement(IOUtil.readString(in));
                    list.addElement(IOUtil.readString(in));
                    list.addElement(this.readShort(in));
                    list.addElement(this.readShort(in));
                    list.addElement(this.readInt(in));
                    list.addElement(this.readShort2(in));
                    list.addElement(this.readShort2(in));
                    list.addElement(this.readInt(in));
                    list.addElement(this.readInt(in));
                    list.addElement(this.readShort2(in));
                    list.addElement(this.readShort2(in));
                    list.addElement(this.readBoolean(in));
                    list.addElement(this.readDouble(in));
                    list.addElement(this.readInt(in));
                    list.addElement(this.readInt(in));
                    break;
                }
                default: {
                    LOGGER.warning("ReportInfo:  unknown drawing method: " + command);
                }
            }
            command = in.readShort();
            list.addElement(command);
        }
        list.removeElementAt(list.size() - 1);
        return list;
    }

    private Vector<ImageMapNode> getDataMap(DataInputStream in) throws Exception {
        Vector<ImageMapNode> list = new Vector<ImageMapNode>(10);
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            list.addElement(ImageMapNode.read(in));
        }
        return list;
    }

    private void readArray(Vector<Object> list, DataInputStream in, int state) throws Exception {
        int count = in.readShort();
        list.addElement(count);
        if (state == 1) {
            for (int i = 0; i < count; ++i) {
                list.addElement(this.readX(in));
            }
        } else {
            for (int i = 0; i < count; ++i) {
                list.addElement(this.readY(in));
            }
        }
    }

    private Shape readShape(DataInputStream in) throws Exception {
        int seg = in.readInt();
        GeneralPath path = new GeneralPath();
        while (seg != -1) {
            switch (seg) {
                case 4: {
                    break;
                }
                case 0: {
                    path.moveTo(in.readFloat(), in.readFloat());
                    break;
                }
                case 1: {
                    path.lineTo(in.readFloat(), in.readFloat());
                    break;
                }
                case 2: {
                    path.quadTo(in.readFloat(), in.readFloat(), in.readFloat(), in.readFloat());
                    break;
                }
                case 3: {
                    path.curveTo(in.readFloat(), in.readFloat(), in.readFloat(), in.readFloat(), in.readFloat(), in.readFloat());
                }
            }
            seg = in.readInt();
        }
        return path;
    }

    private Integer readShort(DataInputStream in) throws Exception {
        return in.readShort();
    }

    private Short readShort2(DataInputStream in) throws Exception {
        return in.readShort();
    }

    private Float readX(DataInputStream in) throws Exception {
        return Float.valueOf((float)in.readShort() / (float)this.width);
    }

    private Float readY(DataInputStream in) throws Exception {
        return Float.valueOf((float)in.readShort() / (float)this.height);
    }

    private Double readDoubleX(DataInputStream in) throws Exception {
        return in.readDouble() / (double)this.width;
    }

    private Double readDoubleY(DataInputStream in) throws Exception {
        return in.readDouble() / (double)this.height;
    }

    private Integer readInt(DataInputStream in) throws Exception {
        return in.readInt();
    }

    private Double readDouble(DataInputStream in) throws Exception {
        return in.readDouble();
    }

    private Float readFloat(DataInputStream in) throws Exception {
        return Float.valueOf(in.readFloat());
    }

    private Boolean readBoolean(DataInputStream in) throws Exception {
        return in.readBoolean();
    }

    private String getFileName(String basefile) throws Exception {
        return ReportInfo.getFileName(basefile, null);
    }

    static String getFileName(String basefile, SortKeys sortKeys) throws Exception {
        IConnection socket = ServerMessage.createConnection();
        ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
        DataOutputStream dout = new DataOutputStream(bstream);
        dout.writeShort(20881);
        IOUtil.writeString(dout, "REPORTFILE");
        dout.writeInt(0);
        dout.writeBoolean(false);
        IOUtil.writeString(dout, basefile);
        IOUtil.writeString(dout, "");
        dout.writeInt(4);
        dout.writeBoolean(sortKeys != null && !sortKeys.isEmpty());
        try {
            byte[] array = bstream.toByteArray();
            socket.setContentLength(array.length);
            socket.getOutputStream().write(array);
            socket.getOutputStream().flush();
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Failed to write data", ex);
            if (socket != null) {
                socket.close();
            }
            throw ex;
        }
        String retname = null;
        try {
            DataInputStream dstream = new DataInputStream(socket.getInputStream());
            int code = dstream.readInt();
            if (code != 0) {
                throw new IOException(IOUtil.getErrorString(code) + IOUtil.readString(dstream));
            }
            retname = IOUtil.readString(dstream);
            dstream.close();
            socket.close();
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Can't read data", ex);
            try {
                socket.close();
            }
            catch (Exception ex2) {
                LOGGER.log(Level.FINEST, "Can't close socket", ex2);
            }
            throw ex;
        }
        catch (Error err) {
            LOGGER.log(Level.FINEST, "Can't read data", err);
            try {
                socket.close();
            }
            catch (Exception ex2) {
                LOGGER.log(Level.FINEST, "Can't close socket", ex2);
            }
            throw new Exception(err.getMessage());
        }
        return retname;
    }

    private void writeToServer(IConnection socket, String reportFile, byte[] reportData, Object[] sqlparams, int jobRequest, String securityLevel, int order, int[] mapping) throws Exception {
        this.writeToServer(socket, reportFile, reportData, sqlparams, jobRequest, -1, null, false, false, securityLevel, order, mapping);
    }

    private void writeToServer(IConnection socket, String reportFile, byte[] reportData, Object[] sqlparams, int jobRequest, int exportType, String exportFile, boolean isMultiPage, boolean paginatedSinglePage, String securityLevel, int order) throws Exception {
        this.writeToServer(socket, reportFile, reportData, sqlparams, jobRequest, exportType, exportFile, isMultiPage, paginatedSinglePage, securityLevel, order, null);
    }

    private void writeToServer(IConnection socket, String reportFile, byte[] reportData, Object[] sqlparams, int jobRequest, int exportType, String exportFile, boolean isMultiPage, boolean paginatedSinglePage, String securityLevel, int order, int[] mapping) throws Exception {
        ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
        DataOutputStream dout = new DataOutputStream(bstream);
        int slaveType = 20881;
        dout.writeShort(slaveType);
        IOUtil.writeString(dout, reportFile);
        if (reportData != null) {
            dout.writeInt(reportData.length);
            dout.write(reportData);
        } else {
            dout.writeInt(0);
        }
        if (securityLevel != null) {
            dout.writeBoolean(true);
            IOUtil.writeString(dout, securityLevel);
        } else {
            dout.writeBoolean(false);
        }
        IOUtil.writeString(dout, this.baseFile);
        IOUtil.writeString(dout, this.rootFileName == null ? "" : this.rootFileName);
        dout.writeInt(jobRequest);
        if (sqlparams == null) {
            dout.writeBoolean(false);
        } else {
            dout.writeBoolean(true);
            dout.writeInt(sqlparams.length);
            for (Object sqlparam : sqlparams) {
                dout.writeBoolean(sqlparam != null);
                if (sqlparam == null) continue;
                dout.writeBoolean(sqlparam instanceof Vector);
                if (sqlparam instanceof Vector) {
                    Vector vec = (Vector)sqlparam;
                    dout.writeInt(vec.size());
                    for (int j = 0; j < vec.size(); ++j) {
                        IOUtil.writeString(dout, DataType.write(vec.elementAt(j)));
                    }
                    continue;
                }
                IOUtil.writeString(dout, DataType.write(sqlparam));
            }
        }
        dout.writeInt(order);
        if (mapping == null) {
            dout.writeInt(0);
        } else {
            dout.writeInt(mapping.length);
            for (int element : mapping) {
                dout.writeInt(element);
            }
        }
        if (this.sortKeys != null) {
            this.sortKeys.write(dout);
        } else {
            dout.writeInt(0);
        }
        if (jobRequest == 2) {
            dout.writeInt(exportType);
            IOUtil.writeString(dout, exportFile);
            dout.writeBoolean(isMultiPage);
            dout.writeBoolean(paginatedSinglePage);
            dout.writeBoolean(this.exportTarget);
            IOUtil.writeString(dout, this.exportServlet);
            dout.writeBoolean(this.isDynamicExport);
            IOUtil.writeString(dout, this.serverName);
            dout.writeInt(this.serverPort);
            IOUtil.writeString(dout, this.servletDirectory);
        }
        dout.writeLong(this.bufferTime);
        try {
            byte[] byArray = bstream.toByteArray();
            socket.setContentLength(byArray.length);
            socket.getOutputStream().write(byArray);
            socket.getOutputStream().flush();
        }
        catch (Exception exception) {
            LOGGER.log(Level.FINEST, "Can't write data", exception);
            if (socket != null) {
                socket.close();
            }
            throw exception;
        }
    }

    private int export(String reportFile, byte[] reportData, Object[] sqlparams, int exportType, String exportFile, boolean isExportToMultiPages, boolean paginatedSinglePage) throws Exception {
        IConnection socket = ServerMessage.createConnection();
        int key = -1;
        this.writeToServer(socket, reportFile, reportData, sqlparams, 2, exportType, exportFile, isExportToMultiPages, paginatedSinglePage, this.securityLevel, -1);
        try {
            DataInputStream dstream = new DataInputStream(socket.getInputStream());
            int code = dstream.readInt();
            key = dstream.readInt();
            if (code != 0) {
                throw new IOException(IOUtil.getErrorString(code) + IOUtil.readString(dstream));
            }
            dstream.close();
            socket.close();
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Cannot read data", ex);
            try {
                socket.close();
            }
            catch (Exception ex2) {
                LOGGER.log(Level.FINEST, "Can't close socket", ex2);
            }
            throw ex;
        }
        catch (Error err) {
            LOGGER.log(Level.FINEST, "Cannot read data", err);
            try {
                socket.close();
            }
            catch (Exception ex2) {
                LOGGER.log(Level.FINEST, "Can't close socket", ex2);
            }
            throw new Exception(err.getMessage());
        }
        return key;
    }

    Vector getNextParamOrderValues(int order, Object[] prevValues, int[] mapping) throws Exception {
        IConnection socket = ServerMessage.createConnection();
        this.writeToServer(socket, this.fileName, this.reportData, prevValues, 5, this.securityLevel, order, mapping);
        try {
            DataInputStream dstream = new DataInputStream(socket.getInputStream());
            int code = dstream.readInt();
            if (code != 0) {
                throw new IOException(IOUtil.getErrorString(code) + IOUtil.readString(dstream));
            }
            int len = dstream.readInt();
            Object[][] paramChoice = new Object[len][];
            for (int i = 0; i < len; ++i) {
                paramChoice[i] = new Object[dstream.readInt()];
                for (int j = 0; j < paramChoice[i].length; ++j) {
                    paramChoice[i][j] = DataType.read(IOUtil.readString(dstream));
                }
            }
            Object[][] defaultVals = new Object[len][];
            for (int i = 0; i < len; ++i) {
                defaultVals[i] = new Object[dstream.readInt()];
                for (int j = 0; j < defaultVals[i].length; ++j) {
                    defaultVals[i][j] = DataType.read(IOUtil.readString(dstream));
                }
            }
            Vector<Object[][]> result = new Vector<Object[][]>();
            result.add(paramChoice);
            result.add(defaultVals);
            return result;
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Cannot read data", ex);
            try {
                socket.close();
            }
            catch (Exception ex2) {
                LOGGER.log(Level.FINEST, "Can't close socket", ex2);
            }
            throw ex;
        }
        catch (Error err) {
            LOGGER.log(Level.FINEST, "Cannot read data", err);
            try {
                socket.close();
            }
            catch (Exception ex2) {
                LOGGER.log(Level.FINEST, "Can't close socket", ex2);
            }
            throw new Exception(err.getMessage());
        }
    }

    private DataInputStream getFirstPage(String reportFile, byte[] reportData, Object[] sqlparams, String securityLevel, int order, int[] mapping) throws Exception {
        byte[] indata;
        IConnection socket = ServerMessage.createConnection();
        this.writeToServer(socket, reportFile, reportData, sqlparams, 3, securityLevel, order, mapping);
        try {
            int i;
            DataInputStream dstream = new DataInputStream(socket.getInputStream());
            int code = dstream.readInt();
            if (code != 0) {
                throw new IOException(IOUtil.getErrorString(code) + IOUtil.readString(dstream));
            }
            if (dstream.readInt() == 1) {
                int i2;
                int j;
                int i3;
                int maxOrder = dstream.readInt();
                order = dstream.readInt();
                int len = dstream.readInt();
                int[] seq = null;
                if (len > 0) {
                    seq = new int[len];
                    for (int i4 = 0; i4 < seq.length; ++i4) {
                        seq[i4] = dstream.readInt();
                    }
                }
                int paramSize = dstream.readInt();
                String[] paramName = new String[paramSize];
                Object[] defaultValue = new Object[paramSize];
                boolean[] isMultiValue = new boolean[paramSize];
                boolean[] useComboBox = new boolean[paramSize];
                String[] dateFormat = new String[paramSize];
                boolean[] isSecParamMapped = new boolean[paramSize];
                int[] sqlType = new int[paramSize];
                Object[][] paramChoice = new Object[paramSize][];
                boolean[] isAllOptionEnabled = new boolean[paramSize];
                String[] allOptionLabel = new String[paramSize];
                for (i3 = 0; i3 < paramSize; ++i3) {
                    paramName[i3] = IOUtil.readString(dstream);
                    isMultiValue[i3] = dstream.readBoolean();
                    if (isMultiValue[i3]) {
                        Vector<Object> v = new Vector<Object>();
                        int defSize = dstream.readInt();
                        for (j = 0; j < defSize; ++j) {
                            v.add(DataType.read(IOUtil.readString(dstream)));
                        }
                        defaultValue[i3] = v;
                    } else {
                        defaultValue[i3] = DataType.read(IOUtil.readString(dstream));
                    }
                    useComboBox[i3] = dstream.readBoolean();
                    isSecParamMapped[i3] = dstream.readBoolean();
                    dateFormat[i3] = IOUtil.readStr(dstream);
                    sqlType[i3] = dstream.readInt();
                    paramChoice[i3] = new Object[dstream.readInt()];
                    for (int j2 = 0; j2 < paramChoice[i3].length; ++j2) {
                        paramChoice[i3][j2] = DataType.read(IOUtil.readString(dstream));
                    }
                    isAllOptionEnabled[i3] = dstream.readBoolean();
                    allOptionLabel[i3] = IOUtil.readStr(dstream);
                }
                mapping = new int[dstream.readInt()];
                for (i3 = 0; i3 < mapping.length; ++i3) {
                    mapping[i3] = dstream.readInt();
                }
                int[] reorderedMapping = new int[dstream.readInt()];
                for (int i5 = 0; i5 < reorderedMapping.length; ++i5) {
                    reorderedMapping[i5] = dstream.readInt();
                }
                Object[] newParam = this.promptParamDialog(paramName, paramChoice, isMultiValue, useComboBox, sqlType, defaultValue, isSecParamMapped, dateFormat, sqlparams, seq, mapping, reorderedMapping, isAllOptionEnabled, allOptionLabel);
                if (newParam == null) {
                    this.cancelled = true;
                    return null;
                }
                int qCt = 0;
                if (this.newSQLParam == null && sqlparams != null && mapping.length == 0) {
                    for (i2 = 0; i2 < sqlparams.length; ++i2) {
                        if (sqlparams[i2] == null || sqlparams[i2].equals("UnMapped")) continue;
                        ++qCt;
                    }
                }
                if (qCt > 0) {
                    this.newSQLParam = new Object[paramSize + qCt];
                    j = 0;
                    for (int i6 = 0; i6 < this.newSQLParam.length; ++i6) {
                        if (sqlparams != null && i6 < sqlparams.length && sqlparams[i6] != null && !sqlparams[i6].equals("UnMapped")) {
                            this.newSQLParam[i6] = sqlparams[i6];
                            continue;
                        }
                        if (j >= paramSize) continue;
                        this.newSQLParam[i6] = newParam[j++];
                    }
                } else if (sqlparams != null) {
                    this.newSQLParam = new Object[paramSize];
                    for (i2 = 0; i2 < this.newSQLParam.length; ++i2) {
                        this.newSQLParam[i2] = reorderedMapping[i2] > -1 ? sqlparams[reorderedMapping[i2]] : newParam[i2];
                    }
                } else {
                    this.newSQLParam = newParam;
                }
                for (i2 = 0; this.newSQLParam != null && i2 < this.newSQLParam.length; ++i2) {
                    this.baseFile = this.baseFile + "_" + this.formatName(this.newSQLParam[i2].toString().hashCode() + "");
                }
                return this.getFirstPage(reportFile, reportData, this.newSQLParam, securityLevel, order + 1, mapping);
            }
            this.width = dstream.readInt();
            this.height = dstream.readInt();
            this.totalSections = dstream.readInt();
            this.orientation = dstream.readInt();
            this.columnList = new String[dstream.readInt()];
            for (i = 0; i < this.columnList.length; ++i) {
                this.columnList[i] = IOUtil.readString(dstream);
            }
            this.showMultiDrillDownSelectionOption = dstream.readBoolean();
            if (this.showMultiDrillDownSelectionOption) {
                this.nextLevelReport = IOUtil.readString(dstream);
                this.mDrillColName = new String[dstream.readInt()];
                this.mDrillSQLType = new int[this.mDrillColName.length];
                this.mDrillColData = new Object[this.mDrillColName.length][];
                for (i = 0; i < this.mDrillColName.length; ++i) {
                    this.mDrillColName[i] = IOUtil.readString(dstream);
                    this.mDrillSQLType[i] = dstream.readInt();
                    this.mDrillColData[i] = new Object[dstream.readInt()];
                    for (int j = 0; j < this.mDrillColData[i].length; ++j) {
                        this.mDrillColData[i][j] = DataType.read(IOUtil.readString(dstream));
                    }
                }
            }
            boolean isColumnar = dstream.readBoolean();
            if (this.sortKeys == null) {
                this.sortKeys = new SortKeys(isColumnar);
            }
            int len = dstream.readInt();
            indata = new byte[len];
            dstream.readFully(indata, 0, len);
            dstream.close();
            socket.close();
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Cannot read data", ex);
            try {
                socket.close();
            }
            catch (Exception ex2) {
                LOGGER.log(Level.FINEST, "Failed to close socket", ex2);
            }
            throw ex;
        }
        catch (Error err) {
            LOGGER.log(Level.FINEST, "Cannot read data", err);
            try {
                socket.close();
            }
            catch (Exception ex2) {
                LOGGER.log(Level.FINEST, "Failed to close socket", ex2);
            }
            throw new Exception(err.getMessage());
        }
        return new DataInputStream(new ByteArrayInputStream(indata));
    }

    private static String getPrefixFileName(String name) {
        String path = name.replace('\\', '/');
        int lastDir = path.lastIndexOf(47);
        int index = name.lastIndexOf(46);
        if (index > 0 && index > lastDir) {
            return name.substring(0, index);
        }
        return name;
    }

    String getRunTimeValue(String inStr) {
        return this.valueTable.getRunTimeValue(inStr);
    }

    private Object[] promptParamDialog(String[] columnName, Object[][] choice, boolean[] isMultiValue, boolean[] useComboBox, int[] sqlType, Object[] defaultValue, boolean[] isSecParamMapped, String[] dateFormat, Object[] sqlparams, int[] seq, int[] mapping, int[] reorderedMapping, boolean[] isAllOptionEnabled, String[] allOptionLabel) {
        EnterParamDialog dialog = new EnterParamDialog(this, this.getParent(), columnName, choice, isMultiValue, useComboBox, sqlType, defaultValue, isSecParamMapped, dateFormat, sqlparams, seq, mapping, reorderedMapping, isAllOptionEnabled, allOptionLabel);
        dialog.setVisible(true);
        return dialog.getValues();
    }

    Object[] promptMultiDrillDownDialog() {
        if (this.mDrillColName == null) {
            return null;
        }
        int size = this.mDrillColName.length;
        boolean[] isMultiValue = new boolean[size];
        boolean[] useComboBox = new boolean[size];
        Object[] defaultValue = new Object[size];
        boolean[] isSecParamMapped = new boolean[size];
        String[] dateFormat = new String[size];
        for (int i = 0; i < size; ++i) {
            isMultiValue[i] = true;
            useComboBox[i] = true;
            isSecParamMapped[i] = false;
        }
        EnterParamDialog dialog = new EnterParamDialog(this, this.getParent(), this.mDrillColName, this.mDrillColData, isMultiValue, useComboBox, this.mDrillSQLType, defaultValue, isSecParamMapped, dateFormat, null, null, null, null, null, null);
        dialog.setVisible(true);
        return dialog.getValues();
    }

    boolean getExportTarget() {
        return this.exportTarget;
    }

    void setExportTarget(boolean server) {
        this.exportTarget = server;
    }

    void setExportServlet(String url) {
        this.exportServlet = url;
    }

    void setDynamicExport(boolean state, String serverName, int serverPort, String servletDirectory) {
        this.isDynamicExport = state;
        this.serverName = serverName;
        this.serverPort = serverPort;
        this.servletDirectory = servletDirectory;
    }

    void backupInfo(int page, int sec) {
        this.report = new Vector[10][this.totalSections];
        this.dataMap = new Vector[10][this.totalSections];
        this.curFile = -1;
        this.lastPage = page;
        this.lastSection = sec;
    }

    int getLastBrowsePage() {
        return this.lastPage;
    }

    int getLastBrowseSection() {
        return this.lastSection;
    }
}

