/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.PageViewer.swing;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import quadbase.common.client.ServerMessage;
import quadbase.reportdesigner.PageViewer.swing.CButton;
import quadbase.reportdesigner.PageViewer.swing.CComboBox;
import quadbase.reportdesigner.PageViewer.swing.CPanel;
import quadbase.reportdesigner.PageViewer.swing.CSpinBox;
import quadbase.reportdesigner.PageViewer.swing.ReportCanvas;

public class ReportToolBar
extends CPanel
implements ActionListener {
    private CButton firstPageBut;
    private CButton lastPageBut;
    private CButton prevPageBut;
    private CButton nextPageBut;
    private CButton backBut;
    private ReportCanvas reportCanvas;
    private CButton sortBut;
    private CButton zoomBut;
    private CSpinBox zoomFactor;
    private CComboBox comboListBut;
    private CComboBox dirBut;
    private CPanel panel1;

    public ReportToolBar(ReportCanvas reportCanvas) {
        this(reportCanvas, false);
    }

    public ReportToolBar(ReportCanvas reportCanvas, boolean showBackBut) {
        this.reportCanvas = reportCanvas;
        this.setLayout(new GridLayout(2, 1, 0, 0));
        this.panel1 = new CPanel();
        this.panel1.setLayout(new GridLayout(1, 0, 0, 0));
        this.comboListBut = this.getColumnList();
        this.dirBut = this.getDirectionList();
        if (ServerMessage.useServer && reportCanvas.reportInfo.sortingEnabled() && reportCanvas.sortMenuVisible) {
            this.panel1.add(this.comboListBut);
            this.panel1.add(this.dirBut);
            this.sortBut = new CButton("Sort");
            this.panel1.add(this.sortBut);
            this.sortBut.addActionListener(this);
        }
        this.zoomFactor = new CSpinBox(1, 200, 1);
        this.panel1.add(this.zoomFactor);
        this.zoomFactor.setValue(reportCanvas.getZoomFactor());
        this.zoomBut = new CButton("Zoom");
        this.panel1.add(this.zoomBut);
        this.zoomBut.addActionListener(this);
        if (reportCanvas.isBackButtonVisible() || showBackBut) {
            this.backBut = new CButton("Back");
            this.panel1.add(this.backBut);
            this.backBut.addActionListener(this);
            this.backBut.setEnabled(reportCanvas.countLinkHistory() > 0);
        }
        this.firstPageBut = new CButton("<< First");
        this.firstPageBut.addActionListener(this);
        this.prevPageBut = new CButton("< Previous");
        this.prevPageBut.addActionListener(this);
        this.nextPageBut = new CButton("Next >");
        this.nextPageBut.addActionListener(this);
        this.lastPageBut = new CButton("Last >>");
        this.lastPageBut.addActionListener(this);
        CPanel panel2 = new CPanel();
        panel2.setLayout(new GridLayout(1, -1, 0, 0));
        panel2.add(this.firstPageBut);
        panel2.add(this.prevPageBut);
        panel2.add(this.nextPageBut);
        panel2.add(this.lastPageBut);
        this.add(this.panel1);
        this.add(panel2);
        this.setEnabled();
    }

    private CComboBox getDirectionList() {
        CComboBox box = new CComboBox();
        box.addItem("ASC");
        box.addItem("DES");
        return box;
    }

    private CComboBox getColumnList() {
        String[] colList;
        CComboBox box = new CComboBox();
        for (String element : colList = this.reportCanvas.reportInfo.columnList) {
            box.addItem(element);
        }
        return box;
    }

    public void setEnabled() {
        if (this.backBut == null && this.reportCanvas.isBackButtonVisible()) {
            this.backBut = new CButton("Back");
            this.panel1.add(this.backBut);
            this.backBut.addActionListener(this);
            if (this.reportCanvas.isReportToolBarVisible()) {
                this.reportCanvas.setReportToolBarVisible(false);
                this.reportCanvas.setReportToolBarVisible(true);
            }
        }
        if (this.backBut != null) {
            this.backBut.setEnabled(this.reportCanvas.countLinkHistory() > 0);
        }
        this.lastPageBut.setEnabled(this.reportCanvas.isTotalPagesReady() && this.reportCanvas.isFirstFileAvail());
        this.nextPageBut.setEnabled(this.reportCanvas.isNextAvailPageEnabled());
        this.prevPageBut.setEnabled(this.reportCanvas.isPrevAvailPageEnabled());
        this.firstPageBut.setEnabled(true);
    }

    boolean isBackButtonVisible() {
        return this.backBut != null;
    }

    void updateZoomFactor() {
        this.zoomFactor.setValue(this.reportCanvas.getZoomFactor());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.firstPageBut) {
            this.reportCanvas.setPage(1);
            this.reportCanvas.setSection(1);
        } else if (e.getSource() == this.lastPageBut) {
            this.reportCanvas.setPage(this.reportCanvas.getAllAvailPages());
            this.reportCanvas.setSection(this.reportCanvas.getTotalSections());
        } else if (e.getSource() == this.prevPageBut) {
            this.reportCanvas.goToPreviousAvailPage();
        } else if (e.getSource() == this.backBut) {
            this.reportCanvas.goBackHyperLink();
        } else if (e.getSource() == this.nextPageBut) {
            this.reportCanvas.goToNextAvailPage();
        } else if (e.getSource() == this.backBut) {
            if (this.reportCanvas.countLinkHistory() > 0) {
                this.reportCanvas.goBackHyperLink();
            }
        } else if (e.getSource() == this.sortBut) {
            String[] colList = this.reportCanvas.reportInfo.columnList;
            int i = this.comboListBut.getSelectedIndex();
            boolean dir = this.dirBut.getSelectedIndex() == 0;
            this.reportCanvas.setOrder(dir, colList[i]);
        } else if (e.getSource() == this.zoomBut) {
            int zoomFac = this.zoomFactor.getValue();
            if (zoomFac <= 0) {
                zoomFac = 100;
            }
            if (zoomFac > 200) {
                zoomFac = 200;
            }
            this.reportCanvas.setZoomFactor(zoomFac);
            this.reportCanvas.resetOffScreenImage();
        }
        this.reportCanvas.repaint();
        this.setEnabled();
    }
}

