/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.PageViewer.swing;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import quadbase.common.util.internal.IOUtil;

public class SortKeys {
    Vector list = new Vector();
    boolean isColumnar = false;

    public SortKeys(boolean isColumnar) {
        this.isColumnar = isColumnar;
    }

    void addKey(String columnName, boolean isAsc) {
        Pair pair = new Pair(columnName, isAsc);
        if (this.isColumnar && this.list.size() > 0) {
            this.list.removeAllElements();
        }
        this.list.addElement(pair);
    }

    boolean isEmpty() {
        return this.list.size() == 0;
    }

    void reset() {
        this.list = new Vector();
    }

    void write(DataOutputStream dout) throws IOException {
        dout.writeInt(this.list.size());
        for (int i = 0; i < this.list.size(); ++i) {
            Pair pair = (Pair)this.list.elementAt(i);
            IOUtil.writeString(dout, pair.columnName);
            dout.writeBoolean(pair.isAsc);
        }
    }

    private class Pair {
        String columnName;
        boolean isAsc;

        public Pair(String columnName, boolean isAsc) {
            this.columnName = columnName;
            this.isAsc = isAsc;
        }
    }
}

