/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.PageViewer.swing;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import quadbase.reportdesigner.PageViewer.swing.ReportInfo;

public class ValueTable {
    static final String PREFIX = "#";
    ReportInfo reportInfo;
    Hashtable uniqueKey;
    Vector key;

    public ValueTable(ReportInfo reportInfo) {
        this.reportInfo = reportInfo;
        this.uniqueKey = null;
        this.addBasicKeys();
    }

    private void addBasicKeys() {
        this.addKey("TP");
        this.addKey("TOTALPAGES");
    }

    private void addKey(String newKey) {
        if (this.key == null) {
            this.key = new Vector();
        }
        this.key.removeElement(newKey);
        this.key.addElement(newKey);
    }

    public String[] getAllVariables() {
        if (this.key == null) {
            return null;
        }
        int nKey = this.key.size();
        if (nKey == 0) {
            return null;
        }
        String[] result = new String[nKey];
        for (int i = 0; i < nKey; ++i) {
            result[i] = (String)this.key.elementAt(i);
        }
        return result;
    }

    public String findValue(String target) {
        if (target == null || this.key == null) {
            return null;
        }
        boolean find = false;
        int nKey = this.key.size();
        for (int i = 0; i < nKey; ++i) {
            if (!target.equalsIgnoreCase((String)this.key.elementAt(i))) continue;
            find = true;
            break;
        }
        if (!find) {
            return null;
        }
        if (target.equalsIgnoreCase("TP")) {
            return this.getTotalPages();
        }
        if (target.equalsIgnoreCase("TOTALPAGES")) {
            return this.getTotalPages();
        }
        return null;
    }

    private String getTotalPages() {
        int i = this.reportInfo.getTotalPages();
        if (i > 0) {
            return i + "";
        }
        return "TOTALPAGES";
    }

    public Enumeration getUniqueKeyList() {
        if (this.uniqueKey == null) {
            return null;
        }
        return this.uniqueKey.keys();
    }

    public Enumeration getUniqueElementList() {
        if (this.uniqueKey == null) {
            return null;
        }
        return this.uniqueKey.elements();
    }

    private String getRunTimeUniqueKeyValue(String inString) {
        if (this.uniqueKey == null) {
            return inString;
        }
        Enumeration key = this.uniqueKey.keys();
        Enumeration value = this.uniqueKey.elements();
        while (key.hasMoreElements()) {
            inString = ValueTable.replace(inString, (String)key.nextElement(), (String)value.nextElement());
        }
        return inString;
    }

    private static String replace(String str, String oldChars, String newChars) {
        int i = str.indexOf(oldChars);
        int oldCharLen = oldChars.length();
        while (i >= 0) {
            if (i > 0 && str.charAt(i - 1) != '\t' && str.charAt(i - 1) != '\n' && str.charAt(i - 1) != '\r' && str.charAt(i - 1) != '\f' && str.charAt(i - 1) != ' ') {
                i = str.indexOf(oldChars, i + oldCharLen);
                continue;
            }
            if (i + oldCharLen < str.length() && str.charAt(i + oldCharLen) != '\t' && str.charAt(i + oldCharLen) != '\n' && str.charAt(i + oldCharLen) != '\r' && str.charAt(i + oldCharLen) != '\f' && str.charAt(i + oldCharLen) != ' ') {
                i = str.indexOf(oldChars, i + oldCharLen);
                continue;
            }
            String str1 = "";
            String str2 = "";
            if (i != 0) {
                str1 = str.substring(0, i);
            }
            if (i + oldCharLen < str.length()) {
                str2 = str.substring(i + oldCharLen);
            }
            str = str1 + newChars + str2;
            if (i + newChars.length() >= str.length()) break;
            i = str.indexOf(oldChars, i + newChars.length());
        }
        return str;
    }

    String getRunTimeValue(String inString) {
        if (inString.startsWith("Evaluation copy by Quadbase Systems Inc.")) {
            return inString;
        }
        if (inString.indexOf(PREFIX) < 0) {
            return this.getRunTimeUniqueKeyValue(inString);
        }
        int currentIndex = 0;
        String delimiter = " \t\n\r#";
        String inStringCopy = inString;
        while ((currentIndex = inStringCopy.indexOf(PREFIX, currentIndex)) >= 0) {
            String token;
            String value;
            String subString;
            StringTokenizer st;
            int length = inStringCopy.length();
            if (currentIndex < length - 1 && (st = new StringTokenizer(subString = inStringCopy.substring(currentIndex + 1, length), delimiter)).hasMoreTokens() && (value = this.findValue(token = st.nextToken())) != null) {
                inStringCopy = inStringCopy.substring(0, currentIndex) + value + inStringCopy.substring(currentIndex + 1 + token.length(), length);
            }
            ++currentIndex;
        }
        return this.getRunTimeUniqueKeyValue(inStringCopy);
    }
}

