/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.ReportAPI;

import java.io.DataInputStream;
import quadbase.ChartAPI.QbChart;
import quadbase.chart.Chart;
import quadbase.chart.ColData;
import quadbase.chart.LoadChart;
import quadbase.chart.ReadDataFile;
import quadbase.chart.ReloadChart;
import quadbase.common.client.FileInfo;
import quadbase.common.client.ServerMessage;
import quadbase.common.util.internal.FileInMemTable;
import quadbase.reportdesigner.ReportAPI.QbReport;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportSection;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.ReportElements.ReportTableElement;
import quadbase.reportdesigner.ReportElements.ReportTreeTable;
import quadbase.reportdesigner.util.IChart;
import quadbase.util.IColumnMap;
import quadbase.util.internal.TransposeRS;

public class ChartObject
extends QbChart
implements IChart {
    private boolean doTransposeData;
    private int[] transposeCol;

    public ChartObject(QbReport qbReport, int dimension, int chartType, boolean doTransposeData, int[] transposeCol, IColumnMap cmap, String template) {
        this(qbReport, dimension, chartType, doTransposeData, transposeCol, cmap, template, null, false);
    }

    public ChartObject(QbReport qbReport, int dimension, int chartType, boolean doTransposeData, int[] transposeCol, IColumnMap cmap, String template, ReportTableElement panel) {
        this(qbReport, dimension, chartType, doTransposeData, transposeCol, cmap, template, panel, false);
    }

    public ChartObject(QbReport qbReport, int dimension, int chartType, boolean doTransposeData, int[] transposeCol, IColumnMap cmap, String template, ReportTableElement panel, boolean useSummaryData) {
        super(true);
        this.doTransposeData = doTransposeData;
        this.transposeCol = transposeCol;
        ReportTable tbl = qbReport.getTable();
        boolean inTable = false;
        int sectionIndex = -1;
        if (panel != null && panel instanceof ReportSection) {
            ReportSection tempSection = tbl.getHeader();
            if (panel.getID().equals(tempSection.getID())) {
                inTable = true;
            }
            tempSection = tbl.getFooter();
            if (panel.getID().equals(tempSection.getID())) {
                inTable = true;
            }
            if (!inTable) {
                int i;
                int counter = tbl.countRowBreakFooter();
                for (i = 0; i < counter; ++i) {
                    if (!panel.getID().equals(tbl.getRowBreakHeader(i).getID())) continue;
                    sectionIndex = i;
                    break;
                }
                counter = tbl.countRowBreakHeader();
                for (i = 0; i < counter; ++i) {
                    if (!panel.getID().equals(tbl.getRowBreakFooter(i).getID())) continue;
                    sectionIndex = i;
                    break;
                }
            }
        }
        if (!inTable && tbl instanceof ReportTreeTable) {
            ReportTreeTable mtbl = (ReportTreeTable)tbl;
            try {
                if (mtbl.countSubTable() <= 0) {
                    tbl.formatTable();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            for (int i = 0; i < sectionIndex; ++i) {
                if (!(tbl instanceof ReportTreeTable)) continue;
                if (((ReportTreeTable)tbl).countSubTable() == 0) break;
                tbl = ((ReportTreeTable)tbl).getSubTable(0);
            }
            if (tbl instanceof ReportTreeTable && ((ReportTreeTable)tbl).countSubTable() > 0) {
                tbl = ((ReportTreeTable)tbl).getSubTable(0);
            }
        } else {
            try {
                if (tbl.getColumn(0).isDataEmpty()) {
                    tbl.formatTable();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        ReportCell[] cells = null;
        if (panel != null && panel instanceof ReportSection) {
            cells = ((ReportSection)panel).getData();
        }
        ColData[] colData = quadbase.reportdesigner.report.ChartObject.getColData(qbReport.getReportObj(), tbl, cells, useSummaryData, null);
        try {
            if (doTransposeData) {
                colData = ColData.getColData(TransposeRS.doTranspose(colData, TransposeRS.getTransposeColumn(transposeCol)));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IllegalArgumentException(ex.getMessage());
        }
        this.createChart(dimension, chartType, colData, cmap, template);
        if (this.chart == null && this.getErrorMessage().equals(SURFACEDATAERROR)) {
            throw new IllegalArgumentException("The data cannot plot a 3D surface chart");
        }
        if (this.chart == null) {
            throw new IllegalArgumentException("Invalid argument(s).  Cannot create the chart");
        }
        this.chart.sourceData = 0;
    }

    public ChartObject(Object chartInfo) {
        super((Chart)chartInfo);
        this.chart.sourceData = 0;
    }

    public static ChartObject createChartObject(QbReport report, String templateFileName) {
        return ChartObject.createChartObject(report, templateFileName, null);
    }

    public static ChartObject createChartObject(QbReport report, String templateFileName, ReportSection panel) {
        LoadChart lc = new LoadChart();
        ReportTable tbl = report.getTable();
        boolean inTable = false;
        int sectionIndex = -1;
        String sectionNameStr = "";
        if (panel != null) {
            ReportSection tempSection = tbl.getHeader();
            if (panel.getID().equals(tempSection.getID())) {
                inTable = true;
            }
            tempSection = tbl.getFooter();
            if (panel.getID().equals(tempSection.getID())) {
                inTable = true;
            }
            if (!inTable) {
                int i;
                int counter = tbl.countRowBreakFooter();
                for (i = 0; i < counter; ++i) {
                    if (!panel.getID().equals(tbl.getRowBreakHeader(i).getID())) continue;
                    sectionIndex = i;
                    sectionNameStr = "H";
                    break;
                }
                counter = tbl.countRowBreakHeader();
                for (i = 0; sectionNameStr.equals("") && i < counter; ++i) {
                    if (!panel.getID().equals(tbl.getRowBreakFooter(i).getID())) continue;
                    sectionIndex = i;
                    sectionNameStr = "F";
                    break;
                }
            }
        }
        if (!inTable && tbl instanceof ReportTreeTable) {
            ReportTreeTable mtbl = (ReportTreeTable)tbl;
            try {
                if (mtbl.countSubTable() <= 0) {
                    tbl.formatTable();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            for (int i = 0; i < sectionIndex; ++i) {
                if (!(tbl instanceof ReportTreeTable)) continue;
                if (((ReportTreeTable)tbl).countSubTable() == 0) break;
                tbl = ((ReportTreeTable)tbl).getSubTable(0);
            }
            if (tbl instanceof ReportTreeTable && ((ReportTreeTable)tbl).countSubTable() > 0) {
                tbl = ((ReportTreeTable)tbl).getSubTable(0);
            }
        } else {
            try {
                if (tbl.getColumn(0).isDataEmpty()) {
                    tbl.formatTable();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        ReportCell[] cells = null;
        if (panel != null) {
            cells = panel.getData();
        }
        boolean isCrossTab = report.getReportType() == 2;
        ColData[] colData = quadbase.reportdesigner.report.ChartObject.getColData(report.getReportObj(), tbl, cells, isCrossTab, null);
        try {
            DataInputStream din = null;
            FileInfo fileInfo = new FileInfo(templateFileName);
            ReadDataFile readFile = new ReadDataFile();
            if (fileInfo.exists()) {
                din = readFile.getInputStream(templateFileName);
            } else {
                FileInMemTable subFilesTable = report.getReportObj().getSubFilesTable();
                String absFilePath = ServerMessage.getPath(templateFileName);
                din = readFile.getInputStream(subFilesTable, absFilePath);
            }
            Chart c = lc.loadChartFromReport(din, colData);
            boolean istransposed = c.isTransposed;
            boolean[] transposeCol = c.getTransposeColumn();
            int[] transposeIndexCol = null;
            if (istransposed && transposeCol != null) {
                int transCount = 0;
                for (boolean element : transposeCol) {
                    if (!element) continue;
                    ++transCount;
                }
                transposeIndexCol = new int[transCount];
                transCount = 0;
                for (int i = 0; i < transposeCol.length; ++i) {
                    if (!transposeCol[i]) continue;
                    transposeIndexCol[transCount] = i;
                    ++transCount;
                }
            }
            QbChart chart = new QbChart(c);
            ChartObject co = new ChartObject((Object)chart.getChart());
            return co;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Chart setNewData(ColData[] colData) throws Exception {
        if (colData == null) {
            return this.chart;
        }
        if (this.doTransposeData) {
            colData = ColData.getColData(TransposeRS.doTranspose(colData, TransposeRS.getTransposeColumn(this.transposeCol)));
        }
        return ReloadChart.reloadData(this.chart, colData);
    }
}

