/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.ReportAPI;

import java.applet.Applet;
import java.io.PrintStream;
import quadbase.common.client.ServerMessage;
import quadbase.common.paramquery.QueryClassFileInfo;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.SOAPQueryFileInfo;
import quadbase.common.paramquery.SalesForceQueryFileInfo;
import quadbase.common.util.IOLAPResultSet;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.EJBInfo;
import quadbase.common.util.internal.ExcelFileInfo;
import quadbase.common.util.internal.XMLFileQueryInfo;
import quadbase.reportdesigner.ReportAPI.DBInfo;
import quadbase.reportdesigner.ReportAPI.DbData;
import quadbase.reportdesigner.report.ColData;
import quadbase.reportdesigner.report.DBAccess;
import quadbase.reportdesigner.report.DataFileInput;
import quadbase.reportdesigner.report.EJBAccess;
import quadbase.reportdesigner.report.ExcelAccess;
import quadbase.reportdesigner.report.OLAPAccess;
import quadbase.reportdesigner.report.SOAPAccess;
import quadbase.reportdesigner.report.SalesForceAccess;
import quadbase.reportdesigner.util.IDatabaseInfo;
import quadbase.reportdesigner.util.IQueryFileInfo;
import quadbase.reportdesigner.util.IResultSet;
import quadbase.reportdesigner.util.ISpreadSheetModel;
import quadbase.reportdesigner.util.internal.TransposeRS;

public class DataSheet {
    private ColData[] colData = null;
    boolean doTranspose = false;
    boolean[] transposeCol;
    Object source = null;
    int dataFileType = 0;

    public DataSheet(Applet applet, IDatabaseInfo dbInfo) {
        this(applet, dbInfo, false, null);
    }

    public DataSheet(Applet applet, IDatabaseInfo dbInfo, boolean doTranspose, int[] transposeColIdx) {
        this(applet, dbInfo, doTranspose, transposeColIdx, 0, -1);
    }

    public DataSheet(Applet applet, IDatabaseInfo dbInfo, boolean doTranspose, int[] transposeColIdx, int startIndex, int count) {
        try {
            ServerMessage.setApplet(applet);
            boolean[] transposeCol = TransposeRS.getTransposeColumn(transposeColIdx);
            if (dbInfo instanceof IQueryFileInfo) {
                QueryFileInfo queryFileInfo = new QueryFileInfo((IQueryFileInfo)dbInfo);
                this.colData = DBAccess.retrieveResult(QueryFileInfo.getDBAccessParameter(queryFileInfo), queryFileInfo, true, doTranspose, transposeCol, null, null, startIndex, count, false);
            } else {
                this.colData = DBInfo.getColData(dbInfo, doTranspose, transposeCol, startIndex, count, false);
            }
            this.createColDataFail();
            this.source = dbInfo;
            this.doTranspose = doTranspose;
            this.transposeCol = transposeCol;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public DataSheet(Applet applet, QueryClassFileInfo queryFileInfo) {
        this(applet, queryFileInfo, 0, -1);
    }

    public DataSheet(Applet applet, QueryClassFileInfo queryFileInfo, int startIndex, int count) {
        try {
            ServerMessage.setApplet(applet);
            this.colData = new DataFileInput().readProcessedData(queryFileInfo.getClassFile(), false, null, null, null, startIndex, count, queryFileInfo.getInSet());
            this.createColDataFail();
            this.source = queryFileInfo;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex.toString());
        }
    }

    public DataSheet(Applet applet, String dataFile) {
        this(applet, dataFile, 0);
    }

    public DataSheet(Applet applet, String dataFile, int dataFileType) {
        this(applet, dataFile, false, null, dataFileType);
    }

    public DataSheet(Applet applet, String dataFile, int dataFileType, int startIndex, int count) {
        this(applet, dataFile, false, null, dataFileType, startIndex, count);
    }

    public DataSheet(Applet applet, String dataFile, boolean doTranspose, int[] transposeColIdx, int dataFileType) {
        this(applet, dataFile, doTranspose, transposeColIdx, dataFileType, 0, -1);
    }

    public DataSheet(Applet applet, String dataFile, boolean doTranspose, int[] transposeColIdx, int dataFileType, int startIndex, int count) {
        try {
            ServerMessage.setApplet(applet);
            this.dataFileType = dataFileType;
            int tmp = 2;
            if (dataFileType == 3) {
                tmp = 6;
            } else if (dataFileType == 2) {
                tmp = 4;
            }
            boolean[] transposeCol = TransposeRS.getTransposeColumn(transposeColIdx);
            this.colData = new DataFileInput().readProcessedData(dataFile, doTranspose, transposeCol, null, null, startIndex, count, null, tmp);
            this.createColDataFail();
            this.source = dataFile;
            this.doTranspose = doTranspose;
            this.transposeCol = transposeCol;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex.toString());
        }
    }

    public DataSheet(Applet applet, IResultSet data) {
        this(applet, data, false, null);
    }

    public DataSheet(Applet applet, IResultSet data, boolean doTranspose, int[] transposeColIdx) {
        try {
            ServerMessage.setApplet(applet);
            boolean[] transposeCol = TransposeRS.getTransposeColumn(transposeColIdx);
            if (doTranspose) {
                data = TransposeRS.doTranspose(data, transposeCol);
            }
            this.colData = data instanceof DbData ? ((DbData)data).getColData() : ColData.getColData(data);
            this.createColDataFail();
            this.source = null;
            this.doTranspose = doTranspose;
            this.transposeCol = transposeCol;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex.toString());
        }
    }

    public DataSheet(Applet applet, EJBInfo ejbInfo) {
        this(applet, ejbInfo, 0, -1);
    }

    public DataSheet(Applet applet, EJBInfo ejbInfo, int startIndex, int count) {
        try {
            ServerMessage.setApplet(applet);
            this.colData = EJBAccess.retrieveResult(ejbInfo.getJNDIName(), ejbInfo.getHomeName(), ejbInfo.getRemoteName(), ejbInfo.getSelectedMethodName(), ejbInfo.getSelectedMethodParamVal(), ejbInfo.getEnvironment());
            this.createColDataFail();
            this.source = ejbInfo;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex.toString());
        }
    }

    public DataSheet(Applet applet, SOAPQueryFileInfo soapInfo) {
        this(applet, soapInfo, 0, -1);
    }

    public DataSheet(Applet applet, SOAPQueryFileInfo soapInfo, int startIndex, int count) {
        try {
            ServerMessage.setApplet(applet);
            this.colData = SOAPAccess.retrieveResult(soapInfo);
            this.createColDataFail();
            this.source = soapInfo;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex.toString());
        }
    }

    public DataSheet(Applet applet, SalesForceQueryFileInfo sfQueryInfo) {
        this(applet, sfQueryInfo, 0, -1);
    }

    public DataSheet(Applet applet, SalesForceQueryFileInfo sfQueryInfo, int startIndex, int count) {
        try {
            ServerMessage.setApplet(applet);
            this.colData = SalesForceAccess.getColData(sfQueryInfo, startIndex, count);
            this.createColDataFail();
            this.source = sfQueryInfo;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex.toString());
        }
    }

    public DataSheet(Applet applet, ExcelFileInfo excelInfo) {
        this(applet, excelInfo, 0, -1);
    }

    public DataSheet(Applet applet, ExcelFileInfo excelInfo, int startIndex, int count) {
        try {
            ServerMessage.setApplet(applet);
            this.colData = ExcelAccess.getColData(excelInfo);
            this.createColDataFail();
            this.source = excelInfo;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex.toString());
        }
    }

    public DataSheet(Applet applet, IOLAPResultSet olapRS, String connectionString, String MDXQuery, String uri, String datasource, String catalog) {
        try {
            ServerMessage.setApplet(applet);
            OLAPAccess olapAccess = new OLAPAccess(olapRS, connectionString, MDXQuery, uri, datasource, catalog);
            this.colData = olapAccess.retrieveResult(0);
            this.createColDataFail();
            this.source = null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IllegalArgumentException(ex.toString());
        }
    }

    public DataSheet(Applet applet, XMLFileQueryInfo xmlInfo) {
        this(applet, xmlInfo, false, null);
    }

    public DataSheet(Applet applet, XMLFileQueryInfo xmlInfo, boolean doTranspose, int[] transposeColIdx) {
        this(applet, xmlInfo, doTranspose, transposeColIdx, 0, -1);
    }

    public DataSheet(Applet applet, XMLFileQueryInfo xmlInfo, boolean doTranspose, int[] transposeColIdx, int startIndex, int count) {
        try {
            ServerMessage.setApplet(applet);
            boolean[] transposeCol = TransposeRS.getTransposeColumn(transposeColIdx);
            this.colData = new DataFileInput().readProcessedData(xmlInfo.getFileName(), doTranspose, transposeCol, null, null, startIndex, count, xmlInfo, 7);
            this.createColDataFail();
            this.source = xmlInfo;
            this.doTranspose = doTranspose;
            this.transposeCol = transposeCol;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex.toString());
        }
    }

    public DataSheet(Applet applet, ISpreadSheetModel spreadSheet) {
        try {
            ServerMessage.setApplet(applet);
            this.colData = ColData.getColData(spreadSheet);
            this.createColDataFail();
            this.source = null;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex.toString());
        }
    }

    public DataSheet(Applet applet, ColData[] colData) {
        ServerMessage.setApplet(applet);
        this.colData = colData;
        this.source = null;
    }

    private void createColDataFail() throws Exception {
        if (this.colData == null || this.colData.length <= 0) {
            throw new Exception("Fail to create data sheet");
        }
    }

    public int getRowCount() {
        return this.colData[0].getSize();
    }

    public int getColumnCount() {
        return this.colData.length - 1;
    }

    public Object[] getRow(int no) {
        if (no >= this.colData[0].getSize()) {
            return null;
        }
        Object[] record = new Object[this.colData.length - 1];
        for (int i = 0; i < record.length; ++i) {
            record[i] = this.colData[i].getData(no);
        }
        return record;
    }

    public String[] getFieldNames() {
        if (this.colData == null) {
            return null;
        }
        String[] fieldNames = new String[this.colData.length - 1];
        for (int i = 0; i < this.colData.length - 1; ++i) {
            fieldNames[i] = this.colData[i].getName();
        }
        return fieldNames;
    }

    public int[] getOriginalDataTypes() {
        if (this.colData == null) {
            return null;
        }
        int[] dataTypes = new int[this.colData.length - 1];
        for (int i = 0; i < this.colData.length - 1; ++i) {
            dataTypes[i] = this.colData[i].getOriginalDataType();
        }
        return dataTypes;
    }

    public String[] getOriginalDataTypeNames() {
        int[] originalDataTypes = this.getOriginalDataTypes();
        String[] originalDataTypeNames = null;
        if (originalDataTypes != null) {
            originalDataTypeNames = new String[originalDataTypes.length];
            for (int i = 0; i < originalDataTypes.length; ++i) {
                originalDataTypeNames[i] = DataType.getTypeName(originalDataTypes[i]);
            }
        }
        return originalDataTypeNames;
    }

    public void addRow(Object[] record) {
        int nRow = this.getRowCount();
        int nCol = this.getColumnCount();
        if (record == null || record.length != nCol) {
            return;
        }
        for (int i = 0; i < record.length; ++i) {
            this.colData[i].add(record[i]);
            this.colData[i].bGenUniqueName = false;
        }
        int idx = nRow != 0 ? (Integer)this.colData[nCol].getData(nRow - 1) : -1;
        this.colData[nCol].add(idx + 1);
    }

    public void deleteRow(int no) {
        int nRow = this.getRowCount();
        int nCol = this.getColumnCount();
        if (no >= nRow || nRow == 0) {
            return;
        }
        for (int i = 0; i <= nCol; ++i) {
            this.colData[i].removeData(no);
            this.colData[i].bGenUniqueName = false;
        }
    }

    public void updateRow(Object[] record, int no) {
        if (no >= this.colData[0].getSize()) {
            return;
        }
        int nCol = this.getColumnCount();
        if (record == null || record.length != nCol) {
            return;
        }
        for (int i = 0; i < record.length; ++i) {
            this.colData[i].setData(no, record[i]);
            this.colData[i].bGenUniqueName = false;
        }
    }

    public void print(PrintStream out, int separator, int format) {
        ColData.print(out, this.colData, separator, format);
    }

    public ColData[] getColData() {
        return this.colData;
    }

    Object getSource() {
        return this.source;
    }

    int getSourceType() {
        if (this.source == null) {
            return 0;
        }
        if (this.source instanceof IDatabaseInfo) {
            return 1;
        }
        if (this.source instanceof XMLFileQueryInfo) {
            return 7;
        }
        if (this.source instanceof EJBInfo) {
            return 5;
        }
        if (this.dataFileType == 3) {
            return 6;
        }
        if (this.dataFileType == 2) {
            return 4;
        }
        if (this.dataFileType == 12) {
            return 12;
        }
        return 2;
    }

    boolean isTranspose() {
        return this.doTranspose;
    }

    int[] getTransposedColumn() {
        return TransposeRS.getTransposeIndex(this.transposeCol);
    }
}

