/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.ReportAPI;

import java.util.Vector;
import quadbase.reportdesigner.ReportElements.CBAggrColFooter;
import quadbase.reportdesigner.ReportElements.CBAggrColHeader;
import quadbase.reportdesigner.ReportElements.CBAggrColumn;
import quadbase.reportdesigner.ReportElements.CBColumnFooter;
import quadbase.reportdesigner.ReportElements.CBColumnHeader;
import quadbase.reportdesigner.ReportElements.ColumnBreakColumn;
import quadbase.reportdesigner.ReportElements.RBColumnHeader;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportColumn;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.ReportElements.ReportSection;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.report.Report;

public class FixedFieldCrossTabReport {
    Report report = null;

    public FixedFieldCrossTabReport(Report rpt) {
        this.report = rpt;
    }

    public int getColumnBreakCount() {
        return this.report.getColumnBreakCount();
    }

    public ColumnBreakColumn getColumnBreakColumnTemplate(int colBkValIdx) {
        return (ColumnBreakColumn)this.report.getReportTables().elementAt(0).getFirstColumnBreakColumn(colBkValIdx).clone();
    }

    public void setColumnBreakColumnStyle(ReportColumn col, int colBkValIdx) {
        ReportTable tbl = this.report.getReportTables().elementAt(0);
        for (int i = 0; i < tbl.getColumnCount(); ++i) {
            if (!(tbl.getColumn(i) instanceof ColumnBreakColumn) || ((ColumnBreakColumn)tbl.getColumn(i)).getColBreakValueIndex() != colBkValIdx) continue;
            double backupW = tbl.getColumn(i).getWidth();
            double backupH = tbl.getColumn(i).getHeight();
            tbl.getColumn(i).applyStyle(col);
            tbl.getColumn(i).setWidth(backupW);
            tbl.getColumn(i).setHeight(backupH);
            ReportElement.resizeForCrossTabFixedField(tbl.getColumn(i), tbl.getTableElementsNoGLWithSecuredMode(), col.getWidth(), col.getHeight());
        }
    }

    public void moveColumnBreakColumn(double dx, double dy, int colBkValIdx) {
        ReportTable tbl = this.report.getReportTables().elementAt(0);
        ColumnBreakColumn elt = tbl.getFirstColumnBreakColumn(colBkValIdx);
        if (dx != 0.0) {
            ReportElement.moveForCrossTabFixedField(elt, tbl.getTableElementsNoGLWithSecuredMode(), true, dx);
        }
        if (dy != 0.0) {
            ReportElement.moveForCrossTabFixedField(elt, tbl.getTableElementsNoGLWithSecuredMode(), false, dy);
        }
    }

    public ReportCell getCBColumnHeaderTemplate(ReportSection header, int colBkValIdx) {
        return ReportCell.clone(header.getFirstCBColumnHeader(colBkValIdx));
    }

    public void setCBColumnHeaderStyle(ReportSection sec, ReportCell header, int colBkValIdx) {
        ReportCell[] data;
        for (ReportCell element : data = sec.getData()) {
            if (!(element instanceof CBColumnHeader) || ((CBColumnHeader)element).getColBreakValueIndex() != colBkValIdx) continue;
            double backupW = element.getWidth();
            double backupH = element.getHeight();
            element.applyStyle(header);
            element.setWidth(backupW);
            element.setHeight(backupH);
            ReportElement.resizeForCrossTabFixedField(element, sec.cellsNoGLWithSecuredMode(), header.getWidth(), header.getHeight());
        }
    }

    public void moveCBColumnHeader(ReportSection sec, int colBkValIdx, double dx, double dy) {
        CBColumnHeader elt = sec.getFirstCBColumnHeader(colBkValIdx);
        if (dx != 0.0) {
            ReportElement.moveForCrossTabFixedField(elt, (ReportElement[])sec.cellsNoGLWithSecuredMode(), true, dx);
        }
        if (dy != 0.0) {
            ReportElement.moveForCrossTabFixedField(elt, (ReportElement[])sec.cellsNoGLWithSecuredMode(), false, dy);
        }
    }

    public ReportCell getNestedCBColumnHeaderTemplate(ReportSection header, int level) {
        return ReportCell.clone(header.getFirstRBColumnHeader(level));
    }

    public void setNestedCBColumnHeaderStyle(ReportSection sec, int level, ReportCell header) {
        ReportCell[] data;
        for (ReportCell element : data = sec.getData()) {
            if (!(element instanceof RBColumnHeader) || ((RBColumnHeader)element).getColBreakLevel() != level) continue;
            double backupW = element.getWidth();
            double backupH = element.getHeight();
            element.applyStyle(header);
            element.setWidth(backupW);
            element.setHeight(backupH);
            ReportElement.resizeForCrossTabFixedField(element, sec.cellsNoGLWithSecuredMode(), header.getWidth(), header.getHeight());
        }
    }

    public ReportCell getCBColumnFooterTemplate(int seclevel, int colBkValIdx) {
        if (this.report.isColumnAggregationInHeader()) {
            if (seclevel == 0) {
                return ReportCell.clone(this.report.getReportTables().elementAt(0).getHeader().getFirstCBColumnFooter(colBkValIdx));
            }
            return ReportCell.clone(this.report.getReportTables().elementAt(0).getRowBreakHeader(seclevel - 1).getFirstCBColumnFooter(colBkValIdx));
        }
        if (seclevel == 0) {
            return ReportCell.clone(this.report.getReportTables().elementAt(0).getFooter().getFirstCBColumnFooter(colBkValIdx));
        }
        return ReportCell.clone(this.report.getReportTables().elementAt(0).getRowBreakFooter(seclevel - 1).getFirstCBColumnFooter(colBkValIdx));
    }

    public void setCBColumnFooterStyle(int seclevel, ReportCell footer, int colBkValIdx) {
        ReportCell[] data;
        ReportSection sec = null;
        sec = this.report.isColumnAggregationInHeader() ? (seclevel == 0 ? this.report.getReportTables().elementAt(0).getHeader() : this.report.getReportTables().elementAt(0).getRowBreakHeader(seclevel - 1)) : (seclevel == 0 ? this.report.getReportTables().elementAt(0).getFooter() : this.report.getReportTables().elementAt(0).getRowBreakFooter(seclevel - 1));
        for (ReportCell element : data = sec.getData()) {
            if (!(element instanceof CBColumnFooter) || ((CBColumnFooter)element).getColBreakValueIndex() != colBkValIdx) continue;
            double backupW = element.getWidth();
            double backupH = element.getHeight();
            element.applyStyle(footer);
            element.setWidth(backupW);
            element.setHeight(backupH);
            ReportElement.resizeForCrossTabFixedField(element, sec.cellsNoGLWithSecuredMode(), footer.getWidth(), footer.getHeight());
        }
    }

    public void moveCBColumnFooter(int seclevel, int colBkValIdx, double dx, double dy) {
        ReportSection sec = null;
        sec = this.report.isColumnAggregationInHeader() ? (seclevel == 0 ? this.report.getReportTables().elementAt(0).getHeader() : this.report.getReportTables().elementAt(0).getRowBreakHeader(seclevel - 1)) : (seclevel == 0 ? this.report.getReportTables().elementAt(0).getFooter() : this.report.getReportTables().elementAt(0).getRowBreakFooter(seclevel - 1));
        ReportCell elt = sec.getFirstCBColumnFooter(colBkValIdx);
        if (dx != 0.0) {
            ReportElement.moveForCrossTabFixedField(elt, (ReportElement[])sec.cellsNoGLWithSecuredMode(), true, dx);
        }
        if (dy != 0.0) {
            ReportElement.moveForCrossTabFixedField(elt, (ReportElement[])sec.cellsNoGLWithSecuredMode(), false, dy);
        }
    }

    public ReportColumn getCBAggrColumnTemplate(int level, int colBkValIdx) {
        return (ReportColumn)this.report.getReportTables().elementAt(0).getFirstCBAggrColumn(level, colBkValIdx).clone();
    }

    public void setCBAggrColumnStyle(int level, ReportColumn col, int colBkValIdx) {
        ReportTable tbl = this.report.getReportTables().elementAt(0);
        for (int i = 0; i < tbl.getColumnCount(); ++i) {
            if (!(tbl.getColumn(i) instanceof CBAggrColumn) || ((CBAggrColumn)tbl.getColumn(i)).getColBreakLevel() != level || ((CBAggrColumn)tbl.getColumn(i)).getColBreakValueIndex() != colBkValIdx) continue;
            double backupW = tbl.getColumn(i).getWidth();
            double backupH = tbl.getColumn(i).getHeight();
            tbl.getColumn(i).applyStyle(col);
            tbl.getColumn(i).setWidth(backupW);
            tbl.getColumn(i).setHeight(backupH);
            ReportElement.resizeForCrossTabFixedField(tbl.getColumn(i), tbl.getTableElementsNoGLWithSecuredMode(), col.getWidth(), col.getHeight());
        }
    }

    public void moveCBAggrColumn(int level, int colBkValIdx, double dx, double dy) {
        ReportTable tbl = this.report.getReportTables().elementAt(0);
        CBAggrColumn elt = tbl.getFirstCBAggrColumn(level, colBkValIdx);
        if (dx != 0.0) {
            ReportElement.moveForCrossTabFixedField(elt, tbl.getTableElementsNoGLWithSecuredMode(), true, dx);
        }
        if (dy != 0.0) {
            ReportElement.moveForCrossTabFixedField(elt, tbl.getTableElementsNoGLWithSecuredMode(), false, dy);
        }
    }

    public ReportCell getCBAggrColHeaderTemplate(ReportSection header, int level, int colBkValIdx) {
        return ReportCell.clone(header.getFirstCBAggrColHeader(level, colBkValIdx));
    }

    public void setCBAggrColHeaderStyle(ReportSection sec, int level, ReportCell header, int colBkValIdx) {
        ReportCell[] data;
        for (ReportCell element : data = sec.getData()) {
            if (!(element instanceof CBAggrColHeader) || ((CBAggrColHeader)element).getColBreakLevel() != level || ((CBAggrColHeader)element).getColBreakValueIndex() != colBkValIdx) continue;
            double backupW = element.getWidth();
            double backupH = element.getHeight();
            element.applyStyle(header);
            element.setWidth(backupW);
            element.setHeight(backupH);
            ReportElement.resizeForCrossTabFixedField(element, sec.cellsNoGLWithSecuredMode(), header.getWidth(), header.getHeight());
        }
    }

    public void moveCBAggrColHeader(ReportSection sec, int level, int colBkValIdx, double dx, double dy) {
        CBColumnHeader elt = sec.getFirstCBColumnHeader(colBkValIdx);
        if (dx != 0.0) {
            ReportElement.moveForCrossTabFixedField(elt, (ReportElement[])sec.cellsNoGLWithSecuredMode(), true, dx);
        }
        if (dy != 0.0) {
            ReportElement.moveForCrossTabFixedField(elt, (ReportElement[])sec.cellsNoGLWithSecuredMode(), false, dy);
        }
    }

    public ReportCell getCBAggrColFooterTemplate(int level, int colBkValIdx, int seclevel) {
        ReportSection sec = null;
        sec = this.report.isColumnAggregationInHeader() ? (seclevel == 0 ? this.report.getReportTables().elementAt(0).getHeader() : this.report.getReportTables().elementAt(0).getRowBreakHeader(seclevel - 1)) : (seclevel == 0 ? this.report.getReportTables().elementAt(0).getFooter() : this.report.getReportTables().elementAt(0).getRowBreakFooter(seclevel - 1));
        return ReportCell.clone(sec.getFirstCBAggrColFooter(level, colBkValIdx));
    }

    public void setCBAggrColFooterStyle(int level, int seclevel, ReportCell footer, int colBkValIdx) {
        ReportCell[] data;
        ReportSection sec = null;
        sec = this.report.isColumnAggregationInHeader() ? (seclevel == 0 ? this.report.getReportTables().elementAt(0).getHeader() : this.report.getReportTables().elementAt(0).getRowBreakHeader(seclevel - 1)) : (seclevel == 0 ? this.report.getReportTables().elementAt(0).getFooter() : this.report.getReportTables().elementAt(0).getRowBreakFooter(seclevel - 1));
        for (ReportCell element : data = sec.getData()) {
            if (!(element instanceof CBAggrColFooter) || ((CBAggrColFooter)element).getColBreakLevel() != level || ((CBAggrColFooter)element).getColBreakValueIndex() != colBkValIdx) continue;
            double backupW = element.getWidth();
            double backupH = element.getHeight();
            element.applyStyle(footer);
            element.setWidth(backupW);
            element.setHeight(backupH);
            ReportElement.resizeForCrossTabFixedField(element, sec.cellsNoGLWithSecuredMode(), footer.getWidth(), footer.getHeight());
        }
    }

    public void moveCBAggrColFooter(int level, int colBkValIdx, int seclevel, double dx, double dy) {
        ReportSection sec = null;
        sec = this.report.isColumnAggregationInHeader() ? (seclevel == 0 ? this.report.getReportTables().elementAt(0).getHeader() : this.report.getReportTables().elementAt(0).getRowBreakHeader(seclevel - 1)) : (seclevel == 0 ? this.report.getReportTables().elementAt(0).getFooter() : this.report.getReportTables().elementAt(0).getRowBreakFooter(seclevel - 1));
        ReportCell elt = sec.getFirstCBAggrColFooter(level, colBkValIdx);
        if (dx != 0.0) {
            ReportElement.moveForCrossTabFixedField(elt, (ReportElement[])sec.cellsNoGLWithSecuredMode(), true, dx);
        }
        if (dy != 0.0) {
            ReportElement.moveForCrossTabFixedField(elt, (ReportElement[])sec.cellsNoGLWithSecuredMode(), false, dy);
        }
    }

    public ReportCell[] getHeaderData() {
        return this.report.getReportTables().elementAt(0).getHeader().getDataIgnoreRepeatCells();
    }

    public ReportCell[] getFooterData(int seclevel) {
        if (seclevel == 0) {
            return this.report.getReportTables().elementAt(0).getFooter().getDataIgnoreRepeatCells();
        }
        return this.report.getReportTables().elementAt(0).getRowBreakFooter(seclevel - 1).getDataIgnoreRepeatCells();
    }

    public ReportColumn[] getColumns() {
        Vector<ReportColumn> vec = this.report.getReportTables().elementAt(0).getColumnsIgnoreRepeatColumn();
        ReportColumn[] rcol = new ReportColumn[vec.size()];
        for (int i = 0; i < vec.size(); ++i) {
            rcol[i] = vec.elementAt(i);
        }
        return rcol;
    }
}

