/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.ReportAPI;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.ChartAPI.QbChart;
import quadbase.chart.Chart;
import quadbase.chart.ColData;
import quadbase.chart.LoadChart;
import quadbase.chart.SaveChart;
import quadbase.common.client.FileInfo;
import quadbase.common.client.ServerMessage;
import quadbase.common.param.HtmlParameterPageWriter;
import quadbase.common.param.OrderedParameterSet;
import quadbase.common.param.Param;
import quadbase.common.param.ParameterGrabber;
import quadbase.common.param.ParameterPage;
import quadbase.common.param.Parameters;
import quadbase.common.param.QueryParam;
import quadbase.common.paramquery.EnterParamDialog;
import quadbase.common.paramquery.QueryClassFileInfo;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.paramquery.QueryMultiValueInParam;
import quadbase.common.paramquery.QueryParser;
import quadbase.common.paramquery.QueryXMLFileInfo;
import quadbase.common.paramquery.SOAPQueryFileInfo;
import quadbase.common.paramquery.SalesForceQueryFileInfo;
import quadbase.common.util.IAlertable;
import quadbase.common.util.ICustomParameterDateFormat;
import quadbase.common.util.IDatabaseInfo;
import quadbase.common.util.IQueryFileInfo;
import quadbase.common.util.IQueryMultiValueInParam;
import quadbase.common.util.internal.ClassFileUtil;
import quadbase.common.util.internal.CloseUtils;
import quadbase.common.util.internal.CopyFile;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.EJBInfo;
import quadbase.common.util.internal.ExcelFileInfo;
import quadbase.common.util.internal.FileInMemTable;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.LCKey;
import quadbase.common.util.internal.QbConnection;
import quadbase.common.util.internal.QbDebug;
import quadbase.common.util.internal.QbUtil;
import quadbase.common.util.internal.XMLFileQueryInfo;
import quadbase.datasource.util.QueryInParam;
import quadbase.reportdesigner.ReportAPI.ChartObject;
import quadbase.reportdesigner.ReportAPI.DBInfo;
import quadbase.reportdesigner.ReportAPI.DataSheet;
import quadbase.reportdesigner.ReportAPI.DbData;
import quadbase.reportdesigner.ReportAPI.DrillDownReport;
import quadbase.reportdesigner.ReportAPI.FixedFieldCrossTabReport;
import quadbase.reportdesigner.ReportAPI.SubReport;
import quadbase.reportdesigner.ReportElements.ColumnWrap;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportChartObject;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.ReportElements.ReportImage;
import quadbase.reportdesigner.ReportElements.ReportSection;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.ReportElements.ReportTableElement;
import quadbase.reportdesigner.ReportElements.SubReportObject;
import quadbase.reportdesigner.ReportElements.TableOfContents;
import quadbase.reportdesigner.report.DBAccess;
import quadbase.reportdesigner.report.DHTMLReport;
import quadbase.reportdesigner.report.DataFileInput;
import quadbase.reportdesigner.report.DrillDownNode;
import quadbase.reportdesigner.report.EJBAccess;
import quadbase.reportdesigner.report.ExcelAccess;
import quadbase.reportdesigner.report.Formula;
import quadbase.reportdesigner.report.ImportFontMapping;
import quadbase.reportdesigner.report.LoadReport;
import quadbase.reportdesigner.report.LoadXMLReport;
import quadbase.reportdesigner.report.NewFormulaParser;
import quadbase.reportdesigner.report.NewScriptParser;
import quadbase.reportdesigner.report.OLAPAccess;
import quadbase.reportdesigner.report.PDFReport;
import quadbase.reportdesigner.report.PageReport;
import quadbase.reportdesigner.report.Parameter;
import quadbase.reportdesigner.report.PrintReport;
import quadbase.reportdesigner.report.PrintUtil;
import quadbase.reportdesigner.report.ReloadReport;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.ReportMultiSectionTable;
import quadbase.reportdesigner.report.ReportUI;
import quadbase.reportdesigner.report.SOAPAccess;
import quadbase.reportdesigner.report.SalesForceAccess;
import quadbase.reportdesigner.report.SaveReport;
import quadbase.reportdesigner.report.Script;
import quadbase.reportdesigner.report.TransformQuery;
import quadbase.reportdesigner.util.ColInfo;
import quadbase.reportdesigner.util.IChart;
import quadbase.reportdesigner.util.IChartModifier;
import quadbase.reportdesigner.util.ICustomDefinedFunctions;
import quadbase.reportdesigner.util.IDynamicImageURLGenerator;
import quadbase.reportdesigner.util.IDynamicReportKeyGenerator;
import quadbase.reportdesigner.util.IExportConstants;
import quadbase.reportdesigner.util.IExportThreadListener;
import quadbase.reportdesigner.util.IHTMLLinksProvider;
import quadbase.reportdesigner.util.IInputData;
import quadbase.reportdesigner.util.IOLAPResultSet;
import quadbase.reportdesigner.util.IQbQueryFileInfo;
import quadbase.reportdesigner.util.IReport;
import quadbase.reportdesigner.util.IReportPropertiesConstants;
import quadbase.reportdesigner.util.IReportTypeConstants;
import quadbase.reportdesigner.util.IResultSet;
import quadbase.reportdesigner.util.IRow;
import quadbase.reportdesigner.util.ISpreadSheetModel;
import quadbase.reportdesigner.util.ISpreadSheetModelListener;
import quadbase.reportdesigner.util.IStringCustomizer;
import quadbase.reportdesigner.util.ISubReport;
import quadbase.reportdesigner.util.ReplaceColumnInfoList;
import quadbase.reportdesigner.util.SimpleQueryFileInfo;
import quadbase.reportdesigner.util.SpreadSheetModelEvent;
import quadbase.reportdesigner.util.internal.ReportUtil;
import quadbase.reportdesigner.util.internal.TransposeRS;
import quadbase.util.IQueryInParam;

public class QbReport
implements IReportTypeConstants,
IExportConstants,
IReportPropertiesConstants,
IReport,
IAlertable {
    public static final int DATABASESOURCE = 1;
    public static final int DATAFILESOURCE = 2;
    public static final int QUADBASEXMLFILESOURCE = 4;
    public static final int CLASSFILESOURCE = 6;
    public static final int XMLFILEQUERYSOURCE = 7;
    public static final int EJBSOURCE = 5;
    public static final int MEMORYDATASOURCE = 0;
    public static final int SOAPDATASOURCE = 12;
    public static final int SALESFORCESOURCE = 11;
    public static final int EXCELSOURCE = 13;
    public static final int MULTIPLEDATASOURCES = 3;
    public static final int DATAFILE = 0;
    public static final int QUERYFILE = 1;
    public static final int XMLFILE = 2;
    public static final int CLASSFILE = 3;
    public static final int OLAPRESULTSET = 10;
    public static final int PORTRAIT = 0;
    public static final int LANDSCAPE = 1;
    public static final int PLAIN = 0;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    public static final int BOLDITALIC = 3;
    private static final Logger LOGGER = Logger.getLogger(QbReport.class.getName());
    private static boolean oneShotExport = false;
    private static boolean exportToMultiPages = false;
    public Report report;
    protected Vector<SubReportObject> subReports = null;
    String subReportPath;
    String drilldownPath;
    String chartPath;
    String imagePath;
    private String errorMessage;
    private ISpreadSheetModel spreadSheet;
    private ISpreadSheetModelListener spreadSheetListener;
    private DrillDownNode root = null;
    private Object[] colValue = null;
    private boolean optimizeMemory;
    private boolean isTransposed;
    private boolean[] transposeCol;
    private String filename;
    private boolean promptForParamValue = true;
    private boolean isEnterpriseServer = true;
    private boolean[] selectAllInfo;
    private boolean[] needUpdate;

    public QbReport() {
        Report report = new Report();
        this.initDrillDownTree(report, null);
        this.setSubReports(report, new Vector<SubReportObject>());
    }

    public QbReport(Object parent, byte[] reportData) {
        this(parent, reportData, oneShotExport);
    }

    public QbReport(QbReport qbreport) {
        this(qbreport, false);
    }

    public QbReport(QbReport qbreport, boolean reUseTable) {
        if (qbreport == null) {
            throw new IllegalArgumentException("Null report object");
        }
        try {
            this.report = new Report(reUseTable, qbreport.report);
            this.root = qbreport.root;
            this.subReports = qbreport.subReports;
            this.report.subReports = this.subReports;
        }
        catch (Exception ex) {
            this.errorMessage = IOUtil.getStackTrace(ex);
            throw new IllegalArgumentException(this.errorMessage);
        }
        if (this.report == null) {
            throw new IllegalArgumentException("Cannot Create Report");
        }
    }

    public QbReport(Object parent, byte[] reportData, boolean optimizeMemory) {
        this(parent, reportData, optimizeMemory, oneShotExport);
    }

    public QbReport(Object parent, byte[] reportData, boolean optimizeMemory, boolean multiPageExp) {
        Properties props = new Properties();
        if (ServerMessage.performOptimizeMemory(optimizeMemory)) {
            props.put("optimize memory", "true");
        }
        if (multiPageExp) {
            props.put("multi-page export", "true");
        }
        this.qbReportHelper(parent, reportData, null, props);
    }

    public QbReport(Object parent, byte[] reportData, Properties props) {
        this.qbReportHelper(parent, reportData, null, props);
    }

    public QbReport(Object parent, byte[] reportData, Object[] parameters, Properties props) {
        this.qbReportHelper(parent, reportData, parameters, props);
    }

    public QbReport(Object parent, byte[] reportData, Object[] parameters, Properties props, Hashtable<String, byte[]> rptTable) {
        this.qbReportHelper(parent, reportData, parameters, props, rptTable);
    }

    public QbReport(Object parent, int reportType, XMLFileQueryInfo xmlInfo, ColInfo[] mapping, String template, boolean sideBySideLayout) {
        Properties props = new Properties();
        if (sideBySideLayout) {
            props.put("side by side layout", "true");
        }
        this.qbReportHelper(parent, reportType, xmlInfo, mapping, template, props);
    }

    public QbReport(Object parent, int reportType, XMLFileQueryInfo xmlInfo, ColInfo[] mapping, String template, Properties props) {
        this.qbReportHelper(parent, reportType, xmlInfo, mapping, template, props);
    }

    public QbReport(Object parent, int reportType, EJBInfo ejbInfo, ColInfo[] mapping, String template) {
        this(parent, reportType, ejbInfo.getJNDIName(), ejbInfo.getHomeName(), ejbInfo.getRemoteName(), ejbInfo.getSelectedMethodName(), ejbInfo.getSelectedMethodParamVal(), ejbInfo.getEnvironment(), mapping, template);
    }

    public QbReport(Object parent, int reportType, String jndiName, String homeName, String remoteName, String selectedMethodName, Object[] selectedMethodParamVal, ColInfo[] mapping, String template) {
        this(parent, reportType, jndiName, homeName, remoteName, selectedMethodName, selectedMethodParamVal, null, mapping, template);
    }

    public QbReport(Object parent, int reportType, String jndiName, String homeName, String remoteName, String selectedMethodName, Object[] selectedMethodParamVal, Hashtable<String, String> environment, ColInfo[] mapping, String template) {
        this(parent, reportType, jndiName, homeName, remoteName, selectedMethodName, selectedMethodParamVal, environment, mapping, template, null);
    }

    public QbReport(Object parent, int reportType, String jndiName, String homeName, String remoteName, String selectedMethodName, Object[] selectedMethodParamVal, Hashtable<String, String> environment, ColInfo[] mapping, String template, Properties props) {
        quadbase.reportdesigner.report.ColData[] colData;
        Object[] pr = this.parseProperties(props);
        boolean sideBySideLayout = (Boolean)pr[0];
        boolean multiPageExp = (Boolean)pr[2];
        boolean sorteddata = (Boolean)pr[3];
        boolean generateCrossTabGrandTotalColumn = (Boolean)pr[8];
        boolean crossTabFreeForm = (Boolean)pr[13];
        Properties oprops = new Properties();
        oprops.setProperty("crossTabFreeForm", crossTabFreeForm + "");
        oprops.setProperty("crossTabSummaryPositionL", "true");
        oprops.setProperty("crossTabFormulaInHeader", "false");
        ServerMessage.setParent(parent);
        try {
            if (mapping == null) {
                mapping = LoadReport.getColInfo(template);
            }
            colData = EJBAccess.retrieveResult(jndiName, homeName, remoteName, selectedMethodName, selectedMethodParamVal, environment);
        }
        catch (Exception ex) {
            this.errorMessage = IOUtil.getStackTrace(ex);
            throw new IllegalArgumentException(this.errorMessage);
        }
        if (colData == null) {
            throw new IllegalArgumentException("Cannot Create Report");
        }
        this.createReport(reportType, colData, mapping, template, sorteddata, sideBySideLayout, false, generateCrossTabGrandTotalColumn, null, null, oprops);
        if (this.report == null) {
            throw new IllegalArgumentException("Cannot Create Report");
        }
        this.report.setExportToMultiPages(multiPageExp);
        this.report.sourceData = 5;
        this.report.jndiName = jndiName;
        this.report.homeName = homeName;
        this.report.remoteName = remoteName;
        this.report.selectedMethodName = selectedMethodName;
        this.report.selectedMethodParamVal = selectedMethodParamVal;
        this.report.environment = environment;
    }

    public QbReport(Object parent, int reportType, SOAPQueryFileInfo soapInfo, ColInfo[] mapping, String template, Properties props) {
        quadbase.reportdesigner.report.ColData[] colData;
        Object[] pr = this.parseProperties(props);
        boolean sideBySideLayout = (Boolean)pr[0];
        boolean multiPageExp = (Boolean)pr[2];
        boolean sorteddata = (Boolean)pr[3];
        boolean promptParam = (Boolean)pr[7];
        boolean generateCrossTabGrandTotalColumn = (Boolean)pr[8];
        boolean crossTabFreeForm = (Boolean)pr[13];
        if (promptParam && soapInfo.isParameterized()) {
            try {
                QueryFileInfo.getParameter(soapInfo, false, false, true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Properties oprops = new Properties();
        oprops.setProperty("crossTabFreeForm", crossTabFreeForm + "");
        oprops.setProperty("crossTabSummaryPositionL", "true");
        oprops.setProperty("crossTabFormulaInHeader", "false");
        ServerMessage.setParent(parent);
        try {
            if (mapping == null) {
                mapping = LoadReport.getColInfo(template);
            }
            colData = SOAPAccess.retrieveResult(soapInfo);
        }
        catch (Exception ex) {
            this.errorMessage = IOUtil.getStackTrace(ex);
            throw new IllegalArgumentException(this.errorMessage);
        }
        if (colData == null) {
            throw new IllegalArgumentException("Cannot Create Report");
        }
        this.createReport(reportType, colData, mapping, template, sorteddata, sideBySideLayout, false, generateCrossTabGrandTotalColumn, null, null, oprops);
        if (this.report != null) {
            this.report.setExportToMultiPages(multiPageExp);
            this.report.sourceData = 12;
            this.report.soapInfo = soapInfo;
            if (soapInfo.isParameterized()) {
                this.report.dbInfo = soapInfo;
            }
        } else {
            throw new IllegalArgumentException("Cannot Create Report");
        }
    }

    public QbReport(Object parent, int reportType, SalesForceQueryFileInfo sfQueryInfo, ColInfo[] mapping, String template, Properties props) {
        quadbase.reportdesigner.report.ColData[] colData;
        Object[] pr = this.parseProperties(props);
        boolean sideBySideLayout = (Boolean)pr[0];
        boolean multiPageExp = (Boolean)pr[2];
        boolean sorteddata = (Boolean)pr[3];
        boolean promptParam = (Boolean)pr[7];
        boolean generateCrossTabGrandTotalColumn = (Boolean)pr[8];
        boolean crossTabFreeForm = (Boolean)pr[13];
        if (promptParam && sfQueryInfo.getInParam() != null) {
            try {
                QueryFileInfo.getParameter(sfQueryInfo, false, false, true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Properties oprops = new Properties();
        oprops.setProperty("crossTabFreeForm", crossTabFreeForm + "");
        oprops.setProperty("crossTabSummaryPositionL", "true");
        oprops.setProperty("crossTabFormulaInHeader", "false");
        ServerMessage.setParent(parent);
        try {
            if (mapping == null) {
                mapping = LoadReport.getColInfo(template);
            }
            colData = SalesForceAccess.getColData(sfQueryInfo);
        }
        catch (Exception ex) {
            this.errorMessage = IOUtil.getStackTrace(ex);
            throw new IllegalArgumentException(this.errorMessage);
        }
        if (colData == null) {
            throw new IllegalArgumentException("Cannot Create Report");
        }
        this.createReport(reportType, colData, mapping, template, sorteddata, sideBySideLayout, false, generateCrossTabGrandTotalColumn, null, null, oprops);
        if (this.report != null) {
            this.report.setExportToMultiPages(multiPageExp);
            this.report.sourceData = 11;
            this.report.sfQueryInfo = sfQueryInfo;
            if (sfQueryInfo.isParameterized()) {
                this.report.dbInfo = sfQueryInfo;
            }
        } else {
            throw new IllegalArgumentException("Cannot Create Report");
        }
    }

    public QbReport(Object parent, int reportType, ExcelFileInfo excelInfo, ColInfo[] mapping, String template, Properties props) {
        quadbase.reportdesigner.report.ColData[] colData;
        Object[] pr = this.parseProperties(props);
        boolean sideBySideLayout = (Boolean)pr[0];
        boolean multiPageExp = (Boolean)pr[2];
        boolean sorteddata = (Boolean)pr[3];
        boolean generateCrossTabGrandTotalColumn = (Boolean)pr[8];
        boolean crossTabFreeForm = (Boolean)pr[13];
        Properties oprops = new Properties();
        oprops.setProperty("crossTabFreeForm", crossTabFreeForm + "");
        oprops.setProperty("crossTabSummaryPositionL", "true");
        oprops.setProperty("crossTabFormulaInHeader", "false");
        ServerMessage.setParent(parent);
        try {
            if (mapping == null) {
                mapping = LoadReport.getColInfo(template);
            }
            colData = ExcelAccess.getColData(excelInfo);
        }
        catch (Exception ex) {
            this.errorMessage = IOUtil.getStackTrace(ex);
            throw new IllegalArgumentException(this.errorMessage);
        }
        if (colData == null) {
            throw new IllegalArgumentException("Cannot Create Report");
        }
        this.createReport(reportType, colData, mapping, template, sorteddata, sideBySideLayout, false, generateCrossTabGrandTotalColumn, null, null, oprops);
        if (this.report == null) {
            throw new IllegalArgumentException("Cannot Create Report");
        }
        this.report.setExportToMultiPages(multiPageExp);
        this.report.sourceData = 13;
        this.report.excelInfo = excelInfo;
    }

    public QbReport(Object parent, String fileName) {
        this(parent, fileName, false);
    }

    public QbReport(Object parent, String fileName, boolean isEnterpriseServer) {
        this(parent, fileName, isEnterpriseServer, oneShotExport);
    }

    public QbReport(Object parent, String fileName, boolean isEnterpriseServer, boolean optimizeMemory) {
        this(parent, fileName, isEnterpriseServer, optimizeMemory, exportToMultiPages);
    }

    public QbReport(Object parent, String fileName, boolean isEnterpriseServer, boolean optimizeMemory, boolean multiPageExp) {
        this(parent, fileName, isEnterpriseServer, optimizeMemory, exportToMultiPages, false);
    }

    public QbReport(Object parent, String fileName, boolean isEnterpriseServer, boolean optimizeMemory, boolean multiPageExp, boolean useBackupData) {
        this(parent, fileName, isEnterpriseServer, optimizeMemory, exportToMultiPages, useBackupData, true);
    }

    public QbReport(Object parent, String fileName, boolean isEnterpriseServer, boolean optimizeMemory, boolean multiPageExp, boolean useBackupData, boolean promptParamValue) {
        this(parent, fileName, isEnterpriseServer, optimizeMemory, multiPageExp, useBackupData, promptParamValue, null);
    }

    public QbReport(Object parent, String fileName, boolean isEnterpriseServer, boolean optimizeMemory, boolean multiPageExp, boolean useBackupData, boolean promptParamValue, String relativeDomainPath) {
        Properties props = new Properties();
        if (isEnterpriseServer) {
            props.put("enterprise server", "true");
        }
        if (ServerMessage.performOptimizeMemory(optimizeMemory)) {
            props.put("optimize memory", "true");
        }
        if (multiPageExp) {
            props.put("multi-page export", "true");
        }
        if (useBackupData) {
            props.put("use backup data", "true");
        }
        if (promptParamValue) {
            props.put("prompt parameter", "true");
        } else {
            props.put("prompt parameter", "false");
        }
        if (relativeDomainPath != null && relativeDomainPath.length() > 0) {
            props.put("relative domain path", relativeDomainPath);
        }
        this.qbReportHelper(parent, fileName, null, null, props);
    }

    public QbReport(Object parent, String fileName, Object[] parameters) {
        this(parent, fileName, parameters, null, null);
    }

    public QbReport(Object parent, String fileName, Object[] queryParameters, Object[] formulaParameters) {
        this(parent, fileName, queryParameters, formulaParameters, null);
    }

    public QbReport(Object parent, String fileName, Properties props) {
        this(parent, fileName, (Object[])null, (Object[])null, props);
    }

    public QbReport(Object parent, String fileName, Object[] queryParameters, Object[] formulaParameters, Properties props) {
        this.qbReportHelper(parent, fileName, queryParameters, formulaParameters, props);
    }

    public QbReport(Object parent, String fileName, Object req) {
        this(parent, fileName, null, req);
    }

    public QbReport(Object parent, String fileName, Object req, int order, Object[] paramValues) {
        this(parent, fileName, null, req, order, paramValues, (DrillDownNode)null);
    }

    public QbReport(Object parent, String fileName, Object req, int order, Object[] paramValues, DrillDownNode node) {
        this(parent, fileName, null, req, order, paramValues, node);
    }

    public QbReport(Object parent, String fileName, byte[] reportData, Object req) {
        this(parent, fileName, reportData, req, null);
    }

    public QbReport(Object parent, String fileName, byte[] reportData, Object req, int order, Object[] paramValues) {
        this(parent, fileName, reportData, req, null, order, paramValues);
    }

    public QbReport(Object parent, String fileName, byte[] reportData, Object req, int order, Object[] paramValues, DrillDownNode node) {
        this(parent, fileName, reportData, req, null, order, paramValues, node);
    }

    public QbReport(Object parent, String fileName, byte[] reportData, Object req, Hashtable<String, byte[]> rptTable) {
        this(parent, fileName, reportData, req, rptTable, -1, null);
    }

    public QbReport(Object parent, String fileName, byte[] reportData, Object req, Hashtable<String, byte[]> rptTable, int order, Object[] paramValues) {
        this(parent, fileName, reportData, req, rptTable, order, paramValues, null);
    }

    public QbReport(Object parent, String fileName, byte[] reportData, Object req, Hashtable<String, byte[]> rptTable, int order, Object[] paramValues, DrillDownNode node) {
        Object[] paramValueArr = this.getParamInput(req);
        ServerMessage.setParent(parent);
        try {
            this.promptForParamValue = false;
            String securityLevel = this.getSecurityLevel(req);
            this.report = reportData != null && rptTable != null ? this.loadReportFromByteArray(reportData, null, null, true, false, true, securityLevel, rptTable) : this.loadReportFromFile(fileName, null, null, true, false, true, securityLevel, null, null);
            if (node != null) {
                this.report.currentNode = node;
            }
            int ct = 0;
            OrderedParameterSet allPromptParams = this.getReportObj().getParametersInSequence();
            for (int i = 0; i < order; ++i) {
                Parameters parameters = allPromptParams.getParamsAt(i);
                this.report.setPreviewSecurityLevel(null);
                Parameters allParams = this.getReportObj().getParametersInSequence().getParamsAt(i);
                Object[] paramValue = new Object[allParams.size()];
                for (int j = 0; j < paramValue.length; ++j) {
                    paramValue[j] = paramValues[j + ct];
                }
                ct += paramValue.length;
                this.setParameterValues(parameters, allParams, paramValue, false);
            }
            Parameters parameters = allPromptParams;
            if (order > -1) {
                parameters = allPromptParams.getParamsAt(order);
            }
            this.report.setPreviewSecurityLevel(null);
            Parameters allParams = this.getReportObj().getParametersInSequence();
            if (order > -1) {
                allParams = allParams.getParamsAt(order);
            }
            this.setParameterValues(parameters, allParams, paramValueArr);
            this.report.setPreviewSecurityLevel(securityLevel);
        }
        catch (Exception ex) {
            this.errorMessage = IOUtil.getStackTrace(ex);
            throw new IllegalArgumentException(this.errorMessage);
        }
        if (this.report == null) {
            throw new IllegalArgumentException("Cannot Create Report");
        }
    }

    public QbReport(Object parent, int reportType, quadbase.reportdesigner.util.IDatabaseInfo dbinfo, ColInfo[] mapping, String template) {
        this(parent, reportType, dbinfo, mapping, template, false);
    }

    public QbReport(Object parent, int reportType, quadbase.reportdesigner.util.IDatabaseInfo dbinfo, ColInfo[] mapping, String template, boolean sideBySideLayout) {
        this(parent, reportType, dbinfo, mapping, template, false, QbReport.isForExportOnly());
    }

    @Deprecated
    public QbReport(Object parent, int reportType, quadbase.reportdesigner.util.IDatabaseInfo dbinfo, ColInfo[] mapping, String template, boolean sideBySideLayout, boolean optimizeMemory) {
        this(parent, reportType, dbinfo, mapping, template, false, optimizeMemory, exportToMultiPages);
    }

    public QbReport(Object parent, int reportType, quadbase.reportdesigner.util.IDatabaseInfo dbinfo, ColInfo[] mapping, String template, Properties props) {
        this.qbReportHelper(parent, reportType, dbinfo, mapping, template, props);
    }

    public QbReport(Object parent, int reportType, quadbase.reportdesigner.util.IDatabaseInfo dbinfo, ColInfo[] mapping, String template, boolean sideBySideLayout, boolean optimizeMemory, boolean multiPageExp) {
        Properties props = new Properties();
        if (sideBySideLayout) {
            props.put("side by side layout", "true");
        }
        if (ServerMessage.performOptimizeMemory(optimizeMemory)) {
            props.put("optimize memory", "true");
        }
        if (multiPageExp) {
            props.put("multi-page export", "true");
        }
        this.qbReportHelper(parent, reportType, dbinfo, mapping, template, props);
    }

    public QbReport(Object parent, int reportType, String dataFile, ColInfo[] mapping, String template) {
        this(parent, reportType, dataFile, mapping, template, false);
    }

    public QbReport(Object parent, int reportType, String dataFile, ColInfo[] mapping, String template, boolean sideBySideLayout) {
        this(parent, reportType, 0, dataFile, mapping, template, sideBySideLayout);
    }

    public QbReport(Object parent, int reportType, int fileType, String filename, ColInfo[] mapping, String template) {
        this(parent, reportType, fileType, filename, mapping, template, false);
    }

    public QbReport(Object parent, int reportType, int fileType, String filename, ColInfo[] mapping, String template, boolean sideBySideLayout) {
        Properties props = new Properties();
        if (sideBySideLayout) {
            props.put("side by side layout", "true");
        }
        this.qbReportHelper(parent, reportType, fileType, filename, mapping, template, props, null, null, null, null, null, null, (short)0, null, null);
    }

    public QbReport(Object parent, int reportType, int fileType, String filename, ColInfo[] mapping, String template, Properties props) {
        this.qbReportHelper(parent, reportType, fileType, filename, mapping, template, props, null, null, null, null, null, null, (short)0, null, null);
    }

    public QbReport(Object parent, int reportType, String connectionString, String MDXQuery, String template, Properties props, short aggrValForValueCol) {
        if (reportType != 2 && reportType != 1 && reportType != 0) {
            throw new IllegalArgumentException("Illegal report type");
        }
        this.qbReportHelper(parent, reportType, 10, null, null, template, props, null, connectionString, MDXQuery, null, null, null, aggrValForValueCol, null, null);
    }

    public QbReport(Object parent, int reportType, String uri, String datasource, String catalog, String MDXQuery, String template, Properties props, short aggrValForValueCol) {
        if (reportType != 2 && reportType != 1 && reportType != 0) {
            throw new IllegalArgumentException("Illegal report type");
        }
        this.qbReportHelper(parent, reportType, 10, null, null, template, props, null, null, MDXQuery, uri, datasource, catalog, aggrValForValueCol, null, null);
    }

    public QbReport(Object parent, int reportType, IOLAPResultSet olapRS, String template, Properties props, short aggrValForValueCol) {
        if (reportType != 2 && reportType != 1 && reportType != 0) {
            throw new IllegalArgumentException("Illegal report type");
        }
        this.qbReportHelper(parent, reportType, 10, null, null, template, props, olapRS, null, null, null, null, null, aggrValForValueCol, null, null);
    }

    public QbReport(Object parent, int reportType, String connectionString, String MDXQuery, String template, Properties props, short aggrValForValueCol, boolean[] rowBreakAggrIncluded, boolean[] colBreakAggrIncluded) {
        if (reportType != 2 && reportType != 1 && reportType != 0) {
            throw new IllegalArgumentException("Illegal report type");
        }
        this.qbReportHelper(parent, reportType, 10, null, null, template, props, null, connectionString, MDXQuery, null, null, null, aggrValForValueCol, rowBreakAggrIncluded, colBreakAggrIncluded);
    }

    public QbReport(Object parent, int reportType, String uri, String datasource, String catalog, String MDXQuery, String template, Properties props, short aggrValForValueCol, boolean[] rowBreakAggrIncluded, boolean[] colBreakAggrIncluded) {
        if (reportType != 2 && reportType != 1 && reportType != 0) {
            throw new IllegalArgumentException("Illegal report type");
        }
        this.qbReportHelper(parent, reportType, 10, null, null, template, props, null, null, MDXQuery, uri, datasource, catalog, aggrValForValueCol, rowBreakAggrIncluded, colBreakAggrIncluded);
    }

    public QbReport(Object parent, int reportType, IOLAPResultSet olapRS, String template, Properties props, short aggrValForValueCol, boolean[] rowBreakAggrIncluded, boolean[] colBreakAggrIncluded) {
        if (reportType != 2 && reportType != 1 && reportType != 0) {
            throw new IllegalArgumentException("Illegal report type");
        }
        this.qbReportHelper(parent, reportType, 10, null, null, template, props, olapRS, null, null, null, null, null, aggrValForValueCol, rowBreakAggrIncluded, colBreakAggrIncluded);
    }

    public QbReport(Object parent, int reportType, IResultSet data, ColInfo[] mapping, String template) {
        this(parent, reportType, data, mapping, template, false);
    }

    public QbReport(Object parent, int reportType, IResultSet data, ColInfo[] mapping, String template, boolean sideBySideLayout) {
        this(parent, reportType, data, mapping, template, sideBySideLayout, false);
    }

    public QbReport(Object parent, int reportType, IResultSet data, ColInfo[] mapping, String template, boolean sideBySideLayout, boolean isDataSorted) {
        this(parent, reportType, data, mapping, template, sideBySideLayout, isDataSorted, false);
    }

    public QbReport(Object parent, int reportType, IResultSet data, ColInfo[] mapping, String template, boolean sideBySideLayout, boolean isDataSorted, boolean optimizeMemory) {
        Properties props = new Properties();
        if (sideBySideLayout) {
            props.put("side by side layout", "true");
        }
        if (isDataSorted) {
            props.put("data sorted", "true");
        }
        if (ServerMessage.performOptimizeMemory(optimizeMemory)) {
            props.put("optimize memory", "true");
        }
        this.qbReportHelper(parent, reportType, data, mapping, template, props, null);
    }

    public QbReport(Object parent, int reportType, IResultSet data, ColInfo[] mapping, String template, boolean sideBySideLayout, boolean isDataSorted, boolean optimizeMemory, Object[] distinctValue) {
        Properties props = new Properties();
        if (sideBySideLayout) {
            props.put("side by side layout", "true");
        }
        if (isDataSorted) {
            props.put("data sorted", "true");
        }
        if (ServerMessage.performOptimizeMemory(optimizeMemory)) {
            props.put("optimize memory", "true");
        }
        this.qbReportHelper(parent, reportType, data, mapping, template, props, distinctValue);
    }

    public QbReport(Object parent, int reportType, IResultSet data, ColInfo[] mapping, String template, Properties props) {
        this.qbReportHelper(parent, reportType, data, mapping, template, props, null);
    }

    public QbReport(Object parent, int reportType, IResultSet data, ColInfo[] mapping, String template, Properties props, Object[] distinctValue) {
        this.qbReportHelper(parent, reportType, data, mapping, template, props, distinctValue);
    }

    public QbReport(Object parent, int reportType, ISpreadSheetModel sheet, ColInfo[] mapping, String template) {
        this(parent, reportType, sheet, mapping, template, false);
    }

    public QbReport(Object parent, int reportType, ISpreadSheetModel sheet, ColInfo[] mapping, String template, boolean sideBySideLayout) {
        Properties props = new Properties();
        if (sideBySideLayout) {
            props.put("side by side layout", "true");
        }
        this.qbReportHelper(parent, reportType, sheet, mapping, template, props);
    }

    public QbReport(Object parent, int reportType, ISpreadSheetModel sheet, ColInfo[] mapping, String template, Properties props) {
        this.qbReportHelper(parent, reportType, sheet, mapping, template, props);
    }

    public QbReport(Object parent, int reportType, DataSheet[] dataSheet, ColInfo[] mapping, String template) {
        this(parent, reportType, dataSheet, mapping, template, false);
    }

    public QbReport(Object parent, int reportType, DataSheet[] dataSheet, ColInfo[] mapping, String template, boolean sideBySideLayout) {
        Properties props = new Properties();
        if (sideBySideLayout) {
            props.put("side by side layout", "true");
        }
        this.qbReportHelper(parent, reportType, dataSheet, mapping, template, props);
    }

    public QbReport(Object parent, int reportType, DataSheet[] dataSheet, ColInfo[] mapping, String template, Properties props) {
        this.qbReportHelper(parent, reportType, dataSheet, mapping, template, props);
    }

    protected QbReport(Report r) {
        this.report = r;
    }

    public static final void setDebugMode(int mode) {
        QbDebug.setDebugMode(mode);
    }

    public static final void setDebugMode(String mode) {
        QbDebug.setDebugMode(mode);
    }

    @Deprecated
    public static boolean isForExportOnly() {
        return oneShotExport;
    }

    @Deprecated
    public static void setForExportOnly(boolean state) {
        oneShotExport = state;
    }

    public static int getInputDataBlockSize() {
        return Report.getInputDataBlockSize();
    }

    public static void setInputDataBlockSize(int val) {
        Report.setInputDataBlockSize(val);
    }

    public static int getMaxRecordInMemory() {
        return ServerMessage.getPagingThreshold();
    }

    public static void setMaxRecordInMemory(int r) {
        ServerMessage.setPagingThreshold(r);
    }

    public static int getFileRecordBufferSize() {
        return ServerMessage.getPageBufferSize();
    }

    public static void setFileRecordBufferSize(int r) throws Exception {
        ServerMessage.setPageBufferSize(r);
    }

    public static int getMaxCharForRecordFile() {
        return ServerMessage.getMaxFieldSize();
    }

    public static void setMaxCharForRecordFile(int r) throws Exception {
        ServerMessage.setMaxFieldSize(r);
    }

    public static int getPagingThreshold() {
        return ServerMessage.getPagingThreshold();
    }

    public static void setPagingThreshold(int r) {
        ServerMessage.setPagingThreshold(r);
    }

    public static int getPageBufferSize() {
        return ServerMessage.getPageBufferSize();
    }

    public static void setPageBufferSize(int r) throws Exception {
        ServerMessage.setPageBufferSize(r);
    }

    public static int getMaxFieldSize() {
        return ServerMessage.getMaxFieldSize();
    }

    public static void setMaxFieldSize(int r) throws Exception {
        ServerMessage.setMaxFieldSize(r);
    }

    public static int getTotalPageBufferSize() {
        return ServerMessage.getTotalPageBufferSize();
    }

    public static void setTotalPageBufferSize(int r) throws Exception {
        ServerMessage.setTotalPageBufferSize(r);
    }

    public static String getTempDirectory() {
        return ServerMessage.getTempDirectory();
    }

    public static void setTempDirectory(String str) {
        ServerMessage.setTempDirectory(str);
    }

    @Deprecated
    public static boolean isExportToMultiPages() {
        return exportToMultiPages;
    }

    public static void setExportToMultiPages(boolean state) {
        exportToMultiPages = state;
        Report.setStaticExport(state);
    }

    public static void deleteViewFile(String viewFile) {
        PageReport.delete(viewFile);
    }

    public static String getVersion() {
        return SaveReport.VERSIONNAME + " (VERSION " + 7004 + " Update " + ServerMessage.getUpdateVersion() + ")";
    }

    public static String getUpdateVersion() {
        return ServerMessage.getUpdateVersion();
    }

    public static boolean isEspressManagerUsed() {
        return ServerMessage.useServer;
    }

    public static void setEspressManagerUsed(boolean b) {
        if (ServerMessage.useServer && !b) {
            ServerMessage.useServer = b;
            LCKey.resetLicense();
        }
        if (!ServerMessage.isServletServer()) {
            ServerMessage.useServer = b;
        }
    }

    public static int getQueryTimeout() {
        return QbConnection.getQueryTimeout();
    }

    public static void setQueryTimeout(int seconds) {
        QbConnection.setQueryTimeout(seconds);
    }

    public static void setConnectURLForServer(String comm_url) {
        ServerMessage.setConnectURL(comm_url);
    }

    public static void useHttp(boolean b) {
        if (b) {
            ServerMessage.useHttp();
        } else {
            ServerMessage.useSocket();
        }
    }

    public static synchronized void refreshWithOriginalData(Report report) throws Exception {
        if (report.getOriginalSourceData() > 0) {
            report.sourceData = report.getOriginalSourceData();
        }
        report = ReloadReport.reloadData(report, false);
        report.getQueryParameters();
    }

    public static void applyChartPathToAllCharts(boolean b) {
        Report.applyChartPathToAllCharts = b;
    }

    @Deprecated
    public static String pack(String filename) throws Exception {
        return QbReport.pack(filename, null, null, null);
    }

    @Deprecated
    public static String pack(String filename, String subReportPath, String drillDownPath, String chartPath) throws Exception {
        LoadReport loadReport = new LoadReport();
        loadReport.readOnly = true;
        Report rpt = loadReport.loadReportFromFile(filename, null, null, false, false);
        if (subReportPath != null) {
            rpt.setSubReportPath(subReportPath);
        }
        if (drillDownPath != null) {
            rpt.setDrillDownPath(drillDownPath);
        }
        if (chartPath != null) {
            rpt.setChartPath(chartPath);
        }
        SaveReport saveReport = new SaveReport(rpt);
        saveReport.setSubReports(rpt.subReports);
        saveReport.setDrillDownNode(rpt.currentNode);
        saveReport.generatePAKFile(true);
        filename = filename.substring(0, filename.length() - 3) + "pak";
        saveReport.getSubFilesTable().setTopName(filename);
        saveReport.getSubFilesTable().setFileInMemEnabled(true);
        saveReport.saveToFile(filename);
        return filename;
    }

    @Deprecated
    public static String pack(String filename, String relativeDomainPath) throws Exception {
        return QbReport.pack(filename, relativeDomainPath, false);
    }

    @Deprecated
    public static String pack(String filename, String relativeDomainPath, boolean isEntpServer) throws Exception {
        LoadReport loadReport = new LoadReport();
        loadReport.readOnly = true;
        loadReport.setRelativeDomainPath(relativeDomainPath);
        loadReport.setBackupDataUsed(true);
        Report rpt = loadReport.loadReportFromFile(filename, null, null, isEntpServer, false);
        SaveReport saveReport = new SaveReport(rpt);
        saveReport.setSubReports(rpt.subReports);
        saveReport.setDrillDownNode(rpt.currentNode);
        saveReport.generatePAKFile(true);
        filename = filename.substring(0, filename.length() - 3) + "pak";
        saveReport.getSubFilesTable().setTopName(filename);
        saveReport.getSubFilesTable().setFileInMemEnabled(true);
        saveReport.saveToFile(filename);
        return filename;
    }

    @Deprecated
    public static void unpack(String pakfilename, String filename, String relativeDomainPath) throws Exception {
        QbReport.unpack(pakfilename, filename, relativeDomainPath, true);
    }

    @Deprecated
    public static void unpack(String pakfilename, String filename, String relativeDomainPath, boolean popUp) throws Exception {
        LoadReport loadReport = new LoadReport(true);
        loadReport.readOnly = true;
        loadReport.setRelativeDomainPath(relativeDomainPath);
        loadReport.setBackupDataUsed(true);
        loadReport.setShowWarningDialog(popUp);
        loadReport.getSubFilesTable().setFileInMemEnabled(true);
        Report rpt = loadReport.loadReportFromFile(pakfilename);
        SaveReport saveReport = new SaveReport(rpt);
        saveReport.setSubReports(rpt.subReports);
        saveReport.setDrillDownNode(rpt.currentNode);
        saveReport.generatePAKFile(false);
        saveReport.saveAllFilesExceptRootFileFromTheMemoryTableToFileSystem(relativeDomainPath);
        saveReport.saveToFile(filename);
    }

    public static void setServerAddress(String address) throws UnknownHostException {
        ServerMessage.setAddress(address);
    }

    public static void setServerPortNumber(int port) {
        ServerMessage.setPortNumber(port);
    }

    public static void setServerHosts(Vector<String> hostnames) {
        ServerMessage.setHosts(hostnames);
    }

    public static void setServletRunner(String comm_url) {
        ServerMessage.setConnectServlet(comm_url);
    }

    public static void useServlet(boolean b) {
        if (b) {
            ServerMessage.useServlet();
        } else {
            ServerMessage.useSocket();
        }
    }

    public static String getServletContext() {
        return ServerMessage.getServletContext();
    }

    public static void setServletContext(String context) {
        ServerMessage.setServletContext(context);
    }

    public static int getPixelPerInchForExport() {
        return QbUtil.pixelPerInchExport;
    }

    public static void setPixelPerInchForExport(int PIXEL_PER_INCH) {
        QbUtil.setPixelPerInchForExport(PIXEL_PER_INCH);
    }

    public static boolean useSubReportCache() {
        return Report.useSubReportCache();
    }

    public static void setSubReportCache(boolean state) {
        Report.setSubReportCache(state);
    }

    public static QbReport createQbReport(Report r) {
        QbReport qbr = new QbReport();
        qbr.report = r;
        qbr.initDrillDownTree(r, r.currentNode);
        qbr.setSubReports(r, r.subReports);
        return qbr;
    }

    public static boolean useSingleTableForDistinctParamValue() {
        return ServerMessage.useSingleTableForDistinctParamValue();
    }

    public static void setUseSingleTableForDistinctParamValue(boolean state) {
        ServerMessage.setUseSingleTableForDistinctParamValue(state);
    }

    public static void setPdfEncryptionStrength(boolean strength128bit) {
        PDFReport.pdfEncStrength = strength128bit;
    }

    public static void setExcelExportFitCell(boolean b) {
        Report.Excel_fitCell = b;
    }

    public static void setExcelExportNonNumericFitCell(boolean b) {
        Report.Excel_NonNumericFitCell = b;
    }

    public static void setExcelExportStreaming(boolean b) {
        Report.Excel_streaming = b;
    }

    public static void setExcelExportWindowsize(int s) {
        Report.Excel_window_size = s;
    }

    private void qbReportHelper(Object parent, byte[] reportData, Object[] parameters, Properties props) {
        this.qbReportHelper(parent, reportData, parameters, props, null);
    }

    private void qbReportHelper(Object parent, byte[] reportData, Object[] parameters, Properties props, Hashtable<String, byte[]> rptTable) {
        ServerMessage.setParent(parent);
        try {
            Object[] pr = this.parseProperties(props);
            boolean optimizeMemory = ServerMessage.performOptimizeMemory((Boolean)pr[1]);
            boolean multiPageExp = (Boolean)pr[2];
            String securityLevel = (String)pr[4];
            boolean isEntpServer = (Boolean)pr[5];
            boolean useBackupData = (Boolean)pr[6];
            this.promptForParamValue = (Boolean)pr[7];
            LoadReport ld = new LoadReport(false, optimizeMemory);
            ld.setSecurityLevel(securityLevel);
            ld.setBackupDataUsed(useBackupData);
            ld.setDrillDownReportTable(rptTable);
            Vector<QueryInParamSet> p = null;
            if (parameters != null) {
                p = new Vector<QueryInParamSet>();
                p.addElement((QueryInParamSet)parameters);
            }
            this.report = ld.loadReport(new DataInputStream(new ByteArrayInputStream(reportData)), p, isEntpServer);
            this.report.setNullDataOption(this.report.getNullDataOption(), true);
            this.report.setExportToMultiPages(multiPageExp);
            Vector<DrillDownNode> childNodes = ld.getChildNodes();
            this.initDrillDownTree(this.report, ld.getDrillDownNode(), childNodes);
            this.setSubReports(this.report, ld.getSubReports());
            if (ld.getErrorMessage() != null) {
                this.errorMessage = ld.getErrorMessage();
            } else if (this.report.getOriginalSourceData() > 0) {
                this.errorMessage = "Failed to get data from data source!";
            }
        }
        catch (Exception ex) {
            this.errorMessage = IOUtil.getStackTrace(ex);
            throw new IllegalArgumentException(this.errorMessage);
        }
        if (this.report == null) {
            throw new IllegalArgumentException("Cannot Create Report");
        }
    }

    private void qbReportHelper(Object parent, int reportType, XMLFileQueryInfo xmlInfo, ColInfo[] mapping, String template, Properties props) {
        Object[] pr = this.parseProperties(props);
        boolean sideBySideLayout = (Boolean)pr[0];
        boolean multiPageExp = (Boolean)pr[2];
        boolean sorteddata = (Boolean)pr[3];
        boolean generateCrossTabGrandTotalColumn = (Boolean)pr[8];
        try {
            this.createFromDataFile(parent, reportType, xmlInfo.getFileName(), xmlInfo, mapping, template, sideBySideLayout, 7, sorteddata, generateCrossTabGrandTotalColumn, props);
        }
        catch (Exception ex) {
            this.errorMessage = IOUtil.getStackTrace(ex);
            throw new IllegalArgumentException(this.errorMessage);
        }
        if (this.report == null) {
            throw new IllegalArgumentException("Cannot Create Report");
        }
        this.report.setExportToMultiPages(multiPageExp);
    }

    private void qbReportHelper(Object parent, String fileName, Object[] queryParameters, Object[] formulaParameters, Properties props) {
        this.filename = fileName;
        Object[] pr = this.parseProperties(props);
        this.optimizeMemory = ServerMessage.performOptimizeMemory((Boolean)pr[1]);
        boolean multiPageExp = (Boolean)pr[2];
        String securityLevel = (String)pr[4];
        this.isEnterpriseServer = (Boolean)pr[5];
        boolean useBackupData = (Boolean)pr[6];
        boolean promptParamValue = (Boolean)pr[7];
        String relativeDomainPath = (String)pr[12];
        ServerMessage.setParent(parent);
        try {
            this.promptForParamValue = promptParamValue;
            Vector<QueryInParamSet> qParameters = null;
            if (queryParameters != null) {
                qParameters = new Vector<QueryInParamSet>();
                qParameters.addElement((QueryInParamSet)queryParameters);
            }
            Vector<Object[]> fParameters = null;
            if (formulaParameters != null) {
                fParameters = new Vector<Object[]>();
                fParameters.addElement(formulaParameters);
            }
            this.report = this.loadReportFromFile(fileName, qParameters, fParameters, useBackupData ? true : this.isEnterpriseServer, this.optimizeMemory, useBackupData, securityLevel, relativeDomainPath, null);
            this.report.setExportToMultiPages(multiPageExp);
            if (!useBackupData && this.report.getOriginalSourceData() > 0) {
                this.errorMessage = "Failed to get data from data source!";
            }
            this.report.setFileName(this.filename);
        }
        catch (Exception ex) {
            this.errorMessage = IOUtil.getStackTrace(ex);
            throw new IllegalArgumentException(this.errorMessage);
        }
        if (this.report == null) {
            throw new IllegalArgumentException("Cannot Create Report");
        }
    }

    public void setParameterValues(Parameters parameters, Object[] values) throws Exception {
        this.setParameterValues(parameters, parameters, values);
    }

    public void setParameterValues(Parameters parameters, Object[] values, boolean[] selectAllInfo, boolean[] needUpdate) throws Exception {
        this.selectAllInfo = selectAllInfo;
        this.needUpdate = needUpdate;
        this.setParameterValues(parameters, parameters, values);
    }

    public void setParameterValues(Parameters parameters, Object[] values, boolean[] selectAllInfo) throws Exception {
        this.selectAllInfo = selectAllInfo;
        this.setParameterValues(parameters, parameters, values);
    }

    public void setParameterValues(Parameters parameters, Parameters allParams, Object[] values) throws Exception {
        this.setParameterValues(parameters, allParams, values, true);
    }

    public void setParameterValues(Parameters parameters, Parameters allParams, Object[] values, boolean refresh) throws Exception {
        boolean needRefresh = false;
        if (this.needUpdate == null && this.selectAllInfo != null) {
            int len = this.selectAllInfo.length;
            this.needUpdate = new boolean[len];
            for (int cnt = 0; cnt < len; ++cnt) {
                this.needUpdate[cnt] = true;
            }
        }
        if (values != null) {
            if (parameters.size() != values.length) {
                System.out.println("unequal parameter size: drilldown must have parameterized sub report");
            }
            for (int i = 0; i < allParams.size() && i < values.length; ++i) {
                Param param = allParams.get(i);
                Parameters ps = parameters.get(param.name());
                if (ps != null && ps.size() > 0 && values[i] != null) {
                    String[] temp;
                    String dateFormat = param.getDateFormat();
                    if (param.isMapToColumn()) {
                        dateFormat = null;
                    }
                    if (!param.isFormulaParam() && param.multiValue()) {
                        temp = (String[])values[i];
                        if (!param.isMapToColumn() && temp.length <= 1) {
                            values[i] = QbUtil.parseMultiValues(((String[])values[i])[0]);
                        }
                        param.setValues(ReportUtil.getMultiValueObject(param.getSqlType(), (String[])values[i], dateFormat));
                        if (this.selectAllInfo != null && this.needUpdate[i]) {
                            if (this.selectAllInfo[i]) {
                                param.setValue("SELECT_-_ALL_-_MULTIPLE_-_VALUES");
                            } else {
                                param.setValue("NOT_-_SELECT_-_ALL_-_MULTIPLE_-_VALUES");
                            }
                        }
                    } else {
                        temp = (String[])values[i];
                        if (temp.length == 3) {
                            if (temp[2] == null || temp[2].equals("")) {
                                temp[2] = "2003";
                            }
                            String date = temp[0] + "/" + temp[1] + "/" + temp[2];
                            param.setValue(ReportUtil.getValueObject(param.getSqlType(), date, "MM/dd/yyyy"));
                        } else if (param instanceof QueryParam && ((QueryParam)param).findParam().isAllOptionEnabled() && ((QueryParam)param).findParam().getAllOptionLabel().equals(temp[0])) {
                            quadbase.common.paramquery.QueryInParam qip = ((QueryParam)param).findParam();
                            param.setValue(qip.getAllOptionLabel());
                        } else {
                            param.setValue(ReportUtil.getValueObject(param.getSqlType(), temp[0], dateFormat));
                        }
                    }
                    param.getReport().setSubReportParamValues(param);
                    this.report.setSubReportParamValues(param);
                }
                needRefresh = refresh;
            }
        }
        if (needRefresh) {
            this.refreshWithOriginalData();
        }
    }

    private String getSecurityLevel(Object reqObj) {
        Method getParamValsMethod = null;
        Object returnObj = null;
        String securityLevel = null;
        try {
            getParamValsMethod = reqObj.getClass().getMethod("getParameterValues", String.class);
            returnObj = getParamValsMethod.invoke(reqObj, "SecurityLevel");
            if (returnObj != null) {
                securityLevel = ((String[])returnObj)[0];
            }
        }
        catch (NoSuchMethodException ne) {
            ne.printStackTrace();
        }
        catch (IllegalAccessException ae) {
            ae.printStackTrace();
        }
        catch (InvocationTargetException ie) {
            ie.printStackTrace();
        }
        return securityLevel;
    }

    public Object[] getParamInput(Object reqObj) {
        int paramSetSize = 0;
        Class<?> reqClass = null;
        Method getParamValsMethod = null;
        Object returnObj = null;
        Object[] paramValueArr = null;
        try {
            reqClass = reqObj.getClass();
            getParamValsMethod = reqClass.getMethod("getParameterValues", String.class);
            returnObj = getParamValsMethod.invoke(reqObj, "paramSetSize");
            if (returnObj != null) {
                paramSetSize = Integer.valueOf(((String[])returnObj)[0]);
            }
            paramValueArr = new Object[paramSetSize];
            this.selectAllInfo = new boolean[paramSetSize];
            for (int i = 0; i < paramSetSize; ++i) {
                getParamValsMethod = reqClass.getMethod("getParameterValues", String.class);
                paramValueArr[i] = returnObj = getParamValsMethod.invoke(reqObj, "paramValue_" + i);
                returnObj = getParamValsMethod.invoke(reqObj, "paramValue_" + i + "_SelectAll");
                if (returnObj == null) continue;
                this.selectAllInfo[i] = ((String[])returnObj)[0].equals("true");
            }
        }
        catch (NoSuchMethodException ne) {
            ne.printStackTrace();
        }
        catch (IllegalAccessException ae) {
            ae.printStackTrace();
        }
        catch (InvocationTargetException ie) {
            ie.printStackTrace();
        }
        return paramValueArr;
    }

    public void setSubReportParameters(Object req) {
        this.report.setSubReportParameters(req);
    }

    private void qbReportHelper(Object parent, int reportType, quadbase.reportdesigner.util.IDatabaseInfo dbinfo, ColInfo[] mapping, String template, Properties props) {
        Object[] pr = this.parseProperties(props);
        boolean sideBySideLayout = (Boolean)pr[0];
        this.optimizeMemory = ServerMessage.performOptimizeMemory((Boolean)pr[1]);
        boolean multiPageExp = (Boolean)pr[2];
        boolean sorteddata = (Boolean)pr[3];
        this.promptForParamValue = true;
        this.promptForParamValue = (Boolean)pr[7];
        boolean generateCrossTabGrandTotalColumn = (Boolean)pr[8];
        String reportStyle = (String)pr[9];
        try {
            if (mapping == null) {
                mapping = LoadReport.getColInfo(template);
            }
            if (!(dbinfo instanceof DBInfoBasic && ((DBInfoBasic)((Object)dbinfo)).isUseJNDIDataSource() || !this.isUncompleteDBInfo(dbinfo))) {
                dbinfo = ReportUtil.cast(this.fillDBInfo(dbinfo, LoadReport.getDBInfoBasic(template)));
            }
            this.createFromIDatabaseInfo(parent, reportType, dbinfo, mapping, template, false, sideBySideLayout, this.optimizeMemory, multiPageExp, sorteddata, generateCrossTabGrandTotalColumn, !this.promptForParamValue, props);
            if (this.report != null && reportStyle != null) {
                this.report.applyStyle(reportStyle);
            }
        }
        catch (Exception ex) {
            this.errorMessage = IOUtil.getStackTrace(ex);
            throw new IllegalArgumentException(this.errorMessage);
        }
        if (this.report == null) {
            throw new IllegalArgumentException("Cannot Create Report");
        }
    }

    boolean isUncompleteDBInfo(IDatabaseInfo dbInfo) {
        if (dbInfo == null) {
            return true;
        }
        if (dbInfo.getConnection() != null) {
            return false;
        }
        return dbInfo.getQuery() == null || dbInfo.getDriverName() == null || dbInfo.getQuery() == null || dbInfo.getPassword() == null || dbInfo.getURLString() == null || dbInfo.getUserID() == null;
    }

    IDatabaseInfo fillDBInfo(IDatabaseInfo dbInfo, IDatabaseInfo _dbInfo) {
        String userID;
        String url;
        String password;
        String driver;
        if (dbInfo == null) {
            return _dbInfo;
        }
        String query = dbInfo.getQuery();
        if (query == null) {
            query = _dbInfo.getQuery();
        }
        if ((driver = dbInfo.getDriverName()) == null) {
            driver = _dbInfo.getDriverName();
        }
        if ((password = dbInfo.getPassword()) == null) {
            password = _dbInfo.getPassword();
        }
        if ((url = dbInfo.getURLString()) == null) {
            url = _dbInfo.getURLString();
        }
        if ((userID = dbInfo.getUserID()) == null) {
            userID = _dbInfo.getUserID();
        }
        if (dbInfo instanceof quadbase.reportdesigner.util.IQueryFileInfo) {
            SimpleQueryFileInfo sInfo = new SimpleQueryFileInfo(url, driver, userID, password, query);
            sInfo.setInParam(((quadbase.reportdesigner.util.IQueryFileInfo)dbInfo).getInParam());
            return sInfo;
        }
        return new DBInfo(url, driver, userID, password, query);
    }

    private void qbReportHelper(Object parent, int reportType, int fileType, String filename, ColInfo[] mapping, String template, Properties props, quadbase.common.util.IOLAPResultSet olapRS, String connectionString, String MDXQuery, String uri, String datasource, String catalog, short aggrValForValueCol, boolean[] rowBreakAggrIncluded, boolean[] colBreakAggrIncluded) {
        Object[] pr = this.parseProperties(props);
        boolean sideBySideLayout = (Boolean)pr[0];
        boolean multiPageExp = (Boolean)pr[2];
        boolean sorteddata = (Boolean)pr[3];
        boolean generateCrossTabGrandTotalColumn = (Boolean)pr[8];
        String reportStyle = (String)pr[9];
        try {
            if (mapping == null && fileType != 10) {
                mapping = LoadReport.getColInfo(template);
            }
            if (fileType == 1) {
                QueryFileInfo info = QueryFileInfo.readFile(filename);
                this.createFromIDatabaseInfo(parent, reportType, info, mapping, template, false, sideBySideLayout, false, multiPageExp, sorteddata, generateCrossTabGrandTotalColumn, false, props);
                this.report.queryFilename = filename;
            } else if (fileType == 0 || fileType == 2 || fileType == 3) {
                int tmp = 2;
                if (fileType == 3) {
                    tmp = 6;
                } else if (fileType == 2) {
                    tmp = 4;
                }
                this.createFromDataFile(parent, reportType, filename, null, mapping, template, sideBySideLayout, tmp, sorteddata, generateCrossTabGrandTotalColumn, props);
                if (this.report != null) {
                    this.report.setExportToMultiPages(multiPageExp);
                }
            } else if (fileType == 10) {
                this.createFromOLAPResultSet(parent, reportType, olapRS, connectionString, MDXQuery, uri, datasource, catalog, template, generateCrossTabGrandTotalColumn, props, aggrValForValueCol, rowBreakAggrIncluded, colBreakAggrIncluded);
                if (this.report != null) {
                    this.report.setExportToMultiPages(multiPageExp);
                }
            } else {
                throw new IllegalArgumentException("Illegal fileType");
            }
            if (this.report == null) {
                throw new IllegalArgumentException("Cannot Create Report");
            }
            if (reportStyle != null) {
                this.report.applyStyle(reportStyle);
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex.toString());
        }
    }

    private void createFromIDatabaseInfo(Object parent, int reportType, IDatabaseInfo dbinfo, ColInfo[] mapping, String template, boolean useDefaults, boolean sideBySideLayout, boolean optimizeMemory) throws Exception {
        this.createFromIDatabaseInfo(parent, reportType, dbinfo, mapping, template, useDefaults, sideBySideLayout, optimizeMemory, exportToMultiPages, false);
    }

    private void createFromIDatabaseInfo(Object parent, int reportType, IDatabaseInfo dbinfo, ColInfo[] mapping, String template, boolean useDefaults, boolean sideBySideLayout, boolean optimizeMemory, boolean multiPageExp, boolean u_sorteddata) throws Exception {
        this.createFromIDatabaseInfo(parent, reportType, dbinfo, mapping, template, useDefaults, sideBySideLayout, optimizeMemory, multiPageExp, u_sorteddata, true);
    }

    private void createFromIDatabaseInfo(Object parent, int reportType, IDatabaseInfo dbinfo, ColInfo[] mapping, String template, boolean useDefaults, boolean sideBySideLayout, boolean optimizeMemory, boolean multiPageExp, boolean u_sorteddata, boolean generateCrossTabGrandTotalColumn) throws Exception {
        this.createFromIDatabaseInfo(parent, reportType, dbinfo, mapping, template, useDefaults, sideBySideLayout, optimizeMemory, multiPageExp, u_sorteddata, generateCrossTabGrandTotalColumn, false, null);
    }

    private void createFromIDatabaseInfo(Object parent, int reportType, IDatabaseInfo dbinfo, ColInfo[] mapping, String template, boolean useDefaults, boolean sideBySideLayout, boolean optimizeMemory, boolean multiPageExp, boolean u_sorteddata, boolean generateCrossTabGrandTotalColumn, boolean isEntpServer, Properties props) throws Exception {
        ServerMessage.setParent(parent);
        Object[] res = this.setColData(u_sorteddata, dbinfo, mapping, useDefaults, reportType, optimizeMemory, isEntpServer);
        quadbase.reportdesigner.report.ColData[] colData = (quadbase.reportdesigner.report.ColData[])res[0];
        QueryFileInfo queryFileInfo = (QueryFileInfo)res[1];
        boolean sorteddata = (Boolean)res[2];
        this.createReport(reportType, colData, mapping, template, sorteddata, sideBySideLayout, optimizeMemory, generateCrossTabGrandTotalColumn, null, null, props);
        if (this.report == null) {
            throw new IllegalArgumentException("Cannot create the report");
        }
        this.report.sourceData = 1;
        this.report.dbInfo = new DBInfo(dbinfo);
        this.report.setExportToMultiPages(multiPageExp);
        this.report.queryFilename = null;
        if (dbinfo instanceof quadbase.reportdesigner.util.IQueryFileInfo) {
            this.report.setQueryFileInfo(queryFileInfo);
            this.report.dbInfo = queryFileInfo;
        } else {
            this.report.setQueryFileInfo(null);
        }
    }

    private Object[] setColData(boolean u_sorteddata, IDatabaseInfo dbinfo, ColInfo[] mapping, boolean useDefaults, int reportType, boolean optimizeMemory, boolean isEntpServer) throws Exception {
        String sqlstr;
        optimizeMemory = ServerMessage.performOptimizeMemory(optimizeMemory);
        quadbase.reportdesigner.report.ColData[] colData = null;
        QueryFileInfo queryFileInfo = null;
        boolean sorteddata = false;
        if (dbinfo instanceof quadbase.reportdesigner.util.IQueryFileInfo) {
            optimizeMemory = false;
            if (!(this.report != null && (this.report.isKeepDataSourceOrder() || u_sorteddata || reportType != 1 && reportType != 2 && reportType != 3 || this.isTransposed))) {
                try {
                    sqlstr = dbinfo.getQuery();
                    sqlstr = TransformQuery.transform(sqlstr, mapping);
                    quadbase.common.util.IQueryInParam[] inParam = ReportUtil.getInParam(dbinfo);
                    QueryInParamSet paramSet = null;
                    if (inParam != null) {
                        quadbase.common.paramquery.QueryInParam[][] paramInSeq = null;
                        quadbase.reportdesigner.util.IQueryInParam[][] oldParamInSeq = ReportUtil.getParamInSequence(dbinfo);
                        if (oldParamInSeq != null) {
                            paramInSeq = new quadbase.common.paramquery.QueryInParam[oldParamInSeq.length][oldParamInSeq.length];
                        }
                        int nInParam = inParam.length;
                        quadbase.common.paramquery.QueryInParam[] tempIn = new quadbase.common.paramquery.QueryInParam[nInParam];
                        int[][] inParamMap = QueryInParamSet.makeParamMap(sqlstr);
                        for (int i = 0; i < nInParam; ++i) {
                            quadbase.common.util.IQueryInParam currIn = inParam[i];
                            tempIn[i] = currIn instanceof IQueryMultiValueInParam ? new QueryMultiValueInParam(inParamMap[i], currIn.getParamName(), currIn.getPromptName(), currIn.isMapToColumn(), currIn.getTableName(), currIn.getColumnName(), currIn.getSqlType(), currIn.getDefaultValue(), currIn.getValue(), ((IQueryMultiValueInParam)currIn).getValues()) : new quadbase.common.paramquery.QueryInParam(inParamMap[i], currIn.getParamName(), currIn.getPromptName(), currIn.isMapToColumn(), currIn.getTableName(), currIn.getColumnName(), currIn.getSqlType(), currIn.getDefaultValue(), currIn.getValue());
                            if (currIn instanceof quadbase.common.paramquery.QueryInParam) {
                                tempIn[i].setSqlSelect(((quadbase.common.paramquery.QueryInParam)currIn).getSqlSelect());
                            }
                            if (currIn instanceof quadbase.common.paramquery.QueryInParam) {
                                tempIn[i].setSqlSelect(((quadbase.common.paramquery.QueryInParam)currIn).getSqlSelect());
                                tempIn[i].setDefaultSql(((quadbase.common.paramquery.QueryInParam)currIn).getDefaultSql());
                            }
                            if (currIn instanceof QueryInParam) {
                                tempIn[i].setSqlSelect(((QueryInParam)currIn).getSqlSelect());
                                tempIn[i].setDefaultSql(((QueryInParam)currIn).getDefaultSql());
                            }
                            if (currIn instanceof ReportUtil.CQueryInParam) {
                                tempIn[i].setSqlSelect(((ReportUtil.CQueryInParam)currIn).getSqlSelect());
                                tempIn[i].setDefaultSql(((ReportUtil.CQueryInParam)currIn).getDefaultSql());
                            }
                            if (currIn instanceof ICustomParameterDateFormat) {
                                tempIn[i].setDateFormat(((ICustomParameterDateFormat)((Object)currIn)).getDateFormat());
                            }
                            if (useDefaults) {
                                if (currIn instanceof quadbase.common.paramquery.QueryInParam) {
                                    tempIn[i].setValue(((quadbase.common.paramquery.QueryInParam)currIn).getDefaultValue((QueryFileInfo)dbinfo));
                                } else {
                                    tempIn[i].setValue(currIn.getDefaultValue());
                                }
                            }
                            if (oldParamInSeq == null) continue;
                            int jct = 0;
                            for (quadbase.reportdesigner.util.IQueryInParam[] element : oldParamInSeq) {
                                int kct = 0;
                                for (quadbase.reportdesigner.util.IQueryInParam element2 : element) {
                                    if (!element2.getParamName().equals(tempIn[i].getParamName())) continue;
                                    paramInSeq[jct][kct] = tempIn[i];
                                    ++kct;
                                }
                                if (kct <= 0) continue;
                                ++jct;
                            }
                        }
                        paramSet = new QueryInParamSet(tempIn);
                        paramSet.setParameterInPromptSequence(paramInSeq);
                    }
                    DBInfoBasic dbbasic = new DBInfoBasic(dbinfo);
                    dbbasic.setQuery(sqlstr);
                    queryFileInfo = new QueryFileInfo("EspressReport", 7004, dbbasic, paramSet);
                    colData = DBAccess.retrieveResult(QueryFileInfo.getDBAccessParameter(queryFileInfo, !this.promptForParamValue), queryFileInfo, true, false, null, null, null, optimizeMemory);
                    sorteddata = true;
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINEST, ex.getMessage());
                }
            }
            if (!sorteddata) {
                queryFileInfo = new QueryFileInfo((quadbase.reportdesigner.util.IQueryFileInfo)dbinfo);
                if (useDefaults) {
                    quadbase.common.util.IQueryInParam[] inParam = queryFileInfo.getInParam();
                    for (quadbase.common.util.IQueryInParam element : inParam) {
                        if (element == null) continue;
                        if (element instanceof quadbase.common.paramquery.QueryInParam) {
                            element.setValue(((quadbase.common.paramquery.QueryInParam)element).getDefaultValue(queryFileInfo));
                            continue;
                        }
                        element.setValue(element.getDefaultValue());
                    }
                }
                colData = DBAccess.retrieveResult(QueryFileInfo.getDBAccessParameter(queryFileInfo, !this.promptForParamValue), queryFileInfo, true, this.isTransposed, this.transposeCol, null, null, optimizeMemory);
            }
        } else {
            if (!(u_sorteddata || reportType != 1 && reportType != 2 || this.isTransposed)) {
                try {
                    String origQuery = sqlstr = dbinfo.getQuery();
                    DBInfoBasic tempdbInfo = null;
                    String newQuery = null;
                    if (reportType == 2 && optimizeMemory && TransformQuery.isValidQuery(sqlstr, mapping)) {
                        newQuery = TransformQuery.transformDistCol(sqlstr, mapping);
                        sqlstr = TransformQuery.transformCrossTab(sqlstr, mapping);
                        tempdbInfo = new DBInfoBasic(dbinfo);
                        tempdbInfo.setQuery(newQuery);
                        quadbase.reportdesigner.report.ColData[] distCol = DBInfo.getColData(tempdbInfo, false, null, 0, -1, optimizeMemory);
                        this.colValue = QbUtil.toArray(distCol[0].getDataSet());
                        if (this.colValue == null) {
                            throw new Exception("No valid column value is found for one shot crosstab.");
                        }
                    } else {
                        sqlstr = TransformQuery.transform(sqlstr, mapping);
                    }
                    boolean retried = false;
                    while (true) {
                        try {
                            quadbase.reportdesigner.report.ColData[] colData2 = null;
                            tempdbInfo = new DBInfoBasic(dbinfo);
                            tempdbInfo.setQuery(sqlstr);
                            colData2 = optimizeMemory && reportType != 2 || reportType == 2 && optimizeMemory && TransformQuery.isValidQuery(sqlstr, mapping) ? DBInfo.getColData(tempdbInfo, false, null, 0, 0, optimizeMemory) : DBInfo.getColData(tempdbInfo, false, null, 0, -1, optimizeMemory);
                            colData = colData2;
                            sorteddata = true;
                            if (!optimizeMemory || reportType != 2 || TransformQuery.isValidQuery(sqlstr, mapping)) break;
                            sorteddata = false;
                        }
                        catch (Exception te) {
                            if (retried) {
                                throw te;
                            }
                            sqlstr = origQuery;
                            retried = true;
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } else if (reportType == 0 || reportType == 4 || reportType == 3 && optimizeMemory) {
                quadbase.reportdesigner.report.ColData[] colData2 = null;
                colData2 = optimizeMemory ? DBInfo.getColData(dbinfo, false, null, 0, 0, optimizeMemory) : DBInfo.getColData(dbinfo, false, null, 0, -1, optimizeMemory);
                colData = colData2;
                sorteddata = true;
            }
            if (!sorteddata) {
                colData = DBInfo.getColData(dbinfo, this.isTransposed, this.transposeCol, 0, -1, optimizeMemory);
            }
        }
        Object[] res = new Object[]{colData, queryFileInfo, sorteddata || u_sorteddata};
        return res;
    }

    private void createFromOLAPResultSet(Object parent, int reportType, quadbase.common.util.IOLAPResultSet olapRS, String connectionString, String MDXQuery, String uri, String datasource, String catalog, String template, boolean generateCrossTabGrandTotalColumn, Properties props, short aggrValForValueCol, boolean[] rowBreakAggrIncluded, boolean[] colBreakAggrIncluded) throws Exception {
        ServerMessage.setParent(parent);
        OLAPAccess olapAccess = new OLAPAccess(olapRS, connectionString, MDXQuery, uri, datasource, catalog);
        quadbase.reportdesigner.report.ColData[] colData = olapAccess.retrieveResult(reportType);
        ColInfo[] mapping = olapAccess.getMapping(reportType, aggrValForValueCol);
        rowBreakAggrIncluded = olapAccess.isRowBreakAggrIncluded(rowBreakAggrIncluded);
        colBreakAggrIncluded = olapAccess.isColBreakAggrIncluded(colBreakAggrIncluded);
        boolean u_sorteddata = true;
        this.createReport(reportType, colData, mapping, template, u_sorteddata, false, false, generateCrossTabGrandTotalColumn, rowBreakAggrIncluded, colBreakAggrIncluded, props);
        if (this.report == null) {
            throw new IllegalArgumentException("Invalid argument(s).  Cannot create the report");
        }
        this.report.olapRS = olapRS;
        if (connectionString != null) {
            this.report.mondrianConnectionString = connectionString;
        }
        this.report.MDXQuery = MDXQuery;
        if (uri != null) {
            this.report.xmlaURI = uri;
        }
        if (datasource != null) {
            this.report.xmlaDataSource = datasource;
        }
        if (catalog != null) {
            this.report.xmlaCatalog = catalog;
        }
        this.report.sourceData = 10;
    }

    private void createFromDataFile(Object parent, int reportType, String dataFile, XMLFileQueryInfo xmlFileQueryInfo, ColInfo[] mapping, String template, boolean sideBySideLayout, int dataFileType, boolean u_sorteddata, boolean generateCrossTabGrandTotalColumn, Properties props) throws Exception {
        ServerMessage.setParent(parent);
        quadbase.reportdesigner.report.ColData[] colData = null;
        QueryClassFileInfo classInfo = null;
        QueryXMLFileInfo queryXMLFileInfo = null;
        if (dataFileType == 6 && ClassFileUtil.isParameterized(dataFile)) {
            classInfo = new QueryClassFileInfo(dataFile);
            Vector<QueryInParamSet> paramV = null;
            paramV = QueryFileInfo.getParameter(classInfo, false, false, true);
            colData = new DataFileInput().readProcessedData(dataFile, this.isTransposed, this.transposeCol, null, null, 0, -1, paramV.elementAt(0));
        } else if (dataFileType == 7 && xmlFileQueryInfo.getInParam() != null) {
            queryXMLFileInfo = new QueryXMLFileInfo(xmlFileQueryInfo);
            queryXMLFileInfo.setInSet(xmlFileQueryInfo.getInSet());
            try {
                QueryFileInfo.getParameter(queryXMLFileInfo, false, false, true);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            colData = new DataFileInput().readProcessedData(dataFile, this.isTransposed, this.transposeCol, null, null, 0, -1, xmlFileQueryInfo, dataFileType);
        } else {
            colData = new DataFileInput().readProcessedData(dataFile, this.isTransposed, this.transposeCol, null, null, 0, -1, xmlFileQueryInfo, dataFileType);
        }
        this.createReport(reportType, colData, mapping, template, u_sorteddata, sideBySideLayout, false, generateCrossTabGrandTotalColumn, null, null, props);
        if (this.report == null) {
            throw new IllegalArgumentException("Invalid argument(s).  Cannot create the report");
        }
        this.report.sourceData = dataFileType;
        this.report.sourceFile = dataFile;
        this.report.xmlFileQueryInfo = xmlFileQueryInfo;
        if (classInfo != null) {
            this.report.dbInfo = classInfo;
        } else if (queryXMLFileInfo != null) {
            this.report.dbInfo = queryXMLFileInfo;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void qbReportHelper(Object parent, int reportType, IResultSet data, ColInfo[] mapping, String template, Properties props, Object[] distinctValue) {
        quadbase.reportdesigner.report.ColData[] colData;
        Object[] pr = this.parseProperties(props);
        boolean sideBySideLayout = (Boolean)pr[0];
        this.optimizeMemory = ServerMessage.performOptimizeMemory((Boolean)pr[1]);
        boolean multiPageExp = (Boolean)pr[2];
        boolean sorteddata = (Boolean)pr[3];
        boolean generateCrossTabGrandTotalColumn = (Boolean)pr[8];
        String reportStyle = (String)pr[9];
        if (!sorteddata) {
            this.optimizeMemory = false;
        }
        this.colValue = distinctValue;
        ServerMessage.setParent(parent);
        try {
            IResultSet rs;
            if (mapping == null) {
                mapping = LoadReport.getColInfo(template);
            }
            colData = data instanceof DbData ? ((DbData)data).getColData() : (this.optimizeMemory ? quadbase.reportdesigner.report.ColData.getColData(data, 0, 0) : quadbase.reportdesigner.report.ColData.getColData(data));
            if (this.isTransposed && (rs = TransposeRS.doTranspose(colData, this.transposeCol)) != null) {
                colData = quadbase.reportdesigner.report.ColData.getColData(rs);
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
        this.createReport(reportType, colData, mapping, template, sorteddata, sideBySideLayout, this.optimizeMemory, generateCrossTabGrandTotalColumn, null, null, props);
        if (this.report == null) throw new IllegalArgumentException("Cannot Create Report");
        this.report.setExportToMultiPages(multiPageExp);
        this.report.sourceData = 0;
        this.report.originalColDataFromMemSource = this.report.getColData();
        this.report.originalIResultSet = data;
        try {
            if (reportStyle == null) return;
            this.report.applyStyle(reportStyle);
            return;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void qbReportHelper(Object parent, int reportType, ISpreadSheetModel sheet, ColInfo[] mapping, String template, Properties props) {
        Object[] pr = this.parseProperties(props);
        boolean sideBySideLayout = (Boolean)pr[0];
        boolean multiPageExp = (Boolean)pr[2];
        boolean sorteddata = (Boolean)pr[3];
        boolean generateCrossTabGrandTotalColumn = (Boolean)pr[8];
        String reportStyle = (String)pr[9];
        ServerMessage.setParent(parent);
        try {
            if (mapping == null) {
                mapping = LoadReport.getColInfo(template);
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
        this.spreadSheet = sheet;
        quadbase.reportdesigner.report.ColData[] colData = quadbase.reportdesigner.report.ColData.getColData(sheet);
        try {
            IResultSet rs;
            if (this.isTransposed && (rs = TransposeRS.doTranspose(colData, this.transposeCol)) != null) {
                colData = quadbase.reportdesigner.report.ColData.getColData(rs);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.createReport(reportType, colData, mapping, template, sorteddata, sideBySideLayout, false, generateCrossTabGrandTotalColumn, null, null, props);
        if (this.report == null) throw new IllegalArgumentException("Cannot Create Report");
        this.report.setExportToMultiPages(multiPageExp);
        this.report.sourceData = 0;
        this.report.originalColDataFromMemSource = this.report.getColData();
        try {
            if (reportStyle != null) {
                this.report.applyStyle(reportStyle);
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
        this.spreadSheetListener = new CSpreadSheetListener();
        sheet.addSpreadSheetModelListener(this.spreadSheetListener);
    }

    private void qbReportHelper(Object parent, int reportType, DataSheet[] dataSheet, ColInfo[] mapping, String template, Properties props) {
        block11: {
            Object[] pr = this.parseProperties(props);
            boolean sideBySideLayout = (Boolean)pr[0];
            boolean multiPageExp = (Boolean)pr[2];
            boolean sorteddata = (Boolean)pr[3];
            boolean generateCrossTabGrandTotalColumn = (Boolean)pr[8];
            String reportStyle = (String)pr[9];
            try {
                IResultSet rs;
                ServerMessage.setParent(parent);
                if (mapping == null) {
                    mapping = LoadReport.getColInfo(template);
                }
                if (dataSheet == null || dataSheet.length <= 0) {
                    throw new IllegalArgumentException("DataSheet is null");
                }
                Vector<quadbase.reportdesigner.report.ColData[]> colList = new Vector<quadbase.reportdesigner.report.ColData[]>();
                Object[] source = new Object[dataSheet.length];
                int[] sourceType = new int[dataSheet.length];
                boolean[] doTranspose = new boolean[dataSheet.length];
                Object[] transposeColList = new Object[dataSheet.length];
                for (int i = 0; i < dataSheet.length; ++i) {
                    colList.addElement(dataSheet[i].getColData());
                    if (source == null || sourceType == null || doTranspose == null || transposeColList == null) continue;
                    if (dataSheet[i].getSource() == null) {
                        source = null;
                        sourceType = null;
                        doTranspose = null;
                        transposeColList = null;
                        continue;
                    }
                    source[i] = dataSheet[i].getSource();
                    sourceType[i] = dataSheet[i].getSourceType();
                    doTranspose[i] = dataSheet[i].isTranspose();
                    transposeColList[i] = dataSheet[i].getTransposedColumn();
                }
                quadbase.reportdesigner.report.ColData[] colData = quadbase.reportdesigner.report.ColData.merge(colList, true);
                if (this.isTransposed && (rs = TransposeRS.doTranspose(colData, this.transposeCol)) != null) {
                    colData = quadbase.reportdesigner.report.ColData.getColData(rs);
                }
                this.createReport(reportType, colData, mapping, template, sideBySideLayout, sorteddata, false, generateCrossTabGrandTotalColumn, null, null, props);
                if (this.report != null) {
                    this.report.setExportToMultiPages(multiPageExp);
                    if (source != null) {
                        this.report.sourceData = 3;
                        this.report.sourceList = source;
                        this.report.sourceType = sourceType;
                        this.report.transposeColList = transposeColList;
                        this.report.doTranspose = doTranspose;
                        this.report.setTransposed(this.isTransposed, this.transposeCol);
                    } else {
                        this.report.sourceData = 0;
                    }
                    if (reportStyle != null) {
                        this.report.applyStyle(reportStyle);
                    }
                    break block11;
                }
                throw new IllegalArgumentException("Cannot Create Report");
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(ex.toString());
            }
        }
    }

    public void createReport(int reportType, quadbase.reportdesigner.report.ColData[] data, ColInfo[] mapping, String templatename, boolean sideBySideLayout) {
        this.createReport(reportType, data, mapping, templatename, false, sideBySideLayout);
    }

    public void createReport(int reportType, quadbase.reportdesigner.report.ColData[] data, ColInfo[] mapping, String templatename, boolean sorteddata, boolean sideBySideLayout) {
        this.createReport(reportType, data, mapping, templatename, sorteddata, sideBySideLayout, false);
    }

    public void createReport(int reportType, quadbase.reportdesigner.report.ColData[] data, ColInfo[] mapping, String templatename, boolean sorteddata, boolean sideBySideLayout, boolean optimizeMemory) {
        this.createReport(reportType, data, mapping, templatename, sorteddata, sideBySideLayout, optimizeMemory, true);
    }

    public void createReport(int reportType, quadbase.reportdesigner.report.ColData[] data, ColInfo[] mapping, String templatename, boolean sorteddata, boolean sideBySideLayout, boolean optimizeMemory, boolean generateCrossTabGrandTotalColumn) {
        this.createReport(reportType, data, mapping, templatename, sorteddata, sideBySideLayout, optimizeMemory, generateCrossTabGrandTotalColumn, null, null, null);
    }

    public void createReport(int reportType, quadbase.reportdesigner.report.ColData[] data, ColInfo[] mapping, String templatename, boolean sorteddata, boolean sideBySideLayout, boolean optimizeMemory, boolean generateCrossTabGrandTotalColumn, boolean[] rowBreakAggrIncluded, boolean[] colBreakAggrIncluded, Properties props) {
        if (this.errorMessage == null) {
            try {
                if (data != null) {
                    this.report = new Report(data, optimizeMemory);
                    this.report.colDataSorted = sorteddata;
                    if (this.colValue != null) {
                        this.report.distColValue = this.colValue;
                    }
                } else if (this.report != null) {
                    this.report = new Report(this.report);
                    if (this.colValue != null) {
                        this.report.distColValue = this.colValue;
                    }
                } else {
                    throw new IllegalArgumentException("Null data argument");
                }
                if (reportType == 3) {
                    this.report.setSideBySideLayout(sideBySideLayout);
                }
                if (reportType == 2) {
                    this.report.setShowRowAggregationGrandTotal(generateCrossTabGrandTotalColumn);
                    this.report.rowBreakAggrIncluded = rowBreakAggrIncluded;
                    this.report.colBreakAggrIncluded = colBreakAggrIncluded;
                    if (props != null) {
                        Object[] pr = this.parseProperties(props);
                        this.report.crossTabFreeForm = (Boolean)pr[13];
                        this.report.setShowRowAggregationSubtotal((Boolean)pr[18]);
                        this.report.setRowAggregationSubtotalOnLeft((Boolean)pr[14]);
                        this.report.setShowColumnAggregation((Boolean)pr[17]);
                        if (this.report.isShowColumnAggregation()) {
                            this.report.setColumnAggregationInHeader((Boolean)pr[15]);
                        }
                        this.report.setAlignCrossTabColBkValHori((Boolean)pr[16]);
                    }
                }
                this.report.createTable(reportType, mapping);
            }
            catch (Exception ex) {
                this.errorMessage = IOUtil.getStackTrace(ex);
            }
            if (templatename != null) {
                try {
                    this.report = this.loadTemplate(templatename);
                }
                catch (Exception ex) {
                    this.errorMessage = "Failed to load template " + ex.toString();
                }
            }
            this.initDrillDownTree(this.report, null);
            this.setSubReports(this.report, new Vector<SubReportObject>());
        }
    }

    public boolean isForDeploy() {
        return this.report.isForDeploy();
    }

    public void setForDeploy(boolean state) {
        this.report.setForDeploy(state);
    }

    public boolean isMultiPageExp() {
        return this.report.isExportToMultiPages();
    }

    public void setMultiPageExp(boolean state) {
        this.report.setExportToMultiPages(state);
    }

    @Deprecated
    public boolean isUsingIE55DHTMLRendering() {
        return this.report.isUsingIE55DHTMLRendering();
    }

    @Deprecated
    public void setUsingIE55DHTMLRendering(boolean b) {
        this.report.setUsingIE55DHTMLRendering(b);
    }

    @Deprecated
    public void setUseStyleSheet(boolean state) {
    }

    public void setExternalStyleSheetName(String css) {
        this.report.setExternalStyleSheetName(css);
    }

    public String getHTMLTitle() {
        return this.report.getHTMLTitle();
    }

    public void setHTMLTitle(String title) {
        this.report.setHTMLTitle(title);
    }

    public void setExportDelimiter(int delimiter) {
        this.report.setExportDelimiter(delimiter);
    }

    public void setExportNewlineDelimiter(int nlDelimiter) {
        this.report.setExportNewlineDelimiter(nlDelimiter);
    }

    public Vector<String> getExportedFiles() {
        return this.report.exportedFiles;
    }

    public void cleanExportedFiles() {
        this.report.exportedFiles = null;
    }

    @Deprecated
    public void setApplyExcelFormat(boolean state) {
        this.report.setApplyExcelFormat(state);
    }

    public void applyTemplate(String templatename) throws Exception {
        this.applyTemplate(templatename, false);
    }

    public void applyTemplate(String templatename, boolean applyFormula) throws Exception {
        this.report = this.loadTemplate(templatename, applyFormula, true);
    }

    public void applyTemplate(String templatename, boolean applyFormula, boolean applyEmptySection) throws Exception {
        this.report = this.loadTemplate(templatename, applyFormula, applyEmptySection);
    }

    public void applyTemplate(byte[] data, boolean isRPTFormat) throws Exception {
        this.report = this.loadTemplate(data, isRPTFormat);
    }

    Report loadTemplate(String templatename) throws Exception {
        return this.loadTemplate(templatename, false, true);
    }

    Report loadTemplate(String templatename, boolean applyFormula, boolean applyEmptySection) throws Exception {
        Report newreport = null;
        try {
            LoadReport loadReport = new LoadReport();
            loadReport.setCopyEmptySection(applyEmptySection);
            newreport = loadReport.loadTemplateFromFile(templatename, applyFormula, this.report);
        }
        catch (Exception ex) {
            this.errorMessage = IOUtil.getStackTrace(ex);
            throw new IOException(ex.toString());
        }
        return newreport;
    }

    Report loadTemplate(byte[] data, boolean isRPTFormat) throws Exception {
        Report newreport = null;
        try {
            if (isRPTFormat) {
                ByteArrayInputStream in = new ByteArrayInputStream(data);
                DataInputStream datain = new DataInputStream(in);
                newreport = new LoadReport().loadTemplate(this.report, datain);
                datain.close();
                in.close();
            } else {
                newreport = new LoadXMLReport().loadTemplateFromByteArray(data, this.report);
            }
        }
        catch (Exception ex) {
            this.errorMessage = IOUtil.getStackTrace(ex);
            throw new IOException(ex.toString());
        }
        return newreport;
    }

    private Report loadReportFromFile(String urlname, Vector<QueryInParamSet> parameters, Vector<Object[]> formulaParams, boolean isEnterpriseServer, boolean optimizeMemory, boolean useBackupData, String securityLevel, String relativeDomainPath, FileInMemTable subFilesTable) throws IOException {
        Report newreport = null;
        try {
            LoadReport ld = new LoadReport(false, optimizeMemory);
            ld.setSecurityLevel(securityLevel);
            ld.setBackupDataUsed(useBackupData);
            ld.setRelativeDomainPath(relativeDomainPath);
            ld.readOnly = true;
            if (subFilesTable != null) {
                ld.setSubFilesTable(subFilesTable);
            } else if (urlname.toLowerCase().endsWith(".pak")) {
                ld.getSubFilesTable().setTopName(urlname);
                ld.getSubFilesTable().setFileInMemEnabled(true);
            } else {
                ld.getSubFilesTable().setTopName(null);
                ld.getSubFilesTable().setFileInMemEnabled(false);
            }
            newreport = ld.loadReportFromFile(urlname, parameters, formulaParams, isEnterpriseServer, this.promptForParamValue);
            if (LCKey.isFree() && (newreport.getSubReports().length > 0 || newreport.currentNode.children().hasMoreElements() || newreport.getReportChartObjects().length > 0)) {
                throw new Exception("This report contains charts/subreports/drilldowns,\nand only can be opened in full version,\nplease contact sales@quadbase.com for more information.");
            }
            newreport.setNullDataOption(newreport.getNullDataOption(), true);
            Vector<DrillDownNode> childNodes = ld.getChildNodes();
            this.initDrillDownTree(newreport, ld.getDrillDownNode(), childNodes);
            this.setSubReports(newreport, ld.getSubReports());
            if (ld.getErrorMessage() != null) {
                this.errorMessage = ld.getErrorMessage();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.errorMessage = IOUtil.getStackTrace(ex);
            throw new IOException(ex.toString());
        }
        return newreport;
    }

    private Report loadReportFromByteArray(byte[] reportData, Vector<QueryInParamSet> parameters, Vector formulaParams, boolean isEnterpriseServer, boolean optimizeMemory, boolean useBackupData, String securityLevel, Hashtable<String, byte[]> rptTable) throws IOException {
        Report newreport = null;
        try {
            LoadReport ld = new LoadReport(false, optimizeMemory);
            ld.setSecurityLevel(securityLevel);
            ld.setBackupDataUsed(useBackupData);
            ld.setDrillDownReportTable(rptTable);
            ByteArrayInputStream bstream = new ByteArrayInputStream(reportData);
            DataInputStream inputstream = new DataInputStream(bstream);
            newreport = ld.loadReport(inputstream, parameters, formulaParams, isEnterpriseServer);
            newreport.setNullDataOption(newreport.getNullDataOption(), true);
            Vector<DrillDownNode> childNodes = ld.getChildNodes();
            this.initDrillDownTree(newreport, ld.getDrillDownNode(), childNodes);
            this.setSubReports(newreport, ld.getSubReports());
            if (LCKey.isFree() && (newreport.getSubReports().length > 0 || newreport.currentNode.children().hasMoreElements() || newreport.getReportChartObjects().length > 0)) {
                throw new Exception("This report contains charts/subreports/drilldowns,\nand only can be opened in full version,\nplease contact sales@quadbase.com for more information.");
            }
        }
        catch (Exception ex) {
            this.errorMessage = IOUtil.getStackTrace(ex);
            throw new IOException(ex.toString());
        }
        return newreport;
    }

    public final Object getParent() {
        return ServerMessage.getParent();
    }

    public final void setParent(Object parent) {
        ServerMessage.setParent(parent);
    }

    public final Frame getFrame() {
        return ServerMessage.getFrame();
    }

    public final void setFrame(Frame parent) {
        ServerMessage.setFrame(parent);
    }

    public final Applet getApplet() {
        return ServerMessage.getApplet();
    }

    public final void setApplet(Applet parent) {
        ServerMessage.setApplet(parent);
    }

    public final String getErrorMessage() {
        return this.errorMessage;
    }

    public ICustomDefinedFunctions getCustomDefinedFunctions() {
        return Report.getCustomDefinedFunctions();
    }

    public void setCustomDefinedFunctions(ICustomDefinedFunctions f) {
        Report.setCustomDefinedFunctions(f);
    }

    public final void loadFile(String fileName) throws IOException {
    }

    public Report getReportObj() {
        return this.report;
    }

    public final void setStringCustomizer(IStringCustomizer stringCustomizer) {
        this.report.setStringCustomizer(stringCustomizer);
    }

    public TableOfContents getTableOfContentsObject() {
        return this.report.getTableOfContentsObject();
    }

    public ReportSection getPageHeader() {
        return this.report.getPageHeader();
    }

    public void setPageHeader(ReportSection sec) {
        this.report.setPageHeader(sec);
    }

    public ReportSection getReportHeader() {
        return this.report.getReportHeader();
    }

    public void setReportHeader(ReportSection sec) {
        this.report.setReportHeader(sec);
    }

    public ReportSection getReportFooter() {
        return this.report.getReportFooter();
    }

    public void setReportFooter(ReportSection sec) {
        this.report.setReportFooter(sec);
    }

    public ReportSection getPageFooter() {
        return this.report.getPageFooter();
    }

    public void setPageFooter(ReportSection sec) {
        this.report.setPageFooter(sec);
    }

    public double getPageWidth() {
        return this.report.getPageWidth();
    }

    public void setPageWidth(double w) {
        this.report.setPageWidth(w);
    }

    public double getPageHeight() {
        return this.report.getPageHeight();
    }

    public void setPageHeight(double h) {
        this.report.setPageHeight(h);
    }

    public int getOrientation() {
        return this.report.getOrientation();
    }

    public void setOrientation(int orient) {
        this.report.setOrientation(orient, true);
    }

    public double getTopMargin() {
        return this.report.getTopMargin();
    }

    public void setTopMargin(double m) {
        this.report.setTopMargin(m);
    }

    public double getBottomMargin() {
        return this.report.getBottomMargin();
    }

    public void setBottomMargin(double m) {
        this.report.setBottomMargin(m);
    }

    public double getLeftMargin() {
        return this.report.getLeftMargin();
    }

    public void setLeftMargin(double m) {
        this.report.setLeftMargin(m);
    }

    public double getRightMargin() {
        return this.report.getRightMargin();
    }

    public void setRightMargin(double m) {
        this.report.setRightMargin(m);
    }

    public double getDHTMLTopMargin() {
        return this.report.getDHTMLTopMargin();
    }

    public void setDHTMLTopMargin(double m) {
        this.report.setDHTMLTopMargin(m);
    }

    public boolean isDHTMLTopMarginRepeatOnEveryPage() {
        return this.report.isDHTMLTopMarginRepeatOnEveryPage();
    }

    public void setDHTMLTopMarginRepeatOnEveryPage(boolean state) {
        this.report.setDHTMLTopMarginRepeatOnEveryPage(state);
    }

    public boolean isAdjustFont() {
        return this.report.isAdjustFont();
    }

    public void setAdjustFont(boolean state) {
        this.report.setAdjustFont(state);
    }

    public void setFontMapping(String fontName, int style, String ttf) {
        this.setFontMapping(fontName, style, ttf, null, true);
    }

    public void setFontMapping(String fontName, int style, String ttf, String encoding, boolean embed) {
        Hashtable<String, String> fontMapping = this.report.getFontMapping();
        if (fontMapping == null) {
            fontMapping = new Hashtable();
        }
        String key = fontName;
        key = style == 1 ? key + " BOLD" : (style == 2 ? key + " ITALIC" : (style == 3 ? key + " BOLDITALIC" : key + " PLAIN"));
        String fontStr = null;
        fontStr = encoding != null ? ttf + "&ENC=" + encoding + "&EMBED=" + (embed ? "TRUE" : "FALSE") : ttf;
        fontMapping.put(key, fontStr);
        this.report.setFontMapping(fontMapping);
    }

    public Hashtable<String, String> getFontMapping() {
        return this.report.getFontMapping();
    }

    public void setFontMapping(Hashtable<String, String> fontMapping) {
        this.report.setFontMapping(fontMapping);
    }

    public String[][] getRichTextFonts() {
        return this.report.getRichTextFonts();
    }

    public void setRichTextFonts(String[][] fontList) {
        this.report.setRichTextFonts(fontList);
    }

    public ReportTable getTable() {
        if (this.report.getReportTables().size() == 0) {
            return null;
        }
        return this.report.getReportTables().elementAt(0);
    }

    public FixedFieldCrossTabReport getFixedFieldCrossTabReport() {
        if (!this.report.crossTabFreeForm) {
            return new FixedFieldCrossTabReport(this.report);
        }
        return null;
    }

    public void preloadChartObjects() {
        quadbase.reportdesigner.report.ChartObject.preLoadCharts(this.report, null);
    }

    public void export(int format, String fileName) throws Exception {
        this.export(format, fileName, null, null, 3900);
    }

    public void export(int format, String fileName, boolean saveAllData) throws Exception {
        this.export(format, fileName, null, null, 3900, saveAllData);
    }

    public void export(int format, String fileName, String userPass, String ownerPass, int permissions) throws Exception {
        this.export(format, fileName, userPass, ownerPass, permissions, false, null);
    }

    public void export(int format, String fileName, String userPass, String ownerPass, int permissions, String javaScript) throws Exception {
        this.export(format, fileName, userPass, ownerPass, permissions, false, javaScript);
    }

    @Deprecated
    public void export(int format, String fileName, String userPass, String ownerPass, int permissions, boolean saveAllData) throws Exception {
        this.export(format, fileName, userPass, ownerPass, permissions, saveAllData, null);
    }

    private void export(int format, String fileName, String userPass, String ownerPass, int permissions, boolean saveAllData, String javaScript) throws Exception {
        Properties props = new Properties();
        if (userPass != null) {
            props.put("usrPass", userPass);
        }
        if (ownerPass != null) {
            props.put("ownerPass", ownerPass);
        }
        props.put("permission", permissions + "");
        props.put("saveAllData", saveAllData + "");
        if (javaScript != null) {
            props.put("javaScript", javaScript);
        }
        this.export(format, fileName, props, null);
    }

    public void export(int format, OutputStream out) throws Exception {
        this.export(format, out, false);
    }

    public void export(int format, OutputStream out, boolean skipFormatTable) throws Exception {
        this.export(format, out, null, null, 3900, false, null, null, skipFormatTable);
    }

    public void export(int format, OutputStream out, String filename) throws Exception {
        this.export(format, out, null, null, 3900, false, null, filename, false);
    }

    public void export(int format, OutputStream out, boolean saveAllData, boolean skipFormatTable) throws Exception {
        this.export(format, out, null, null, 3900, saveAllData, null, null, skipFormatTable);
    }

    public void export(int format, OutputStream out, String userPass, String ownerPass, int permissions) throws Exception {
        this.export(format, out, userPass, ownerPass, permissions, false, null);
    }

    public void export(int format, OutputStream out, String userPass, String ownerPass, int permissions, String javaScript) throws Exception {
        this.export(format, out, userPass, ownerPass, permissions, false, javaScript);
    }

    @Deprecated
    public void export(int format, OutputStream out, String userPass, String ownerPass, int permissions, boolean saveAllData) throws Exception {
        this.export(format, out, userPass, ownerPass, permissions, saveAllData, null);
    }

    private void export(int format, OutputStream out, String userPass, String ownerPass, int permissions, boolean saveAllData, String javaScript) throws Exception {
        this.export(format, out, userPass, ownerPass, permissions, saveAllData, javaScript, null, false);
    }

    public void export(int format, OutputStream out, String userPass, String ownerPass, int permissions, boolean saveAllData, String javaScript, String filename, boolean skipFormatTable) throws Exception {
        this.export(format, out, userPass, ownerPass, permissions, saveAllData, javaScript, filename, false, skipFormatTable);
    }

    public synchronized void export(int format, OutputStream out, String userPass, String ownerPass, int permissions, boolean saveAllData, String javaScript, String filename, boolean limitExcelCellSplit, boolean skipFormatTable) throws Exception {
        if (format == 1 || format == 15) {
            this.saveDrillDownReports(this.report.currentNode, true, saveAllData, this.report.getSubFilesTable());
            this.saveSubReports("TEMP", true, saveAllData, format);
            this.saveCharts("TEMP", true);
        } else {
            this.saveDrillDownReports(this.report.currentNode, false, saveAllData, this.report.getSubFilesTable());
        }
        if (this.root != null && this.report.currentNode.equals(this.root)) {
            if (this.getFileName() != null) {
                this.report.currentNode.setFileName(this.getFileName());
            }
            this.report.export(format, out, filename, this.report.currentNode, false, -1, userPass, ownerPass, permissions, saveAllData, null, javaScript, limitExcelCellSplit, skipFormatTable);
        } else {
            this.report.export(format, out, filename, null, false, -1, userPass, ownerPass, permissions, saveAllData, null, javaScript, limitExcelCellSplit, skipFormatTable);
        }
    }

    public void export(int format, OutputStream out, int exportPage) throws Exception {
        this.export(format, out, exportPage, null, null, 3900, false, null, false);
    }

    public void export(int format, OutputStream out, int exportPage, boolean saveAllData, boolean skipFormatTable) throws Exception {
        this.export(format, out, exportPage, null, null, 3900, saveAllData, null, skipFormatTable);
    }

    public void export(int format, OutputStream out, int exportPage, boolean saveAllData) throws Exception {
        this.export(format, out, exportPage, null, null, 3900, saveAllData);
    }

    public void export(int format, OutputStream out, int exportPage, String userPass, String ownerPass, int permissions, String javaScript) throws Exception {
        this.export(format, out, exportPage, userPass, ownerPass, permissions, false, javaScript, false);
    }

    @Deprecated
    public void export(int format, OutputStream out, int exportPage, String userPass, String ownerPass, int permissions, boolean saveAllData) throws Exception {
        this.export(format, out, exportPage, userPass, ownerPass, permissions, saveAllData, null, false);
    }

    private void export(int format, OutputStream out, int exportPage, String userPass, String ownerPass, int permissions, boolean saveAllData, String javaScript, boolean skipFormatTable) throws Exception {
        if (this.root != null && this.report.currentNode.equals(this.root)) {
            this.report.export(format, out, null, this.report.currentNode, true, exportPage, userPass, ownerPass, permissions, saveAllData, null, javaScript, false, skipFormatTable);
        } else {
            this.report.export(format, out, null, null, true, exportPage, userPass, ownerPass, permissions, saveAllData, null, javaScript, false, skipFormatTable);
        }
    }

    public void export(int format, OutputStream out, Properties prop, IExportThreadListener expListener) throws Exception {
        boolean skipFormatTable;
        String saveAllDataStr = prop.getProperty("saveAllData");
        String usrPassStr = prop.getProperty("usrPass");
        String ownerPassStr = prop.getProperty("ownerPass");
        String permissionStr = prop.getProperty("permission");
        String javaScriptStr = prop.getProperty("javaScript");
        String exportPageStr = prop.getProperty("exportPage");
        String skipFormatTableStr = prop.getProperty("skipFormatTable");
        String limitExcelCellSplitStr = prop.getProperty("limit excel cell split");
        boolean limitExcelCellSplit = limitExcelCellSplitStr == null ? false : Boolean.valueOf(limitExcelCellSplitStr);
        boolean saveAllData = saveAllDataStr == null ? false : Boolean.valueOf(saveAllDataStr);
        String userPass = usrPassStr == null ? "" : usrPassStr;
        String ownerPass = ownerPassStr == null ? "" : ownerPassStr;
        int permissions = permissionStr == null ? 3900 : Integer.parseInt(permissionStr);
        int exportPage = exportPageStr == null ? -1 : Integer.parseInt(exportPageStr);
        boolean bl = skipFormatTable = skipFormatTableStr == null ? false : Boolean.valueOf(skipFormatTableStr);
        if (this.root != null && this.report.currentNode.equals(this.root)) {
            this.report.export(format, out, null, this.report.currentNode, true, exportPage, userPass, ownerPass, permissions, saveAllData, expListener, javaScriptStr, limitExcelCellSplit, skipFormatTable);
        } else {
            this.report.export(format, out, null, null, true, exportPage, userPass, ownerPass, permissions, saveAllData, expListener, javaScriptStr, limitExcelCellSplit, skipFormatTable);
        }
    }

    public synchronized void export(int format, String fileName, Properties prop, IExportThreadListener expListener) throws Exception {
        boolean saveToNewFile;
        String saveAllDataStr = prop.getProperty("saveAllData");
        String usrPassStr = prop.getProperty("usrPass");
        String ownerPassStr = prop.getProperty("ownerPass");
        String permissionStr = prop.getProperty("permission");
        String javaScriptStr = prop.getProperty("javaScript");
        String exportPageStr = prop.getProperty("exportPage");
        String limitExcelCellSplitStr = prop.getProperty("limit excel cell split");
        boolean limitExcelCellSplit = limitExcelCellSplitStr == null ? false : Boolean.valueOf(limitExcelCellSplitStr);
        boolean saveAllData = saveAllDataStr == null ? false : Boolean.valueOf(saveAllDataStr);
        String pageViewer = prop.getProperty("pageViewer");
        boolean isPageViewer = pageViewer == null ? false : Boolean.valueOf(pageViewer);
        String userPass = usrPassStr == null ? "" : usrPassStr;
        String ownerPass = ownerPassStr == null ? "" : ownerPassStr;
        int permissions = permissionStr == null ? 3900 : Integer.parseInt(permissionStr);
        int exportPage = exportPageStr == null ? -1 : Integer.parseInt(exportPageStr);
        boolean bl = saveToNewFile = !fileName.replaceAll(".rpt", "").equals(this.report.currentNode.getFileName(this.report.getSubFilesTable()).replaceAll(".rpt", ""));
        if (this.report.currentNode.equals(this.root)) {
            this.report.rootNode = null;
        }
        if ((format == 1 || format == 8) && saveToNewFile) {
            if (!this.report.isDHTMLViewerUsed()) {
                this.report.currentNode.setFileName(fileName);
            }
            this.saveDrillDownReports(this.report.currentNode, true, saveAllData, this.report.getSubFilesTable());
        } else {
            if (!this.report.isDHTMLViewerUsed()) {
                this.report.currentNode.setFileName(fileName);
            }
            this.saveDrillDownReports(this.report.currentNode, false, saveAllData, this.report.getSubFilesTable());
        }
        if (format == 1 || format == 8) {
            this.saveSubReports(fileName, saveToNewFile, saveAllData, 1);
            this.saveCharts(fileName, saveToNewFile);
        } else if (format == 15) {
            this.saveSubReports(fileName, saveToNewFile, saveAllData, format);
        }
        if (this.root != null && this.report.currentNode.equals(this.root) && !isPageViewer) {
            if (this.getFileName() != null && !this.getFileName().equals("")) {
                this.report.currentNode.setFileName(this.getFileName());
            }
            this.report.export(format, fileName, this.report.currentNode, exportPage, userPass, ownerPass, permissions, saveAllData, expListener, javaScriptStr, limitExcelCellSplit);
        } else {
            this.report.export(format, fileName, null, exportPage, userPass, ownerPass, permissions, saveAllData, expListener, javaScriptStr, limitExcelCellSplit);
        }
    }

    public String getDHTMLHeader() {
        return "<meta http-equiv=\"Content-Style-Type\" content=\"text/css\" charset=\"UTF-8\">";
    }

    public boolean isHeadTagIncluded() {
        return this.report.isHeadTagIncluded();
    }

    public void setHeadTagIncluded(boolean b) {
        this.report.setHeadTagIncluded(b);
    }

    @Deprecated
    public String getHTMLParamPage(String reportLoc, int format) {
        return this.getHTMLParamPage(reportLoc, this.getSecurityLevel(), format, null);
    }

    @Deprecated
    public String getHTMLParamPage(String reportLoc, String securityLevel, int format) {
        return this.getHTMLParamPage(reportLoc, securityLevel, format, null);
    }

    @Deprecated
    public String getHTMLParamPage(String reportLoc, int format, String servletName) {
        return this.getHTMLParamPage(reportLoc, this.getSecurityLevel(), format, servletName);
    }

    @Deprecated
    public String getHTMLParamPage(String reportLoc, String securityLevel, int format, String servletName) {
        boolean isParamReport = this.getParamReport(reportLoc);
        if (servletName == null) {
            servletName = this.getParamReportServletName();
        }
        if (isParamReport) {
            ParameterPage paramPage = this.getParameterPage(reportLoc, securityLevel, format, servletName);
            if (paramPage == null) {
                return "";
            }
            StringWriter strBuf = new StringWriter(2048);
            BufferedWriter out = new BufferedWriter(strBuf);
            HtmlParameterPageWriter writer = new HtmlParameterPageWriter(paramPage, out);
            try {
                writer.writePage();
                out.flush();
                out.close();
                return strBuf.toString();
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    @Deprecated
    public String getHTMLParamPageBody(String reportLoc, int format) {
        return this.getHTMLParamPageBody(reportLoc, this.getSecurityLevel(), format, null);
    }

    @Deprecated
    public String getHTMLParamPageBody(String reportLoc, String securityLevel, int format) {
        return this.getHTMLParamPageBody(reportLoc, securityLevel, format, null);
    }

    @Deprecated
    public String getHTMLParamPageBody(String reportLoc, int format, String servletName) {
        return this.getHTMLParamPageBody(reportLoc, this.getSecurityLevel(), format, servletName);
    }

    @Deprecated
    public String getHTMLParamPageBody(String reportLoc, String securityLevel, int format, String servletName) {
        boolean isParamReport = this.getParamReport(reportLoc);
        if (servletName == null) {
            servletName = this.getParamReportServletName();
        }
        if (isParamReport) {
            ParameterPage paramPage = this.getParameterPage(reportLoc, securityLevel, format, servletName);
            if (paramPage == null) {
                return "";
            }
            StringWriter strBuf = new StringWriter(2048);
            BufferedWriter out = new BufferedWriter(strBuf);
            HtmlParameterPageWriter writer = new HtmlParameterPageWriter(paramPage, out);
            try {
                writer.writeBody();
                out.flush();
                out.close();
                return strBuf.toString();
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    @Deprecated
    public String getHTMLParamPageBlock() {
        boolean isParamReport = this.getParamReport(null);
        if (isParamReport) {
            ParameterPage paramPage = this.getParameterPage(null, null, -1, null);
            StringWriter strBuf = new StringWriter(2048);
            BufferedWriter out = new BufferedWriter(strBuf);
            HtmlParameterPageWriter writer = new HtmlParameterPageWriter(paramPage, out);
            try {
                writer.writeParamTable();
                out.flush();
                out.close();
                return strBuf.toString();
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    private boolean getParamReport(String reportLoc) {
        IInputData inputData;
        try {
            this.promptForParamValue = false;
            if (this.report == null) {
                this.report = this.loadReportFromFile(reportLoc, null, null, false, false, false, null, null, null);
            }
        }
        catch (IOException ie) {
            ie.printStackTrace();
        }
        boolean isParamReport = false;
        if (this.report != null && ((inputData = this.getInputData()).getDatabaseInfo() != null && inputData.getDatabaseInfo() instanceof quadbase.reportdesigner.util.IQueryFileInfo || this.report.getFormulaParameters() != null && this.report.getFormulaParameters().size() > 0)) {
            isParamReport = true;
        }
        return isParamReport;
    }

    private String getParamReportServletName() {
        String servletName = null;
        String servletDirectory = this.report.getServletDirectory();
        if (servletDirectory != null) {
            if (!(servletDirectory = servletDirectory.replace('\\', '/')).startsWith("/")) {
                servletDirectory = "/" + servletDirectory;
            }
            if (!servletDirectory.endsWith("/")) {
                servletDirectory = servletDirectory + "/";
            }
        } else {
            servletDirectory = "/servlet/";
        }
        servletName = this.report.isHttpsDynamicExport() ? "https://" + this.report.getHttpsServerName() + ":" + this.report.getHttpsServletRunnerPort() + servletDirectory + "ParamReportGeneratorServlet" : this.report.protocol + this.report.serverName + ":" + this.report.servletRunnerPort + servletDirectory + "ParamReportGeneratorServlet";
        return servletName;
    }

    public byte[] exportReportToByteArray() throws Exception {
        ByteArrayOutputStream fstream = new ByteArrayOutputStream(2048);
        this.export(1, fstream);
        fstream.close();
        return fstream.toByteArray();
    }

    public void setDynamicExport(boolean state, String serverName, int servletRunnerPort) {
        this.report.setDynamicExport(state, serverName, servletRunnerPort);
    }

    public void setDynamicExport(boolean state, String serverName, int servletRunnerPort, int timeoutDuration) {
        this.report.setDynamicExport(state, serverName, servletRunnerPort, timeoutDuration);
    }

    public void setDynamicExport(boolean state, boolean relativeUrlToServlets) {
        this.report.setDynamicExport(state, relativeUrlToServlets);
    }

    public void setHttpsDynamicExport(boolean state, String serverName, int servletRunnerPort) {
        this.report.setHttpsDynamicExport(state, serverName, servletRunnerPort);
    }

    public void setHttpsDynamicExport(boolean state, String serverName, int servletRunnerPort, int timeoutDuration) {
        this.report.setHttpsDynamicExport(state, serverName, servletRunnerPort, timeoutDuration);
    }

    public boolean isDynamicExport() {
        return this.report.isDynamicExport();
    }

    public boolean isHttpsDynamicExport() {
        return this.report.isHttpsDynamicExport();
    }

    public String exportReportToString() throws Exception {
        byte[] byte_array = this.exportReportToByteArray();
        StringBuffer temp = new StringBuffer(byte_array.length);
        for (byte element : byte_array) {
            temp = temp.append(element + " ");
        }
        return temp.toString();
    }

    public void draw(Graphics g, int page, int section) throws Exception {
        new ReportUI(this.report, g).draw(g, page, section);
    }

    public int getTotalPages(Graphics g) throws Exception {
        return new ReportUI(this.report, g).getTotalPages();
    }

    public int getTotalSections(Graphics g) throws Exception {
        return new ReportUI(this.report, g).getTotalSections();
    }

    public void autoFitColumns() {
        this.report.autoFitColumns();
    }

    public void printUsingAwtPrint(Frame frame, boolean showPageDialog, boolean showPrintDialog, int firstPage, int lastPage) throws Exception {
        PrintReport.printUsingAwtPrint(this.report, showPageDialog, showPrintDialog, firstPage, lastPage);
    }

    public void print(Frame frame) throws Exception {
        if (frame == null) {
            frame = new Frame();
        }
        new PrintReport(this.report, (Component)frame).print();
    }

    public void print(Graphics g) throws Exception {
        if (IOUtil.isJava2D()) {
            PrintReport.printUsingSwing(new ReportUI(this.report, g));
        } else {
            this.print();
        }
    }

    public void print() throws Exception {
        if (IOUtil.isJava2D()) {
            PrintReport.printUsingSwing(new ReportUI(this.report, IOUtil.getOffScreenGraphics()));
        } else {
            this.print(ServerMessage.getFrame() != null ? ServerMessage.getFrame() : new Frame());
        }
    }

    public void print(int firstPage, int lastPage) throws Exception {
        if (IOUtil.isJava2D()) {
            PrintReport.printUsingSwing(new ReportUI(this.report, IOUtil.getOffScreenGraphics()), firstPage, lastPage);
        } else {
            this.print(ServerMessage.getFrame() != null ? ServerMessage.getFrame() : new Frame());
        }
    }

    public void print(int firstPage, int lastPage, String preferredPrinter) throws Exception {
        this.print(firstPage, lastPage, preferredPrinter, 1);
    }

    public void print(int firstPage, int lastPage, String preferredPrinter, int numOfCopy) throws Exception {
        if (IOUtil.isJava2D()) {
            PrintReport.printUsingSwing(new ReportUI(this.report, IOUtil.getOffScreenGraphics()), firstPage, lastPage, preferredPrinter, numOfCopy);
        } else {
            this.print(ServerMessage.getFrame() != null ? ServerMessage.getFrame() : new Frame());
        }
    }

    public void print(int firstPage, int lastPage, Object printService, Object printRequestAttributeSet) throws Exception {
        this.print(firstPage, lastPage, printService, printRequestAttributeSet, 1);
    }

    public void print(int firstPage, int lastPage, Object printService, Object printRequestAttributeSet, int numOfCopy) throws Exception {
        if (IOUtil.isJava2D()) {
            PrintReport.printUsingSwing(new ReportUI(this.report, IOUtil.getOffScreenGraphics()), firstPage, lastPage, printService, printRequestAttributeSet, numOfCopy);
        } else {
            this.print(ServerMessage.getFrame() != null ? ServerMessage.getFrame() : new Frame());
        }
    }

    public String[] getAllAvailPrinters() {
        if (IOUtil.isJava14()) {
            return PrintUtil.getAvailPrinters();
        }
        return null;
    }

    public synchronized void setDisplayRow(int displayRow) throws Exception {
        Report newReport = null;
        this.report = newReport = ReloadReport.reloadData(this.report, true, null, 0, displayRow);
    }

    public synchronized void refresh() throws Exception {
        if (this.report.sourceData == 0 && this.spreadSheet != null) {
            this.report.setNewData(quadbase.reportdesigner.report.ColData.getColData(this.spreadSheet));
            return;
        }
        this.report = ReloadReport.reloadData(this.report, false);
        this.report.getQueryParameters();
    }

    public synchronized void refreshWithOriginalData() throws Exception {
        if (this.report.getOriginalSourceData() > 0) {
            this.report.sourceData = this.report.getOriginalSourceData();
        }
        this.refresh();
    }

    public synchronized void refreshWithSubReportsOriginalData() throws Exception {
        SubReportObject[] sroArray = this.getSubReports();
        if (sroArray != null) {
            for (SubReportObject sro : sroArray) {
                ((SubReport)sro.getSubReport()).refreshWithOriginalData();
            }
        }
        this.refreshWithOriginalData();
    }

    public void updateDataSource() {
        this.report.setOriginalSourceData(0);
    }

    public void setChartExportHTMLParameters(String dirLocation, String url, String fileName) {
        this.report.setChartExportHTMLParameters(dirLocation, url, fileName);
    }

    public String getChartPath() {
        return this.chartPath;
    }

    public void setChartPath(String path) {
        this.chartPath = path;
        this.report.setChartPath(path);
    }

    public String getImagePath() {
        return this.imagePath;
    }

    public void setImagePath(String path) {
        this.imagePath = path;
        this.report.setImagePath(path);
    }

    public String getSubReportPath() {
        return this.subReportPath;
    }

    public void setSubReportPath(String path) {
        this.subReportPath = path;
        this.report.setSubReportPath(path);
    }

    public void setDrillDownPath(String path, boolean isRoot) {
        this.drilldownPath = path;
        this.report.setDrillDownPath(path, isRoot);
    }

    public String getDrillDownPath() {
        return this.drilldownPath;
    }

    public void setDrillDownPath(String path) {
        this.setDrillDownPath(path, false);
    }

    public void setServletDirectory(String path) {
        this.report.setServletDirectory(path);
    }

    @Override
    public Report getReportInfo() {
        return this.getReportInfo(false);
    }

    @Override
    public Report getReportInfo(boolean forViewer) {
        try {
            if (forViewer) {
                this.saveDrillDownReports(this.report.currentNode, false, false, this.report.getSubFilesTable());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return this.report;
    }

    @Override
    public ReportElement getData(String id) {
        return this.report.getData(id);
    }

    public Locale getLocale() throws IllegalComponentStateException {
        if (this.report.getLocale() != null) {
            return this.report.getLocale();
        }
        return Locale.getDefault();
    }

    public void setLocale(Locale locale) {
        this.report.setLocale(locale);
    }

    public TimeZone getTimeZone() {
        if (this.report.getTimeZone() != null) {
            return this.report.getTimeZone();
        }
        return TimeZone.getDefault();
    }

    public void setTimeZone(TimeZone zone) {
        this.report.setTimeZone(zone);
    }

    public Object getNULLDataValue() {
        return this.report.getNullDataOption();
    }

    public void setNULLDataValue(String value) {
        if (value != null) {
            this.report.setNullDataOption(value, true);
        }
    }

    public Object getNumericNULLDataValue() {
        return this.report.getNullDataOption();
    }

    public void setNumericNULLDataValue(Object value) {
        if (value != null) {
            this.report.setNullDataOption(value.toString(), true);
        }
    }

    public Object getDateTimeNULLDataValue() {
        return this.report.getNullDataOption();
    }

    public void setDateTimeNULLDataValue(Object value) {
        if (value != null) {
            this.report.setNullDataOption(value.toString(), true);
        }
    }

    public Object getBooleanNULLDataValue() {
        return this.report.getNullDataOption();
    }

    public void setBooleanNULLDataValue(Object value) {
        if (value != null) {
            this.report.setNullDataOption(value.toString(), true);
        }
    }

    public String getStringNULLDataValue() {
        return this.report.getNullDataOption();
    }

    public void setStringNULLDataValue(String value) {
        if (value != null) {
            this.report.setNullDataOption(value, true);
        }
    }

    public final IInputData getInputData() {
        return new CInputData(this);
    }

    Object[] getValidRow(IRow r) {
        try {
            int l = this.report.getColData().length - 1;
            Object[] rec = new Object[l];
            for (int i = 1; i <= l; ++i) {
                rec[i - 1] = r.getObject(i);
            }
            return this.getValidRecord(rec);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Failed to read row : " + ex);
        }
    }

    Object[] getValidRecord(Object rec) {
        Object[] newRecord;
        if (rec == null || !(rec instanceof Object[])) {
            throw new IllegalArgumentException("Record must be instance of String array or Object array");
        }
        quadbase.reportdesigner.report.ColData[] colData = this.report.getColData();
        int len = colData.length - 1;
        if (rec instanceof String[]) {
            String[] sarray = (String[])rec;
            if (sarray.length != len) {
                throw new IllegalArgumentException("Record size must be equal to " + len);
            }
            newRecord = new Object[len];
            for (int i = 0; i < len; ++i) {
                newRecord[i] = DataType.createObject(sarray[i], colData[i].getDataType());
            }
        } else {
            newRecord = (Object[])rec;
            for (int i = 0; i < len; ++i) {
                if (DataType.match(colData[i].getOriginalDataType(), newRecord[i])) continue;
                throw new IllegalArgumentException("Record type mismatch in field " + i + ". Data Type must be " + DataType.getTypeName(colData[i].getOriginalDataType()));
            }
        }
        return newRecord;
    }

    int searchRecord(quadbase.reportdesigner.report.ColData[] cdata, String[] sarray) throws IllegalArgumentException {
        Object[] newRecord = this.getValidRecord(sarray);
        int size = cdata[0].getSize();
        for (int i = size - 1; i >= 0; --i) {
            boolean bfind = true;
            for (int j = 0; j < cdata.length - 1; ++j) {
                if (cdata[j].getData(i).toString().equals(newRecord[j].toString())) continue;
                bfind = false;
                break;
            }
            if (!bfind) continue;
            return i;
        }
        return -1;
    }

    String[] checkStrArr(Object value) throws IllegalArgumentException {
        String[] sarray;
        if (!(value instanceof String[])) {
            if (!(value instanceof Object[])) {
                throw new IllegalArgumentException("Value must be instance of String array or Object array");
            }
            Object[] objarr = (Object[])value;
            sarray = new String[objarr.length];
            for (int i = 0; i < sarray.length; ++i) {
                sarray[i] = objarr[i].toString();
            }
        } else {
            sarray = (String[])value;
        }
        return sarray;
    }

    protected void finalize() throws Throwable {
        try {
            ServerMessage.setComponent(null);
            if (this.report != null) {
                this.report.cleanup();
            }
        }
        finally {
            super.finalize();
        }
    }

    public void cleanup() throws Throwable {
        this.finalize();
    }

    public int getDrillDownReportCount() {
        if (this.report != null && this.report.currentNode != null) {
            return this.report.currentNode.getChildCount();
        }
        return 0;
    }

    public DrillDownReport getDrillDownReportAt(int index, boolean useBackupData) throws Exception {
        if (this.report != null && this.report.currentNode != null) {
            DrillDownNode node = this.report.currentNode.getChildAt(index);
            node.setDomainPath(this.report.domainPath);
            if (node.getDrillDownReport() != null) {
                return node.getDrillDownReport();
            }
            LoadReport lr = new LoadReport();
            lr.readOnly = true;
            lr.setBackupDataUsed(useBackupData);
            lr.setSubFilesTable(this.report.getSubFilesTable());
            lr.setRelativeDomainPath(this.report.domainPath);
            lr.setPromptParamValue(this.promptForParamValue);
            Report ddr = null;
            if (node.getByteArray() != null) {
                ddr = lr.loadReportFromByteArray(node.getByteArray());
            } else {
                ddr = lr.loadReportFromFile(node.getFileName(), null);
                ddr.currentNode = node;
            }
            DrillDownReport ret = new DrillDownReport(ddr);
            if (this.subReportPath != null) {
                ret.setSubReportPath(this.subReportPath);
            }
            if (this.drilldownPath != null) {
                ret.setDrillDownPath(this.drilldownPath);
            }
            if (this.chartPath != null) {
                ret.setChartPath(this.chartPath);
            }
            if (this.imagePath != null) {
                ret.setImagePath(this.imagePath);
            }
            ret.setPromptForParamValues(this.promptForParamValue);
            node.setDrillDownReport(ret);
            return ret;
        }
        return null;
    }

    public DrillDownReport getDrillDownReportAt(int index) throws Exception {
        return this.getDrillDownReportAt(index, false);
    }

    public DrillDownReport getDrillDownReport(String name, boolean useBackupData) throws Exception {
        if (this.report != null && this.report.currentNode != null) {
            for (int i = 0; i < this.report.currentNode.getChildCount(); ++i) {
                DrillDownNode node = this.report.currentNode.getChildAt(i);
                node.setDomainPath(this.report.domainPath);
                if (!node.getName().equals(name) && !node.getFileName().equals(name)) continue;
                if (node.getDrillDownReport() != null) {
                    return node.getDrillDownReport();
                }
                LoadReport lr = new LoadReport();
                lr.setSubFilesTable(this.getReportObj().getSubFilesTable());
                lr.readOnly = true;
                lr.setBackupDataUsed(useBackupData);
                Report ddr = null;
                if (node.getByteArray() != null) {
                    ddr = lr.loadReportFromByteArray(node.getByteArray());
                } else if (this.getReportObj().getSubFilesTable() != null && this.getReportObj().getSubFilesTable().containsKey(name)) {
                    ddr = lr.loadPakReportFromByteArray(name, this.getReportObj().getSubFilesTable().get(name));
                } else {
                    ddr = lr.loadReportFromFile(node.getFileName(), null);
                    ddr.currentNode = node;
                }
                DrillDownReport ret = new DrillDownReport(ddr);
                if (this.subReportPath != null) {
                    ret.setSubReportPath(this.subReportPath);
                }
                if (this.drilldownPath != null) {
                    ret.setDrillDownPath(this.drilldownPath);
                }
                if (this.chartPath != null) {
                    ret.setChartPath(this.chartPath);
                }
                if (this.imagePath != null) {
                    ret.setImagePath(this.imagePath);
                }
                node.setDrillDownReport(ret);
                return ret;
            }
        }
        return null;
    }

    public DrillDownReport getDrillDownReport(String name) throws Exception {
        return this.getDrillDownReport(name, false);
    }

    public DrillDownReport createDrillDownReport(String name, int reportType, quadbase.reportdesigner.util.IDatabaseInfo dbInfo, ColInfo[] mapping, String template, int[] columnMapping) throws Exception {
        return this.createDrillDownReport(name, reportType, dbInfo, mapping, template, columnMapping, true, false);
    }

    public DrillDownReport createDrillDownReport(String name, int reportType, quadbase.reportdesigner.util.IDatabaseInfo dbInfo, ColInfo[] mapping, String template, int[] columnMapping, boolean autoInsertDrillDownLink) throws Exception {
        return this.createDrillDownReport(name, reportType, dbInfo, mapping, template, columnMapping, autoInsertDrillDownLink, false);
    }

    public DrillDownReport createDrillDownReport(String name, int reportType, quadbase.reportdesigner.util.IDatabaseInfo dbInfo, ColInfo[] mapping, String template, int[] columnMapping, boolean autoInsertDrillDownLink, boolean sideBySideLayout) throws Exception {
        return this.createDrillDownReport(name, reportType, dbInfo, mapping, template, columnMapping, autoInsertDrillDownLink, sideBySideLayout, true);
    }

    public DrillDownReport createDrillDownReport(String name, int reportType, quadbase.reportdesigner.util.IDatabaseInfo dbInfo, ColInfo[] mapping, String template, int[] columnMapping, boolean autoInsertDrillDownLink, boolean sideBySideLayout, boolean prevParamPrompt) throws Exception {
        if (LCKey.isFree()) {
            throw new Exception("This feature is only included in full version, please contact sales@quadbase.com for more information.");
        }
        if (!(dbInfo instanceof quadbase.reportdesigner.util.IQueryFileInfo)) {
            throw new IllegalArgumentException("Drill-down reports must use a parameterized query.");
        }
        if (columnMapping.length != ((quadbase.reportdesigner.util.IQueryFileInfo)dbInfo).getInParam().length) {
            throw new IllegalArgumentException("The number of column mapping indices does not match the number of parameters in the query.");
        }
        for (int i = 0; i < this.report.currentNode.getChildCount(); ++i) {
            if (!this.report.currentNode.getChildAt(i).getName().equals(name)) continue;
            throw new IllegalArgumentException("A drill-down report already exists with the given name.");
        }
        DrillDownNode node = this.report.currentNode.createNewChild(name, this.report.getSubFilesTable());
        node.setColumnMapping(columnMapping);
        node.setSaved(false);
        try {
            DrillDownReport ret = new DrillDownReport();
            super.createFromIDatabaseInfo(ServerMessage.getParent(), reportType, dbInfo, mapping, template, true, sideBySideLayout, false);
            if (autoInsertDrillDownLink) {
                for (int element : columnMapping) {
                    if (element < 0) continue;
                    this.report.getReportTables().elementAt(0).getColumn(element).setDrillDownName(name);
                }
            }
            ret.report.currentNode = node;
            node.setDrillDownReport(ret);
            ret.getReportObj().isPrevParamPrompt = prevParamPrompt;
            return ret;
        }
        catch (Exception ex) {
            this.report.currentNode.remove(node);
            throw ex;
        }
    }

    public DrillDownReport createCrossTabDrillDownReport(String name, int reportType, quadbase.reportdesigner.util.IDatabaseInfo dbInfo, ColInfo[] mapping, String template, int[] columnMapping, boolean sideBySideLayout) throws Exception {
        if (LCKey.isFree()) {
            throw new Exception("This feature is only included in full version, please contact sales@quadbase.com for more information.");
        }
        if (!(dbInfo instanceof quadbase.reportdesigner.util.IQueryFileInfo)) {
            throw new IllegalArgumentException("Drill-down reports must use a parameterized query.");
        }
        if (columnMapping.length != ((quadbase.reportdesigner.util.IQueryFileInfo)dbInfo).getInParam().length) {
            throw new IllegalArgumentException("The number of column mapping indices does not match the number of parameters in the query.");
        }
        for (int i = 0; i < this.report.currentNode.getChildCount(); ++i) {
            if (!this.report.currentNode.getChildAt(i).getName().equals(name)) continue;
            throw new IllegalArgumentException("A drill-down report already exists with the given name.");
        }
        DrillDownNode node = this.report.currentNode.createNewChild(name, this.report.getSubFilesTable());
        node.setColumnMapping(columnMapping);
        node.setCrossTabDrillDown(true);
        node.setSaved(false);
        try {
            DrillDownReport ret = new DrillDownReport();
            super.createFromIDatabaseInfo(ServerMessage.getParent(), reportType, dbInfo, mapping, template, true, sideBySideLayout, false);
            for (int element : columnMapping) {
                ReportTable tbl = this.report.getReportTables().elementAt(0);
                if (!this.report.colInfo[element].isColumnBreak()) continue;
                for (int j = 0; j < tbl.getColumnCount(); ++j) {
                    if (this.report.getColInfoIndex(tbl.getColumn(j)) != element) continue;
                    tbl.getColumn(j).setDrillDownName(name);
                    this.report.colInfo[this.report.getColInfoIndex(tbl.getColumn(j))].setDrillDownName(name);
                }
            }
            ret.report.currentNode = node;
            node.setDrillDownReport(ret);
            return ret;
        }
        catch (Exception ex) {
            this.report.currentNode.remove(node);
            throw ex;
        }
    }

    protected void initDrillDownTree(Report r, DrillDownNode node) {
        this.initDrillDownTree(r, node, null);
    }

    protected void initDrillDownTree(Report r, DrillDownNode node, Vector<DrillDownNode> childNodes) {
        if (node != null) {
            this.root = node;
        } else {
            this.root = new DrillDownNode("ROOT");
            if (childNodes != null) {
                for (int i = 0; i < childNodes.size(); ++i) {
                    this.root.add(childNodes.elementAt(i));
                }
            }
        }
        if (r != null) {
            r.currentNode = this.root;
        }
    }

    private Report saveDrillDownReports(DrillDownNode parent, boolean updateFileName, boolean saveAllData, FileInMemTable subFilesTable) throws Exception {
        int i;
        if (LCKey.isFree() && parent.getChildCount() > 0) {
            throw new Exception("This feature is only included in full version, please contact sales@quadbase.com for more information.");
        }
        if (parent == null) {
            return null;
        }
        String parentName = parent.getFileName(subFilesTable);
        if (parent.getByteArray() == null && (parentName == null || parentName.length() == 0 || !Report.fileExists(subFilesTable, parentName) && !Report.fileExists(subFilesTable, parentName + ".rpt"))) {
            return null;
        }
        Report returnReport = null;
        Vector<DrillDownNode> children = new Vector<DrillDownNode>();
        for (i = 0; i < parent.getChildCount(); ++i) {
            children.addElement(parent.getChildAt(i));
        }
        parent.removeAllChildren();
        for (i = 0; i < children.size(); ++i) {
            int childs;
            DrillDownNode newChild = null;
            DrillDownNode oldChild = (DrillDownNode)children.elementAt(i);
            if (updateFileName || !oldChild.isSaved()) {
                newChild = parent.createNewChild(oldChild.getName(), subFilesTable);
                newChild.setColumnMapping(oldChild.getColumnMapping());
                newChild.setCrossTabDrillDown(oldChild.isCrossTabDrillDown());
                newChild.setDrillDownReport(oldChild.getDrillDownReport());
                newChild.setSaved(oldChild.isSaved());
                newChild.setByteArray(oldChild.getByteArray());
                for (int j = 0; j < oldChild.getChildCount(); ++j) {
                    oldChild.getChildAt(j).setParent(null);
                    newChild.add(oldChild.getChildAt(j));
                }
            } else {
                newChild = oldChild;
                parent.add(newChild);
            }
            if (newChild.getDrillDownReport() != null) {
                if (newChild.getByteArray() == null && !Report.fileExistsInMemoryTable(subFilesTable, newChild.getFileName())) {
                    super.saveSubReports(newChild.getFileName(subFilesTable), false, saveAllData, 1);
                    super.saveCharts(newChild.getFileName(subFilesTable), false);
                    newChild.getDrillDownReport().report.export(1, newChild.getFileName(subFilesTable), null, null, null, 3900, saveAllData, null);
                } else {
                    super.saveSubReports(newChild.getFileName(subFilesTable), false, saveAllData, 10);
                    super.saveCharts(newChild.getFileName(subFilesTable), false);
                    ByteArrayOutputStream fstream = new ByteArrayOutputStream(2048);
                    DataOutputStream out = new DataOutputStream(fstream);
                    newChild.getDrillDownReport().report.export(10, out, newChild.getFileName(subFilesTable), null, false, 0, null, null, 3900, saveAllData);
                    out.close();
                    fstream.close();
                    newChild.setByteArray(fstream.toByteArray());
                    newChild.getDrillDownReport().report.getSubFilesTable().put(newChild.getFileName(), newChild.getByteArray());
                }
                newChild.setSaved(true);
                returnReport = newChild.getDrillDownReport().report;
            } else if (updateFileName) {
                CopyFile.copy(this.getAbsolutePath(oldChild.getFileName(subFilesTable)), this.getAbsolutePath(newChild.getFileName(subFilesTable)));
            }
            if (returnReport != null) {
                newChild = returnReport.currentNode;
            }
            if ((childs = newChild.getChildCount()) <= 0) continue;
            this.saveDrillDownReports(newChild, updateFileName, saveAllData, subFilesTable);
        }
        return returnReport;
    }

    protected void setSubReports(Report r, Vector<SubReportObject> sr) {
        if (r != null) {
            r.subReports = sr;
        }
        this.subReports = sr;
    }

    public boolean isSubReport() {
        return false;
    }

    private void formatTable() {
        try {
            this.getTable().formatTable();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ReportImage[] getReportImages() {
        Vector images = new Vector();
        QbUtil.addArrayToVector(images, this.report.getPageHeader().getReportImages());
        QbUtil.addArrayToVector(images, this.report.getReportHeader().getReportImages());
        QbUtil.addArrayToVector(images, this.report.getReportFooter().getReportImages());
        QbUtil.addArrayToVector(images, this.report.getPageFooter().getReportImages());
        this.formatTable();
        Vector<ReportTable> reportTables = this.report.getReportTables();
        for (int i = 0; reportTables != null && i < reportTables.size(); ++i) {
            ReportTable tbl = reportTables.elementAt(i);
            QbUtil.addArrayToVector(images, tbl.getAllReportImages());
        }
        ReportImage[] temp = new ReportImage[images.size()];
        for (int i = 0; i < images.size(); ++i) {
            temp[i] = (ReportImage)images.elementAt(i);
        }
        return temp;
    }

    public int getReportImageCount() {
        return this.getReportImages().length;
    }

    public ReportImage getReportImageAt(int index) {
        ReportImage[] images = this.getReportImages();
        if (index < images.length) {
            return images[index];
        }
        return null;
    }

    public ReportImage[] getReportImages(ReportTableElement elt, boolean includeSubSection) {
        if (elt instanceof ReportSection) {
            return ((ReportSection)elt).getReportImages(includeSubSection);
        }
        if (elt instanceof ReportTable) {
            return ((ReportTable)elt).getAllReportImages();
        }
        return null;
    }

    public ReportChartObject[] getReportChartObjects() {
        return this.getReportChartObjects(true);
    }

    public ReportChartObject[] getReportChartObjects(boolean formatTable) {
        Vector charts = new Vector();
        QbUtil.addArrayToVector(charts, this.report.getPageHeader().getReportChartObjects());
        QbUtil.addArrayToVector(charts, this.report.getReportHeader().getReportChartObjects());
        QbUtil.addArrayToVector(charts, this.report.getReportFooter().getReportChartObjects());
        QbUtil.addArrayToVector(charts, this.report.getPageFooter().getReportChartObjects());
        if (formatTable) {
            this.formatTable();
        }
        Vector<ReportTable> reportTables = this.report.getReportTables();
        for (int i = 0; reportTables != null && i < reportTables.size(); ++i) {
            ReportTable tbl = reportTables.elementAt(i);
            QbUtil.addArrayToVector(charts, tbl.getAllReportChartObjects());
        }
        ReportChartObject[] temp = new ReportChartObject[charts.size()];
        for (int i = 0; i < charts.size(); ++i) {
            temp[i] = (ReportChartObject)charts.elementAt(i);
        }
        return temp;
    }

    public int getReportChartObjectCount() {
        return this.getReportChartObjects(false).length;
    }

    public ReportChartObject getReportChartObjectAt(int index) {
        return this.getReportChartObjectAt(index, true);
    }

    public ReportChartObject getReportChartObjectAt(int index, boolean formatTable) {
        ReportChartObject[] charts = this.getReportChartObjects(formatTable);
        if (index < charts.length) {
            return charts[index];
        }
        return null;
    }

    public ReportChartObject[] getReportChartObjects(ReportTableElement elt, boolean includeSubSection) {
        if (elt instanceof ReportSection) {
            return ((ReportSection)elt).getReportChartObjects(includeSubSection);
        }
        if (elt instanceof ReportTable) {
            return ((ReportTable)elt).getAllReportChartObjects();
        }
        return null;
    }

    public SubReportObject[] getSubReports() {
        return this.report.getSubReports();
    }

    public int getSubReportCount() {
        return this.getSubReports().length;
    }

    public SubReportObject getSubReportAt(int index) {
        SubReportObject[] sreports = this.getSubReports();
        if (index < sreports.length) {
            return sreports[index];
        }
        return null;
    }

    public SubReportObject[] getSubReports(ReportTableElement elt, boolean includeSubSection) {
        if (elt instanceof ReportSection) {
            return ((ReportSection)elt).getSubReports(includeSubSection);
        }
        if (elt instanceof ReportTable) {
            return ((ReportTable)elt).getAllSubReports();
        }
        return null;
    }

    @Deprecated
    public void removeSubReportAt(int index) {
        this.subReports.removeElementAt(index);
    }

    private void saveCharts(String filename, boolean updateFileName) throws Exception {
        ReportChartObject[] charts = this.getReportChartObjects();
        if (LCKey.isFree() && charts.length > 0) {
            throw new Exception("This feature is only included in full version, please contact sales@quadbase.com for more information.");
        }
        for (ReportChartObject chart : charts) {
            int format = 0;
            String chartFileName = chart.getText();
            if (updateFileName && chart.getChart() != null) {
                chartFileName = this.report != null ? chart.getNewChartName(this.report.getSubFilesTable(), filename) : chart.getNewChartName(null, filename);
            }
            if (chartFileName.toUpperCase().endsWith("CHT")) {
                format = 0;
            } else if (chartFileName.toUpperCase().endsWith("TPL")) {
                format = 5;
            } else if (chartFileName.toUpperCase().endsWith("PAC")) {
                format = 16;
            }
            chart.setText(chartFileName);
            if (chart.getChart() == null) continue;
            ((QbChart)chart.getChart()).export(format, chart.getText());
        }
    }

    private void saveSubReports(String filename, boolean updateFileName, boolean saveAllData, int format) throws Exception {
        if (LCKey.isFree() && this.getSubReports().length > 0) {
            throw new Exception("This feature is only included in full version, please contact sales@quadbase.com for more information.");
        }
        for (int i = 0; i < this.getSubReports().length; ++i) {
            SubReportObject curSR = this.getSubReports()[i];
            String newFileName = curSR.getFileName();
            if (curSR.getFileName() == null || curSR.getFileName().equals("") || updateFileName) {
                SubReportObject tempObj = new SubReportObject(filename, null, curSR.getDomainPath(), this.report.getSubFilesTable());
                tempObj.setDomainAndCheckForUniqueFileName(curSR.getDomainPath());
                newFileName = tempObj.getFileName();
                if (format == 10) {
                    newFileName = SaveReport.getPakFileName(newFileName);
                }
            }
            curSR.getSubReport((boolean)true, (boolean)false, (boolean)true, null).getReportInfo().subReports = null;
            DrillDownNode node = curSR.getSubReport((boolean)true, (boolean)false, (boolean)true, null).getReportInfo().currentNode;
            Report sreport = curSR.getSubReport(true, false, true, null).getReportInfo();
            if (format == 15) {
                sreport = curSR.hasUsableReport() ? (sreport.getQueryParams().size() != 0 ? curSR.reloadReportWithParameters(sreport, this.report, this.report.getReportTables().elementAt(0)) : curSR.loadReport(this.report, this.report.getReportTables().elementAt(0))) : curSR.loadReport(this.report, this.report.getReportTables().elementAt(0));
            }
            String absoluteNewFileName = this.getAbsolutePath(newFileName);
            if (sreport.parentNode != null) {
                sreport.parentNode.setFileName(filename);
            }
            QbReport qbreport = new QbReport(sreport);
            qbreport.saveCharts(filename, false);
            int ddCount = sreport.currentNode.getChildCount();
            if (ddCount > 0 && (format == 1 || format == 10)) {
                this.saveDrillDownReports(sreport.currentNode, false, saveAllData, this.report.getSubFilesTable());
            }
            if (format != 10) {
                sreport.export(format, absoluteNewFileName, node, null, null, 3900, saveAllData, null);
            }
            if (this.report == null) continue;
            String oldfilename = curSR.getFileName();
            if (oldfilename != null && oldfilename.equals("")) {
                curSR.setFileName(newFileName);
                continue;
            }
            this.report.updateSubReportFileName(curSR.getFileName(), newFileName);
        }
        this.report.getNonSharedAvailableSubReportParams();
    }

    private String getAbsolutePath(String newFileName) {
        String absoluteNewFileName = newFileName;
        if (!ServerMessage.useLoadBalancer || ServerMessage.isLoadBalancer) {
            absoluteNewFileName = ServerMessage.getPath(newFileName);
        } else {
            try {
                Class<?> organizerDataImplClass = Class.forName("quadbase.reportorganizer.data.OrganizerDataImpl");
                Method method = organizerDataImplClass.getMethod("getServletConnection", new Class[0]);
                URLConnection servletConnection = (URLConnection)method.invoke(null, new Object[0]);
                ObjectOutputStream servletOut = new ObjectOutputStream(servletConnection.getOutputStream());
                servletOut.writeInt(148);
                servletOut.writeObject(absoluteNewFileName);
                servletOut.flush();
                servletOut.close();
                ObjectInputStream servletIn = new ObjectInputStream(servletConnection.getInputStream());
                boolean success = servletIn.readBoolean();
                if (success) {
                    absoluteNewFileName = (String)servletIn.readObject();
                    servletIn.close();
                } else {
                    servletIn.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return absoluteNewFileName;
    }

    public void setReportObjectForSubReports(String filename, ISubReport rptobject) {
        if (this.report != null) {
            this.report.setReportObjectForSubReports(filename, rptobject);
        }
    }

    public void setColumnWrap(int x, int repeattime) {
        ColumnWrap wrap = this.report.getColumnWrap();
        if (wrap == null) {
            this.report.addColumnWrap(x, repeattime);
        } else {
            wrap.setX(x);
            wrap.setWrapCount(repeattime);
        }
    }

    public void resetColumnWrap() {
        this.report.resetColumnWrap();
    }

    public void setHTMLLinksProvider(IHTMLLinksProvider provider) {
        this.report.setHTMLLinksProvider(provider);
    }

    public void setDrillDownReportHashtable(Hashtable<String, byte[]> table) {
        this.report.setDrillDownReportHashtable(table);
    }

    public void sortByColumn(int colIndex, boolean isAsc) {
        try {
            this.getTable().formatTable();
            this.getTable().createIndexArray(colIndex, isAsc, this.report, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void sortByMultiColumn(int[] colIndex, boolean[] isAsc) {
        try {
            this.getTable().formatTable();
            this.getTable().createIndexArray(colIndex, 0, isAsc, this.report, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setFitGroupOnPage(boolean isFitGroupOnPage) {
        this.report.colInfo[this.report.breakColIndex[0]].setFitGroupOnPage(isFitGroupOnPage);
    }

    public int getReportType() {
        if (this.report == null) {
            return -1;
        }
        return this.report.getReportType();
    }

    public void addFormula(Formula formulaObj) {
        try {
            Vector<Vector<Formula>> formulaVec = new Vector<Vector<Formula>>();
            formulaVec.add(this.report.formulas);
            for (int j = 0; this.report.subReports != null && j < this.report.subReports.size(); ++j) {
                Report rpt = this.report.getSubReportArray()[j];
                if (rpt == null) continue;
                formulaVec.add(rpt.formulas);
            }
            ByteArrayInputStream inputStream = new ByteArrayInputStream(formulaObj.getText().getBytes("UTF-8"));
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)inputStream, "UTF-8");
            NewFormulaParser parser = new NewFormulaParser(inputStreamReader);
            formulaObj.setFormula(parser.parse(formulaVec, this.report.getQueryParameters(), this.report.getFormulaParameters(), formulaObj.getName()));
            this.report.formulas.addElement(formulaObj);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void addScript(Script scriptObj) {
        try {
            Vector<Vector<Formula>> formulaVec = new Vector<Vector<Formula>>();
            formulaVec.add(this.report.formulas);
            for (int j = 0; this.report.subReports != null && j < this.report.subReports.size(); ++j) {
                Report rpt = this.report.getSubReportArray()[j];
                if (rpt == null) continue;
                formulaVec.add(rpt.formulas);
            }
            ByteArrayInputStream inputStream = new ByteArrayInputStream(scriptObj.getText().getBytes("UTF-8"));
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)inputStream, "UTF-8");
            NewScriptParser parser = new NewScriptParser(inputStreamReader);
            scriptObj.setScript(parser.parse(formulaVec, this.report.getQueryParameters(), this.report.getFormulaParameters(), scriptObj.getName(), this.report));
            this.report.scripts.addElement(scriptObj);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void setFormulaScriptParamValue(String paramName, Object value) {
        for (int i = 0; i < this.report.getFormulaParameters().size(); ++i) {
            Parameter param = this.report.getFormulaParameters().elementAt(i);
            if (!param.getName().equals(paramName)) continue;
            param.setValue(value);
            break;
        }
    }

    public Color getBackgroundColor() {
        return this.report.getBackgroundColor();
    }

    public void setBackgroundColor(Color color) {
        this.report.setBackgroundColor(color);
    }

    public void createTopNReport(int sortColIndex, int topN, boolean ascending) {
        this.report.setTopN(topN);
        this.report.setAscending(ascending);
        this.report.colInfo[sortColIndex].setTopN(true);
    }

    public Vector<Parameter> getQueryParameters() {
        return this.report.getQueryParameters();
    }

    public Vector<Parameter> getFormulaParameters() {
        return this.report.getFormulaParameters();
    }

    public void promptFormulaParameters(Object object) {
        if (object instanceof Frame) {
            new EnterParamDialog((Frame)object, this.getReportObj(), null, this.getFormulaParameters(), true).setVisible(true);
        } else if (object instanceof Dialog) {
            new EnterParamDialog((Dialog)object, this.getReportObj(), null, this.getFormulaParameters(), true).setVisible(true);
        } else {
            new EnterParamDialog(new Frame(), this.getReportObj(), null, this.getFormulaParameters(), true).setVisible(true);
        }
    }

    public Object[] parseProperties(Properties props) {
        boolean sideBySideLayout = false;
        this.optimizeMemory = false;
        boolean multiPageExp = exportToMultiPages;
        boolean sorteddata = false;
        String securityLevel = null;
        boolean isEnterpriseServer = false;
        boolean useBackupData = false;
        boolean promptParamValue = true;
        boolean generateCrossTabGrandTotalColumn = true;
        boolean crossTabFreeForm = true;
        boolean addCrossTabSubTotalColumn = true;
        boolean crossTabSubTotalColumnPositionLeft = false;
        boolean addCrossTabFormula = true;
        boolean crossTabFormulaOnHeader = false;
        boolean crossTabColBkValAlignH = true;
        boolean limitExcelCellSplit = false;
        String reportStyle = null;
        String relativeDomainPath = null;
        this.isTransposed = false;
        this.transposeCol = null;
        if (props != null) {
            securityLevel = props.getProperty("security level");
            reportStyle = props.getProperty("report style");
            relativeDomainPath = props.getProperty("relative domain path");
            Enumeration<?> enum1 = props.propertyNames();
            while (enum1.hasMoreElements()) {
                String name;
                String value;
                Object obj = enum1.nextElement();
                if (!(obj instanceof String) || (value = props.get(name = (String)obj) != null ? props.get(name).toString() : null) == null) continue;
                if (name.equalsIgnoreCase("side by side layout") || name.equalsIgnoreCase("sidebysidelayout")) {
                    if (!value.equalsIgnoreCase("true") && !value.equalsIgnoreCase("t")) continue;
                    sideBySideLayout = true;
                    continue;
                }
                if (name.equalsIgnoreCase("optimize memory") || name.equalsIgnoreCase("optimizememory")) {
                    if (!value.equalsIgnoreCase("true") && !value.equalsIgnoreCase("t")) continue;
                    this.optimizeMemory = ServerMessage.performOptimizeMemory(true);
                    continue;
                }
                if (name.equalsIgnoreCase("multi-page export") || name.equalsIgnoreCase("multi-pageexport") || name.equalsIgnoreCase("multipage export") || name.equalsIgnoreCase("multipageexport")) {
                    if (!value.equalsIgnoreCase("true") && !value.equalsIgnoreCase("t")) continue;
                    multiPageExp = true;
                    continue;
                }
                if (name.equalsIgnoreCase("data sorted") || name.equalsIgnoreCase("datasorted")) {
                    if (!value.equalsIgnoreCase("true") && !value.equalsIgnoreCase("t")) continue;
                    sorteddata = true;
                    continue;
                }
                if (name.equalsIgnoreCase("enterprise server") || name.equalsIgnoreCase("isEnterpriseServer")) {
                    if (!value.equalsIgnoreCase("true") && !value.equalsIgnoreCase("t")) continue;
                    isEnterpriseServer = true;
                    continue;
                }
                if (name.equalsIgnoreCase("use backup data") || name.equalsIgnoreCase("useBackupData")) {
                    if (!value.equalsIgnoreCase("true") && !value.equalsIgnoreCase("t")) continue;
                    useBackupData = true;
                    continue;
                }
                if (name.equalsIgnoreCase("prompt parameter") || name.equalsIgnoreCase("promptParamValue")) {
                    if (!value.equalsIgnoreCase("false") && !value.equalsIgnoreCase("f")) continue;
                    promptParamValue = false;
                    continue;
                }
                if (name.equalsIgnoreCase("generateCrossTabGrandTotalColumn") || name.equalsIgnoreCase("crossTabRowSummaryColumn")) {
                    if (!value.equalsIgnoreCase("false") && !value.equalsIgnoreCase("f")) continue;
                    generateCrossTabGrandTotalColumn = false;
                    continue;
                }
                if (name.equalsIgnoreCase("crossTabFreeForm")) {
                    if (!value.equalsIgnoreCase("false") && !value.equalsIgnoreCase("f")) continue;
                    crossTabFreeForm = false;
                    continue;
                }
                if (name.equalsIgnoreCase("addCrossTabSubTotalColumn")) {
                    if (!value.equalsIgnoreCase("false") && !value.equalsIgnoreCase("f")) continue;
                    addCrossTabSubTotalColumn = false;
                    continue;
                }
                if (name.equalsIgnoreCase("crossTabSummaryPositionL")) {
                    if (!value.equalsIgnoreCase("true") && !value.equalsIgnoreCase("t")) continue;
                    crossTabSubTotalColumnPositionLeft = true;
                    continue;
                }
                if (name.equalsIgnoreCase("crossTabFormulaIncluded")) {
                    if (!value.equalsIgnoreCase("false") && !value.equalsIgnoreCase("f")) continue;
                    addCrossTabFormula = false;
                    continue;
                }
                if (addCrossTabFormula && name.equalsIgnoreCase("crossTabFormulaInHeader")) {
                    if (!value.equalsIgnoreCase("true") && !value.equalsIgnoreCase("t")) continue;
                    crossTabFormulaOnHeader = true;
                    continue;
                }
                if (name.equalsIgnoreCase("crossTabColBkValAlignH")) {
                    if (!value.equalsIgnoreCase("false") && !value.equalsIgnoreCase("f")) continue;
                    crossTabColBkValAlignH = false;
                    continue;
                }
                if (name.equalsIgnoreCase("transpose")) {
                    if (!value.equalsIgnoreCase("true") && !value.equalsIgnoreCase("t")) continue;
                    this.isTransposed = true;
                    continue;
                }
                if (name.equalsIgnoreCase("transposedColumn")) {
                    this.transposeCol = this.getTransposeColumn(props.getProperty(name));
                    continue;
                }
                if (name.equalsIgnoreCase("limit excel cell split")) {
                    if (!value.equalsIgnoreCase("true") && !value.equalsIgnoreCase("t")) continue;
                    limitExcelCellSplit = true;
                    continue;
                }
                if (name.equalsIgnoreCase("security level") || name.equalsIgnoreCase("relative domain path") || name.equalsIgnoreCase("report style")) continue;
                LOGGER.log(Level.WARNING, "Unsupported report property name \"" + name + "\"!");
            }
        }
        if (this.isTransposed) {
            sorteddata = false;
            this.optimizeMemory = false;
        }
        Object[] ret = new Object[19];
        ret[0] = sideBySideLayout;
        ret[1] = ServerMessage.performOptimizeMemory(this.optimizeMemory);
        ret[2] = multiPageExp;
        ret[3] = sorteddata;
        ret[4] = securityLevel;
        ret[5] = isEnterpriseServer;
        ret[6] = useBackupData;
        ret[7] = promptParamValue;
        ret[8] = generateCrossTabGrandTotalColumn;
        ret[9] = reportStyle;
        ret[10] = this.isTransposed;
        ret[11] = this.transposeCol;
        ret[12] = relativeDomainPath;
        ret[13] = crossTabFreeForm;
        ret[18] = addCrossTabSubTotalColumn;
        ret[14] = crossTabSubTotalColumnPositionLeft;
        ret[15] = crossTabFormulaOnHeader;
        ret[16] = crossTabColBkValAlignH;
        ret[17] = addCrossTabFormula;
        return ret;
    }

    private boolean[] getTransposeColumn(String s) {
        try {
            int ttype;
            if (s == null || s.equals("")) {
                return null;
            }
            Vector<Integer> vec = new Vector<Integer>();
            int max = -1;
            StreamTokenizer st = new StreamTokenizer(new StringReader(s));
            while ((ttype = st.nextToken()) != 10 && ttype != -1) {
                if (ttype == -2) {
                    if (st.nval > (double)max) {
                        max = (int)st.nval;
                    }
                    vec.addElement((int)st.nval);
                    continue;
                }
                throw new IllegalArgumentException("Format shall be \"n1 n2 n3 n4 ...\" where n1, n2..  . are integers");
            }
            if (max < 0) {
                return null;
            }
            boolean[] tmp = new boolean[max + 1];
            for (int j = 0; j < vec.size(); ++j) {
                tmp[((Integer)vec.elementAt((int)j)).intValue()] = true;
            }
            return tmp;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public void setSecurityLevel(String level, boolean refresh, boolean promptParam) throws Exception {
        if (!this.report.isValidSecurityLevel(level)) {
            level = null;
        }
        this.report.setPreviewSecurityLevel(level);
        if (refresh && this.report.getPreviewSecurityLevel() != null && this.report.getSecurityQueryParameterMap() != null && this.report.dbInfo != null && this.report.dbInfo instanceof QueryFileInfo) {
            quadbase.common.paramquery.QueryInParam[] masterParams = ((QueryFileInfo)this.report.dbInfo).getInSet().getParameter();
            quadbase.common.util.IQueryInParam[] securityParams = QueryParser.verifyParameters(masterParams, (quadbase.common.util.IQueryInParam[])this.report.getSecurityQueryParameterMap().get(this.report.getPreviewSecurityLevel()));
            Vector<quadbase.common.paramquery.QueryInParam> unselectedParameters = new Vector<quadbase.common.paramquery.QueryInParam>();
            if (securityParams != null) {
                for (int i = 0; i < masterParams.length; ++i) {
                    Vector<Object> obj = null;
                    if (masterParams[i] instanceof QueryMultiValueInParam) {
                        obj = ((QueryMultiValueInParam)securityParams[i]).getValues();
                        if (obj != null) {
                            ((QueryMultiValueInParam)masterParams[i]).setValues(obj);
                            continue;
                        }
                        if (!promptParam) continue;
                        unselectedParameters.addElement(masterParams[i]);
                        ((QueryMultiValueInParam)masterParams[i]).setValues(null);
                        continue;
                    }
                    obj = securityParams[i].getValue();
                    if (obj != null) {
                        masterParams[i].setValue(obj);
                        continue;
                    }
                    if (!promptParam) continue;
                    unselectedParameters.addElement(masterParams[i]);
                    masterParams[i].setValue(null);
                }
                if (unselectedParameters.size() > 0) {
                    quadbase.common.paramquery.QueryInParam[] unselectedParams = new quadbase.common.paramquery.QueryInParam[unselectedParameters.size()];
                    for (int i = 0; i < unselectedParams.length; ++i) {
                        unselectedParams[i] = (quadbase.common.paramquery.QueryInParam)unselectedParameters.elementAt(i);
                    }
                    QueryFileInfo reportqfi = (QueryFileInfo)this.report.dbInfo;
                    QueryFileInfo qfi = new QueryFileInfo(reportqfi.getProductName(), reportqfi.getVersion(), new DBInfoBasic(reportqfi.getURLString(), reportqfi.getDriverName(), reportqfi.getUserID(), reportqfi.getPassword(), reportqfi.getQuery(), reportqfi.getAdditionalDb()), new QueryInParamSet(unselectedParams));
                    QueryFileInfo.getParameter(qfi, false, false, true, false);
                }
                this.refreshWithOriginalData();
            } else {
                throw new Exception("Warning: The security query parameters for security level '" + level + "' do not match the actual query parameters.");
            }
        }
    }

    public String getSecurityLevel() {
        return this.report.getPreviewSecurityLevel();
    }

    public void setSecurityLevel(String level) throws Exception {
        this.setSecurityLevel(level, true, true);
    }

    public Hashtable<String, quadbase.common.paramquery.QueryInParam[]> getSecurityQueryParameterMap() {
        return this.report.getSecurityQueryParameterMap();
    }

    public void setSecurityQueryParameterMap(Hashtable<String, quadbase.common.paramquery.QueryInParam[]> table) {
        this.report.setSecurityQueryParameterMap(table);
    }

    public void setExportToSingleWPagination(boolean singleWPagination) {
        this.report.setExportToSingleWPagination(singleWPagination);
    }

    public void setExpandAndCollapseOptionForDHTML(boolean expAndCol, boolean defaultToExpandAll) {
        this.report.setExpandAndCollapseEnabled(expAndCol);
        this.report.setDefaultToExpandAll(defaultToExpandAll);
    }

    public void setExpandAndCollapseOptionForDHTML(boolean expAndCol, int expandLevelToGroupSectionIndex) {
        this.report.setExpandAndCollapseEnabled(expAndCol);
        this.report.setExpandGroupLevelTo(expandLevelToGroupSectionIndex);
    }

    public boolean isExpandAndCollapseOptionForDHTML() {
        return this.report.isExpandAndCollapseEnabled();
    }

    public boolean isDefaultToExpandAllForDHTML() {
        return this.report.isDefaultToExpandAll();
    }

    public int getExpandToGroupSectionIndex() {
        return this.report.getExpandGroupLevelTo();
    }

    public boolean isEmbeddedScriptWithInThePageForDHTML() {
        return this.report.isEmbeddedScriptWithInThePage();
    }

    public void setEmbeddedScriptWithInThePageForDHTML(boolean b) {
        this.report.setEmbeddedScriptWithInThePage(b);
    }

    public boolean isAnimationOnForExpandAndCollapse() {
        return this.report.isAnimationOnForExpandAndCollapse();
    }

    public void setAnimationOnForExpandAndCollapse(boolean b) {
        this.report.setAnimationOnForExpandAndCollapse(b);
    }

    public String getScriptReportNameForExpandAndCollapse() {
        return this.report.getExpandAndCollapseScriptName();
    }

    public void setScriptReportNameForExpandAndCollapse(String str) {
        this.report.setExpandAndCollapseScriptName(str);
    }

    public void setDHTMLBrowserMargin(double d) {
        DHTMLReport.setBrowserMargin(d);
    }

    public IDynamicImageURLGenerator getDynamicImageURLGenerator() {
        return this.report.getDynamicImageURLGenerator();
    }

    public void setDynamicImageURLGenerator(IDynamicImageURLGenerator generator) {
        this.report.setDynamicImageURLGenerator(generator);
    }

    public IDynamicReportKeyGenerator getDynamicReportKeyGenerator() {
        return this.report.getDynamicReportKeyGenerator();
    }

    public void setDynamicReportKeyGenerator(IDynamicReportKeyGenerator generator) {
        this.report.setDynamicReportKeyGenerator(generator);
    }

    public void setXMLEncoding(String enc) {
        ServerMessage.setXMLEncoding(enc);
    }

    public void setPaperSize(String size) {
        ServerMessage.setPaperSize(size);
    }

    public ParameterPage getParameterPage(String reportLoc, String securityLevel, int format, String servletName) {
        return this.getParameterPage(reportLoc, securityLevel, format, servletName, -1);
    }

    public ParameterPage getParameterPage(String reportLoc, String securityLevel, int format, String servletName, int order) {
        if (servletName == null) {
            servletName = this.getParamReportServletName();
        }
        return this.report.getParameterPage(reportLoc, securityLevel, format, servletName, order);
    }

    public ParameterPage getParameterPage(String reportLoc, int format) {
        return this.report.getParameterPage(reportLoc, null, format, null);
    }

    public void setSnapToGrid(boolean snapToGrid) {
        this.report.setSnapToGrid(snapToGrid, 0.1, 0.1);
    }

    public String getDescription(ReportElement elt) {
        if (elt != null) {
            return this.report.getDescription(elt);
        }
        return null;
    }

    public int getDataSourceType() {
        int type = this.report.sourceData;
        if (type == 1) {
            return 1;
        }
        if (type == 2) {
            return 2;
        }
        if (type == 4) {
            return 4;
        }
        if (type == 6) {
            return 6;
        }
        if (type == 7) {
            return 7;
        }
        if (type == 5) {
            return 5;
        }
        if (type == 0) {
            return 0;
        }
        if (type == 11) {
            return 11;
        }
        if (type == 13) {
            return 13;
        }
        if (type == 3) {
            return 3;
        }
        return -1;
    }

    public void setExportEncoding(String enc) {
        this.report.setExportEncoding(enc);
    }

    public void setHTMLCharset(String charset) {
        this.report.setHTMLCharset(charset);
    }

    @Deprecated
    public void setRTFEncoding(String enc) {
        this.report.setRTFEncoding(enc);
    }

    public boolean isUsing16ColorsForRTF() {
        return !this.report.isUsingAllColorsForRTF();
    }

    public void setUsing16ColorsForRTF(boolean b) {
        this.report.setUsingAllColorsForRTF(!b);
    }

    public void setSubReportsQueryParameter(Hashtable<String, Parameter[]> table) {
        this.report.setSubQueryParamTable(table);
    }

    public void setSubReportFormulaParameter(Hashtable<String, Parameter[]> table) {
        this.report.setSubFormulaParamTable(table);
    }

    public void setDrawBeforeExport(boolean state) {
        this.report.setDrawBeforeExport(state);
    }

    public Parameters getAllParameters() {
        return this.getAllParameters(false);
    }

    public Parameters getAllParameters(boolean ordered) {
        if (ordered) {
            return this.getReportObj().getParametersInSequence();
        }
        return ParameterGrabber.getParameters(this.getReportObj());
    }

    public ReportImage getBackgroundImage() {
        return this.report.getBackgroundImage();
    }

    public void setBackgroundImage(ReportImage c) {
        this.report.setBackgroundImage(c);
    }

    public void clearSubReportCache() {
        this.report.deleteSubReportColDataFiles();
    }

    public void setAutoClearSubReportCache(boolean b) {
        this.report.autoDelete = b;
    }

    public void setLimitSubReportQueryExecution(boolean b) {
        this.report.limitSubReportQueryExecution = b;
    }

    public void importFontMapping(String fontXml) {
        try {
            ImportFontMapping importFontMapping = new ImportFontMapping();
            Hashtable fontMapping = importFontMapping.importXML(fontXml);
            this.report.setFontMapping(fontMapping);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setDrillDownConnection(Object httpSession, Connection conn) {
        try {
            Class<?> sessionClass = httpSession.getClass();
            Method setAttributeMethod = sessionClass.getMethod("setAttribute", String.class, Object.class);
            setAttributeMethod.invoke(httpSession, "DRILLDOWNCONN", conn);
            this.report.setDrillDownConnection(conn);
        }
        catch (NoSuchMethodException ne) {
            ne.printStackTrace();
        }
        catch (IllegalAccessException ae) {
            ae.printStackTrace();
        }
        catch (InvocationTargetException ie) {
            ie.printStackTrace();
        }
    }

    public void setDrillDownDatabaseInfo(Object httpSession, String url, String driver, String usr, String pwd) {
        try {
            Class<?> sessionClass = httpSession.getClass();
            String[] database = new String[]{url, driver, usr, pwd};
            Method setAttributeMethod = sessionClass.getMethod("setAttribute", String.class, Object.class);
            setAttributeMethod.invoke(httpSession, "DRILLDOWNDATABASEINFO", database);
            this.report.setDrillDownDatabaseInfo(database);
        }
        catch (NoSuchMethodException ne) {
            ne.printStackTrace();
        }
        catch (IllegalAccessException ae) {
            ae.printStackTrace();
        }
        catch (InvocationTargetException ie) {
            ie.printStackTrace();
        }
    }

    public void setSFDrillDownDatabaseInfo(Object httpSession, String sessionid, String serverurl, String clientid) {
        try {
            Class<?> sessionClass = httpSession.getClass();
            String[] connection = new String[]{sessionid, serverurl, clientid};
            Method setAttributeMethod = sessionClass.getMethod("setAttribute", String.class, Object.class);
            setAttributeMethod.invoke(httpSession, "SFDRILLDOWNDATABASEINFO", connection);
        }
        catch (NoSuchMethodException ne) {
            ne.printStackTrace();
        }
        catch (IllegalAccessException ae) {
            ae.printStackTrace();
        }
        catch (InvocationTargetException ie) {
            ie.printStackTrace();
        }
    }

    public void setDataRegistryLocation(String location) throws Exception {
        this.report.dataSourceLoc = location;
    }

    public void setAllDataRegistryLocation(String location) throws Exception {
        SubReportObject[] subReportObjects;
        Report rpt = this.getReportObj();
        rpt.dataSourceLoc = location;
        for (SubReportObject subReportObject : subReportObjects = this.getSubReports()) {
            QbReport subReport = (QbReport)((Object)subReportObject.getSubReport(false, false, true, this));
            subReport.setAllDataRegistryLocation(location);
        }
        int numberOfDrillDowns = this.getDrillDownReportCount();
        for (int i = 0; i < numberOfDrillDowns; ++i) {
            DrillDownReport drillDownReport = this.getDrillDownReportAt(i, true);
            drillDownReport.setAllDataRegistryLocation(location);
        }
        this.setChartDataRegistryLocation(location);
    }

    void setChartDataRegistryLocation(String location) {
        ReportChartObject[] reportChartObjects = this.getReportChartObjects();
        for (int i = 0; i < reportChartObjects.length; ++i) {
            QbChart chart;
            if (reportChartObjects[i].isReportDataUsed() || (chart = (QbChart)reportChartObjects[i].getChartObject()) == null) continue;
            chart.getChart().dataSourceLoc = location;
        }
    }

    public void setExportNewlineDelimiter(String delim) {
        if (delim.equalsIgnoreCase("windows")) {
            this.report.setExportNewlineDelimiter(0);
        } else if (delim.equalsIgnoreCase("mac")) {
            this.report.setExportNewlineDelimiter(1);
        } else if (delim.equalsIgnoreCase("others")) {
            this.report.setExportNewlineDelimiter(2);
        } else if (delim.equalsIgnoreCase("system")) {
            this.report.setExportNewlineDelimiter(3);
        }
    }

    public void setInternalStyleSheetName(String name) {
        this.report.setInternalStyleSheetName(name);
    }

    public String getHTMLTarget() {
        return this.report.getHTMLTarget();
    }

    public void setHTMLTarget(String target) {
        this.report.setHTMLTarget(target);
    }

    public void setCenterDHTMLReport(boolean b) {
        this.report.setCenterDHTMLReport(b);
    }

    @Deprecated
    public void saveAs(String filename, String relativeDomainPath) {
        try {
            Report newReport = this.getReportObj();
            SaveReport saveReport = new SaveReport(newReport, false);
            boolean isPakFile = SaveReport.isPAKFile(filename);
            boolean isRptFile = SaveReport.isRPTFile(filename);
            if (isPakFile || isRptFile) {
                newReport.currentNode.setFileName(filename);
            } else {
                newReport.currentNode.setFileName(SaveReport.getRptFileName(filename));
            }
            if (!isPakFile) {
                this.copyChildNodes(newReport.currentNode, relativeDomainPath);
                this.resaveChildNodes(newReport.currentNode, relativeDomainPath);
                this.copySubReports(filename, relativeDomainPath);
            }
            saveReport.setDrillDownNode(newReport.currentNode);
            saveReport.setSubReports(this.subReports);
            saveReport.setSubFilesTable(newReport.getSubFilesTable());
            if (!isPakFile) {
                this.saveAllCharts(newReport, filename, relativeDomainPath);
            }
            this.saveToFile(saveReport, filename);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void copyChildNodes(DrillDownNode node, String relativeDomainPath) {
        int i;
        Vector<DrillDownNode> children = new Vector<DrillDownNode>();
        for (i = 0; i < node.getChildCount(); ++i) {
            children.addElement(node.getChildAt(i));
        }
        node.removeAllChildren();
        for (i = 0; i < children.size(); ++i) {
            DrillDownNode oldChild = (DrillDownNode)children.elementAt(i);
            DrillDownNode newChild = node.createNewChild(oldChild.getName(), this.report.getSubFilesTable());
            newChild.setCrossTabDrillDown(oldChild.isCrossTabDrillDown());
            newChild.setColumnMapping(oldChild.getColumnMapping());
            newChild.setDomainPath(relativeDomainPath);
            try {
                SaveReport sr;
                Report ddReport;
                LoadReport lr = new LoadReport(false);
                lr.setRelativeDomainPath(relativeDomainPath);
                lr.loadDataHeaderOnly(oldChild.getFileName());
                Vector<SubReportObject> childSRs = lr.getSubReports();
                if (childSRs == null || childSRs.size() <= 0) {
                    lr = new LoadReport(false);
                    lr.setRelativeDomainPath(relativeDomainPath);
                    lr.setBackupDataUsed(true);
                    ddReport = lr.loadReportFromFile(oldChild.getFileName());
                    ddReport.resetSourceData();
                    if (ddReport.rootNode != null) {
                        ddReport.rootNode.setFileName(node.getRoot().getFileName());
                    }
                    this.saveAllCharts(ddReport, newChild.getFileName(), relativeDomainPath);
                    sr = new SaveReport(ddReport, false);
                    sr.setSubReports(childSRs);
                    this.saveToFile(sr, newChild.getFileName());
                } else {
                    lr = new LoadReport(false);
                    lr.setRelativeDomainPath(relativeDomainPath);
                    lr.setBackupDataUsed(true);
                    ddReport = lr.loadReportFromFile(oldChild.getFileName());
                    ddReport.resetSourceData();
                    if (ddReport.rootNode != null) {
                        ddReport.rootNode.setFileName(node.getRoot().getFileName());
                    }
                    childSRs = lr.getSubReports();
                    this.copySubReports_Helper(newChild.getFileName(), ddReport, childSRs, relativeDomainPath);
                    this.saveAllCharts(ddReport, newChild.getFileName(), relativeDomainPath);
                    sr = new SaveReport(ddReport, false);
                    sr.setSubReports(childSRs);
                    this.saveToFile(sr, newChild.getFileName());
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if (oldChild.isLeaf()) continue;
            for (int j = 0; j < oldChild.getChildCount(); ++j) {
                newChild.add(oldChild.getChildAt(j));
            }
            this.copyChildNodes(newChild, relativeDomainPath);
        }
    }

    private void resaveChildNodes(DrillDownNode node, String relativeDomainPath) {
        int i;
        Vector<DrillDownNode> children = new Vector<DrillDownNode>();
        for (i = 0; i < node.getChildCount(); ++i) {
            children.addElement(node.getChildAt(i));
        }
        for (i = 0; i < children.size(); ++i) {
            DrillDownNode child = (DrillDownNode)children.elementAt(i);
            try {
                LoadReport lr = new LoadReport(false);
                lr.loadDataHeaderOnly(child.getFileName());
                lr = new LoadReport(false);
                lr.setBackupDataUsed(true);
                lr.setRelativeDomainPath(relativeDomainPath);
                Report ddReport = lr.loadReportFromFile(child.getFileName());
                ddReport.resetSourceData();
                Vector<SubReportObject> childSRs = lr.getSubReports();
                this.copySubReports_Helper(child.getFileName(), ddReport, childSRs, relativeDomainPath);
                if (child.getChildCount() > 0 || ddReport.currentNode.getChildCount() > 0) {
                    ddReport.currentNode.removeAllChildren();
                    for (int j = 0; j < child.getChildCount(); ++j) {
                        DrillDownNode newChild = child.getChildAt(j);
                        DrillDownNode copyNode = (DrillDownNode)newChild.clone();
                        ddReport.currentNode.add(copyNode);
                    }
                }
                this.saveAllCharts(ddReport, child.getFileName(), relativeDomainPath);
                SaveReport sr = new SaveReport(ddReport, false);
                sr.setSubReports(childSRs);
                this.saveToFile(sr, child.getFileName());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if (child.isLeaf()) continue;
            this.resaveChildNodes(child, relativeDomainPath);
        }
    }

    private void copySubReports(String newtitle, String relativeDomainPath) {
        this.copySubReports_Helper(newtitle, this.report, this.subReports, relativeDomainPath);
    }

    private void copySubReports_Helper(String newtitle, Report mainReport, Vector<SubReportObject> srVector, String relativeDomainPath) {
        if (srVector != null && srVector.size() > 0) {
            int i;
            String[] oldnames = new String[srVector.size()];
            String[] newnames = new String[srVector.size()];
            Vector<SubReportObject> newSubReportVector = new Vector<SubReportObject>();
            for (i = 0; i < srVector.size(); ++i) {
                SubReportObject newcell = new SubReportObject(newtitle, srVector.elementAt(i).getParamShareReportID(), relativeDomainPath, mainReport.getSubFilesTable());
                newcell.setParameterMap(srVector.elementAt(i).getParameterMap());
                newSubReportVector.addElement(newcell);
                oldnames[i] = srVector.elementAt(i).getFileName();
                newnames[i] = newcell.getFileName();
                int index = oldnames[i].lastIndexOf("_sub");
                String prefix_old = oldnames[i].substring(0, index);
                index = newnames[i].lastIndexOf("_sub");
                String prefix_new = newnames[i].substring(0, index);
                if (prefix_old.equals(prefix_new)) {
                    newnames[i] = oldnames[i].substring(0, oldnames[i].length() - 4) + newnames[i].substring(newnames[i].length() - 4);
                    newcell.setText(newnames[i]);
                    newcell.setFileName(newnames[i]);
                }
                try {
                    LoadReport lr = new LoadReport(false);
                    lr.setSubFilesTable(mainReport.getSubFilesTable());
                    lr.setBackupDataUsed(true);
                    lr.setRelativeDomainPath(relativeDomainPath);
                    Report subR = lr.loadReportFromFile(oldnames[i]);
                    if (subR.parentNode == null) {
                        subR.parentNode = new DrillDownNode();
                        subR.parentNode.setDomainPath(relativeDomainPath);
                    }
                    subR.parentNode.setFileName(newtitle);
                    subR.currentNode.setFileName(newnames[i]);
                    if (lr.getDrillDownNode() != null) {
                        this.copyChildNodes(lr.getDrillDownNode(), relativeDomainPath);
                    }
                    this.saveAllCharts(subR, newnames[i], relativeDomainPath);
                    SaveReport sr = new SaveReport(subR, false);
                    sr.setSubFilesTable(mainReport.getSubFilesTable());
                    sr.setDrillDownNode(lr.getDrillDownNode());
                    this.saveToFile(sr, newnames[i]);
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    CopyFile.copy(oldnames[i], newnames[i]);
                }
            }
            srVector.removeAllElements();
            for (i = 0; i < newSubReportVector.size(); ++i) {
                srVector.addElement((SubReportObject)newSubReportVector.elementAt(i));
            }
            mainReport.getReportHeader().renameSubReportFileNames(oldnames, newnames);
            mainReport.getPageHeader().renameSubReportFileNames(oldnames, newnames);
            mainReport.getPageFooter().renameSubReportFileNames(oldnames, newnames);
            mainReport.getReportFooter().renameSubReportFileNames(oldnames, newnames);
            ReportTable table = mainReport.getReportTables().elementAt(0);
            table.getHeader().renameSubReportFileNames(oldnames, newnames);
            table.getFooter().renameSubReportFileNames(oldnames, newnames);
            if (table instanceof ReportMultiSectionTable) {
                ReportMultiSectionTable mtbl = (ReportMultiSectionTable)table;
                for (int i2 = 0; i2 < mtbl.countRowBreakHeader(); ++i2) {
                    mtbl.getRowBreakHeader(i2).renameSubReportFileNames(oldnames, newnames);
                    mtbl.getRowBreakFooter(i2).renameSubReportFileNames(oldnames, newnames);
                }
            }
            table.renameSubReportFileNames(oldnames, newnames);
        }
    }

    void saveAllCharts(Report r, String name, String relativeDomainPath) {
        Vector<ReportChartObject> charts = r.getAllCharts();
        for (int i = 0; i < charts.size(); ++i) {
            String chartName = name;
            ReportChartObject cObj = charts.get(i);
            chartName = chartName.replaceAll("(?i)\\bsubreport[/\\\\]", "chart/");
            chartName = chartName.replaceAll("(?i)\\bdrilldown[/\\\\]", "chart/");
            chartName = chartName.replaceAll("(?i)\\breportfiles[/\\\\]", "chart/");
            chartName = chartName.replaceAll("(?i)\\btemplates[/\\\\]", "chart/");
            String ext = "";
            ext = cObj.getText().toLowerCase().endsWith(".tpl") ? ".tpl" : (cObj.getText().toLowerCase().endsWith(".pac") ? ".pac" : ".cht");
            if (chartName.toLowerCase().endsWith(".rpt") || chartName.toLowerCase().endsWith(".pak") || chartName.toLowerCase().endsWith(".qrp")) {
                chartName = chartName.substring(0, chartName.length() - 4);
            }
            try {
                int ct = i;
                while (new FileInfo(name + "_" + ct + ext).exists()) {
                    ++ct;
                }
                chartName = chartName + "_" + ct;
            }
            catch (Exception e) {
                e.printStackTrace();
                chartName = chartName + "_" + i;
            }
            QbChart chart = (QbChart)cObj.getChartObject();
            cObj.setText(chartName + ext);
            chart.saveAs(chartName + ext, relativeDomainPath, true);
        }
    }

    void saveToFile(SaveReport saveReport, String fileName) throws Exception {
        saveReport.saveToFile(fileName);
    }

    public String getFileName() {
        return this.filename;
    }

    public void setFileName(String fn) {
        this.filename = fn;
    }

    public double getMinPageHeight() {
        double minTableHeight;
        ReportCell[] rcs;
        double minHeight = 0.0;
        double sectHeight = 0.0;
        ReportSection sect = this.getPageHeader();
        sectHeight = this.getMaxHeightInSection(sect);
        int numOfVisibleElm = 0;
        for (ReportCell rc : rcs = sect.getCells()) {
            if (!rc.isVisible()) continue;
            ++numOfVisibleElm;
        }
        if (sectHeight < sect.getHeight() && numOfVisibleElm > 0) {
            sectHeight = sect.getHeight();
        }
        minHeight += sectHeight;
        sect = this.getPageFooter();
        sectHeight = this.getMaxHeightInSection(sect);
        numOfVisibleElm = 0;
        for (ReportCell rc : rcs = sect.getCells()) {
            if (!rc.isVisible()) continue;
            ++numOfVisibleElm;
        }
        if (sectHeight < sect.getHeight() && numOfVisibleElm > 0) {
            sectHeight = sect.getHeight();
        }
        minHeight += sectHeight;
        double maxElHeight = 0.0;
        sect = this.getReportHeader();
        sectHeight = this.getMaxHeightInSection(sect);
        if (sectHeight > maxElHeight) {
            maxElHeight = sectHeight;
        }
        if ((sectHeight = this.getMaxHeightInSection(sect = this.getReportFooter())) > maxElHeight) {
            maxElHeight = sectHeight;
        }
        if (maxElHeight < (minTableHeight = this.getTable().getMinHeight())) {
            maxElHeight = minTableHeight;
        }
        minHeight += maxElHeight;
        minHeight = minHeight + this.getTopMargin() + this.getBottomMargin();
        return minHeight;
    }

    private double getMaxHeightInSection(ReportSection sect) {
        ReportCell[] rcs = sect.getData(true);
        double minHeight = 0.0;
        for (int i = 0; i < rcs.length; ++i) {
            if (!rcs[i].isVisible()) continue;
            if (rcs[i] instanceof SubReportObject) {
                try {
                    QbReport subReport = (QbReport)((Object)((SubReportObject)rcs[i]).getSubReport(false, false, true, this));
                    double subHeight = subReport.getMinPageHeight();
                    if (!(subHeight > minHeight)) continue;
                    minHeight = subHeight;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (!(rcs[i].getHeight() > minHeight)) continue;
            minHeight = rcs[i].getHeight() + 0.1;
        }
        return minHeight;
    }

    public boolean isPromptForParamValues() {
        return this.promptForParamValue;
    }

    public void setPromptForParamValues(boolean prompt) {
        this.promptForParamValue = prompt;
    }

    @Override
    public String[] getAllAlertIds() {
        return this.report.getAllAlertIds();
    }

    @Override
    public String[] getTriggeredAlertIds() {
        return this.report.getTriggeredAlertIds();
    }

    @Override
    public Map<String, Vector<String>> getTriggeredAlertDetails() {
        return this.report.getTriggeredAlertDetails();
    }

    public void clearReportParameterValues() {
        Parameters ps = this.getAllParameters();
        for (int i = 0; i < ps.size(); ++i) {
            Param p = ps.get(i);
            p.setValue(null);
            p.setValues(null);
        }
    }

    public boolean isKeepDataSourceOrder() {
        return this.report.isKeepDataSourceOrder();
    }

    public void setKeepDataSourceOrder(boolean keepDataSourceOrder) {
        this.report.setKeepDataSourceOrder(keepDataSourceOrder);
    }

    class CInputData
    implements IInputData {
        QbReport qbReport;

        public CInputData(QbReport r) {
            this.qbReport = r;
        }

        @Override
        public final ColInfo[] getMapping() {
            return QbReport.this.report.colInfo;
        }

        @Override
        public final void setMapping(ColInfo[] colInfo) {
            QbReport.this.report.reCreateTable(QbReport.this.report.getReportType(), colInfo);
        }

        @Override
        public final quadbase.reportdesigner.util.IDatabaseInfo getDatabaseInfo() {
            if (QbReport.this.report.sourceData != 1 && QbReport.this.report.getOriginalSourceData() != 1 && QbReport.this.report.sourceData != 7 && QbReport.this.report.getOriginalSourceData() != 7 && QbReport.this.report.sourceData != 6 && QbReport.this.report.sourceData != 11 && QbReport.this.report.getOriginalSourceData() != 6 || QbReport.this.report.dbInfo == null) {
                return null;
            }
            if (QbReport.this.report.dbInfo instanceof IQbQueryFileInfo || QbReport.this.report.dbInfo instanceof QueryFileInfo) {
                return ReportUtil.cast2((IQueryFileInfo)((Object)QbReport.this.report.dbInfo));
            }
            if (QbReport.this.report.dbInfo instanceof IQueryFileInfo) {
                return ReportUtil.cast((IQueryFileInfo)((Object)QbReport.this.report.dbInfo));
            }
            return ReportUtil.cast(QbReport.this.report.dbInfo);
        }

        @Override
        public final void setDatabaseInfo(IDatabaseInfo dbinfo) throws Exception {
            this.setDatabaseInfo(dbinfo, true);
        }

        @Override
        public final void setDatabaseInfo(IDatabaseInfo dbinfo, boolean setNewData) throws Exception {
            this.setDatabaseInfo(dbinfo, setNewData, false);
        }

        @Override
        public final void setDatabaseInfo(IDatabaseInfo dbinfo, boolean setNewData, boolean sorteddata) throws Exception {
            if (QbReport.this.isUncompleteDBInfo(dbinfo)) {
                dbinfo = QbReport.this.fillDBInfo(dbinfo, QbReport.this.report.dbInfo);
            }
            if ((dbinfo.getDriverName() == null || dbinfo.getDriverName().equals("")) && dbinfo.getConnection() == null) {
                return;
            }
            this.checkParamQuery(dbinfo);
            quadbase.reportdesigner.report.ColData[] data = null;
            if (setNewData) {
                Object[] res = QbReport.this.setColData(sorteddata, dbinfo, this.getMapping(), false, QbReport.this.report.getReportType(), QbReport.this.optimizeMemory, QbReport.this.isEnterpriseServer);
                data = (quadbase.reportdesigner.report.ColData[])res[0];
                sorteddata = (Boolean)res[2];
            }
            if (dbinfo instanceof quadbase.reportdesigner.util.IQueryFileInfo) {
                QbReport.this.report.queryFilename = null;
                QbReport.this.report.dbInfo = new QueryFileInfo((quadbase.reportdesigner.util.IQueryFileInfo)dbinfo, setNewData);
            } else {
                QbReport.this.report.queryFilename = null;
                QbReport.this.report.setQueryFileInfo(null);
                QbReport.this.report.dbInfo = new DBInfo(dbinfo);
            }
            if (setNewData) {
                String domainPath = QbReport.this.report.domainPath;
                QbReport.this.report = QbReport.this.report.setNewData(data, sorteddata);
                QbReport.this.report.domainPath = domainPath;
            }
            QbReport.this.report.sourceData = 1;
            QbReport.this.report.colDataSorted = sorteddata;
            if (QbReport.this.filename != null && !SaveReport.isPAKFile(QbReport.this.filename)) {
                SaveReport sr = new SaveReport(QbReport.this.report);
                sr.setSubFilesTable(QbReport.this.report.getSubFilesTable());
                sr.saveToOutput(QbReport.this.filename, false);
            }
        }

        @Override
        public void setAllDatabaseInfo(String url, String driver, String usr, String pwd) throws Exception {
            this.setDatabaseInfo(this.qbReport, url, driver, usr, pwd, null, true, true, false);
        }

        @Override
        public void setAllDatabaseInfo(String url, String driver, String usr, String pwd, boolean setNewData) throws Exception {
            this.setDatabaseInfo(this.qbReport, url, driver, usr, pwd, null, true, setNewData, false);
        }

        @Override
        public void setAllDatabaseInfo(String url, String driver, String usr, String pwd, boolean setNewData, boolean sorteddata) throws Exception {
            this.setDatabaseInfo(this.qbReport, url, driver, usr, pwd, null, true, setNewData, sorteddata);
        }

        @Override
        public void setAllDatabaseInfo(Connection conn) throws Exception {
            this.setDatabaseInfo(this.qbReport, null, null, null, null, conn, true, true, false);
        }

        @Override
        public void setAllDatabaseInfo(Connection conn, boolean setNewData) throws Exception {
            this.setDatabaseInfo(this.qbReport, null, null, null, null, conn, true, setNewData, false);
        }

        @Override
        public void setAllDatabaseInfo(Connection conn, boolean setNewData, boolean sorteddata) throws Exception {
            this.setDatabaseInfo(this.qbReport, null, null, null, null, conn, true, setNewData, sorteddata);
        }

        void setDatabaseInfo(QbReport qbReport, String url, String driver, String usr, String pwd, Connection conn, boolean rootReport, boolean setNewData, boolean sorteddata) throws Exception {
            Parameters newParams;
            SubReportObject[] sroArray;
            Parameters myParams = null;
            if (rootReport) {
                myParams = qbReport.getAllParameters(true);
            }
            IInputData inputData = qbReport.getInputData();
            quadbase.reportdesigner.util.IDatabaseInfo databaseInfo = inputData.getDatabaseInfo();
            String dbquery = databaseInfo.getQuery();
            boolean isPakFile = SaveReport.isPAKFile(qbReport.getFileName());
            if (databaseInfo instanceof quadbase.reportdesigner.util.IQueryFileInfo) {
                quadbase.reportdesigner.util.IQueryInParam[] paramSet = ((quadbase.reportdesigner.util.IQueryFileInfo)databaseInfo).getInParam();
                SimpleQueryFileInfo newDatabaseInfo = conn == null ? new SimpleQueryFileInfo(url, driver, usr, pwd, dbquery) : new SimpleQueryFileInfo(conn, dbquery);
                newDatabaseInfo.setInParam(paramSet);
                if (databaseInfo instanceof IQbQueryFileInfo) {
                    quadbase.reportdesigner.util.IQueryInParam[][] parameterInPromptSequence = ((IQbQueryFileInfo)databaseInfo).getParameterInPromptSequence();
                    newDatabaseInfo.setParameterInPromptSequence(parameterInPromptSequence);
                }
                inputData.setDatabaseInfo(newDatabaseInfo, setNewData, sorteddata);
            } else {
                DBInfo newDatabaseInfo = conn == null ? new DBInfo(url, driver, usr, pwd, dbquery) : new DBInfo(conn, dbquery);
                inputData.setDatabaseInfo(newDatabaseInfo, setNewData, sorteddata);
            }
            this.setChartDatabaseInfo(qbReport, url, driver, usr, pwd, conn, setNewData);
            Vector<SubReportObject> subReportObjects = qbReport.getReportObj().subReports;
            if (subReportObjects != null) {
                for (int i = 0; i < subReportObjects.size(); ++i) {
                    SubReportObject sro = subReportObjects.elementAt(i);
                    if (!isPakFile && SaveReport.isPAKFile(sro.getFileName())) {
                        sro.setFileName(SaveReport.getRptFileName(sro.getFileName()));
                    }
                    this.updateAndSaveSubReportDataSource(qbReport, url, driver, usr, pwd, conn, setNewData, sorteddata, sro);
                }
            }
            if ((sroArray = qbReport.getSubReports()) != null) {
                for (SubReportObject sro : sroArray) {
                    if (!isPakFile && SaveReport.isPAKFile(sro.getFileName())) {
                        sro.setFileName(SaveReport.getRptFileName(sro.getFileName()));
                    }
                    this.updateAndSaveSubReportDataSource(qbReport, url, driver, usr, pwd, conn, setNewData, sorteddata, sro);
                }
            }
            qbReport.getReportObj().useBackupData = false;
            int numberOfDrillDowns = qbReport.getDrillDownReportCount();
            for (int i = 0; i < numberOfDrillDowns; ++i) {
                DrillDownNode node = qbReport.report.currentNode.getChildAt(i);
                if (!isPakFile && SaveReport.isPAKFile(node.getFileName())) {
                    node.setFileName(SaveReport.getRptFileName(node.getFileName()));
                }
                DrillDownReport drillDownReport = qbReport.getDrillDownReportAt(i, true);
                this.setDatabaseInfo(drillDownReport, url, driver, usr, pwd, conn, false, setNewData, sorteddata);
                FileInMemTable subFilesTable = QbReport.this.report.getSubFilesTable();
                Report ddR = drillDownReport.getReportObj();
                SaveReport sr = new SaveReport(ddR);
                sr.setSubFilesTable(subFilesTable);
                sr.saveToOutput(node.getFileName(), false);
                if (subFilesTable == null || !subFilesTable.containsKey(node.getFileName())) continue;
                node.setByteArray(subFilesTable.get(node.getFileName()));
            }
            if (rootReport && (newParams = qbReport.getAllParameters(true)).size() > 0 && myParams != null) {
                for (int i = 0; i < newParams.size(); ++i) {
                    Param currentParam = newParams.get(i);
                    if (currentParam.multiValue()) {
                        currentParam.setValues(myParams.get(i).getValues());
                        continue;
                    }
                    currentParam.setValue(myParams.get(i).getValue());
                }
            }
        }

        private void updateAndSaveSubReportDataSource(QbReport qbReport, String url, String driver, String usr, String pwd, Connection conn, boolean setNewData, boolean sorteddata, SubReportObject sro) throws Exception {
            QbReport subReport = (QbReport)((Object)sro.getSubReport(false, false, true, qbReport));
            this.setDatabaseInfo(subReport, url, driver, usr, pwd, conn, false, setNewData, sorteddata);
            SaveReport sr = new SaveReport(subReport.getReportObj());
            sr.generatePAKFile(SaveReport.isPAKFile(sro.getFileName()));
            sr.setSubFilesTable(QbReport.this.report.getSubFilesTable());
            sr.setDrillDownNode(subReport.getReportObj().currentNode);
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DataOutputStream dout = new DataOutputStream(bout);
            sr.saveData(dout);
            sro.setByteArray(bout.toByteArray());
            sr.saveToOutput(sro.getFileName(), false);
            sro.clearReportCache(1.0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setChartDatabaseInfo(QbReport qbReport, String url, String driver, String usr, String pwd, Connection conn, boolean setNewData) {
            ReportChartObject[] reportChartObjects = qbReport.getReportChartObjects();
            for (int i = 0; i < reportChartObjects.length; ++i) {
                String chartLocation1;
                if (reportChartObjects[i].isReportDataUsed()) continue;
                if (QbReport.this.chartPath != null) {
                    chartLocation1 = QbReport.this.chartPath + QbUtil.getFileName(reportChartObjects[i].getText());
                } else {
                    File file = new File(reportChartObjects[i].getText());
                    if (file.isAbsolute()) {
                        chartLocation1 = reportChartObjects[i].getText();
                    } else {
                        reportChartObjects[i].setDomainPath(qbReport.report.domainPath);
                        chartLocation1 = reportChartObjects[i].getText();
                    }
                }
                QbChart tempChart = null;
                Properties props = new Properties();
                props.put("prompt parameter", "false");
                props.put("use backup data", "true");
                boolean isTemplate = reportChartObjects[i].getText().toUpperCase().endsWith(".TPL");
                if (reportChartObjects[i].getBytes() != null) {
                    try {
                        tempChart = new QbChart((Applet)null, reportChartObjects[i].getBytes(), isTemplate, props);
                    }
                    catch (Exception e) {
                        System.out.println("Following error occured when attempting to use Chart bytes...\n" + e.getMessage() + "\nAttempting to find chart from path.");
                        tempChart = new QbChart((Applet)null, chartLocation1, null, props);
                    }
                } else {
                    tempChart = !qbReport.promptForParamValue ? new QbChart((Applet)null, chartLocation1, null, props) : new QbChart((Applet)null, chartLocation1);
                    if (tempChart.getChart().sourceData != 1 && tempChart.getChart().getOriginalSourceData() != 1) {
                        return;
                    }
                }
                String chartQuery = tempChart.gethInputData().getDatabaseInfo().getQuery();
                ChartModifier chartMod = new ChartModifier(url, driver, usr, pwd, chartQuery, conn);
                reportChartObjects[i].setChartModifier(chartMod);
                reportChartObjects[i].setChart(chartMod.modifyChart(tempChart.getChart(), setNewData));
                if (!SaveReport.isPAKFile(qbReport.getFileName()) || qbReport.report.getSubFilesTable() == null) continue;
                SaveChart saveChart = new SaveChart(tempChart.getChart());
                ByteArrayOutputStream baoStream = new ByteArrayOutputStream(2048);
                DataOutputStream out = new DataOutputStream(baoStream);
                try {
                    saveChart.saveToDataOutput(out, isTemplate);
                }
                catch (IOException e) {
                    LOGGER.log(Level.SEVERE, "Cannot save chart to dataOutputStream!\n" + e.getMessage());
                }
                finally {
                    CloseUtils.close(out);
                    CloseUtils.close(baoStream);
                }
                qbReport.report.getSubFilesTable().put(chartLocation1, baoStream.toByteArray());
            }
        }

        public Chart openChart(InputStream instream, ColData[] colData, boolean isTemplate, Vector preSetParams) throws Exception {
            LoadChart loadChart = new LoadChart();
            loadChart.setParameterField(preSetParams);
            return loadChart.loadChartFromReport(new DataInputStream(instream), colData, isTemplate);
        }

        void replaceDatabaseInfo(QbReport qbReport, String originalUrl, String url, String driver, String usr, String pwd, Connection conn, boolean rootReport, boolean setNewData, boolean sorteddata) throws Exception {
            Parameters newParams;
            Parameters myParams = null;
            if (rootReport) {
                myParams = qbReport.getAllParameters(true);
            }
            IInputData inputData = qbReport.getInputData();
            quadbase.reportdesigner.util.IDatabaseInfo databaseInfo = inputData.getDatabaseInfo();
            String dbquery = databaseInfo.getQuery();
            if (databaseInfo.getURLString().equals(originalUrl)) {
                if (databaseInfo instanceof quadbase.reportdesigner.util.IQueryFileInfo) {
                    quadbase.reportdesigner.util.IQueryInParam[] paramSet = ((quadbase.reportdesigner.util.IQueryFileInfo)databaseInfo).getInParam();
                    SimpleQueryFileInfo newDatabaseInfo = conn == null ? new SimpleQueryFileInfo(url, driver, usr, pwd, dbquery) : new SimpleQueryFileInfo(conn, dbquery);
                    newDatabaseInfo.setInParam(paramSet);
                    inputData.setDatabaseInfo(newDatabaseInfo, setNewData, sorteddata);
                } else {
                    DBInfo newDatabaseInfo = conn == null ? new DBInfo(url, driver, usr, pwd, dbquery) : new DBInfo(conn, dbquery);
                    inputData.setDatabaseInfo(newDatabaseInfo, setNewData, sorteddata);
                }
            }
            this.replaceChartDatabaseInfo(qbReport, originalUrl, url, driver, usr, pwd, conn);
            Vector<SubReportObject> subReportObjects = qbReport.getReportObj().subReports;
            for (int i = 0; subReportObjects != null && i < subReportObjects.size(); ++i) {
                SubReportObject sro = subReportObjects.elementAt(i);
                QbReport subReport = (QbReport)((Object)sro.getSubReport(false, false, true, qbReport));
                this.replaceDatabaseInfo(subReport, originalUrl, url, driver, usr, pwd, conn, false, setNewData, sorteddata);
                SaveReport sr = new SaveReport(subReport.getReportObj());
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                DataOutputStream dout = new DataOutputStream(bout);
                sr.saveData(dout);
                sro.setByteArray(bout.toByteArray());
                sro.clearReportCache(1.0);
            }
            qbReport.getReportObj().useBackupData = false;
            int numberOfDrillDowns = qbReport.getDrillDownReportCount();
            for (int i = 0; i < numberOfDrillDowns; ++i) {
                DrillDownReport drillDownReport = qbReport.getDrillDownReportAt(i, true);
                this.replaceDatabaseInfo(drillDownReport, originalUrl, url, driver, usr, pwd, conn, false, setNewData, sorteddata);
            }
            if (rootReport && (newParams = qbReport.getAllParameters(true)).size() > 0 && myParams != null) {
                for (int i = 0; i < newParams.size(); ++i) {
                    Param currentParam = newParams.get(i);
                    if (currentParam.multiValue()) {
                        currentParam.setValues(myParams.get(i).getValues());
                        continue;
                    }
                    currentParam.setValue(myParams.get(i).getValue());
                }
            }
        }

        void replaceChartDatabaseInfo(QbReport qbReport, String originalUrl, String url, String driver, String usr, String pwd, Connection conn) {
            ReportChartObject[] reportChartObjects = qbReport.getReportChartObjects();
            for (int i = 0; i < reportChartObjects.length; ++i) {
                if (reportChartObjects[i].isReportDataUsed()) continue;
                reportChartObjects[i].setDomainPath(qbReport.report.domainPath);
                String chartLocation1 = reportChartObjects[i].getText();
                QbChart tempChart = null;
                if (reportChartObjects[i].getBytes() != null) {
                    boolean isTemplate = reportChartObjects[i].getText().toUpperCase().endsWith(".TPL");
                    try {
                        Vector preSetParams = quadbase.reportdesigner.report.ChartObject.getPresetParams(QbReport.this.report, qbReport.getTable(), reportChartObjects[i]);
                        tempChart = new QbChart(this.openChart(new ByteArrayInputStream(reportChartObjects[i].getBytes()), null, isTemplate, preSetParams));
                    }
                    catch (Exception e) {
                        System.out.println("Following error occured when attempting to use Chart bytes...\n" + e.getMessage() + "\nAttempting to find chart from path.");
                        tempChart = new QbChart((Applet)null, chartLocation1);
                    }
                } else {
                    tempChart = new QbChart((Applet)null, chartLocation1);
                }
                String chartQuery = tempChart.gethInputData().getDatabaseInfo().getQuery();
                if (!tempChart.gethInputData().getDatabaseInfo().getURLString().equals(originalUrl)) continue;
                ChartModifier chartMod = new ChartModifier(url, driver, usr, pwd, chartQuery, conn);
                reportChartObjects[i].setChartModifier(chartMod);
                reportChartObjects[i].setChart(chartMod.modifyChart(tempChart.getChart()));
            }
        }

        @Override
        public void replaceAllDatabaseInfo(String originalUrl, String url, String driver, String usr, String pwd, boolean setNewData) throws Exception {
            this.replaceDatabaseInfo(this.qbReport, originalUrl, url, driver, usr, pwd, null, true, setNewData, false);
        }

        void replaceDatabaseInfo(QbReport qbReport, Hashtable<String, Properties> databaseMap, Properties defaultVal, Connection conn, boolean rootReport, boolean setNewData, boolean sorteddata) throws Exception {
            Parameters newParams;
            Parameters myParams = null;
            if (rootReport) {
                myParams = qbReport.getAllParameters(true);
            }
            IInputData inputData = qbReport.getInputData();
            quadbase.reportdesigner.util.IDatabaseInfo databaseInfo = inputData.getDatabaseInfo();
            String dbquery = databaseInfo.getQuery();
            if (databaseMap.get(databaseInfo.getURLString()) != null || defaultVal != null) {
                Properties prop = databaseMap.get(databaseInfo.getURLString()) != null ? databaseMap.get(databaseInfo.getURLString()) : defaultVal;
                if (prop != null) {
                    String url = prop.getProperty("URL");
                    String driver = prop.getProperty("DRIVER");
                    String usr = prop.getProperty("USERNAME");
                    String pwd = prop.getProperty("PASSWORD");
                    if (url != null && driver != null && usr != null && pwd != null) {
                        if (databaseInfo instanceof quadbase.reportdesigner.util.IQueryFileInfo) {
                            quadbase.reportdesigner.util.IQueryInParam[] paramSet = ((quadbase.reportdesigner.util.IQueryFileInfo)databaseInfo).getInParam();
                            SimpleQueryFileInfo newDatabaseInfo = conn == null ? new SimpleQueryFileInfo(url, driver, usr, pwd, dbquery) : new SimpleQueryFileInfo(conn, dbquery);
                            newDatabaseInfo.setInParam(paramSet);
                            if (databaseInfo instanceof IQbQueryFileInfo) {
                                quadbase.reportdesigner.util.IQueryInParam[][] parameterInPromptSequence = ((IQbQueryFileInfo)databaseInfo).getParameterInPromptSequence();
                                newDatabaseInfo.setParameterInPromptSequence(parameterInPromptSequence);
                            }
                            inputData.setDatabaseInfo(newDatabaseInfo, setNewData, sorteddata);
                        } else {
                            DBInfo newDatabaseInfo = conn == null ? new DBInfo(url, driver, usr, pwd, dbquery) : new DBInfo(conn, dbquery);
                            inputData.setDatabaseInfo(newDatabaseInfo, setNewData, sorteddata);
                        }
                    } else if (url != null) {
                        System.out.println("Database URL is not available");
                    } else if (driver != null) {
                        System.out.println("Database DRIVER is not available");
                    } else if (usr != null) {
                        System.out.println("Database USERNAME is not available");
                    } else if (pwd != null) {
                        System.out.println("Database PASSWORD is not available");
                    }
                } else {
                    System.out.println("Internal Error - Database MAP property is null");
                }
            }
            this.replaceChartDatabaseInfo(qbReport, databaseMap, defaultVal, conn);
            Vector<SubReportObject> subReportObjects = qbReport.getReportObj().subReports;
            for (int i = 0; subReportObjects != null && i < subReportObjects.size(); ++i) {
                SubReportObject sro = subReportObjects.elementAt(i);
                QbReport subReport = (QbReport)((Object)sro.getSubReport(false, false, true, qbReport));
                this.replaceDatabaseInfo(subReport, databaseMap, defaultVal, conn, false, setNewData, sorteddata);
                SaveReport sr = new SaveReport(subReport.getReportObj());
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                DataOutputStream dout = new DataOutputStream(bout);
                sr.saveData(dout);
                sro.setByteArray(bout.toByteArray());
                sro.clearReportCache(1.0);
            }
            qbReport.getReportObj().useBackupData = false;
            int numberOfDrillDowns = qbReport.getDrillDownReportCount();
            for (int i = 0; i < numberOfDrillDowns; ++i) {
                DrillDownReport drillDownReport = qbReport.getDrillDownReportAt(i, true);
                this.replaceDatabaseInfo(drillDownReport, databaseMap, defaultVal, conn, false, setNewData, sorteddata);
            }
            if (rootReport && (newParams = qbReport.getAllParameters(true)).size() > 0 && myParams != null) {
                for (int i = 0; i < newParams.size(); ++i) {
                    Param currentParam = newParams.get(i);
                    if (currentParam.multiValue()) {
                        currentParam.setValues(myParams.get(i).getValues());
                        continue;
                    }
                    currentParam.setValue(myParams.get(i).getValue());
                }
            }
        }

        void replaceChartDatabaseInfo(QbReport qbReport, Hashtable<String, Properties> databaseMap, Properties defaultVal, Connection conn) {
            ReportChartObject[] reportChartObjects = qbReport.getReportChartObjects();
            for (int i = 0; i < reportChartObjects.length; ++i) {
                if (reportChartObjects[i].isReportDataUsed()) continue;
                reportChartObjects[i].setDomainPath(qbReport.report.domainPath);
                String chartLocation1 = reportChartObjects[i].getText();
                QbChart tempChart = null;
                if (reportChartObjects[i].getBytes() != null) {
                    boolean isTemplate = reportChartObjects[i].getText().toUpperCase().endsWith(".TPL");
                    try {
                        Vector preSetParams = quadbase.reportdesigner.report.ChartObject.getPresetParams(QbReport.this.report, qbReport.getTable(), reportChartObjects[i]);
                        tempChart = new QbChart(this.openChart(new ByteArrayInputStream(reportChartObjects[i].getBytes()), null, isTemplate, preSetParams));
                    }
                    catch (Exception e) {
                        System.out.println("Following error occured when attempting to use Chart bytes...\n" + e.getMessage() + "\nAttempting to find chart from path.");
                        tempChart = new QbChart((Applet)null, chartLocation1);
                    }
                } else {
                    tempChart = new QbChart((Applet)null, chartLocation1);
                }
                String chartQuery = tempChart.gethInputData().getDatabaseInfo().getQuery();
                if (databaseMap.get(tempChart.gethInputData().getDatabaseInfo().getURLString()) == null && defaultVal == null) continue;
                Properties prop = databaseMap.get(tempChart.gethInputData().getDatabaseInfo().getURLString()) != null ? databaseMap.get(tempChart.gethInputData().getDatabaseInfo().getURLString()) : defaultVal;
                if (prop != null) {
                    String url = prop.getProperty("URL");
                    String driver = prop.getProperty("DRIVER");
                    String usr = prop.getProperty("USERNAME");
                    String pwd = prop.getProperty("PASSWORD");
                    if (url != null && driver != null && usr != null && pwd != null) {
                        ChartModifier chartMod = new ChartModifier(url, driver, usr, pwd, chartQuery, conn);
                        reportChartObjects[i].setChartModifier(chartMod);
                        reportChartObjects[i].setChart(chartMod.modifyChart(tempChart.getChart()));
                        continue;
                    }
                    if (url != null) {
                        System.out.println("Database URL is not available");
                        continue;
                    }
                    if (driver != null) {
                        System.out.println("Database DRIVER is not available");
                        continue;
                    }
                    if (usr != null) {
                        System.out.println("Database USERNAME is not available");
                        continue;
                    }
                    if (pwd == null) continue;
                    System.out.println("Database PASSWORD is not available");
                    continue;
                }
                System.out.println("Internal Error - databaseMap properties is null");
            }
        }

        @Override
        public void replaceAllDatabaseInfo(Hashtable<String, Properties> databaseMap, Properties defaultVals, boolean setNewData) throws Exception {
            this.replaceDatabaseInfo(this.qbReport, databaseMap, defaultVals, null, true, setNewData, false);
        }

        @Override
        public void replaceColumns(ReplaceColumnInfoList colList) throws Exception {
            this.replaceColumns(this.qbReport, colList);
        }

        void replaceColumns(QbReport qbReport, ReplaceColumnInfoList colList) throws Exception {
            SubReportObject[] subReportObjects;
            if (colList == null) {
                return;
            }
            qbReport.getReportObj().replaceColumns(colList);
            for (SubReportObject subReportObject : subReportObjects = qbReport.getSubReports()) {
                QbReport subReport = (QbReport)((Object)subReportObject.getSubReport(false, false, true, qbReport));
                this.replaceColumns(subReport, colList);
                subReport.refreshWithOriginalData();
            }
            int numberOfDrillDowns = qbReport.getDrillDownReportCount();
            for (int i = 0; i < numberOfDrillDowns; ++i) {
                DrillDownReport drillDownReport = qbReport.getDrillDownReportAt(i, true);
                this.replaceColumns(drillDownReport, colList);
                drillDownReport.refreshWithOriginalData();
            }
        }

        @Override
        public final void setJNDIDatabaseInfo(IDatabaseInfo dbinfo, boolean setNewData, boolean sorteddata) throws Exception {
            this.checkParamQuery(dbinfo);
            quadbase.reportdesigner.report.ColData[] data = null;
            if (setNewData) {
                Object[] res = QbReport.this.setColData(sorteddata, dbinfo, this.getMapping(), false, QbReport.this.report.getReportType(), QbReport.this.optimizeMemory, true);
                data = (quadbase.reportdesigner.report.ColData[])res[0];
                sorteddata = (Boolean)res[2];
            }
            if (dbinfo instanceof quadbase.reportdesigner.util.IQueryFileInfo) {
                QbReport.this.report.queryFilename = null;
                QbReport.this.report.dbInfo = new QueryFileInfo((quadbase.reportdesigner.util.IQueryFileInfo)dbinfo, setNewData);
            } else {
                QbReport.this.report.queryFilename = null;
                QbReport.this.report.setQueryFileInfo(null);
                QbReport.this.report.dbInfo = new DBInfo(dbinfo);
            }
            if (setNewData) {
                String domainPath = QbReport.this.report.domainPath;
                QbReport.this.report = QbReport.this.report.setNewData(data, sorteddata);
                QbReport.this.report.domainPath = domainPath;
            }
            QbReport.this.report.sourceData = 1;
            QbReport.this.report.colDataSorted = sorteddata;
        }

        @Override
        public void setAllJNDIDatabaseInfo(Hashtable<String, String> env, String jndiName) throws Exception {
            this.setJNDIDatabaseInfo(this.qbReport, env, jndiName, true, false, false);
        }

        void setJNDIDatabaseInfo(QbReport qbReport, Hashtable<String, String> env, String jndiName, boolean rootReport, boolean setNewData, boolean sorteddata) throws Exception {
            Parameters newParams;
            Parameters myParams = null;
            if (rootReport) {
                myParams = qbReport.getAllParameters(true);
            }
            IInputData inputData = qbReport.getInputData();
            quadbase.reportdesigner.util.IDatabaseInfo databaseInfo = inputData.getDatabaseInfo();
            String dbquery = databaseInfo.getQuery();
            if (databaseInfo instanceof quadbase.reportdesigner.util.IQueryFileInfo) {
                quadbase.reportdesigner.util.IQueryInParam[] paramSet = ((quadbase.reportdesigner.util.IQueryFileInfo)databaseInfo).getInParam();
                SimpleQueryFileInfo newDatabaseInfo = new SimpleQueryFileInfo(jndiName, dbquery, (Hashtable)env);
                newDatabaseInfo.setInParam(paramSet);
                inputData.setJNDIDatabaseInfo(newDatabaseInfo, setNewData, sorteddata);
            } else {
                DBInfo newDatabaseInfo = new DBInfo(jndiName, dbquery, env);
                inputData.setJNDIDatabaseInfo(newDatabaseInfo, setNewData, sorteddata);
            }
            this.setJNDIChartDatabaseInfo(qbReport, env, jndiName);
            Vector<SubReportObject> subReportObjects = qbReport.getReportObj().subReports;
            for (int i = 0; subReportObjects != null && i < subReportObjects.size(); ++i) {
                SubReportObject sro = subReportObjects.elementAt(i);
                QbReport subReport = (QbReport)((Object)sro.getSubReport(false, false, true, qbReport));
                this.setJNDIDatabaseInfo(subReport, env, jndiName, false, setNewData, sorteddata);
                SaveReport sr = new SaveReport(subReport.getReportObj());
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                DataOutputStream dout = new DataOutputStream(bout);
                sr.saveData(dout);
                sro.setByteArray(bout.toByteArray());
                sro.clearReportCache(1.0);
            }
            qbReport.getReportObj().useBackupData = false;
            int numberOfDrillDowns = qbReport.getDrillDownReportCount();
            for (int i = 0; i < numberOfDrillDowns; ++i) {
                DrillDownReport drillDownReport = qbReport.getDrillDownReportAt(i, true);
                this.setJNDIDatabaseInfo(drillDownReport, env, jndiName, false, setNewData, sorteddata);
            }
            if (rootReport && (newParams = qbReport.getAllParameters(true)).size() > 0 && myParams != null) {
                for (int i = 0; i < newParams.size(); ++i) {
                    Param currentParam = newParams.get(i);
                    if (currentParam.multiValue()) {
                        currentParam.setValues(myParams.get(i).getValues());
                        continue;
                    }
                    currentParam.setValue(myParams.get(i).getValue());
                }
            }
        }

        void setJNDIChartDatabaseInfo(QbReport qbReport, Hashtable<String, String> env, String jndiName) {
            ReportChartObject[] reportChartObjects = qbReport.getReportChartObjects();
            for (int i = 0; i < reportChartObjects.length; ++i) {
                if (reportChartObjects[i].isReportDataUsed()) continue;
                reportChartObjects[i].setDomainPath(qbReport.report.domainPath);
                String chartLocation1 = reportChartObjects[i].getText();
                QbChart tempChart = null;
                if (reportChartObjects[i].getBytes() != null) {
                    boolean isTemplate = reportChartObjects[i].getText().toUpperCase().endsWith(".TPL");
                    try {
                        Vector preSetParams = quadbase.reportdesigner.report.ChartObject.getPresetParams(QbReport.this.report, qbReport.getTable(), reportChartObjects[i]);
                        tempChart = new QbChart(this.openChart(new ByteArrayInputStream(reportChartObjects[i].getBytes()), null, isTemplate, preSetParams));
                    }
                    catch (Exception e) {
                        System.out.println("Following error occured when attempting to use Chart bytes...\n" + e.getMessage() + "\nAttempting to find chart from path.");
                        tempChart = new QbChart((Applet)null, chartLocation1);
                    }
                } else {
                    tempChart = new QbChart((Applet)null, chartLocation1);
                }
                String chartQuery = tempChart.gethInputData().getDatabaseInfo().getQuery();
                ChartModifier chartMod = new ChartModifier(jndiName, chartQuery, env);
                reportChartObjects[i].setChartModifier(chartMod);
                reportChartObjects[i].setChart(chartMod.modifyChart(tempChart.getChart()));
            }
        }

        private final void checkParamQuery(IDatabaseInfo dbinfo) throws IllegalArgumentException {
            String[] paramNames = QueryParser.getAllParameters(dbinfo.getQuery());
            if (paramNames == null || paramNames.length == 0) {
                return;
            }
            if (QbReport.this.report.dbInfo instanceof IQueryFileInfo) {
                dbinfo = ReportUtil.cast((IQueryFileInfo)dbinfo);
            }
            if (!(dbinfo instanceof quadbase.reportdesigner.util.IQueryFileInfo)) {
                throw new IllegalArgumentException("parameterized query found, please use a class that implements IQueryFileInfo (which extends IDatabaseInfo)");
            }
        }

        @Override
        public final String getQueryFilename() {
            if (QbReport.this.report.sourceData == 2) {
                return QbReport.this.report.queryFilename;
            }
            return null;
        }

        @Override
        public final void setQueryFilename(String filename) throws Exception {
            QueryFileInfo temp = QueryFileInfo.readFile(filename);
            this.setDatabaseInfo(temp);
            QbReport.this.report.queryFilename = filename;
        }

        @Override
        public quadbase.reportdesigner.util.IQueryFileInfo readQueryFile(String filename) throws Exception {
            return ReportUtil.cast((quadbase.reportdesigner.util.IQueryFileInfo)((Object)QueryFileInfo.readFile(filename)));
        }

        @Override
        public final String getDataFile() {
            if (QbReport.this.report.sourceData == 2 || QbReport.this.report.getOriginalSourceData() == 2) {
                return QbReport.this.report.sourceFile;
            }
            return null;
        }

        @Override
        public final void setDataFile(String fileName) throws IOException {
            this.setDataFile(fileName, false);
        }

        @Override
        public final void setDataFile(String fileName, boolean sortedData) throws IOException {
            this.setDataFile(fileName, sortedData, null);
        }

        @Override
        public final void setDataFile(String fileName, boolean sortedData, String encoding) throws IOException {
            try {
                QbReport.this.report = QbReport.this.report.setNewData(new DataFileInput().readProcessedData(fileName, false, null, null, null, 0, -1, null, 0, encoding), sortedData);
            }
            catch (Exception ex) {
                throw new IOException(ex.toString());
            }
            QbReport.this.report.sourceData = 2;
            QbReport.this.report.sourceFile = fileName;
            QbReport.this.report.sourceFileEncoding = encoding;
        }

        @Override
        public final String getClassFile() {
            if (QbReport.this.report.sourceData == 6 || QbReport.this.report.getOriginalSourceData() == 6) {
                return QbReport.this.report.sourceFile;
            }
            return null;
        }

        @Override
        public final void setClassFile(String className) throws IOException {
            this.setClassFile(className, false);
        }

        @Override
        public final void setClassFile(String className, boolean sortedData) throws IOException {
            this.setClassFile(className, false, true);
        }

        @Override
        public final void setClassFile(String className, boolean sortedData, boolean showPromptDialog) throws IOException {
            try {
                if (ClassFileUtil.isParameterized(className)) {
                    QueryClassFileInfo classInfo = new QueryClassFileInfo(className);
                    QbReport.this.report.dbInfo = classInfo;
                    Vector<QueryInParamSet> paramV = null;
                    paramV = QueryFileInfo.getParameter(classInfo, false, !showPromptDialog, true);
                    QbReport.this.report = QbReport.this.report.setNewData(new DataFileInput().readProcessedData(className, false, null, null, null, 0, -1, paramV.elementAt(0)), sortedData);
                } else {
                    QbReport.this.report = QbReport.this.report.setNewData(new DataFileInput().readProcessedData(className, false, null, null, 6), sortedData);
                }
            }
            catch (Exception ex) {
                throw new IOException(ex.toString());
            }
            QbReport.this.report.sourceData = 6;
            QbReport.this.report.sourceFile = className;
        }

        @Override
        public final XMLFileQueryInfo getXMLFileQueryInfo() {
            return QbReport.this.report.getXMLFileQueryInfo();
        }

        @Override
        public final void setXMLFileQueryInfo(XMLFileQueryInfo xmlInfo) {
            this.setXMLFileQueryInfo(xmlInfo, false);
        }

        @Override
        public final void setXMLFileQueryInfo(XMLFileQueryInfo xmlInfo, boolean sortedData) {
            try {
                quadbase.reportdesigner.report.ColData[] data = new DataFileInput().readProcessedData(xmlInfo.getFileName(), false, null, null, null, 0, -1, xmlInfo, 7);
                QbReport.this.report = QbReport.this.report.setNewData(data, sortedData);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            QbReport.this.report.sourceData = 7;
            QbReport.this.report.xmlFileQueryInfo = xmlInfo;
        }

        @Override
        public final String getXMLFile() {
            XMLFileQueryInfo xmlInfo = this.getXMLFileQueryInfo();
            if (xmlInfo != null) {
                return this.getXMLFileQueryInfo().getFileName();
            }
            return null;
        }

        @Override
        public final void setXMLFile(String xmlFile) throws IOException {
            this.setXMLFile(xmlFile, false);
        }

        @Override
        public final void setXMLFile(String xmlFile, boolean sortedData) throws IOException {
            if (QbReport.this.report.sourceData != 7 && QbReport.this.report.getOriginalSourceData() != 7) {
                throw new IOException("Failed to set the xml data file!");
            }
            XMLFileQueryInfo xmlInfo = this.getXMLFileQueryInfo();
            if (xmlInfo == null) {
                throw new IOException("Failed to set the xml data file!");
            }
            this.setXMLFileQueryInfo(new XMLFileQueryInfo(xmlFile, xmlInfo.getFieldInfo(), xmlInfo.getCondition(), xmlInfo.getConditionInfo(), xmlInfo.getInSet()), sortedData);
        }

        @Override
        public final String getDTDFile() {
            XMLFileQueryInfo xmlInfo = this.getXMLFileQueryInfo();
            if (xmlInfo != null) {
                return this.getXMLFileQueryInfo().getDTDName();
            }
            return null;
        }

        @Override
        public final SalesForceQueryFileInfo getSalesForceQueryInfo() {
            return QbReport.this.report.sfQueryInfo;
        }

        @Override
        public final void setSalesForceQueryInfo(SalesForceQueryFileInfo sfQueryInfo) throws Exception {
            quadbase.reportdesigner.report.ColData[] data = SalesForceAccess.getColData(sfQueryInfo);
            QbReport.this.report = QbReport.this.report.setNewData(data);
            QbReport.this.report.sourceData = 11;
            QbReport.this.report.sfQueryInfo = sfQueryInfo;
            if (sfQueryInfo.isParameterized()) {
                QbReport.this.report.dbInfo = sfQueryInfo;
            }
        }

        @Override
        public void setAllSalesForceInfo(String serverUrl, String sessionId) throws Exception {
            SalesForceQueryFileInfo sfQueryInfo = this.qbReport.getInputData().getSalesForceQueryInfo();
            if (sfQueryInfo != null) {
                sfQueryInfo.setServerUrl(serverUrl);
                sfQueryInfo.setSessionId(sessionId);
            }
            Vector<SubReportObject> subReportObjects = this.qbReport.getReportObj().subReports;
            for (int i = 0; subReportObjects != null && i < subReportObjects.size(); ++i) {
                SubReportObject sro = subReportObjects.elementAt(i);
                QbReport subReport = (QbReport)((Object)sro.getSubReport(false, false, true, this.qbReport));
                subReport.getInputData().setAllSalesForceInfo(serverUrl, sessionId);
                SaveReport sr = new SaveReport(subReport.getReportObj());
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                DataOutputStream dout = new DataOutputStream(bout);
                sr.saveData(dout);
                sro.setByteArray(bout.toByteArray());
                sro.clearReportCache(1.0);
            }
            this.qbReport.getReportObj().useBackupData = false;
            int numberOfDrillDowns = this.qbReport.getDrillDownReportCount();
            for (int i = 0; i < numberOfDrillDowns; ++i) {
                DrillDownReport drillDownReport = this.qbReport.getDrillDownReportAt(i, true);
                drillDownReport.getInputData().setAllSalesForceInfo(serverUrl, sessionId);
            }
            ReportChartObject[] reportChartObjects = this.qbReport.getReportChartObjects();
            if (reportChartObjects != null) {
                for (int i = 0; i < reportChartObjects.length; ++i) {
                    if (reportChartObjects[i].isReportDataUsed()) continue;
                    reportChartObjects[i].setDomainPath(this.qbReport.report.domainPath);
                    SalesForceQueryFileInfo chartInfo = ((QbChart)reportChartObjects[i].getChart()).gethInputData().getSalesForceQueryInfo();
                    if (chartInfo == null) continue;
                    chartInfo.setServerUrl(serverUrl);
                    chartInfo.setSessionId(sessionId);
                }
            }
        }

        @Override
        public ExcelFileInfo getExcelFileInfo() {
            return QbReport.this.report.excelInfo;
        }

        @Override
        public void setExcelFileInfo(ExcelFileInfo excelInfo) throws Exception {
            quadbase.reportdesigner.report.ColData[] data = ExcelAccess.getColData(excelInfo);
            QbReport.this.report = QbReport.this.report.setNewData(data);
            QbReport.this.report.sourceData = 13;
            QbReport.this.report.excelInfo = excelInfo;
        }

        @Override
        public final void addRow(IRow r) {
            Object[] records = QbReport.this.getValidRow(r);
            QbReport.this.report.addRecord(records);
        }

        @Override
        public final void deleteRow(int rowId) {
            if (rowId >= QbReport.this.report.getDataRowSize()) {
                throw new IllegalArgumentException("Row ID must be less than " + QbReport.this.report.getDataRowSize());
            }
            QbReport.this.report.removeRecord(rowId);
        }

        @Override
        public final void updateRow(int rowId, IRow r) {
            Object[] newrec = QbReport.this.getValidRow(r);
            QbReport.this.report.setRecord(newrec, rowId);
        }

        @Override
        public final IRow getRow(final int rowId) {
            return new IRow(){
                Object[] row;
                {
                    this.row = QbReport.this.report.getRecord(rowId);
                }

                @Override
                public Object getObject(int i) {
                    if (i <= 0 || i > this.row.length) {
                        throw new IllegalArgumentException("Invalid index :" + i);
                    }
                    return this.row[i - 1];
                }
            };
        }

        @Override
        public final int getRowCount() {
            return QbReport.this.report.getDataRowSize();
        }

        @Override
        public final int matchRecord(IRow r) {
            Object[] newrec = QbReport.this.getValidRow(r);
            return QbReport.this.searchRecord(QbReport.this.report.getColData(), QbReport.this.checkStrArr(newrec));
        }

        @Override
        public final IResultSet getData() {
            return quadbase.reportdesigner.report.ColData.getResultSet(QbReport.this.report.getColData());
        }

        @Override
        public final void setData(IResultSet rs) throws Exception {
            this.setData(rs, false);
        }

        @Override
        public final void setData(IResultSet rs, boolean sortedData) throws Exception {
            QbReport.this.report = rs instanceof DbData ? QbReport.this.report.setNewData(((DbData)rs).getColData()) : QbReport.this.report.setNewData(quadbase.reportdesigner.report.ColData.getColData(rs), sortedData);
            QbReport.this.report.originalColDataFromMemSource = QbReport.this.report.getColData();
            QbReport.this.report.sourceData = 0;
            QbReport.this.report.useBackupData = false;
        }

        @Override
        @Deprecated
        public final void setData(IResultSet rs, boolean sortedData, boolean optimizeMemory) throws Exception {
            this.setData(rs, sortedData, optimizeMemory, null);
        }

        @Override
        @Deprecated
        public final void setData(IResultSet rs, boolean sortedData, boolean optimizeMemory, Object[] distinctValue) throws Exception {
            if (!(optimizeMemory = ServerMessage.performOptimizeMemory(optimizeMemory)) || !sortedData) {
                this.setData(rs, sortedData);
                return;
            }
            QbReport.this.report = rs instanceof DbData ? QbReport.this.report.setNewData(((DbData)rs).getColData()) : QbReport.this.report.setNewData(quadbase.reportdesigner.report.ColData.getColData(rs, 0, 0));
            QbReport.this.report.originalColDataFromMemSource = QbReport.this.report.getColData();
            QbReport.this.report.dbInfo = null;
            QbReport.this.report.useBackupData = false;
            QbReport.this.report.sourceData = 0;
            QbReport.this.report.setForExportOnly(true);
            QbReport.this.report.distColValue = distinctValue;
            QbReport.this.report.originalIResultSet = rs;
        }

        @Override
        public final ISpreadSheetModel getSpreadSheetModel() {
            return QbReport.this.spreadSheet;
        }

        @Override
        public final void setSpreadSheetModel(ISpreadSheetModel sheet) {
            QbReport.this.spreadSheet = sheet;
            if (sheet == null) {
                return;
            }
            if (QbReport.this.spreadSheetListener == null) {
                QbReport.this.spreadSheetListener = new CSpreadSheetListener();
            }
            sheet.addSpreadSheetModelListener(QbReport.this.spreadSheetListener);
            quadbase.reportdesigner.report.ColData[] colDataArray = quadbase.reportdesigner.report.ColData.getColData(sheet);
            Report newReport = null;
            try {
                newReport = QbReport.this.report.setNewData(colDataArray);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if (newReport != null) {
                QbReport.this.report = newReport;
                QbReport.this.report.originalColDataFromMemSource = null;
                QbReport.this.report.sourceData = 0;
            }
        }

        class ChartModifier
        implements IChartModifier {
            String newDatabaseDriver = "";
            String newDatabaseURL = "";
            String userid = "";
            String password = "";
            String query = "";
            Connection conn;
            boolean isJNDI = false;
            Hashtable<String, String> env = null;
            String jndiName = "";

            public ChartModifier(String jndiName, String query, Hashtable<String, String> env) {
                this.env = env;
                this.jndiName = jndiName;
                this.query = query;
                this.isJNDI = true;
            }

            public ChartModifier(String newDatabaseURL, String newDatabaseDriver, String userid, String password, String query, Connection conn) {
                this.query = query;
                this.newDatabaseURL = newDatabaseURL;
                this.newDatabaseDriver = newDatabaseDriver;
                this.userid = userid;
                this.password = password;
                this.conn = conn;
                this.isJNDI = false;
            }

            @Override
            public IChart modifyChart(Object chartInfo) {
                return this.modifyChart(chartInfo, true);
            }

            public IChart modifyChart(Object chartInfo, boolean verifyNewData) {
                ChartObject chart = new ChartObject(chartInfo);
                QbChart.setForExportOnly(true);
                try {
                    if (chart.gethInputData().getDatabaseInfo() instanceof quadbase.util.IQueryFileInfo) {
                        IQueryInParam[] paramSet = ((quadbase.util.IQueryFileInfo)chart.gethInputData().getDatabaseInfo()).getInParam();
                        quadbase.util.SimpleQueryFileInfo newDatabaseInfo = null;
                        newDatabaseInfo = !this.isJNDI ? (this.conn == null ? new quadbase.util.SimpleQueryFileInfo(this.newDatabaseURL, this.newDatabaseDriver, this.userid, this.password, this.query) : new quadbase.util.SimpleQueryFileInfo(this.conn, this.query)) : new quadbase.util.SimpleQueryFileInfo(this.jndiName, this.query, (Hashtable)this.env);
                        newDatabaseInfo.setInParam(paramSet);
                        chart.gethInputData().setDatabaseInfo(newDatabaseInfo, false);
                    } else {
                        quadbase.ChartAPI.DBInfo newDatabaseInfo = null;
                        newDatabaseInfo = !this.isJNDI ? (this.conn == null ? new quadbase.ChartAPI.DBInfo(this.newDatabaseURL, this.newDatabaseDriver, this.userid, this.password, this.query) : new quadbase.ChartAPI.DBInfo(this.conn, this.query)) : new quadbase.ChartAPI.DBInfo(this.jndiName, this.query, this.env);
                        chart.gethInputData().setDatabaseInfo(newDatabaseInfo, false);
                    }
                    if (verifyNewData) {
                        chart.refresh();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return chart;
            }
        }
    }

    class CSpreadSheetListener
    implements ISpreadSheetModelListener {
        CSpreadSheetListener() {
        }

        @Override
        public void spreadSheetChanged(SpreadSheetModelEvent e) {
            if (e.getSource() != QbReport.this.spreadSheet) {
                return;
            }
            int row = e.getRow();
            int col = e.getColumn();
            if (row > 0 && col > 0) {
                int rowId = (row - 1) * QbReport.this.spreadSheet.getColumnCount() + col - 1;
                Object[] rec = QbReport.this.report.getRecord(rowId);
                rec[2] = QbReport.this.spreadSheet.getValueAt(row, col);
                QbReport.this.report.setRecord(rec, rowId);
            } else {
                Report newReport = null;
                try {
                    newReport = QbReport.this.report.setNewData(quadbase.reportdesigner.report.ColData.getColData(QbReport.this.spreadSheet));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                if (newReport != null) {
                    QbReport.this.report = newReport;
                }
            }
        }
    }
}

