/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.ReportElements;

import java.util.Vector;

public class Bookmark {
    private String title;
    private int[] tree;
    private int page = 1;
    private int section = 1;
    private double ypos;

    public Bookmark(String title, Vector<Integer> vec) {
        this.title = title;
        if (vec != null) {
            this.tree = new int[vec.size()];
            for (int i = 0; i < vec.size(); ++i) {
                this.tree[i] = vec.elementAt(i);
            }
        }
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTree(int[] tree) {
        this.tree = tree;
    }

    public int[] getTree() {
        return this.tree;
    }

    public int getLevel() {
        if (this.tree != null) {
            return this.tree.length - 1;
        }
        return 0;
    }

    public void setPageNumber(int page) {
        this.page = page;
    }

    public int getPageNumber() {
        return this.page;
    }

    public void setSection(int section) {
        this.section = section;
    }

    public int getSection() {
        return this.section;
    }

    public void setYPos(double ypos) {
        this.ypos = ypos;
    }

    public double getYPos() {
        return this.ypos;
    }

    public String toString() {
        return this.tree[0] + ":" + this.title + " " + this.getPageNumber() + " " + this.section;
    }

    public String getKey() {
        StringBuffer sb = new StringBuffer();
        for (int element : this.tree) {
            sb.append(element);
        }
        return sb.toString();
    }
}

