/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.ReportElements;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Writer;
import java.util.Properties;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import quadbase.reportdesigner.ReportElements.ReportColumn;
import quadbase.reportdesigner.report.LoadXMLReportHelper;
import quadbase.reportdesigner.util.IFormat;

public class CBAggrColumn
extends ReportColumn {
    int level = -1;
    int colBkValIdx = 0;
    public static final String XMLTAG = "CBAGGRCOLUMN";

    public CBAggrColumn() {
    }

    public CBAggrColumn(String name, IFormat dataFormat, int level, int colBkValIdx, int noOfCol) {
        super(name, dataFormat, noOfCol);
        this.level = level;
        this.colBkValIdx = colBkValIdx;
    }

    public CBAggrColumn(CBAggrColumn col) {
        super(col);
        this.level = col.getColBreakLevel();
        this.colBkValIdx = col.colBkValIdx;
    }

    public CBAggrColumn(CBAggrColumn col, Properties treeProp) {
        super(col, treeProp);
        this.level = col.getColBreakLevel();
        this.colBkValIdx = col.colBkValIdx;
    }

    @Override
    public void copyTemplate(ReportColumn col, boolean b) {
        super.copyTemplate(col, b);
    }

    @Override
    public void copy(ReportColumn col) {
        if (col instanceof CBAggrColumn) {
            this.level = ((CBAggrColumn)col).level;
            this.colBkValIdx = ((CBAggrColumn)col).colBkValIdx;
        }
        super.copy(col);
    }

    @Override
    public void deepCopy(ReportColumn col) {
        if (col instanceof CBAggrColumn) {
            this.level = ((CBAggrColumn)col).level;
            this.colBkValIdx = ((CBAggrColumn)col).colBkValIdx;
        }
        super.deepCopy(col);
    }

    public int getColBreakLevel() {
        return this.level;
    }

    public int getColBreakValueIndex() {
        return this.colBkValIdx;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeInt(this.level);
        out.writeInt(this.colBkValIdx);
        super.write(out);
    }

    @Override
    public void read(DataInput in, int version) throws Exception {
        this.level = in.readInt();
        if (version >= 278) {
            this.colBkValIdx = in.readInt();
        }
        super.read(in, version);
    }

    public static CBAggrColumn createCBAggrColumn(DataInput in, int version) throws Exception {
        CBAggrColumn aggrCol = new CBAggrColumn();
        aggrCol.read(in, version);
        return aggrCol;
    }

    @Override
    public void writeXML(Writer out, boolean writeElementTag) throws IOException {
        if (writeElementTag) {
            out.write("<CBAGGRCOLUMN>\n");
        }
        out.write("<CBAGGRCOLUMN_LEVEL>" + this.level + "</CBAGGRCOLUMN_LEVEL>\n");
        out.write("<CBAGGRCOLUMN_COLBKVALIDX>" + this.colBkValIdx + "</CBAGGRCOLUMN_COLBKVALIDX>\n");
        super.writeXML(out, false);
        if (writeElementTag) {
            out.write("</CBAGGRCOLUMN>\n");
        }
    }

    @Override
    public void readXML(Node node, int version) throws Exception {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node child = nodeList.item(i);
            if (child.getNodeName().equalsIgnoreCase("CBAGGRCOLUMN_LEVEL")) {
                this.level = Integer.parseInt(LoadXMLReportHelper.readText(child).trim());
                continue;
            }
            if (!child.getNodeName().equalsIgnoreCase("CBAGGRCOLUMN_COLBKVALIDX")) continue;
            this.colBkValIdx = Integer.parseInt(LoadXMLReportHelper.readText(child).trim());
        }
        super.readXML(node, version);
    }

    public static CBAggrColumn createCBAggrColumn(Node node, int version) throws Exception {
        if (!node.getNodeName().equalsIgnoreCase(XMLTAG)) {
            throw new Exception("'CBAGGRCOLUMN' element expected, but found '" + node.getNodeName() + "' element.");
        }
        CBAggrColumn column = new CBAggrColumn();
        column.readXML(node, version);
        return column;
    }

    public Object clone() {
        CBAggrColumn _new = new CBAggrColumn();
        _new.copy(this);
        return _new;
    }
}

