/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.ReportElements;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Writer;
import java.util.Properties;
import java.util.Vector;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import quadbase.reportdesigner.ReportElements.ReportColumn;
import quadbase.reportdesigner.report.LoadXMLReportHelper;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.util.IFormat;

public class ColumnBreakColumn
extends ReportColumn {
    public static final String XMLTAG = "COLUMNBREAKCOLUMN";
    private int colBkValIdx = 0;
    private String parentColName;
    private Vector<Object> pathObjects;

    public ColumnBreakColumn() {
    }

    public ColumnBreakColumn(String name, IFormat dataFormat, int colBKValIdx, int noOfCol) {
        super(name, dataFormat, noOfCol);
        this.colBkValIdx = colBKValIdx;
    }

    public ColumnBreakColumn(ColumnBreakColumn col) {
        super(col);
        this.colBkValIdx = col.colBkValIdx;
        this.parentColName = col.parentColName;
    }

    public ColumnBreakColumn(ColumnBreakColumn col, Properties treeProp) {
        super(col, treeProp);
        this.colBkValIdx = col.colBkValIdx;
        this.parentColName = col.parentColName;
    }

    public int getColBreakValueIndex() {
        return this.colBkValIdx;
    }

    public void setParentColumnName(String tmp) {
        this.parentColName = tmp;
    }

    public String getParentColumnName() {
        return this.parentColName;
    }

    public Vector<Object> getPathObjects() {
        return this.pathObjects;
    }

    public void setPathObjects(Vector<Object> pathObjects) {
        this.pathObjects = new Vector<Object>(pathObjects);
    }

    public Object getText(Report report, int colInfoIndex) {
        int level = 0;
        for (int i = report.colInfo.length - 1; i > colInfoIndex && i >= 0; --i) {
            if (!report.colInfo[i].isColumnBreak()) continue;
            ++level;
        }
        if (level == 0) {
            if (report.getColumnBreakValueCount() > 1 && !report.placeColumnBreakValueVertically()) {
                return this.parentColName;
            }
            return this.getText();
        }
        return this.pathObjects.get(this.pathObjects.size() - level);
    }

    @Override
    public void copyTemplate(ReportColumn col, boolean b) {
        super.copyTemplate(col, b);
    }

    @Override
    public void copy(ReportColumn col) {
        if (col instanceof ColumnBreakColumn) {
            this.colBkValIdx = ((ColumnBreakColumn)col).colBkValIdx;
            this.parentColName = ((ColumnBreakColumn)col).parentColName;
            this.pathObjects = ((ColumnBreakColumn)col).pathObjects;
        }
        super.copy(col);
    }

    @Override
    public void deepCopy(ReportColumn col) {
        if (col instanceof ColumnBreakColumn) {
            this.colBkValIdx = ((ColumnBreakColumn)col).colBkValIdx;
            this.parentColName = ((ColumnBreakColumn)col).parentColName;
            this.pathObjects = ((ColumnBreakColumn)col).pathObjects;
        }
        super.deepCopy(col);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeInt(this.colBkValIdx);
        super.write(out);
    }

    @Override
    public void read(DataInput in, int version) throws Exception {
        if (version >= 278) {
            this.colBkValIdx = in.readInt();
        }
        super.read(in, version);
    }

    public static ColumnBreakColumn createColumnBreakColumn(DataInput in, int version) throws Exception {
        ColumnBreakColumn cbColumn = new ColumnBreakColumn();
        cbColumn.read(in, version);
        return cbColumn;
    }

    @Override
    public void writeXML(Writer out, boolean writeElementTag) throws IOException {
        if (writeElementTag) {
            out.write("<COLUMNBREAKCOLUMN>\n");
        }
        out.write("<COLUMNBREAKCOLUMN_COLBKVALIDX>" + this.colBkValIdx + "</COLUMNBREAKCOLUMN_COLBKVALIDX>\n");
        super.writeXML(out, false);
        if (writeElementTag) {
            out.write("</COLUMNBREAKCOLUMN>\n");
        }
    }

    @Override
    public void readXML(Node node, int version) throws Exception {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node child = nodeList.item(i);
            if (!child.getNodeName().equalsIgnoreCase("COLUMNBREAKCOLUMN_COLBKVALIDX")) continue;
            this.colBkValIdx = Integer.parseInt(LoadXMLReportHelper.readText(child).trim());
        }
        super.readXML(node, version);
    }

    public static ColumnBreakColumn createColumnBreakColumn(Node node, int version) throws Exception {
        if (!node.getNodeName().equalsIgnoreCase(XMLTAG)) {
            throw new Exception("'COLUMNBREAKCOLUMN' element expected, but found '" + node.getNodeName() + "' element.");
        }
        ColumnBreakColumn column = new ColumnBreakColumn();
        column.readXML(node, version);
        return column;
    }

    public Object clone() {
        ColumnBreakColumn _new = new ColumnBreakColumn();
        _new.copy(this);
        return _new;
    }
}

