/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.ReportElements;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Writer;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.report.LoadXMLReportHelper;

public class ColumnHeader
extends ReportCell {
    public boolean isFormula = true;
    static String XMLTAG = "COLUMNHEADER";

    public void applyTemplate(ColumnHeader colHeader) {
        super.applyTemplate(colHeader);
        this.isFormula = colHeader.isFormula;
    }

    public void applyTemplate(ColumnHeader colHeader, boolean applyScript) {
        super.applyTemplate(colHeader, applyScript);
        this.isFormula = colHeader.isFormula;
        if (!this.isFormula) {
            this.setText(colHeader.getText());
        }
    }

    public void copyTemplate(ColumnHeader colHeader) {
        super.copyTemplate(colHeader);
        this.isFormula = colHeader.isFormula;
    }

    public void applyStyle(ColumnHeader colHeader) {
        super.applyStyle(colHeader);
        this.isFormula = colHeader.isFormula;
        if (!this.isFormula) {
            this.setText(colHeader.getText());
        }
    }

    public void copy(ColumnHeader colHeader) {
        super.copy(colHeader);
        this.isFormula = colHeader.isFormula;
        if (!this.isFormula) {
            this.setText(colHeader.getText());
        }
    }

    public void deepCopy(ColumnHeader colHeader) {
        super.deepCopy(colHeader);
        this.isFormula = colHeader.isFormula;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeBoolean(this.isFormula);
        super.write(out);
    }

    @Override
    public void writeXML(Writer out, boolean writeElementTag) throws IOException {
        if (writeElementTag) {
            out.write("<" + XMLTAG + ">\n");
        }
        out.write("<COLUMNHEADER_ISFORMULA>" + this.isFormula + "</COLUMNHEADER_ISFORMULA>\n");
        super.writeXML(out, false);
        if (writeElementTag) {
            out.write("</" + XMLTAG + ">\n");
        }
    }

    @Override
    public void read(DataInput in, int version) throws Exception {
        this.isFormula = in.readBoolean();
        super.read(in, version);
    }

    @Override
    public void readXML(Node node, int version) throws Exception {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node child = nodeList.item(i);
            if (!child.getNodeName().equalsIgnoreCase("COLUMNHEADER_ISFORMULA")) continue;
            this.isFormula = LoadXMLReportHelper.parseBoolean(LoadXMLReportHelper.readText(child));
        }
        super.readXML(node, version);
    }

    public static ColumnHeader createColumnHeader(Node node, int version) throws Exception {
        if (!node.getNodeName().equalsIgnoreCase(XMLTAG)) {
            throw new Exception("'" + XMLTAG + "' element expected, but found '" + node.getNodeName() + "' element.");
        }
        ColumnHeader columnHeader = new ColumnHeader();
        columnHeader.readXML(node, version);
        return columnHeader;
    }

    public static ColumnHeader createColumnHeader(DataInput in, int version) throws Exception {
        ColumnHeader columnHeader = new ColumnHeader();
        columnHeader.read(in, version);
        return columnHeader;
    }
}

