/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.ReportElements;

import java.awt.Color;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Writer;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import quadbase.common.util.internal.QbUtil;
import quadbase.reportdesigner.ReportElements.ReportLine;
import quadbase.reportdesigner.report.LoadXMLReportHelper;

public class ColumnWrap
extends ReportLine {
    int wrapCount = 1;
    public static final String XMLTAG = "COLUMNWRAP";

    private ColumnWrap() {
        super(true);
    }

    public ColumnWrap(double x) {
        super(true);
        this.setBgColor(Color.lightGray);
        this.setX(x);
        this.setHeight(-1.0);
        this.setWidth(QbUtil.toInch(5.0));
        this.setY(0.0);
    }

    public void setWrapCount(int ct) {
        for (ColumnWrap node = (ColumnWrap)this.getHeadNode(); node != null; node = (ColumnWrap)node.next()) {
            node.wrapCount = ct;
        }
    }

    public int getWrapCount() {
        return this.wrapCount;
    }

    @Override
    public void setY(double yy) {
        super.setY(0.0);
    }

    public void copy(ColumnWrap _line) {
        super.copy(_line);
        this.setWrapCount(_line.getWrapCount());
    }

    public void deepCopy(ColumnWrap _line) {
        super.deepCopy(_line);
        this.setWrapCount(_line.getWrapCount());
    }

    public void applyTemplate(ColumnWrap _line) {
        super.applyTemplate(_line);
        this.setWrapCount(_line.getWrapCount());
    }

    public void copyTemplate(ColumnWrap _line) {
        super.copyTemplate(_line);
        this.setWrapCount(_line.getWrapCount());
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeInt(this.getWrapCount());
    }

    @Override
    public void writeXML(Writer out, boolean writeElementTag) throws IOException {
        if (writeElementTag) {
            out.write("<COLUMNWRAP>\n");
        }
        super.writeXML(out, false);
        out.write("<COLUMNWRAP_WRAPCOUNT>" + this.getWrapCount() + "</COLUMNWRAP_WRAPCOUNT>\n");
        if (writeElementTag) {
            out.write("</COLUMNWRAP>\n");
        }
    }

    public static ColumnWrap createColumnWrap(Node node, int version) throws Exception {
        if (!node.getNodeName().equalsIgnoreCase(XMLTAG)) {
            throw new Exception("'COLUMNWRAP' element expected, but found '" + node.getNodeName() + "' element.");
        }
        ColumnWrap cell = new ColumnWrap();
        cell.readXML(node, version);
        return cell;
    }

    @Override
    public void readXML(Node node, int version) throws Exception {
        super.readXML(node, version);
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node child = nodeList.item(i);
            if (!child.getNodeName().equalsIgnoreCase("COLUMNWRAP_WRAPCOUNT")) continue;
            this.setWrapCount(Integer.parseInt(LoadXMLReportHelper.readText(child)));
        }
    }

    public static ColumnWrap createColumnWrap(DataInput in, int version) throws Exception {
        ColumnWrap cell = new ColumnWrap();
        cell.read(in, version);
        return cell;
    }

    @Override
    public void read(DataInput in, int version) throws Exception {
        super.read(in, version);
        this.setWrapCount(in.readInt());
    }
}

