/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.ReportElements;

import java.util.Vector;
import quadbase.reportdesigner.ReportElements.CBAggrColFooter;
import quadbase.reportdesigner.ReportElements.CBAggrColHeader;
import quadbase.reportdesigner.ReportElements.CBAggrColumn;
import quadbase.reportdesigner.ReportElements.CBColumnFooter;
import quadbase.reportdesigner.ReportElements.CBColumnHeader;
import quadbase.reportdesigner.ReportElements.ColumnBreakColumn;
import quadbase.reportdesigner.ReportElements.ColumnHeader;
import quadbase.reportdesigner.ReportElements.RBColumnHeader;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportColumn;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.ReportElements.ReportImage;
import quadbase.reportdesigner.ReportElements.ReportLine;
import quadbase.reportdesigner.ReportElements.ReportSection;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.ReportElements.ReportTableElement;
import quadbase.reportdesigner.util.internal.FormatUtil;

public class CrossTabReportSection
extends ReportSection {
    public CrossTabReportSection() {
    }

    public CrossTabReportSection(ReportTableElement reporttableelement) {
        super(reporttableelement);
    }

    public void copyTemplate(ReportSection reportSection, boolean copyEmptySection, boolean applyScript, Vector columns, int[] fieldsCount, boolean isCrossTabSummaryColToL, boolean isAddCrossTabSubTotalColumn) {
        Vector<ReportCell> oldsubreports = this.getOldSubReports();
        Vector oldSectionList = this.sectionList;
        this.copy(reportSection, 0, -1, columns, null, true, copyEmptySection, false, applyScript, false, fieldsCount, isCrossTabSummaryColToL, isAddCrossTabSubTotalColumn, null, null);
        this.copyTemplates(oldsubreports, oldSectionList);
    }

    public void copy(ReportSection reportSection, int columnOffset, int separatingIndex, Vector columns, ReportCell[] globalFormatTemplates, boolean isApplyTemplateOp, boolean copyEmptySection, boolean copyGuideLine, boolean applyScript, boolean keepElt, int[] fieldsCount, boolean isCrossTabSubTotalColumnPositionLeft, boolean isAddCrossTabSubTotalColumn, ReportSection parentHeader, Vector newColumns) {
        if (parentHeader != null && this.getData().length == 0 && reportSection.isCrossTabFixedFieldHeader()) {
            this.setData(ReportTable.cloneNewData(parentHeader.getData()));
        }
        this.copy(null, reportSection, columnOffset, separatingIndex, columns, globalFormatTemplates, isApplyTemplateOp, copyEmptySection, copyGuideLine, applyScript, keepElt, fieldsCount, isCrossTabSubTotalColumnPositionLeft, isAddCrossTabSubTotalColumn, newColumns);
    }

    private void copy(ReportCell[] orgNewCells, ReportSection reportSection, int columnOffset, int separatingIndex, Vector columns, ReportCell[] globalFormatTemplates, boolean isApplyTemplateOp, boolean copyEmptySection, boolean copyGuideLine, boolean applyScript, boolean keepElt, int[] fieldsCount, boolean isCrossTabSubTotalColumnPositionLeft, boolean isAddCrossTabSubTotalColumn, Vector newColumns) {
        ReportElement[] newCells;
        this.superCopy(reportSection);
        this.setRepeatOnEveryPage(reportSection.isRepeatOnEveryPage());
        this.setResetPageNumber(reportSection.isResetPageNumber());
        this.setNewExcelSheet(reportSection.isNewExcelSheet());
        this.isModified = reportSection.isModified;
        this.setSectionStyle(reportSection.getSectionStyle());
        CrossTabReportSection temp = null;
        boolean isCrossTabFixedField = false;
        int columnBreakValueCount = 1;
        ReportSection cloneSection = null;
        if (columns != null) {
            isCrossTabFixedField = CrossTabReportSection.isCrossTabFixedField(columns);
            if (isCrossTabFixedField) {
                Vector<ReportElement> firstRowOfColumns = CrossTabReportSection.getFirstRowOfColumns(columns);
                columnBreakValueCount = CrossTabReportSection.getColBreakValueCount(firstRowOfColumns);
                if (this.containsFixedFieldCrossTabElement(this) && !this.containsFixedFieldCrossTabElement(reportSection)) {
                    cloneSection = new ReportSection();
                    cloneSection.setDataForDeepCopy(this.getData());
                }
            } else {
                columnBreakValueCount = CrossTabReportSection.getColBreakValueCount(columns);
            }
        }
        if (columnOffset != 0 && separatingIndex >= 0 && columns != null && reportSection.getCellCount() > 0) {
            newCells = null;
            temp = new CrossTabReportSection();
            temp.setDataForDeepCopy(reportSection.getData());
            if (isCrossTabFixedField) {
                ReportCell[] irCells = reportSection.getDataIgnoreRepeatCells();
                boolean bl = isCrossTabFixedField = reportSection.getData().length != irCells.length;
                if (isCrossTabFixedField) {
                    reportSection.setData(irCells);
                } else {
                    this.setData(this.getDataIgnoreRepeatCells());
                }
            }
            reportSection.adjustColumnIndex(columnOffset, separatingIndex, columns, globalFormatTemplates, newColumns != null ? newColumns.size() : columns.size());
            if (orgNewCells == null) {
                orgNewCells = this.findExtraCrossTabCells(columnOffset, separatingIndex, isCrossTabFixedField);
            }
            if (orgNewCells != null) {
                newCells = new ReportCell[orgNewCells.length];
                for (int i = 0; i < orgNewCells.length; ++i) {
                    newCells[i] = ReportCell.clone(orgNewCells[i]);
                }
            }
            if (newCells != null) {
                ReportCell columnHeaderSettings = null;
                ReportCell stringFormulaSettings = null;
                ReportCell logicFormulaSettings = null;
                ReportCell numericFormulaSettings = null;
                ReportCell timeFormulaSettings = null;
                if (globalFormatTemplates != null && globalFormatTemplates.length > 0) {
                    stringFormulaSettings = globalFormatTemplates[0];
                }
                if (globalFormatTemplates != null && globalFormatTemplates.length > 1) {
                    columnHeaderSettings = globalFormatTemplates[1];
                }
                if (globalFormatTemplates != null && globalFormatTemplates.length > 2) {
                    logicFormulaSettings = globalFormatTemplates[2];
                }
                if (globalFormatTemplates != null && globalFormatTemplates.length > 3) {
                    numericFormulaSettings = globalFormatTemplates[3];
                }
                if (globalFormatTemplates != null && globalFormatTemplates.length > 4) {
                    timeFormulaSettings = globalFormatTemplates[4];
                }
                double supposeXPos = 0.0;
                if (separatingIndex - 1 >= 0 && separatingIndex - 1 < columns.size()) {
                    supposeXPos = ((ReportColumn)columns.elementAt(separatingIndex - 1)).getX() + ((ReportColumn)columns.elementAt(separatingIndex - 1)).getWidth();
                }
                ReportElement[] reportElementArray = newCells;
                int n = reportElementArray.length;
                for (int i = 0; i < n; ++i) {
                    ReportElement newCell = reportElementArray[i];
                    if (newCell == null) continue;
                    double x = newCell.getX();
                    boolean isVisible = newCell.isVisible();
                    if (isCrossTabFixedField) {
                        ReportCell tmpCell;
                        if (newCell instanceof CBColumnHeader) {
                            ((CBColumnHeader)newCell).applyTemplate(temp.getFirstCBColumnHeader(((CBColumnHeader)newCell).getColBreakValueIndex()), true);
                        } else if (newCell instanceof RBColumnHeader) {
                            tmpCell = temp.getFirstRBColumnHeader(((RBColumnHeader)newCell).getColBreakLevel());
                            if (tmpCell != null) {
                                if (tmpCell instanceof RBColumnHeader) {
                                    ((RBColumnHeader)newCell).applyTemplate((RBColumnHeader)tmpCell, true);
                                } else {
                                    ((ReportCell)newCell).applyTemplate(tmpCell, true);
                                }
                            }
                        } else if (newCell instanceof CBAggrColHeader) {
                            tmpCell = temp.getFirstCBAggrColHeader(((CBAggrColHeader)newCell).getColBreakLevel(), ((CBAggrColHeader)newCell).getColBreakValueIndex());
                            if (tmpCell instanceof CBAggrColHeader) {
                                ((CBAggrColHeader)newCell).applyTemplate((CBAggrColHeader)tmpCell, true);
                            } else {
                                ((ReportCell)newCell).applyTemplate(tmpCell, true);
                            }
                        } else if (newCell instanceof CBColumnFooter) {
                            ((ReportCell)newCell).applyTemplate(temp.getFirstCBColumnFooter(((CBColumnFooter)newCell).getColBreakValueIndex()), true);
                            newCell.setX(x);
                        } else if (newCell instanceof CBAggrColFooter) {
                            ((ReportCell)newCell).applyTemplate(temp.getFirstCBAggrColFooter(((CBAggrColFooter)newCell).getColBreakLevel(), ((CBAggrColFooter)newCell).getColBreakValueIndex()), true);
                        } else if (temp.getCellCount() > 0 && temp.getData(temp.getCellCount() - 1) != null && !(temp.getData(temp.getCellCount() - 1) instanceof ReportLine)) {
                            ((ReportCell)newCell).applyTemplate(temp.getData(temp.getCellCount() - 1), true);
                        }
                        newCell.setX(x);
                    } else {
                        if (this.idExists(newCell.getID(), reportSection.getData())) {
                            newCell.setID(this.getID(), reportSection.getData());
                        }
                        if (reportSection.getCellCount() > 0 && reportSection.getData(reportSection.getCellCount() - 1) != null && !(reportSection.getData(reportSection.getCellCount() - 1) instanceof ReportLine)) {
                            ((ReportCell)newCell).applyTemplate(reportSection.getData(reportSection.getCellCount() - 1), true);
                        }
                        if (newCell instanceof ColumnHeader && columnHeaderSettings != null) {
                            ((ReportCell)newCell).applyTemplate(columnHeaderSettings, true);
                            x = x * columnHeaderSettings.getWidth() + supposeXPos;
                        } else if (stringFormulaSettings != null && FormatUtil.isFormatAppliabled(((ReportCell)newCell).getDataFormat(), stringFormulaSettings.getDataFormat())) {
                            ((ReportCell)newCell).applyTemplate(stringFormulaSettings, true);
                            x = x * stringFormulaSettings.getWidth() + supposeXPos;
                        } else if (logicFormulaSettings != null && FormatUtil.isFormatAppliabled(((ReportCell)newCell).getDataFormat(), logicFormulaSettings.getDataFormat())) {
                            ((ReportCell)newCell).applyTemplate(logicFormulaSettings, true);
                            x = x * logicFormulaSettings.getWidth() + supposeXPos;
                        } else if (numericFormulaSettings != null && FormatUtil.isFormatAppliabled(((ReportCell)newCell).getDataFormat(), numericFormulaSettings.getDataFormat())) {
                            ((ReportCell)newCell).applyTemplate(numericFormulaSettings, true);
                            x = x * numericFormulaSettings.getWidth() + supposeXPos;
                        } else if (timeFormulaSettings != null && FormatUtil.isFormatAppliabled(((ReportCell)newCell).getDataFormat(), timeFormulaSettings.getDataFormat())) {
                            ((ReportCell)newCell).applyTemplate(timeFormulaSettings, true);
                            x = x * timeFormulaSettings.getWidth() + supposeXPos;
                        }
                        newCell.setX(x);
                    }
                    newCell.setVisible(isVisible);
                    reportSection.addData((ReportCell)newCell);
                }
            }
            if (isCrossTabFixedField) {
                int[] rowBkIdx = columnBreakValueCount > 1 ? new int[fieldsCount.length + 1] : new int[fieldsCount.length];
                for (int i = 0; i < rowBkIdx.length; ++i) {
                    rowBkIdx[i] = 0;
                }
                ReportElement[] newCellsX = ReportElement.sortElement(newCells, 1, true);
                boolean rbColumnHeaderWidthEqualsToZero = false;
                int rbVisibleCtn = 0;
                for (int i = 0; i < newCellsX.length; ++i) {
                    if (!(newCellsX[i] instanceof RBColumnHeader)) continue;
                    int rowBkLevel = ((RBColumnHeader)newCellsX[i]).getColBreakLevel();
                    this.calcRBColumnHeaderWidth((RBColumnHeader)newCellsX[i], newColumns, fieldsCount, isCrossTabSubTotalColumnPositionLeft, isAddCrossTabSubTotalColumn, rowBkIdx[rowBkLevel]);
                    int n = rowBkLevel;
                    rowBkIdx[n] = rowBkIdx[n] + 1;
                    rbColumnHeaderWidthEqualsToZero = newCellsX[i].getWidth() == 0.0;
                    rbVisibleCtn += rbColumnHeaderWidthEqualsToZero ? 1 : 0;
                }
                int totalCBHeader = columnBreakValueCount * rbVisibleCtn;
                int cnt = 0;
                for (ReportElement element : newCellsX) {
                    if (element instanceof CBColumnHeader) {
                        if (cnt < totalCBHeader) {
                            element.setVisible(false);
                        }
                        ++cnt;
                        continue;
                    }
                    if (cnt >= totalCBHeader || !(element instanceof CBColumnFooter)) continue;
                    element.setVisible(false);
                }
            }
        }
        if (!isApplyTemplateOp || copyEmptySection || reportSection.getData() != null && reportSection.getData().length > 0) {
            if (reportSection.isLineOnly() && keepElt && reportSection.getData() != null && reportSection.getData().length > 0) {
                for (ReportCell cell : reportSection.cells) {
                    this.addData(cell);
                }
            } else {
                newCells = reportSection.getData();
                for (int j = 0; j < newCells.length; ++j) {
                    ReportCell newCell = newCells[j];
                    if (j >= this.cells.length || !this.cells[j].getID().equals(newCell.getID()) || !this.cells[j].getClass().equals(newCell.getClass())) continue;
                    newCells[j] = this.cells[j];
                    newCells[j].applyTemplate(newCell);
                    if (newCells[j] instanceof ColumnHeader) {
                        ((ColumnHeader)newCells[j]).isFormula = ((ColumnHeader)newCell).isFormula;
                        newCells[j].setText(newCell.getText());
                        boolean visible = newCells[j].isVisible();
                        ((ReportCell)newCells[j]).copyTemplate(newCell);
                        if (visible || !newCells[j].isVisible()) continue;
                        newCells[j].setVisible(false);
                        continue;
                    }
                    if (newCells[j] instanceof RBColumnHeader) {
                        ((RBColumnHeader)newCells[j]).isFormula = ((RBColumnHeader)newCell).isFormula;
                        newCells[j].setScriptObj(newCell.getScriptObj());
                        newCells[j].setScriptName(newCell.getScriptName());
                        newCells[j].setScript(newCell.getScript());
                        continue;
                    }
                    newCells[j].setText(newCell.getText());
                    ((ReportCell)newCells[j]).copyTemplate(newCell);
                }
                this.setData((ReportCell[])newCells);
                if (isApplyTemplateOp) {
                    for (int i = 0; i < this.cells.length; ++i) {
                        this.cells[i].securityMap = null;
                        if (applyScript) continue;
                        this.cells[i].setScriptName(null);
                        this.cells[i].setScriptObj(null);
                        this.cells[i].setScript(null);
                    }
                }
            }
        }
        Vector<CrossTabReportSection> newSectionList = new Vector<CrossTabReportSection>();
        for (int i = 0; i < reportSection.sectionList.size(); ++i) {
            ReportSection subSection = reportSection.sectionList.elementAt(i);
            CrossTabReportSection _subSection = new CrossTabReportSection();
            _subSection.copy(subSection);
            if (!isApplyTemplateOp || copyEmptySection || _subSection.getData() != null && _subSection.getData().length > 0) {
                newSectionList.addElement(_subSection);
                _subSection.parentSection = this;
                if (isApplyTemplateOp && !applyScript) {
                    for (int j = 0; j < _subSection.getCellCount(); ++j) {
                        _subSection.getData(j).setScriptName(null);
                        _subSection.getData(j).setScriptObj(null);
                        _subSection.getData(j).setScript(null);
                    }
                }
            } else if (this.sectionList.size() > i) {
                newSectionList.addElement((CrossTabReportSection)this.sectionList.elementAt(i));
            }
            if (!copyGuideLine) {
                _subSection.setData(_subSection.getDataNoGuideLine());
            }
            if (!isCrossTabFixedField) continue;
            ReportSection orgSection = new ReportSection();
            orgSection.copy(_subSection);
            orgSection.setDataForDeepCopy(_subSection.getData());
            if (orgNewCells == null && cloneSection != null && this.containsFixedFieldCrossTabElement(_subSection)) {
                _subSection.setData(cloneSection.getData());
            }
            if (orgSection.getID().endsWith("_FTR" + i) || orgSection.getID().endsWith("_HDR" + i)) continue;
            _subSection.copy(orgNewCells, orgSection, columnOffset, separatingIndex, columns, globalFormatTemplates, isApplyTemplateOp, copyEmptySection, copyGuideLine, applyScript, keepElt, fieldsCount, isCrossTabSubTotalColumnPositionLeft, isAddCrossTabSubTotalColumn, newColumns);
        }
        this.sectionList = newSectionList;
        if (temp != null) {
            reportSection.setData(temp.getData());
        }
        if (!copyGuideLine) {
            this.setData(this.getDataNoGuideLine());
        }
        if (isCrossTabFixedField) {
            CrossTabReportSection.repositionCells(reportSection, this, columns, fieldsCount, false, isCrossTabSubTotalColumnPositionLeft, isAddCrossTabSubTotalColumn);
        }
    }

    private boolean containsFixedFieldCrossTabElement(ReportSection sec) {
        for (int i = 0; i < sec.getCellCount(); ++i) {
            if (!(sec.getData(i) instanceof CBColumnHeader) && !(sec.getData(i) instanceof CBColumnFooter) && !(sec.getData(i) instanceof RBColumnHeader)) continue;
            return true;
        }
        return false;
    }

    private ReportCell[] findExtraCrossTabCells(int columnOffSet, int separatingIndex, boolean isCrossTabFixedField) {
        int i;
        ReportCell[] cs = this.getData();
        if (isCrossTabFixedField ? cs == null : cs == null || columnOffSet <= 0) {
            return new ReportCell[0];
        }
        Vector<ReportCell> newCells = new Vector<ReportCell>();
        for (i = cs.length - 1; i >= 0; --i) {
            String formula;
            if (isCrossTabFixedField && (cs[i] instanceof CBAggrColHeader || cs[i] instanceof CBColumnHeader || cs[i] instanceof RBColumnHeader || cs[i] instanceof CBAggrColFooter || cs[i] instanceof CBColumnFooter)) {
                newCells.addElement(cs[i]);
            }
            if ((formula = cs[i].getFormula()) == null) {
                formula = cs[i].getFormulaName();
            }
            if (formula == null) continue;
            try {
                int endindex;
                String indexstring;
                int oldindex;
                int colindex = formula.toLowerCase().indexOf("col(");
                if (colindex <= -1 || (oldindex = Integer.parseInt((indexstring = formula.substring(colindex + 4, endindex = formula.indexOf(")", colindex))).trim())) < separatingIndex || oldindex >= separatingIndex + columnOffSet || isCrossTabFixedField) continue;
                newCells.addElement(cs[i]);
                cs[i].setX(oldindex - separatingIndex);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        cs = new ReportCell[newCells.size()];
        for (i = 0; i < cs.length; ++i) {
            cs[i] = (ReportCell)newCells.elementAt(i);
        }
        return cs;
    }

    public static void repositionCells(ReportSection orgSec, ReportSection sec, Vector cols, int[] fieldsCount, boolean repositionNestLevelOnly, boolean isCTSummaryColumnToL, boolean isAddCrossTabSubTotalColumn) {
        Vector orgCellRows = orgSec.getTextCellForHTML();
        Vector cellRows = sec.getTextCellForHTML(true);
        Vector<ReportElement> columns = CrossTabReportSection.getFirstRowOfColumns(cols);
        if (orgCellRows.size() == 0 || cellRows.size() == 0) {
            return;
        }
        int orgCellRowsID = orgCellRows.size() - 1;
        int cellRowsID = cellRows.size() - 1;
        CrossTabReportSection.repositionCells(orgSec, sec, columns, fieldsCount, repositionNestLevelOnly, isCTSummaryColumnToL, isAddCrossTabSubTotalColumn, orgCellRows, cellRows, orgCellRowsID, cellRowsID);
    }

    public static void repositionCells(ReportSection orgSec, ReportSection sec, Vector columns, int[] fieldsCount, boolean repositionNestLevelOnly, boolean isCTSummaryColumnToL, boolean isAddCrossTabSubTotalColumn, Vector orgCellRows, Vector cellRows, int orgCellRowsID, int cellRowsID) {
        int j;
        int k;
        ReportCell[] oCells = (ReportCell[])orgCellRows.elementAt(orgCellRowsID);
        ReportCell[] rCells = (ReportCell[])cellRows.elementAt(cellRowsID);
        for (k = 0; !(k >= oCells.length || oCells[k] instanceof CBAggrColHeader || oCells[k] instanceof CBAggrColFooter || oCells[k] instanceof CBColumnHeader || oCells[k] instanceof CBColumnFooter); ++k) {
        }
        if (k >= oCells.length) {
            return;
        }
        ReportCell[] newrCells = new ReportCell[rCells.length];
        for (int j2 = 0; j2 < k; ++j2) {
            newrCells[j2] = rCells[j2];
        }
        Vector<ReportCell> regCells = new Vector<ReportCell>();
        int idx = k;
        boolean isFooterElt = false;
        for (j = k; j < rCells.length; ++j) {
            if (rCells[j] instanceof CBAggrColHeader || rCells[j] instanceof CBAggrColFooter || rCells[j] instanceof CBColumnHeader || rCells[j] instanceof CBColumnFooter) {
                newrCells[idx] = rCells[j];
                if (rCells[j] instanceof CBAggrColFooter || rCells[j] instanceof CBColumnFooter) {
                    isFooterElt = true;
                }
                ++idx;
                continue;
            }
            regCells.addElement(rCells[j]);
        }
        for (j = 0; j < regCells.size(); ++j) {
            newrCells[idx] = (ReportCell)regCells.elementAt(j);
            ++idx;
        }
        if (!repositionNestLevelOnly) {
            CrossTabReportSection.repositionColBreakRow(oCells, newrCells, k);
            if (cellRowsID >= 1) {
                CrossTabReportSection.repositionCells(orgSec, sec, columns, fieldsCount, repositionNestLevelOnly, isCTSummaryColumnToL, isAddCrossTabSubTotalColumn, orgCellRows, cellRows, orgCellRowsID - 1, cellRowsID - 1);
            }
        }
        if (!isFooterElt) {
            block4: for (int i = cellRowsID - 1; i >= 0; --i) {
                rCells = (ReportCell[])cellRows.elementAt(i);
                for (int g = 0; g < rCells.length; ++g) {
                    if (!(rCells[g] instanceof RBColumnHeader)) continue;
                    CrossTabReportSection.repositionRowBreakRow(rCells, g, columns, fieldsCount, isCTSummaryColumnToL, isAddCrossTabSubTotalColumn);
                    continue block4;
                }
            }
        }
    }

    private static void repositionRowBreakRow(ReportCell[] rCells, int g, Vector columns, int[] fieldsCount, boolean isCTSummaryColumnToL, boolean isAddCrossTabSubTotalColumn) {
        int rowBKLevel = ((RBColumnHeader)rCells[g]).getColBreakLevel();
        double startX = 0.0;
        if (columns == null) {
            return;
        }
        ReportElement[] cols = new ReportElement[columns.size()];
        for (int j = 0; j < columns.size(); ++j) {
            cols[j] = (ReportElement)columns.elementAt(j);
        }
        for (ReportElement col : cols = ReportElement.sortElement(cols, 1, true)) {
            if (!(col instanceof ColumnBreakColumn) && !(col instanceof CBAggrColumn)) continue;
            startX = ((ReportColumn)col).getX();
            break;
        }
        CrossTabReportSection.setRowBreakLabelX(0, rowBKLevel, g, startX, rCells, cols, fieldsCount, isCTSummaryColumnToL, isAddCrossTabSubTotalColumn);
    }

    private static double[] setRowBreakLabelX(int level, int rowBKLevel, int g, double startX, ReportCell[] rCells, ReportElement[] columns, int[] fieldsCount, boolean isCrossTabSubTotalColumnPositionLeft, boolean isAddCrossTabSubTotalColumn) {
        if (fieldsCount == null) {
            return null;
        }
        ReportCell prevCell = null;
        CBAggrColumn[] aggrCol = null;
        if (level != 0) {
            aggrCol = CrossTabReportSection.getCBAggrColumns(columns, level, fieldsCount.length);
        }
        RBColumnHeader lastRBColumnHeaderCell = null;
        for (ReportCell rCell : rCells) {
            if (!(rCell instanceof RBColumnHeader)) continue;
            lastRBColumnHeaderCell = (RBColumnHeader)rCell;
        }
        for (int i = 0; i < fieldsCount[level]; ++i) {
            if (g >= rCells.length) continue;
            if (isAddCrossTabSubTotalColumn && isCrossTabSubTotalColumnPositionLeft && aggrCol != null && i == 0 && level != 0) {
                CBAggrColumn[] cBAggrColumnArray = aggrCol;
                int n = cBAggrColumnArray.length;
                for (int rCell = 0; rCell < n; ++rCell) {
                    CBAggrColumn element = cBAggrColumnArray[rCell];
                    rCells[g].setWidth(rCells[g].getWidth() + element.getWidth());
                    if (!(rCells[g] instanceof RBColumnHeader)) continue;
                    ((RBColumnHeader)rCells[g]).addBreakDownCell(element.getWidth());
                }
            }
            if (level == rowBKLevel) {
                if (!(rCells[g] instanceof RBColumnHeader) && lastRBColumnHeaderCell != null) {
                    rCells[g].setX(lastRBColumnHeaderCell.getX() + lastRBColumnHeaderCell.getWidth());
                } else {
                    rCells[g].setX(startX);
                    prevCell = rCells[g];
                    startX += rCells[g].getWidth();
                }
                if (++g <= fieldsCount[level] || g >= rCells.length || rCells[g] instanceof RBColumnHeader || lastRBColumnHeaderCell == null) continue;
                rCells[g].setX(lastRBColumnHeaderCell.getX() + lastRBColumnHeaderCell.getWidth());
                continue;
            }
            double[] val = CrossTabReportSection.setRowBreakLabelX(level + 1, rowBKLevel, g, startX, rCells, columns, fieldsCount, isCrossTabSubTotalColumnPositionLeft, isAddCrossTabSubTotalColumn);
            startX = val[0];
            g = (int)val[1];
            prevCell = rCells[g - 1];
        }
        if (isAddCrossTabSubTotalColumn && !isCrossTabSubTotalColumnPositionLeft && aggrCol != null) {
            for (CBAggrColumn element : aggrCol) {
                startX += element.getWidth();
                if (prevCell == null) continue;
                prevCell.setWidth(prevCell.getWidth() + element.getWidth());
                if (!(prevCell instanceof RBColumnHeader)) continue;
                ((RBColumnHeader)prevCell).addBreakDownCell(element.getWidth());
            }
        }
        double[] val = new double[]{startX, g};
        if (!(rCells[rCells.length - 1] instanceof RBColumnHeader)) {
            rCells[rCells.length - 1].setX(lastRBColumnHeaderCell.getX() + lastRBColumnHeaderCell.getWidth());
        }
        return val;
    }

    private static ReportCell[] repositionColBreakRow(ReportCell[] oCells, ReportCell[] rCells, int stIdx) {
        rCells = CrossTabReportSection.rearrangeColumnBreakHeaderFooterCells(oCells, rCells);
        double offset = 0.0;
        ReportCell curCell = null;
        ReportElement prevCell = null;
        int i = 0;
        for (i = stIdx; i < rCells.length; ++i) {
            curCell = rCells[i];
            if (curCell == null || !curCell.isVisible()) continue;
            if (!(curCell instanceof CBAggrColHeader) && !(curCell instanceof CBAggrColFooter) && !(curCell instanceof CBColumnHeader) && !(curCell instanceof CBColumnFooter)) break;
            if (prevCell != null) {
                curCell.setX(prevCell.getX() + prevCell.getWidth());
            } else {
                ReportCell tmpCell = CrossTabReportSection.getFirstCell(oCells);
                if (tmpCell != null) {
                    curCell.setX(tmpCell.getX());
                }
            }
            offset += curCell.getWidth();
            prevCell = curCell;
        }
        for (int j = stIdx; j < oCells.length; ++j) {
            curCell = oCells[j];
            if (curCell == null || !curCell.isVisible()) continue;
            if (curCell instanceof CBAggrColHeader || curCell instanceof CBAggrColFooter || curCell instanceof CBColumnHeader || curCell instanceof CBColumnFooter) {
                offset -= curCell.getWidth();
                continue;
            }
            if (i < rCells.length) {
                rCells[i].setX(curCell.getX() + offset);
            }
            ++i;
        }
        return rCells;
    }

    private static ReportCell getFirstCell(ReportCell[] oCells) {
        for (ReportCell oCell : oCells) {
            if (!(oCell instanceof CBAggrColHeader) && !(oCell instanceof CBAggrColFooter) && !(oCell instanceof CBColumnHeader) && !(oCell instanceof CBColumnFooter)) continue;
            return oCell;
        }
        return null;
    }

    private static ReportCell[] rearrangeColumnBreakHeaderFooterCells(ReportCell[] oCells, ReportCell[] rCells) {
        boolean foundCBColumnHeader = false;
        for (ReportCell oCell : oCells) {
            if (!(oCell instanceof CBColumnHeader) && !(oCell instanceof CBColumnFooter)) continue;
            foundCBColumnHeader = true;
            break;
        }
        if (!foundCBColumnHeader) {
            return rCells;
        }
        foundCBColumnHeader = false;
        for (ReportCell rCell : rCells) {
            if (!(rCell instanceof CBColumnHeader) && !(rCell instanceof CBColumnFooter)) continue;
            foundCBColumnHeader = true;
            break;
        }
        if (!foundCBColumnHeader) {
            return rCells;
        }
        ReportCell[] newCells = new ReportCell[rCells.length];
        int i = 0;
        for (i = 0; i < oCells.length; ++i) {
            boolean foundIt = false;
            for (int j = 0; j < rCells.length; ++j) {
                if (rCells[j] == null || !rCells[j].getText().equals(oCells[i].getText()) || oCells[i] instanceof CBColumnHeader || oCells[i] instanceof CBColumnFooter || rCells[j].getClass() != oCells[i].getClass()) continue;
                newCells[i] = rCells[j];
                rCells[j] = null;
                foundIt = true;
                break;
            }
            if (!foundIt) break;
        }
        if (i + 1 >= rCells.length && i < newCells.length && newCells[i] != null) {
            return newCells;
        }
        int j = 0;
        while (i < rCells.length) {
            while (rCells[j] == null) {
                ++j;
            }
            newCells[i] = rCells[j];
            rCells[j] = null;
            ++i;
        }
        return newCells;
    }

    private static CBAggrColumn[] getCBAggrColumns(ReportElement[] columns, int level, int fieldsCountLen) {
        if (fieldsCountLen == level) {
            return null;
        }
        CBAggrColumn[] aggCols = new CBAggrColumn[CrossTabReportSection.getColBreakValueCount(columns)];
        int aggrLvl = fieldsCountLen - 1 - level;
        for (int i = 0; i < aggCols.length; ++i) {
            aggCols[i] = CrossTabReportSection.getCBAggrColumn(columns, aggrLvl, i);
            if (aggCols[i] != null) continue;
            return null;
        }
        return aggCols;
    }

    private static CBAggrColumn getCBAggrColumn(ReportElement[] columns, int aggrLvl, int colBkValIdx) {
        for (ReportElement column2 : columns) {
            CBAggrColumn aggrCol;
            if (!(column2 instanceof CBAggrColumn) || (aggrCol = (CBAggrColumn)column2).getColBreakLevel() != aggrLvl || aggrCol.getColBreakValueIndex() != colBkValIdx) continue;
            return aggrCol;
        }
        return null;
    }

    boolean isCrossTabFixedFieldSection(ReportCell[] tempData) {
        for (ReportCell element : tempData) {
            if (!(element instanceof CBColumnHeader) && !(element instanceof CBColumnFooter) && !(element instanceof RBColumnHeader) && !(element instanceof CBAggrColHeader) && !(element instanceof CBAggrColFooter)) continue;
            return true;
        }
        return false;
    }

    static int getColBreakValueCount(Vector columns) {
        int valCt = 0;
        for (int i = 0; i < columns.size(); ++i) {
            int valIdx;
            if (!(columns.elementAt(i) instanceof ColumnBreakColumn) || (valIdx = ((ColumnBreakColumn)columns.elementAt(i)).getColBreakValueIndex()) <= valCt) continue;
            valCt = valIdx;
        }
        return valCt + 1;
    }

    private static int getColBreakValueCount(ReportElement[] columns) {
        int valCt = 0;
        for (ReportElement column2 : columns) {
            int valIdx;
            if (!(column2 instanceof ColumnBreakColumn) || (valIdx = ((ColumnBreakColumn)column2).getColBreakValueIndex()) <= valCt) continue;
            valCt = valIdx;
        }
        return valCt + 1;
    }

    public void calcRBColumnHeaderWidth(RBColumnHeader colHeader, Vector newColumns, int[] fieldsCount, boolean isCrossTabSubTotalColumnPositionLeft, boolean isAddCrossTabSubTotalColumn, int rbIdx) {
        boolean multiColBkVal2ndToLastLevel;
        if (fieldsCount == null) {
            return;
        }
        Vector<Double> cellWidthArray = new Vector<Double>();
        Vector<ReportElement> columns = CrossTabReportSection.getFirstRowOfUnsortedColumns(newColumns);
        int colBkValCount = CrossTabReportSection.getColBreakValueCount(columns);
        int colBreakLevel = colHeader.getColBreakLevel();
        int numOfColumns = 0;
        boolean containAggrCol = this.getFirstCBAggrColHeader(0, 0) instanceof CBAggrColHeader;
        if (colBkValCount > 1) {
            numOfColumns = colBkValCount;
        }
        for (int i = fieldsCount.length - 1; i > colBreakLevel; --i) {
            numOfColumns = numOfColumns != 0 ? numOfColumns * fieldsCount[i] + (containAggrCol ? colBkValCount : 0) : fieldsCount[i] + (containAggrCol ? 1 : 0);
        }
        double width = 0.0;
        boolean bl = multiColBkVal2ndToLastLevel = colBkValCount > 1 && fieldsCount.length - 1 == colBreakLevel;
        if (colBreakLevel == fieldsCount.length && colBkValCount > 1) {
            int ct = 0;
            for (int i = 0; i < columns.size(); ++i) {
                if (!(columns.elementAt(i) instanceof ColumnBreakColumn) || ((ColumnBreakColumn)columns.elementAt(i)).getColBreakValueIndex() != 0) continue;
                if (ct < rbIdx) {
                    ++ct;
                    continue;
                }
                for (int j = 0; j < numOfColumns; ++j) {
                    ReportColumn col = (ReportColumn)columns.elementAt(i);
                    if (col.isVisible()) {
                        double twidth = ((ReportColumn)columns.elementAt(i)).getWidth();
                        width = twidth + width;
                        cellWidthArray.add(twidth);
                    }
                    ++i;
                }
                break;
            }
        } else if (!containAggrCol) {
            for (int i = 0; i < columns.size(); ++i) {
                if (!(columns.elementAt(i) instanceof ColumnBreakColumn)) continue;
                i += rbIdx * numOfColumns;
                for (int j = 0; j < numOfColumns; ++j) {
                    ReportColumn col = (ReportColumn)columns.elementAt(i);
                    if (col.isVisible()) {
                        double twidth = ((ReportColumn)columns.elementAt(i)).getWidth();
                        width = twidth + width;
                        cellWidthArray.add(twidth);
                    }
                    ++i;
                }
                break;
            }
        } else if (multiColBkVal2ndToLastLevel) {
            int ct = 0;
            for (int i = 0; i < columns.size(); ++i) {
                if (!(columns.elementAt(i) instanceof ColumnBreakColumn) || ((ColumnBreakColumn)columns.elementAt(i)).getColBreakValueIndex() != 0) continue;
                if (ct < rbIdx) {
                    ++ct;
                    continue;
                }
                for (int j = 0; j < numOfColumns; ++j) {
                    ReportColumn col = (ReportColumn)columns.elementAt(i);
                    if (col.isVisible()) {
                        double twidth = ((ReportColumn)columns.elementAt(i)).getWidth();
                        width = twidth + width;
                        cellWidthArray.insertElementAt(twidth, 0);
                    }
                    ++i;
                }
                break;
            }
        } else if (isAddCrossTabSubTotalColumn) {
            int aggrIdx = fieldsCount.length - colBreakLevel - 2;
            int ct = 0;
            if (isCrossTabSubTotalColumnPositionLeft) {
                for (int i = 0; i < columns.size(); ++i) {
                    if (!(columns.elementAt(i) instanceof CBAggrColumn) || ((CBAggrColumn)columns.elementAt(i)).getColBreakLevel() != aggrIdx) continue;
                    if (ct < rbIdx) {
                        ++ct;
                        continue;
                    }
                    for (int j = 0; j < numOfColumns && j < columns.size(); ++j) {
                        ReportColumn col = (ReportColumn)columns.elementAt(i);
                        if (!col.isVisible()) continue;
                        double totalWidth = columns.elementAt(i).getWidth();
                        width = totalWidth + width;
                        cellWidthArray.add(totalWidth);
                    }
                    break;
                }
            } else {
                ct = this.countAggrColumns(columns, aggrIdx, colBkValCount - 1);
                for (int i = columns.size() - 1; i >= 0; --i) {
                    if (!(columns.elementAt(i) instanceof CBAggrColumn) || ((CBAggrColumn)columns.elementAt(i)).getColBreakLevel() != aggrIdx || ((CBAggrColumn)columns.elementAt(i)).getColBreakValueIndex() != colBkValCount - 1 || --ct != rbIdx) continue;
                    for (int j = 0; j < numOfColumns && i >= 0; --i, ++j) {
                        ReportColumn col = (ReportColumn)columns.elementAt(i);
                        if (!col.isVisible()) continue;
                        double totalWidth = columns.elementAt(i).getWidth();
                        width = totalWidth + width;
                        cellWidthArray.insertElementAt(totalWidth, 0);
                    }
                    break;
                }
            }
        }
        colHeader.setWidth(width);
        colHeader.setBreakDownCells(cellWidthArray);
    }

    public void applyStyleForFixedFieldSection(ReportSection _section, boolean copyScripts) {
        int j = 0;
        ReportElement[] tempData = _section.getData();
        double sectionHeight = this.height;
        for (ReportCell cell : this.cells) {
            if (cell instanceof ReportImage) continue;
            if (cell instanceof CBColumnHeader) {
                CBColumnHeader tplCell = _section.getFirstCBColumnHeader(((CBColumnHeader)cell).getColBreakValueIndex());
                cell.applyStyleButNotWHCopyScripts(tplCell, copyScripts);
            } else if (cell instanceof RBColumnHeader) {
                ReportCell tmpCell = _section.getFirstRBColumnHeader(((RBColumnHeader)cell).getColBreakLevel());
                if (tmpCell != null) {
                    cell.applyStyleButNotWHCopyScripts(tmpCell, copyScripts);
                }
            } else if (cell instanceof CBAggrColHeader) {
                ReportCell tmpCell = _section.getFirstCBAggrColHeader(((CBAggrColHeader)cell).getColBreakLevel(), ((CBAggrColHeader)cell).getColBreakValueIndex());
                if (tmpCell != null) {
                    cell.applyStyleButNotWHCopyScripts(tmpCell, copyScripts);
                }
            } else if (cell instanceof CBColumnFooter) {
                ReportCell tmpCell = _section.getFirstCBColumnFooter(((CBColumnFooter)cell).getColBreakValueIndex());
                if (tmpCell != null) {
                    cell.applyStyleButNotWHCopyScripts(tmpCell, copyScripts);
                } else {
                    this.applyStyleFromNonLineAndImageCellFromTheSection(tempData, cell);
                }
            } else if (cell instanceof CBAggrColFooter) {
                ReportCell tmpCell = _section.getFirstCBAggrColFooter(((CBAggrColFooter)cell).getColBreakLevel(), ((CBAggrColFooter)cell).getColBreakValueIndex());
                if (tmpCell != null) {
                    cell.applyStyleButNotWHCopyScripts(tmpCell, copyScripts);
                } else {
                    this.applyStyleFromNonLineAndImageCellFromTheSection(tempData, cell);
                }
            } else {
                boolean foundStyle = false;
                while (j < tempData.length) {
                    if (tempData[j] instanceof CBColumnHeader || tempData[j] instanceof CBColumnFooter || tempData[j] instanceof RBColumnHeader || tempData[j] instanceof CBAggrColHeader || tempData[j] instanceof CBAggrColFooter || tempData[j] instanceof ReportImage) {
                        ++j;
                        continue;
                    }
                    if (cell.getFormula() != null && tempData[j] instanceof ReportCell && !((ReportCell)tempData[j]).getFormula().equals(cell.getFormula())) {
                        ++j;
                        continue;
                    }
                    cell.applyStyleButNotWH(tempData[j]);
                    foundStyle = true;
                    ++j;
                    break;
                }
                if (!foundStyle && tempData.length > 0) {
                    this.applyStyleFromNonLineAndImageCellFromTheSection(tempData, cell);
                }
            }
            if (!(cell.getY() + cell.getHeight() > sectionHeight)) continue;
            sectionHeight = cell.getY() + cell.getHeight();
        }
        for (ReportCell cell : _section.cells) {
            if (!(cell instanceof ReportImage)) continue;
            if (cell instanceof ReportLine && !((ReportLine)cell).isVertical() && cell.getY() > 0.0) {
                cell.setY(sectionHeight - cell.getHeight());
                sectionHeight += cell.getHeight();
            }
            this.addData(cell);
        }
        this.setHeight(sectionHeight);
    }

    private void applyStyleFromNonLineAndImageCellFromTheSection(ReportElement[] tempData, ReportCell cell) {
        for (ReportElement reportElement : tempData) {
            if (reportElement instanceof ReportLine || reportElement instanceof ReportImage) continue;
            cell.applyStyleButNotWH(reportElement);
            break;
        }
    }

    public void copyExtraCells(ReportSection reportSection) {
        ReportCell[] data;
        boolean isFixedFieldCrossTab = false;
        for (ReportCell element : data = this.getData()) {
            if (!(element instanceof CBAggrColFooter) && !(element instanceof CBAggrColHeader) && !(element instanceof CBColumnFooter) && !(element instanceof CBColumnHeader) && !(element instanceof RBColumnHeader)) continue;
            isFixedFieldCrossTab = true;
            break;
        }
        if (!isFixedFieldCrossTab) {
            return;
        }
        this.setData(reportSection.getData());
    }
}

