/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.ReportElements;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.report.LoadXMLReportHelper;

public class FormattedCell
extends ReportCell
implements Serializable {
    private int rowIndex;
    private int columnIndex = -1;
    public static final String XMLTAG = "FORMATTEDCELL";

    public FormattedCell() {
    }

    public FormattedCell(String name) {
        super(name);
    }

    public FormattedCell(ReportCell _cell, int rowId) {
        this.copy(_cell);
        this.rowIndex = rowId;
    }

    public FormattedCell(ReportCell _cell, int rowId, boolean isVisible) {
        this.copy(_cell);
        this.rowIndex = rowId;
        this.visible = isVisible;
    }

    public void setColumnIndex(int index) {
        this.columnIndex = index;
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    public void copy(FormattedCell _formattedCell) {
        super.copy(_formattedCell);
        this.setRowIndex(_formattedCell.getRowIndex());
        this.setVisible(_formattedCell.getVisible());
        this.setColumnIndex(_formattedCell.getColumnIndex());
    }

    @Override
    public void copy(ReportCell _cell) {
        super.copy(_cell);
    }

    public void deepCopy(FormattedCell _formattedCell) {
        super.deepCopy(_formattedCell);
        this.setRowIndex(_formattedCell.getRowIndex());
        this.setVisible(_formattedCell.getVisible());
        this.setColumnIndex(_formattedCell.getColumnIndex());
    }

    public void copyTemplate(FormattedCell _formattedCell) {
        super.copyTemplate(_formattedCell);
    }

    public void applyTemplate(FormattedCell _formattedCell) {
        super.applyTemplate(_formattedCell);
    }

    public boolean equals(FormattedCell _formattedCell) {
        if (_formattedCell == this) {
            return true;
        }
        if (!super.equals(_formattedCell)) {
            return false;
        }
        if (this.rowIndex != _formattedCell.getRowIndex()) {
            return false;
        }
        return this.visible == _formattedCell.getVisible();
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public void setRowIndex(int rowId) {
        this.rowIndex = rowId;
    }

    public boolean getVisible() {
        return this.isVisible();
    }

    @Override
    public void writeXML(Writer out, boolean writeElementTag) throws IOException {
        if (writeElementTag) {
            out.write("<FORMATTEDCELL>\n");
        }
        super.writeXML(out, false);
        out.write("<FORMATTEDCELL_ROWINDEX>" + this.rowIndex + "</FORMATTEDCELL_ROWINDEX>\n");
        if (this.columnIndex > -1) {
            out.write("<FORMATTEDCELL_COLUMNINDEX>" + this.columnIndex + "</FORMATTEDCELL_COLUMNINDEX>\n");
        }
        if (writeElementTag) {
            out.write("</FORMATTEDCELL>\n");
        }
    }

    public static FormattedCell createFormattedCell(Node node, int version) throws Exception {
        if (!node.getNodeName().equalsIgnoreCase(XMLTAG)) {
            throw new Exception("'FORMATTEDCELL' element expected, but found '" + node.getNodeName() + "' element.");
        }
        FormattedCell cell = new FormattedCell();
        cell.readXML(node, version);
        return cell;
    }

    @Override
    public void readXML(Node node, int version) throws Exception {
        super.readXML(node, version);
        boolean check1 = false;
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node child = nodeList.item(i);
            if (child.getNodeName().equalsIgnoreCase("FORMATTEDCELL_ROWINDEX")) {
                this.rowIndex = Integer.parseInt(LoadXMLReportHelper.readText(child));
                check1 = true;
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("FORMATTEDCELL_VISIBLE")) {
                if (version >= 138) continue;
                this.visible = LoadXMLReportHelper.parseBoolean(LoadXMLReportHelper.readText(child));
                continue;
            }
            if (!child.getNodeName().equalsIgnoreCase("FORMATTEDCELL_COLUMNINDEX")) continue;
            this.columnIndex = Integer.parseInt(LoadXMLReportHelper.readText(child));
        }
        if (!check1) {
            throw new Exception("Missing 'FORMATTEDCELL' attributes.");
        }
    }

    public static FormattedCell createFormattedCell(DataInput in, int version) throws Exception {
        FormattedCell cell = new FormattedCell();
        cell.read(in, version);
        return cell;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeInt(this.rowIndex);
    }

    @Override
    public void read(DataInput in, int version) throws Exception {
        super.read(in, version);
        if (version >= 36) {
            this.rowIndex = in.readInt();
            if (version < 138) {
                this.visible = in.readBoolean();
            }
        }
    }

    public String toString() {
        return this.getText();
    }
}

