/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.ReportElements;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Vector;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import quadbase.common.util.internal.IOUtil;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportChartObject;
import quadbase.reportdesigner.ReportElements.ReportDocument;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.ReportElements.ReportGrid;
import quadbase.reportdesigner.ReportElements.ReportImage;
import quadbase.reportdesigner.ReportElements.ReportLine;
import quadbase.reportdesigner.ReportElements.SubReportObject;
import quadbase.reportdesigner.report.LoadXMLReportHelper;

public class FormattedRow
implements Serializable {
    private double rowHeight;
    private Vector<ReportElement> rowElements;
    public static final String XMLTAG = "FORMATTEDROW";

    public FormattedRow() {
    }

    public FormattedRow(double rowHeight, Vector<ReportElement> rowElements) {
        this.rowHeight = rowHeight;
        this.rowElements = rowElements;
    }

    public double getRowHeight() {
        return this.rowHeight;
    }

    public void setRowHeight(double rowHeight) {
        this.rowHeight = rowHeight;
    }

    public Vector<ReportElement> getRowElements() {
        return this.rowElements;
    }

    public void setRowElements(Vector<ReportElement> rowElements) {
        this.rowElements = rowElements;
    }

    public void addElement(ReportElement element) {
        if (this.rowElements == null) {
            this.rowElements = new Vector();
        }
        this.rowElements.addElement(element);
    }

    public boolean setElementAt(ReportElement element, int index) {
        if (this.rowElements == null || this.rowElements.size() < index) {
            return false;
        }
        this.rowElements.setElementAt(element, index);
        return true;
    }

    public boolean removeElement(ReportElement element) {
        if (this.rowElements == null) {
            return false;
        }
        return this.rowElements.removeElement(element);
    }

    public int getNumberOfElements() {
        if (this.rowElements == null) {
            return 0;
        }
        return this.rowElements.size();
    }

    public ReportElement getReportElement(int index) {
        if (this.rowElements == null) {
            return null;
        }
        return this.rowElements.elementAt(index);
    }

    public void writeXML(Writer out, boolean writeElementTag) throws IOException {
        if (writeElementTag) {
            out.write("<FORMATTEDROW>\n");
        }
        out.write("<FORMATTEDROW_ROWHEIGHT>" + this.rowHeight + "</FORMATTEDROW_ROWHEIGHT>\n");
        int count = this.getNumberOfElements();
        out.write("<FORMATTEDROW_ROWELEMENTCOUNT>" + count + "</FORMATTEDROW_ROWELEMENTCOUNT>\n");
        for (int i = 0; i < count; ++i) {
            this.writeReportElementXML(this.getReportElement(i), out, true);
        }
        if (writeElementTag) {
            out.write("</FORMATTEDROW>\n");
        }
    }

    private void writeReportElementXML(ReportElement element, Writer out, boolean writeElementTag) {
        try {
            if (element instanceof ReportCell) {
                if (element instanceof ReportLine) {
                    ((ReportLine)element).writeXML(out, writeElementTag);
                } else if (element instanceof ReportGrid) {
                    ((ReportGrid)element).writeXML(out, writeElementTag);
                } else if (element instanceof ReportChartObject) {
                    ((ReportChartObject)element).writeXML(out, writeElementTag);
                } else if (element instanceof ReportImage) {
                    ((ReportImage)element).writeXML(out, writeElementTag);
                } else if (element instanceof ReportDocument) {
                    ((ReportDocument)element).writeXML(out, writeElementTag);
                } else if (element instanceof SubReportObject) {
                    ((SubReportObject)element).writeXML(out, writeElementTag);
                } else {
                    ((ReportCell)element).writeXML(out, writeElementTag);
                }
            } else {
                System.out.println("You cann't add this type of Report Element to formatted row");
            }
        }
        catch (IOException e) {
            System.out.println("Exception caught, try to write XML");
        }
    }

    public static FormattedRow createFormattedRow(Node node, int version) throws Exception {
        if (!node.getNodeName().equalsIgnoreCase(XMLTAG)) {
            throw new Exception("'FORMATTEDROW' element expected, but found '" + node.getNodeName() + "' element.");
        }
        FormattedRow row = new FormattedRow();
        row.readXML(node, version);
        return row;
    }

    public void readXML(Node node, int version) throws Exception {
        boolean check1 = false;
        NodeList nodeList = node.getChildNodes();
        int count = 0;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node child = nodeList.item(i);
            if (child.getNodeName().equalsIgnoreCase("FORMATTEDROW_ROWHEIGHT")) {
                this.rowHeight = Double.parseDouble(LoadXMLReportHelper.readText(child));
                check1 = true;
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("FORMATTEDROW_ROWELEMENTCOUNT")) {
                count = Integer.parseInt(LoadXMLReportHelper.readText(child));
                if (count <= 0) continue;
                this.rowElements = new Vector();
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTLINE")) {
                this.rowElements.addElement(ReportLine.createLine(child, version));
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTGRID")) {
                this.rowElements.addElement(ReportGrid.createGrid(child, version));
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTCHARTOBJECT")) {
                this.rowElements.addElement(ReportChartObject.createChartObject(child, version));
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTIMAGE")) {
                this.rowElements.addElement(ReportImage.createImage(child, version));
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTDOCUMENT")) {
                this.rowElements.addElement(ReportDocument.createDocument(child, version));
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("SUBREPORTOBJECT")) {
                this.rowElements.addElement(SubReportObject.createSubReportObject(child, version));
                continue;
            }
            if (!child.getNodeName().equalsIgnoreCase("REPORTCELL")) continue;
            this.rowElements.addElement(ReportCell.createCell(child, version));
        }
        if (!check1) {
            throw new Exception("Missing 'FORMATTEDROW' attributes ROWHEIGHT.");
        }
    }

    public static FormattedRow createFormattedRow(DataInput in, int version) throws Exception {
        FormattedRow row = new FormattedRow();
        row.read(in, version);
        return row;
    }

    public void write(DataOutput out) throws IOException {
        out.writeDouble(this.rowHeight);
        int count = this.getNumberOfElements();
        out.writeInt(count);
        for (int i = 0; i < count; ++i) {
            ReportElement element = this.getReportElement(i);
            this.writeReportElement(element, out);
        }
    }

    private void writeReportElement(ReportElement element, DataOutput out) {
        try {
            if (element instanceof ReportCell) {
                if (element instanceof ReportLine) {
                    IOUtil.writeString(out, "REPORTLINE");
                    ((ReportLine)element).write(out);
                } else if (element instanceof ReportGrid) {
                    IOUtil.writeString(out, "REPORTGRID");
                    ((ReportGrid)element).write(out);
                } else if (element instanceof ReportChartObject) {
                    IOUtil.writeString(out, "REPORTCHARTOBJECT");
                    ((ReportChartObject)element).write(out);
                } else if (element instanceof ReportImage) {
                    IOUtil.writeString(out, "REPORTIMAGE");
                    ((ReportImage)element).write(out);
                } else if (element instanceof ReportDocument) {
                    IOUtil.writeString(out, "REPORTDOCUMENT");
                    ((ReportDocument)element).write(out);
                } else if (element instanceof SubReportObject) {
                    IOUtil.writeString(out, "SUBREPORTOBJECT");
                    ((SubReportObject)element).write(out);
                } else {
                    IOUtil.writeString(out, "REPORTCELL");
                    ((ReportCell)element).write(out);
                }
            } else {
                System.out.println("You cann't add this type of Report Element to formatted row");
            }
        }
        catch (IOException e) {
            System.out.println("Exception caught, try to write XML");
        }
    }

    public void read(DataInput in, int version) throws Exception {
        if (version >= 37) {
            this.rowHeight = in.readDouble();
            int count = in.readInt();
            if (count > 0) {
                this.rowElements = new Vector();
            }
            for (int i = 0; i < count; ++i) {
                String type = IOUtil.readString(in, true);
                this.rowElements.addElement(this.createElement(in, version, type));
            }
        }
    }

    private ReportElement createElement(DataInput in, int version, String type) {
        try {
            if (type.equals("REPORTLINE")) {
                return ReportLine.createLine(in, version);
            }
            if (type.equals("REPORTGRID")) {
                return ReportGrid.createGrid(in, version);
            }
            if (type.equals("REPORTCHARTOBJECT")) {
                return ReportChartObject.createChartObject(in, version);
            }
            if (type.equals("REPORTIMAGE")) {
                return ReportImage.createImage(in, version);
            }
            if (type.equals("REPORTDOCUMENT")) {
                return ReportDocument.createDocument(in, version);
            }
            if (type.equals("SUBREPORTOBJECT")) {
                return SubReportObject.createSubReportObject(in, version);
            }
            if (type.equals("REPORTCELL")) {
                return ReportCell.createCell(in, version);
            }
            System.out.println("This ReportElement type is not supported in formatted row!");
            return null;
        }
        catch (Exception e) {
            System.out.println("Exception caught, try to read the ReportElement");
            return null;
        }
    }
}

