/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.ReportElements;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import quadbase.reportdesigner.report.LoadXMLReportHelper;

public class FormattedRowKey
implements Serializable {
    private int rowIndex;
    private int[] treeStructure;
    private int count;
    public static final String XMLTAG = "FORMATTEDROWKEY";

    public FormattedRowKey() {
    }

    public FormattedRowKey(int rowIndex) {
        this.rowIndex = rowIndex;
        this.treeStructure = null;
        this.count = 0;
    }

    public FormattedRowKey(int rowIndex, int[] treeStructure) {
        this.rowIndex = rowIndex;
        this.treeStructure = treeStructure;
        this.count = treeStructure == null ? 0 : treeStructure.length;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public int[] getTreeStructure() {
        return this.treeStructure;
    }

    public void setRowIndex(int rowIndex) {
        this.rowIndex = rowIndex;
    }

    public void setTreeStructure(int[] treeStructure) {
        this.treeStructure = treeStructure;
        this.count = treeStructure.length;
    }

    public int getTreeLevelCount() {
        if (this.treeStructure != null) {
            return this.treeStructure.length;
        }
        return 0;
    }

    public void writeXML(Writer out, boolean writeElementTag) throws IOException {
        if (writeElementTag) {
            out.write("<FORMATTEDROWKEY>\n");
        }
        out.write("<FORMATTEDROWKEY_ROWINDEX>" + this.rowIndex + "</FORMATTEDROWKEY_ROWINDEX>\n");
        out.write("<FORMATTEDROWKEY_TREELEVELCOUNT>" + this.getTreeLevelCount() + "</FORMATTEDROWKEY_TREELEVELCOUNT>\n");
        for (int i = 0; i < this.getTreeLevelCount(); ++i) {
            out.write("<FORMATTEDROWKEY_TREELEVEL>" + this.treeStructure[i] + "</FORMATTEDROWKEY_TREELEVEL>\n");
        }
        if (writeElementTag) {
            out.write("</FORMATTEDROWKEY>\n");
        }
    }

    public void readXML(Node node, int version) throws Exception {
        boolean check1 = false;
        NodeList nodeList = node.getChildNodes();
        int index = 0;
        this.count = 0;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node child = nodeList.item(i);
            if (child.getNodeName().equalsIgnoreCase("FORMATTEDROWKEY_ROWINDEX")) {
                this.rowIndex = Integer.parseInt(LoadXMLReportHelper.readText(child));
                check1 = true;
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("FORMATTEDROWKEY_TREELEVELCOUNT")) {
                this.count = Integer.parseInt(LoadXMLReportHelper.readText(child));
                if (this.count <= 0 || this.treeStructure != null) continue;
                this.treeStructure = new int[this.count];
                continue;
            }
            if (!child.getNodeName().equalsIgnoreCase("FORMATTEDROWKEY_TREELEVEL") || index >= this.count) continue;
            this.treeStructure[index] = Integer.parseInt(LoadXMLReportHelper.readText(child));
            ++index;
        }
        if (!check1) {
            throw new Exception("Missing 'FORMATTEDROWKEY' attributes ROWINDEX.");
        }
    }

    public static FormattedRowKey createFormattedRowKey(Node node, int version) throws Exception {
        if (!node.getNodeName().equalsIgnoreCase(XMLTAG)) {
            throw new Exception("'FORMATTEDROWKEY' element expected, but found '" + node.getNodeName() + "' element.");
        }
        FormattedRowKey key = new FormattedRowKey();
        key.readXML(node, version);
        return key;
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.rowIndex);
        this.count = this.getTreeLevelCount();
        out.writeInt(this.count);
        for (int i = 0; i < this.count; ++i) {
            out.writeInt(this.treeStructure[i]);
        }
    }

    public void read(DataInput in, int version) throws Exception {
        if (version >= 37) {
            this.rowIndex = in.readInt();
            this.count = in.readInt();
            if (this.count > 0 && this.treeStructure == null) {
                this.treeStructure = new int[this.count];
            }
            for (int i = 0; i < this.count; ++i) {
                this.treeStructure[i] = in.readInt();
            }
        }
    }

    public static FormattedRowKey createFormattedRowKey(DataInput in, int version) throws Exception {
        FormattedRowKey key = new FormattedRowKey();
        key.read(in, version);
        return key;
    }

    public boolean equals(Object key) {
        FormattedRowKey newKey = (FormattedRowKey)key;
        if (this.rowIndex != newKey.rowIndex) {
            return false;
        }
        if (this.treeStructure == null && newKey.treeStructure == null) {
            return true;
        }
        if (this.treeStructure == null || newKey.treeStructure == null) {
            return false;
        }
        if (this.treeStructure.length != newKey.treeStructure.length) {
            return false;
        }
        for (int i = 0; i < this.treeStructure.length; ++i) {
            if (this.treeStructure[i] == newKey.treeStructure[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.treeStructure == null) {
            return this.rowIndex;
        }
        String str = this.rowIndex + "_";
        for (int element : this.treeStructure) {
            str = str + element;
        }
        return str.hashCode();
    }
}

