/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.ReportElements;

import java.awt.Color;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Writer;
import java.util.Vector;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.QbUtil;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.ReportElements.ReportLine;
import quadbase.reportdesigner.ReportElements.ReportSection;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.report.LoadXMLReportHelper;
import quadbase.reportdesigner.report.Report;

public class GuideLine
extends ReportLine {
    Vector<ReportElement> leftTopElts;
    Vector<ReportElement> midlineElts;
    Vector<ReportElement> rightBottomElts;
    Vector<String> leftTopEltIDs;
    Vector<String> midlineEltIDs;
    Vector<String> rightBottomEltIDs;
    public static final String XMLTAG = "GUIDELINE";

    public GuideLine() {
    }

    public GuideLine(double d, boolean isVertical, boolean snapToGrid, boolean metric, double stepSize) {
        super(isVertical);
        this.setSnapToGrid(snapToGrid, metric, stepSize);
        this.setBgColor(new Color(92, 92, 92));
        this.setLineStyle(3);
        if (isVertical) {
            this.setXX(d);
            this.setYY(0.0);
            this.setHeight(-1.0);
            this.setWidth(QbUtil.toInch(1.0));
        } else {
            this.setXX(0.0);
            this.setYY(d);
            this.setHeight(QbUtil.toInch(1.0));
            this.setWidth(12.0);
        }
    }

    public void deepCopy(GuideLine _line) {
        super.deepCopy(_line);
        this.leftTopElts = _line.getLeftTopElts();
        this.midlineElts = _line.getMidlineElts();
        this.rightBottomElts = _line.getRightBottomElts();
    }

    public Vector<ReportElement> getLeftTopElts() {
        return this.leftTopElts;
    }

    public Vector<ReportElement> getMidlineElts() {
        return this.midlineElts;
    }

    public Vector<ReportElement> getRightBottomElts() {
        return this.rightBottomElts;
    }

    public void addLeftTopElt(ReportElement elt) {
        if (this.leftTopElts == null) {
            this.leftTopElts = new Vector();
        }
        if (!this.leftTopElts.contains(elt)) {
            this.leftTopElts.addElement(elt);
        }
    }

    public void addMidlineElt(ReportElement elt) {
        if (this.midlineElts == null) {
            this.midlineElts = new Vector();
        }
        if (!this.midlineElts.contains(elt)) {
            this.midlineElts.addElement(elt);
        }
    }

    public void addRightBottomElt(ReportElement elt) {
        if (this.rightBottomElts == null) {
            this.rightBottomElts = new Vector();
        }
        if (!this.rightBottomElts.contains(elt)) {
            this.rightBottomElts.addElement(elt);
        }
    }

    public void copyElts(GuideLine gl) {
        this.leftTopElts = gl.getLeftTopElts();
        this.midlineElts = gl.getMidlineElts();
        this.rightBottomElts = gl.getRightBottomElts();
    }

    public void alignElts() {
        ReportElement elt;
        int i;
        for (i = 0; this.leftTopElts != null && i < this.leftTopElts.size(); ++i) {
            elt = this.leftTopElts.elementAt(i);
            if (this.isVertical) {
                if (elt.getVSnap() == 4) {
                    elt.setWidth(elt.getX() + elt.getWidth() - this.getX());
                }
                elt.setXX(this.getX());
                continue;
            }
            if (elt.getSnap() == 4) {
                elt.setHeight(elt.getY() + elt.getHeight() - this.getY());
            }
            elt.setYY(this.getY());
        }
        for (i = 0; this.midlineElts != null && i < this.midlineElts.size(); ++i) {
            elt = this.midlineElts.elementAt(i);
            if (this.isVertical) {
                elt.setXX(this.getX() - elt.getWidth() / 2.0);
                continue;
            }
            elt.setYY(this.getY() - elt.getHeight() / 2.0);
        }
        for (i = 0; this.rightBottomElts != null && i < this.rightBottomElts.size(); ++i) {
            elt = this.rightBottomElts.elementAt(i);
            if (this.isVertical) {
                if (elt.getVSnap() == 4) {
                    elt.setWidth(this.getX() - elt.getX());
                    continue;
                }
                elt.setXX(this.getX() - elt.getWidth());
                continue;
            }
            if (elt.getSnap() == 4) {
                elt.setHeight(this.getY() - elt.getY());
                continue;
            }
            elt.setYY(this.getY() - elt.getHeight());
        }
    }

    public void shiftOnMove(ReportElement elt, Vector<ReportElement> panelElements, boolean isVertical, double change) {
        for (int j = 0; j < panelElements.size(); ++j) {
            ReportElement relt = panelElements.elementAt(j);
            if (relt != null && relt instanceof ReportSection) {
                if (!(elt instanceof ReportCell) || !((ReportSection)relt).hasCell((ReportCell)elt)) continue;
                ((ReportSection)relt).shiftOnMove(elt, isVertical, change);
                continue;
            }
            if (relt == null || !(relt instanceof ReportTable) || !((ReportTable)relt).hasColumn(elt)) continue;
            ((ReportTable)relt).shiftOnMove(elt, isVertical, change);
        }
    }

    public void shift(ReportElement elt, Vector<ReportElement> panelElements, boolean isVertical, double change) {
        for (int j = 0; j < panelElements.size(); ++j) {
            ReportElement relt = panelElements.elementAt(j);
            if (relt != null && relt instanceof ReportSection) {
                if (!((ReportSection)relt).hasCell((ReportCell)elt)) continue;
                ((ReportSection)relt).shift(elt, isVertical, change);
                continue;
            }
            if (relt == null || !(relt instanceof ReportTable) || !((ReportTable)relt).hasColumn(elt)) continue;
            ((ReportTable)relt).shift(elt, isVertical, change);
        }
    }

    public void alignEltsWithShift(Vector<ReportElement> panelElements, double w, double h) {
        ReportElement elt;
        int i;
        for (i = 0; this.leftTopElts != null && i < this.leftTopElts.size(); ++i) {
            elt = this.leftTopElts.elementAt(i);
            if (this.isVertical) {
                if (elt.getVSnap() == 4) {
                    elt.setWidth(elt.getX() + elt.getWidth() - this.getX());
                } else {
                    this.shiftOnMove(elt, panelElements, true, w);
                }
                elt.setXX(this.getX());
                continue;
            }
            if (elt.getSnap() == 4) {
                elt.setHeight(elt.getY() + elt.getHeight() - this.getY());
            } else {
                this.shiftOnMove(elt, panelElements, false, h);
            }
            elt.setYY(this.getY());
        }
        for (i = 0; this.midlineElts != null && i < this.midlineElts.size(); ++i) {
            elt = this.midlineElts.elementAt(i);
            if (this.isVertical) {
                this.shiftOnMove(elt, panelElements, true, w);
                elt.setXX(this.getX() - elt.getWidth() / 2.0);
                continue;
            }
            this.shiftOnMove(elt, panelElements, false, h);
            elt.setYY(this.getY() - elt.getHeight() / 2.0);
        }
        for (i = 0; this.rightBottomElts != null && i < this.rightBottomElts.size(); ++i) {
            elt = this.rightBottomElts.elementAt(i);
            if (this.isVertical) {
                if (elt.getVSnap() == 4) {
                    this.shift(elt, panelElements, true, w);
                    continue;
                }
                this.shiftOnMove(elt, panelElements, true, w);
                elt.setXX(this.getX() - elt.getWidth());
                continue;
            }
            if (elt.getSnap() == 4) {
                this.shift(elt, panelElements, false, h);
                continue;
            }
            this.shiftOnMove(elt, panelElements, false, h);
            elt.setYY(this.getY() - elt.getHeight());
        }
    }

    public void removeElt(ReportElement elt) {
        elt.setSnap((short)0);
        elt.setVSnap((short)0);
        if (this.leftTopElts != null) {
            this.leftTopElts.remove(elt);
        }
        if (this.midlineElts != null) {
            this.midlineElts.remove(elt);
        }
        if (this.rightBottomElts != null) {
            this.rightBottomElts.remove(elt);
        }
    }

    public void removeAll() {
        ReportElement elt;
        int i;
        if (this.leftTopElts != null) {
            for (i = 0; i < this.leftTopElts.size(); ++i) {
                elt = this.leftTopElts.elementAt(i);
                if (!this.isVertical()) {
                    if (elt.getSnap() < 4) {
                        elt.setSnap((short)0);
                        continue;
                    }
                    elt.setSnap((short)3);
                    continue;
                }
                if (elt.getVSnap() < 4) {
                    elt.setVSnap((short)0);
                    continue;
                }
                elt.setVSnap((short)3);
            }
            this.leftTopElts = null;
        }
        if (this.midlineElts != null) {
            for (i = 0; i < this.midlineElts.size(); ++i) {
                elt = this.midlineElts.elementAt(i);
                if (!this.isVertical()) {
                    elt.setSnap((short)0);
                    continue;
                }
                elt.setVSnap((short)0);
            }
            this.midlineElts = null;
        }
        if (this.rightBottomElts != null) {
            for (i = 0; i < this.rightBottomElts.size(); ++i) {
                elt = this.rightBottomElts.elementAt(i);
                if (!this.isVertical()) {
                    if (elt.getSnap() < 4) {
                        elt.setSnap((short)0);
                        continue;
                    }
                    elt.setSnap((short)1);
                    continue;
                }
                if (elt.getVSnap() < 4) {
                    elt.setVSnap((short)0);
                    continue;
                }
                elt.setVSnap((short)1);
            }
            this.rightBottomElts = null;
        }
    }

    public void replace(ReportElement newElt, ReportElement oldElt) {
        int i;
        Vector<ReportElement> vec;
        if (this.leftTopElts != null && this.leftTopElts.contains(oldElt)) {
            vec = new Vector<ReportElement>();
            for (i = 0; i < this.leftTopElts.size(); ++i) {
                if (this.leftTopElts.elementAt(i) == oldElt) {
                    vec.addElement(newElt);
                    continue;
                }
                vec.addElement(this.leftTopElts.elementAt(i));
            }
            this.leftTopElts = vec;
        }
        if (this.midlineElts != null && this.midlineElts.contains(oldElt)) {
            vec = new Vector();
            for (i = 0; i < this.midlineElts.size(); ++i) {
                if (this.midlineElts.elementAt(i) == oldElt) {
                    vec.addElement(newElt);
                    continue;
                }
                vec.addElement(this.midlineElts.elementAt(i));
            }
            this.midlineElts = vec;
        }
        if (this.rightBottomElts != null && this.rightBottomElts.contains(oldElt)) {
            vec = new Vector();
            for (i = 0; i < this.rightBottomElts.size(); ++i) {
                if (this.rightBottomElts.elementAt(i) == oldElt) {
                    vec.addElement(newElt);
                    continue;
                }
                vec.addElement(this.rightBottomElts.elementAt(i));
            }
            this.rightBottomElts = vec;
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        ReportLine head = this.getHeadNode();
        if (head != this) {
            out.writeBoolean(false);
        } else {
            int i;
            out.writeBoolean(true);
            if (this.leftTopElts != null) {
                for (i = this.leftTopElts.size() - 1; i >= 0; --i) {
                    if (this.leftTopElts.elementAt(i) != null) continue;
                    this.leftTopElts.remove(i);
                }
                out.writeInt(this.leftTopElts.size());
                for (i = 0; i < this.leftTopElts.size(); ++i) {
                    IOUtil.writeStr(out, this.leftTopElts.elementAt(i).getID());
                }
            } else {
                out.writeInt(0);
            }
            if (this.midlineElts != null) {
                for (i = this.midlineElts.size() - 1; i >= 0; --i) {
                    if (this.midlineElts.elementAt(i) != null) continue;
                    this.midlineElts.remove(i);
                }
                out.writeInt(this.midlineElts.size());
                for (i = 0; i < this.midlineElts.size(); ++i) {
                    IOUtil.writeStr(out, this.midlineElts.elementAt(i).getID());
                }
            } else {
                out.writeInt(0);
            }
            if (this.rightBottomElts != null) {
                for (i = this.rightBottomElts.size() - 1; i >= 0; --i) {
                    if (this.rightBottomElts.elementAt(i) != null) continue;
                    this.rightBottomElts.remove(i);
                }
                out.writeInt(this.rightBottomElts.size());
                for (i = 0; i < this.rightBottomElts.size(); ++i) {
                    IOUtil.writeStr(out, this.rightBottomElts.elementAt(i).getID());
                }
            } else {
                out.writeInt(0);
            }
        }
    }

    @Override
    public void writeXML(Writer out, boolean writeElementTag) throws IOException {
        int i;
        if (writeElementTag) {
            out.write("<GUIDELINE>\n");
        }
        super.writeXML(out, false);
        if (this.leftTopElts != null) {
            for (i = 0; i < this.leftTopElts.size(); ++i) {
                if (this.leftTopElts.elementAt(i) == null) continue;
                out.write("<GUIDELINE_LEFTTOPELT>" + this.leftTopElts.elementAt(i).getID() + "</GUIDELINE_LEFTTOPELT>\n");
            }
        }
        if (this.midlineElts != null) {
            for (i = 0; i < this.midlineElts.size(); ++i) {
                if (this.midlineElts.elementAt(i) == null) continue;
                out.write("<GUIDELINE_MIDLINEELT>" + this.midlineElts.elementAt(i).getID() + "</GUIDELINE_MIDLINEELT>\n");
            }
        }
        if (this.rightBottomElts != null) {
            for (i = 0; i < this.rightBottomElts.size(); ++i) {
                if (this.rightBottomElts.elementAt(i) == null) continue;
                out.write("<GUIDELINE_RIGHTBOTTOMELT>" + this.rightBottomElts.elementAt(i).getID() + "</GUIDELINE_RIGHTBOTTOMELT>\n");
            }
        }
        if (writeElementTag) {
            out.write("</GUIDELINE>\n");
        }
    }

    public static GuideLine createGuideLine(DataInput in, int version) throws Exception {
        GuideLine cell = new GuideLine();
        cell.read(in, version);
        return cell;
    }

    @Override
    public void read(DataInput in, int version) throws Exception {
        super.read(in, version);
        if (in.readBoolean()) {
            int i;
            int count = in.readInt();
            this.leftTopEltIDs = new Vector();
            for (i = 0; i < count; ++i) {
                this.leftTopEltIDs.addElement(IOUtil.readStr(in));
            }
            count = in.readInt();
            this.midlineEltIDs = new Vector();
            for (i = 0; i < count; ++i) {
                this.midlineEltIDs.addElement(IOUtil.readStr(in));
            }
            count = in.readInt();
            this.rightBottomEltIDs = new Vector();
            for (i = 0; i < count; ++i) {
                this.rightBottomEltIDs.addElement(IOUtil.readStr(in));
            }
        }
    }

    public static GuideLine createGuideLine(Node node, int version) throws Exception {
        if (!node.getNodeName().equalsIgnoreCase(XMLTAG)) {
            throw new Exception("'GUIDELINE' element expected, but found '" + node.getNodeName() + "' element.");
        }
        GuideLine cell = new GuideLine();
        cell.readXML(node, version);
        return cell;
    }

    @Override
    public void readXML(Node node, int version) throws Exception {
        super.readXML(node, version);
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node child = nodeList.item(i);
            if (child.getNodeName().equalsIgnoreCase("GUIDELINE_LEFTTOPELT")) {
                if (this.leftTopEltIDs == null) {
                    this.leftTopEltIDs = new Vector();
                }
                this.leftTopEltIDs.addElement(LoadXMLReportHelper.readText(child));
            }
            if (child.getNodeName().equalsIgnoreCase("GUIDELINE_MIDLINEELT")) {
                if (this.midlineEltIDs == null) {
                    this.midlineEltIDs = new Vector();
                }
                this.midlineEltIDs.addElement(LoadXMLReportHelper.readText(child));
            }
            if (!child.getNodeName().equalsIgnoreCase("GUIDELINE_RIGHTBOTTOMELT")) continue;
            if (this.rightBottomEltIDs == null) {
                this.rightBottomEltIDs = new Vector();
            }
            this.rightBottomEltIDs.addElement(LoadXMLReportHelper.readText(child));
        }
    }

    public void linkSnappedElements(Report report) {
        int i;
        if (this.leftTopEltIDs != null) {
            this.leftTopElts = new Vector();
            for (i = 0; i < this.leftTopEltIDs.size(); ++i) {
                this.leftTopElts.addElement(report.getData(this.leftTopEltIDs.elementAt(i)));
            }
        }
        if (this.midlineEltIDs != null) {
            this.midlineElts = new Vector();
            for (i = 0; i < this.midlineEltIDs.size(); ++i) {
                this.midlineElts.addElement(report.getData(this.midlineEltIDs.elementAt(i)));
            }
        }
        if (this.rightBottomEltIDs != null) {
            this.rightBottomElts = new Vector();
            for (i = 0; i < this.rightBottomEltIDs.size(); ++i) {
                this.rightBottomElts.addElement(report.getData(this.rightBottomEltIDs.elementAt(i)));
            }
        }
    }

    public boolean containsElement(ReportElement elt) {
        int i;
        if (this.leftTopElts != null) {
            for (i = 0; i < this.leftTopElts.size(); ++i) {
                if (elt != this.leftTopElts.elementAt(i)) continue;
                return true;
            }
        }
        if (this.rightBottomElts != null) {
            for (i = 0; i < this.rightBottomElts.size(); ++i) {
                if (elt != this.rightBottomElts.elementAt(i)) continue;
                return true;
            }
        }
        if (this.midlineElts != null) {
            for (i = 0; i < this.midlineElts.size(); ++i) {
                if (elt != this.midlineElts.elementAt(i)) continue;
                return true;
            }
        }
        return false;
    }
}

