/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.ReportElements;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Writer;
import java.util.Vector;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import quadbase.common.util.internal.VersioningDataOutput;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.report.LoadXMLReportHelper;

public class RBColumnHeader
extends ReportCell {
    int level = 0;
    Vector<Double> breakDownCellWidth = null;
    public boolean isFormula = true;
    public static final String XMLTAG = "RBCOLUMNHEADER";

    public RBColumnHeader() {
    }

    public RBColumnHeader(String text, int level) {
        super(text);
        this.level = level;
    }

    public RBColumnHeader(int level) {
        this.level = level;
    }

    public void applyTemplate(RBColumnHeader _elt) {
        super.applyTemplate(_elt);
        this.isFormula = _elt.isFormula;
    }

    public void applyTemplate(RBColumnHeader _elt, boolean applyScript) {
        super.applyTemplate(_elt, applyScript);
        this.isFormula = _elt.isFormula;
        if (!this.isFormula) {
            this.setText(_elt.getText());
        }
    }

    public void copyTemplate(RBColumnHeader _elt) {
        super.copyTemplate(_elt);
        this.isFormula = _elt.isFormula;
    }

    public void applyStyle(RBColumnHeader _elt) {
        super.applyStyle(_elt);
        this.isFormula = _elt.isFormula;
        if (!this.isFormula) {
            this.setText(_elt.getText());
        }
    }

    public void copy(RBColumnHeader _elt) {
        this.breakDownCellWidth = _elt.breakDownCellWidth;
        super.copy(_elt);
        this.isFormula = _elt.isFormula;
        if (!this.isFormula) {
            this.setText(_elt.getText());
        }
    }

    public void deepCopy(RBColumnHeader _elt) {
        this.breakDownCellWidth = _elt.breakDownCellWidth;
        super.deepCopy(_elt);
        this.isFormula = _elt.isFormula;
    }

    public int getColBreakLevel() {
        return this.level;
    }

    public void setBreakDownCells(Vector<Double> vec) {
        this.breakDownCellWidth = vec;
    }

    public void addBreakDownCell(double cellW) {
        if (this.breakDownCellWidth != null) {
            this.breakDownCellWidth.addElement(cellW);
        }
    }

    public ReportCell[] splitCell() {
        if (this.breakDownCellWidth == null) {
            return new ReportCell[]{this};
        }
        ReportCell[] colHdrs = new RBColumnHeader[this.breakDownCellWidth.size()];
        double offset = 0.0;
        for (int i = 0; i < colHdrs.length; ++i) {
            colHdrs[i] = (RBColumnHeader)ReportCell.clone(this);
            colHdrs[i].setX(colHdrs[i].getX() + offset);
            colHdrs[i].setWidth(this.breakDownCellWidth.elementAt(i));
            colHdrs[i].setID(colHdrs[i].getID() + "_S" + i);
            offset += colHdrs[i].getWidth();
        }
        return colHdrs;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeInt(this.level);
        ((VersioningDataOutput)out).writeBoolean(this.isFormula, (short)298);
        super.write(out);
    }

    @Override
    public void read(DataInput in, int version) throws Exception {
        this.level = in.readInt();
        if (version >= 298) {
            this.isFormula = in.readBoolean();
        }
        super.read(in, version);
    }

    public static RBColumnHeader createRBColumnHeader(DataInput in, int version) throws Exception {
        RBColumnHeader rbCol = new RBColumnHeader();
        rbCol.read(in, version);
        return rbCol;
    }

    @Override
    public void writeXML(Writer out, boolean writeElementTag) throws IOException {
        if (writeElementTag) {
            out.write("<RBCOLUMNHEADER>\n");
        }
        out.write("<RBCOLUMNHEADER_LEVEL>" + this.level + "</RBCOLUMNHEADER_LEVEL>\n");
        out.write("<RBCOLUMNHEADER_ISFORMULA>" + this.isFormula + "</RBCOLUMNHEADER_ISFORMULA>\n");
        super.writeXML(out, false);
        if (writeElementTag) {
            out.write("</RBCOLUMNHEADER>\n");
        }
    }

    @Override
    public void readXML(Node node, int version) throws Exception {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node child = nodeList.item(i);
            if (child.getNodeName().equalsIgnoreCase("RBCOLUMNHEADER_LEVEL")) {
                this.level = Integer.parseInt(LoadXMLReportHelper.readText(child).trim());
            }
            if (!child.getNodeName().equalsIgnoreCase("RBCOLUMNHEADER_ISFORMULA")) continue;
            this.isFormula = Boolean.valueOf(LoadXMLReportHelper.readText(child).trim());
        }
        super.readXML(node, version);
    }

    public static RBColumnHeader createRBColumnHeader(Node node, int version) throws Exception {
        if (!node.getNodeName().equalsIgnoreCase(XMLTAG)) {
            throw new Exception("'RBCOLUMNHEADER' element expected, but found '" + node.getNodeName() + "' element.");
        }
        RBColumnHeader columnHeader = new RBColumnHeader();
        columnHeader.readXML(node, version);
        return columnHeader;
    }
}

