/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.ReportElements;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.Vector;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.FontTable;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.QbUtil;
import quadbase.common.util.internal.XMLUtil;
import quadbase.reportdesigner.ReportElements.Bookmark;
import quadbase.reportdesigner.ReportElements.CBAggrColFooter;
import quadbase.reportdesigner.ReportElements.CBAggrColHeader;
import quadbase.reportdesigner.ReportElements.CBColumnFooter;
import quadbase.reportdesigner.ReportElements.CBColumnHeader;
import quadbase.reportdesigner.ReportElements.ColumnHeader;
import quadbase.reportdesigner.ReportElements.FormattedCell;
import quadbase.reportdesigner.ReportElements.RBColumnHeader;
import quadbase.reportdesigner.ReportElements.ReportChartObject;
import quadbase.reportdesigner.ReportElements.ReportColumn;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.ReportElements.ReportGrid;
import quadbase.reportdesigner.ReportElements.ReportImage;
import quadbase.reportdesigner.ReportElements.ReportLine;
import quadbase.reportdesigner.ReportElements.ReportRTFObject;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.ReportElements.SubReportObject;
import quadbase.reportdesigner.ReportElements.TableOfContents;
import quadbase.reportdesigner.lang.IObject;
import quadbase.reportdesigner.report.Formula;
import quadbase.reportdesigner.report.LoadXMLReportHelper;
import quadbase.reportdesigner.report.NewFormulaParser;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.ScriptReportElement;
import quadbase.reportdesigner.util.IFormat;
import quadbase.reportdesigner.util.internal.FormatUtil;

public class ReportCell
extends ReportElement {
    private IFormat format = null;
    private String formula = null;
    private int sqlType = -1;
    private Formula formulaObj = null;
    private String formulaName = null;
    private Object scriptedValue = null;
    private Bookmark entry = null;
    private ReportColumn column;
    public static final String XMLTAG = "REPORTCELL";

    public ReportCell() {
        this.setFont(FontTable.newFont("Dialog", 1, QbUtil.getAdjustedFont(12, true)));
    }

    public ReportCell(String name) {
        super(name);
        this.setFont(FontTable.newFont("Dialog", 1, QbUtil.getAdjustedFont(12, true)));
    }

    public ReportCell(IObject formula) {
        this();
        this.setFormula(formula.getFormula());
        this.sqlType = formula.getSQLType();
    }

    public ReportCell(Formula formula) {
        this();
        this.formulaObj = formula;
        this.formulaName = formula.getName();
        this.setFormula(formula.getText());
        if (formula.getSQLType() >= 0) {
            this.sqlType = formula.getSQLType();
        }
        if (this.format == null) {
            this.setDataFormat(FormatUtil.createFormat(DataType.mapType(this.sqlType)));
        }
    }

    public ReportCell(ReportColumn _col, int index) {
        super.copy(_col);
        this.setDataFormat(_col.getDataFormat());
        int altRow = _col.getAlternateRow();
        this.setStyleName(_col.getStyleName());
        if (altRow > 0 && index / altRow % 2 != 0) {
            this.setBgColor(_col.getBgColor2());
            this.setFontColor(_col.getFontColor2());
            this.setFont(_col.getRefFont2());
            this.setStyleName(_col.getStyleName2());
            this.setUnderline(_col.isUnderline2());
        }
    }

    ReportCell(ReportColumn _col, int index, int tableNumber) {
        this(_col, index, index, tableNumber);
    }

    ReportCell(ReportColumn _col, int dataidx, int displayidx, int tableNumber) {
        super.copy(_col);
        this.setDataFormat(_col.getDataFormat());
        int altRow = _col.getAlternateRow();
        boolean rowBreak = _col.isDualColorOnRowBreak();
        this.setStyleName(_col.getStyleName());
        if (altRow > 0 && displayidx / altRow % 2 != 0 || rowBreak && tableNumber % 2 != 0 || _col.getDualColorColInfoIndex() != null && _col.getIsBGColor2(dataidx)) {
            this.setBgColor(_col.getBgColor2());
            this.setFontColor(_col.getFontColor2());
            this.setFont(_col.getRefFont2());
            this.setStyleName(_col.getStyleName2());
            this.setUnderline(_col.isUnderline2());
        }
    }

    public IFormat getDataFormat() {
        return this.format;
    }

    public void setDataFormat(IFormat format) {
        this.format = format;
    }

    public void copy(ReportCell _cell) {
        super.copy(_cell);
        this.setDataFormat(_cell.getDataFormat());
        this.formulaName = _cell.getFormulaName();
        this.formulaObj = _cell.getFormulaObj() != null ? _cell.getFormulaObj().copy() : null;
        this.setFormula(_cell.getFormula());
        this.sqlType = _cell.getSQLType();
        this.entry = _cell.getEntry();
        this.column = _cell.getColumn();
    }

    public void deepCopy(ReportCell _cell) {
        super.deepCopy(_cell);
        this.setDataFormat(_cell.getDataFormat());
        this.formulaName = _cell.getFormulaName();
        this.formulaObj = _cell.getFormulaObj() != null ? _cell.getFormulaObj().copy() : null;
        this.setFormula(_cell.getFormula());
        this.sqlType = _cell.getSQLType();
        this.entry = _cell.getEntry();
        this.column = _cell.getColumn();
    }

    public void copyTemplate(ReportCell _cell) {
        super.copyTemplate(_cell);
        if (FormatUtil.isFormatAppliabled(this.getDataFormat(), _cell.getDataFormat())) {
            this.setDataFormat(_cell.getDataFormat());
        }
        this.formulaName = _cell.getFormulaName();
        this.formulaObj = _cell.getFormulaObj() != null ? _cell.getFormulaObj().copy() : null;
        this.setFormula(_cell.getFormula());
        this.sqlType = _cell.getSQLType();
        this.entry = _cell.getEntry();
        this.column = _cell.getColumn();
    }

    public void applyTemplate(ReportCell _cell) {
        this.applyTemplate(_cell, false);
    }

    public void applyTemplate(ReportCell _cell, boolean applyScript) {
        if (_cell == null) {
            return;
        }
        super.applyTemplate(_cell, applyScript);
        if (FormatUtil.isFormatAppliabled(this.getDataFormat(), _cell.getDataFormat())) {
            if (this.format != null && _cell.getDataFormat() != null && this.format.getFormatType() == 4 && _cell.getDataFormat().getFormatType() == 4) {
                return;
            }
            this.setDataFormat(_cell.getDataFormat());
        }
    }

    public boolean equals(ReportCell _cell) {
        if (_cell == this) {
            return true;
        }
        if (!super.equals(_cell)) {
            return false;
        }
        if (this.format == null && _cell.format != null) {
            return false;
        }
        if (!(this.format == null || _cell.format != null && this.format.getTextFormat().equals(_cell.format.getTextFormat()))) {
            return false;
        }
        if (this.formulaName == null && _cell.getFormulaName() != null) {
            return false;
        }
        if (this.formulaName != null && !this.formulaName.equals(_cell.getFormulaName())) {
            return false;
        }
        if (this.formulaObj != null && this.formulaObj.equals(_cell.getFormulaObj())) {
            return false;
        }
        if (this.formula == null && _cell.getFormula() != null) {
            return false;
        }
        if (this.formula != null && !this.formula.equals(_cell.getFormula())) {
            return false;
        }
        return this.sqlType == _cell.getSQLType();
    }

    public void setFormulaObj(Formula f) {
        this.formulaObj = f;
        this.formulaName = this.formulaObj.getName();
        this.setFormula(this.formulaObj.getText());
        if (f.getSQLType() >= 0) {
            this.sqlType = this.formulaObj.getSQLType();
        }
        IFormat formulaFormat = FormatUtil.createFormat(DataType.mapType(this.sqlType));
        if (this.format == null || !FormatUtil.isFormatAppliabled(this.format, formulaFormat)) {
            this.setDataFormat(formulaFormat);
        }
    }

    public Formula getFormulaObj() {
        return this.formulaObj;
    }

    public String getFormulaName() {
        if (this.formulaObj != null) {
            return this.formulaObj.getName();
        }
        return this.formulaName;
    }

    public String getFormula() {
        if (this.formulaObj != null) {
            return this.formulaObj.getText();
        }
        if (this.formula != null) {
            return this.formula;
        }
        return this.formulaName;
    }

    public int getSQLType() {
        if (this.formulaObj != null) {
            this.sqlType = this.formulaObj.getSQLType();
        }
        return this.sqlType;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        FormatUtil.writeDataFormat(out, this.format);
        if (this.getFormulaName() != null) {
            IOUtil.writeStr(out, this.getFormulaName());
        } else {
            IOUtil.writeStr(out, this.getFormula());
        }
        out.writeInt(this.getSQLType());
        if (this.getFormulaObj() != null && !(this instanceof ColumnHeader)) {
            this.setText("");
        }
        super.write(out);
    }

    @Override
    public void writeXML(Writer out, boolean writeElementTag) throws IOException {
        if (writeElementTag) {
            out.write("<REPORTCELL>\n");
        }
        FormatUtil.writeXMLDataFormat(out, this.format);
        if (this.getFormulaName() != null) {
            out.write("<REPORTCELL_FORMULA>" + XMLUtil.encodeCDATA(this.getFormulaName()) + "</REPORTCELL_FORMULA>\n");
        } else if (this.getFormula() != null) {
            out.write("<REPORTCELL_FORMULA>" + XMLUtil.encodeCDATA(this.getFormula()) + "</REPORTCELL_FORMULA>\n");
        }
        out.write("<REPORTCELL_SQLTYPE>" + DataType.getTypeName(this.getSQLType()) + "</REPORTCELL_SQLTYPE>\n");
        if (this.getFormulaObj() != null && !(this instanceof ColumnHeader)) {
            this.setText("");
        }
        super.writeXML(out, false);
        if (writeElementTag) {
            out.write("</REPORTCELL>\n");
        }
    }

    public static ReportCell createCell(Node node, int version) throws Exception {
        if (!node.getNodeName().equalsIgnoreCase(XMLTAG)) {
            throw new Exception("'REPORTCELL' element expected, but found '" + node.getNodeName() + "' element.");
        }
        ReportCell cell = new ReportCell();
        cell.readXML(node, version);
        return cell;
    }

    @Override
    public void readXML(Node node, int version) throws Exception {
        this.formulaName = null;
        boolean check1 = false;
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node child = nodeList.item(i);
            if (this.getDataFormat() == null) {
                this.setDataFormat(FormatUtil.readXMLDataFormat(child, version));
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTCELL_FORMULA")) {
                if (version >= 70) {
                    this.formulaName = LoadXMLReportHelper.readCDATA(child);
                    continue;
                }
                this.formula = LoadXMLReportHelper.readCDATA(child);
                continue;
            }
            if (!child.getNodeName().equalsIgnoreCase("REPORTCELL_SQLTYPE")) continue;
            this.sqlType = DataType.findType(LoadXMLReportHelper.readText(child));
            check1 = true;
        }
        if (!check1) {
            throw new Exception("Missing 'REPORTCELL' attribute.");
        }
        super.readXML(node, version);
    }

    public static ReportCell createCell(DataInput in, int version) throws Exception {
        ReportCell cell = new ReportCell();
        cell.read(in, version);
        return cell;
    }

    @Override
    public void read(DataInput in, int version) throws Exception {
        if (version >= 2) {
            this.setDataFormat(FormatUtil.readDataFormat(in, version));
        }
        if (version >= 70) {
            this.formulaName = IOUtil.readStr(in);
        } else {
            this.setFormula(IOUtil.readStr(in));
        }
        this.sqlType = in.readInt();
        super.read(in, version);
    }

    public static ReportCell clone(ReportCell _cell) {
        if (_cell instanceof CBColumnHeader) {
            CBColumnHeader cell = new CBColumnHeader(((CBColumnHeader)_cell).getColBreakValueIndex());
            cell.copy((CBColumnHeader)_cell);
            return cell;
        }
        if (_cell instanceof CBAggrColHeader) {
            CBAggrColHeader cell = new CBAggrColHeader(((CBAggrColHeader)_cell).getColBreakLevel(), ((CBAggrColHeader)_cell).getColBreakValueIndex());
            cell.copy((CBAggrColHeader)_cell);
            return cell;
        }
        if (_cell instanceof RBColumnHeader) {
            RBColumnHeader cell = new RBColumnHeader(((RBColumnHeader)_cell).getColBreakLevel());
            cell.copy((RBColumnHeader)_cell);
            return cell;
        }
        if (_cell instanceof ColumnHeader) {
            ColumnHeader cell = new ColumnHeader();
            cell.copy((ColumnHeader)_cell);
            return cell;
        }
        if (_cell instanceof CBColumnFooter) {
            CBColumnFooter cell = new CBColumnFooter(((CBColumnFooter)_cell).getColBreakValueIndex());
            cell.copy((CBColumnFooter)_cell);
            return cell;
        }
        if (_cell instanceof CBAggrColFooter) {
            CBAggrColFooter cell = new CBAggrColFooter(((CBAggrColFooter)_cell).getColBreakLevel(), ((CBAggrColFooter)_cell).getColBreakValueIndex());
            cell.copy((CBAggrColFooter)_cell);
            return cell;
        }
        if (_cell instanceof ReportLine) {
            ReportLine cell = new ReportLine();
            cell.copy((ReportLine)_cell);
            return cell;
        }
        if (_cell instanceof ReportGrid) {
            ReportGrid cell = new ReportGrid();
            cell.copy((ReportGrid)_cell);
            return cell;
        }
        if (_cell instanceof ReportChartObject) {
            ReportChartObject cell = new ReportChartObject();
            cell.copy((ReportChartObject)_cell);
            return cell;
        }
        if (_cell instanceof ReportImage) {
            ReportImage cell = new ReportImage();
            cell.copy((ReportImage)_cell);
            return cell;
        }
        if (_cell instanceof SubReportObject) {
            SubReportObject cell = new SubReportObject();
            cell.copy((SubReportObject)_cell);
            return cell;
        }
        if (_cell instanceof TableOfContents) {
            TableOfContents cell = new TableOfContents();
            cell.copy((TableOfContents)_cell);
            return cell;
        }
        if (_cell instanceof FormattedCell) {
            FormattedCell cell = new FormattedCell();
            cell.copy((FormattedCell)_cell);
            return cell;
        }
        if (_cell instanceof ReportRTFObject) {
            ReportRTFObject cell = new ReportRTFObject(null);
            cell.copy((ReportRTFObject)_cell);
            return cell;
        }
        ReportCell cell = new ReportCell();
        cell.copy(_cell);
        return cell;
    }

    public boolean formulaReferenced(Formula form) {
        if (form == this.formulaObj) {
            return true;
        }
        return this.formulaObj != null && this.formulaObj.formulaReferenced(form);
    }

    public void createFormulaObject(Report r) {
        if (this.formulaObj == null && this.formula != null) {
            try {
                Vector<Vector<Formula>> formulaVec = new Vector<Vector<Formula>>();
                formulaVec.add(r.formulas);
                for (int j = 0; r.subReports != null && j < r.subReports.size(); ++j) {
                    Report rpt = r.getSubReportArray(true)[j];
                    if (rpt == null) continue;
                    formulaVec.add(rpt.formulas);
                }
                this.formulaObj = new Formula("formula" + (r.formulas.size() + 1), this.formula);
                ByteArrayInputStream inputStream = new ByteArrayInputStream(this.formula.getBytes("UTF-8"));
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)inputStream, "UTF-8");
                NewFormulaParser parser = new NewFormulaParser(inputStreamReader);
                this.formulaObj.setFormula(parser.parse(formulaVec, r.getQueryParameters(), r.getFormulaParameters(), null));
                this.formulaObj.getDatatype(r);
                r.formulas.addElement(this.formulaObj);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void createFormulaObjectFromText(Report r) {
        if (this.formula != null) {
            for (int i = 0; i < r.formulas.size(); ++i) {
                Formula f = r.formulas.elementAt(i);
                if (!this.formula.equals(f.getName())) continue;
                f.getDatatype(r);
                this.setFormulaObj(f);
                return;
            }
            if (this.formulaObj == null) {
                try {
                    Vector<Vector<Formula>> formulaVec = new Vector<Vector<Formula>>();
                    formulaVec.add(r.formulas);
                    for (int j = 0; r.subReports != null && j < r.subReports.size(); ++j) {
                        Report rpt = r.getSubReportArray(true)[j];
                        if (rpt == null) continue;
                        formulaVec.add(rpt.formulas);
                    }
                    this.formulaObj = new Formula(null, this.formula);
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(this.formula.getBytes("UTF-8"));
                    InputStreamReader inputStreamReader = new InputStreamReader((InputStream)inputStream, "UTF-8");
                    NewFormulaParser parser = new NewFormulaParser(inputStreamReader);
                    this.formulaObj.setFormula(parser.parse(formulaVec, r.getQueryParameters(), r.getFormulaParameters(), null));
                    this.formulaObj.getDatatype(r);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    public void createFormulaObjectFromName(Report r) {
        if (this.formulaName != null) {
            for (int i = 0; i < r.formulas.size(); ++i) {
                Formula f = r.formulas.elementAt(i);
                if (!this.formulaName.equals(f.getName())) continue;
                if (f.getFormula() instanceof ScriptReportElement && ((ScriptReportElement)f.getFormula()).getId() == null) {
                    ((ScriptReportElement)f.getFormula()).setId(this.getID());
                }
                f.getDatatype(r);
                this.setFormulaObj(f);
                return;
            }
            if (this.formulaObj == null) {
                this.setFormula(this.formulaName);
                this.createFormulaObjectFromText(r);
            }
        } else {
            this.createFormulaObjectFromText(r);
        }
    }

    public int getColIndex(ReportTable table) {
        if (this.formulaObj == null) {
            return -1;
        }
        String s = this.formulaObj.getText();
        if (s.startsWith("{") && s.endsWith("}")) {
            String colName = s.substring(s.indexOf(123) + 1, s.indexOf(125));
            for (int i = 0; i < table.getColumnCount(); ++i) {
                if (!table.getColumn(i).getText().equals(colName)) continue;
                return i;
            }
        } else if (s.indexOf("COL(") >= 0) {
            int index = s.indexOf("COL(");
            int index2 = s.indexOf(")", index);
            return Integer.parseInt(s.substring(index + 4, index2).trim());
        }
        return -1;
    }

    public void setScriptedValue(Object value) {
        this.scriptedValue = value;
    }

    public Object getScriptedValue() {
        return this.scriptedValue;
    }

    @Deprecated
    public void setFormula(String formula) {
        this.formula = formula;
    }

    public Bookmark getEntry() {
        return this.entry;
    }

    public void setEntry(Bookmark entry) {
        this.entry = entry;
    }

    public ReportColumn getColumn() {
        return this.column;
    }

    public void setColumn(ReportColumn column) {
        this.column = column;
    }

    public void applyStyle(ReportCell _cell) {
        super.applyStyle(_cell);
        if (FormatUtil.isFormatAppliabled(this.getDataFormat(), _cell.getDataFormat())) {
            this.setDataFormat(_cell.getDataFormat());
        }
    }

    public void applyStyleButNotWH(ReportCell _cell) {
        super.applyStyleButNotWH(_cell);
        if (FormatUtil.isFormatAppliabled(this.getDataFormat(), _cell.getDataFormat())) {
            this.setDataFormat(_cell.getDataFormat());
        }
    }

    public void applyStyleButNotWHCopyScripts(ReportCell _cell, boolean copyScriptsAndDrillDownLinks) {
        this.applyStyleButNotWH(_cell);
        if (copyScriptsAndDrillDownLinks) {
            this.setScriptName(_cell.getScriptName());
            this.setScriptObj(_cell.getScriptObj());
            this.setScript(_cell.getScript());
            this.setLink(_cell.getLink());
            this.setDrillDownName(_cell.getDrillDownName());
            this.setHint(_cell.getHint());
        }
    }
}

