/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.ReportElements;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Properties;
import java.util.Vector;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import quadbase.ChartAPI.QbChart;
import quadbase.chart.Chart;
import quadbase.chart.LoadChart;
import quadbase.chart.SaveChart;
import quadbase.common.client.FileInfo;
import quadbase.common.client.ServerMessage;
import quadbase.common.util.internal.FileInMemTable;
import quadbase.common.util.internal.IChart;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.VersioningDataOutput;
import quadbase.reportdesigner.ReportElements.ReportImage;
import quadbase.reportdesigner.report.LoadXMLReportHelper;
import quadbase.reportdesigner.report.ReadDataFile;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.util.IChartModifier;
import quadbase.util.IQueryFileInfo;

public class ReportChartObject
extends ReportImage
implements Serializable {
    IChart chartObject;
    public static final String XMLTAG = "REPORTCHARTOBJECT";
    boolean includeSectionData = false;
    boolean useReportData = true;
    boolean useSummaryData = false;
    boolean exportMapFile = false;
    IChartModifier chartModifier;
    private String[] parameterMap = null;
    private String domainPath = "";
    private String[] colDataMapping = null;
    private FileInMemTable subFilesTable;

    public ReportChartObject() {
    }

    public ReportChartObject(String name) {
        super(name);
    }

    public void setChart(IChart chartObject) {
        this.chartObject = chartObject;
    }

    public IChart getChart() {
        return this.chartObject;
    }

    public void setParameterMap(String[] p) {
        this.parameterMap = p;
    }

    public String[] getParameterMap() {
        return this.parameterMap;
    }

    public void setChartModifier(IChartModifier chartMod) {
        this.chartModifier = chartMod;
    }

    public IChartModifier getChartModifier() {
        return this.chartModifier;
    }

    public boolean isSectionDataIncluded() {
        return this.includeSectionData;
    }

    public void setSectionDataIncluded(boolean b) {
        this.includeSectionData = b;
    }

    public boolean isReportDataUsed() {
        return this.useReportData;
    }

    public void setReportDataUsed(boolean b) {
        this.useReportData = b;
    }

    public void setSummaryDataUsed(boolean b) {
        this.useSummaryData = b;
    }

    public boolean isSummaryDataUsed() {
        return this.useSummaryData;
    }

    public String[] getColDataMapping() {
        return this.colDataMapping;
    }

    public void setColDataMapping(String[] map) {
        this.colDataMapping = map;
    }

    public boolean isExportMapFile() {
        return this.exportMapFile;
    }

    public void setExportMapFile(boolean b) {
        this.exportMapFile = b;
    }

    public String getChartLocation() {
        return this.getText();
    }

    public static ReportChartObject createChartObject(DataInput in, int version) throws Exception {
        return ReportChartObject.createChartObject(in, version, false, null, "");
    }

    public static ReportChartObject createChartObject(DataInput in, int version, boolean pack, FileInMemTable subFilesTable, String domainPath) throws Exception {
        ReportChartObject cell = new ReportChartObject();
        cell.read(in, version, pack, subFilesTable, domainPath);
        return cell;
    }

    @Override
    public void read(DataInput in, int version) throws Exception {
        this.read(in, version, false, null, "");
    }

    public void read(DataInput in, int version, boolean pack, FileInMemTable subFilesTable, String domainPath) throws Exception {
        boolean hasBytes;
        int count;
        boolean hasMap;
        super.read(in, version, false, subFilesTable);
        this.domainPath = domainPath;
        this.subFilesTable = subFilesTable;
        if (version >= 34) {
            this.includeSectionData = in.readBoolean();
        }
        if (version >= 107) {
            this.useReportData = in.readBoolean();
        }
        if (version >= 272) {
            this.useSummaryData = in.readBoolean();
        }
        if (version >= 262 && version <= 270 || version >= 273) {
            int colMapCt = in.readInt();
            this.colDataMapping = colMapCt == -1 ? null : new String[colMapCt];
            for (int i = 0; i < colMapCt; ++i) {
                this.colDataMapping[i] = IOUtil.readString(in, true);
            }
        }
        if (version >= 108) {
            this.exportMapFile = in.readBoolean();
        }
        if (version >= 177 && (hasMap = in.readBoolean())) {
            count = in.readInt();
            this.parameterMap = count >= 0 ? new String[count] : null;
            for (int i = 0; i < count; ++i) {
                this.parameterMap[i] = IOUtil.readStr(in);
            }
        }
        if ((pack || this.getText(subFilesTable).equals("") && version >= 209) && (hasBytes = in.readBoolean())) {
            count = in.readInt();
            byte[] bytes = new byte[count];
            in.readFully(bytes);
            this.setBytes(bytes);
            if (subFilesTable != null && subFilesTable.isFileInMemEnabled()) {
                subFilesTable.put(this.getText(subFilesTable), bytes);
            }
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        this.write(out, false);
    }

    @Override
    public void write(DataOutput out, boolean pack) throws IOException {
        String path = this.domainPath;
        this.domainPath = "";
        super.write(out, false);
        this.domainPath = path;
        out.writeBoolean(this.includeSectionData);
        out.writeBoolean(this.useReportData);
        out.writeBoolean(this.useSummaryData);
        if (this.colDataMapping == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(this.colDataMapping.length);
            for (String element : this.colDataMapping) {
                IOUtil.writeString(out, element);
            }
        }
        out.writeBoolean(this.exportMapFile);
        if (this.parameterMap == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeInt(this.parameterMap.length);
            for (String element : this.parameterMap) {
                IOUtil.writeStr(out, element);
            }
        }
        if (pack || this.getText().equals("")) {
            this.packChart(out);
            this.writeChartData(out);
        }
    }

    public void writeChartData(DataOutput out) throws IOException {
        try {
            String filename = this.getText();
            FileInMemTable subFilesTable = null;
            if (out instanceof VersioningDataOutput) {
                subFilesTable = ((VersioningDataOutput)out).getSubFilesTables();
            }
            ByteArrayOutputStream bytestream = new ByteArrayOutputStream(2048);
            ReadDataFile readfile = new ReadDataFile();
            if (filename == null || filename.equals("")) {
                throw new Exception();
            }
            DataInputStream in = readfile.getInputStream(subFilesTable, filename);
            int c = in.read();
            while (c != -1) {
                bytestream.write(c);
                c = in.read();
            }
            in.close();
            bytestream.close();
            byte[] barray = bytestream.toByteArray();
            out.writeBoolean(true);
            out.writeInt(barray.length);
            out.write(barray);
        }
        catch (Exception ex) {
            if (this.getBytes() != null) {
                out.writeBoolean(true);
                out.writeInt(this.getBytes().length);
                out.write(this.getBytes());
            }
            if (this.getChart() != null) {
                try {
                    ByteArrayOutputStream bytestream2 = new ByteArrayOutputStream(2048);
                    ((QbChart)this.getChart()).export(5, bytestream2);
                    bytestream2.flush();
                    byte[] bytearray = bytestream2.toByteArray();
                    bytestream2.close();
                    out.writeBoolean(true);
                    out.writeInt(bytearray.length);
                    out.write(bytearray, 0, bytearray.length);
                }
                catch (Throwable x) {
                    x.printStackTrace();
                    out.writeBoolean(false);
                }
            }
            out.writeBoolean(false);
        }
    }

    public void resetByteArray() {
        if (this.getBytes() == null) {
            return;
        }
        try {
            ByteArrayOutputStream bytestream = new ByteArrayOutputStream(2048);
            ReadDataFile readfile = new ReadDataFile();
            if (this.getText() == null) {
                return;
            }
            String filename = this.getText();
            if ((filename = filename.replace('\\', '/')).startsWith("file:/")) {
                filename = filename.substring(6);
            }
            DataInputStream in = readfile.getInputStream(null, filename);
            int c = in.read();
            while (c != -1) {
                bytestream.write(c);
                c = in.read();
            }
            in.close();
            bytestream.close();
            byte[] barray = bytestream.toByteArray();
            this.setBytes(barray);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void packChart(DataOutput out) {
        try {
            String filename = this.getText();
            if (filename == null || filename.equals("")) {
                return;
            }
            LoadChart loadChart = new LoadChart();
            FileInMemTable subFilesTable = null;
            if (out instanceof VersioningDataOutput) {
                subFilesTable = ((VersioningDataOutput)out).getSubFilesTables();
                loadChart.setSubFilesTable(subFilesTable);
            }
            Chart chart = null;
            if ((subFilesTable == null || subFilesTable.contains(filename)) && (chart = loadChart.loadChartFromFile(null, filename, null, true)).getBackgroundImage() != null) {
                SaveChart savechart = new SaveChart(chart);
                savechart.pack = true;
                boolean template = filename.toUpperCase().endsWith(".TPL");
                savechart.saveToFile(filename.substring(0, filename.length() - 4), template);
            }
        }
        catch (Exception ex) {
            ex.getMessage();
        }
    }

    public static ReportChartObject createChartObject(Node node, int version) throws Exception {
        if (!node.getNodeName().equalsIgnoreCase(XMLTAG)) {
            throw new Exception("'REPORTCHARTOBJECT' element expected, but found '" + node.getNodeName() + "' element.");
        }
        ReportChartObject cell = new ReportChartObject();
        cell.readXML(node, version);
        return cell;
    }

    public void deepCopy(ReportChartObject _chart) {
        super.deepCopy(_chart);
        this.chartObject = _chart.getChart();
        this.chartModifier = _chart.getChartModifier();
        this.setSectionDataIncluded(_chart.isSectionDataIncluded());
        this.setReportDataUsed(_chart.isReportDataUsed());
        this.setSummaryDataUsed(_chart.isSummaryDataUsed());
        this.setExportMapFile(_chart.isExportMapFile());
        this.setParameterMap(_chart.getParameterMap());
        this.setColDataMapping(_chart.getColDataMapping());
        this.domainPath = _chart.domainPath;
    }

    public void copy(ReportChartObject _chart) {
        super.copy(_chart);
        this.chartObject = _chart.getChart();
        this.chartModifier = _chart.getChartModifier();
        this.setSectionDataIncluded(_chart.isSectionDataIncluded());
        this.setReportDataUsed(_chart.isReportDataUsed());
        this.setSummaryDataUsed(_chart.isSummaryDataUsed());
        this.setExportMapFile(_chart.isExportMapFile());
        this.setParameterMap(_chart.getParameterMap());
        this.setColDataMapping(_chart.getColDataMapping());
        this.domainPath = _chart.domainPath;
    }

    public void copyTemplate(ReportChartObject _chart) {
        super.copyTemplate(_chart);
        this.setSectionDataIncluded(_chart.isSectionDataIncluded());
        this.setReportDataUsed(_chart.isReportDataUsed());
        this.setSummaryDataUsed(_chart.isSummaryDataUsed());
        this.setColDataMapping(_chart.getColDataMapping());
        this.setExportMapFile(_chart.isExportMapFile());
    }

    public void applyTemplate(ReportChartObject _chart) {
        super.applyTemplate(_chart);
        this.setSectionDataIncluded(_chart.isSectionDataIncluded());
        this.setReportDataUsed(_chart.isReportDataUsed());
        this.setSummaryDataUsed(_chart.isSummaryDataUsed());
        this.setExportMapFile(_chart.isExportMapFile());
    }

    @Override
    public void writeXML(Writer out, boolean writeElementTag) throws IOException {
        if (writeElementTag) {
            out.write("<REPORTCHARTOBJECT>\n");
        }
        super.writeXML(out, false);
        out.write("<REPORTCHARTOBJECT_INCLUDESECTIONDATA>" + this.isSectionDataIncluded() + "</REPORTCHARTOBJECT_INCLUDESECTIONDATA>\n");
        out.write("<REPORTCHARTOBJECT_USEREPORTDATA>" + this.isReportDataUsed() + "</REPORTCHARTOBJECT_USEREPORTDATA>\n");
        out.write("<REPORTCHARTOBJECT_USESUMMARYDATA>" + this.isSummaryDataUsed() + "</REPORTCHARTOBJECT_USESUMMARYDATA>\n");
        out.write("<REPORTCHARTOBJECT_EXPORTMAPFILE>" + this.isExportMapFile() + "</REPORTCHARTOBJECT_EXPORTMAPFILE>\n");
        if (this.parameterMap != null) {
            for (String element : this.parameterMap) {
                out.write("<PARAMETERMAP>" + element + "</PARAMETERMAP>");
            }
        }
        if (this.colDataMapping != null) {
            for (String element : this.colDataMapping) {
                out.write("<COLDATAMAPPING>" + element + "</COLDATAMAPPING>");
            }
        }
        if (writeElementTag) {
            out.write("</REPORTCHARTOBJECT>\n");
        }
    }

    @Override
    public void readXML(Node node, int version) throws Exception {
        int i;
        super.readXML(node, version);
        boolean check1 = false;
        boolean check2 = false;
        boolean check3 = false;
        boolean check4 = false;
        Vector<String> params = new Vector<String>();
        Vector<String> colDataMap = new Vector<String>();
        NodeList nodeList = node.getChildNodes();
        for (i = 0; i < nodeList.getLength(); ++i) {
            Node child = nodeList.item(i);
            if (child.getNodeName().equalsIgnoreCase("REPORTCHARTOBJECT_INCLUDESECTIONDATA")) {
                this.includeSectionData = LoadXMLReportHelper.parseBoolean(LoadXMLReportHelper.readText(child));
                check1 = true;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTCHARTOBJECT_USEREPORTDATA")) {
                this.useReportData = LoadXMLReportHelper.parseBoolean(LoadXMLReportHelper.readText(child));
                check2 = true;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTCHARTOBJECT_USESUMMARYDATA")) {
                this.useSummaryData = LoadXMLReportHelper.parseBoolean(LoadXMLReportHelper.readText(child));
                check4 = true;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTCHARTOBJECT_EXPORTMAPFILE")) {
                this.exportMapFile = LoadXMLReportHelper.parseBoolean(LoadXMLReportHelper.readText(child));
                check3 = true;
            }
            if (child.getNodeName().equalsIgnoreCase("PARAMETERMAP")) {
                params.addElement(LoadXMLReportHelper.readText(child));
            }
            if (!child.getNodeName().equalsIgnoreCase("COLDATAMAPPING")) continue;
            colDataMap.addElement(LoadXMLReportHelper.readText(child));
        }
        if (params.size() > 0) {
            this.parameterMap = new String[params.size()];
            for (i = 0; i < this.parameterMap.length; ++i) {
                this.parameterMap[i] = (String)params.elementAt(i);
            }
        }
        if (colDataMap.size() > 0) {
            this.colDataMapping = new String[colDataMap.size()];
            for (i = 0; i < this.colDataMapping.length; ++i) {
                this.colDataMapping[i] = (String)colDataMap.elementAt(i);
            }
        }
        if (!check1) {
            this.includeSectionData = false;
        }
        if (!check2) {
            this.useReportData = true;
        }
        if (!check3) {
            this.exportMapFile = false;
        }
        if (!check4) {
            this.useSummaryData = false;
        }
    }

    public void setDomainPath(String path) {
        this.domainPath = path;
    }

    public String getDomainPath() {
        return this.domainPath;
    }

    @Override
    public String getText() {
        return this.getText(this.subFilesTable);
    }

    public String getText(FileInMemTable subFilesTable) {
        String s = super.getText();
        if (this.domainPath != null && !this.domainPath.equals("") && s.startsWith(this.domainPath)) {
            super.setText(s.substring(this.domainPath.length()));
        }
        if (this.domainPath != null && !this.domainPath.equals("")) {
            String filename2 = s.replaceAll("\\\\", "/");
            if (filename2.indexOf("/chart/") > -1 && this.useReportData) {
                return this.domainPath + filename2.substring(filename2.lastIndexOf("/chart/") + 1);
            }
            return this.domainPath + super.getText();
        }
        if (s == null || s.length() == 0) {
            return s;
        }
        try {
            String filename2;
            if (subFilesTable != null) {
                String filename22;
                if (!Report.fileExists(subFilesTable, s) && (filename22 = s.replaceAll("\\\\", "/")).indexOf("/chart/") > -1 && this.useReportData) {
                    return filename22.substring(filename22.lastIndexOf("/chart/") + 1);
                }
            } else if (!new FileInfo(s).exists() && (filename2 = s.replaceAll("\\\\", "/")).indexOf("/chart/") > -1 && this.useReportData) {
                return filename2.substring(filename2.lastIndexOf("/chart/") + 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return s;
    }

    @Override
    public void setText(String fn) {
        if (fn == null) {
            return;
        }
        fn = fn.replace('\\', '/');
        if (this.domainPath != null && !this.domainPath.equals("") && fn.indexOf(this.domainPath) >= 0) {
            super.setText(fn.substring(fn.indexOf(this.domainPath) + this.domainPath.length()));
        } else {
            super.setText(fn);
        }
    }

    public String getNewChartName(FileInMemTable subFilesTable, String filename) {
        String chartFileName = filename;
        String ext = "";
        int index = chartFileName.indexOf(46);
        if (index < 0) {
            index = chartFileName.length();
        }
        chartFileName = chartFileName.substring(chartFileName.lastIndexOf(92) + 1, index);
        chartFileName = chartFileName.substring(chartFileName.lastIndexOf(47) + 1);
        ext = this.getText().toUpperCase().endsWith("CHT") ? ".cht" : ".tpl";
        String tmp = chartFileName = "chart/" + chartFileName;
        int ct = 0;
        try {
            if (this.domainPath == null) {
                while (Report.fileExists(subFilesTable, chartFileName + ext)) {
                    chartFileName = tmp + "_" + ct++;
                }
            } else {
                while (Report.fileExists(subFilesTable, this.domainPath + chartFileName + ext)) {
                    chartFileName = tmp + "_" + ct++;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return chartFileName + ext;
    }

    public IChart getChartObject() {
        if (this.chartObject != null) {
            return this.chartObject;
        }
        boolean oldFlag = QbChart.isForExportOnly();
        QbChart.setForExportOnly(true);
        Properties props = new Properties();
        props.put("prompt parameter", "false");
        props.put("use backup data", "true");
        if (this.getBytes() != null) {
            boolean isTemplate = false;
            if (this.getText() != null && this.getText().toUpperCase().endsWith(".TPL")) {
                isTemplate = true;
            }
            QbChart tmpChart = new QbChart(ServerMessage.getApplet(), this.getBytes(), isTemplate, props);
            QbChart.setForExportOnly(oldFlag);
            if (tmpChart.gethInputData().getDatabaseInfo() instanceof IQueryFileInfo) {
                return tmpChart;
            }
            this.chartObject = tmpChart;
            return this.chartObject;
        }
        QbChart tmpChart = new QbChart(ServerMessage.getApplet(), this.getText(), null, props);
        QbChart.setForExportOnly(oldFlag);
        if (tmpChart.gethInputData().getDatabaseInfo() instanceof IQueryFileInfo) {
            return tmpChart;
        }
        this.chartObject = tmpChart;
        return this.chartObject;
    }

    public int getDataSourceType() {
        if (!this.isReportDataUsed()) {
            return ((QbChart)this.getChartObject()).getChart().sourceData;
        }
        return -1;
    }

    public String getDataSourceID() {
        if (!this.isReportDataUsed()) {
            return ((QbChart)this.getChartObject()).getChart().dataSourceID;
        }
        return null;
    }

    public void setDataSourceID(String id) {
        if (!this.isReportDataUsed()) {
            ((QbChart)this.getChartObject()).getChart().dataSourceID = id;
        }
    }
}

