/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.ReportElements;

import java.awt.Color;
import java.awt.Font;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import quadbase.common.client.ServerMessage;
import quadbase.common.util.internal.DataSet;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.FontTable;
import quadbase.common.util.internal.IDataSet;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.QbUtil;
import quadbase.common.util.internal.XMLUtil;
import quadbase.reportdesigner.ReportElements.CBAggrColumn;
import quadbase.reportdesigner.ReportElements.ColumnBreakColumn;
import quadbase.reportdesigner.ReportElements.FormattedCell;
import quadbase.reportdesigner.ReportElements.FormattedRowKey;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportDocument;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.ReportElements.ReportImage;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.report.Aggregation;
import quadbase.reportdesigner.report.LoadXMLReportHelper;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.Script;
import quadbase.reportdesigner.util.ICellScript;
import quadbase.reportdesigner.util.IFormat;
import quadbase.reportdesigner.util.ImageURLFormat;
import quadbase.reportdesigner.util.StringFormat;
import quadbase.reportdesigner.util.TextURLFormat;
import quadbase.reportdesigner.util.internal.BooleanCompare;
import quadbase.reportdesigner.util.internal.DateCompare;
import quadbase.reportdesigner.util.internal.FormatUtil;
import quadbase.reportdesigner.util.internal.ICompareObject;
import quadbase.reportdesigner.util.internal.NumberCompare;
import quadbase.reportdesigner.util.internal.SortObject;
import quadbase.reportdesigner.util.internal.StringCompare;

public class ReportColumn
extends ReportElement
implements Serializable {
    private IFormat format;
    private ICellScript cellScript = null;
    private IDataSet data;
    private IDataSet actualdata = null;
    private IDataSet scriptedData = null;
    private String styleName2 = "";
    private Color bgColor2 = new Color(233, 233, 233);
    private Color fontColor2 = Color.black;
    private Font font2 = FontTable.newFont("Dialog", 0, QbUtil.getAdjustedFont(12, true));
    private boolean underline2 = false;
    private int altRow = 0;
    private String dbTableName;
    private boolean dualColorOnRowBreak = false;
    private int[] dualColorColInfoIndex;
    private boolean[] isBGColor2;
    private int noOfCol = -1;
    private boolean isTreeReport = false;
    private IDataSet dataSetTree;
    private Object drillDownData = null;
    private Vector<FormattedCell> formattedCells = null;
    private Hashtable<FormattedRowKey, FormattedCell> formattedCellsTable = null;
    private int charLen = ServerMessage.getMaxFieldSize();
    public static final String XMLTAG = "REPORTCOLUMN";
    private boolean doNotFinalizeDataSet = false;

    public ReportColumn() {
        this.setBgColor(Color.white);
    }

    public ReportColumn(ReportColumn _col) {
        this();
        this.copy(_col);
    }

    public ReportColumn(ReportColumn _col, Properties treeProp) {
        this();
        this.copy(_col);
        this.isTreeReport = true;
        if (treeProp != null) {
            this.dataSetTree = (IDataSet)treeProp.get("DataSetTree");
        }
    }

    public ReportColumn(String name, int noOfCol, boolean isTreeReport, Properties treeProp) {
        super(name);
        this.noOfCol = noOfCol;
        this.isTreeReport = isTreeReport;
        if (treeProp != null) {
            this.dataSetTree = (IDataSet)treeProp.get("DataSetTree");
        }
        this.setBgColor(Color.white);
    }

    public ReportColumn(String name, IFormat dataFormat, int noOfCol) {
        this(name, noOfCol, true, null);
        this.format = dataFormat;
    }

    public ReportColumn(String name, String tableName, IFormat dataFormat, int columnDisplaySize, int noOfCol, boolean isTreeReport) {
        this(name, noOfCol, isTreeReport, null);
        this.dbTableName = tableName;
        this.format = dataFormat;
        if (columnDisplaySize > 0) {
            this.charLen = columnDisplaySize;
        }
    }

    public ReportColumn(String name, String tableName, IFormat dataFormat, int columnDisplaySize, Hashtable<FormattedRowKey, FormattedCell> formattedCellsTable, int noOfCol, boolean isTreeReport) {
        this(name, noOfCol, isTreeReport, new Properties());
        this.dbTableName = tableName;
        this.format = dataFormat;
        this.formattedCellsTable = formattedCellsTable;
        if (columnDisplaySize > 0) {
            this.charLen = columnDisplaySize;
        }
    }

    @Override
    public boolean contains(double cx, double cy) {
        if (!this.isVisible()) {
            return false;
        }
        return super.contains(cx, cy);
    }

    @Override
    public boolean containsX(double cx, double w) {
        if (!this.isVisible()) {
            return false;
        }
        return super.containsX(cx, w);
    }

    @Override
    public boolean containsY(double cy, double h) {
        if (!this.isVisible()) {
            return false;
        }
        return super.containsY(cy, h);
    }

    @Override
    public boolean inTopHalf(double cy) {
        if (!this.isVisible()) {
            return false;
        }
        return super.inTopHalf(cy);
    }

    @Override
    public boolean inBottomHalf(double cy) {
        if (!this.isVisible()) {
            return false;
        }
        return super.inBottomHalf(cy);
    }

    @Override
    public boolean inLeftHalf(double cx) {
        if (!this.isVisible()) {
            return false;
        }
        return super.inLeftHalf(cx);
    }

    @Override
    public boolean inRightHalf(double cx) {
        if (!this.isVisible()) {
            return false;
        }
        return super.inRightHalf(cx);
    }

    @Override
    public boolean inLeftEnd(double cx) {
        if (!this.isVisible()) {
            return false;
        }
        return super.inLeftEnd(cx);
    }

    @Override
    public boolean inRightEnd(double cx, double w) {
        if (!this.isVisible()) {
            return false;
        }
        return super.inRightEnd(cx, w);
    }

    public void copy(ReportColumn _col) {
        super.copy(_col);
        if (_col == null) {
            return;
        }
        this.setDataFormat(_col.getDataFormat());
        this.setCellScript(_col.getCellScript());
        this.setVisible(_col.isVisible());
        this.data = _col.data;
        this.doNotFinalizeDataSet = true;
        this.setStyleName2(_col.getStyleName2());
        this.setBgColor2(_col.getBgColor2());
        this.setFontColor2(_col.getFontColor2());
        this.setUnderline2(_col.isUnderline2());
        this.setFont2(FontTable.newFont(_col.getRefFont2().getName(), _col.getRefFont2().getStyle(), _col.getRefFont2().getSize()));
        this.setAlternateRow(_col.getAlternateRow());
        this.setFormattedCells(_col.getFormattedCells());
        this.setFormattedCellsTable(_col.getFormattedCellsTable());
        if (_col.getDBTableName() != null) {
            this.setDBTableName(_col.getDBTableName());
        }
        this.setDualColorOnRowBreak(_col.isDualColorOnRowBreak());
        this.setDualColorColInfoIndex(_col.getDualColorColInfoIndex());
        this.isBGColor2 = _col.isBGColor2;
        this.charLen = _col.charLen;
        this.noOfCol = _col.noOfCol;
        this.isTreeReport = _col.isTreeReport;
        this.dataSetTree = _col.dataSetTree;
    }

    public void copyTemplate(ReportColumn _col) {
        this.copyTemplate(_col, false);
    }

    public void copyTemplate(ReportColumn _col, boolean applyFunction) {
        this.copyTemplate(_col, applyFunction, true, true);
    }

    public void copyTemplate(ReportColumn _col, boolean applyFunction, boolean applyElementPosition) {
        this.copyTemplate(_col, applyFunction, applyElementPosition, true);
    }

    public void copyTemplate(ReportColumn _col, boolean applyFunction, boolean applyElementPosition, boolean copyDrillDownName) {
        this.applyTemplate(_col, false, applyElementPosition, copyDrillDownName);
        if (applyFunction) {
            this.setScriptName(_col.getScriptName());
        }
        if (applyFunction) {
            this.setScriptObj(_col.getScriptObj());
        }
        if (applyFunction) {
            this.setScript(_col.getScript());
        }
        if (applyFunction) {
            this.setSecurityMap(_col.getSecurityMap());
            this.setSecurityTextScript(_col.isSecurityTextScript());
            this.setShiftSecuredColX(_col.isShiftSecuredColX());
            this.setShiftSecuredColXIncludeHeaderAndFooter(_col.isShiftSecuredColXIncludeHeaderAndFooter());
        }
        this.setFormattedCells(_col.getFormattedCells());
        this.setFormattedCellsTable(_col.getFormattedCellsTable());
        if (this.getDataFormat() != null && _col.getDataFormat() != null) {
            if (FormatUtil.isFormatAppliabled(this.getDataFormat(), _col.getDataFormat())) {
                this.setDataFormat(_col.getDataFormat());
            }
        } else {
            this.setDataFormat(_col.getDataFormat());
        }
        if (_col.getDBTableName() != null) {
            this.setDBTableName(_col.getDBTableName());
        }
        this.charLen = _col.charLen;
    }

    public void copyTemplateExceptOrigin(ReportColumn _col) {
        double x = this.getX();
        double y = this.getY();
        this.applyTemplate(_col);
        this.setCellScript(_col.getCellScript());
        this.setX(x);
        this.setY(y);
    }

    public void deepCopy(ReportColumn _col) {
        super.deepCopy(_col);
        this.setDataFormat(_col.getDataFormat());
        this.setCellScript(_col.getCellScript());
        this.setVisible(_col.isVisible());
        this.data = _col.data;
        this.doNotFinalizeDataSet = true;
        this.setStyleName2(_col.getStyleName2());
        this.setBgColor2(_col.getBgColor2());
        this.setFontColor2(_col.getFontColor2());
        this.setUnderline2(_col.isUnderline2());
        this.setFont2(FontTable.newFont(_col.getRefFont2().getName(), _col.getRefFont2().getStyle(), _col.getRefFont2().getSize()));
        this.setAlternateRow(_col.getAlternateRow());
        this.setCellScript(_col.getCellScript());
        this.setText(_col.getText());
        this.setFormattedCells(_col.getFormattedCells());
        this.setFormattedCellsTable(_col.getFormattedCellsTable());
        if (_col.getDBTableName() != null) {
            this.setDBTableName(_col.getDBTableName());
        }
        this.setDualColorOnRowBreak(_col.isDualColorOnRowBreak());
        this.setDualColorColInfoIndex(_col.getDualColorColInfoIndex());
        this.isBGColor2 = _col.isBGColor2;
        this.charLen = _col.charLen;
    }

    public void positionCopy(ReportColumn _col) {
        super.deepCopy(_col);
        this.setDataFormat(_col.getDataFormat());
        this.setCellScript(_col.getCellScript());
        this.setVisible(_col.isVisible());
        this.data = _col.data;
        this.doNotFinalizeDataSet = true;
        this.setStyleName2(_col.getStyleName2());
        this.setBgColor2(_col.getBgColor2());
        this.setFontColor2(_col.getFontColor2());
        this.setUnderline2(_col.isUnderline2());
        this.setFont2(FontTable.newFont(_col.getRefFont2().getName(), _col.getRefFont2().getStyle(), _col.getRefFont2().getSize()));
        this.setAlternateRow(_col.getAlternateRow());
        this.setCellScript(_col.getCellScript());
        this.setText(_col.getText());
        this.setFormattedCells(_col.getFormattedCells());
        this.setFormattedCellsTable(_col.getFormattedCellsTable());
        if (_col.getDBTableName() != null) {
            this.setDBTableName(_col.getDBTableName());
        }
        this.setDualColorOnRowBreak(_col.isDualColorOnRowBreak());
        this.setDualColorColInfoIndex(_col.getDualColorColInfoIndex());
        this.isBGColor2 = _col.isBGColor2;
        this.charLen = _col.charLen;
        this.noOfCol = _col.noOfCol;
    }

    public void applyTemplate(ReportColumn _col) {
        this.applyTemplate(_col, false);
    }

    public void applyTemplate(ReportColumn _col, boolean applyScript) {
        this.applyTemplate(_col, applyScript, true, true);
    }

    public void applyTemplate(ReportColumn _col, boolean applyScript, boolean applyElementPosition, boolean copyDrillDownName) {
        super.applyTemplate(_col, applyScript, applyElementPosition, copyDrillDownName);
        if (this.getDataFormat() != null && _col.getDataFormat() != null && FormatUtil.isFormatAppliabled(this.getDataFormat(), _col.getDataFormat())) {
            this.setDataFormat(_col.getDataFormat());
        }
        this.setVisible(_col.isVisible());
        this.setStyleName2(_col.getStyleName2());
        this.setBgColor2(_col.getBgColor2());
        this.setFontColor2(_col.getFontColor2());
        this.setUnderline2(_col.isUnderline2());
        this.setFont2(FontTable.newFont(_col.getRefFont2().getName(), _col.getRefFont2().getStyle(), _col.getRefFont2().getSize()));
        this.setAlternateRow(_col.getAlternateRow());
        this.setFormattedCells(_col.getFormattedCells());
        this.setFormattedCellsTable(_col.getFormattedCellsTable());
        if (_col.getDBTableName() != null) {
            this.setDBTableName(_col.getDBTableName());
        }
        this.setDualColorOnRowBreak(_col.isDualColorOnRowBreak());
        this.setDualColorColInfoIndex(_col.getDualColorColInfoIndex());
        this.isBGColor2 = _col.isBGColor2;
        this.charLen = _col.charLen;
    }

    public int getMaxCharForRecordFile() {
        return this.charLen;
    }

    public void setMaxCharForRecordFile(int cl) throws Exception {
        this.charLen = cl;
    }

    public void setDBTableName(String name) {
        this.dbTableName = name;
    }

    public String getDBTableName() {
        return this.dbTableName;
    }

    @Override
    public Vector<Color> getAllColors(Vector<Color> colors) {
        colors = super.getAllColors(colors);
        if (this.bgColor2 != null && !colors.contains(this.bgColor2)) {
            colors.add(this.bgColor2);
        }
        if (this.fontColor2 != null && !colors.contains(this.fontColor2)) {
            colors.add(this.fontColor2);
        }
        return colors;
    }

    public void setAlternateRow(int altRow) {
        this.altRow = altRow;
    }

    public int getAlternateRow() {
        return this.altRow;
    }

    public void setDualColorOnRowBreak(boolean state) {
        this.dualColorOnRowBreak = state;
    }

    public boolean isDualColorOnRowBreak() {
        return this.dualColorOnRowBreak;
    }

    public void setDualColorColInfoIndex(int[] colInfoIndex) {
        this.dualColorColInfoIndex = colInfoIndex;
    }

    public int[] getDualColorColInfoIndex() {
        return this.dualColorColInfoIndex;
    }

    public int getDualColorColInfoCount() {
        if (this.dualColorColInfoIndex == null) {
            return 0;
        }
        return this.dualColorColInfoIndex.length;
    }

    public void setIsBGColor2(int index, boolean bool) {
        if (this.data == null) {
            return;
        }
        if (this.isBGColor2 == null) {
            this.isBGColor2 = new boolean[this.data.size()];
        }
        if (index >= this.isBGColor2.length) {
            boolean[] tmp = new boolean[this.data.size()];
            for (int i = 0; i < this.isBGColor2.length; ++i) {
                tmp[i] = this.isBGColor2[i];
            }
            this.isBGColor2 = tmp;
        }
        this.isBGColor2[index] = bool;
    }

    public boolean getIsBGColor2(int index) {
        if (this.isBGColor2 != null) {
            return this.isBGColor2[index];
        }
        return false;
    }

    public String getStyleName2() {
        return this.styleName2 == null ? "" : this.styleName2;
    }

    public void setStyleName2(String newStyleName2) {
        this.styleName2 = newStyleName2;
    }

    public Color getBgColor2() {
        return this.bgColor2;
    }

    public void setBgColor2(Color newColorBg) {
        this.bgColor2 = newColorBg;
    }

    public Color getFontColor2() {
        return this.fontColor2;
    }

    public void setFontColor2(Color newColorFt) {
        this.fontColor2 = newColorFt;
    }

    public boolean isUnderline2() {
        return this.underline2;
    }

    public void setUnderline2(boolean underline) {
        this.underline2 = underline;
    }

    public Font getFont2() {
        return FontTable.clone(this.font2);
    }

    public Font getRefFont2() {
        return this.font2;
    }

    public void setFont2(Font newFont) {
        this.font2 = newFont;
    }

    public IFormat getDataFormat() {
        return this.format;
    }

    public void setDataFormat(IFormat format) {
        this.format = format;
    }

    public ICellScript getCellScript() {
        return this.cellScript;
    }

    public void setCellScript(ICellScript script) {
        this.cellScript = script;
    }

    public Vector<FormattedCell> getFormattedCells() {
        return this.formattedCells;
    }

    public void setFormattedCells(Vector<FormattedCell> formattedCells) {
        this.formattedCells = formattedCells;
    }

    public int getFormattedCellsCount() {
        if (this.formattedCells == null) {
            return 0;
        }
        return this.formattedCells.size();
    }

    public Hashtable<FormattedRowKey, FormattedCell> getFormattedCellsTable() {
        return this.formattedCellsTable;
    }

    public void setFormattedCellsTable(Hashtable<FormattedRowKey, FormattedCell> table) {
        this.formattedCellsTable = table;
    }

    public int getFormattedCellsTableCount() {
        if (this.formattedCellsTable != null) {
            return this.formattedCellsTable.size();
        }
        return 0;
    }

    private void addFormattedCellToHashTable(FormattedRowKey key, FormattedCell cell) {
        if (this.formattedCellsTable == null) {
            this.formattedCellsTable = new Hashtable();
        }
        this.formattedCellsTable.put(key, cell);
    }

    public Object getFormattedData(int index) {
        if (this.formattedCells == null) {
            return null;
        }
        return this.formattedCells.elementAt(index);
    }

    public FormattedCell getFormattedCell(int index) {
        if (this.formattedCells == null) {
            return null;
        }
        return this.formattedCells.elementAt(index);
    }

    public FormattedCell getFormattedCellAtRow(int row) {
        if (this.formattedCells == null) {
            return null;
        }
        for (int i = 0; i < this.formattedCells.size(); ++i) {
            if (row != this.getFormattedCell(i).getRowIndex()) continue;
            return this.getFormattedCell(i);
        }
        return null;
    }

    public void addFormattedCell(FormattedCell formattedCell) {
        this.setFormattedCell(formattedCell);
    }

    public void setFormattedCell(FormattedCell newCell) {
        int rowIndex = newCell.getRowIndex();
        if (this.formattedCells == null) {
            this.formattedCells = new Vector();
            this.formattedCells.addElement(newCell);
        } else {
            boolean cellFound = false;
            for (int i = 0; i < this.formattedCells.size() && !cellFound; ++i) {
                if (rowIndex != this.getFormattedCell(i).getRowIndex()) continue;
                this.formattedCells.setElementAt(newCell, i);
                cellFound = true;
            }
            if (!cellFound) {
                this.formattedCells.addElement(newCell);
            }
        }
    }

    public void addFormattedCell(int row, Vector<Integer> tree, FormattedCell formattedCell) {
        int[] intArray = QbUtil.convertVectorToIntArray(tree);
        FormattedRowKey key = new FormattedRowKey(row, intArray);
        this.addFormattedCell(key, formattedCell);
    }

    public void addFormattedCell(int row, int[] tree, FormattedCell formattedCell) {
        FormattedRowKey key = new FormattedRowKey(row, tree);
        this.addFormattedCell(key, formattedCell);
    }

    public void addFormattedCell(FormattedRowKey key, FormattedCell formattedCell) {
        if (this.formattedCellsTable == null) {
            this.formattedCellsTable = new Hashtable();
        }
        this.formattedCellsTable.put(key, formattedCell);
    }

    public void removeFormattedCell(int row, Vector<Integer> tree, FormattedCell formattedCell) {
        int[] intArray = QbUtil.convertVectorToIntArray(tree);
        this.formattedCells.removeElement(formattedCell);
        if (this.formattedCellsTable != null) {
            this.formattedCellsTable.remove(new FormattedRowKey(row, intArray));
        }
    }

    public int getFormattedCellsTableSize() {
        if (this.formattedCellsTable == null) {
            return 0;
        }
        return this.formattedCellsTable.size();
    }

    public boolean hasFormattedCell(int row, Vector<Integer> tree) {
        if (this.formattedCellsTable == null) {
            return false;
        }
        int[] intArray = QbUtil.convertVectorToIntArray(tree);
        FormattedRowKey key = new FormattedRowKey(row, intArray);
        return this.formattedCellsTable.containsKey(key);
    }

    public boolean hasFormattedCell(int row, Vector<Integer> tree, FormattedCell cell) {
        if (this.formattedCellsTable == null) {
            return false;
        }
        int[] intArray = QbUtil.convertVectorToIntArray(tree);
        FormattedRowKey key = new FormattedRowKey(row, intArray);
        return this.formattedCellsTable.containsKey(key) && cell == this.formattedCellsTable.get(key);
    }

    public boolean isDataEmpty() {
        return this.data == null;
    }

    public int getDataCount() {
        if (this.data == null) {
            return 0;
        }
        return this.data.size();
    }

    public long getDataSize() {
        if (this.data == null) {
            return 0L;
        }
        return this.data.getMemSizeUsed();
    }

    public IDataSet getDataSet() {
        return this.data;
    }

    public Object[] getData() {
        return this.data == null ? null : QbUtil.toArray(this.data);
    }

    public Object getData(int index) {
        if (this.data == null || this.data.size() <= index) {
            return null;
        }
        return this.data.elementAt(index);
    }

    public String getFormatData(int index) throws Exception {
        return FormatUtil.formatLabel(this.getData(index), this.format);
    }

    public String getFormatData(int index, IFormat format) throws Exception {
        return FormatUtil.formatLabel(this.getData(index), format);
    }

    public ReportElement getFormatCell(int index) throws Exception {
        return this.getFormatCell(index, index, 0, false);
    }

    public ReportElement getFormatCell(int dataindex, int displayindex) throws Exception {
        return this.getFormatCell(dataindex, displayindex, 0, false);
    }

    public ReportElement getFormatCell(int dataindex, int displayindex, int tableNumber) throws Exception {
        return this.getFormatCell(dataindex, displayindex, tableNumber, false);
    }

    public ReportElement getFormatCell(int dataindex, int displayindex, int tableNumber, boolean designMode) throws Exception {
        Object data;
        if (this.getData(dataindex) instanceof ReportImage) {
            ReportImage img = new ReportImage();
            img.copy((ReportImage)this.getData(dataindex));
            img.copy(this);
            int altRow = this.getAlternateRow();
            if (altRow > 0 && displayindex / altRow % 2 != 0) {
                img.setBgColor(this.getBgColor2());
            }
            if (this.dualColorOnRowBreak && tableNumber % 2 != 0) {
                img.setBgColor(this.getBgColor2());
            }
            return img;
        }
        if (this.getData(dataindex) instanceof ReportDocument) {
            ReportCell doc = (ReportCell)this.getData(dataindex);
            doc.copy(this);
            ((ReportDocument)doc).setText();
            if (this.cellScript != null) {
                doc = this.cellScript.formatCell(dataindex, doc, doc.getText(), this.format);
            }
            return doc;
        }
        if (this.format instanceof ImageURLFormat && this.getScript() == null) {
            URL url;
            ReportImage img;
            block23: {
                img = new ReportImage();
                img.copy(this);
                img.setDataFormat(this.format);
                url = null;
                Object data2 = this.getData(dataindex);
                if (data2 != null) {
                    String path = this.getData(dataindex).toString();
                    try {
                        url = new URL(path);
                    }
                    catch (MalformedURLException e) {
                        if (!ServerMessage.isWebApp) break block23;
                        try {
                            url = new URL(ServerMessage.getServerInfo() + ServerMessage.getContext() + path);
                        }
                        catch (MalformedURLException malformedURLException) {
                            // empty catch block
                        }
                    }
                }
            }
            if (url != null) {
                img.setImageURL(url, false);
                return img;
            }
        }
        if (this.format instanceof TextURLFormat && this.getScript() == null && (data = this.getData(dataindex)) != null) {
            ReportDocument doc = new ReportDocument();
            doc.copy(this);
            try {
                doc.setDataFormat(this.format);
                doc.setRelativePath(this.getData(dataindex).toString());
                doc.setText();
                return doc;
            }
            catch (Exception data2) {
                // empty catch block
            }
        }
        ReportCell cell = null;
        if (this.formattedCells != null && !designMode) {
            boolean cellFound = false;
            for (int i = 0; i < this.formattedCells.size() && !cellFound; ++i) {
                if (displayindex != this.getFormattedCell(i).getRowIndex()) continue;
                cell = this.getFormattedCell(i);
                cellFound = true;
            }
        }
        if (cell == null) {
            cell = new ReportCell(this, dataindex, displayindex, tableNumber);
        }
        if (cell instanceof FormattedCell) {
            if (!((FormattedCell)cell).getVisible()) {
                cell.setText("");
            } else {
                cell.setText(this.getFormatData(dataindex, cell.getDataFormat()));
            }
        } else {
            cell.setText(this.getFormatData(dataindex));
        }
        if (this.cellScript != null) {
            cell = this.cellScript.formatCell(dataindex, cell, this.getData(dataindex), this.format);
        }
        return cell;
    }

    public void resetData() {
        this.data = null;
        this.actualdata = null;
        this.scriptedData = null;
    }

    public void setDataSet(IDataSet dataSet) {
        this.data = (IDataSet)dataSet.clone();
    }

    public void addData(Object obj) {
        if (this.data == null) {
            if (this.dataSetTree == null) {
                Properties treeProp = new Properties();
                this.data = new DataSet("D_" + this.getAddress(), this.charLen, this.noOfCol, this.isTreeReport, treeProp);
            } else {
                this.data = new DataSet(0, this.dataSetTree);
            }
        }
        this.data.addElement(obj);
    }

    public void replaceData(Object obj, int index) {
        if (this.data == null) {
            return;
        }
        this.data.setElementAt(obj, index);
    }

    public void removeAllData() {
        if (this.data == null) {
            return;
        }
        this.data.removeAllElements();
        if (this.scriptedData == null) {
            return;
        }
        this.scriptedData.removeAllElements();
    }

    public void setData(int row, Object newData) {
        this.data.setElementAt(newData, row);
    }

    public void addActualData(Object newData) {
        if (this.actualdata == null) {
            if (this.dataSetTree == null) {
                Properties treeProp = new Properties();
                this.actualdata = new DataSet("AD_" + this.getAddress(), this.charLen, this.noOfCol, this.isTreeReport, treeProp);
            } else {
                this.actualdata = new DataSet(1, this.dataSetTree);
            }
        }
        this.actualdata.addElement(newData);
    }

    public boolean isValid() {
        if (this.data != null) {
            return this.data.isValid();
        }
        if (this.actualdata != null) {
            return this.actualdata.isValid();
        }
        return true;
    }

    public void cleanup() {
        try {
            this.finalize();
        }
        catch (Throwable ex) {
            throw new IllegalArgumentException(IOUtil.getStackTrace(ex));
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (!this.doNotFinalizeDataSet) {
                if (this.data != null) {
                    this.data.cleanup();
                }
                if (this.actualdata != null) {
                    this.actualdata.cleanup();
                }
                if (this.scriptedData != null) {
                    this.scriptedData.cleanup();
                }
            }
        }
        finally {
            super.finalize();
        }
    }

    public void releaseDiskBuffer() {
        if (this.data != null) {
            this.data.releaseDiskBuffer();
        }
        if (this.actualdata != null) {
            this.actualdata.releaseDiskBuffer();
        }
        if (this.scriptedData != null) {
            this.scriptedData.releaseDiskBuffer();
        }
        if (this.dataSetTree != null) {
            this.dataSetTree.releaseDiskBuffer();
        }
    }

    public Object getActualData(int i) {
        if ((this.actualdata == null || this.actualdata.size() == 0) && this.data != null) {
            return this.data.elementAt(i);
        }
        if (this.actualdata != null && this.actualdata.size() > 0) {
            return this.actualdata.elementAt(i);
        }
        return null;
    }

    public void addScriptedData(Object newData) {
        if (this.scriptedData == null) {
            if (this.dataSetTree == null) {
                Properties treeProp = new Properties();
                this.scriptedData = new DataSet("SD_" + this.getAddress(), this.charLen, this.noOfCol, this.isTreeReport, treeProp);
            } else {
                this.scriptedData = new DataSet(2, this.dataSetTree);
            }
        }
        this.scriptedData.addElement(newData);
    }

    public void insertScriptedDataAt(Object newData, int index) {
        if (this.scriptedData == null) {
            if (this.dataSetTree == null) {
                Properties treeProp = new Properties();
                this.scriptedData = new DataSet("SD_" + this.getAddress(), this.charLen, this.noOfCol, this.isTreeReport, treeProp);
            } else {
                this.scriptedData = new DataSet(2, this.dataSetTree);
            }
        }
        if (index >= this.scriptedData.size()) {
            for (int i = this.scriptedData.size(); i <= index; ++i) {
                this.scriptedData.addElement(null);
            }
            this.scriptedData.setElementAt(newData, index);
        }
    }

    public boolean hasScriptedData(int i) {
        if (this.scriptedData == null) {
            return false;
        }
        if (this.scriptedData.size() <= i) {
            return false;
        }
        return this.scriptedData.elementAt(i) != null;
    }

    public Object getScriptedData(int i) {
        if (this.scriptedData == null || i >= this.scriptedData.size() || this.scriptedData.elementAt(i) == null) {
            return this.getData(i);
        }
        return this.scriptedData.elementAt(i);
    }

    public int getScriptedDataCount() {
        if (this.scriptedData == null) {
            return -1;
        }
        return this.scriptedData.size();
    }

    public int getActualDataCount() {
        if (this.actualdata == null) {
            return -1;
        }
        return this.actualdata.size();
    }

    public DataSet getScriptedData(ReportTable table, Report report, int col) {
        Properties treeProp = new Properties();
        DataSet scriptedObject = new DataSet("ASD_" + this.getAddress(), this.charLen, this.noOfCol, this.isTreeReport, treeProp);
        if (this.data == null) {
            return scriptedObject;
        }
        int ct = this.getActualDataCount();
        if (ct == -1) {
            ct = this.data.size();
        }
        for (int i = 0; i < ct; ++i) {
            scriptedObject.addElement(this.getScriptedData(table, report, col, i));
        }
        return scriptedObject;
    }

    public Object getScriptedData(ReportTable table, Report report, int col, int row) {
        if (this.getScriptObj() != null) {
            Object scriptedObject = null;
            Object object = this.getActualData(row);
            try {
                int sqlType = report.getSQLType(report.getColInfoIndex(col));
                IFormat format = FormatUtil.createFormat(DataType.mapType(sqlType));
                ReportCell cell = new ReportCell();
                cell.setScriptedValue(object);
                this.getScriptObj().applyScript(table, row, 1, 1, 1, 1, report, cell, object, format);
                scriptedObject = cell.getScriptedValue();
                if (scriptedObject != null && scriptedObject.equals("Q#B#S#V#S#T#N")) {
                    return null;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return scriptedObject;
        }
        return this.getActualData(row);
    }

    public void setDrillDownData(Object data) {
        this.drillDownData = data;
    }

    public Object getDrillDownData(int row) {
        if (this.drillDownData != null) {
            return this.drillDownData;
        }
        return this.getData(row);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        FormatUtil.writeDataFormat(out, this.format);
        IOUtil.writeStr(out, this.getStyleName2());
        IOUtil.writeColor(out, this.bgColor2);
        IOUtil.writeColor(out, this.fontColor2);
        out.writeBoolean(this.underline2);
        IOUtil.writeFont(out, this.font2);
        out.writeInt(this.altRow);
        out.writeBoolean(this.dualColorOnRowBreak);
        if (this.dualColorColInfoIndex == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.dualColorColInfoIndex.length);
            for (int element : this.dualColorColInfoIndex) {
                out.writeInt(element);
            }
        }
        int ct = this.getFormattedCellsCount();
        out.writeInt(ct);
        for (int i = 0; i < ct; ++i) {
            this.getFormattedCell(i).write(out);
        }
        int count = this.getFormattedCellsTableCount();
        out.writeInt(count);
        if (this.formattedCellsTable != null) {
            Enumeration<FormattedRowKey> e = this.formattedCellsTable.keys();
            while (e.hasMoreElements()) {
                FormattedRowKey key = e.nextElement();
                FormattedCell cell = this.formattedCellsTable.get(key);
                if (cell == null) continue;
                key.write(out);
                cell.write(out);
            }
        }
        super.write(out);
    }

    @Override
    public void writeXML(Writer out, boolean writeElementTag) throws IOException {
        if (writeElementTag) {
            out.write("<REPORTCOLUMN>\n");
        }
        FormatUtil.writeXMLDataFormat(out, this.format);
        if (this.styleName2 != null) {
            out.write("<REPORTCOLUMN_STYLENAME2>" + XMLUtil.encodeCDATA(this.getStyleName2()) + "</REPORTCOLUMN_STYLENAME2>\n");
        }
        if (this.bgColor2 != null) {
            out.write("<REPORTCOLUMN_BGCOLOR2>" + this.bgColor2.getRGB() + "</REPORTCOLUMN_BGCOLOR2>\n");
        }
        if (this.fontColor2 != null) {
            out.write("<REPORTCOLUMN_FONTCOLOR2>" + this.fontColor2.getRGB() + "</REPORTCOLUMN_FONTCOLOR2>\n");
        }
        if (this.styleName2 != null) {
            out.write("<REPORTCOLUMN_UNDERLINE2>" + this.underline2 + "</REPORTCOLUMN_UNDERLINE2>\n");
        }
        out.write("<REPORTCOLUMN_FONTNAME2>" + XMLUtil.encodeCDATA(this.font2.getName()) + "</REPORTCOLUMN_FONTNAME2>\n");
        out.write("<REPORTCOLUMN_FONTSTYLE2>" + this.font2.getStyle() + "</REPORTCOLUMN_FONTSTYLE2>\n");
        out.write("<REPORTCOLUMN_FONTSIZE2>" + this.font2.getSize() + "</REPORTCOLUMN_FONTSIZE2>\n");
        out.write("<REPORTCOLUMN_ALTERNATEROW>" + this.altRow + "</REPORTCOLUMN_ALTERNATEROW>\n");
        out.write("<REPORTCOLUMN_DUALCOLORONROWBREAK>" + this.dualColorOnRowBreak + "</REPORTCOLUMN_DUALCOLORONROWBREAK>\n");
        out.write("<REPORTCOLUMN_DUALCOLORCOLINFOCOUNT>" + this.getDualColorColInfoCount() + "</REPORTCOLUMN_DUALCOLORCOLINFOCOUNT>\n");
        if (this.dualColorColInfoIndex != null) {
            for (int element : this.dualColorColInfoIndex) {
                out.write("<REPORTCOLUMN_DUALCOLORCOLINFOINDEX>" + element + "</REPORTCOLUMN_DUALCOLORCOLINFOINDEX>\n");
            }
        }
        int count = this.getFormattedCellsCount();
        out.write("<REPORTCOLUMN_FORMATTEDCELLSCOUNT>" + count + "</REPORTCOLUMN_FORMATTEDCELLSCOUNT>\n");
        if (count > 0) {
            for (int i = 0; i < count; ++i) {
                this.getFormattedCell(i).writeXML(out, true);
            }
        }
        count = this.getFormattedCellsTableCount();
        out.write("<REPORTCOLUMN_FORMATTEDCELLSTABLECOUNT>" + count + "</REPORTCOLUMN_FORMATTEDCELLSTABLECOUNT>\n");
        if (count > 0) {
            Enumeration<FormattedRowKey> e = this.formattedCellsTable.keys();
            while (e.hasMoreElements()) {
                FormattedRowKey key = e.nextElement();
                FormattedCell cell = this.formattedCellsTable.get(key);
                if (cell == null) continue;
                out.write("<REPORTCOLUMN_FORMATTEDCELLSTABLEENTRY>");
                key.writeXML(out, true);
                cell.writeXML(out, true);
                out.write("</REPORTCOLUMN_FORMATTEDCELLSTABLEENTRY>\n");
            }
        }
        super.writeXML(out, false);
        if (writeElementTag) {
            out.write("</REPORTCOLUMN>\n");
        }
    }

    public static ReportColumn createColumn(Node node, int version) throws Exception {
        if (node.getNodeName().equalsIgnoreCase("COLUMNBREAKCOLUMN")) {
            return ColumnBreakColumn.createColumnBreakColumn(node, version);
        }
        if (node.getNodeName().equalsIgnoreCase("CBAGGRCOLUMN")) {
            return CBAggrColumn.createCBAggrColumn(node, version);
        }
        if (!node.getNodeName().equalsIgnoreCase(XMLTAG)) {
            throw new Exception("'REPORTCOLUMN' element expected, but found '" + node.getNodeName() + "' element.");
        }
        ReportColumn col = new ReportColumn();
        col.readXML(node, version);
        return col;
    }

    @Override
    public void readXML(Node node, int version) throws Exception {
        boolean check2 = false;
        int count = 0;
        String fontname = null;
        int fontstyle = -1;
        int fontsize = -1;
        this.setBgColor(null);
        String stylename2 = "";
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node child = nodeList.item(i);
            if (child.getNodeName().equalsIgnoreCase("REPORTCOLUMN_VISIBLE")) {
                if (version >= 138) continue;
                this.setVisible(LoadXMLReportHelper.parseBoolean(LoadXMLReportHelper.readText(child)));
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTCOLUMN_STYLENAME2")) {
                stylename2 = LoadXMLReportHelper.readCDATA(child);
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTCOLUMN_BGCOLOR2")) {
                this.setBgColor2(new Color(Integer.parseInt(LoadXMLReportHelper.readText(child))));
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTCOLUMN_FONTCOLOR2")) {
                this.setFontColor2(new Color(Integer.parseInt(LoadXMLReportHelper.readText(child))));
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTCOLUMN_UNDERLINE2")) {
                this.setUnderline2(LoadXMLReportHelper.parseBoolean(LoadXMLReportHelper.readText(child)));
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTCOLUMN_FONTNAME2")) {
                fontname = LoadXMLReportHelper.readCDATA(child);
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTCOLUMN_FONTSTYLE2")) {
                fontstyle = Integer.parseInt(LoadXMLReportHelper.readText(child));
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTCOLUMN_FONTSIZE2")) {
                fontsize = Integer.parseInt(LoadXMLReportHelper.readText(child));
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTCOLUMN_ALTERNATEROW")) {
                this.setAlternateRow(Integer.parseInt(LoadXMLReportHelper.readText(child)));
                check2 = true;
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTCOLUMN_DUALCOLORONROWBREAK")) {
                this.setDualColorOnRowBreak(LoadXMLReportHelper.parseBoolean(LoadXMLReportHelper.readText(child)));
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTCOLUMN_DUALCOLORCOLINFOCOUNT")) {
                this.dualColorColInfoIndex = new int[Integer.parseInt(LoadXMLReportHelper.readText(child))];
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTCOLUMN_DUALCOLORCOLINFOINDEX")) {
                this.dualColorColInfoIndex[count++] = Integer.parseInt(LoadXMLReportHelper.readText(child));
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTCOLUMN_FORMATTEDCELLSCOUNT")) {
                count = Integer.parseInt(LoadXMLReportHelper.readText(child));
                if (count <= 0 || this.formattedCells != null) continue;
                this.formattedCells = new Vector();
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("FORMATTEDCELL")) {
                FormattedCell cell = FormattedCell.createFormattedCell(child, version);
                this.formattedCells.addElement(cell);
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTCOLUMN_FORMATTEDCELLSTABLECOUNT")) {
                count = Integer.parseInt(LoadXMLReportHelper.readText(child));
                if (count <= 0 || this.formattedCellsTable != null) continue;
                this.formattedCellsTable = new Hashtable();
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTCOLUMN_FORMATTEDCELLSTABLEENTRY")) {
                NodeList entryList = child.getChildNodes();
                FormattedRowKey key = null;
                FormattedCell cell = null;
                for (int j = 0; j < entryList.getLength(); ++j) {
                    Node entry = entryList.item(j);
                    if (entry.getNodeName().equalsIgnoreCase("FORMATTEDROWKEY")) {
                        key = FormattedRowKey.createFormattedRowKey(entry, version);
                        continue;
                    }
                    if (!entry.getNodeName().equalsIgnoreCase("FORMATTEDCELL")) continue;
                    cell = FormattedCell.createFormattedCell(entry, version);
                }
                if (this.formattedCellsTable == null) {
                    this.formattedCellsTable = new Hashtable();
                }
                if (key == null || cell == null) continue;
                this.addFormattedCellToHashTable(key, cell);
                continue;
            }
            if (this.getDataFormat() != null) continue;
            this.setDataFormat(FormatUtil.readXMLDataFormat(child, version));
        }
        if (!check2 || fontname == null || fontstyle == -1 || fontsize == -1) {
            throw new Exception("Missing 'REPORTCOLUMN' attributes.");
        }
        this.setFont2(FontTable.newFont(fontname, fontstyle, fontsize));
        this.setStyleName2(stylename2);
        super.readXML(node, version);
    }

    public static ReportColumn createColumn(DataInput in, int version) throws Exception {
        ReportColumn col = new ReportColumn();
        col.read(in, version);
        return col;
    }

    @Override
    public void read(DataInput in, int version) throws Exception {
        int count;
        int i;
        int size;
        this.setDataFormat(FormatUtil.readDataFormat(in, version));
        if (version < 138) {
            this.setVisible(in.readBoolean());
        }
        if (version >= 169) {
            this.setStyleName2(IOUtil.readStr(in));
        }
        this.setBgColor2(IOUtil.readColor(in));
        this.setFontColor2(IOUtil.readColor(in));
        if (version >= 178) {
            this.setUnderline2(in.readBoolean());
        }
        this.setFont2(IOUtil.readFont(in));
        this.setAlternateRow(in.readInt());
        if (version >= 73) {
            this.setDualColorOnRowBreak(in.readBoolean());
        }
        if (version >= 105 && (size = in.readInt()) > 0) {
            this.dualColorColInfoIndex = new int[size];
            for (i = 0; i < size; ++i) {
                this.dualColorColInfoIndex[i] = in.readInt();
            }
        }
        if (version >= 36) {
            count = in.readInt();
            for (i = 0; i < count; ++i) {
                FormattedCell.createFormattedCell(in, version);
            }
        }
        if (version >= 38) {
            count = in.readInt();
            for (i = 0; i < count; ++i) {
                FormattedRowKey.createFormattedRowKey(in, version);
                FormattedCell.createFormattedCell(in, version);
            }
        }
        super.read(in, version);
    }

    public void setStringFormat(int code) {
        if (this.format instanceof StringFormat) {
            if (code == 7) {
                this.setDataFormat(new ImageURLFormat());
            } else if (code == 8) {
                this.setDataFormat(new TextURLFormat());
            }
        }
    }

    public int[] sort(boolean isAsc) {
        int len = this.getDataCount();
        if (len == 0) {
            return null;
        }
        int[] indexArray = null;
        ICompareObject[] objects = new ICompareObject[len];
        for (int i = 0; i < len; ++i) {
            Object data = this.getData(i);
            objects[i] = data instanceof Boolean ? new BooleanCompare((Boolean)this.getData(i), i) : (data instanceof Number ? new NumberCompare((Number)this.getData(i), i) : (data instanceof String ? new StringCompare((String)this.getData(i), i) : (data instanceof Date ? new DateCompare((Date)this.getData(i), i) : new StringCompare(null, i))));
        }
        indexArray = SortObject.sortIndex(objects, isAsc);
        return indexArray;
    }

    public int[] sort(boolean isAsc, int[] indexArray) {
        if (indexArray == null || indexArray.length == 0) {
            return null;
        }
        if (this.getDataCount() == 0) {
            return null;
        }
        ICompareObject[] objects = new ICompareObject[indexArray.length];
        for (int i = 0; i < indexArray.length; ++i) {
            Object data = this.getData(indexArray[i]);
            objects[i] = data instanceof Boolean ? new BooleanCompare((Boolean)this.getData(indexArray[i]), indexArray[i]) : (data instanceof Number ? new NumberCompare((Number)this.getData(indexArray[i]), indexArray[i]) : (data instanceof String ? new StringCompare((String)this.getData(indexArray[i]), indexArray[i]) : (data instanceof Date ? new DateCompare((Date)this.getData(indexArray[i]), indexArray[i]) : new StringCompare(null, indexArray[i]))));
        }
        return SortObject.sortIndex(objects, isAsc);
    }

    public int[] sortActualdata(boolean isAsc) {
        int i;
        if (this.actualdata == null) {
            return this.sort(isAsc);
        }
        int len = this.actualdata.size();
        ICompareObject[] objects = new ICompareObject[len];
        if (this.actualdata.elementAt(0) instanceof Boolean) {
            for (i = 0; i < len; ++i) {
                objects[i] = new BooleanCompare((Boolean)this.actualdata.elementAt(i), i);
            }
        } else if (this.actualdata.elementAt(0) instanceof Number) {
            for (i = 0; i < len; ++i) {
                objects[i] = new NumberCompare((Number)this.actualdata.elementAt(i), i);
            }
        } else if (this.actualdata.elementAt(0) instanceof String) {
            for (i = 0; i < len; ++i) {
                objects[i] = new StringCompare((String)this.actualdata.elementAt(i), i);
            }
        } else if (this.actualdata.elementAt(0) instanceof Date) {
            for (i = 0; i < len; ++i) {
                objects[i] = new DateCompare((Date)this.actualdata.elementAt(i), i);
            }
        }
        int[] indexArray = SortObject.sortIndex(objects, isAsc);
        return indexArray;
    }

    @Override
    public boolean scriptReferenced(Script script) {
        return this.isVisible() && script.getName().equals(this.getScriptName());
    }

    public void setTopNData(int[] sortedIndex, boolean isRowBreak, short aggr) {
        if (sortedIndex == null || this.data == null) {
            this.data = null;
            return;
        }
        DataSet topNData = new DataSet("TOPN_" + this.getAddress(), this.charLen, this.noOfCol, this.isTreeReport, null);
        if (isRowBreak) {
            for (int i = 0; i < sortedIndex.length && i < this.data.size(); ++i) {
                topNData.addElement(this.data.elementAt(i));
            }
        } else if (aggr == 0) {
            for (int element : sortedIndex) {
                topNData.addElement(this.data.elementAt(element));
            }
        } else {
            for (int element : sortedIndex) {
                topNData.addElement(this.actualdata.elementAt(element));
            }
        }
        this.actualdata = topNData;
        if (aggr == 0) {
            this.data = topNData;
        } else {
            this.data = new DataSet("TOPNA_" + this.getAddress(), this.charLen, this.noOfCol, this.isTreeReport, null);
            this.data.addElement(Aggregation.getComputedValue(aggr, QbUtil.toArray(topNData)));
        }
    }

    public void recalculateFormulaColumnValue(Report report, int i, ReportTable table) {
        DataSet newdata = null;
        newdata = new DataSet("RCD_" + this.getAddress(), this.charLen, this.noOfCol, this.isTreeReport, null);
        try {
            int ct = this.getDataCount();
            for (int j = 0; j < ct; ++j) {
                newdata.addElement(report.colInfo[i].getFormulaObj().getValue(table, j, 1, 1, 1, 1, report, null, null, true));
            }
            this.data = newdata;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void applyStyle(ReportColumn _col) {
        super.applyStyle(_col);
        this.setBgColor2(_col.getBgColor2());
        this.setFontColor2(_col.getFontColor2());
        this.setFont2(FontTable.newFont(_col.getRefFont2().getName(), _col.getRefFont2().getStyle(), _col.getRefFont2().getSize()));
        this.setStyleName2(_col.getStyleName2());
        this.setUnderline2(_col.isUnderline2());
        this.setAlternateRow(_col.getAlternateRow());
        this.setDualColorOnRowBreak(_col.isDualColorOnRowBreak());
        this.setDualColorColInfoIndex(_col.getDualColorColInfoIndex());
        if (FormatUtil.isFormatAppliabled(this.getDataFormat(), _col.getDataFormat())) {
            this.setDataFormat(_col.getDataFormat());
        }
    }
}

