/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.ReportElements;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.IReportDocument;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportColumn;
import quadbase.reportdesigner.report.LoadXMLReportHelper;
import quadbase.reportdesigner.report.ReadDataFile;

public class ReportDocument
extends ReportCell
implements IReportDocument,
Serializable {
    private String textString = null;
    private String relativePath = null;
    public static final String XMLTAG = "REPORTDOCUMENT";

    public ReportDocument() {
    }

    public ReportDocument(String name) {
        super(name);
    }

    public ReportDocument(ReportColumn _col, int index) {
        super(_col, index);
    }

    @Override
    public void setTextString(String text) {
        this.textString = text;
    }

    @Override
    public String getTextString() {
        return this.textString;
    }

    @Override
    public void setRelativePath(String rpath) {
        this.relativePath = rpath;
    }

    @Override
    public String getRelativePath() {
        return this.relativePath;
    }

    @Override
    public void setText() {
        if (this.textString != null) {
            this.setText(this.textString);
        } else {
            try {
                ReadDataFile rdf = new ReadDataFile();
                DataInputStream input = rdf.getInputStream(null, this.relativePath);
                String line = input.readLine();
                String data = "";
                while (line != null) {
                    data = data + line;
                    line = input.readLine();
                }
                input.close();
                this.setText(data);
            }
            catch (Exception e) {
                this.setText("");
            }
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        IOUtil.writeStr(out, this.textString);
        IOUtil.writeStr(out, this.relativePath);
    }

    @Override
    public void writeXML(Writer out, boolean writeElementTag) throws IOException {
        if (writeElementTag) {
            out.write("<REPORTDOCUMENT>\n");
        }
        super.writeXML(out, false);
        out.write("<REPORTDOCUMENT_TEXTSTRING>" + this.textString + "</REPORTDOCUMENT_TEXTSTRING>\n");
        out.write("<REPORTDOCUMENT_RELATIVEPATH>" + this.relativePath + "</REPORTDOCUMENT_RELATIVEPATH>\n");
        if (writeElementTag) {
            out.write("</REPORTDOCUMENT>\n");
        }
    }

    public static ReportDocument createDocument(DataInput in, int version) throws Exception {
        ReportDocument cell = new ReportDocument();
        cell.read(in, version);
        return cell;
    }

    @Override
    public void read(DataInput in, int version) throws Exception {
        super.read(in, version);
        this.textString = IOUtil.readStr(in);
        this.relativePath = IOUtil.readStr(in);
    }

    public static ReportDocument createDocument(Node node, int version) throws Exception {
        if (!node.getNodeName().equalsIgnoreCase(XMLTAG)) {
            throw new Exception("'REPORTDOCUMENT' element expected, but found '" + node.getNodeName() + "' element.");
        }
        ReportDocument cell = new ReportDocument();
        cell.readXML(node, version);
        return cell;
    }

    @Override
    public void readXML(Node node, int version) throws Exception {
        super.readXML(node, version);
        boolean check2 = false;
        boolean check1 = false;
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node child = nodeList.item(i);
            if (child.getNodeName().equalsIgnoreCase("REPORTDOCUMENT_TEXTSTRING")) {
                this.textString = LoadXMLReportHelper.readText(child);
                check1 = true;
                continue;
            }
            if (!child.getNodeName().equalsIgnoreCase("REPORTDOCUMENT_TEXTSTRING")) continue;
            this.relativePath = LoadXMLReportHelper.readText(child);
            check2 = true;
        }
        if (!check1 || !check2) {
            throw new Exception("Missing REPORTDOCUMENT attributes.");
        }
    }

    public String toString() {
        if (this.textString != null) {
            return this.textString;
        }
        return super.toString();
    }
}

