/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.ReportElements;

import java.awt.Color;
import java.awt.Font;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import quadbase.common.util.internal.FontTable;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbUtil;
import quadbase.common.util.internal.VersioningDataOutput;
import quadbase.common.util.internal.XMLUtil;
import quadbase.reportdesigner.ReportElements.BorderSide;
import quadbase.reportdesigner.ReportElements.CBAggrColFooter;
import quadbase.reportdesigner.ReportElements.CBAggrColHeader;
import quadbase.reportdesigner.ReportElements.CBAggrColumn;
import quadbase.reportdesigner.ReportElements.CBColumnFooter;
import quadbase.reportdesigner.ReportElements.CBColumnHeader;
import quadbase.reportdesigner.ReportElements.ColumnBreakColumn;
import quadbase.reportdesigner.ReportElements.ColumnHeader;
import quadbase.reportdesigner.ReportElements.ColumnWrap;
import quadbase.reportdesigner.ReportElements.GuideLine;
import quadbase.reportdesigner.ReportElements.RBColumnHeader;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportChartObject;
import quadbase.reportdesigner.ReportElements.ReportColumn;
import quadbase.reportdesigner.ReportElements.ReportGrid;
import quadbase.reportdesigner.ReportElements.ReportImage;
import quadbase.reportdesigner.ReportElements.ReportLine;
import quadbase.reportdesigner.ReportElements.ReportRTFObject;
import quadbase.reportdesigner.ReportElements.ReportSection;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.ReportElements.ReportTableElement;
import quadbase.reportdesigner.ReportElements.ReportTitle;
import quadbase.reportdesigner.ReportElements.SubReportObject;
import quadbase.reportdesigner.ReportElements.TableOfContents;
import quadbase.reportdesigner.report.LoadXMLReportHelper;
import quadbase.reportdesigner.report.NewScriptParser;
import quadbase.reportdesigner.report.Script;
import quadbase.reportdesigner.util.IFormat;

public abstract class ReportElement
implements Serializable {
    private static final String REPORTELEMENT_TOP_BORDER = "REPORTELEMENT_TOP_BORDER";
    private static final String REPORTELEMENT_RIGHT_BORDER = "REPORTELEMENT_RIGHT_BORDER";
    private static final String REPORTELEMENT_BOTTOM_BORDER = "REPORTELEMENT_BOTTOM_BORDER";
    private static final String REPORTELEMENT_LEFT_BORDER = "REPORTELEMENT_LEFT_BORDER";
    private String text = "";
    private String id = "";
    private String customid = "";
    private Font font = FontTable.newFont("Dialog", 0, QbUtil.getAdjustedFont(12, true));
    private boolean underline = false;
    private Font adjustFont = null;
    protected Color bgColor = null;
    private Color fontColor = Color.black;
    private short align = 0;
    private short valign = 1;
    private boolean noWrap = false;
    private double y = 0.0;
    protected double x = 0.0;
    protected double width = 1.0;
    protected double height = 0.3;
    protected double min_width = 0.0;
    protected double min_height = 0.0;
    protected double rotate_angle = 0.0;
    protected Color borderColor = Color.black;
    private String styleName = "";
    private String link = "";
    private String hint = "";
    private String target = "EspressReport";
    private String drillDownName = null;
    private String script;
    private String scriptName;
    private Script scriptObj;
    private boolean resizeToFitContent = false;
    protected boolean isLocked = false;
    protected short snap = 0;
    protected short vsnap = 0;
    private boolean snapToGrid = false;
    boolean metric = false;
    double inchGridSpace = 0.1;
    double cmGridSpace = 0.25;
    private String bookmark = null;
    private boolean drawAgain = false;
    private double drawX = 0.0;
    private double drawY = 0.0;
    private double[] arrayX;
    private double[] arrayY;
    private int z = 0;
    private int uniqueNumber = QbUtil.nextNumber();
    private String address = null;
    protected boolean visible = true;
    protected Hashtable<String, ReportElement> securityMap = null;
    private boolean securityTextScript = false;
    private boolean shiftSecuredColX = false;
    private boolean shiftSecuredColXIncludeHeaderAndFooter = false;
    protected int roundCornerRadius = 0;
    protected boolean[] roundCornersArray = new boolean[4];
    private int topBorder;
    private int rightBorder;
    private int bottomBorder;
    private int leftBorder;
    public static final int SORT_Y = 0;
    public static final int SORT_X = 1;
    public static final int SORT_Z = 2;
    public static final int CHART = 0;
    public static final int GRID = 1;
    public static final int LINE = 2;
    public static final int IMAGE = 3;
    public static final int COLUMN = 4;
    public static final int FORMULA = 5;
    public static final int LABEL = 6;
    public static final int SECTION = 7;
    public static final int TABLE = 8;
    public static final int SUBREPORT = 9;
    public static final int RTFOBJECT = 10;
    public static final int TABLEOFCONTENTS = 11;
    public static final int COLUMNHEADER = 12;
    public static final int TITLE = 13;
    public static final int NONE = -1;
    public static final String[] ID_TYPE = new String[]{"CHT", "RECT", "LINE", "IMG", "COL", "FORM", "LB", "SEC", "TBL", "SRPT", "RTF", "TOC"};
    public static final int ROTATE_NONE = 0;
    public static final int ROTATE_CLOCKWISE = 90;
    public static final int ROTATE_COUNTERCLOCKWISE = -90;

    public ReportElement() {
    }

    public ReportElement(String name) {
        this.setText(name);
    }

    public void copy(ReportElement _elt) {
        if (_elt == null) {
            return;
        }
        this.text = _elt.text;
        this.id = _elt.id;
        this.customid = _elt.customid;
        this.setScriptName(_elt.getScriptName());
        this.setScriptObj(_elt.getScriptObj());
        this.setScript(_elt.getScript());
        this.setSecurityTextScript(_elt.isSecurityTextScript());
        this.setRotateAngle(_elt.getRotateAngle(), false);
        this.setShiftSecuredColX(_elt.isShiftSecuredColX());
        this.shiftSecuredColXIncludeHeaderAndFooter = _elt.shiftSecuredColXIncludeHeaderAndFooter;
        this.setVisible(_elt.isVisible());
        this.securityMap = _elt.securityMap;
        this.applyTemplate(_elt);
        this.snapToGrid = _elt.snapToGrid;
        this.inchGridSpace = _elt.inchGridSpace;
        this.cmGridSpace = _elt.cmGridSpace;
        this.drawAgain = _elt.drawAgain;
        this.drawX = _elt.drawX;
        this.drawY = _elt.drawY;
        this.setZ(_elt.getZ());
        this.uniqueNumber = _elt.uniqueNumber;
        this.address = _elt.address;
        this.roundCornerRadius = _elt.roundCornerRadius;
        this.roundCornersArray = (boolean[])_elt.roundCornersArray.clone();
        this.setBorderThickness(_elt);
    }

    public void deepCopy(ReportElement _elt) {
        this.copy(_elt);
    }

    public void copyTemplate(ReportElement _elt) {
        this.copy(_elt);
    }

    public void applyTemplate(ReportElement _elt) {
        this.applyTemplate(_elt, false);
    }

    public void applyTemplate(ReportElement _elt, boolean applyScript) {
        this.applyTemplate(_elt, applyScript, true, true);
    }

    public void applyTemplate(ReportElement _elt, boolean applyScript, boolean applyElementPosition, boolean copyDrillDownName) {
        if (_elt == null) {
            return;
        }
        this.font = FontTable.newFont(_elt.font.getName(), _elt.font.getStyle(), _elt.font.getSize());
        this.adjustFont = null;
        if (!_elt.id.equals(_elt.customid)) {
            this.customid = _elt.customid;
        }
        this.setBgColor(_elt.bgColor);
        this.setFontColor(_elt.fontColor);
        this.setUnderline(_elt.isUnderline());
        this.setAlign(_elt.getAlign());
        this.setVAlign(_elt.getVAlign());
        this.setRotateAngle(_elt.getRotateAngle(), false);
        this.setNoWrap(_elt.isNoWrap());
        if (applyElementPosition) {
            this.setXX(_elt.getX(), true);
            this.setYY(_elt.getY(), true);
        }
        this.setZ(_elt.getZ());
        this.setWidth(_elt.getWidth());
        this.setHeight(_elt.getHeight());
        this.setMinWidth(_elt.getMin_Width());
        this.setMinHeight(_elt.getMin_Height());
        this.setBorderThickness(_elt);
        this.borderColor = _elt.getBorderColor();
        this.styleName = _elt.getStyleName();
        this.link = _elt.getLink();
        this.hint = _elt.getHint();
        this.target = _elt.getTarget();
        if (copyDrillDownName) {
            this.drillDownName = _elt.getDrillDownName();
        }
        this.setResizeToFitContent(_elt.isResizeToFitContent());
        this.setLocked(_elt.isLocked());
        this.setSnap(_elt.getSnap());
        this.setVSnap(_elt.getVSnap());
        this.snapToGrid = _elt.snapToGrid;
        this.inchGridSpace = _elt.inchGridSpace;
        this.cmGridSpace = _elt.cmGridSpace;
        if (applyScript) {
            this.setScriptObj(_elt.getScriptObj());
            this.setScriptName(_elt.getScriptName());
            this.setScript(_elt.getScript());
        }
        this.uniqueNumber = _elt.uniqueNumber;
        this.address = _elt.address;
        this.roundCornerRadius = _elt.roundCornerRadius;
        this.roundCornersArray = (boolean[])_elt.roundCornersArray.clone();
        this.setBorderThickness(_elt);
    }

    String getAddress() {
        if (this.address == null) {
            this.address = String.valueOf(this.uniqueNumber);
        }
        return this.address;
    }

    public void applyStyle(ReportElement _elt) {
        this.applyStyleButNotWH(_elt);
        this.setWidth(_elt.getWidth());
        this.setHeight(_elt.getHeight());
        this.setMinWidth(_elt.getMin_Width());
        this.setMinHeight(_elt.getMin_Height());
        this.setY(_elt.getY());
    }

    public void applyStyleButNotWH(ReportElement _elt) {
        this.setBgColor(_elt.getBgColor());
        this.font = _elt.getFont();
        this.setFontColor(_elt.fontColor);
        this.setRotateAngle(_elt.getRotateAngle(), false);
        this.setUnderline(_elt.isUnderline());
        this.setAlign(_elt.getAlign());
        this.setVAlign(_elt.getVAlign());
        this.setNoWrap(_elt.isNoWrap());
        this.setBorderThickness(_elt);
        this.borderColor = _elt.getBorderColor();
        this.roundCornerRadius = _elt.roundCornerRadius;
        this.roundCornersArray = (boolean[])_elt.roundCornersArray.clone();
        this.setMinWidth(_elt.getMin_Width());
        this.setMinHeight(_elt.getMin_Height());
    }

    public void copyStyleWithScriptsButNotWH(ReportElement _elt, boolean copyScriptsAndDrillDownLinks) {
        this.applyStyleButNotWH(_elt);
        if (copyScriptsAndDrillDownLinks) {
            this.setScriptName(_elt.getScriptName());
            this.setScriptObj(_elt.getScriptObj());
            this.setScript(_elt.getScript());
            this.setLink(_elt.getLink());
            this.setDrillDownName(_elt.getDrillDownName());
            this.setHint(_elt.getHint());
        }
    }

    public boolean equals(ReportElement _elt) {
        if (_elt == null) {
            return false;
        }
        if (_elt == this) {
            return true;
        }
        if (this.text != null && _elt.text == null) {
            return false;
        }
        if (this.text != null && !this.text.equals(_elt.text)) {
            return false;
        }
        if (this.scriptName == null && _elt.scriptName != null) {
            return false;
        }
        if (this.scriptName != null && !this.scriptName.equals(_elt.scriptName)) {
            return false;
        }
        if (this.scriptObj != _elt.scriptObj) {
            return false;
        }
        if (this.script == null && _elt.script != null) {
            return false;
        }
        if (this.script != null && !this.script.equals(_elt.script)) {
            return false;
        }
        if (this.isSecurityTextScript() != _elt.isSecurityTextScript()) {
            return false;
        }
        if (this.isShiftSecuredColX() != _elt.isShiftSecuredColX()) {
            return false;
        }
        if (this.shiftSecuredColXIncludeHeaderAndFooter != _elt.shiftSecuredColXIncludeHeaderAndFooter) {
            return false;
        }
        if (!this.id.equals(_elt.getID())) {
            return false;
        }
        if (this.customid != null && _elt.customid == null) {
            return false;
        }
        if (this.customid != null && !this.customid.equals(_elt.customid)) {
            return false;
        }
        if (!this.font.equals(_elt.getRefFont())) {
            return false;
        }
        if (this.bgColor == null && _elt.bgColor != null) {
            return false;
        }
        if (this.bgColor != null && !this.bgColor.equals(_elt.bgColor)) {
            return false;
        }
        if (this.fontColor == null && _elt.fontColor != null) {
            return false;
        }
        if (this.fontColor != null && !this.fontColor.equals(_elt.fontColor)) {
            return false;
        }
        if (this.underline != _elt.isUnderline()) {
            return false;
        }
        if (this.align != _elt.getAlign()) {
            return false;
        }
        if (this.valign != _elt.getVAlign()) {
            return false;
        }
        if (this.noWrap != _elt.isNoWrap()) {
            return false;
        }
        if (this.resizeToFitContent != _elt.resizeToFitContent) {
            return false;
        }
        if (this.isLocked != _elt.isLocked) {
            return false;
        }
        if (this.x != _elt.getX()) {
            return false;
        }
        if (this.y != _elt.getY()) {
            return false;
        }
        if (this.width != _elt.getWidth()) {
            return false;
        }
        if (this.height != _elt.getHeight()) {
            return false;
        }
        if (this.topBorder != _elt.getTopBorder() && this.rightBorder != _elt.getRightBorder() && this.bottomBorder != _elt.getBottomBorder() && this.leftBorder != _elt.getLeftBorder()) {
            return false;
        }
        if (this.borderColor == null && _elt.borderColor != null) {
            return false;
        }
        if (this.borderColor != null && this.borderColor != _elt.getBorderColor()) {
            return false;
        }
        if (!this.styleName.equals(_elt.getStyleName())) {
            return false;
        }
        if (!this.link.equals(_elt.getLink())) {
            return false;
        }
        if (!this.hint.equals(_elt.getHint())) {
            return false;
        }
        if (!this.target.equals(_elt.getTarget())) {
            return false;
        }
        if (this.drillDownName == null && _elt.getDrillDownName() != null) {
            return false;
        }
        return this.drillDownName == null || this.drillDownName.equals(_elt.getDrillDownName());
    }

    public boolean contains(double cx, double cy) {
        if (this.height < 0.0) {
            return cx >= this.x && cx <= this.x + this.width && cy >= this.y;
        }
        return cx >= this.x && cx <= this.x + this.width && cy >= this.y && cy <= this.y + this.height;
    }

    public boolean containsX(double cx, double w) {
        return this.x + this.width > cx && this.x < cx + w;
    }

    public boolean containsY(double cy, double h) {
        return cy + h >= this.y;
    }

    public boolean inTopHalf(double cy) {
        return cy < this.y + this.height * 0.5;
    }

    public boolean inBottomHalf(double cy) {
        return cy >= this.y + this.height * 0.5;
    }

    public boolean inLeftHalf(double cx) {
        return this.containsX(cx, 0.0) && cx < this.x + this.width * 0.5;
    }

    public boolean inRightHalf(double cx) {
        return this.containsX(cx, 0.0) && cx >= this.x + this.width * 0.5;
    }

    public boolean inLeftEnd(double cx) {
        return this.containsX(cx, 0.0) && cx >= this.x;
    }

    public boolean inRightEnd(double cx, double w) {
        return this.containsX(cx + w, 0.0) && cx < this.x;
    }

    public boolean isSecurityTextScript() {
        return this.securityTextScript;
    }

    public void setSecurityTextScript(boolean state) {
        this.securityTextScript = state;
    }

    public boolean isShiftSecuredColX() {
        return this.shiftSecuredColX;
    }

    public boolean isShiftSecuredColXIncludeHeaderAndFooter() {
        return this.shiftSecuredColXIncludeHeaderAndFooter;
    }

    public void setShiftSecuredColX(boolean state) {
        this.shiftSecuredColX = state;
    }

    public void setShiftSecuredColXIncludeHeaderAndFooter(boolean state) {
        this.shiftSecuredColXIncludeHeaderAndFooter = state;
    }

    public void applySecurity(ReportElement _elt) {
        this.shiftSecuredColXIncludeHeaderAndFooter = _elt.shiftSecuredColXIncludeHeaderAndFooter;
        this.shiftSecuredColX = _elt.shiftSecuredColX;
        this.securityTextScript = _elt.securityTextScript;
        this.securityMap = _elt.securityMap;
    }

    public String getScript() {
        if (this.scriptObj != null) {
            return this.scriptObj.getText();
        }
        return this.script;
    }

    public void setScript(String s) {
        this.script = s;
    }

    public String getScriptName() {
        if (this.scriptObj != null) {
            return this.scriptObj.getName();
        }
        return this.scriptName;
    }

    public void setScriptName(String s) {
        this.scriptName = s;
    }

    public Script getScriptObj() {
        return this.scriptObj;
    }

    public void setScriptObj(Script scriptObj) {
        this.scriptObj = scriptObj;
    }

    public void setScriptObjNull(Script scriptObj) {
        this.scriptObj = scriptObj;
        if (scriptObj == null) {
            this.scriptName = null;
            this.script = null;
        }
    }

    public short getAlign() {
        return this.align;
    }

    public void setAlign(short newAlign) {
        this.align = newAlign;
    }

    public short getVAlign() {
        return this.valign;
    }

    public void setVAlign(short newVAlign) {
        this.valign = newVAlign;
    }

    public void setSnap(short snap) {
        if (this.isLocked) {
            return;
        }
        this.snap = snap;
    }

    public short getSnap() {
        return this.snap;
    }

    public void setVSnap(short vsnap) {
        if (this.isLocked) {
            return;
        }
        this.vsnap = vsnap;
    }

    public short getVSnap() {
        return this.vsnap;
    }

    public Color getBgColor() {
        return this.bgColor;
    }

    public void setBgColor(Color newColorBg) {
        this.bgColor = newColorBg;
    }

    public Color getFontColor() {
        return this.fontColor;
    }

    public void setFontColor(Color newColorFt) {
        this.fontColor = newColorFt;
    }

    public Vector<Color> getAllColors(Vector<Color> colors) {
        if (this.bgColor != null && !colors.contains(this.bgColor)) {
            colors.add(this.bgColor);
        }
        if (this.fontColor != null && !colors.contains(this.fontColor)) {
            colors.add(this.fontColor);
        }
        if (this.borderColor != null && !colors.contains(this.borderColor)) {
            colors.add(this.borderColor);
        }
        return colors;
    }

    public boolean isUnderline() {
        return this.underline;
    }

    public void setUnderline(boolean underline) {
        this.underline = underline;
    }

    public Font getFont() {
        this.font = FontTable.clone(this.font);
        return this.font;
    }

    public Font getRefFont() {
        return this.font;
    }

    public void setFont(Font newFont) {
        this.font = newFont;
        this.adjustFont = null;
    }

    public Font getRefFontToDraw(boolean adjust) {
        if (!adjust) {
            return this.font;
        }
        if (this.adjustFont == null) {
            this.adjustFont = FontTable.newFont(this.font.getName(), this.font.getStyle(), QbUtil.resizeViewerFont(this.font.getSize(), adjust));
        }
        return this.adjustFont;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String newText) {
        this.text = newText;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String newID) {
        if (this.customid == null || this.customid.trim().equals("") || this.customid.equals(this.id)) {
            this.setCustomID(newID);
        }
        this.id = newID;
    }

    public String getCustomID() {
        return this.customid;
    }

    public void setCustomID(String newID) {
        this.customid = newID;
    }

    public boolean isNoWrap() {
        return this.noWrap;
    }

    public void setNoWrap(boolean w) {
        this.noWrap = w;
    }

    public boolean isResizeToFitContent() {
        return this.resizeToFitContent;
    }

    public void setResizeToFitContent(boolean b) {
        this.resizeToFitContent = b;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public void setLocked(boolean state) {
        if (this.getSnap() == 0 && this.getVSnap() == 0) {
            this.isLocked = state;
        }
    }

    public String getStyleName() {
        return this.styleName == null ? "" : this.styleName;
    }

    public void setStyleName(String newStyleName) {
        if (newStyleName == null) {
            newStyleName = "";
        }
        this.styleName = newStyleName;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String newLink) {
        if (newLink == null) {
            newLink = "";
        }
        this.link = newLink;
    }

    public String getHint() {
        return this.hint;
    }

    public void setHint(String newHint) {
        if (newHint == null) {
            newHint = "";
        }
        this.hint = newHint;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String newTarget) {
        if (newTarget == null) {
            newTarget = "";
        }
        this.target = newTarget;
    }

    public String getDrillDownName() {
        return this.drillDownName;
    }

    public void setDrillDownName(String name) {
        this.drillDownName = name;
    }

    public double getX() {
        return this.x;
    }

    public int getXPos() {
        return QbUtil.toPixel(this.getX());
    }

    public int getXPos(boolean forExport) {
        if (forExport) {
            return QbUtil.toPixel_export(this.getX());
        }
        return this.getXPos();
    }

    public float getXToPoints() {
        return QbUtil.toPoints(this.getX());
    }

    public float getYToPoints() {
        return QbUtil.toPoints(this.getY());
    }

    public double getX(boolean isMetric) {
        return isMetric ? this.x * 2.54 : this.x;
    }

    public void setX(double x) {
        if (this.isLocked()) {
            return;
        }
        if (this.snapToGrid) {
            x = this.metric ? QbUtil.getPosAfterSnapToGrid(x) : (double)Math.round(x / this.inchGridSpace) * this.inchGridSpace;
            x = ReportElement.roundUp(x);
        }
        if (this.vsnap == 0 && !(this instanceof GuideLine)) {
            this.x = x >= 0.0 ? x : 0.0;
        }
    }

    public void setXX(double x, boolean doNotReCal) {
        if (doNotReCal) {
            this.x = x;
        } else {
            this.setX(x);
        }
    }

    public void setX(double x, boolean isMetric) {
        if (this.isLocked()) {
            return;
        }
        if (!isMetric) {
            if (this.snapToGrid) {
                x = (double)Math.round(x / this.inchGridSpace) * this.inchGridSpace;
            }
        } else {
            x /= 2.54;
            x = QbUtil.getPosAfterSnapToGrid(x);
        }
        x = ReportElement.roundUp(x);
        if (this.vsnap == 0 && !(this instanceof GuideLine)) {
            this.x = x >= 0.0 ? x : 0.0;
        }
    }

    public void setXX(double x) {
        if (this.isLocked()) {
            return;
        }
        if (this.snapToGrid) {
            x = this.metric ? QbUtil.getPosAfterSnapToGrid(x) : (double)Math.round(x / this.inchGridSpace) * this.inchGridSpace;
        }
        this.x = (x = ReportElement.roundUp(x)) >= 0.0 ? x : 0.0;
    }

    public double getY() {
        return this.y;
    }

    public int getYPos() {
        return QbUtil.toPixel(this.getY());
    }

    public int getYPos(boolean forExport) {
        if (forExport) {
            return QbUtil.toPixel_export(this.getY());
        }
        return this.getYPos();
    }

    public double getY(boolean isMetric) {
        return isMetric ? this.y * 2.54 : this.y;
    }

    public void setY(double y) {
        if (this.isLocked()) {
            return;
        }
        if (this.snapToGrid) {
            y = this.metric ? QbUtil.getPosAfterSnapToGrid(y) : (double)Math.round(y / this.inchGridSpace) * this.inchGridSpace;
            y = ReportElement.roundUp(y);
        }
        if (this.snap == 0 && !(this instanceof GuideLine)) {
            this.y = y >= 0.0 ? y : 0.0;
        }
    }

    public void setYY(double y, boolean doNotReCal) {
        if (doNotReCal) {
            this.y = y;
        } else {
            this.setY(y);
        }
    }

    public void setYY(double y) {
        if (this.isLocked()) {
            return;
        }
        if (this.snapToGrid) {
            y = this.metric ? QbUtil.getPosAfterSnapToGrid(y) : (double)Math.round(y / this.inchGridSpace) * this.inchGridSpace;
            y = ReportElement.roundUp(y);
        }
        this.y = y >= 0.0 ? y : 0.0;
    }

    public void setY(double y, boolean isMetric) {
        if (this.isLocked()) {
            return;
        }
        if (!isMetric) {
            if (this.snapToGrid) {
                y = (double)Math.round(y / this.inchGridSpace) * this.inchGridSpace;
            }
        } else {
            y /= 2.54;
            if (this.snapToGrid) {
                y = QbUtil.getPosAfterSnapToGrid(y);
            }
        }
        y = ReportElement.roundUp(y);
        if (this.snap == 0 && !(this instanceof GuideLine)) {
            this.y = y >= 0.0 ? y : 0.0;
        }
    }

    public double getWidth() {
        return this.width;
    }

    public int getWidthOfElement() {
        return QbUtil.toPixel(this.width);
    }

    public int getWidthOfElement(boolean forExport) {
        if (forExport) {
            return QbUtil.toPixel_export(this.width);
        }
        return this.getWidthOfElement();
    }

    public float getWidthToPoints() {
        return QbUtil.toPoints(this.width);
    }

    public double getWidth(boolean isMetric) {
        return isMetric ? this.getWidth() * 2.54 : this.getWidth();
    }

    public void setWidth(double width) {
        if (this.isLocked()) {
            return;
        }
        if (!(!this.snapToGrid || this instanceof ReportLine && ((ReportLine)this).isVertical())) {
            if (this.metric) {
                double tmp = QbUtil.getPosAfterSnapToGrid(width);
                if (tmp > 0.0) {
                    width = tmp;
                }
            } else {
                double x2;
                double tmpx2;
                double tmp = (double)Math.round(width / this.inchGridSpace) * this.inchGridSpace;
                if (tmp > 0.0) {
                    width = tmp;
                }
                if ((tmpx2 = (double)Math.round((x2 = width + this.getX()) / this.inchGridSpace) * this.inchGridSpace) < x2) {
                    width -= 1.0E-15;
                }
            }
        }
        this.width = ReportElement.roundUp(width);
    }

    public void setWidth(double width, boolean isMetric) {
        if (this.isLocked()) {
            return;
        }
        if (!isMetric) {
            double tmp;
            if (!(!this.snapToGrid || this instanceof ReportImage || this instanceof ReportLine && ((ReportLine)this).isVertical() || !((tmp = (double)Math.round(width / this.inchGridSpace) * this.inchGridSpace) > 0.0))) {
                width = tmp;
            }
        } else {
            double tmp;
            width /= 2.54;
            if (!(!this.snapToGrid || this instanceof ReportImage || this instanceof ReportLine && ((ReportLine)this).isVertical() || !((tmp = QbUtil.getPosAfterSnapToGrid(width)) > 0.0))) {
                width = tmp;
            }
        }
        this.width = ReportElement.roundUp(width);
    }

    public void setMinWidth(double mW) {
        this.min_width = mW;
    }

    public void setMinHeight(double mH) {
        this.min_height = mH;
    }

    public double getMin_Width() {
        return this.min_width;
    }

    public double getMin_Height() {
        return this.min_height;
    }

    public double getHeight() {
        return this.height;
    }

    public int getHeightOfElement() {
        return QbUtil.toPixel(this.height);
    }

    public int getHeightOfElement(boolean forExport) {
        if (forExport) {
            return QbUtil.toPixel_export(this.height);
        }
        return this.getHeightOfElement();
    }

    public float getHeightToPoints() {
        return (float)Math.rint(QbUtil.toPoints(this.height));
    }

    public double getHeight(boolean isMetric) {
        return isMetric ? this.getHeight() * 2.54 : this.getHeight();
    }

    public void setHeight(double height) {
        boolean isVerticalLine;
        if (this.isLocked()) {
            return;
        }
        if (this instanceof ReportSection || this instanceof ReportTable) {
            this.height = height;
            return;
        }
        double tmp = 0.0;
        boolean isReportGridWithTopAndBottom = this instanceof ReportGrid && ((ReportGrid)this).next() == null && ((ReportGrid)this).previous() == null;
        boolean bl = isVerticalLine = this instanceof ReportLine && ((ReportLine)this).isVertical();
        if (this.snapToGrid && (!(this instanceof ReportLine) && !(this instanceof ReportGrid) || isReportGridWithTopAndBottom || isVerticalLine)) {
            tmp = this.metric ? QbUtil.getPosAfterSnapToGrid(height) : (double)Math.round(height / this.inchGridSpace) * this.inchGridSpace;
        }
        if (tmp > 0.0) {
            height = tmp;
        }
        this.height = ReportElement.roundUp(height);
    }

    public void setHeight(double height, boolean isMetric) {
        if (this.isLocked()) {
            return;
        }
        if (this instanceof ReportSection || this instanceof ReportTable) {
            this.height = height;
            return;
        }
        if (!isMetric) {
            double tmp;
            if (!(!this.snapToGrid || this instanceof ReportImage || this instanceof ReportLine && ((ReportLine)this).isVertical() || !((tmp = (double)Math.round(height / this.inchGridSpace) * this.inchGridSpace) > 0.0))) {
                height = tmp;
            }
        } else {
            double tmp;
            height /= 2.54;
            if (!(!this.snapToGrid || this instanceof ReportImage || this instanceof ReportLine && ((ReportLine)this).isVertical() || !((tmp = QbUtil.getPosAfterSnapToGrid(height)) > 0.0))) {
                height = tmp;
            }
        }
        this.height = ReportElement.roundUp(height);
    }

    public void resize(double xratio, double yratio) {
        if (this.isLocked()) {
            return;
        }
        if (this.snapToGrid) {
            if (!this.metric) {
                if (xratio != 1.0) {
                    double d = this.x / this.width;
                    this.width = Math.floor(this.width * xratio / this.inchGridSpace) * this.inchGridSpace;
                    this.x = d * this.width;
                }
                if (yratio != 1.0) {
                    double dd = this.y / this.height;
                    this.height = Math.floor(this.height * yratio / this.inchGridSpace) * this.inchGridSpace;
                    this.y = dd * this.height;
                }
            } else {
                if (xratio != 1.0) {
                    double d = this.x / this.width;
                    this.width = Math.floor(this.width * xratio / this.cmGridSpace) * this.cmGridSpace;
                    this.x = d * this.width;
                }
                if (yratio != 1.0) {
                    double dd = this.y / this.height;
                    this.height = Math.floor(this.height * yratio / this.cmGridSpace) * this.cmGridSpace;
                    this.y = dd * this.height;
                }
            }
        } else {
            this.x *= xratio;
            this.width *= xratio;
            this.y *= yratio;
            this.height *= yratio;
        }
    }

    @Deprecated
    public int getBorderThickness() {
        return this.topBorder;
    }

    public void setBorderThickness(int borderThickness) {
        this.setBorderThickness(borderThickness, borderThickness, borderThickness, borderThickness);
    }

    public void setBorderThickness(int borderThickness, BorderSide borderSide) {
        switch (borderSide) {
            case RIGHT: {
                this.rightBorder = borderThickness;
                break;
            }
            case BOTTOM: {
                this.bottomBorder = borderThickness;
                break;
            }
            case LEFT: {
                this.leftBorder = borderThickness;
                break;
            }
            default: {
                this.topBorder = borderThickness;
            }
        }
    }

    public void setBorderThickness(int topBorder, int rightBorder, int bottomBorder, int leftBorder) {
        this.topBorder = topBorder;
        this.rightBorder = rightBorder;
        this.bottomBorder = bottomBorder;
        this.leftBorder = leftBorder;
    }

    @Deprecated
    public void setBorder(int b) {
        this.setBorderThickness(b);
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color newBorderColor) {
        this.borderColor = newBorderColor;
    }

    public static ReportElement[] sortElement(ReportElement[] elemsToSort, int order, boolean asc) {
        int i;
        if (elemsToSort == null || elemsToSort.length <= 1) {
            return elemsToSort;
        }
        ReportElement[] result = new ReportElement[elemsToSort.length];
        for (i = 0; i < result.length; ++i) {
            ReportElement temp = null;
            double tempD = 0.0;
            int index = 0;
            for (int j = 0; j < elemsToSort.length; ++j) {
                if (elemsToSort[j] == null) continue;
                double tempD2 = ReportElement.getSortValue(elemsToSort[j], order);
                if (temp == null) {
                    temp = elemsToSort[j];
                    tempD = tempD2;
                    index = j;
                    continue;
                }
                if (asc && tempD2 < tempD || !asc && tempD2 > tempD || asc && tempD == tempD2 && elemsToSort[j] instanceof RBColumnHeader && order == 1) {
                    temp = elemsToSort[j];
                    tempD = tempD2;
                    index = j;
                    continue;
                }
                if (order != 2 || tempD2 != tempD || !(temp instanceof ReportLine) && !(temp instanceof ReportGrid) || elemsToSort[j] instanceof ReportLine || elemsToSort[j] instanceof ReportGrid) continue;
                temp = elemsToSort[j];
                tempD = tempD2;
                index = j;
            }
            elemsToSort[index] = null;
            result[i] = temp;
        }
        for (i = 0; i < result.length; ++i) {
            elemsToSort[i] = result[i];
        }
        return elemsToSort;
    }

    static final double getSortValue(ReportElement r, int order) {
        switch (order) {
            case 1: {
                return r.getX();
            }
            case 0: {
                return r.getY();
            }
            case 2: {
                return r.getZ();
            }
        }
        return 0.0;
    }

    public static Vector<ReportElement> sortElementInXYOrder(ReportElement[] areportCell) {
        Vector<ReportElement[]> vec = ReportElement.sortElementHorizontally(areportCell);
        Vector<ReportElement> res = new Vector<ReportElement>();
        for (int i = 0; i < vec.size(); ++i) {
            ReportElement[] list;
            for (ReportElement element : list = vec.elementAt(i)) {
                res.add(element);
            }
        }
        return res;
    }

    public static Vector<ReportElement[]> sortElementHorizontally(ReportElement[] areportcell) {
        if (ReportElement.isFixedFieldCrossTabWithMultiRows(areportcell)) {
            Vector<ReportElement>[] vec2 = ReportElement.getFirst2RowOfColumns(areportcell);
            Vector<ReportElement[]> finalSec = new Vector<ReportElement[]>();
            finalSec.add(ReportElement.sortElement(ReportElement.convertToREltArray(vec2[0]), 1, true));
            Vector<ReportElement[]> vec3 = ReportElement.sortElementHorizontally2(ReportElement.convertToREltArray(vec2[1]));
            for (int i = 0; i < vec3.size(); ++i) {
                finalSec.add(vec3.elementAt(i));
            }
            return finalSec;
        }
        return ReportElement.sortElementHorizontally2(areportcell);
    }

    private static Vector<ReportElement[]> sortElementHorizontally2(ReportElement[] areportcell) {
        Vector<ReportElement[]> vector = new Vector<ReportElement[]>();
        areportcell = ReportElement.sortElement(areportcell, 0, true);
        int i = 0;
        double d = 0.0;
        Object el = null;
        int j = 0;
        while (j < areportcell.length) {
            double h = -1.0;
            for (int q = i; q < areportcell.length && h < 0.0; ++q) {
                if (areportcell[q] instanceof ReportLine && ((ReportLine)areportcell[q]).isVertical() || q == 0 && areportcell[q] instanceof ColumnHeader && !(areportcell[q] instanceof RBColumnHeader) && !(areportcell[q] instanceof CBColumnHeader)) continue;
                d = areportcell[q].getHeight() + areportcell[q].getY();
                h = areportcell[q].getHeight();
            }
            for (int k = i; k < areportcell.length; ++k) {
                if (areportcell[k].getY() + 0.001 >= d) {
                    if (h != 0.0) break;
                    ++j;
                    break;
                }
                ++j;
            }
            if (j > i) {
                ReportElement[] areportcell1 = new ReportElement[j - i];
                for (int l = 0; l < areportcell1.length; ++l) {
                    areportcell1[l] = areportcell[i + l];
                }
                vector.addElement(ReportElement.sortElement(areportcell1, 1, true));
            } else if (i == j) {
                // empty if block
            }
            i = ++j;
        }
        if (vector.size() == 0) {
            vector.addElement(ReportElement.sortElement(areportcell, 1, true));
        }
        return vector;
    }

    private static double roundUp(double val) {
        double decPt = 1000000.0;
        return Math.rint(val * decPt) / decPt;
    }

    public static Vector<ReportElement[]> sortElement(ReportElement[] areportcell) {
        return ReportElement.sortElement(areportcell, true);
    }

    static Vector<ReportElement[]> sortElement(ReportElement[] areportcell, boolean sortX) {
        if (ReportElement.isFixedFieldCrossTabWithMultiRows(areportcell)) {
            Vector<ReportElement>[] vec2 = ReportElement.getFirst2RowOfColumns(areportcell);
            Vector<ReportElement[]> finalSec = new Vector<ReportElement[]>();
            if (sortX) {
                finalSec.add(ReportElement.sortElement(ReportElement.convertToREltArray(vec2[0]), 1, true));
            } else {
                finalSec.add(ReportElement.convertToREltArray(vec2[0]));
            }
            Vector<ReportElement[]> vec3 = ReportElement.sortElement2(ReportElement.convertToREltArray(vec2[1]), sortX);
            for (int i = 0; i < vec3.size(); ++i) {
                finalSec.add(vec3.elementAt(i));
            }
            return finalSec;
        }
        return ReportElement.sortElement2(areportcell, sortX);
    }

    private static Vector<ReportElement[]> sortElement2(ReportElement[] areportcell, boolean sortX) {
        Vector<ReportElement[]> vector = new Vector<ReportElement[]>();
        areportcell = ReportElement.sortElement(areportcell, 0, true);
        int i = 0;
        double d = 0.0;
        int j = 0;
        while (j < areportcell.length) {
            double h = -1.0;
            for (int q = i; q < areportcell.length && h < 0.0; ++q) {
                d = areportcell[q].getHeight() + areportcell[q].getY();
                h = areportcell[q].getHeight();
            }
            for (int k = i; k < areportcell.length; ++k) {
                if (areportcell[k].getY() >= d) {
                    if (h != 0.0) break;
                    ++j;
                    break;
                }
                ++j;
            }
            if (j > i) {
                ReportElement[] areportcell1 = new ReportElement[j - i];
                for (int l = 0; l < areportcell1.length; ++l) {
                    areportcell1[l] = areportcell[i + l];
                }
                if (sortX) {
                    vector.addElement(ReportElement.sortElement(areportcell1, 1, true));
                } else {
                    vector.addElement(areportcell1);
                }
            }
            i = j;
        }
        return vector;
    }

    public static Vector<ReportElement[]> sortElementVertically(ReportElement[] areportcell) {
        Vector<ReportElement[]> vector = new Vector<ReportElement[]>();
        areportcell = ReportElement.sortElement(areportcell, 1, true);
        int i = 0;
        int j = 0;
        while (j < areportcell.length) {
            double d = areportcell[i].getWidth() + areportcell[i].getX();
            double w = areportcell[i].getWidth();
            for (int k = i; k < areportcell.length; ++k) {
                if (areportcell[k].getX() + 0.001 >= d) {
                    if (w != 0.0) break;
                    ++j;
                    break;
                }
                ++j;
            }
            if (j > i) {
                ReportElement[] areportcell1 = new ReportElement[j - i];
                for (int l = 0; l < areportcell1.length; ++l) {
                    areportcell1[l] = areportcell[i + l];
                }
                vector.addElement(ReportElement.sortElement(areportcell1, 0, true));
            }
            i = j;
        }
        return vector;
    }

    public static Vector<ReportElement>[] getFirst2RowOfColumns(Vector<ReportElement> vec) {
        ReportElement[] elt = ReportElement.convertToREltArray(vec);
        return ReportElement.getFirst2RowOfColumns(elt);
    }

    public static Vector<ReportElement>[] getFirst2RowOfColumns(ReportElement[] elt) {
        Vector[] vec2 = new Vector[]{new Vector(), new Vector()};
        double level0H = -1.0;
        for (ReportElement element : elt) {
            ReportColumn tmpCol;
            if (element instanceof ColumnBreakColumn) {
                tmpCol = (ColumnBreakColumn)element;
                if (((ColumnBreakColumn)tmpCol).getColBreakValueIndex() != 0) {
                    double res = 0.0;
                    if (((ColumnBreakColumn)tmpCol).getParentColumnName() != null) {
                        res = level0H;
                    }
                    if (res <= tmpCol.getY()) {
                        vec2[1].add(element);
                        continue;
                    }
                    vec2[0].add(element);
                    continue;
                }
                if (level0H == -1.0) {
                    level0H = tmpCol.getY() + tmpCol.getHeight();
                }
                vec2[0].add(element);
                continue;
            }
            if (element instanceof CBAggrColumn) {
                tmpCol = (CBAggrColumn)element;
                if (((CBAggrColumn)tmpCol).getColBreakValueIndex() != 0) {
                    if (level0H == -1.0) {
                        vec2[0].add(element);
                        continue;
                    }
                    if (level0H <= tmpCol.getY()) {
                        vec2[1].add(element);
                        continue;
                    }
                    vec2[0].add(element);
                    continue;
                }
                vec2[0].add(element);
                continue;
            }
            if (level0H == -1.0) {
                vec2[0].add(element);
                continue;
            }
            if (level0H <= element.getY()) {
                vec2[1].add(element);
                continue;
            }
            vec2[0].add(element);
        }
        return vec2;
    }

    static ReportElement[] convertToREltArray(Vector<ReportElement> vec) {
        ReportElement[] relt = new ReportElement[vec.size()];
        for (int i = 0; i < relt.length; ++i) {
            relt[i] = vec.elementAt(i);
        }
        return relt;
    }

    static Vector<ReportElement> convertToVector(ReportElement[] relt) {
        Vector<ReportElement> vec = new Vector<ReportElement>();
        for (ReportElement element : relt) {
            vec.add(element);
        }
        return vec;
    }

    private static boolean isFixedFieldCrossTabWithMultiRows(ReportElement[] elt) {
        double level0H = 0.0;
        for (ReportElement element : elt) {
            if (!(element instanceof ColumnBreakColumn)) continue;
            ColumnBreakColumn tmpCol = (ColumnBreakColumn)element;
            if (tmpCol.getColBreakValueIndex() == 0) {
                level0H = tmpCol.getY() + tmpCol.getHeight();
                continue;
            }
            if (!(level0H <= tmpCol.getY())) continue;
            return true;
        }
        return false;
    }

    public void write(DataOutput out) throws IOException {
        VersioningDataOutput vdo;
        IOUtil.writeStr(out, this.getText());
        IOUtil.writeStr(out, this.getID());
        IOUtil.writeStr(out, this.customid);
        if (this.isSecurityTextScript() && this.getScriptObj() != null) {
            out.writeBoolean(true);
            this.getScriptObj().write(out);
        } else {
            out.writeBoolean(false);
            IOUtil.writeStr(out, this.getScriptName());
        }
        out.writeBoolean(this.isShiftSecuredColX());
        out.writeBoolean(this.isShiftSecuredColXIncludeHeaderAndFooter());
        IOUtil.writeFont(out, this.getRefFont());
        IOUtil.writeColor(out, this.getBgColor());
        IOUtil.writeColor(out, this.getFontColor());
        out.writeBoolean(this.isUnderline());
        out.writeShort(this.getAlign());
        out.writeShort(this.getVAlign());
        out.writeBoolean(this.isNoWrap());
        out.writeBoolean(this.isResizeToFitContent());
        out.writeBoolean(this.isLocked());
        out.writeShort(this.getSnap());
        out.writeShort(this.getVSnap());
        out.writeDouble(this.getX());
        out.writeDouble(this.getY());
        out.writeInt(this.getZ());
        out.writeDouble(this.getWidth());
        out.writeDouble(this.getHeight());
        out.writeInt(this.getBorderThickness());
        IOUtil.writeColor(out, this.getBorderColor());
        IOUtil.writeStr(out, this.getStyleName());
        IOUtil.writeStr(out, this.getLink());
        IOUtil.writeStr(out, this.getHint());
        IOUtil.writeStr(out, this.getTarget());
        IOUtil.writeStr(out, this.getDrillDownName());
        if (this.securityMap != null) {
            out.writeBoolean(true);
            out.writeInt(this.securityMap.size());
            Enumeration<String> enum1 = this.securityMap.keys();
            while (enum1.hasMoreElements()) {
                String key = enum1.nextElement();
                IOUtil.writeStr(out, key.toString());
                ((ReportCell)this.securityMap.get(key)).write(out);
            }
        } else {
            out.writeBoolean(false);
        }
        if (out instanceof VersioningDataOutput) {
            vdo = (VersioningDataOutput)out;
            vdo.writeDouble(this.getRotateAngle(), (short)2001);
        } else {
            out.writeDouble(this.getRotateAngle());
        }
        out.writeBoolean(this.visible);
        if (out instanceof VersioningDataOutput) {
            vdo = (VersioningDataOutput)out;
            vdo.writeInt(this.getRoundCornerRadius(), (short)6601);
            IOUtil.writeBooleans(vdo, this.getRoundCornersArray(), (short)6601);
        } else {
            out.writeInt(this.getRoundCornerRadius());
            IOUtil.writeBooleans(out, this.getRoundCornersArray());
        }
        if (out instanceof VersioningDataOutput) {
            vdo = (VersioningDataOutput)out;
            vdo.writeInt(this.getTopBorder(), (short)6605);
            vdo.writeInt(this.getRightBorder(), (short)6605);
            vdo.writeInt(this.getBottomBorder(), (short)6605);
            vdo.writeInt(this.getLeftBorder(), (short)6605);
        } else {
            out.writeInt(this.getTopBorder());
            out.writeInt(this.getRightBorder());
            out.writeInt(this.getBottomBorder());
            out.writeInt(this.getLeftBorder());
        }
    }

    public void writeXML(Writer out, boolean writeElementTag) throws IOException {
        boolean[] rCornersArray;
        if (writeElementTag) {
            out.write("<REPORTELEMENT>\n");
        }
        if (this.getText() != null) {
            out.write("<REPORTELEMENT_TEXT>" + XMLUtil.encodeXML(this.getText()) + "</REPORTELEMENT_TEXT>\n");
        }
        if (this.getID() != null) {
            out.write("<REPORTELEMENT_ID>" + XMLUtil.encodeCDATA(this.getID()) + "</REPORTELEMENT_ID>\n");
        }
        if (this.getCustomID() != null) {
            out.write("<REPORTELEMENT_CUSTOMID>" + XMLUtil.encodeCDATA(this.customid) + "</REPORTELEMENT_CUSTOMID>\n");
        }
        if (this.isSecurityTextScript() && this.getScriptObj() != null) {
            out.write("<REPORTELEMENT_SCRIPT>");
            try {
                this.getScriptObj().writeXML(out);
            }
            catch (Exception ex) {
                throw new IOException(ex.getMessage());
            }
            out.write("</REPORTELEMENT_SCRIPT>\n");
        } else if (this.getScriptName() != null) {
            out.write("<REPORTELEMENT_SCRIPT>" + XMLUtil.encodeCDATA(this.getScriptName()) + "</REPORTELEMENT_SCRIPT>\n");
        }
        out.write("<REPORTELEMENT_SHIFTSECUREDCOLX>" + this.isShiftSecuredColX() + "</REPORTELEMENT_SHIFTSECUREDCOLX>\n");
        out.write("<REPORTELEMENT_SHIFTSECUREDCOLXINCLUDEHEADERANDFOOTER>" + this.isShiftSecuredColXIncludeHeaderAndFooter() + "</REPORTELEMENT_SHIFTSECUREDCOLXINCLUDEHEADERANDFOOTER>\n");
        out.write("<REPORTELEMENT_FONTNAME>" + XMLUtil.encodeCDATA(this.getRefFont().getName()) + "</REPORTELEMENT_FONTNAME>\n");
        out.write("<REPORTELEMENT_FONTSIZE>" + this.getRefFont().getSize() + "</REPORTELEMENT_FONTSIZE>\n");
        out.write("<REPORTELEMENT_FONTSTYLE>" + this.getRefFont().getStyle() + "</REPORTELEMENT_FONTSTYLE>\n");
        if (this.getBgColor() != null) {
            out.write("<REPORTELEMENT_BGCOLOR>" + this.getBgColor().getRGB() + "</REPORTELEMENT_BGCOLOR>\n");
        }
        if (this.getFontColor() != null) {
            out.write("<REPORTELEMENT_FONTCOLOR>" + this.getFontColor().getRGB() + "</REPORTELEMENT_FONTCOLOR>\n");
        }
        out.write("<REPORTELEMENT_UNDERLINE>" + this.isUnderline() + "</REPORTELEMENT_UNDERLINE>\n");
        out.write("<REPORTELEMENT_ALIGN>" + this.getAlign() + "</REPORTELEMENT_ALIGN>\n");
        out.write("<REPORTELEMENT_VALIGN>" + this.getVAlign() + "</REPORTELEMENT_VALIGN>\n");
        out.write("<REPORTELEMENT_NOWRAP>" + this.isNoWrap() + "</REPORTELEMENT_NOWRAP>\n");
        out.write("<REPORTELEMENT_RESIZE_TO_FIT_CONTENT>" + this.isResizeToFitContent() + "</REPORTELEMENT_RESIZE_TO_FIT_CONTENT>\n");
        out.write("<REPORTELEMENT_ISLOCKED>" + this.isLocked() + "</REPORTELEMENT_ISLOCKED>\n");
        out.write("<REPORTELEMENT_SNAP>" + this.getSnap() + "</REPORTELEMENT_SNAP>");
        out.write("<REPORTELEMENT_VSNAP>" + this.getVSnap() + "</REPORTELEMENT_VSNAP>");
        out.write("<REPORTELEMENT_X>" + this.getX() + "</REPORTELEMENT_X>\n");
        out.write("<REPORTELEMENT_Y>" + this.getY() + "</REPORTELEMENT_Y>\n");
        out.write("<REPORTELEMENT_Z>" + this.getZ() + "</REPORTELEMENT_Z>\n");
        out.write("<REPORTELEMENT_WIDTH>" + this.getWidth() + "</REPORTELEMENT_WIDTH>\n");
        out.write("<REPORTELEMENT_HEIGHT>" + this.getHeight() + "</REPORTELEMENT_HEIGHT>\n");
        out.write("<REPORTELEMENT_VISIBLE>" + this.isVisible() + "</REPORTELEMENT_VISIBLE>\n");
        out.write("<REPORTELEMENT_BORDER>" + this.getBorderThickness() + "</REPORTELEMENT_BORDER>\n");
        if (this.getBorderColor() != null) {
            out.write("<REPORTELEMENT_BORDERCOLOR>" + this.getBorderColor().getRGB() + "</REPORTELEMENT_BORDERCOLOR>\n");
        }
        if (this.getStyleName() != null) {
            out.write("<REPORTELEMENT_STYLENAME>" + XMLUtil.encodeCDATA(this.getStyleName()) + "</REPORTELEMENT_STYLENAME>\n");
        }
        if (this.getLink() != null) {
            out.write("<REPORTELEMENT_LINK>" + XMLUtil.encodeCDATA(this.getLink()) + "</REPORTELEMENT_LINK>\n");
        }
        if (this.getHint() != null) {
            out.write("<REPORTELEMENT_HINT>" + XMLUtil.encodeCDATA(this.getHint()) + "</REPORTELEMENT_HINT>\n");
        }
        if (this.getTarget() != null) {
            out.write("<REPORTELEMENT_TARGET>" + XMLUtil.encodeCDATA(this.getTarget()) + "</REPORTELEMENT_TARGET>\n");
        }
        if (this.getDrillDownName() != null) {
            out.write("<REPORTELEMENT_DRILLDOWNNAME>" + XMLUtil.encodeCDATA(this.getDrillDownName()) + "</REPORTELEMENT_DRILLDOWNNAME>\n");
        }
        if (this.securityMap != null) {
            out.write("<REPORTELEMENT_SECURITYMAP>");
            Enumeration<String> enum1 = this.securityMap.keys();
            while (enum1.hasMoreElements()) {
                String key = enum1.nextElement();
                out.write("<REPORTELEMENT_SECURITYLEVEL name=\"" + XMLUtil.encodeXML(key.toString()) + "\">");
                ((ReportCell)this.securityMap.get(key)).writeXML(out, true);
                out.write("</REPORTELEMENT_SECURITYLEVEL>");
            }
            out.write("</REPORTELEMENT_SECURITYMAP>\n");
        }
        out.write("<REPORTELEMENT_ROTATEANGLE>" + this.getRotateAngle() + "</REPORTELEMENT_ROTATEANGLE>\n");
        out.write("<REPORTELEMENT_ROUNDCORNERRADIUS>" + this.getRoundCornerRadius() + "</REPORTELEMENT_ROUNDCORNERRADIUS>\n");
        out.write("<REPORTELEMENT_ROUNDCORNERSARRAY>\n");
        for (boolean element : rCornersArray = this.getRoundCornersArray()) {
            out.write("<REPORTELEMENT_ROUNDCORNERSARRAY_ITEM>" + element + "</REPORTELEMENT_ROUNDCORNERSARRAY_ITEM>\n");
        }
        out.write("</REPORTELEMENT_ROUNDCORNERSARRAY>\n");
        out.write("<REPORTELEMENT_TOP_BORDER>" + this.getTopBorder() + "</" + REPORTELEMENT_TOP_BORDER + ">\n");
        out.write("<REPORTELEMENT_RIGHT_BORDER>" + this.getRightBorder() + "</" + REPORTELEMENT_RIGHT_BORDER + ">\n");
        out.write("<REPORTELEMENT_BOTTOM_BORDER>" + this.getBottomBorder() + "</" + REPORTELEMENT_BOTTOM_BORDER + ">\n");
        out.write("<REPORTELEMENT_LEFT_BORDER>" + this.getLeftBorder() + "</" + REPORTELEMENT_LEFT_BORDER + ">\n");
    }

    public void readXML(Node node, int version) throws Exception {
        this.setText(null);
        this.setID(null);
        this.setCustomID(null);
        this.setScriptName(null);
        this.setStyleName("");
        this.setLink(null);
        this.setHint(null);
        this.setTarget(null);
        this.setDrillDownName(null);
        this.setLocked(false);
        String fontname = null;
        int fontstyle = -1;
        int fontsize = -1;
        boolean lock = false;
        boolean check15 = false;
        boolean check14 = false;
        boolean check13 = false;
        boolean check12 = false;
        boolean check11 = false;
        boolean check10 = false;
        boolean check9 = false;
        boolean check6 = false;
        boolean check5 = false;
        boolean check4 = false;
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node child = nodeList.item(i);
            if (child.getNodeName().equalsIgnoreCase("REPORTELEMENT_TEXT")) {
                String datatext = XMLUtil.readCDATA(child);
                if (datatext.equals("")) {
                    datatext = XMLUtil.readText(child);
                }
                this.setText(datatext);
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTELEMENT_ID")) {
                this.setID(LoadXMLReportHelper.readCDATA(child));
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTELEMENT_CUSTOMID")) {
                this.setCustomID(LoadXMLReportHelper.readCDATA(child));
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTELEMENT_SCRIPT")) {
                NodeList nlist = child.getChildNodes();
                for (int j = 0; j < nlist.getLength() && !this.securityTextScript; ++j) {
                    Node grandchild = nlist.item(j);
                    if (!grandchild.getNodeName().equalsIgnoreCase("SCRIPT")) continue;
                    Script script = new Script();
                    script.readXML(grandchild, version, null, null, null);
                    this.setScriptObj(script);
                    this.securityTextScript = true;
                }
                if (this.securityTextScript) continue;
                if (version >= 70) {
                    this.setScriptName(LoadXMLReportHelper.readCDATA(child));
                    continue;
                }
                this.setScript(LoadXMLReportHelper.readCDATA(child));
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTELEMENT_SHIFTSECUREDCOLX")) {
                this.setShiftSecuredColX(LoadXMLReportHelper.parseBoolean(LoadXMLReportHelper.readText(child)));
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTELEMENT_SHIFTSECUREDCOLXINCLUDEHEADERANDFOOTER")) {
                this.setShiftSecuredColXIncludeHeaderAndFooter(LoadXMLReportHelper.parseBoolean(LoadXMLReportHelper.readText(child)));
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTELEMENT_FONTNAME")) {
                fontname = LoadXMLReportHelper.readCDATA(child);
                check4 = true;
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTELEMENT_FONTSIZE")) {
                fontsize = Integer.parseInt(LoadXMLReportHelper.readText(child));
                check5 = true;
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTELEMENT_FONTSTYLE")) {
                fontstyle = Integer.parseInt(LoadXMLReportHelper.readText(child));
                check6 = true;
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTELEMENT_VISIBLE")) {
                this.setVisible(LoadXMLReportHelper.parseBoolean(LoadXMLReportHelper.readText(child)));
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTELEMENT_BGCOLOR")) {
                this.setBgColor(new Color(Integer.parseInt(LoadXMLReportHelper.readText(child))));
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTELEMENT_FONTCOLOR")) {
                this.setFontColor(new Color(Integer.parseInt(LoadXMLReportHelper.readText(child))));
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTELEMENT_UNDERLINE")) {
                this.setUnderline(LoadXMLReportHelper.parseBoolean(LoadXMLReportHelper.readText(child)));
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTELEMENT_ALIGN")) {
                this.setAlign(Short.parseShort(LoadXMLReportHelper.readText(child)));
                check9 = true;
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTELEMENT_VALIGN")) {
                this.setVAlign(Short.parseShort(LoadXMLReportHelper.readText(child)));
                check10 = true;
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTELEMENT_NOWRAP")) {
                this.setNoWrap(LoadXMLReportHelper.parseBoolean(LoadXMLReportHelper.readText(child)));
                check11 = true;
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTELEMENT_SNAP")) {
                this.setSnap(Short.parseShort(LoadXMLReportHelper.readText(child)));
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTELEMENT_VSNAP")) {
                this.setVSnap(Short.parseShort(LoadXMLReportHelper.readText(child)));
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTELEMENT_RESIZE_TO_FIT_CONTENT") && version >= 32) {
                this.setResizeToFitContent(LoadXMLReportHelper.parseBoolean(LoadXMLReportHelper.readText(child)));
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTELEMENT_ISLOCKED") && version >= 173) {
                lock = LoadXMLReportHelper.parseBoolean(LoadXMLReportHelper.readText(child));
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTELEMENT_X")) {
                this.setXX(Double.parseDouble(LoadXMLReportHelper.readText(child)));
                check12 = true;
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTELEMENT_Y")) {
                this.setYY(Double.parseDouble(LoadXMLReportHelper.readText(child)));
                check13 = true;
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTELEMENT_Z")) {
                this.setZ(Integer.parseInt(LoadXMLReportHelper.readText(child)));
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTELEMENT_WIDTH")) {
                this.setWidth(Double.parseDouble(LoadXMLReportHelper.readText(child)));
                check14 = true;
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTELEMENT_HEIGHT")) {
                this.setHeight(Double.parseDouble(LoadXMLReportHelper.readText(child)));
                check15 = true;
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTELEMENT_BORDER")) {
                int borderThickness = Integer.parseInt(LoadXMLReportHelper.readText(child));
                this.setBorderThickness(borderThickness, borderThickness, borderThickness, borderThickness);
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTELEMENT_BORDERCOLOR")) {
                this.borderColor = new Color(Integer.parseInt(LoadXMLReportHelper.readText(child)));
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTELEMENT_STYLENAME")) {
                this.setStyleName(LoadXMLReportHelper.readCDATA(child));
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTELEMENT_LINK")) {
                this.setLink(LoadXMLReportHelper.readCDATA(child));
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTELEMENT_HINT")) {
                this.setHint(LoadXMLReportHelper.readCDATA(child));
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTELEMENT_TARGET")) {
                this.setTarget(LoadXMLReportHelper.readCDATA(child));
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTELEMENT_DRILLDOWNNAME")) {
                this.setDrillDownName(LoadXMLReportHelper.readCDATA(child));
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTELEMENT_SECURITYMAP")) {
                this.securityMap = new Hashtable();
                NodeList childList = child.getChildNodes();
                for (int j = 0; j < childList.getLength(); ++j) {
                    NamedNodeMap nnm;
                    Node grandchild = childList.item(j);
                    if (!grandchild.getNodeName().equalsIgnoreCase("REPORTELEMENT_SECURITYLEVEL") || (nnm = grandchild.getAttributes()) == null || nnm.getNamedItem("name") == null) continue;
                    Node attr = nnm.getNamedItem("name");
                    String key = attr.getNodeValue();
                    NodeList grandchildList = grandchild.getChildNodes();
                    for (int k = 0; k < grandchildList.getLength(); ++k) {
                        Node ggchild = grandchildList.item(k);
                        if (!ggchild.getNodeName().equalsIgnoreCase("REPORTCELL")) continue;
                        ReportCell level = ReportCell.createCell(ggchild, version);
                        this.securityMap.put(key, level);
                        k = grandchildList.getLength();
                    }
                }
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTELEMENT_ROTATEANGLE")) {
                this.setRotateAngle(Double.parseDouble(LoadXMLReportHelper.readText(child)), false);
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTELEMENT_ROUNDCORNERRADIUS")) {
                this.setRoundCornerRadius(Integer.parseInt(LoadXMLReportHelper.readCDATA(child)));
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTELEMENT_ROUNDCORNERSARRAY")) {
                boolean[] sRoundCornersArray = new boolean[4];
                NodeList childList = child.getChildNodes();
                int k = 0;
                for (int j = 0; j < childList.getLength(); ++j) {
                    Node grandChild = childList.item(j);
                    if (!grandChild.getNodeName().equalsIgnoreCase("REPORTELEMENT_ROUNDCORNERSARRAY_ITEM")) continue;
                    sRoundCornersArray[k] = LoadXMLReportHelper.parseBoolean(LoadXMLReportHelper.readText(grandChild));
                    ++k;
                }
                this.setRoundCornersArray(sRoundCornersArray);
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase(REPORTELEMENT_TOP_BORDER)) {
                this.setTopBorder(Integer.parseInt(LoadXMLReportHelper.readCDATA(child)));
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase(REPORTELEMENT_RIGHT_BORDER)) {
                this.setRightBorder(Integer.parseInt(LoadXMLReportHelper.readCDATA(child)));
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase(REPORTELEMENT_BOTTOM_BORDER)) {
                this.setBottomBorder(Integer.parseInt(LoadXMLReportHelper.readCDATA(child)));
                continue;
            }
            if (!child.getNodeName().equalsIgnoreCase(REPORTELEMENT_LEFT_BORDER)) continue;
            this.setLeftBorder(Integer.parseInt(LoadXMLReportHelper.readCDATA(child)));
        }
        this.setLocked(lock);
        if (check4 && check5 && check6 && check9 && check10 && check11 && check12 && check13 && check14 && check15) {
            if (fontname == null || fontstyle == -1 || fontsize == -1) {
                throw new Exception("Invalid font values.");
            }
        } else {
            throw new Exception("Missing 'REPORTELEMENT' attributes.");
        }
        this.setFont(FontTable.newFont(fontname, fontstyle, fontsize));
    }

    public void read(DataInput in, int version) throws Exception {
        boolean lock = false;
        this.setText(IOUtil.readStr(in));
        if (version > 25) {
            this.setID(IOUtil.readStr(in));
        }
        if (version >= 172) {
            this.setCustomID(IOUtil.readStr(in));
        }
        if (version >= 70) {
            if (version >= 136) {
                this.securityTextScript = in.readBoolean();
                if (this.securityTextScript) {
                    Script script = new Script();
                    script.read(in, version, null, null, null);
                    this.setScriptObj(script);
                }
            }
            if (!this.securityTextScript) {
                this.setScriptName(IOUtil.readStr(in));
            }
        } else if (version > 26) {
            this.setScript(IOUtil.readStr(in));
        }
        if (version >= 242) {
            this.setShiftSecuredColX(in.readBoolean());
        }
        if (version >= 286) {
            this.setShiftSecuredColXIncludeHeaderAndFooter(in.readBoolean());
        }
        this.setFont(IOUtil.readFont(in));
        this.setBgColor(IOUtil.readColor(in));
        this.setFontColor(IOUtil.readColor(in));
        if (version >= 178) {
            this.setUnderline(in.readBoolean());
        }
        this.setAlign(in.readShort());
        this.setVAlign(in.readShort());
        this.setNoWrap(in.readBoolean());
        if (version >= 32) {
            this.setResizeToFitContent(in.readBoolean());
        }
        if (version >= 173) {
            lock = in.readBoolean();
        }
        if (version >= 144 && version < 160 || version >= 162) {
            this.setSnap(in.readShort());
            this.setVSnap(in.readShort());
        }
        this.setXX(in.readDouble());
        this.setYY(in.readDouble());
        if (version >= 160) {
            this.setZ(in.readInt());
        }
        this.setWidth(in.readDouble());
        this.setHeight(in.readDouble());
        int borderThickness = in.readInt();
        if (version < 6605) {
            this.setBorderThickness(borderThickness, borderThickness, borderThickness, borderThickness);
        }
        this.borderColor = IOUtil.readColor(in);
        if (version >= 168) {
            this.setStyleName(IOUtil.readStr(in));
        }
        if (version >= 13) {
            this.setLink(IOUtil.readStr(in));
            this.setHint(IOUtil.readStr(in));
            this.setTarget(IOUtil.readStr(in));
        }
        if (version > 20) {
            if (version > 23) {
                this.setDrillDownName(IOUtil.readStr(in));
            } else {
                in.readInt();
            }
        }
        if (version >= 134) {
            boolean hasSecurityMap = in.readBoolean();
            if (hasSecurityMap) {
                this.securityMap = new Hashtable();
                int count = in.readInt();
                for (int i = 0; i < count; ++i) {
                    String key = IOUtil.readStr(in);
                    ReportCell cell = ReportCell.createCell(in, version);
                    this.securityMap.put(key, cell);
                }
            } else {
                this.securityMap = null;
            }
        }
        if (version >= 2001) {
            double d = in.readDouble();
            this.setRotateAngle(d, false);
        }
        if (version >= 138) {
            this.visible = in.readBoolean();
        }
        if (version >= 6601) {
            this.setRoundCornerRadius(in.readInt());
            this.setRoundCornersArray(IOUtil.readBooleans(in));
        }
        if (version >= 6605) {
            this.setTopBorder(in.readInt());
            this.setRightBorder(in.readInt());
            this.setBottomBorder(in.readInt());
            this.setLeftBorder(in.readInt());
        }
        this.setLocked(lock);
    }

    public static String getElementType(ReportElement elt) {
        if (elt instanceof ReportChartObject) {
            return "Chart";
        }
        if (elt instanceof ReportLine && !(elt instanceof ColumnWrap)) {
            return "ReportLine";
        }
        if (elt instanceof ReportGrid) {
            return "ReportGrid";
        }
        if (elt instanceof ReportImage) {
            return "Image";
        }
        if (elt instanceof ReportColumn) {
            return "Column";
        }
        if (elt instanceof ColumnHeader) {
            return "ColumnHeader";
        }
        if (elt instanceof ReportTitle) {
            return "Title";
        }
        if (elt instanceof ReportCell) {
            if (((ReportCell)elt).getFormula() != null) {
                return "Formula";
            }
            return "Label";
        }
        return null;
    }

    public static int findElementType(ReportElement elt) {
        if (elt instanceof TableOfContents) {
            return 11;
        }
        if (elt instanceof ReportChartObject) {
            return 0;
        }
        if (elt instanceof ReportLine) {
            return 2;
        }
        if (elt instanceof ReportGrid) {
            return 1;
        }
        if (elt instanceof ReportImage) {
            return 3;
        }
        if (elt instanceof SubReportObject) {
            return 9;
        }
        if (elt instanceof ReportRTFObject) {
            return 10;
        }
        if (elt instanceof ReportCell) {
            if (((ReportCell)elt).getFormula() != null) {
                return 5;
            }
            return 6;
        }
        if (elt instanceof ReportSection) {
            return 7;
        }
        if (elt instanceof ReportTableElement) {
            return 8;
        }
        return 4;
    }

    public static int findGroupElementType(ReportElement elt) {
        if (elt instanceof ReportChartObject) {
            return 3;
        }
        if (elt instanceof ReportImage && !(elt instanceof ReportLine) && !(elt instanceof ReportGrid)) {
            return 3;
        }
        if (elt instanceof ReportImage) {
            return -1;
        }
        if (elt instanceof SubReportObject) {
            return 9;
        }
        if (elt instanceof ReportRTFObject) {
            return 10;
        }
        if (elt instanceof ReportCell) {
            if (((ReportCell)elt).getFormula() != null) {
                return 5;
            }
            return 6;
        }
        if (elt instanceof ReportColumn) {
            return 4;
        }
        return -1;
    }

    public void setID(String prefix, Object[] elts) {
        String base = prefix + (prefix.equals("") ? "" : "_") + ID_TYPE[ReportElement.findElementType(this)];
        int idx = 0;
        if (elts == null || elts.length == 0) {
            this.setID(base + idx);
            return;
        }
        while (true) {
            String tmp;
            if (!this.idExists(tmp = base + idx, elts)) {
                this.setID(tmp);
                return;
            }
            ++idx;
        }
    }

    boolean idExists(String newID, Object[] elts) {
        for (Object elt : elts) {
            if (!newID.equals(((ReportElement)elt).getID())) continue;
            return true;
        }
        return false;
    }

    public static Vector<ReportElement> findSpecificElements(ReportElement[] ret, String type) {
        int size = Array.getLength(ret);
        Vector<ReportElement> temp = new Vector<ReportElement>();
        for (int i = 0; i < size; ++i) {
            ReportElement t = (ReportElement)Array.get(ret, i);
            if (!ReportElement.getElementType(t).equals(type)) continue;
            temp.addElement(t);
        }
        return temp;
    }

    public static void swapElements(ReportElement elt1, ReportElement elt2, ReportElement[] cells) {
        if (elt1.getX() > elt2.getX()) {
            ReportElement tmp = elt1;
            elt1 = elt2;
            elt2 = tmp;
        }
        double elt1W = elt1.getWidth();
        double elt1H = elt1.getHeight();
        double elt2W = elt2.getWidth();
        double elt2H = elt2.getHeight();
        ReportElement.shift(elt1, cells, true, elt2W - elt1W);
        ReportElement.shift(elt2, cells, true, elt1W - elt2W);
        ReportElement.shift(elt1, cells, false, elt2H - elt1H);
        ReportElement.shift(elt2, cells, false, elt1H - elt2H);
        double elt1X = elt1.getX();
        double elt1Y = elt1.getY();
        int elt1Z = elt1.getZ();
        double elt2X = elt2.getX();
        double elt2Y = elt2.getY();
        int elt2Z = elt2.getZ();
        elt1.setX(elt2X);
        elt1.setY(elt2Y);
        elt1.setZ(elt2Z);
        elt1.setWidth(elt1W);
        elt1.setHeight(elt1H);
        elt2.setX(elt1X);
        elt2.setY(elt1Y);
        elt2.setZ(elt1Z);
        elt2.setWidth(elt2W);
        elt2.setHeight(elt2H);
    }

    public static void shift(ReportElement elt, ReportElement[] elts, boolean isHorizontal, double change) {
        Vector<Object> temp = new Vector();
        temp = isHorizontal ? ReportElement.sortElementHorizontally(elts) : ReportElement.sortElementVertically(elts);
        int vectorIndex = 0;
        int objIndex = 0;
        int i = 0;
        int j = 0;
        for (i = 0; i < temp.size(); ++i) {
            ReportElement relt;
            ReportElement[] eltArray = (ReportElement[])temp.elementAt(i);
            int size = Array.getLength(eltArray);
            for (j = 0; j < size && (relt = (ReportElement)Array.get(eltArray, j)) != elt; ++j) {
            }
            if (j < size) break;
        }
        if (i >= temp.size()) {
            return;
        }
        vectorIndex = i;
        objIndex = j;
        if (isHorizontal) {
            elt.setWidth(elt.getWidth() + change);
        } else {
            elt.setHeight(elt.getHeight() + change);
        }
        ReportElement[] arrayFound = (ReportElement[])temp.elementAt(vectorIndex);
        for (int k = objIndex + 1; k < Array.getLength(arrayFound); ++k) {
            ReportElement rep = (ReportElement)Array.get(arrayFound, k);
            if (rep instanceof ColumnWrap || rep instanceof ReportLine && ((ReportLine)rep).previous() != null) continue;
            if (isHorizontal) {
                rep.setX(rep.getX() + change);
                continue;
            }
            rep.setY(rep.getY() + change);
        }
    }

    public static void shiftOnMove(ReportElement elt, ReportElement[] elts, boolean isHorizontal, double change) {
        Vector<Object> temp = new Vector();
        temp = isHorizontal ? ReportElement.sortElementHorizontally(elts) : ReportElement.sortElementVertically(elts);
        int vectorIndex = 0;
        int objIndex = 0;
        int i = 0;
        int j = 0;
        for (i = 0; i < temp.size(); ++i) {
            ReportElement relt;
            ReportElement[] eltArray = (ReportElement[])temp.elementAt(i);
            int size = Array.getLength(eltArray);
            for (j = 0; j < size && (relt = (ReportElement)Array.get(eltArray, j)) != elt; ++j) {
            }
            if (j < size) break;
        }
        if (i >= temp.size()) {
            return;
        }
        vectorIndex = i;
        objIndex = j;
        if (isHorizontal) {
            elt.setX(elt.getX() + change);
        } else {
            elt.setY(elt.getY() + change);
        }
        ReportElement[] arrayFound = (ReportElement[])temp.elementAt(vectorIndex);
        for (int k = objIndex + 1; k < Array.getLength(arrayFound); ++k) {
            ReportElement rep = (ReportElement)Array.get(arrayFound, k);
            if (rep instanceof ColumnWrap) continue;
            if (isHorizontal) {
                rep.setX(rep.getX() + change);
                continue;
            }
            rep.setY(rep.getY() + change);
        }
    }

    public static void resizeForCrossTabFixedField(Vector<ReportElement> resizeItems, ReportElement[] elts, double ratioW, double ratioH, double startXD, double startYD) {
        Vector<ReportElement[]> temp = ReportElement.sortElementHorizontally(elts);
        int i = 0;
        int j = 0;
        for (i = 0; i < temp.size(); ++i) {
            ReportElement relt;
            boolean resizeH = false;
            boolean applyToAllCrossTabElts = false;
            Vector<ReportElement> resizeHList = new Vector<ReportElement>();
            ReportElement[] eltArray = temp.elementAt(i);
            int size = Array.getLength(eltArray);
            double deltaH = 0.0;
            block1: for (j = 0; j < size; ++j) {
                relt = (ReportElement)Array.get(eltArray, j);
                for (int k = 0; k < resizeItems.size(); ++k) {
                    ReportElement e = resizeItems.elementAt(k);
                    if (!relt.getID().equals(e.getID())) continue;
                    double backupX = e.getX();
                    double backupY = e.getY();
                    double backupW = e.getWidth();
                    double backupH = e.getHeight();
                    if (!resizeH) {
                        double offsetY = e.getY() - startYD;
                        e.setY(startYD + offsetY * ratioH);
                        e.setHeight(e.getHeight() * ratioH);
                        if (e.getHeight() != backupH) {
                            deltaH = e.getHeight() - backupH;
                            e.setY(backupY);
                            e.setHeight(backupH);
                            resizeH = true;
                        }
                    }
                    if (resizeH) {
                        if (!applyToAllCrossTabElts) {
                            applyToAllCrossTabElts = ReportElement.isCrossTabElt(e);
                        }
                        resizeHList.add(e);
                    }
                    double offsetX = e.getX() - startXD;
                    e.setX(startXD + offsetX * ratioW);
                    e.setWidth(e.getWidth() * ratioW);
                    if (e.getWidth() == backupW) continue block1;
                    double delta = e.getWidth() - backupW;
                    if (j >= 1) {
                        ReportElement prevE = (ReportElement)Array.get(eltArray, j - 1);
                        if (backupX != e.getX()) {
                            delta += prevE.getX() + prevE.getWidth() - e.getX();
                            e.setX(prevE.getX() + prevE.getWidth());
                        }
                    }
                    for (int l = j + 1; l < size; ++l) {
                        ReportElement relt2 = (ReportElement)Array.get(eltArray, l);
                        relt2.setX(relt2.getX() + delta);
                    }
                    continue block1;
                }
            }
            if (!resizeH) continue;
            if (applyToAllCrossTabElts) {
                for (j = 0; j < size; ++j) {
                    relt = (ReportElement)Array.get(eltArray, j);
                    if (!ReportElement.isCrossTabElt(relt) && !ReportElement.contains(relt, resizeHList)) continue;
                    double offsetY = relt.getY() - startYD;
                    relt.setY(startYD + offsetY * ratioH);
                    relt.setHeight(relt.getHeight() * ratioH);
                }
                for (int k = i + 1; k < temp.size(); ++k) {
                    ReportElement[] eltArray2 = temp.elementAt(k);
                    size = Array.getLength(eltArray2);
                    for (j = 0; j < size; ++j) {
                        ReportElement tmpElt = (ReportElement)Array.get(eltArray2, j);
                        tmpElt.setY(tmpElt.getY() + deltaH);
                    }
                }
                continue;
            }
            for (j = 0; j < resizeHList.size(); ++j) {
                relt = (ReportElement)resizeHList.elementAt(j);
                double offsetY = relt.getY() - startYD;
                relt.setY(startYD + offsetY * ratioH);
                relt.setHeight(relt.getHeight() * ratioH);
            }
        }
    }

    public static boolean contains(ReportElement elt, Vector<ReportElement> eltList) {
        for (int i = 0; i < eltList.size(); ++i) {
            if (!elt.getID().equals(eltList.elementAt(i).getID())) continue;
            return true;
        }
        return false;
    }

    public static void resizeForCrossTabFixedField(ReportElement resizeItem, ReportElement[] elts, double newW, double newH) {
        Vector<ReportElement[]> temp = ReportElement.sortElementHorizontally(elts);
        int i = 0;
        int j = 0;
        boolean foundIt = false;
        for (i = 0; i < temp.size(); ++i) {
            ReportElement relt;
            boolean resizeH = false;
            boolean applyToAllCrossTabElts = false;
            Vector<ReportElement> resizeHList = new Vector<ReportElement>();
            ReportElement[] eltArray = temp.elementAt(i);
            int size = Array.getLength(eltArray);
            double deltaH = 0.0;
            for (j = 0; j < size; ++j) {
                relt = (ReportElement)Array.get(eltArray, j);
                ReportElement e = resizeItem;
                if (!relt.getID().equals(e.getID())) continue;
                foundIt = true;
                if (newH != e.getHeight()) {
                    deltaH = newH - e.getHeight();
                    resizeH = true;
                }
                if (resizeH) {
                    if (!applyToAllCrossTabElts) {
                        applyToAllCrossTabElts = ReportElement.isCrossTabElt(e);
                    }
                    resizeHList.add(e);
                }
                if (e.getWidth() == newW) break;
                double delta = newW - e.getWidth();
                e.setWidth(newW);
                for (int l = j + 1; l < size; ++l) {
                    ReportElement relt2 = (ReportElement)Array.get(eltArray, l);
                    relt2.setX(relt2.getX() + delta);
                    if (!ReportElement.sameClass(e, relt2)) continue;
                    delta += newW - relt2.getWidth();
                    relt2.setWidth(newW);
                }
                break;
            }
            if (resizeH) {
                if (applyToAllCrossTabElts) {
                    for (j = 0; j < size; ++j) {
                        relt = (ReportElement)Array.get(eltArray, j);
                        if (!ReportElement.isCrossTabElt(relt) && !ReportElement.contains(relt, resizeHList)) continue;
                        relt.setHeight(newH);
                    }
                    for (int k = i + 1; k < temp.size(); ++k) {
                        ReportElement[] eltArray2 = temp.elementAt(k);
                        size = Array.getLength(eltArray2);
                        for (j = 0; j < size; ++j) {
                            ReportElement tmpElt = (ReportElement)Array.get(eltArray2, j);
                            tmpElt.setY(tmpElt.getY() + deltaH);
                        }
                    }
                } else {
                    for (j = 0; j < resizeHList.size(); ++j) {
                        relt = (ReportElement)resizeHList.elementAt(j);
                        relt.setHeight(newH);
                    }
                }
                break;
            }
            if (!foundIt) continue;
            return;
        }
    }

    private static boolean sameClass(ReportElement e1, ReportElement e2) {
        if (e1 instanceof ColumnBreakColumn && e2 instanceof ColumnBreakColumn) {
            return true;
        }
        if (e1 instanceof ColumnBreakColumn && e2 instanceof ColumnBreakColumn) {
            return true;
        }
        if (e1 instanceof CBAggrColumn && e2 instanceof CBAggrColumn && ((CBAggrColumn)e1).getColBreakLevel() == ((CBAggrColumn)e2).getColBreakLevel()) {
            return true;
        }
        if (e1 instanceof CBAggrColFooter && e2 instanceof CBAggrColFooter && ((CBAggrColFooter)e1).getColBreakLevel() == ((CBAggrColFooter)e2).getColBreakLevel()) {
            return true;
        }
        if (e1 instanceof CBAggrColHeader && e2 instanceof CBAggrColHeader && ((CBAggrColHeader)e1).getColBreakLevel() == ((CBAggrColHeader)e2).getColBreakLevel()) {
            return true;
        }
        if (e1 instanceof CBColumnFooter && e2 instanceof CBColumnFooter) {
            return true;
        }
        if (e1 instanceof CBColumnHeader && e2 instanceof CBColumnHeader) {
            return true;
        }
        return e1 instanceof RBColumnHeader && e2 instanceof RBColumnHeader && ((RBColumnHeader)e1).getColBreakLevel() == ((RBColumnHeader)e2).getColBreakLevel();
    }

    public static void moveForCrossTabFixedField(ReportElement elt, ReportElement[] elts, boolean isHorizontal, double change) {
        Vector<ReportElement> groupFormat = new Vector<ReportElement>();
        groupFormat.add(elt);
        ReportElement.moveForCrossTabFixedField(groupFormat, elts, isHorizontal, change);
    }

    public static void moveForCrossTabFixedField(Vector<ReportElement> groupFormat, ReportElement[] elts, boolean isHorizontal, double change) {
        try {
            Vector<ReportElement[]> temp = ReportElement.sortElementHorizontally(elts);
            if (isHorizontal) {
                Vector<ReportElement> selectedEltHead = ReportElement.getMostLeftEltList(groupFormat, temp);
                for (int i = 0; i < selectedEltHead.size(); ++i) {
                    ReportElement elt = selectedEltHead.elementAt(i);
                    ReportElement.moveForCrossTabFixedFieldHorzontally(temp, elt, change, groupFormat);
                }
            } else if (change <= 0.0) {
                ReportElement.moveForCrossTabFixedFieldVertically(temp, ReportElement.getTopOrBottomLeftGroupFormat(groupFormat, true), change);
            } else {
                ReportElement.moveForCrossTabFixedFieldVertically(temp, ReportElement.getTopOrBottomLeftGroupFormat(groupFormat, false), change);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static Vector<ReportElement> getMostLeftEltList(Vector<ReportElement> groupFormat, Vector<ReportElement[]> sortedTbl) {
        Vector<ReportElement> res = new Vector<ReportElement>();
        block0: for (int r = 0; r < sortedTbl.size(); ++r) {
            ReportElement[] eltArray = sortedTbl.elementAt(r);
            int size = Array.getLength(eltArray);
            for (int j = 0; j < size; ++j) {
                ReportElement relt = (ReportElement)Array.get(eltArray, j);
                boolean isSelected = false;
                for (int k = 0; k < groupFormat.size(); ++k) {
                    if (relt != groupFormat.elementAt(k)) continue;
                    isSelected = true;
                    break;
                }
                if (!isSelected) continue;
                res.add(relt);
                if (ReportElement.isCrossTabElt(relt)) continue block0;
            }
        }
        return res;
    }

    private static ReportElement getTopOrBottomLeftGroupFormat(Vector<ReportElement> groupFormat, boolean bottom) {
        ReportElement selObj = null;
        for (int i = 0; i < groupFormat.size(); ++i) {
            ReportElement tmpObj = groupFormat.get(i);
            if (selObj == null) {
                selObj = tmpObj;
                continue;
            }
            if (tmpObj.getX() < selObj.getX()) {
                selObj = tmpObj;
                continue;
            }
            if (!(bottom && tmpObj.getY() > selObj.getY()) && (bottom || !(tmpObj.getY() < selObj.getY()))) continue;
            selObj = tmpObj;
        }
        return selObj;
    }

    public static boolean isCrossTabElt(ReportElement elt) {
        return elt instanceof CBAggrColFooter || elt instanceof CBAggrColHeader || elt instanceof CBAggrColumn || elt instanceof CBColumnFooter || elt instanceof CBColumnHeader || elt instanceof RBColumnHeader || elt instanceof ColumnBreakColumn;
    }

    private static void moveForCrossTabFixedFieldHorzontally(Vector<ReportElement[]> temp, ReportElement elt, double change, Vector<ReportElement> groupFormat) throws Exception {
        int k;
        int vectorIndex = 0;
        int objIndex = 0;
        int i = 0;
        int j = 0;
        boolean eltFound = false;
        int firstCrossTabIndex = -1;
        for (i = 0; i < temp.size(); ++i) {
            ReportElement[] eltArray = temp.elementAt(i);
            int size = Array.getLength(eltArray);
            firstCrossTabIndex = -1;
            for (j = 0; j < size; ++j) {
                ReportElement relt = (ReportElement)Array.get(eltArray, j);
                if (firstCrossTabIndex == -1 && ReportElement.isCrossTabElt(relt) && ReportElement.isCrossTabElt(elt)) {
                    firstCrossTabIndex = j;
                }
                if (relt != elt) continue;
                if (firstCrossTabIndex < 0) break;
                j = firstCrossTabIndex;
                elt = (ReportElement)Array.get(eltArray, j);
                break;
            }
            if (j < size) break;
        }
        if (i < temp.size() && firstCrossTabIndex >= 0) {
            eltFound = true;
            vectorIndex = i;
            objIndex = j;
        }
        elt.setX(elt.getX() + change);
        if (!eltFound) {
            return;
        }
        ReportElement[] arrayFound = temp.elementAt(vectorIndex);
        for (k = objIndex + 1; k < Array.getLength(arrayFound); ++k) {
            ReportElement rep = (ReportElement)Array.get(arrayFound, k);
            if (rep instanceof ColumnWrap || !ReportElement.isSelected(groupFormat, rep)) continue;
            rep.setX(rep.getX() + change);
        }
        for (k = objIndex + 1; k < Array.getLength(arrayFound); ++k) {
            ReportElement prev = (ReportElement)Array.get(arrayFound, k - 1);
            ReportElement rep = (ReportElement)Array.get(arrayFound, k);
            if (rep instanceof ColumnWrap || ReportElement.isSelected(groupFormat, rep) || !(rep.getX() < prev.getX() + prev.getWidth())) continue;
            rep.setX(prev.getX() + prev.getWidth());
        }
    }

    private static boolean isSelected(Vector<ReportElement> groupFormat, ReportElement rep) {
        if (groupFormat == null) {
            return false;
        }
        for (int i = 0; i < groupFormat.size(); ++i) {
            if (rep != groupFormat.elementAt(i)) continue;
            return true;
        }
        return false;
    }

    private static void moveForCrossTabFixedFieldVertically(Vector<ReportElement[]> temp, ReportElement elt, double change) throws Exception {
        ReportElement[] eltArray;
        int vectorIndex = 0;
        int i = 0;
        int j = 0;
        for (i = 0; i < temp.size(); ++i) {
            ReportElement relt;
            eltArray = temp.elementAt(i);
            int size = Array.getLength(eltArray);
            for (j = 0; j < size && (relt = (ReportElement)Array.get(eltArray, j)) != elt; ++j) {
            }
            if (j < size) break;
        }
        if (i >= temp.size()) {
            return;
        }
        vectorIndex = i;
        if (change < 0.0) {
            double min = 0.0;
            for (i = 0; i <= vectorIndex; ++i) {
                ReportElement[] eltArray2 = temp.elementAt(i);
                for (j = 0; j < Array.getLength(eltArray2); ++j) {
                    ReportElement rep = (ReportElement)Array.get(eltArray2, j);
                    if (rep instanceof ColumnWrap) continue;
                    if (rep.getY() + change < min) {
                        rep.setY(min);
                    } else {
                        rep.setY(rep.getY() + change);
                    }
                    if (j + 1 != Array.getLength(eltArray2)) continue;
                    min = rep.getY() + rep.getHeight();
                }
            }
        } else {
            for (i = vectorIndex; i < temp.size(); ++i) {
                eltArray = temp.elementAt(i);
                for (j = 0; j < Array.getLength(eltArray); ++j) {
                    ReportElement rep = (ReportElement)Array.get(eltArray, j);
                    if (rep instanceof ColumnWrap) continue;
                    rep.setY(rep.getY() + change);
                }
            }
        }
    }

    public static void shiftObjectsOnMove(ReportElement elt, ReportElement[] elts, boolean isHorizontal, double change) {
        Vector<Object> temp = new Vector();
        temp = isHorizontal ? ReportElement.sortElementHorizontally(elts) : ReportElement.sortElementVertically(elts);
        int vectorIndex = 0;
        int objIndex = 0;
        int i = 0;
        int j = 0;
        for (i = 0; i < temp.size(); ++i) {
            ReportElement relt;
            ReportElement[] eltArray = (ReportElement[])temp.elementAt(i);
            int size = Array.getLength(eltArray);
            for (j = 0; j < size && (relt = (ReportElement)Array.get(eltArray, j)) != elt; ++j) {
            }
            if (j < size) break;
        }
        if (i >= temp.size()) {
            return;
        }
        vectorIndex = i;
        objIndex = j;
        ReportElement[] arrayFound = (ReportElement[])temp.elementAt(vectorIndex);
        for (int k = objIndex + 1; k < Array.getLength(arrayFound); ++k) {
            ReportElement rep = (ReportElement)Array.get(arrayFound, k);
            if (rep instanceof ColumnWrap) continue;
            if (isHorizontal) {
                rep.setX(rep.getX() + change);
                continue;
            }
            rep.setY(rep.getY() + change);
        }
    }

    public static int findMinX(ReportElement[] elt) {
        int minX = 0;
        for (int i = 0; i < Array.getLength(elt); ++i) {
            ReportElement t = (ReportElement)Array.get(elt, i);
            int x = QbUtil.toPixel(t.getX());
            if (i == 0) {
                minX = x;
            }
            if (x > minX) continue;
            minX = x;
        }
        return minX;
    }

    public static int findMaxXr(ReportElement[] elt) {
        int maxXr = 0;
        for (int i = 0; i < Array.getLength(elt); ++i) {
            ReportElement t = (ReportElement)Array.get(elt, i);
            int x = QbUtil.toPixel(t.getX() + t.getWidth());
            if (i == 0) {
                maxXr = x;
            }
            if (x < maxXr) continue;
            maxXr = x;
        }
        return maxXr;
    }

    public static double getMinX(ReportElement[] elt) {
        double minX = 0.0;
        for (int i = 0; i < Array.getLength(elt); ++i) {
            ReportElement t = (ReportElement)Array.get(elt, i);
            double x = t.getX();
            if (i == 0) {
                minX = x;
            }
            if (!(x <= minX)) continue;
            minX = x;
        }
        return minX;
    }

    public static double getMaxXr(ReportElement[] elt) {
        double maxXr = 0.0;
        for (int i = 0; i < Array.getLength(elt); ++i) {
            ReportElement t = (ReportElement)Array.get(elt, i);
            double x = t.getX() + t.getWidth();
            if (i == 0) {
                maxXr = x;
            }
            if (!(x >= maxXr)) continue;
            maxXr = x;
        }
        return maxXr;
    }

    public static int findMinY(ReportElement[] elt) {
        int minY = 0;
        for (int i = 0; i < Array.getLength(elt); ++i) {
            ReportElement t = (ReportElement)Array.get(elt, i);
            int y = QbUtil.toPixel(t.getY());
            if (i == 0) {
                minY = y;
            }
            if (y > minY) continue;
            minY = y;
        }
        return minY;
    }

    public static int findMaxYd(ReportElement[] elt) {
        int maxYd = 0;
        for (int i = 0; i < Array.getLength(elt); ++i) {
            ReportElement t = (ReportElement)Array.get(elt, i);
            int y = QbUtil.toPixel(t.getY() + t.getHeight());
            if (i == 0) {
                maxYd = y;
            }
            if (y < maxYd) continue;
            maxYd = y;
        }
        return maxYd;
    }

    public static ReportElement[] findElementsToRight(ReportElement r, ReportElement[] ret) {
        int minX = QbUtil.toPixel(r.getX());
        int minY = QbUtil.toPixel(r.getY());
        int maxYd = QbUtil.toPixel(r.getY() + r.getHeight());
        Vector<ReportElement> temp = new Vector<ReportElement>();
        int maxXr = minX + QbUtil.toPixel(r.getWidth() / 2.0);
        for (int j = 0; j < Array.getLength(ret); ++j) {
            ReportElement rt = (ReportElement)Array.get(ret, j);
            int xL = QbUtil.toPixel(rt.getX());
            int yU = QbUtil.toPixel(rt.getY());
            int yD = QbUtil.toPixel(rt.getY() + rt.getHeight());
            if (!(xL >= maxXr && minY < yU && yU < maxYd || xL >= maxXr && minY < yD && yD < maxYd) && (xL < maxXr || yU != minY && yD != maxYd)) continue;
            temp.addElement(rt);
        }
        Vector<ReportElement> temp1 = new Vector<ReportElement>();
        for (int j = 0; j < temp.size(); ++j) {
            ReportElement l = (ReportElement)temp.elementAt(j);
            if (l.equals(r)) continue;
            temp1.addElement(l);
        }
        ReportElement[] rpt = new ReportElement[temp1.size()];
        for (int k = 0; k < temp1.size(); ++k) {
            ReportElement l;
            rpt[k] = l = (ReportElement)temp1.elementAt(k);
        }
        return rpt;
    }

    public static Vector<ReportElement> findElementsToRight(ReportElement[] r, ReportElement[] ret) {
        int minY = ReportElement.findMinY(r);
        int maxXr = ReportElement.findMaxXr(r);
        int maxYd = ReportElement.findMaxYd(r);
        Vector<ReportElement> temp = new Vector<ReportElement>();
        for (int j = 0; j < Array.getLength(ret); ++j) {
            ReportElement rt = (ReportElement)Array.get(ret, j);
            int xL = QbUtil.toPixel(rt.getX());
            int yU = QbUtil.toPixel(rt.getY());
            int yD = QbUtil.toPixel(rt.getY() + rt.getHeight());
            if (!(xL >= maxXr && minY < yU && yU < maxYd || xL >= maxXr && minY < yD && yD < maxYd || xL >= maxXr && (yU == minY || yD == maxYd)) && (xL < maxXr || yU >= minY || yD <= maxYd)) continue;
            temp.addElement(rt);
        }
        return temp;
    }

    public static ReportElement[] findElementsToLeft(ReportElement r, ReportElement[] ret) {
        int minX = QbUtil.toPixel(r.getX());
        int minY = QbUtil.toPixel(r.getY());
        int maxYd = QbUtil.toPixel(r.getY() + r.getHeight());
        Vector<ReportElement> temp = new Vector<ReportElement>();
        minX += QbUtil.toPixel(r.getWidth() / 2.0);
        for (int j = 0; j < Array.getLength(ret); ++j) {
            ReportElement rt = (ReportElement)Array.get(ret, j);
            int xR = QbUtil.toPixel(rt.getX() + rt.getWidth());
            int yU = QbUtil.toPixel(rt.getY());
            int yD = QbUtil.toPixel(rt.getY() + rt.getHeight());
            if (!(xR <= minX && minY < yU && yU < maxYd || xR <= minX && minY < yD && yD < maxYd) && (xR > minX || yU != minY && yD != maxYd)) continue;
            temp.addElement(rt);
        }
        Vector<ReportElement> temp1 = new Vector<ReportElement>();
        for (int j = 0; j < temp.size(); ++j) {
            ReportElement l = (ReportElement)temp.elementAt(j);
            if (l.equals(r)) continue;
            temp1.addElement(l);
        }
        ReportElement[] rpt = new ReportElement[temp1.size()];
        for (int k = 0; k < temp1.size(); ++k) {
            ReportElement l;
            rpt[k] = l = (ReportElement)temp1.elementAt(k);
        }
        return rpt;
    }

    public static ReportElement[] findElementsAbove(ReportElement r, ReportElement[] ret) {
        int minX = QbUtil.toPixel(r.getX());
        int minY = QbUtil.toPixel(r.getY());
        int maxXr = QbUtil.toPixel(r.getX() + r.getWidth());
        Vector<ReportElement> temp = new Vector<ReportElement>();
        minY = QbUtil.toPixel(r.getHeight() / 2.0) + minY;
        for (int j = 0; j < Array.getLength(ret); ++j) {
            ReportElement rt = (ReportElement)Array.get(ret, j);
            int xL = QbUtil.toPixel(rt.getX());
            int xR = QbUtil.toPixel(rt.getX() + rt.getWidth());
            int yD = QbUtil.toPixel(rt.getY() + rt.getHeight());
            if (!(yD <= minY && minX < xL && xL < maxXr || yD <= minY && minX < xR && xR < maxXr) && (yD > minY || xL != minX && xR != maxXr)) continue;
            temp.addElement(rt);
        }
        Vector<ReportElement> temp1 = new Vector<ReportElement>();
        for (int j = 0; j < temp.size(); ++j) {
            ReportElement l = (ReportElement)temp.elementAt(j);
            if (l.equals(r)) continue;
            temp1.addElement(l);
        }
        ReportElement[] rpt = new ReportElement[temp1.size()];
        for (int k = 0; k < temp1.size(); ++k) {
            ReportElement l;
            rpt[k] = l = (ReportElement)temp1.elementAt(k);
        }
        return rpt;
    }

    static ReportElement[] findElementsBelow(ReportElement r, ReportElement[] ret) {
        int minX = QbUtil.toPixel(r.getX());
        int maxXr = QbUtil.toPixel(r.getX() + r.getWidth());
        int maxYd = QbUtil.toPixel(r.getY() + r.getHeight());
        Vector<ReportElement> temp = new Vector<ReportElement>();
        for (int j = 0; j < Array.getLength(ret); ++j) {
            ReportElement rt = (ReportElement)Array.get(ret, j);
            int xL = QbUtil.toPixel(rt.getX());
            int xR = QbUtil.toPixel(rt.getX() + rt.getWidth());
            int yU = QbUtil.toPixel(rt.getY());
            if (rt.equals(r) || yU < maxYd || (xL >= minX || xR <= minX) && (xL < minX || xL >= maxXr)) continue;
            temp.addElement(rt);
        }
        ReportElement[] rpt = new ReportElement[temp.size()];
        for (int k = 0; k < temp.size(); ++k) {
            ReportElement l;
            rpt[k] = l = (ReportElement)temp.elementAt(k);
        }
        return rpt;
    }

    public static Vector<ReportElement> findElementsBelow(ReportElement[] r, ReportElement[] ret) {
        int minX = ReportElement.findMinX(r);
        int maxXr = ReportElement.findMaxXr(r);
        int maxYd = ReportElement.findMaxYd(r);
        Vector<ReportElement> temp = new Vector<ReportElement>();
        for (int j = 0; j < Array.getLength(ret); ++j) {
            ReportElement rt = (ReportElement)Array.get(ret, j);
            int xL = QbUtil.toPixel(rt.getX());
            int xR = QbUtil.toPixel(rt.getX() + rt.getWidth());
            int yU = QbUtil.toPixel(rt.getY());
            if (!(yU >= maxYd && minX < xL && xL < maxXr || yU >= maxYd && minX < xR && xR < maxXr || yU >= maxYd && (xL == minX || xR == maxXr)) && (yU < maxYd || xL >= minX || xR <= maxXr)) continue;
            temp.addElement(rt);
        }
        return temp;
    }

    static void resizeHorizontallyAndShift(ReportElement r, ReportElement[] ret, double widthChange) {
        ReportElement[] eltArray = ReportElement.findElementsToRight(r, ret);
        if (Array.getLength(eltArray) == 0) {
            return;
        }
        for (int j = 0; j < Array.getLength(eltArray); ++j) {
            ReportElement elt = (ReportElement)Array.get(eltArray, j);
            elt.setX(elt.getX() + widthChange);
        }
        r.setWidth(r.getWidth() + widthChange);
    }

    static void resizeVerticallyAndShift(ReportElement r, ReportElement[] ret, double heightChange) {
        ReportElement[] eltArray1 = ReportElement.findElementsBelow(r, ret);
        for (int j = 0; j < Array.getLength(eltArray1); ++j) {
            ReportElement elt = (ReportElement)Array.get(eltArray1, j);
            elt.setYY(elt.getY() + heightChange, true);
        }
        r.setHeight(r.getHeight() + heightChange);
    }

    public void applyImageTemplate(ReportElement _elt) {
        this.setWidth(_elt.getWidth());
        this.setHeight(_elt.getHeight());
        this.setBorderThickness(_elt);
        this.borderColor = _elt.getBorderColor();
    }

    public void applyImageTemplateExceptBound(ReportElement _elt) {
        this.setBorderThickness(_elt);
        this.borderColor = _elt.getBorderColor();
    }

    public void setBorderThickness(ReportElement elt) {
        this.topBorder = elt.getTopBorder();
        this.rightBorder = elt.getRightBorder();
        this.bottomBorder = elt.getBottomBorder();
        this.leftBorder = elt.getLeftBorder();
    }

    public boolean scriptReferenced(Script s) {
        if (this.scriptObj == s) {
            return true;
        }
        if (this.securityMap != null) {
            Enumeration<String> enum1 = this.securityMap.keys();
            while (enum1.hasMoreElements()) {
                if (!this.securityMap.get(enum1.nextElement()).scriptReferenced(s)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean securityScriptReferenced(Script s) {
        if (this.securityMap != null) {
            Enumeration<String> enum1 = this.securityMap.keys();
            while (enum1.hasMoreElements()) {
                if (!this.securityMap.get(enum1.nextElement()).scriptReferenced(s)) continue;
                return true;
            }
        }
        return false;
    }

    public void removeScriptReferenced(Script s) {
        if (this.scriptObj == s) {
            this.setScriptObj(null);
            this.setScriptName(null);
            this.setScript(null);
        }
    }

    public void createScriptObject(Vector<Script> scripts) {
        if (this.scriptObj == null && this.script != null) {
            try {
                String name = "script" + (scripts.size() + 1);
                this.scriptObj = new Script(name, this.script);
                scripts.addElement(this.scriptObj);
                ByteArrayInputStream inputStream = new ByteArrayInputStream(this.script.getBytes("UTF-8"));
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)inputStream, "UTF-8");
                NewScriptParser parser = new NewScriptParser(inputStreamReader);
                this.scriptObj.setScript(parser.parse(null, null, null, name, null));
            }
            catch (Throwable e) {
                System.out.println(this.script);
                System.out.println(e);
            }
        }
        if (this.securityMap != null) {
            Enumeration<String> keys = this.securityMap.keys();
            while (keys.hasMoreElements()) {
                this.securityMap.get(keys.nextElement()).createScriptObject(scripts);
            }
        }
    }

    public void createScriptObjectFromName(Vector<Script> scripts) {
        if (this.scriptName != null) {
            for (int i = 0; i < scripts.size(); ++i) {
                Script s = scripts.elementAt(i);
                if (!this.scriptName.equals(s.getName())) continue;
                this.setScriptObj(s);
                i = scripts.size();
            }
        }
        if (this.securityMap != null) {
            Enumeration<String> keys = this.securityMap.keys();
            while (keys.hasMoreElements()) {
                this.securityMap.get(keys.nextElement()).createScriptObjectFromName(scripts);
            }
        }
    }

    public boolean isSnapToGrid() {
        return this.snapToGrid;
    }

    public void setSnapToGrid(boolean snapToGrid, double stepSize, double cmStepSize) {
        this.snapToGrid = snapToGrid;
        this.inchGridSpace = stepSize;
        QbUtil.setCM_UNIT(cmStepSize);
    }

    public void setSnapToGrid(boolean snapToGrid, boolean metric, double stepSize) {
        this.snapToGrid = snapToGrid;
        this.metric = metric;
        if (!metric) {
            this.inchGridSpace = stepSize;
        } else {
            QbUtil.setCM_UNIT(stepSize);
        }
    }

    public void setInchGridSpace(double space) {
        this.inchGridSpace = space;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean b) {
        this.visible = b;
    }

    public boolean isSecurityLevelDefined() {
        return this.securityMap != null && this.securityMap.size() != 0;
    }

    public ReportElement addSecurityLevel(String levelName) {
        if (levelName == null) {
            return null;
        }
        if (this.securityMap == null) {
            this.securityMap = new Hashtable();
        }
        ReportCell newLevel = new ReportCell();
        newLevel.copy(this);
        this.securityMap.put(levelName, newLevel);
        return newLevel;
    }

    public ReportElement getSecurityLevel(String levelName) {
        if (levelName == null || this.securityMap == null) {
            return null;
        }
        return this.securityMap.get(levelName);
    }

    public void removeSecurityLevel(String levelName) {
        if (levelName == null || this.securityMap == null) {
            return;
        }
        this.securityMap.remove(levelName);
    }

    public String[] getSecurityLevels() {
        if (this.securityMap == null) {
            return new String[0];
        }
        Enumeration<String> enum1 = this.securityMap.keys();
        String[] ret = new String[this.securityMap.size()];
        int i = 0;
        while (enum1.hasMoreElements()) {
            ret[i] = enum1.nextElement();
            ++i;
        }
        return ret;
    }

    public String[] getSecuredScripts() {
        if (this.securityMap == null) {
            return new String[0];
        }
        Enumeration<String> enum1 = this.securityMap.keys();
        Vector<String> ret = new Vector<String>();
        while (enum1.hasMoreElements()) {
            ReportElement level = this.securityMap.get(enum1.nextElement());
            if (level == null || level.getScriptName() == null || ret.contains(level.getScriptName())) continue;
            ret.addElement(level.getScriptName());
        }
        String[] scripts = new String[ret.size()];
        for (int i = 0; i < ret.size(); ++i) {
            scripts[i] = (String)ret.elementAt(i);
        }
        return scripts;
    }

    public void setSecurityLevelProperties(String levelName, ReportElement level) {
        if (this.securityMap == null) {
            return;
        }
        ReportElement myLevel = this.getSecurityLevel(levelName);
        if (myLevel != null) {
            myLevel.copy(level);
        }
    }

    public void setSecurityMap(Hashtable<String, ReportElement> table) {
        this.securityMap = table;
    }

    protected Hashtable<String, ReportElement> getSecurityMap() {
        return this.securityMap;
    }

    public void switchSecurityProperties(ReportElement element) {
        if (element == null) {
            return;
        }
        boolean old_visible = element.isVisible();
        boolean old_securityTextScript = element.isSecurityTextScript();
        boolean old_shiftSecuredColX = element.isShiftSecuredColX();
        boolean old_shiftSecuredColXIncludeHeaderAndFooter = element.isShiftSecuredColXIncludeHeaderAndFooter();
        String old_script = element.getScript();
        String old_scriptName = element.getScriptName();
        Script old_scriptObj = element.getScriptObj();
        element.setVisible(this.isVisible());
        element.setSecurityTextScript(this.isSecurityTextScript());
        element.setScript(this.getScript());
        element.setScriptName(this.getScriptName());
        element.setScriptObj(this.getScriptObj());
        this.setVisible(old_visible);
        this.setSecurityTextScript(old_securityTextScript);
        this.setShiftSecuredColX(old_shiftSecuredColX);
        this.setShiftSecuredColXIncludeHeaderAndFooter(old_shiftSecuredColXIncludeHeaderAndFooter);
        this.setScript(old_script);
        this.setScriptName(old_scriptName);
        this.setScriptObj(old_scriptObj);
    }

    public void setBookmark(String bookmark) {
        this.bookmark = bookmark;
    }

    public String getBookmark() {
        return this.bookmark;
    }

    public int getZ() {
        return this.z;
    }

    public void setZ(int z) {
        this.z = z < 0 ? 0 : z;
    }

    public void setDrawAgain(boolean b) {
        this.drawAgain = b;
    }

    public boolean isDrawAgain() {
        return this.drawAgain;
    }

    public double getDrawX() {
        return this.drawX;
    }

    public void setDrawX(double drawX) {
        this.drawX = drawX;
    }

    public double getDrawY() {
        return this.drawY;
    }

    public void setDrawY(double drawY) {
        this.drawY = drawY;
    }

    public void newArrayY(int nRow) {
        this.arrayY = new double[nRow];
        for (int i = 0; i < nRow; ++i) {
            this.arrayY[i] = -1.0;
        }
    }

    public void newArrayX(int nRow) {
        this.arrayX = new double[nRow];
        for (int i = 0; i < nRow; ++i) {
            this.arrayX[i] = -1.0;
        }
    }

    public double getDrawY(int i) {
        if (this.arrayY != null && this.arrayY.length > i) {
            return this.arrayY[i];
        }
        return 0.0;
    }

    public double getDrawX(int i) {
        if (this.arrayX != null && this.arrayX.length > i) {
            return this.arrayX[i];
        }
        return 0.0;
    }

    public void setDrawY(int i, double y) {
        if (this.arrayY != null && this.arrayY.length > i) {
            this.arrayY[i] = y;
        }
    }

    public void setDrawX(int i, double x) {
        if (this.arrayX != null && this.arrayX.length > i) {
            this.arrayX[i] = x;
        }
    }

    public void renameSecurityLevel(String oldName, String newName) {
        if (oldName == null || this.securityMap == null) {
            return;
        }
        Enumeration<String> enum1 = this.securityMap.keys();
        while (enum1.hasMoreElements()) {
            String securityLevelName = enum1.nextElement();
            if (!securityLevelName.equals(oldName)) continue;
            ReportElement level = this.securityMap.get(oldName);
            this.removeSecurityLevel(oldName);
            this.securityMap.put(newName, level);
        }
    }

    public double getRotateAngle() {
        return this.rotate_angle;
    }

    public void setRotateAngle(double rotate_angle) {
        this.setRotateAngle(rotate_angle, true);
    }

    public void setRotateAngle(double rotate_angle, boolean resizeCell) {
        if (resizeCell && Math.abs(this.getRotateAngle() - rotate_angle) == 90.0) {
            double w = this.getWidth();
            this.setWidth(this.getHeight());
            this.setHeight(w);
        }
        this.rotate_angle = rotate_angle;
    }

    public void setRoundCornerRadius(int roundCornerRadius) {
        this.roundCornerRadius = roundCornerRadius;
    }

    public int getRoundCornerRadius() {
        return this.roundCornerRadius;
    }

    public void setRoundCornersArray(boolean[] roundCorners) {
        this.roundCornersArray = roundCorners;
    }

    public boolean[] getRoundCornersArray() {
        return this.roundCornersArray;
    }

    public static boolean doesElementSupportRoundCorners(ReportElement elt) {
        if (elt instanceof ReportGrid) {
            return true;
        }
        if (elt instanceof ReportImage || elt instanceof ReportLine || elt instanceof ReportRTFObject) {
            return false;
        }
        if (elt instanceof ReportColumn) {
            return ((ReportColumn)elt).getDataFormat().getFormatType() != 7;
        }
        if (elt instanceof ReportCell) {
            IFormat dataFormat = ((ReportCell)elt).getDataFormat();
            if (dataFormat != null) {
                return dataFormat.getFormatType() != 7;
            }
            return true;
        }
        return false;
    }

    public static String getElementTypeName(int elementType) {
        String elTypeName = null;
        switch (elementType) {
            case 5: {
                elTypeName = LanguageEncoder.getText("Formula");
                break;
            }
            case 3: {
                elTypeName = LanguageEncoder.getText("Image");
                break;
            }
            case 6: {
                elTypeName = LanguageEncoder.getText("Label");
                break;
            }
            case 11: {
                elTypeName = LanguageEncoder.getText("Table of Contents");
                break;
            }
            case 13: {
                elTypeName = LanguageEncoder.getText("Report Title");
                break;
            }
            case 12: {
                elTypeName = LanguageEncoder.getText("Column Header");
                break;
            }
            case 1: {
                elTypeName = LanguageEncoder.getText("Rectangle");
                break;
            }
            case 0: {
                elTypeName = LanguageEncoder.getText("Chart");
                break;
            }
            case 2: {
                elTypeName = LanguageEncoder.getText("Line");
                break;
            }
            default: {
                elTypeName = LanguageEncoder.getText("Column");
            }
        }
        return elTypeName;
    }

    public int getBorder(BorderSide borderSide) {
        switch (borderSide) {
            case LEFT: {
                return this.leftBorder;
            }
            case RIGHT: {
                return this.rightBorder;
            }
            case BOTTOM: {
                return this.bottomBorder;
            }
        }
        return this.topBorder;
    }

    public int getTopBorder() {
        return this.topBorder;
    }

    public void setTopBorder(int topBorder) {
        this.topBorder = topBorder;
    }

    public int getBottomBorder() {
        return this.bottomBorder;
    }

    public void setBottomBorder(int bottomBorder) {
        this.bottomBorder = bottomBorder;
    }

    public int getLeftBorder() {
        return this.leftBorder;
    }

    public void setLeftBorder(int leftBorder) {
        this.leftBorder = leftBorder;
    }

    public int getRightBorder() {
        return this.rightBorder;
    }

    public void setRightBorder(int rightBorder) {
        this.rightBorder = rightBorder;
    }

    public boolean hasBorder() {
        return this.topBorder > 0 || this.rightBorder > 0 || this.bottomBorder > 0 || this.leftBorder > 0;
    }
}

