/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.ReportElements;

import java.awt.Color;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Writer;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.QbUtil;
import quadbase.reportdesigner.ReportElements.BorderSide;
import quadbase.reportdesigner.ReportElements.ReportImage;
import quadbase.reportdesigner.report.LoadXMLReportHelper;

public class ReportGrid
extends ReportImage {
    private int gridStyle;
    public static final int SOLID = 1;
    public static final int DOUBLE = 2;
    public static final int DASH = 3;
    private ReportGrid prev = null;
    private ReportGrid next = null;
    private String previousID = null;
    private boolean matchColumnWidths = false;
    public static final String XMLTAG = "REPORTGRID";

    public ReportGrid() {
        this.setVAlign((short)1);
        this.setWidth(2.0);
        this.setHeight(1.0);
        this.setBorderThickness(1);
        this.setBorderColor(Color.darkGray);
        this.gridStyle = 1;
    }

    public ReportGrid next() {
        return this.next;
    }

    public ReportGrid previous() {
        return this.prev;
    }

    public void setNext(ReportGrid n) {
        this.next = n;
    }

    public void setPrevious(ReportGrid p) {
        this.previousID = null;
        this.prev = p;
    }

    public ReportGrid getPrev() {
        return this.prev;
    }

    public ReportGrid getNext() {
        return this.next;
    }

    public void setNextGrid(ReportGrid _grid) {
        this.setNext(_grid);
        _grid.setPrevious(this);
        double h = _grid.getHeight();
        _grid.applyTemplate(this);
        this.setHeight(-1.0);
        _grid.setHeight(h);
        _grid.setY(0.0);
        if (this.previous() != null) {
            this.setY(0.0);
        }
        if (_grid.next() != null) {
            _grid.setNextGrid(_grid.next());
        }
    }

    public String getPreviousID() {
        return this.previousID;
    }

    public boolean isCrossSection() {
        return this.next != null || this.prev != null;
    }

    @Override
    public void setX(double x) {
        if (this.next != null || this.prev != null) {
            ReportGrid node = this.getHeadNode();
            while (node != null) {
                node.x = x;
                node = node.next;
            }
            return;
        }
        super.setX(x);
    }

    @Override
    public void setWidth(double width) {
        if (this.next != null || this.prev != null) {
            ReportGrid node = this.getHeadNode();
            while (node != null) {
                node.width = width;
                node = node.next;
            }
            return;
        }
        super.setWidth(width);
    }

    @Override
    public void setBgColor(Color c) {
        if (this.next != null || this.prev != null) {
            ReportGrid node = this.getHeadNode();
            while (node != null) {
                node.bgColor = c;
                node = node.next;
            }
            return;
        }
        super.setBgColor(c);
    }

    @Override
    public void setBorderColor(Color c) {
        if (this.next != null || this.prev != null) {
            ReportGrid node = this.getHeadNode();
            while (node != null) {
                node.borderColor = c;
                node = node.next;
            }
            return;
        }
        super.setBorderColor(c);
    }

    @Override
    public void setBorderThickness(int b) {
        if (this.next != null || this.prev != null) {
            ReportGrid node = this.getHeadNode();
            while (node != null) {
                node.setTopBorder(b);
                node.setBottomBorder(b);
                node.setLeftBorder(b);
                node.setRightBorder(b);
                node = node.next;
            }
            return;
        }
        super.setBorderThickness(b);
    }

    @Override
    public void setBorderThickness(int borderThickness, BorderSide borderSide) {
        this.setBorderThickness(borderThickness);
    }

    @Override
    public int getBorder(BorderSide borderSide) {
        return this.getBorderThickness();
    }

    @Override
    public void setRoundCornerRadius(int radius) {
        if (this.next != null || this.prev != null) {
            ReportGrid node = this.getHeadNode();
            while (node != null) {
                node.roundCornerRadius = radius;
                node = node.next;
            }
            return;
        }
        super.setRoundCornerRadius(radius);
    }

    @Override
    public void setRoundCornersArray(boolean[] roundCornersArray) {
        if (this.next != null || this.prev != null) {
            ReportGrid node = this.getHeadNode();
            while (node != null) {
                node.roundCornersArray = roundCornersArray;
                node = node.next;
            }
            return;
        }
        super.setRoundCornersArray(roundCornersArray);
    }

    @Override
    @Deprecated
    public void setBorder(int b) {
        this.setBorderThickness(b);
    }

    @Override
    public void setLocked(boolean b) {
        if (this.next != null || this.prev != null) {
            ReportGrid node = this.getHeadNode();
            while (node != null) {
                node.isLocked = b;
                node = node.next;
            }
            return;
        }
        super.setLocked(b);
    }

    public ReportGrid getHeadNode() {
        ReportGrid node = this;
        while (node.prev != null) {
            node = node.prev;
        }
        return node;
    }

    public int getGridStyle() {
        return this.gridStyle;
    }

    public void setGridStyle(int style) {
        if (this.next != null || this.prev != null) {
            ReportGrid node = this.getHeadNode();
            while (node != null) {
                node.gridStyle = style;
                node = node.next;
            }
            return;
        }
        this.gridStyle = style;
    }

    @Override
    public void setSnap(short snap) {
        if (this.isLocked) {
            return;
        }
        if (this.next != null || this.prev != null) {
            ReportGrid node = this.getHeadNode();
            while (node != null) {
                node.snap = snap;
                node = node.next;
            }
            return;
        }
        this.snap = snap;
    }

    @Override
    public void setVSnap(short vsnap) {
        if (this.isLocked) {
            return;
        }
        if (this.next != null || this.prev != null) {
            ReportGrid node = this.getHeadNode();
            while (node != null) {
                node.vsnap = vsnap;
                node = node.next;
            }
            return;
        }
        this.vsnap = vsnap;
    }

    public boolean isMatchColumnWidths() {
        return this.matchColumnWidths;
    }

    public void setMatchColumnWidths(boolean b) {
        this.matchColumnWidths = b;
    }

    public void copy(ReportGrid _grid) {
        super.copy(_grid);
        this.setGridStyle(_grid.getGridStyle());
        this.setNext(_grid.next());
        this.setPrevious(_grid.previous());
        this.previousID = this.previous() != null ? this.previous().getID() : null;
        this.setMatchColumnWidths(_grid.isMatchColumnWidths());
    }

    public void deepCopy(ReportGrid _grid) {
        super.deepCopy(_grid);
        this.setGridStyle(_grid.getGridStyle());
        this.setNext(_grid.next());
        this.setPrevious(_grid.previous());
        this.previousID = this.previous() != null ? this.previous().getID() : null;
        this.setMatchColumnWidths(_grid.isMatchColumnWidths());
    }

    public void applyTemplate(ReportGrid _grid) {
        this.applyTemplate(_grid, false);
    }

    public void applyTemplate(ReportGrid _grid, boolean applyScript) {
        super.applyTemplate(_grid, applyScript);
        this.setGridStyle(_grid.getGridStyle());
        this.setMatchColumnWidths(_grid.isMatchColumnWidths());
    }

    public void copyTemplate(ReportGrid _grid) {
        super.copyTemplate(_grid);
        this.setGridStyle(_grid.getGridStyle());
        this.setMatchColumnWidths(_grid.isMatchColumnWidths());
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeInt(this.gridStyle);
        out.writeDouble(0.0);
        out.writeBoolean(this.matchColumnWidths);
        out.writeBoolean(this.previous() != null);
        if (this.previous() != null) {
            IOUtil.writeStr(out, this.previous().getID());
        }
    }

    @Override
    public void writeXML(Writer out, boolean writeElementTag) throws IOException {
        if (writeElementTag) {
            out.write("<REPORTGRID>\n");
        }
        super.writeXML(out, false);
        out.write("<REPORTGRID_GRIDSTYLE>" + this.gridStyle + "</REPORTGRID_GRIDSTYLE>\n");
        out.write("<REPORTGRID_MATCHCOLUMNWIDTHS>" + this.matchColumnWidths + "</REPORTGRID_MATCHCOLUMNWIDTHS>\n");
        if (this.previous() != null && this.previous().getID() != null) {
            out.write("<REPORTGRID_PREVIOUS_ID>" + this.previous().getID() + "</REPORTGRID_PREVIOUS_ID>\n");
        }
        if (writeElementTag) {
            out.write("</REPORTGRID>\n");
        }
    }

    public static ReportGrid createGrid(Node node, int version) throws Exception {
        if (!node.getNodeName().equalsIgnoreCase(XMLTAG)) {
            throw new Exception("'REPORTGRID' element expected, but found '" + node.getNodeName() + "' element.");
        }
        ReportGrid cell = new ReportGrid();
        cell.readXML(node, version);
        return cell;
    }

    @Override
    public void readXML(Node node, int version) throws Exception {
        super.readXML(node, version);
        boolean check1 = false;
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node child = nodeList.item(i);
            if (child.getNodeName().equalsIgnoreCase("REPORTGRID_GRIDSTYLE")) {
                this.setGridStyle(Integer.parseInt(LoadXMLReportHelper.readText(child)));
                check1 = true;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTGRID_RADIUS")) {
                double radius = Double.parseDouble(LoadXMLReportHelper.readText(child));
                this.setRoundCornerRadius((int)QbUtil.toPoints(radius));
                if (!(radius > 0.0)) continue;
                boolean[] rcArray = new boolean[]{true, true, true, true};
                this.setRoundCornersArray(rcArray);
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTGRID_MATCHCOLUMNWIDTHS")) {
                this.matchColumnWidths = LoadXMLReportHelper.parseBoolean(LoadXMLReportHelper.readText(child));
                continue;
            }
            if (!child.getNodeName().equalsIgnoreCase("REPORTGRID_PREVIOUS_ID")) continue;
            this.previousID = LoadXMLReportHelper.readText(child);
        }
        if (!check1) {
            throw new Exception("Missing 'REPORTGRID' attributes.");
        }
    }

    public static ReportGrid createGrid(DataInput in, int version) throws Exception {
        ReportGrid cell = new ReportGrid();
        cell.read(in, version);
        return cell;
    }

    @Override
    public void read(DataInput in, int version) throws Exception {
        super.read(in, version);
        int gridStyle = in.readInt();
        this.setGridStyle(gridStyle);
        if (version >= 175) {
            double radius = in.readDouble();
            if (version < 6601) {
                this.setRoundCornerRadius((int)QbUtil.toPoints(radius));
                if (radius > 0.0) {
                    boolean[] rcArray = new boolean[]{true, true, true, true};
                    this.setRoundCornersArray(rcArray);
                }
            }
        }
        if (version >= 204) {
            this.matchColumnWidths = in.readBoolean();
        }
        if (version >= 29 && in.readBoolean()) {
            this.previousID = IOUtil.readStr(in);
        }
    }
}

