/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.ReportElements;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import quadbase.common.client.FileInfo;
import quadbase.common.util.internal.FileInMemTable;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.IReportImage;
import quadbase.common.util.internal.VersioningDataInput;
import quadbase.common.util.internal.VersioningDataOutput;
import quadbase.common.util.internal.XMLUtil;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.report.LoadXMLReportHelper;
import quadbase.reportdesigner.report.ReadDataFile;
import quadbase.reportdesigner.report.WriteDataFile;

public class ReportImage
extends ReportCell
implements IReportImage,
Serializable {
    URL imageURL = null;
    String imagePath = null;
    int imageType = 7;
    int pdfImageType = 10;
    boolean isGIFTransparent = false;
    int jpegQuality = 99;
    int pngCompression = 0;
    int flashFrameCount = 12;
    float flashFrameRate = 20.0f;
    private String saveDir = null;
    private String saveURL = null;
    private String saveFileName = null;
    private boolean fromDatabase = false;
    private String relativePath = null;
    private byte[] imageData = null;
    public static final String DBImageDir = "DBImages";
    public static final String XMLTAG = "REPORTIMAGE";
    public static final int CENTER = 0;
    public static final int FIT = 1;
    public static final int TILE = 2;
    private int imageOption = 0;

    public ReportImage() {
        this.setVAlign((short)1);
        this.setWidth(3.0);
        this.setHeight(3.0);
    }

    public ReportImage(String name) {
        super(name);
        this.setVAlign((short)1);
        this.setWidth(3.0);
        this.setHeight(3.0);
    }

    public void copy(ReportImage _cell) {
        super.copy(_cell);
        this.setRelativePath(_cell.getRelativePath());
        this.setDBImage(_cell.isDBImage());
        this.setImageType(_cell.getImageType());
        this.setPdfImageType(_cell.getPdfImageType());
        this.setJPEGQuality(_cell.getJPEGQuality());
        this.setPNGCompression(_cell.getPNGCompression());
        this.setGIFTransparent(_cell.isGIFTransparent());
        this.setFlashFrameRate(_cell.getFlashFrameRate());
        this.setFlashFrameCount(_cell.getFlashFrameCount());
        this.setImageURL(_cell.getImageURL(), false);
        this.setImagePath(_cell.getImagePath(), false);
        this.setBytes(_cell.getBytes());
        this.setImageOption(_cell.getImageOption());
        this.saveDir = _cell.saveDir;
        this.saveURL = _cell.saveURL;
        this.saveFileName = _cell.saveFileName;
    }

    public void deepCopy(ReportImage _cell) {
        super.deepCopy(_cell);
        this.setRelativePath(_cell.getRelativePath());
        this.setDBImage(_cell.isDBImage());
        this.setImageType(_cell.getImageType());
        this.setPdfImageType(_cell.getPdfImageType());
        this.setJPEGQuality(_cell.getJPEGQuality());
        this.setPNGCompression(_cell.getPNGCompression());
        this.setGIFTransparent(_cell.isGIFTransparent());
        this.setFlashFrameRate(_cell.getFlashFrameRate());
        this.setFlashFrameCount(_cell.getFlashFrameCount());
        this.setImageURL(_cell.getImageURL(), false);
        this.setImagePath(_cell.getImagePath(), false);
        this.setBytes(_cell.getBytes());
        this.setImageOption(_cell.getImageOption());
    }

    public void copyTemplate(ReportImage _cell) {
        super.copyTemplate(_cell);
        this.setRelativePath(_cell.getRelativePath());
        this.setDBImage(_cell.isDBImage());
        this.setImageType(_cell.getImageType());
        this.setPdfImageType(_cell.getPdfImageType());
        this.setJPEGQuality(_cell.getJPEGQuality());
        this.setPNGCompression(_cell.getPNGCompression());
        this.setGIFTransparent(_cell.isGIFTransparent());
        this.setFlashFrameRate(_cell.getFlashFrameRate());
        this.setFlashFrameCount(_cell.getFlashFrameCount());
        this.setImageURL(_cell.getImageURL(), false);
        this.setImagePath(_cell.getImagePath(), false);
        this.setBytes(_cell.getBytes());
        this.setImageOption(_cell.getImageOption());
    }

    public void applyTemplate(ReportImage _cell) {
        super.applyTemplate(_cell, false);
    }

    public void applyTemplate(ReportImage _cell, boolean applyScript) {
        super.applyTemplate(_cell, applyScript);
        this.setImageType(_cell.getImageType());
        this.setPdfImageType(_cell.getPdfImageType());
        this.setJPEGQuality(_cell.getJPEGQuality());
        this.setPNGCompression(_cell.getPNGCompression());
        this.setGIFTransparent(_cell.isGIFTransparent());
        this.setFlashFrameRate(_cell.getFlashFrameRate());
        this.setFlashFrameCount(_cell.getFlashFrameCount());
        this.setBytes(_cell.getBytes());
        this.setImageOption(_cell.getImageOption());
    }

    public boolean equals(ReportImage _cell) {
        if (_cell == this) {
            return true;
        }
        if (!super.equals(_cell)) {
            return false;
        }
        if (this.imageType != _cell.imageType) {
            return false;
        }
        if (this.pdfImageType != _cell.pdfImageType) {
            return false;
        }
        if (this.jpegQuality != _cell.jpegQuality) {
            return false;
        }
        if (this.pngCompression != _cell.pngCompression) {
            return false;
        }
        if (this.isGIFTransparent != _cell.isGIFTransparent) {
            return false;
        }
        return this.imageOption == _cell.imageOption;
    }

    public int getImageType() {
        return this.imageType;
    }

    public void setImageType(int type) {
        this.imageType = type;
    }

    public int getPdfImageType() {
        return this.pdfImageType;
    }

    public void setPdfImageType(int type) {
        this.pdfImageType = type;
    }

    public int getJPEGQuality() {
        return this.jpegQuality;
    }

    public void setJPEGQuality(int q) {
        this.jpegQuality = q;
    }

    public int getPNGCompression() {
        return this.pngCompression;
    }

    public void setPNGCompression(int q) {
        this.pngCompression = q;
    }

    public boolean isGIFTransparent() {
        return this.isGIFTransparent;
    }

    public void setGIFTransparent(boolean b) {
        this.isGIFTransparent = b;
    }

    public int getFlashFrameCount() {
        return this.flashFrameCount;
    }

    public void setFlashFrameCount(int ct) {
        this.flashFrameCount = ct;
    }

    public float getFlashFrameRate() {
        return this.flashFrameRate;
    }

    public void setFlashFrameRate(float rate) {
        this.flashFrameRate = rate;
    }

    public void setImageOption(int i) {
        this.imageOption = i < 0 || i > 2 ? 0 : i;
    }

    public int getImageOption() {
        return this.imageOption;
    }

    public URL getImageURL() {
        if (this.imagePath != null) {
            try {
                String path = new FileInfo(this.imagePath).getAbsolutePath();
                return new URL(IOUtil.nameToURL3(path));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return this.imageURL;
    }

    @Override
    public void setImageURL(URL url) {
        this.setImageURL(url, true);
    }

    @Override
    public void setImageURL(URL url, boolean setBytes) {
        this.imageURL = url;
        if (url != null) {
            this.imagePath = null;
            if (setBytes) {
                this.setBytes(url.toString());
            }
        }
    }

    public String getImagePath() {
        return this.imagePath;
    }

    public void setImagePath(String path) {
        this.setImagePath(path, true);
    }

    public void setImagePath(String path, boolean setBytes) {
        this.imagePath = path;
        if (path != null) {
            this.imageURL = null;
            if (setBytes) {
                this.setBytes(path);
            }
        }
    }

    public void setBytes(String filename) {
        try {
            ByteArrayOutputStream bytestream = new ByteArrayOutputStream(2048);
            ReadDataFile readfile = new ReadDataFile();
            filename = filename.replace('\\', '/');
            if (filename.startsWith("file:/")) {
                int loc = 5;
                for (int i = 5; i < filename.length(); ++i) {
                    if (filename.charAt(i) == '/') continue;
                    loc = i - 1;
                    break;
                }
                filename = filename.indexOf(":", loc) > 0 ? filename.substring(loc + 1) : filename.substring(loc);
            }
            DataInputStream in = readfile.getInputStream(null, filename);
            int c = in.read();
            while (c != -1) {
                bytestream.write(c);
                c = in.read();
            }
            in.close();
            bytestream.close();
            byte[] barray = bytestream.toByteArray();
            this.setBytes(barray);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setHTMLParameters(String dirLocation, String url, String fileName) {
        this.saveDir = dirLocation;
        this.saveURL = url;
        this.saveFileName = fileName;
        if (this.saveURL == null || this.saveDir == null) {
            return;
        }
        if (!(this.saveDir.equals("") || this.saveDir.endsWith("/") || this.saveDir.endsWith("\\"))) {
            this.saveDir = this.saveDir + File.separator;
        }
        if (!this.saveURL.equals("") && !this.saveURL.endsWith("/")) {
            this.saveURL = this.saveURL + "/";
        }
    }

    public String getSavedFileLocation() {
        if (this.saveDir == null) {
            return null;
        }
        return this.saveDir + this.saveFileName;
    }

    public String getSavedFileURL() {
        if (this.saveURL == null) {
            return null;
        }
        return this.saveURL + this.saveFileName;
    }

    @Override
    public void setDBImage(boolean fdb) {
        this.fromDatabase = fdb;
    }

    public boolean isDBImage() {
        return this.fromDatabase;
    }

    @Override
    public void setRelativePath(String rpath) {
        this.relativePath = rpath;
    }

    @Override
    public String getRelativePath() {
        return this.relativePath;
    }

    public void setBytes(byte[] b) {
        this.imageData = b;
    }

    public byte[] getBytes() {
        return this.imageData;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        this.write(out, false);
    }

    public void write(DataOutput out, boolean pack) throws IOException {
        super.write(out);
        out.writeInt(this.imageType);
        out.writeInt(this.pdfImageType);
        out.writeInt(this.jpegQuality);
        out.writeInt(this.pngCompression);
        out.writeBoolean(this.isGIFTransparent);
        if (out instanceof VersioningDataOutput) {
            ((VersioningDataOutput)out).writeInt(this.flashFrameCount, (short)299);
        }
        if (out instanceof VersioningDataOutput) {
            ((VersioningDataOutput)out).writeFloat(this.flashFrameRate, (short)299);
        }
        out.writeInt(this.imageOption);
        IOUtil.writeStr(out, this.imageURL == null ? null : this.imageURL.toString());
        IOUtil.writeStr(out, this.imagePath == null ? null : this.imagePath);
        this.writeImageData(out, pack);
    }

    protected void writeImageData(DataOutput out, boolean pack) throws IOException {
        block9: {
            if (pack) {
                try {
                    ByteArrayOutputStream bytestream = new ByteArrayOutputStream(2048);
                    ReadDataFile readfile = new ReadDataFile();
                    String filename = this.imageURL.toString();
                    filename = filename.replace('\\', '/');
                    if (filename.startsWith("file:/")) {
                        filename = filename.substring(6);
                    }
                    DataInputStream in = readfile.getInputStream(null, filename);
                    int c = in.read();
                    while (c != -1) {
                        bytestream.write(c);
                        c = in.read();
                    }
                    in.close();
                    bytestream.close();
                    byte[] barray = bytestream.toByteArray();
                    out.writeBoolean(true);
                    out.writeInt(barray.length);
                    out.write(barray);
                    this.setBytes(barray);
                }
                catch (Exception ex) {
                    if (this.getBytes() != null) {
                        out.writeBoolean(true);
                        out.writeInt(this.getBytes().length);
                        out.write(this.getBytes());
                        break block9;
                    }
                    out.writeBoolean(false);
                }
            } else if (this.getBytes() != null) {
                out.writeBoolean(true);
                out.writeInt(this.getBytes().length);
                out.write(this.getBytes());
            } else {
                out.writeBoolean(false);
            }
        }
    }

    @Override
    public void writeXML(Writer out, boolean writeElementTag) throws IOException {
        if (writeElementTag) {
            out.write("<REPORTIMAGE>\n");
        }
        super.writeXML(out, false);
        out.write("<REPORTIMAGE_IMAGETYPE>" + this.imageType + "</REPORTIMAGE_IMAGETYPE>\n");
        out.write("<REPORTIMAGE_PDFIMAGETYPE>" + this.pdfImageType + "</REPORTIMAGE_PDFIMAGETYPE>\n");
        out.write("<REPORTIMAGE_JPEGQUALITY>" + this.jpegQuality + "</REPORTIMAGE_JPEGQUALITY>\n");
        out.write("<REPORTIMAGE_PNGCOMPRESSION>" + this.pngCompression + "</REPORTIMAGE_PNGCOMPRESSION>\n");
        out.write("<REPORTIMAGE_TRANSPARENT_GIF>" + this.isGIFTransparent + "</REPORTIMAGE_TRANSPARENT_GIF>\n");
        out.write("<REPORTIMAGE_FRAMECOUNT_FLASH>" + this.flashFrameCount + "</REPORTIMAGE_FRAMECOUNT_FLASH>\n");
        out.write("<REPORTIMAGE_FRAMERATE_FLASH>" + this.flashFrameRate + "</REPORTIMAGE_FRAMERATE_FLASH>\n");
        out.write("<REPORTIMAGE_IMAGEOPTION>" + this.imageOption + "</REPORTIMAGE_IMAGEOPTION>\n");
        if (this.imageURL != null) {
            out.write("<REPORTIMAGE_URL>" + XMLUtil.encodeCDATA(this.imageURL.toString()) + "</REPORTIMAGE_URL>\n");
        }
        if (this.imagePath != null) {
            out.write("<REPORTIMAGE_PATH>" + XMLUtil.encodeCDATA(this.imagePath) + "</REPORTIMAGE_PATH>\n");
        }
        if (writeElementTag) {
            out.write("</REPORTIMAGE>\n");
        }
    }

    public static ReportImage createImage(Node node, int version) throws Exception {
        if (!node.getNodeName().equalsIgnoreCase(XMLTAG)) {
            throw new Exception("'REPORTIMAGE' element expected, but found '" + node.getNodeName() + "' element.");
        }
        ReportImage cell = new ReportImage();
        cell.readXML(node, version);
        return cell;
    }

    @Override
    public void readXML(Node node, int version) throws Exception {
        super.readXML(node, version);
        boolean check4 = false;
        boolean check3 = false;
        boolean check2 = false;
        boolean check1 = false;
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node child = nodeList.item(i);
            if (child.getNodeName().equalsIgnoreCase("REPORTIMAGE_IMAGETYPE")) {
                this.imageType = Integer.parseInt(LoadXMLReportHelper.readText(child));
                check1 = true;
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTIMAGE_PDFIMAGETYPE")) {
                this.pdfImageType = Integer.parseInt(LoadXMLReportHelper.readText(child));
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTIMAGE_JPEGQUALITY")) {
                this.jpegQuality = Integer.parseInt(LoadXMLReportHelper.readText(child));
                check2 = true;
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTIMAGE_PNGCOMPRESSION")) {
                this.pngCompression = Integer.parseInt(LoadXMLReportHelper.readText(child));
                check3 = true;
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTIMAGE_TRANSPARENT_GIF")) {
                this.isGIFTransparent = LoadXMLReportHelper.parseBoolean(LoadXMLReportHelper.readText(child));
                check4 = true;
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTIMAGE_FRAMECOUNT_FLASH")) {
                this.flashFrameCount = Integer.parseInt(LoadXMLReportHelper.readText(child));
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTIMAGE_FRAMERATE_FLASH")) {
                this.flashFrameRate = Float.parseFloat(LoadXMLReportHelper.readText(child));
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTIMAGE_IMAGEOPTION")) {
                this.imageOption = Integer.parseInt(LoadXMLReportHelper.readText(child));
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTIMAGE_URL")) {
                this.imageURL = new URL(LoadXMLReportHelper.readCDATA(child));
                continue;
            }
            if (!child.getNodeName().equalsIgnoreCase("REPORTIMAGE_PATH")) continue;
            this.imagePath = LoadXMLReportHelper.readCDATA(child);
        }
        if (!(check1 && check2 && check3 && check4)) {
            throw new Exception("Missing 'REPORTIMAGE' attributes.");
        }
    }

    public static ReportImage createImage(DataInput in, int version) throws Exception {
        return ReportImage.createImage(in, version, false, null);
    }

    public static ReportImage createImage(DataInput in, int version, boolean pack, FileInMemTable subFilesTable) throws Exception {
        ReportImage cell = new ReportImage();
        cell.read(in, version, pack, subFilesTable);
        return cell;
    }

    @Override
    public void read(DataInput in, int version) throws Exception {
        this.read(in, version, false, null);
    }

    public void read(DataInput in, int version, boolean pack, FileInMemTable subFilesTable) throws Exception {
        boolean hasImageData;
        String tmp;
        super.read(in, version);
        this.imageType = in.readInt();
        if (version >= 140) {
            this.pdfImageType = in.readInt();
        }
        if (version >= 8) {
            this.jpegQuality = in.readInt();
            this.pngCompression = in.readInt();
            this.isGIFTransparent = in.readBoolean();
        }
        if (in instanceof VersioningDataInput && version >= 299) {
            this.flashFrameCount = in.readInt();
            this.flashFrameRate = in.readFloat();
        }
        if (version >= 133) {
            this.imageOption = in.readInt();
        }
        if (version >= 11) {
            tmp = IOUtil.readStr(in);
            URL uRL = this.imageURL = tmp == null ? null : new URL(tmp);
        }
        if (version >= 146 && version < 160 || version >= 164) {
            tmp = IOUtil.readStr(in);
            String string = this.imagePath = tmp == null ? null : tmp;
        }
        if ((pack || version >= 201) && (hasImageData = in.readBoolean())) {
            int count = in.readInt();
            byte[] barray = new byte[count];
            in.readFully(barray);
            try {
                WriteDataFile wdfile = new WriteDataFile();
                String filename = "";
                if (this.imageURL != null) {
                    this.imageURL.toString();
                }
                if ((filename = filename.replace('\\', '/')).startsWith("file:/")) {
                    filename = filename.substring(6);
                    this.imageURL = new URL(IOUtil.nameToURL2(filename));
                    wdfile.output(subFilesTable, barray, filename);
                } else {
                    this.setBytes(barray);
                }
            }
            catch (IOException ex) {
                this.setBytes(barray);
            }
        }
    }

    public String toString() {
        return this.getText();
    }

    @Override
    public IReportImage createReportImage(String name) {
        ReportImage ret = new ReportImage(name);
        ret.setVAlign((short)1);
        ret.setWidth(3.0);
        ret.setHeight(3.0);
        return ret;
    }
}

