/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.ReportElements;

import java.awt.Color;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.QbUtil;
import quadbase.reportdesigner.ReportElements.BorderSide;
import quadbase.reportdesigner.ReportElements.ReportImage;
import quadbase.reportdesigner.report.LoadXMLReportHelper;

public class ReportLine
extends ReportImage
implements Serializable {
    protected boolean isVertical = false;
    private int lineStyle;
    public static final int SOLID = 1;
    public static final int DOUBLE = 2;
    public static final int DASH = 3;
    private ReportLine prev = null;
    private ReportLine next = null;
    private String previousID = null;
    private boolean matchColumnWidths = false;
    public static final String XMLTAG = "REPORTLINE";

    public ReportLine(boolean isVertical) {
        this.setVAlign((short)1);
        this.lineStyle = 1;
        this.isVertical = isVertical;
        if (!isVertical) {
            this.setWidth(1.0);
            this.setHeight(0.03);
            this.setBgColor(Color.darkGray);
        } else {
            this.setWidth(0.03);
            this.setHeight(1.0);
            this.setBgColor(Color.darkGray);
        }
    }

    public ReportLine() {
    }

    public ReportLine next() {
        return this.next;
    }

    public ReportLine previous() {
        return this.prev;
    }

    public void setNext(ReportLine line) {
        this.next = line;
    }

    public void setPrevious(ReportLine line) {
        this.previousID = null;
        this.prev = line;
    }

    public void setNextLine(ReportLine _line) {
        if (!this.isVertical()) {
            return;
        }
        this.setNext(_line);
        _line.setPrevious(this);
        double h = _line.getHeight();
        _line.applyTemplate(this);
        this.setHeight(-1.0);
        _line.setHeight(h);
        _line.setY(0.0);
        if (this.previous() != null) {
            this.setY(0.0);
        }
        if (_line.next() != null) {
            _line.setNextLine(_line.next());
        }
    }

    public String getPreviousID() {
        return this.previousID;
    }

    public void setPreviousID(String id) {
        this.previousID = id;
    }

    public boolean isCrossSection() {
        return this.next != null || this.prev != null;
    }

    @Override
    public int getBorderThickness() {
        return this.getBorder(null);
    }

    @Override
    public int getBorder(BorderSide borderSide) {
        int thickness = this.isVertical() ? QbUtil.toPixel(this.getWidth() - 0.02) : QbUtil.toPixel(this.getHeight() - 0.02);
        return thickness;
    }

    @Override
    public void setBorderThickness(int pixels) {
        if (this.isVertical) {
            this.setWidth(QbUtil.toInch(pixels + 2));
        } else {
            this.setHeight(QbUtil.toInch(pixels + 2));
        }
    }

    @Override
    @Deprecated
    public void setBorder(int pixels) {
        this.setBorderThickness(pixels);
    }

    @Override
    public void setX(double x) {
        if (this.isVertical && (this.next != null || this.prev != null)) {
            ReportLine node = this.getHeadNode();
            while (node != null) {
                node.x = x;
                node = node.next;
            }
            return;
        }
        super.setX(x);
    }

    @Override
    public void setWidth(double w) {
        if (this.isVertical && (this.next != null || this.prev != null)) {
            ReportLine node = this.getHeadNode();
            while (node != null) {
                node.width = w;
                node = node.next;
            }
            return;
        }
        super.setWidth(w);
    }

    @Override
    public void setHeight(double h) {
        this.height = h;
    }

    @Override
    public void resize(double xratio, double yratio) {
        if (this.isLocked()) {
            return;
        }
        double gridSpace = this.inchGridSpace;
        if (this.metric) {
            gridSpace = this.cmGridSpace;
        }
        if (xratio != 1.0) {
            if (this.isVertical()) {
                if (this.isSnapToGrid()) {
                    this.setXX(Math.floor(this.getX() * xratio / gridSpace) * gridSpace, true);
                } else {
                    this.setXX(this.getX() * xratio, true);
                }
            } else {
                super.resize(xratio, 1.0);
            }
        }
        if (yratio != 1.0) {
            if (this.isVertical()) {
                super.resize(1.0, yratio);
            } else if (this.isSnapToGrid()) {
                this.setYY(Math.floor(this.getY() * yratio / gridSpace) * gridSpace, true);
            } else {
                this.setYY(this.getY() * yratio, true);
            }
        }
    }

    @Override
    public void setBgColor(Color c) {
        if (this.isVertical && (this.next != null || this.prev != null)) {
            ReportLine node = this.getHeadNode();
            while (node != null) {
                node.bgColor = c;
                node = node.next;
            }
            return;
        }
        super.setBgColor(c);
    }

    @Override
    public void setBorderColor(Color c) {
        this.setBgColor(c);
    }

    @Override
    public void setLocked(boolean b) {
        if (this.isVertical && (this.next != null || this.prev != null)) {
            ReportLine node = this.getHeadNode();
            while (node != null) {
                node.isLocked = b;
                node = node.next;
            }
            return;
        }
        super.setLocked(b);
    }

    @Override
    public boolean isVisible() {
        if (this.width == 0.0 || this.height == 0.0) {
            return false;
        }
        return super.isVisible();
    }

    public ReportLine getHeadNode() {
        ReportLine node = this;
        while (node.prev != null) {
            node = node.prev;
        }
        return node;
    }

    public boolean isVertical() {
        return this.isVertical;
    }

    public void setVertical(boolean b) {
        this.isVertical = b;
    }

    public int getLineStyle() {
        return this.lineStyle;
    }

    public void setLineStyle(int style) {
        if (this.isVertical && (this.next != null || this.prev != null)) {
            ReportLine node = this.getHeadNode();
            while (node != null) {
                node.lineStyle = style;
                node = node.next;
            }
            return;
        }
        this.lineStyle = style;
    }

    public boolean isMatchColumnWidths() {
        return this.matchColumnWidths;
    }

    public void setMatchColumnWidths(boolean b) {
        this.matchColumnWidths = b;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeBoolean(this.isVertical);
        out.writeBoolean(this.matchColumnWidths);
        out.writeInt(this.lineStyle);
        out.writeBoolean(this.previous() != null);
        if (this.previous() != null) {
            IOUtil.writeStr(out, this.previous().getID());
        }
    }

    @Override
    public void writeXML(Writer out, boolean writeElementTag) throws IOException {
        if (writeElementTag) {
            out.write("<REPORTLINE>\n");
        }
        super.writeXML(out, false);
        out.write("<REPORTLINE_VERTICAL>" + this.isVertical + "</REPORTLINE_VERTICAL>\n");
        out.write("<REPORTLINE_MATCHCOLUMNWIDTHS>" + this.matchColumnWidths + "</REPORTLINE_MATCHCOLUMNWIDTHS>\n");
        out.write("<REPORTLINE_LINESTYLE>" + this.lineStyle + "</REPORTLINE_LINESTYLE>\n");
        if (this.previous() != null && this.previous().getID() != null) {
            out.write("<REPORTLINE_PREVIOUS_ID>" + this.previous().getID() + "</REPORTLINE_PREVIOUS_ID>\n");
        }
        if (writeElementTag) {
            out.write("</REPORTLINE>\n");
        }
    }

    public static ReportLine createLine(Node node, int version) throws Exception {
        if (!node.getNodeName().equalsIgnoreCase(XMLTAG)) {
            throw new Exception("'REPORTLINE' element expected, but found '" + node.getNodeName() + "' element.");
        }
        ReportLine cell = new ReportLine();
        cell.readXML(node, version);
        return cell;
    }

    @Override
    public void readXML(Node node, int version) throws Exception {
        super.readXML(node, version);
        boolean check2 = false;
        boolean check1 = false;
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node child = nodeList.item(i);
            if (child.getNodeName().equalsIgnoreCase("REPORTLINE_VERTICAL")) {
                this.isVertical = LoadXMLReportHelper.parseBoolean(LoadXMLReportHelper.readText(child));
                check1 = true;
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTLINE_MATCHCOLUMNWIDTHS")) {
                this.matchColumnWidths = LoadXMLReportHelper.parseBoolean(LoadXMLReportHelper.readText(child));
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTLINE_LINESTYLE")) {
                this.lineStyle = Integer.parseInt(LoadXMLReportHelper.readText(child));
                check2 = true;
                continue;
            }
            if (!child.getNodeName().equalsIgnoreCase("REPORTLINE_PREVIOUS_ID")) continue;
            this.previousID = LoadXMLReportHelper.readText(child);
        }
        if (!check1 || !check2) {
            throw new Exception("Missing 'REPORTLINE' attributes.");
        }
    }

    public void copy(ReportLine _line) {
        super.copy(_line);
        this.setMatchColumnWidths(_line.isMatchColumnWidths());
        this.setLineStyle(_line.getLineStyle());
        this.setVertical(_line.isVertical());
        this.setNext(_line.next());
        this.setPrevious(_line.previous());
        if (this.previous() != null) {
            this.previousID = this.previous().getID();
        }
    }

    public void deepCopy(ReportLine _line) {
        super.deepCopy(_line);
        this.setMatchColumnWidths(_line.isMatchColumnWidths());
        this.setLineStyle(_line.getLineStyle());
        this.setVertical(_line.isVertical());
        this.setNext(_line.next());
        this.setPrevious(_line.previous());
        if (this.previous() != null) {
            this.previousID = this.previous().getID();
        }
    }

    public void applyTemplate(ReportLine _line) {
        this.applyTemplate(_line, false);
    }

    public void applyTemplate(ReportLine _line, boolean applyScript) {
        super.applyTemplate(_line, applyScript);
        this.setLineStyle(_line.getLineStyle());
        this.setVertical(_line.isVertical());
        this.setMatchColumnWidths(_line.isMatchColumnWidths());
        this.setWidth(_line.getWidth());
    }

    public void copyTemplate(ReportLine _line) {
        super.copyTemplate(_line);
        this.setLineStyle(_line.getLineStyle());
        this.setVertical(_line.isVertical());
        this.setMatchColumnWidths(_line.isMatchColumnWidths());
    }

    public static ReportLine createLine(DataInput in, int version) throws Exception {
        ReportLine cell = new ReportLine();
        cell.read(in, version);
        return cell;
    }

    @Override
    public void read(DataInput in, int version) throws Exception {
        super.read(in, version);
        this.isVertical = in.readBoolean();
        if (version >= 204) {
            this.matchColumnWidths = in.readBoolean();
        }
        this.lineStyle = in.readInt();
        if (version >= 29 && in.readBoolean()) {
            this.previousID = IOUtil.readStr(in);
        }
        if (this.previousID != null && this.previousID.equals(this.getID())) {
            this.previousID = null;
        }
    }
}

