/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.ReportElements;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Writer;
import java.util.Vector;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import quadbase.common.util.internal.IOUtil;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.report.LoadXMLReportHelper;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.util.IFormat;
import quadbase.reportdesigner.util.internal.FormatUtil;
import quadbase.reportdesigner.util.rtf.RTFUtil;

public class ReportRTFObject
extends ReportCell {
    private byte[] data = null;
    public static final String XMLTAG = "RTFOBJECT";
    private Vector<Object[]> formats = new Vector();
    private Vector<Object> formatMap = new Vector();
    private boolean borderClosed = false;
    private double spacing = 0.25;
    private int columnCount = 1;
    private String saveDir = null;
    private String saveURL = null;
    private String saveFileName = null;

    public ReportRTFObject(byte[] d) {
        this.data = d;
    }

    public ReportRTFObject() {
    }

    public void setData(byte[] d, Object[] fmap) {
        this.data = d;
        this.formatMap = new Vector();
        if (fmap != null) {
            for (Object element : fmap) {
                this.formatMap.addElement(element);
            }
        }
    }

    public String getFullText(Report report, ReportTable tbl) {
        return RTFUtil.getFullText(this.getData(), this.getFormatMap(), this.getFormats(), report, tbl);
    }

    public void copy(ReportRTFObject _source) {
        super.copy(_source);
        this.data = null;
        if (_source.data != null) {
            this.data = new byte[_source.data.length];
            for (int i = 0; i < this.data.length; ++i) {
                this.data[i] = _source.data[i];
            }
        }
        this.formats = _source.formats;
        this.formatMap = _source.formatMap;
        this.columnCount = _source.columnCount;
        this.spacing = _source.spacing;
        this.saveDir = _source.saveDir;
        this.saveURL = _source.saveURL;
        this.saveFileName = _source.saveFileName;
    }

    public void deepCopy(ReportRTFObject _source) {
        super.deepCopy(_source);
        this.data = null;
        if (_source.data != null) {
            this.data = new byte[_source.data.length];
            for (int i = 0; i < this.data.length; ++i) {
                this.data[i] = _source.data[i];
            }
        }
        this.formats = _source.formats;
        this.formatMap = _source.formatMap;
        this.columnCount = _source.columnCount;
        this.spacing = _source.spacing;
    }

    public void copyTemplate(ReportRTFObject _cell) {
        this.copy(_cell);
    }

    public void applyTemplate(ReportRTFObject _cell) {
        this.copy(_cell);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeInt(this.columnCount);
        out.writeDouble(this.spacing);
        if (this.data == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeInt(this.data.length);
            for (byte element : this.data) {
                out.writeByte(element);
            }
        }
        if (this.formats == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.formats.size());
            for (int i = 0; i < this.formats.size(); ++i) {
                Object[] f = this.formats.elementAt(i);
                IOUtil.writeStr(out, (String)f[0]);
                FormatUtil.writeDataFormat(out, (IFormat)f[1]);
                out.writeInt((Integer)f[2]);
            }
        }
        if (this.formatMap == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.formatMap.size());
            for (int i = 0; i < this.formatMap.size(); ++i) {
                IOUtil.writeStr(out, (String)this.formatMap.elementAt(i));
            }
        }
    }

    @Override
    public void writeXML(Writer out, boolean writeElementTag) throws IOException {
        if (writeElementTag) {
            out.write("<RTFOBJECT>\n");
        }
        super.writeXML(out, false);
        out.write("<RTFOBJECT_COLUMNCOUNT>" + this.columnCount + "</RTFOBJECT_COLUMNCOUNT>\n");
        out.write("<RTFOBJECT_COLUMNSPACING>" + this.spacing + "</RTFOBJECT_COLUMNSPACING>");
        if (this.data != null) {
            int i;
            out.write("<RTFOBJECT_DATA><![CDATA[" + IOUtil.bytesToText(this.data) + "]]></RTFOBJECT_DATA>");
            for (i = 0; i < this.formats.size(); ++i) {
                Object[] f = this.formats.elementAt(i);
                out.write("<RTFOBJECT_FORMATNODE>");
                out.write("<NAME>" + (String)f[0] + "</NAME>");
                FormatUtil.writeXMLDataFormat(out, (IFormat)f[1]);
                out.write("<TYPE>" + ((Integer)f[2]).toString() + "</TYPE>");
                out.write("</RTFOBJECT_FORMATNODE>\n");
            }
            for (i = 0; i < this.formatMap.size(); ++i) {
                out.write("<RTFOBJECT_FORMATMAP>");
                out.write("<NAME>" + (String)this.formatMap.elementAt(i) + "</NAME>");
                out.write("</RTFOBJECT_FORMATMAP>\n");
            }
        }
        if (writeElementTag) {
            out.write("</RTFOBJECT>\n");
        }
    }

    public static ReportRTFObject createReportRTFObject(Node node, int version) throws Exception {
        if (!node.getNodeName().equalsIgnoreCase(XMLTAG)) {
            throw new Exception("'RTFOBJECT' element expected, but found '" + node.getNodeName() + "' element.");
        }
        ReportRTFObject cell = new ReportRTFObject(null);
        cell.readXML(node, version);
        return cell;
    }

    @Override
    public void readXML(Node node, int version) throws Exception {
        super.readXML(node, version);
        NodeList nodeList = node.getChildNodes();
        this.data = null;
        this.formats = new Vector();
        this.formatMap = new Vector();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            NodeList subNodeList;
            Node child = nodeList.item(i);
            if (child.getNodeName().equalsIgnoreCase("RTFOBJECT_DATA")) {
                String datastr = LoadXMLReportHelper.readCDATA(child);
                this.data = IOUtil.textToBytes(datastr);
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("RTFOBJECT_FORMATNODE")) {
                subNodeList = child.getChildNodes();
                Object[] f = new Object[3];
                for (int j = 0; j < subNodeList.getLength(); ++j) {
                    Node subChild = subNodeList.item(j);
                    if (subChild.getNodeName().equalsIgnoreCase("NAME")) {
                        f[0] = LoadXMLReportHelper.readText(subChild);
                        continue;
                    }
                    if (subChild.getNodeName().equalsIgnoreCase("TYPE")) {
                        f[2] = Integer.valueOf(LoadXMLReportHelper.readText(subChild));
                        continue;
                    }
                    if (f[1] != null) continue;
                    f[1] = FormatUtil.readXMLDataFormat(subChild, version);
                }
                if (f[0] == null || f[1] == null || f[2] == null) continue;
                this.formats.addElement(f);
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("RTFOBJECT_FORMATMAP")) {
                subNodeList = child.getChildNodes();
                for (int j = 0; j < subNodeList.getLength(); ++j) {
                    Node subChild = subNodeList.item(j);
                    if (!subChild.getNodeName().equalsIgnoreCase("NAME")) continue;
                    this.formatMap.addElement(LoadXMLReportHelper.readText(subChild));
                }
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("RTFOBJECT_COLUMNCOUNT")) {
                this.columnCount = Integer.parseInt(LoadXMLReportHelper.readText(child));
                continue;
            }
            if (!child.getNodeName().equalsIgnoreCase("RTFOBJECT_COLUMNSPACING")) continue;
            this.spacing = Double.parseDouble(LoadXMLReportHelper.readText(child));
        }
    }

    public static ReportRTFObject createReportRTFObject(DataInput in, int version) throws Exception {
        ReportRTFObject cell = new ReportRTFObject(null);
        cell.read(in, version);
        return cell;
    }

    @Override
    public void read(DataInput in, int version) throws Exception {
        boolean hasData;
        super.read(in, version);
        if (version >= 76 || version >= 52 && version < 70) {
            this.columnCount = in.readInt();
            this.spacing = in.readDouble();
        }
        if (hasData = in.readBoolean()) {
            this.data = new byte[in.readInt()];
            for (int i = 0; i < this.data.length; ++i) {
                this.data[i] = in.readByte();
            }
        }
        this.formats = new Vector();
        this.formatMap = new Vector();
        if (version >= 50) {
            int i;
            int count = in.readInt();
            for (i = 0; i < count; ++i) {
                Object[] f = new Object[]{IOUtil.readStr(in), FormatUtil.readDataFormat(in, version), in.readInt()};
                this.formats.addElement(f);
            }
            count = in.readInt();
            for (i = 0; i < count; ++i) {
                this.formatMap.addElement(IOUtil.readStr(in));
            }
        }
    }

    public Vector<Object[]> getFormats() {
        return this.formats;
    }

    public void setFormats(Vector<Object[]> f) {
        this.formats = f != null ? f : new Vector();
    }

    public void setData(byte[] d) {
        this.setData(d, (Vector<Object>)null);
    }

    public void setData(byte[] d, Vector<Object> f) {
        this.data = d;
        this.formatMap = f == null ? new Vector() : f;
    }

    public void addFormat(String formatName, IFormat format, int type) {
        if (this.formats == null) {
            this.formats = new Vector();
        }
        for (int i = this.formats.size() - 1; i >= 0; --i) {
            Object[] f = this.formats.elementAt(i);
            if (!f[0].equals(formatName)) continue;
            this.formats.removeElementAt(i);
        }
        Object[] f = new Object[]{formatName, format, type};
        this.formats.addElement(f);
    }

    public void removeFormat(String formatName) {
        for (int i = this.formats.size() - 1; i >= 0; --i) {
            Object[] f = this.formats.elementAt(i);
            if (!f[0].equals(formatName)) continue;
            this.formats.removeElementAt(i);
        }
    }

    public byte[] getData() {
        return this.data;
    }

    public boolean isBorderClosed() {
        return this.borderClosed;
    }

    public void setBorderClosed(boolean state) {
        this.borderClosed = state;
    }

    public void setColumnSpacing(double space) throws IllegalArgumentException {
        if (space < 0.0) {
            throw new IllegalArgumentException("Column spacing must be non-negative.");
        }
        this.spacing = space;
    }

    public double getColumnSpacing() {
        return this.spacing;
    }

    public void setColumnCount(int columnC) throws IllegalArgumentException {
        if (columnC < 1 || columnC > 4) {
            throw new IllegalArgumentException("Column count must be between 1 and 4 inclusive.");
        }
        this.columnCount = columnC;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public int getActualColumnCount() {
        int cCount = this.columnCount;
        while ((double)cCount + (double)(cCount - 1) * this.spacing > this.getWidth()) {
            --cCount;
        }
        if (cCount < 1) {
            return 1;
        }
        return cCount;
    }

    public double getColumnWidth() {
        if (this.getActualColumnCount() > 1) {
            double w = (this.getWidth() + this.getColumnSpacing()) / (double)this.getActualColumnCount() - this.getColumnSpacing();
            if (w > 0.0) {
                return w;
            }
            return 0.0;
        }
        return this.getWidth();
    }

    public Object[] getFormatMap() {
        if (this.formatMap == null) {
            return new Object[0];
        }
        Object[] ret = new Object[this.formatMap.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.formatMap.elementAt(i);
        }
        return ret;
    }

    public void setHTMLParameters(String dirLocation, String url, String prefix) {
        this.saveDir = dirLocation;
        this.saveURL = url;
        this.saveFileName = prefix;
        if (this.saveURL == null || this.saveDir == null) {
            this.saveDir = null;
            this.saveURL = null;
            this.saveFileName = null;
            return;
        }
        this.saveDir = this.saveDir.replace('\\', '/');
        if (!this.saveDir.endsWith("/")) {
            this.saveDir = this.saveDir + '/';
        }
        if (!this.saveURL.endsWith("/")) {
            this.saveURL = this.saveURL + '/';
        }
    }

    public String getSavedFileLocation() {
        if (this.saveDir == null) {
            return null;
        }
        return this.saveDir + this.saveFileName;
    }

    public String getSavedFileURL() {
        if (this.saveURL == null) {
            return null;
        }
        return this.saveURL + this.saveFileName;
    }

    @Override
    public short getAlign() {
        if (this.getColumnCount() > 1) {
            return 1;
        }
        return super.getAlign();
    }
}

