/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.ReportElements;

import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.lang.reflect.Array;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import quadbase.common.util.internal.FileInMemTable;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.QbUtil;
import quadbase.reportdesigner.ReportElements.CBAggrColFooter;
import quadbase.reportdesigner.ReportElements.CBAggrColHeader;
import quadbase.reportdesigner.ReportElements.CBAggrColumn;
import quadbase.reportdesigner.ReportElements.CBColumnFooter;
import quadbase.reportdesigner.ReportElements.CBColumnHeader;
import quadbase.reportdesigner.ReportElements.ColumnBreakColumn;
import quadbase.reportdesigner.ReportElements.ColumnHeader;
import quadbase.reportdesigner.ReportElements.ColumnWrap;
import quadbase.reportdesigner.ReportElements.GuideLine;
import quadbase.reportdesigner.ReportElements.RBColumnHeader;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportChartObject;
import quadbase.reportdesigner.ReportElements.ReportColumn;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.ReportElements.ReportGrid;
import quadbase.reportdesigner.ReportElements.ReportImage;
import quadbase.reportdesigner.ReportElements.ReportLine;
import quadbase.reportdesigner.ReportElements.ReportRTFObject;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.ReportElements.ReportTableElement;
import quadbase.reportdesigner.ReportElements.ReportTitle;
import quadbase.reportdesigner.ReportElements.SubReportObject;
import quadbase.reportdesigner.ReportElements.TableOfContents;
import quadbase.reportdesigner.report.Formula;
import quadbase.reportdesigner.report.LoadXMLReportHelper;
import quadbase.reportdesigner.report.NewFormulaParser;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.SaveReport;
import quadbase.reportdesigner.report.Script;
import quadbase.reportdesigner.util.IAggregateConstants;
import quadbase.reportdesigner.util.IReport;
import quadbase.reportdesigner.util.ISubReport;
import quadbase.reportdesigner.util.internal.FormatUtil;

public class ReportSection
extends ReportTableElement {
    protected ReportCell[] cells;
    private boolean repeatOnEveryPage;
    private boolean isResetPageNumber = false;
    private boolean isNewExcelSheet = false;
    protected boolean isModified = false;
    private Hashtable<Vector<Integer>, Vector<ReportCell>> sectionCellsTable = null;
    private Hashtable<Vector<Integer>, Hashtable<Integer, ReportCell>> formattedCellsTable = null;
    private Hashtable<Vector<Integer>, Double> heightTable = null;
    protected ReportSection parentSection = null;
    protected Vector<ReportSection> sectionList = new Vector();
    private ReportCell sectionStyle;
    public static final String XMLTAG = "REPORTSECTION";
    private static final String REPORT_FOOTER_ID = "quick_designer_report_footer";
    private static final String GROUP_FOOTER_ID = "quick_designer_group_footer";

    public ReportSection() {
        this.setBorderThickness(0);
        this.setBgColor(null);
        this.cells = new ReportCell[0];
    }

    public ReportSection(String sectionID) {
        super(sectionID);
        this.setBorderThickness(0);
        this.setBgColor(null);
        this.cells = new ReportCell[0];
        this.setID(sectionID);
    }

    public ReportSection(String sectionID, String text) {
        this(text);
        this.setID(sectionID);
    }

    public ReportSection(ReportTableElement reporttableelement) {
        this();
        this.copy(reporttableelement);
    }

    public ReportSection(ReportCell[] areportcell) {
        this();
        this.setData(areportcell);
    }

    public ReportCell[] getCells() {
        return this.cells;
    }

    public boolean hasCell(ReportCell cell) {
        if (this.cells != null) {
            for (ReportCell cell2 : this.cells) {
                if (cell2 != cell) continue;
                return true;
            }
        }
        return false;
    }

    public ReportImage[] getReportImages() {
        return this.getReportImages(true);
    }

    public ReportImage[] getReportImages(boolean includeSubSections) {
        Vector<ReportCell> images = new Vector<ReportCell>();
        for (ReportCell cell : this.cells) {
            if (!(cell instanceof ReportImage)) continue;
            images.addElement(cell);
        }
        if (this.sectionList != null && includeSubSections) {
            for (int i = 0; i < this.sectionList.size(); ++i) {
                Object[] temp = this.sectionList.elementAt(i).getReportImages(false);
                QbUtil.addArrayToVector(images, temp);
            }
        }
        ReportImage[] tmp = new ReportImage[images.size()];
        for (int i = 0; i < images.size(); ++i) {
            tmp[i] = (ReportImage)images.elementAt(i);
        }
        return tmp;
    }

    public ReportChartObject[] getReportChartObjects() {
        return this.getReportChartObjects(true);
    }

    public ReportChartObject[] getReportChartObjects(boolean includeSubSections) {
        Vector<ReportChartObject> charts = new Vector<ReportChartObject>();
        for (ReportCell cell : this.cells) {
            if (!(cell instanceof ReportChartObject)) continue;
            charts.addElement((ReportChartObject)cell);
        }
        if (this.sectionList != null && includeSubSections) {
            for (int i = 0; i < this.sectionList.size(); ++i) {
                Object[] temp = this.sectionList.elementAt(i).getReportChartObjects(false);
                QbUtil.addArrayToVector(charts, temp);
            }
        }
        ReportChartObject[] tmp = new ReportChartObject[charts.size()];
        for (int i = 0; i < charts.size(); ++i) {
            tmp[i] = (ReportChartObject)charts.elementAt(i);
        }
        return tmp;
    }

    public ReportCell[] getTextCells() {
        Vector<ReportCell> textCells = new Vector<ReportCell>();
        for (int i = 0; i < this.cells.length; ++i) {
            if (this.cells[i] instanceof ReportImage) continue;
            textCells.addElement(this.cells[i]);
        }
        if (textCells.size() == 0) {
            return null;
        }
        ReportCell[] tmp = new ReportCell[textCells.size()];
        for (int i = 0; i < textCells.size(); ++i) {
            tmp[i] = (ReportCell)textCells.elementAt(i);
        }
        return tmp;
    }

    public void addData(ReportCell reportcell) {
        if (!this.getID().equals("") && reportcell.getID().equals("")) {
            reportcell.setID(this.getID(), this.cells);
        }
        ReportCell[] areportcell = new ReportCell[this.cells != null ? this.cells.length + 1 : 1];
        for (int i = 0; i < areportcell.length - 1; ++i) {
            areportcell[i] = this.cells[i];
        }
        areportcell[areportcell.length - 1] = reportcell;
        this.setData(areportcell);
        this.cells = this.sortCell(1, true);
    }

    public void addSectionCell(ReportCell reportcell, int[] tree) {
        this.addSectionCell(reportcell, this.convertToVector(tree));
    }

    public void addSectionCell(ReportCell reportcell, Vector<Integer> key) {
        Vector<ReportCell> cellArray;
        if (this.sectionCellsTable == null) {
            this.sectionCellsTable = new Hashtable();
        }
        if (this.sectionCellsTable.containsKey(key)) {
            cellArray = this.sectionCellsTable.get(key);
            if (cellArray == null) {
                cellArray = new Vector();
            }
            cellArray.addElement(reportcell);
        } else {
            cellArray = new Vector<ReportCell>();
            cellArray.addElement(reportcell);
        }
        if (!this.getID().equals("") && reportcell.getID().equals("")) {
            reportcell.setID(this.getID(), QbUtil.toArray(cellArray));
        }
        this.sectionCellsTable.put(key, cellArray);
        this.isModified = true;
    }

    public void deleteSectionCell(ReportCell reportCell, int[] tree) {
        this.deleteSectionCell(reportCell, this.convertToVector(tree));
    }

    public void deleteSectionCell(ReportCell reportCell, Vector<Integer> key) {
        if (this.sectionCellsTable == null || key == null) {
            return;
        }
        if (!this.sectionCellsTable.containsKey(key)) {
            return;
        }
        Vector<ReportCell> cellArray = this.sectionCellsTable.get(key);
        if (cellArray == null) {
            return;
        }
        cellArray.removeElement(reportCell);
    }

    public boolean hasSectionCells(int[] tree) {
        return this.hasSectionCells(this.convertToVector(tree));
    }

    public boolean hasSectionCells(Vector<Integer> key) {
        if (this.sectionCellsTable != null && key != null) {
            return this.sectionCellsTable.containsKey(key);
        }
        return false;
    }

    public boolean hasSectionCell(ReportCell cell, int[] tree) {
        return this.hasSectionCell(cell, this.convertToVector(tree));
    }

    public boolean hasSectionCell(ReportCell cell, Vector<Integer> key) {
        if (this.hasSectionCells(key)) {
            Vector<ReportCell> sectionCells = this.sectionCellsTable.get(key);
            for (int i = 0; i < sectionCells.size(); ++i) {
                if (sectionCells.elementAt(i) != cell) continue;
                return true;
            }
        }
        return false;
    }

    public Vector<ReportCell> getSectionCells(int[] tree) {
        return this.getSectionCells(this.convertToVector(tree));
    }

    public Vector<ReportCell> getSectionCells(Vector<Integer> key) {
        if (this.hasSectionCells(key)) {
            return this.sectionCellsTable.get(key);
        }
        return null;
    }

    public Hashtable<Vector<Integer>, Vector<ReportCell>> getSectionCellsTable() {
        return this.sectionCellsTable;
    }

    public int getSectionCellsCount() {
        if (this.sectionCellsTable != null) {
            return this.sectionCellsTable.size();
        }
        return 0;
    }

    public void setHeightOfSection(double height, int[] tree) {
        this.addToHeightTable(height, this.convertToVector(tree));
    }

    public void addToHeightTable(double height, Vector<Integer> key) {
        if (this.heightTable == null) {
            this.heightTable = new Hashtable();
        }
        Double value = height;
        this.heightTable.put(key, value);
    }

    public double getHeightOfSection(int[] tree) {
        return this.getHeight(this.convertToVector(tree));
    }

    public double getHeight(Vector<Integer> key) {
        Double value;
        if (this.heightTable != null && key != null && (value = this.heightTable.get(key)) != null) {
            return value;
        }
        return -1.0;
    }

    public Hashtable<Vector<Integer>, Double> getHeightTable() {
        return this.heightTable;
    }

    public void setHeightTable(Hashtable<Vector<Integer>, Double> table) {
        this.heightTable = table;
    }

    public int getHeightTableCount() {
        if (this.heightTable != null) {
            return this.heightTable.size();
        }
        return 0;
    }

    public void addFormattedCell(ReportCell newCell, ReportCell oldCell, Vector<Integer> key) {
        int i;
        if (this.formattedCellsTable == null) {
            this.formattedCellsTable = new Hashtable();
        }
        for (i = 0; i < this.cells.length && this.cells[i] != oldCell; ++i) {
        }
        if (this.formattedCellsTable.containsKey(key)) {
            Hashtable<Integer, ReportCell> cellTable = this.formattedCellsTable.get(key);
            cellTable.put(i, newCell);
        } else {
            Hashtable<Integer, ReportCell> cellTable = new Hashtable<Integer, ReportCell>();
            cellTable.put(i, newCell);
            this.formattedCellsTable.put(key, cellTable);
        }
        this.isModified = true;
    }

    public boolean hasFormattedCell(Vector<Integer> key) {
        if (this.formattedCellsTable == null || key == null) {
            return false;
        }
        return this.formattedCellsTable.containsKey(key);
    }

    public boolean hasFormattedCell(ReportCell old, Vector<Integer> key) {
        if (this.hasFormattedCell(key)) {
            int i;
            Hashtable<Integer, ReportCell> cellTable = this.formattedCellsTable.get(key);
            for (i = 0; i < this.cells.length && this.cells[i] != old; ++i) {
            }
            return cellTable.containsKey(i);
        }
        return false;
    }

    public boolean hasThisFormattedCell(ReportCell cell, Vector<Integer> key) {
        if (this.hasFormattedCell(key)) {
            Hashtable<Integer, ReportCell> cellTable = this.formattedCellsTable.get(key);
            return cellTable.contains(cell);
        }
        return false;
    }

    public ReportCell getFormattedCell(ReportCell old, Vector<Integer> key) {
        if (this.hasFormattedCell(key)) {
            int i;
            Hashtable<Integer, ReportCell> cellTable = this.formattedCellsTable.get(key);
            for (i = 0; i < this.cells.length && this.cells[i] != old; ++i) {
            }
            return cellTable.get(i);
        }
        return null;
    }

    public Hashtable<Integer, ReportCell> getFormattedCells(Vector<Integer> key) {
        if (!this.hasFormattedCell(key)) {
            return null;
        }
        return this.formattedCellsTable.get(key);
    }

    public void replaceCell(ReportCell newCell, ReportCell oldCell, int[] tree) {
        this.addFormattedCell(newCell, oldCell, this.convertToVector(tree));
    }

    public boolean hasFormattedCell(int[] tree) {
        return this.hasFormattedCell(this.convertToVector(tree));
    }

    public boolean hasFormattedCell(ReportCell old, int[] tree) {
        return this.hasFormattedCell(old, this.convertToVector(tree));
    }

    public ReportCell getFormattedCell(ReportCell old, int[] tree) {
        return this.getFormattedCell(old, this.convertToVector(tree));
    }

    public Hashtable getFormattedCells(int[] tree) {
        return this.getFormattedCells(this.convertToVector(tree));
    }

    private Vector<Integer> convertToVector(int[] tree) {
        Vector<Integer> v = new Vector<Integer>();
        for (int element : tree) {
            v.addElement(element);
        }
        return v;
    }

    public Hashtable<Vector<Integer>, Hashtable<Integer, ReportCell>> getFormattedCellsTable() {
        return this.formattedCellsTable;
    }

    public void setFormattedCellsTable(Hashtable cellArray) {
        this.formattedCellsTable = null;
    }

    public int getFormattedCellsCount() {
        if (this.formattedCellsTable != null) {
            return this.formattedCellsTable.size();
        }
        return 0;
    }

    public void superCopy(ReportSection reportSection) {
        super.copy(reportSection);
    }

    public void copy(ReportSection reportSection) {
        this.copy(reportSection, 0, -1, null, null, false);
    }

    public void copy(ReportSection reportSection, int columnOffset, int separatingIndex, Vector columns, ReportCell[] globalFormatTemplates, boolean isApplyTemplateOp) {
        this.copy(reportSection, columnOffset, separatingIndex, columns, globalFormatTemplates, isApplyTemplateOp, false);
    }

    public void copy(ReportSection reportSection, int columnOffset, int separatingIndex, Vector columns, ReportCell[] globalFormatTemplates, boolean isApplyTemplateOp, boolean copyEmptySection) {
        this.copy(reportSection, columnOffset, separatingIndex, columns, globalFormatTemplates, isApplyTemplateOp, copyEmptySection, true);
    }

    public void copy(ReportSection reportSection, int columnOffset, int separatingIndex, Vector columns, ReportCell[] globalFormatTemplates, boolean isApplyTemplateOp, boolean copyEmptySection, boolean copyGuideLine) {
        this.copy(reportSection, columnOffset, separatingIndex, columns, globalFormatTemplates, isApplyTemplateOp, copyEmptySection, copyGuideLine, true);
    }

    public void copy(ReportSection reportSection, int columnOffset, int separatingIndex, Vector columns, ReportCell[] globalFormatTemplates, boolean isApplyTemplateOp, boolean copyEmptySection, boolean copyGuideLine, boolean applyScript) {
        this.copy(reportSection, columnOffset, separatingIndex, columns, globalFormatTemplates, isApplyTemplateOp, copyEmptySection, copyGuideLine, applyScript, false);
    }

    public void copy(ReportSection reportSection, int columnOffset, int separatingIndex, Vector columns, ReportCell[] globalFormatTemplates, boolean isApplyTemplateOp, boolean copyEmptySection, boolean copyGuideLine, boolean applyScript, boolean keepElt) {
        this.copy(reportSection, columnOffset, separatingIndex, columns, globalFormatTemplates, isApplyTemplateOp, copyEmptySection, copyGuideLine, applyScript, keepElt, null, null, null);
    }

    public static Vector<ReportElement> getFirstRowOfColumns(Vector<ReportElement> columns) {
        if (columns == null) {
            return null;
        }
        Vector<ReportElement>[] vec = ReportElement.getFirst2RowOfColumns(columns);
        ReportElement[] elt = ReportElement.sortElement(ReportElement.convertToREltArray(vec[0]), 1, true);
        return ReportElement.convertToVector(elt);
    }

    public static Vector<ReportElement> getFirstRowOfUnsortedColumns(Vector<ReportElement> columns) {
        if (columns == null) {
            return null;
        }
        Vector<ReportElement>[] vec = ReportElement.getFirst2RowOfColumns(columns);
        return vec[0];
    }

    public void copy(ReportSection reportSection, int columnOffset, int separatingIndex, Vector columns, ReportCell[] globalFormatTemplates, boolean isApplyTemplateOp, boolean copyEmptySection, boolean copyGuideLine, boolean applyScript, boolean keepElt, int[] fieldsCount, ReportSection parentHeader, Vector newColumns) {
        ReportCell[] newCells;
        super.copy(reportSection);
        this.setRepeatOnEveryPage(reportSection.isRepeatOnEveryPage());
        this.setResetPageNumber(reportSection.isResetPageNumber());
        this.setNewExcelSheet(reportSection.isNewExcelSheet());
        this.isModified = reportSection.isModified;
        this.setSectionStyle(reportSection.getSectionStyle());
        ReportSection temp = null;
        if (columnOffset != 0 && separatingIndex >= 0 && columns != null && reportSection.getCellCount() > 0) {
            newCells = null;
            temp = new ReportSection();
            temp.setDataForDeepCopy(reportSection.getData());
            reportSection.adjustColumnIndex(columnOffset, separatingIndex, columns, globalFormatTemplates, newColumns != null ? newColumns.size() : columns.size());
            if (newCells != null) {
                ReportCell columnHeaderSettings = null;
                ReportCell stringFormulaSettings = null;
                ReportCell logicFormulaSettings = null;
                ReportCell numericFormulaSettings = null;
                ReportCell timeFormulaSettings = null;
                if (globalFormatTemplates != null && globalFormatTemplates.length > 0) {
                    stringFormulaSettings = globalFormatTemplates[0];
                }
                if (globalFormatTemplates != null && globalFormatTemplates.length > 1) {
                    columnHeaderSettings = globalFormatTemplates[1];
                }
                if (globalFormatTemplates != null && globalFormatTemplates.length > 2) {
                    logicFormulaSettings = globalFormatTemplates[2];
                }
                if (globalFormatTemplates != null && globalFormatTemplates.length > 3) {
                    numericFormulaSettings = globalFormatTemplates[3];
                }
                if (globalFormatTemplates != null && globalFormatTemplates.length > 4) {
                    timeFormulaSettings = globalFormatTemplates[4];
                }
                double supposeXPos = 0.0;
                if (separatingIndex - 1 >= 0 && separatingIndex - 1 < columns.size()) {
                    supposeXPos = ((ReportColumn)columns.elementAt(separatingIndex - 1)).getX() + ((ReportColumn)columns.elementAt(separatingIndex - 1)).getWidth();
                }
                for (ReportCell newCell : newCells) {
                    if (newCell == null) continue;
                    double x = newCell.getX();
                    boolean isVisible = newCell.isVisible();
                    if (this.idExists(newCell.getID(), reportSection.getData())) {
                        newCell.setID(this.getID(), reportSection.getData());
                    }
                    if (reportSection.getCellCount() > 0 && reportSection.getData(reportSection.getCellCount() - 1) != null && !(reportSection.getData(reportSection.getCellCount() - 1) instanceof ReportLine)) {
                        newCell.applyTemplate(reportSection.getData(reportSection.getCellCount() - 1), true);
                    }
                    if (newCell instanceof ColumnHeader && columnHeaderSettings != null) {
                        newCell.applyTemplate(columnHeaderSettings, true);
                        x = x * columnHeaderSettings.getWidth() + supposeXPos;
                    } else if (stringFormulaSettings != null && FormatUtil.isFormatAppliabled(newCell.getDataFormat(), stringFormulaSettings.getDataFormat())) {
                        newCell.applyTemplate(stringFormulaSettings, true);
                        x = x * stringFormulaSettings.getWidth() + supposeXPos;
                    } else if (logicFormulaSettings != null && FormatUtil.isFormatAppliabled(newCell.getDataFormat(), logicFormulaSettings.getDataFormat())) {
                        newCell.applyTemplate(logicFormulaSettings, true);
                        x = x * logicFormulaSettings.getWidth() + supposeXPos;
                    } else if (numericFormulaSettings != null && FormatUtil.isFormatAppliabled(newCell.getDataFormat(), numericFormulaSettings.getDataFormat())) {
                        newCell.applyTemplate(numericFormulaSettings, true);
                        x = x * numericFormulaSettings.getWidth() + supposeXPos;
                    } else if (timeFormulaSettings != null && FormatUtil.isFormatAppliabled(newCell.getDataFormat(), timeFormulaSettings.getDataFormat())) {
                        newCell.applyTemplate(timeFormulaSettings, true);
                        x = x * timeFormulaSettings.getWidth() + supposeXPos;
                    }
                    newCell.setX(x);
                    newCell.setVisible(isVisible);
                    reportSection.addData(newCell);
                }
            }
        }
        if (!isApplyTemplateOp || copyEmptySection || reportSection.getData() != null && reportSection.getData().length > 0) {
            if (reportSection.isLineOnly() && keepElt && reportSection.getData() != null && reportSection.getData().length > 0) {
                for (ReportCell cell : reportSection.cells) {
                    this.addData(cell);
                }
            } else {
                newCells = reportSection.getData();
                for (int j = 0; j < newCells.length; ++j) {
                    ReportCell newCell = newCells[j];
                    if (j >= this.cells.length || !this.cells[j].getID().equals(newCell.getID()) || !this.cells[j].getClass().equals(newCell.getClass())) continue;
                    newCells[j] = this.cells[j];
                    newCells[j].applyTemplate(newCell);
                    if (newCells[j] instanceof ColumnHeader) {
                        ((ColumnHeader)newCells[j]).isFormula = ((ColumnHeader)newCell).isFormula;
                        newCells[j].setText(newCell.getText());
                        boolean visible = newCells[j].isVisible();
                        newCells[j].copyTemplate(newCell);
                        if (visible || !newCells[j].isVisible()) continue;
                        newCells[j].setVisible(false);
                        continue;
                    }
                    if (newCells[j] instanceof RBColumnHeader) {
                        ((RBColumnHeader)newCells[j]).isFormula = ((RBColumnHeader)newCell).isFormula;
                        continue;
                    }
                    newCells[j].setText(newCell.getText());
                    newCells[j].copyTemplate(newCell);
                    newCells[j].setDataFormat(newCell.getDataFormat());
                }
                this.setData(newCells);
                if (isApplyTemplateOp) {
                    for (int i = 0; i < this.cells.length; ++i) {
                        this.cells[i].securityMap = null;
                        if (applyScript) continue;
                        this.cells[i].setScriptName(null);
                        this.cells[i].setScriptObj(null);
                        this.cells[i].setScript(null);
                    }
                }
            }
        }
        Vector<ReportSection> newSectionList = new Vector<ReportSection>();
        for (int i = 0; i < reportSection.sectionList.size(); ++i) {
            ReportSection subSection = reportSection.sectionList.elementAt(i);
            ReportSection _subSection = new ReportSection();
            _subSection.copy(subSection);
            if (!isApplyTemplateOp || copyEmptySection || _subSection.getData() != null && _subSection.getData().length > 0) {
                newSectionList.addElement(_subSection);
                _subSection.parentSection = this;
                if (isApplyTemplateOp && !applyScript) {
                    for (int j = 0; j < _subSection.getCellCount(); ++j) {
                        _subSection.getData(j).setScriptName(null);
                        _subSection.getData(j).setScriptObj(null);
                        _subSection.getData(j).setScript(null);
                    }
                }
            } else if (this.sectionList.size() > i) {
                newSectionList.addElement(this.sectionList.elementAt(i));
            }
            if (copyGuideLine) continue;
            _subSection.setData(_subSection.getDataNoGuideLine());
        }
        this.sectionList = newSectionList;
        if (temp != null) {
            reportSection.setData(temp.getData());
        }
        if (!copyGuideLine) {
            this.setData(this.getDataNoGuideLine());
        }
    }

    int countAggrColumns(Vector<ReportElement> columns, int aggrIdx, int colBkVal) {
        int ct = 0;
        for (int i = 0; i < columns.size(); ++i) {
            if (!(columns.elementAt(i) instanceof CBAggrColumn) || ((CBAggrColumn)columns.elementAt(i)).getColBreakLevel() != aggrIdx || ((CBAggrColumn)columns.elementAt(i)).getColBreakValueIndex() != colBkVal) continue;
            ++ct;
        }
        return ct;
    }

    boolean isLineOnly() {
        for (int i = 0; i < this.cells.length; ++i) {
            if (this.cells[i] instanceof ReportLine && !((ReportLine)this.cells[i]).isVertical()) continue;
            return false;
        }
        return true;
    }

    public void deepCopy(ReportSection reportSection) {
        super.deepCopy(reportSection);
        this.setRepeatOnEveryPage(reportSection.isRepeatOnEveryPage());
        this.setResetPageNumber(reportSection.isResetPageNumber());
        this.setNewExcelSheet(reportSection.isNewExcelSheet());
        this.isModified = reportSection.isModified;
        this.setDataForDeepCopy(reportSection.getData());
        this.setSectionStyle(reportSection.getSectionStyle());
        this.sectionList = new Vector();
        if (reportSection.sectionList != null) {
            for (int i = 0; i < reportSection.sectionList.size(); ++i) {
                ReportSection section = this.addSection();
                try {
                    section.deepCopy(reportSection.getSection(i));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void copyTemplate(ReportSection reportSection) {
        this.copyTemplate(reportSection, true);
    }

    public void copyTemplate(ReportSection reportSection, boolean copyEmptySection) {
        this.copyTemplate(reportSection, copyEmptySection, true);
    }

    public void copyTemplate(ReportSection reportSection, boolean copyEmptySection, boolean applyScript) {
        this.copyTemplate(reportSection, copyEmptySection, applyScript, null, null);
    }

    public void copyTemplate(ReportSection reportSection, boolean copyEmptySection, boolean applyScript, Vector columns, int[] fieldsCount) {
        Vector<ReportCell> oldsubreports = this.getOldSubReports();
        Vector<ReportSection> oldSectionList = this.sectionList;
        this.copy(reportSection, 0, -1, columns, null, true, copyEmptySection, false, applyScript, false, fieldsCount, null, null);
        this.copyTemplates(oldsubreports, oldSectionList);
    }

    protected Vector<ReportCell> getOldSubReports() {
        ReportCell[] oldData = this.getData();
        Vector<ReportCell> oldsubreports = new Vector<ReportCell>();
        try {
            for (ReportCell element : oldData) {
                if (!(element instanceof SubReportObject)) continue;
                oldsubreports.addElement(element);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return oldsubreports;
    }

    protected void copyTemplates(Vector<ReportCell> oldsubreports, Vector<ReportSection> oldSectionList) {
        block12: {
            int i2;
            ReportCell[] oldData = this.getData();
            try {
                this.removeAllSubReports();
                for (i2 = 0; i2 < oldsubreports.size(); ++i2) {
                    this.addData(oldsubreports.elementAt(i2));
                }
            }
            catch (Exception i2) {
                // empty catch block
            }
            if (this.sectionList != null) {
                for (i2 = 0; i2 < this.sectionList.size(); ++i2) {
                    this.sectionList.elementAt(i2).removeAllSubReports();
                }
            }
            if (oldSectionList == null) break block12;
            if (this.sectionList != null && this.sectionList.size() > 0) {
                for (i2 = 0; i2 < oldSectionList.size(); ++i2) {
                    if (i2 < this.sectionList.size()) {
                        try {
                            oldSectionList.elementAt(i2).copyTemplate(this.sectionList.elementAt(i2));
                            this.sectionList.insertElementAt(oldSectionList.elementAt(i2), i2);
                            this.sectionList.removeElementAt(i2 + 1);
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    this.sectionList.addElement(oldSectionList.elementAt(i2));
                }
            } else {
                this.sectionList = oldSectionList;
                for (i2 = 0; i2 < this.sectionList.size(); ++i2) {
                    this.sectionList.elementAt(i2).setData(this.sectionList.elementAt(i2).getDataNoGuideLine());
                }
            }
        }
    }

    private void removeAllSubReports() {
        int i;
        ReportCell[] oldData = this.getData();
        for (i = oldData.length - 1; i >= 0; --i) {
            if (!(oldData[i] instanceof SubReportObject)) continue;
            this.removeData(i);
        }
        if (this.sectionList != null) {
            for (i = 0; i < this.sectionList.size(); ++i) {
                this.sectionList.elementAt(i).removeAllSubReports();
            }
        }
    }

    @Deprecated
    public void applyTemplate(ReportSection reportSection) {
        super.applyTemplate(reportSection);
        this.setRepeatOnEveryPage(reportSection.isRepeatOnEveryPage());
        this.setResetPageNumber(reportSection.isResetPageNumber());
        this.setNewExcelSheet(reportSection.isNewExcelSheet());
        this.isModified = reportSection.isModified;
        if (this.cells != null && reportSection.cells != null) {
            int len = this.cells.length < reportSection.cells.length ? this.cells.length : reportSection.cells.length;
            for (int i = 0; i < len; ++i) {
                this.cells[i].applyTemplate(reportSection.cells[i]);
            }
        }
        this.sectionList = reportSection.sectionList;
        this.setSectionStyle(reportSection.getSectionStyle());
    }

    public Vector getCellForHTML() {
        return this.getReportCellForHTML(this.cells);
    }

    public Vector getTextCellForHTML() {
        return this.getTextCellForHTML(false);
    }

    public Vector getTextCellForHTML(boolean reverseOrder) {
        Vector<ReportCell> vecCells = new Vector<ReportCell>();
        for (ReportCell cell : this.cells) {
            if (cell instanceof ReportImage || cell instanceof SubReportObject) continue;
            vecCells.addElement(cell);
        }
        ReportCell[] arrCells = new ReportCell[vecCells.size()];
        int j = 0;
        if (reverseOrder) {
            j = arrCells.length - 1;
        }
        for (int i = 0; i < arrCells.length; ++i) {
            arrCells[i] = (ReportCell)vecCells.elementAt(j);
            if (reverseOrder) {
                --j;
                continue;
            }
            ++j;
        }
        return this.getReportCellForHTML(arrCells);
    }

    public Vector getSubReportForHTML() {
        Vector<ReportCell> vecCells = new Vector<ReportCell>();
        for (ReportCell cell : this.cells) {
            if (!(cell instanceof SubReportObject)) continue;
            vecCells.addElement(cell);
        }
        ReportCell[] arrCells = new ReportCell[vecCells.size()];
        for (int i = 0; i < arrCells.length; ++i) {
            arrCells[i] = (ReportCell)vecCells.elementAt(i);
        }
        return this.getReportCellForHTML(arrCells);
    }

    public int getCellCount() {
        if (this.cells == null) {
            return 0;
        }
        return this.cells.length;
    }

    public boolean hasNoDrawableData() {
        if (!this.isVisible() || this.getData() == null || this.getCellCount() == 0) {
            return true;
        }
        return this.getCellCount() == 1 && this.cells[0] instanceof ColumnWrap;
    }

    public boolean hasNoDrawableData(Vector key) {
        if (this.hasSectionCells(key)) {
            return false;
        }
        if (!this.isVisible() || this.getData() == null || this.getCellCount() == 0) {
            return true;
        }
        return this.getCellCount() == 1 && this.cells[0] instanceof ColumnWrap;
    }

    public ReportCell[] getData() {
        return this.cells;
    }

    public ReportCell[] getData(boolean includeSubSections) {
        int i;
        Vector<ReportCell> list = new Vector<ReportCell>();
        for (i = 0; i < this.cells.length; ++i) {
            if (this.cells[i].getCustomID().equals(GROUP_FOOTER_ID)) continue;
            list.addElement(this.cells[i]);
        }
        if (this.sectionList != null && includeSubSections) {
            for (i = 0; i < this.sectionList.size(); ++i) {
                Object[] temp = this.sectionList.elementAt(i).getData(false);
                QbUtil.addArrayToVector(list, temp);
            }
        }
        ReportCell[] tmp = new ReportCell[list.size()];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            tmp[i2] = (ReportCell)list.elementAt(i2);
        }
        return tmp;
    }

    public boolean sameSection(ReportElement _sec, boolean includeSubSections) {
        if (this == _sec) {
            return true;
        }
        if (this.sectionList != null && includeSubSections) {
            for (int i = 0; i < this.sectionList.size(); ++i) {
                if (this.sectionList.elementAt(i) != _sec) continue;
                return true;
            }
        }
        return false;
    }

    public ReportCell[] getDataNoGuideLine() {
        int count = this.cells.length;
        for (ReportCell cell : this.cells) {
            if (!(cell instanceof GuideLine)) continue;
            --count;
        }
        ReportCell[] temp = new ReportCell[count];
        count = 0;
        for (int i = 0; i < this.cells.length; ++i) {
            if (this.cells[i] instanceof GuideLine) continue;
            this.cells[i].setSnap((short)0);
            this.cells[i].setVSnap((short)0);
            temp[count] = this.cells[i];
            ++count;
        }
        return temp;
    }

    public ReportCell getData(int i) {
        return this.cells[i];
    }

    public ReportCell[] getDataIgnoreRepeatCells() {
        Vector<ReportCell> ncells = new Vector<ReportCell>();
        for (int i = 0; i < this.cells.length; ++i) {
            if (this.cells[i] instanceof CBColumnHeader || this.cells[i] instanceof RBColumnHeader || this.cells[i] instanceof CBAggrColHeader || this.cells[i] instanceof CBColumnFooter || this.cells[i] instanceof CBAggrColFooter) continue;
            ncells.add(this.cells[i]);
        }
        ReportCell[] cArr = new ReportCell[ncells.size()];
        for (int i = 0; i < cArr.length; ++i) {
            cArr[i] = (ReportCell)ncells.elementAt(i);
        }
        return cArr;
    }

    public ReportCell[] getDataIgnoreReportImages() {
        Vector<ReportCell> ncells = new Vector<ReportCell>();
        for (int i = 0; i < this.cells.length; ++i) {
            if (this.cells[i] instanceof ReportImage) continue;
            ncells.add(this.cells[i]);
        }
        ReportCell[] cArr = new ReportCell[ncells.size()];
        for (int i = 0; i < cArr.length; ++i) {
            cArr[i] = (ReportCell)ncells.elementAt(i);
        }
        return cArr;
    }

    public CBColumnHeader getFirstCBColumnHeader(int colBkValIdx) {
        int backup = this.cells.length - 1;
        for (int i = 0; i < this.cells.length; ++i) {
            if (!(this.cells[i] instanceof CBColumnHeader)) continue;
            backup = i;
            if (((CBColumnHeader)this.cells[i]).getColBreakValueIndex() != colBkValIdx) continue;
            return (CBColumnHeader)this.cells[i];
        }
        return (CBColumnHeader)this.cells[backup];
    }

    public ReportCell getFirstCBColumnFooter(int colBkValIdx) {
        for (ReportCell cell : this.cells) {
            if (!(cell instanceof CBColumnFooter) || ((CBColumnFooter)cell).getColBreakValueIndex() != colBkValIdx) continue;
            return cell;
        }
        return null;
    }

    public ReportCell getFirstCBAggrColHeader(int level, int colBkValIdx) {
        int backup = this.cells.length - 1;
        for (int i = 0; i < this.cells.length; ++i) {
            if (!(this.cells[i] instanceof CBAggrColHeader) || ((CBAggrColHeader)this.cells[i]).getColBreakLevel() != level) continue;
            backup = i;
            if (((CBAggrColHeader)this.cells[i]).getColBreakValueIndex() != colBkValIdx) continue;
            return this.cells[i];
        }
        return this.cells[backup];
    }

    public ReportCell getFirstRBColumnHeader(int level) {
        for (ReportCell cell : this.cells) {
            if (!(cell instanceof RBColumnHeader) || ((RBColumnHeader)cell).getColBreakLevel() != level) continue;
            return cell;
        }
        return null;
    }

    public ReportCell getFirstCBAggrColFooter(int level, int colBkValIdx) {
        for (ReportCell cell : this.cells) {
            if (!(cell instanceof CBAggrColFooter) || ((CBAggrColFooter)cell).getColBreakLevel() != level || ((CBAggrColFooter)cell).getColBreakValueIndex() != colBkValIdx) continue;
            return cell;
        }
        return null;
    }

    public ReportCell getData(String cellId) {
        for (ReportCell cell : this.cells) {
            if (!cell.getID().equals(cellId)) continue;
            return cell;
        }
        for (ReportCell cell : this.cells) {
            if (!cell.getCustomID().equals(cellId)) continue;
            return cell;
        }
        if (this.sectionList != null) {
            for (int i = 0; i < this.sectionList.size(); ++i) {
                ReportCell temp = this.sectionList.elementAt(i).getData(cellId);
                if (temp == null) continue;
                return temp;
            }
        }
        return null;
    }

    public ReportCell getSectionCell(int i, Vector<Integer> key) {
        if (key != null && this.hasSectionCells(key)) {
            Vector<ReportCell> cellVector = this.getSectionCells(key);
            return cellVector.elementAt(i);
        }
        return null;
    }

    @Override
    public Vector<Color> getAllColors(Vector<Color> colors) {
        colors = super.getAllColors(colors);
        for (ReportCell cell : this.cells) {
            colors = cell.getAllColors(colors);
        }
        if (this.sectionList != null) {
            for (int i = 0; i < this.sectionList.size(); ++i) {
                colors = this.sectionList.elementAt(i).getAllColors(colors);
            }
        }
        return colors;
    }

    @Override
    public String[] getSecurityLevels() {
        Vector<String> levels = new Vector<String>();
        String[] temp = super.getSecurityLevels();
        for (String element : temp) {
            levels.addElement(element);
        }
        for (ReportCell cell : this.cells) {
            temp = cell.getSecurityLevels();
            for (int j = 0; j < temp.length; ++j) {
                if (levels.contains(temp[j])) continue;
                levels.addElement(temp[j]);
            }
        }
        if (this.sectionList != null) {
            for (int i = 0; i < this.sectionList.size(); ++i) {
                temp = this.sectionList.elementAt(i).getSecurityLevels();
                for (int j = 0; j < temp.length; ++j) {
                    if (levels.contains(temp[j])) continue;
                    levels.addElement(temp[j]);
                }
            }
        }
        String[] ls = new String[levels.size()];
        for (int i = 0; i < ls.length; ++i) {
            ls[i] = (String)levels.elementAt(i);
        }
        return ls;
    }

    @Override
    public String[] getSecuredScripts() {
        Vector<String> scripts = new Vector<String>();
        String[] temp = super.getSecuredScripts();
        for (String element : temp) {
            scripts.addElement(element);
        }
        for (ReportCell cell : this.cells) {
            temp = cell.getSecuredScripts();
            for (int j = 0; j < temp.length; ++j) {
                if (scripts.contains(temp[j])) continue;
                scripts.addElement(temp[j]);
            }
        }
        if (this.sectionList != null) {
            for (int i = 0; i < this.sectionList.size(); ++i) {
                temp = this.sectionList.elementAt(i).getSecuredScripts();
                for (int j = 0; j < temp.length; ++j) {
                    if (scripts.contains(temp[j])) continue;
                    scripts.addElement(temp[j]);
                }
            }
        }
        String[] ls = new String[scripts.size()];
        for (int i = 0; i < ls.length; ++i) {
            ls[i] = (String)scripts.elementAt(i);
        }
        return ls;
    }

    @Override
    public void setSecurityLevelProperties(String levelName, ReportElement level) {
        super.setSecurityLevelProperties(levelName, level);
        for (ReportCell cell : this.cells) {
            cell.setSecurityLevelProperties(levelName, level);
        }
        if (this.sectionList != null) {
            for (int i = 0; i < this.sectionList.size(); ++i) {
                this.sectionList.elementAt(i).setSecurityLevelProperties(levelName, level);
            }
        }
    }

    public void setReportObjectForSubReports(String filename, ISubReport rptobject) {
        for (ReportCell cell : this.cells) {
            SubReportObject sr;
            if (!(cell instanceof SubReportObject) || (sr = (SubReportObject)cell).getFileName() == null || !sr.getFileName().equals(filename)) continue;
            sr.setSubReport(rptobject);
        }
        if (this.sectionList != null) {
            for (int i = 0; i < this.sectionList.size(); ++i) {
                this.sectionList.elementAt(i).setReportObjectForSubReports(filename, rptobject);
            }
        }
    }

    public void updateSubReportFileName(String oldfilename, String newfilename) {
        for (ReportCell cell : this.cells) {
            SubReportObject sr;
            if (!(cell instanceof SubReportObject) || (sr = (SubReportObject)cell).getFileName() == null || !sr.getFileName().equals(oldfilename)) continue;
            sr.setFileName(newfilename);
        }
        if (this.sectionList != null) {
            for (int i = 0; i < this.sectionList.size(); ++i) {
                this.sectionList.elementAt(i).updateSubReportFileName(oldfilename, newfilename);
            }
        }
    }

    public void setHTMLParameters(String dirLocation, String url, String fileName) {
        for (ReportCell cell : this.cells) {
            if (cell instanceof ReportChartObject) {
                ((ReportChartObject)cell).setHTMLParameters(dirLocation, url, fileName);
                continue;
            }
            if (!(cell instanceof SubReportObject)) continue;
            ((SubReportObject)cell).setHTMLParameters(dirLocation, url, fileName);
        }
        if (this.sectionList != null) {
            for (int i = 0; i < this.sectionList.size(); ++i) {
                this.sectionList.elementAt(i).setHTMLParameters(dirLocation, url, fileName);
            }
        }
    }

    public void setChartPath(String path) {
        int i;
        for (i = 0; i < this.cells.length; ++i) {
            if (this.cells[i] instanceof ReportChartObject) {
                String loc;
                if (!Report.applyChartPathToAllCharts && !((ReportChartObject)this.cells[i]).isReportDataUsed() || (loc = this.cells[i].getText()) == null || loc.trim().equals("")) continue;
                loc = loc.replace('\\', '/');
                if (!(path = path.replace('\\', '/')).endsWith("/")) {
                    path = path + "/";
                }
                String fileName = QbUtil.getFileName(loc);
                this.cells[i].setText(path + fileName);
                continue;
            }
            if (!(this.cells[i] instanceof SubReportObject)) continue;
            ((SubReportObject)this.cells[i]).setChartPath(path);
        }
        if (this.sectionList != null) {
            for (i = 0; i < this.sectionList.size(); ++i) {
                this.sectionList.elementAt(i).setChartPath(path);
            }
        }
    }

    public void setImagePath(String path) {
        int i;
        for (i = 0; i < this.cells.length; ++i) {
            if (this.cells[i] instanceof ReportImage && !(this.cells[i] instanceof ReportChartObject) && !(this.cells[i] instanceof ReportLine) && !(this.cells[i] instanceof ReportGrid) && ((ReportImage)this.cells[i]).getImageURL() != null) {
                String loc = ((ReportImage)this.cells[i]).getImageURL().toString();
                if (loc == null || loc.trim().equals("")) continue;
                loc = loc.replace('\\', '/');
                if (!(path = path.replace('\\', '/')).endsWith("/")) {
                    path = path + "/";
                }
                String fileName = QbUtil.getFileName(loc);
                try {
                    if (IOUtil.isURL(path)) {
                        ((ReportImage)this.cells[i]).setImageURL(new URL(path + fileName), true);
                        continue;
                    }
                    ((ReportImage)this.cells[i]).setImagePath(path + fileName, true);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                continue;
            }
            if (!(this.cells[i] instanceof SubReportObject)) continue;
            ((SubReportObject)this.cells[i]).setImagePath(path);
        }
        if (this.sectionList != null) {
            for (i = 0; i < this.sectionList.size(); ++i) {
                this.sectionList.elementAt(i).setImagePath(path);
            }
        }
    }

    public void setSubReportPath(String path) {
        if (path == null) {
            return;
        }
        for (ReportCell cell : this.cells) {
            String loc;
            if (!(cell instanceof SubReportObject) || (loc = ((SubReportObject)cell).getFileName()) == null || loc.trim().equals("")) continue;
            loc = loc.replace('\\', '/');
            if (!(path = path.replace('\\', '/')).endsWith("/")) {
                path = path + "/";
            }
            String fileName = QbUtil.getFileName(loc);
            ((SubReportObject)cell).setFileName(path + fileName);
        }
        if (this.sectionList != null) {
            for (int i = 0; i < this.sectionList.size(); ++i) {
                this.sectionList.elementAt(i).setSubReportPath(path);
            }
        }
    }

    public int[] findSectionCellIndex(double cx, double cy, Vector<Integer> key) {
        int i;
        Vector<Integer> index = new Vector<Integer>();
        if (key != null && this.hasSectionCells(key)) {
            Vector<ReportCell> cellVector = this.getSectionCells(key);
            for (i = 0; i < cellVector.size(); ++i) {
                ReportCell cell = cellVector.elementAt(i);
                if (!cell.contains(cx, cy)) continue;
                index.addElement(i);
            }
        }
        if (index.size() == 0) {
            return null;
        }
        int[] indexArray = new int[index.size()];
        for (i = 0; i < index.size(); ++i) {
            indexArray[i] = Integer.parseInt(((Integer)index.elementAt(i)).toString());
        }
        return indexArray;
    }

    public TableOfContents findTOC(double cx, double cy) {
        for (ReportCell cell : this.cells) {
            if (!cell.contains(cx, cy) || !(cell instanceof TableOfContents)) continue;
            return (TableOfContents)cell;
        }
        return null;
    }

    public TableOfContents getTOC() {
        for (ReportCell cell : this.cells) {
            if (!(cell instanceof TableOfContents)) continue;
            return (TableOfContents)cell;
        }
        if (this.sectionList != null) {
            for (int i = 0; i < this.sectionList.size(); ++i) {
                TableOfContents toc = this.sectionList.elementAt(i).getTOC();
                if (toc == null) continue;
                return toc;
            }
        }
        return null;
    }

    public int[] findImageIndex(double cx, double cy, Vector key) {
        Vector<Integer> index = new Vector<Integer>();
        for (int i = 0; i < this.cells.length; ++i) {
            if (!this.cells[i].contains(cx, cy) || !(this.cells[i] instanceof ReportImage)) continue;
            index.addElement(i);
        }
        if (index.size() == 0) {
            return null;
        }
        int[] indexArray = new int[index.size()];
        for (int i = 0; i < index.size(); ++i) {
            indexArray[i] = Integer.parseInt(((Integer)index.elementAt(i)).toString());
        }
        return indexArray;
    }

    public int[] findReportCellIndex(double cx, double cy, Vector key) {
        Vector<Integer> index = new Vector<Integer>();
        for (int i = this.cells.length - 1; i >= 0; --i) {
            if (!this.cells[i].contains(cx, cy) || this.cells[i] instanceof ReportImage) continue;
            index.addElement(i);
        }
        if (index.size() == 0) {
            return null;
        }
        int[] indexArray = new int[index.size()];
        for (int i = 0; i < index.size(); ++i) {
            indexArray[i] = Integer.parseInt(((Integer)index.elementAt(i)).toString());
        }
        return indexArray;
    }

    private Vector<ReportElement[]> getReportCellForHTML(ReportCell[] areportcell) {
        Vector<ReportElement[]> vector = new Vector<ReportElement[]>();
        areportcell = (ReportCell[])ReportSection.sortElement(areportcell, 0, true);
        int i = 0;
        int j = 0;
        while (j < areportcell.length) {
            double d = areportcell[i].getY();
            for (int k = i; k < areportcell.length && !(areportcell[k].getY() > d); ++k) {
                ++j;
            }
            if (j > i) {
                ReportElement[] areportcell1 = new ReportCell[j - i];
                for (int l = 0; l < areportcell1.length; ++l) {
                    areportcell1[l] = areportcell[i + l];
                }
                vector.addElement(ReportSection.sortElement(areportcell1, 1, true));
            }
            i = j;
        }
        return vector;
    }

    public int indexOf(ReportCell reportcell) {
        for (int i = 0; i < this.cells.length; ++i) {
            if (!this.cells[i].equals(reportcell)) continue;
            return i;
        }
        return -1;
    }

    public int update(ReportCell reportcell) {
        for (int i = 0; i < this.cells.length; ++i) {
            if (!this.cells[i].getID().equals(reportcell.getID())) continue;
            this.cells[i] = reportcell;
            return i;
        }
        return -1;
    }

    public void removeData(int i) {
        if (this.cells == null || this.cells.length == 0) {
            return;
        }
        if (this.sectionStyle != null && this.cells[i].getID().equals(this.sectionStyle.getID())) {
            this.sectionStyle = null;
        }
        ReportCell[] areportcell = new ReportCell[this.cells.length - 1];
        int j = 0;
        for (int k = 0; k < this.cells.length; ++k) {
            if (k == i) continue;
            areportcell[j++] = this.cells[k];
        }
        this.setData(areportcell);
    }

    public void removeData(ReportCell reportcell) {
        int cellIndex = this.indexOf(reportcell);
        if (cellIndex < 0) {
            return;
        }
        this.removeData(cellIndex);
    }

    public void setData(ReportCell reportcell, int i) {
        this.cells[i] = reportcell;
        this.isModified = true;
    }

    public void setData(ReportCell[] areportcell) {
        this.cells = areportcell;
        this.isModified = true;
    }

    public void setDataForDeepCopy(ReportCell[] reportCell) {
        int l = Array.getLength(reportCell);
        this.cells = new ReportCell[l];
        for (int i = 0; i < l; ++i) {
            ReportCell cell = reportCell[i];
            if (cell instanceof TableOfContents) {
                this.cells[i] = new TableOfContents();
                ((TableOfContents)this.cells[i]).copy((TableOfContents)cell);
                continue;
            }
            if (cell instanceof ReportChartObject) {
                this.cells[i] = new ReportChartObject();
                ((ReportChartObject)this.cells[i]).deepCopy((ReportChartObject)cell);
                continue;
            }
            if (cell instanceof ColumnWrap) {
                this.cells[i] = new ColumnWrap(cell.getX());
                ((ColumnWrap)this.cells[i]).deepCopy((ColumnWrap)cell);
                continue;
            }
            if (cell instanceof GuideLine) {
                this.cells[i] = cell;
                continue;
            }
            if (cell instanceof ReportLine) {
                this.cells[i] = new ReportLine();
                ((ReportLine)this.cells[i]).deepCopy((ReportLine)cell);
                continue;
            }
            if (cell instanceof ReportGrid) {
                this.cells[i] = new ReportGrid();
                ((ReportGrid)this.cells[i]).deepCopy((ReportGrid)cell);
                continue;
            }
            if (cell instanceof ReportImage) {
                this.cells[i] = new ReportImage();
                ((ReportImage)this.cells[i]).deepCopy((ReportImage)cell);
                continue;
            }
            if (cell instanceof SubReportObject) {
                this.cells[i] = new SubReportObject();
                ((SubReportObject)this.cells[i]).deepCopy((SubReportObject)cell);
                continue;
            }
            if (cell instanceof ReportRTFObject) {
                this.cells[i] = new ReportRTFObject(null);
                ((ReportRTFObject)this.cells[i]).deepCopy((ReportRTFObject)cell);
                continue;
            }
            if (cell instanceof CBColumnHeader) {
                this.cells[i] = new CBColumnHeader(((CBColumnHeader)cell).getColBreakValueIndex());
                ((CBColumnHeader)this.cells[i]).deepCopy((CBColumnHeader)cell);
                continue;
            }
            if (cell instanceof RBColumnHeader) {
                this.cells[i] = new RBColumnHeader(((RBColumnHeader)cell).getColBreakLevel());
                ((RBColumnHeader)this.cells[i]).deepCopy((RBColumnHeader)cell);
                continue;
            }
            if (cell instanceof CBAggrColHeader) {
                this.cells[i] = new CBAggrColHeader(((CBAggrColHeader)cell).getColBreakLevel(), ((CBAggrColHeader)cell).getColBreakValueIndex());
                ((CBAggrColHeader)this.cells[i]).deepCopy((CBAggrColHeader)cell);
                continue;
            }
            if (cell instanceof ColumnHeader) {
                this.cells[i] = new ColumnHeader();
                ((ColumnHeader)this.cells[i]).deepCopy((ColumnHeader)cell);
                continue;
            }
            if (cell instanceof CBColumnFooter) {
                this.cells[i] = new CBColumnFooter(((CBColumnFooter)cell).getColBreakValueIndex());
                ((CBColumnFooter)this.cells[i]).deepCopy((CBColumnFooter)cell);
                continue;
            }
            if (cell instanceof CBAggrColFooter) {
                this.cells[i] = new CBAggrColFooter(((CBAggrColFooter)cell).getColBreakLevel(), ((CBAggrColFooter)cell).getColBreakValueIndex());
                ((CBAggrColFooter)this.cells[i]).deepCopy((CBAggrColFooter)cell);
                continue;
            }
            if (cell instanceof ReportTitle) {
                this.cells[i] = new ReportTitle();
                ((ReportTitle)this.cells[i]).deepCopy((ReportTitle)cell);
                continue;
            }
            this.cells[i] = new ReportCell();
            this.cells[i].deepCopy(cell);
        }
        this.isModified = true;
    }

    @Override
    public void setID(String newID) {
        super.setID(newID);
        if (this.cells == null) {
            return;
        }
        for (ReportCell cell : this.cells) {
            if (!cell.getID().equals("")) continue;
            cell.setID(newID, this.cells);
        }
        if (this.sectionCellsTable == null) {
            return;
        }
        Enumeration<Vector<Integer>> keys = this.sectionCellsTable.keys();
        while (keys.hasMoreElements()) {
            Vector<ReportCell> cellArray;
            Vector<Integer> key = keys.nextElement();
            if (!this.hasSectionCells(key) || (cellArray = this.getSectionCells(key)) == null) continue;
            for (int j = 0; j < cellArray.size(); ++j) {
                ReportCell cell = cellArray.elementAt(j);
                if (!cell.getID().equals("")) continue;
                cell.setID(newID, QbUtil.toArray(cellArray));
            }
        }
    }

    public boolean customIDExists(String id) {
        if (this.cells != null) {
            for (ReportCell cell : this.cells) {
                if (cell.getCustomID() == null || !cell.getCustomID().equals(id)) continue;
                return true;
            }
        }
        if (this.sectionList != null) {
            for (int i = 0; i < this.sectionList.size(); ++i) {
                if (!this.sectionList.elementAt(i).customIDExists(id)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsZIndex() {
        if (this.cells != null) {
            for (ReportCell cell : this.cells) {
                if (cell.getZ() <= 0) continue;
                return true;
            }
        }
        if (this.sectionList != null) {
            for (int i = 0; i < this.sectionList.size(); ++i) {
                if (!this.sectionList.elementAt(i).containsZIndex()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean formulaReferenced(Formula formula) {
        if (this.cells != null) {
            for (ReportCell cell : this.cells) {
                if (!cell.formulaReferenced(formula)) continue;
                return true;
            }
        }
        if (this.sectionList != null) {
            for (int i = 0; i < this.sectionList.size(); ++i) {
                if (!this.sectionList.elementAt(i).formulaReferenced(formula)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean scriptReferenced(Script script) {
        return this.scriptReferenced(script, false);
    }

    public boolean scriptReferenced(Script script, boolean checkThisSectionOnly) {
        if (this.cells != null) {
            for (ReportCell cell : this.cells) {
                if (!cell.scriptReferenced(script)) continue;
                return true;
            }
        }
        if (!checkThisSectionOnly && this.sectionList != null) {
            for (int i = 0; i < this.sectionList.size(); ++i) {
                if (!this.sectionList.elementAt(i).scriptReferenced(script)) continue;
                return true;
            }
        }
        return this.getScriptObj() == script;
    }

    @Override
    public boolean securityScriptReferenced(Script script) {
        return this.securityScriptReferenced(script, false);
    }

    public boolean securityScriptReferenced(Script script, boolean checkThisSectionOnly) {
        if (this.cells != null) {
            for (ReportCell cell : this.cells) {
                if (!cell.securityScriptReferenced(script)) continue;
                return true;
            }
        }
        if (!checkThisSectionOnly && this.sectionList != null) {
            for (int i = 0; i < this.sectionList.size(); ++i) {
                if (!this.sectionList.elementAt(i).securityScriptReferenced(script)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void removeScriptReferenced(Script script) {
        this.removeScriptReferenced(script, false);
    }

    public boolean removeScriptReferenced(Script script, boolean checkThisSectionOnly) {
        if (this.cells != null) {
            for (ReportCell cell : this.cells) {
                cell.removeScriptReferenced(script);
            }
        }
        if (!checkThisSectionOnly && this.sectionList != null) {
            for (int i = 0; i < this.sectionList.size(); ++i) {
                this.sectionList.elementAt(i).removeScriptReferenced(script);
            }
        }
        return this.getScriptObj() == script;
    }

    public void createFormulaObject(Report report) {
        if (this.cells != null) {
            for (ReportCell cell : this.cells) {
                cell.createFormulaObject(report);
            }
        }
        if (this.sectionList != null) {
            for (int i = 0; i < this.sectionList.size(); ++i) {
                this.sectionList.elementAt(i).createFormulaObject(report);
            }
        }
    }

    public void createFormulaObjectFromName(Report report) {
        if (this.cells != null) {
            for (ReportCell cell : this.cells) {
                cell.createFormulaObjectFromName(report);
            }
        }
        if (this.sectionList != null) {
            for (int i = 0; i < this.sectionList.size(); ++i) {
                this.sectionList.elementAt(i).createFormulaObjectFromName(report);
            }
        }
    }

    @Override
    public void createScriptObject(Vector<Script> scripts) {
        if (this.cells != null) {
            for (ReportCell cell : this.cells) {
                cell.createScriptObject(scripts);
            }
        }
        if (this.sectionList != null) {
            for (int i = 0; i < this.sectionList.size(); ++i) {
                this.sectionList.elementAt(i).createScriptObject(scripts);
            }
        }
    }

    @Override
    public void createScriptObjectFromName(Vector<Script> scripts) {
        super.createScriptObjectFromName(scripts);
        for (ReportCell cell : this.cells) {
            cell.createScriptObjectFromName(scripts);
        }
        if (this.sectionList != null) {
            for (int i = 0; i < this.sectionList.size(); ++i) {
                this.sectionList.elementAt(i).createScriptObjectFromName(scripts);
            }
        }
    }

    public void setGridLineLink(IReport report) {
        if (this.cells != null) {
            for (ReportCell cell : this.cells) {
                ReportGrid grid;
                if (cell instanceof ReportLine) {
                    ReportLine line = (ReportLine)cell;
                    if (line.getPreviousID() == null) continue;
                    ReportLine line2 = (ReportLine)report.getData(line.getPreviousID());
                    line.setPrevious(line2);
                    if (line2 == null) continue;
                    line2.setNext(line);
                    continue;
                }
                if (!(cell instanceof ReportGrid) || (grid = (ReportGrid)cell).getPreviousID() == null) continue;
                ReportGrid grid2 = (ReportGrid)report.getData(grid.getPreviousID());
                grid.setPrevious(grid2);
                if (grid2 == null) continue;
                grid2.setNext(grid);
            }
        }
        if (this.sectionList != null) {
            for (int i = 0; i < this.sectionList.size(); ++i) {
                this.sectionList.elementAt(i).setGridLineLink(report);
            }
        }
    }

    public ReportCell[] sortCell(int order, boolean isAsc) {
        return (ReportCell[])ReportSection.sortElement(this.cells, order, isAsc);
    }

    public void sortSection(int order, boolean isAsc) {
        this.cells = this.sortCell(order, isAsc);
    }

    public ReportCell[] sortCell(int order, boolean isAsc, Vector<Integer> key) {
        int i;
        if (key == null || !this.hasSectionCells(key)) {
            return (ReportCell[])ReportSection.sortElement(this.cells, order, isAsc);
        }
        Vector<ReportCell> cellVector = this.getSectionCells(key);
        ReportElement[] cellArray = new ReportCell[cellVector.size()];
        for (int i2 = 0; i2 < cellVector.size(); ++i2) {
            cellArray[i2] = cellVector.elementAt(i2);
        }
        if (this.cells == null) {
            return (ReportCell[])ReportSection.sortElement(cellArray, order, isAsc);
        }
        ReportElement[] areportcell = new ReportCell[this.cells.length + cellArray.length];
        for (i = 0; i < this.cells.length; ++i) {
            areportcell[i] = this.cells[i];
        }
        for (i = 0; i < cellArray.length; ++i) {
            areportcell[this.cells.length + i] = cellArray[i];
        }
        return (ReportCell[])ReportSection.sortElement(areportcell, order, isAsc);
    }

    public double getMinHeight() {
        double max_Y = 0.0;
        double val = 0.0;
        for (int i = 0; i < this.cells.length; ++i) {
            val = this.cells[i].getHeight() + this.cells[i].getY();
            if (this.cells[i] instanceof ReportLine && !((ReportLine)this.cells[i]).isVertical()) {
                val -= 0.02;
                if (((ReportLine)this.cells[i]).getLineStyle() == 2) {
                    val += 2.0 * (this.cells[i].getHeight() - 0.02);
                }
            }
            if (!(val > max_Y)) continue;
            max_Y = val;
        }
        return max_Y;
    }

    public double getMinWidth() {
        double max_X = 0.0;
        double val = 0.0;
        if (this.cells == null) {
            return max_X;
        }
        for (ReportCell cell : this.cells) {
            if (cell instanceof GuideLine || !((val = cell.getWidth() + cell.getX()) > max_X)) continue;
            max_X = val;
        }
        return max_X;
    }

    @Override
    public void resize(double xratio, double yratio) {
        for (ReportCell cell : this.cells) {
            cell.resize(xratio, yratio);
        }
    }

    public void formatSection() {
        double w = this.getMinWidth();
        if (w > super.getWidth()) {
            super.setWidth(w);
        }
        this.isModified = false;
    }

    public boolean isRepeatOnEveryPage() {
        return this.repeatOnEveryPage;
    }

    public void setRepeatOnEveryPage(boolean state) {
        this.repeatOnEveryPage = state;
    }

    public boolean isResetPageNumber() {
        return this.isResetPageNumber;
    }

    public void setResetPageNumber(boolean state) {
        this.isResetPageNumber = state;
        if (state) {
            this.setPrintOnNewPage(true);
        }
    }

    public boolean isNewExcelSheet() {
        return this.isNewExcelSheet;
    }

    public void setNewExcelSheet(boolean state) {
        this.isNewExcelSheet = state;
    }

    @Override
    public void setBorderThickness(int border) {
        super.setBorderThickness(border);
        if (!"Master Section".equals(this.getText())) {
            for (int i = 0; i < this.getCellCount(); ++i) {
                if (this.getData(i) instanceof GuideLine) continue;
                this.getData(i).setBorderThickness(border);
            }
        }
    }

    @Override
    @Deprecated
    public void setBorder(int border) {
        this.setBorderThickness(border);
    }

    @Override
    public void setBorderColor(Color color) {
        super.setBorderColor(color);
        if (!"Master Section".equals(this.getText())) {
            for (int i = 0; i < this.getCellCount(); ++i) {
                if (this.getData(i) instanceof GuideLine) continue;
                this.getData(i).setBorderColor(color);
            }
        }
    }

    @Override
    public double getHeight() {
        return super.getHeight();
    }

    @Override
    public double getWidth() {
        if (this.isModified) {
            this.formatSection();
        }
        return super.getWidth();
    }

    @Override
    public void setHeight(double h) {
        super.setHeight(h);
    }

    @Override
    public void setWidth(double w) {
        super.setWidth(w);
        this.formatSection();
    }

    public void setSectionStyle(ReportCell cell) {
        this.sectionStyle = cell;
    }

    public ReportCell getSectionStyle() {
        return this.sectionStyle;
    }

    public boolean hasSectionStyle() {
        return this.sectionStyle != null;
    }

    public boolean isSectionStyle(ReportCell cell) {
        return this.sectionStyle != null && this.sectionStyle.getID().equals(cell.getID());
    }

    @Override
    public void write(DataOutput out) throws IOException {
        this.write(out, false);
    }

    public void write(DataOutput out, boolean pack) throws IOException {
        int i;
        if (this.isModified) {
            this.formatSection();
        }
        out.writeInt(this.getCellCount());
        for (i = 0; i < this.getCellCount(); ++i) {
            this.writeCell(out, this.getData(i), pack);
        }
        out.writeBoolean(this.isRepeatOnEveryPage());
        out.writeBoolean(this.isResetPageNumber());
        out.writeBoolean(this.isNewExcelSheet());
        if (this.sectionStyle == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.writeCell(out, this.sectionStyle, pack);
        }
        out.writeInt(0);
        out.writeInt(0);
        out.writeInt(0);
        if (this.sectionList != null) {
            out.writeInt(this.sectionList.size());
            for (i = 0; i < this.sectionList.size(); ++i) {
                this.sectionList.elementAt(i).write(out, pack);
            }
        } else {
            out.writeInt(0);
        }
        super.write(out);
    }

    @Override
    public void read(DataInput in, int version) throws Exception {
        this.read(in, version, false, false, null, "");
    }

    public void read(DataInput in, int version, boolean pack, boolean fromReportDesigner, FileInMemTable subFilesTable, String domainPath) throws Exception {
        int count;
        int len = in.readInt();
        for (int i = 0; i < len; ++i) {
            ReportCell cell = this.createCell(in, version, pack, fromReportDesigner, subFilesTable, domainPath);
            if (cell == null) continue;
            this.addData(cell);
        }
        this.setRepeatOnEveryPage(in.readBoolean());
        if (version >= 48) {
            this.setResetPageNumber(in.readBoolean());
        }
        if (version >= 171) {
            this.setNewExcelSheet(in.readBoolean());
        }
        if (version >= 205 && in.readBoolean()) {
            this.sectionStyle = this.createCell(in, version, fromReportDesigner, pack, subFilesTable, domainPath);
            for (ReportCell cell : this.cells) {
                if (!this.isSectionStyle(cell)) continue;
                this.sectionStyle = cell;
            }
        }
        if (version < 5) {
            this.setPrintOnNewPage(in.readBoolean());
        }
        if (version < 101 && version > 15) {
            this.setVisible(in.readBoolean());
        }
        if (version >= 40) {
            int j;
            int cellCt;
            int j2;
            Vector<Integer> key;
            int keyCt;
            int i;
            count = in.readInt();
            if (count > 0 && this.sectionCellsTable == null) {
                this.sectionCellsTable = new Hashtable();
            }
            for (i = 0; i < count; ++i) {
                keyCt = in.readInt();
                key = new Vector<Integer>();
                for (j2 = 0; j2 < keyCt; ++j2) {
                    int k = in.readInt();
                    key.addElement(k);
                }
                cellCt = in.readInt();
                Vector<ReportCell> cellArray = new Vector<ReportCell>();
                for (j = 0; j < cellCt; ++j) {
                    ReportCell cell = this.createCell(in, version, pack, fromReportDesigner, subFilesTable, domainPath);
                    cellArray.addElement(cell);
                }
                this.sectionCellsTable.put(key, cellArray);
            }
            count = in.readInt();
            if (count > 0 && this.formattedCellsTable == null) {
                this.formattedCellsTable = new Hashtable();
            }
            for (i = 0; i < count; ++i) {
                keyCt = in.readInt();
                key = new Vector();
                for (j2 = 0; j2 < keyCt; ++j2) {
                    int k = in.readInt();
                    key.addElement(k);
                }
                cellCt = in.readInt();
                Hashtable<Integer, ReportCell> cellTable = new Hashtable<Integer, ReportCell>();
                for (j = 0; j < cellCt; ++j) {
                    int index = in.readInt();
                    Integer indexKey = index;
                    ReportCell cell = this.createCell(in, version, pack, fromReportDesigner, subFilesTable, domainPath);
                    cellTable.put(indexKey, cell);
                }
                this.formattedCellsTable.put(key, cellTable);
            }
            count = in.readInt();
            if (count > 0 && this.heightTable == null) {
                this.heightTable = new Hashtable();
            }
            for (i = 0; i < count; ++i) {
                keyCt = in.readInt();
                key = new Vector();
                for (int j3 = 0; j3 < keyCt; ++j3) {
                    int k = in.readInt();
                    key.addElement(k);
                }
                double height = in.readDouble();
                this.heightTable.put(key, height);
            }
        }
        if (version >= 47) {
            count = in.readInt();
            this.sectionList = new Vector();
            for (int i = 0; i < count; ++i) {
                ReportSection sec = ReportSection.createSection(in, version, pack, fromReportDesigner, subFilesTable, domainPath);
                sec.parentSection = this;
                this.sectionList.addElement(sec);
            }
        }
        super.read(in, version);
        this.sectionCellsTable = null;
        this.formattedCellsTable = null;
        this.heightTable = null;
    }

    @Override
    public void writeXML(Writer out, boolean writeElementTag) throws IOException {
        int i;
        if (this.isModified) {
            this.formatSection();
        }
        if (writeElementTag) {
            out.write("<REPORTSECTION>\n");
        }
        out.write("<REPORTSECTION_REPEAT_ON_EVERY_PAGE>" + this.isRepeatOnEveryPage() + "</REPORTSECTION_REPEAT_ON_EVERY_PAGE>\n");
        out.write("<REPORTSECTION_RESETPAGENUMBER>" + this.isResetPageNumber() + "</REPORTSECTION_RESETPAGENUMBER>\n");
        out.write("<REPORTSECTION_NEWEXCELSHEET>" + this.isNewExcelSheet() + "</REPORTSECTION_NEWEXCELSHEET>\n");
        if (this.sectionStyle != null) {
            out.write("<REPORTSECTION_STYLE>\n");
            this.writeXMLCell(out, this.sectionStyle);
            out.write("</REPORTSECTION_STYLE>\n");
        }
        super.writeXML(out, false);
        for (i = 0; i < this.getCellCount(); ++i) {
            this.writeXMLCell(out, this.getData(i));
        }
        out.write("<SECTION_LIST>\n");
        if (this.sectionList != null) {
            for (i = 0; i < this.sectionList.size(); ++i) {
                this.sectionList.elementAt(i).writeXML(out, true);
            }
        }
        out.write("</SECTION_LIST>\n");
        if (writeElementTag) {
            out.write("</REPORTSECTION>\n");
        }
    }

    public static ReportSection createSection(Node node, int version) throws Exception {
        if (!node.getNodeName().equalsIgnoreCase(XMLTAG)) {
            throw new Exception("'REPORTSECTION' element expected, but found '" + node.getNodeName() + "' element.");
        }
        ReportSection sect = new ReportSection();
        sect.readXML(node, version);
        return sect;
    }

    @Override
    public void readXML(Node node, int version) throws Exception {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            NodeList keyElements;
            int j;
            NodeList entryList;
            Node child = nodeList.item(i);
            if (child.getNodeName().equalsIgnoreCase("REPORTSECTION_REPEAT_ON_EVERY_PAGE")) {
                this.setRepeatOnEveryPage(LoadXMLReportHelper.parseBoolean(LoadXMLReportHelper.readText(child)));
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTSECTION_RESETPAGENUMBER")) {
                this.setResetPageNumber(LoadXMLReportHelper.parseBoolean(LoadXMLReportHelper.readText(child)));
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTSECTION_NEWEXCELSHEET")) {
                this.setNewExcelSheet(LoadXMLReportHelper.parseBoolean(LoadXMLReportHelper.readText(child)));
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTSECTION_VISIBLE")) {
                if (version >= 138) continue;
                this.setVisible(LoadXMLReportHelper.parseBoolean(LoadXMLReportHelper.readText(child)));
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTSECTION_STYLE")) {
                this.sectionStyle = this.createXMLCell(child.getChildNodes().item(0), version);
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTSECTION_SECTIONCELLS")) {
                if (this.sectionCellsTable == null) {
                    this.sectionCellsTable = new Hashtable();
                }
                entryList = child.getChildNodes();
                Vector<Integer> key = null;
                Vector<ReportCell> cellArray = null;
                for (j = 0; j < entryList.getLength(); ++j) {
                    int k;
                    Node entry = entryList.item(j);
                    if (entry.getNodeName().equalsIgnoreCase("REPORTSECTION_SECTIONCELLKEY")) {
                        key = new Vector<Integer>();
                        keyElements = entry.getChildNodes();
                        for (k = 0; k < keyElements.getLength(); ++k) {
                            if (!keyElements.item(k).getNodeName().equalsIgnoreCase("KEYELEMENT")) continue;
                            int value = Integer.parseInt(LoadXMLReportHelper.readText(keyElements.item(k)));
                            key.addElement(value);
                        }
                    } else if (entry.getNodeName().equalsIgnoreCase("REPORTSECTION_SECTIONCELLARRAY")) {
                        cellArray = new Vector<ReportCell>();
                        NodeList sectionCells = entry.getChildNodes();
                        for (k = 0; k < sectionCells.getLength(); ++k) {
                            ReportCell cell;
                            if (!sectionCells.item(k).getNodeName().equalsIgnoreCase("REPORTSECTION_SECTIONCELLENTRY") || (cell = this.createXMLCell(sectionCells.item(k).getChildNodes().item(0), version)) == null) continue;
                            cellArray.addElement(cell);
                        }
                    }
                    if (key == null || cellArray == null) continue;
                    this.sectionCellsTable.put(key, cellArray);
                }
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTSECTION_FORMATTEDCELLS")) {
                if (this.formattedCellsTable == null) {
                    this.formattedCellsTable = new Hashtable();
                }
                entryList = child.getChildNodes();
                Vector<Integer> key = null;
                Hashtable<Integer, ReportCell> cellTable = null;
                for (j = 0; j < entryList.getLength(); ++j) {
                    int k;
                    Node entry = entryList.item(j);
                    if (entry.getNodeName().equalsIgnoreCase("REPORTSECTION_FORMATTEDCELLKEY")) {
                        key = new Vector<Integer>();
                        keyElements = entry.getChildNodes();
                        for (k = 0; k < keyElements.getLength(); ++k) {
                            if (!keyElements.item(k).getNodeName().equalsIgnoreCase("KEYELEMENT")) continue;
                            int value = Integer.parseInt(LoadXMLReportHelper.readText(keyElements.item(k)));
                            key.addElement(value);
                        }
                    } else if (entry.getNodeName().equalsIgnoreCase("REPORTSECTION_FORMATTEDCELLARRAY")) {
                        cellTable = new Hashtable<Integer, ReportCell>();
                        NodeList formattedCells = entry.getChildNodes();
                        for (k = 0; k < formattedCells.getLength(); ++k) {
                            Node n = formattedCells.item(k);
                            if (!n.getNodeName().equals("REPORTSECTION_FORMATTEDCELLENTRY")) continue;
                            Node in = n.getChildNodes().item(0);
                            int index = Integer.parseInt(LoadXMLReportHelper.readText(in));
                            Node rcell = n.getChildNodes().item(1);
                            ReportCell cell = this.createXMLCell(rcell.getChildNodes().item(0), version);
                            if (cell == null) continue;
                            cellTable.put(index, cell);
                        }
                    }
                    if (key == null || cellTable == null) continue;
                    this.formattedCellsTable.put(key, cellTable);
                }
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTSECTION_HEIGHTTABLE")) {
                if (this.heightTable == null) {
                    this.heightTable = new Hashtable();
                }
                entryList = child.getChildNodes();
                Vector<Integer> key = new Vector<Integer>();
                double height = 0.0;
                for (int j2 = 0; j2 < entryList.getLength(); ++j2) {
                    Node entry = entryList.item(j2);
                    if (entry.getNodeName().equalsIgnoreCase("REPORTSECTION_HEIGHTTABLEKEY")) {
                        NodeList keyElements2 = entry.getChildNodes();
                        for (int k = 0; k < keyElements2.getLength(); ++k) {
                            int value = Integer.parseInt(LoadXMLReportHelper.readText(keyElements2.item(k)));
                            key.addElement(value);
                        }
                    } else if (entry.getNodeName().equalsIgnoreCase("REPORTSECTION_SECTIONHEIGHT")) {
                        height = Double.parseDouble(LoadXMLReportHelper.readText(entry));
                    }
                    if (height == 0.0) continue;
                    this.heightTable.put(key, height);
                }
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("SECTION_LIST")) {
                NodeList children = child.getChildNodes();
                for (int j3 = 0; j3 < children.getLength(); ++j3) {
                    if (!children.item(j3).getNodeName().equalsIgnoreCase(XMLTAG)) continue;
                    ReportSection sec = ReportSection.createSection(children.item(j3), version);
                    sec.parentSection = this;
                    this.sectionList.addElement(sec);
                }
                continue;
            }
            ReportCell cell = this.createXMLCell(child, version);
            if (cell == null) continue;
            this.addData(cell);
        }
        super.readXML(node, version);
        this.sectionCellsTable = null;
        this.formattedCellsTable = null;
        this.heightTable = null;
    }

    public static ReportSection createSection(DataInput in, int version, boolean pack, boolean fromReportDesigner, FileInMemTable subFilesTable, String domainPath) throws Exception {
        ReportSection sect = new ReportSection();
        sect.read(in, version, pack, fromReportDesigner, subFilesTable, domainPath);
        return sect;
    }

    private void writeCell(DataOutput out, ReportCell cell, boolean pack) throws IOException {
        if (cell instanceof GuideLine) {
            out.writeInt(9);
            ((GuideLine)cell).write(out);
        } else if (cell instanceof ReportChartObject) {
            out.writeInt(1);
            ((ReportChartObject)cell).write(out, pack);
        } else if (cell instanceof ColumnWrap) {
            out.writeInt(6);
            ((ColumnWrap)cell).write(out);
        } else if (cell instanceof ReportLine) {
            out.writeInt(3);
            ((ReportLine)cell).write(out);
        } else if (cell instanceof ReportGrid) {
            out.writeInt(4);
            ((ReportGrid)cell).write(out);
        } else if (cell instanceof ReportImage) {
            out.writeInt(2);
            ((ReportImage)cell).write(out, pack);
        } else if (cell instanceof SubReportObject) {
            out.writeInt(5);
            SubReportObject subReportObj = (SubReportObject)cell;
            if (pack && !subReportObj.getFileName().toLowerCase().endsWith(".pak")) {
                subReportObj.setFileName(SaveReport.getPakFileName(subReportObj.getFileName()));
            }
            subReportObj.write(out);
        } else if (cell instanceof ReportRTFObject) {
            out.writeInt(7);
            ((ReportRTFObject)cell).write(out);
        } else if (cell instanceof TableOfContents) {
            out.writeInt(10);
            ((TableOfContents)cell).write(out);
        } else if (cell instanceof ReportTitle) {
            out.writeInt(11);
            ((ReportTitle)cell).write(out);
        } else if (cell instanceof RBColumnHeader) {
            out.writeInt(12);
            ((RBColumnHeader)cell).write(out);
        } else if (cell instanceof CBColumnHeader) {
            out.writeInt(13);
            ((CBColumnHeader)cell).write(out);
        } else if (cell instanceof CBColumnFooter) {
            out.writeInt(14);
            ((CBColumnFooter)cell).write(out);
        } else if (cell instanceof CBAggrColHeader) {
            out.writeInt(15);
            ((CBAggrColHeader)cell).write(out);
        } else if (cell instanceof CBAggrColFooter) {
            out.writeInt(16);
            ((CBAggrColFooter)cell).write(out);
        } else if (cell instanceof ColumnHeader) {
            out.writeInt(8);
            ((ColumnHeader)cell).write(out);
        } else {
            out.writeInt(0);
            cell.write(out);
        }
    }

    private void writeXMLCell(Writer out, ReportCell cell) throws IOException {
        if (cell instanceof GuideLine) {
            ((GuideLine)cell).writeXML(out, true);
        } else if (cell instanceof ReportChartObject) {
            ((ReportChartObject)cell).writeXML(out, true);
        } else if (cell instanceof ColumnWrap) {
            ((ColumnWrap)cell).writeXML(out, true);
        } else if (cell instanceof ReportLine) {
            ((ReportLine)cell).writeXML(out, true);
        } else if (cell instanceof ReportGrid) {
            ((ReportGrid)cell).writeXML(out, true);
        } else if (cell instanceof ReportImage) {
            ((ReportImage)cell).writeXML(out, true);
        } else if (cell instanceof ReportRTFObject) {
            ((ReportRTFObject)cell).writeXML(out, true);
        } else if (cell instanceof TableOfContents) {
            ((TableOfContents)cell).writeXML(out, true);
        } else if (cell instanceof ReportTitle) {
            ((ReportTitle)cell).writeXML(out, true);
        } else if (cell instanceof RBColumnHeader) {
            ((RBColumnHeader)cell).writeXML(out, true);
        } else if (cell instanceof CBColumnHeader) {
            ((CBColumnHeader)cell).writeXML(out, true);
        } else if (cell instanceof CBColumnFooter) {
            ((CBColumnFooter)cell).writeXML(out, true);
        } else if (cell instanceof CBAggrColHeader) {
            ((CBAggrColHeader)cell).writeXML(out, true);
        } else if (cell instanceof CBAggrColFooter) {
            ((CBAggrColFooter)cell).writeXML(out, true);
        } else if (cell instanceof ColumnHeader) {
            ((ColumnHeader)cell).writeXML(out, true);
        } else {
            cell.writeXML(out, true);
        }
    }

    private ReportCell createCell(DataInput in, int version, boolean pack, boolean fromReportDesigner, FileInMemTable subFilesTable, String domainPath) throws Exception {
        if (version < 6) {
            return ReportCell.createCell(in, version);
        }
        int type = in.readInt();
        if (type == 1) {
            return ReportChartObject.createChartObject(in, version, pack, subFilesTable, domainPath);
        }
        if (type == 2) {
            return ReportImage.createImage(in, version, pack, subFilesTable);
        }
        if (type == 3) {
            return ReportLine.createLine(in, version);
        }
        if (type == 4) {
            return ReportGrid.createGrid(in, version);
        }
        if (type == 5) {
            return SubReportObject.createSubReportObject(in, version, pack, fromReportDesigner, subFilesTable, false, domainPath, true);
        }
        if (type == 6) {
            return ColumnWrap.createColumnWrap(in, version);
        }
        if (type == 7) {
            return ReportRTFObject.createReportRTFObject(in, version);
        }
        if (type == 8) {
            return ColumnHeader.createColumnHeader(in, version);
        }
        if (type == 9) {
            if (version >= 144 && version < 160 || version >= 162) {
                return GuideLine.createGuideLine(in, version);
            }
            return null;
        }
        if (type == 10) {
            return TableOfContents.createTableOfContents(in, version);
        }
        if (type == 11) {
            return ReportTitle.createReportTitle(in, version);
        }
        if (type == 12) {
            return RBColumnHeader.createRBColumnHeader(in, version);
        }
        if (type == 13) {
            return CBColumnHeader.createCBColumnHeader(in, version);
        }
        if (type == 14) {
            return CBColumnFooter.createCBColumnFooter(in, version);
        }
        if (type == 15) {
            return CBAggrColHeader.createCBAggrColHeader(in, version);
        }
        if (type == 16) {
            return CBAggrColFooter.createCBAggrColFooter(in, version);
        }
        return ReportCell.createCell(in, version);
    }

    private ReportCell createXMLCell(Node node, int version) throws Exception {
        String tag = node.getNodeName();
        if (tag.equalsIgnoreCase("GUIDELINE")) {
            return GuideLine.createGuideLine(node, version);
        }
        if (tag.equalsIgnoreCase("REPORTCHARTOBJECT")) {
            return ReportChartObject.createChartObject(node, version);
        }
        if (tag.equalsIgnoreCase("REPORTIMAGE")) {
            return ReportImage.createImage(node, version);
        }
        if (tag.equalsIgnoreCase("REPORTLINE")) {
            return ReportLine.createLine(node, version);
        }
        if (tag.equalsIgnoreCase("REPORTGRID")) {
            return ReportGrid.createGrid(node, version);
        }
        if (tag.equalsIgnoreCase(ColumnHeader.XMLTAG)) {
            return ColumnHeader.createColumnHeader(node, version);
        }
        if (tag.equalsIgnoreCase(ReportTitle.XMLTAG)) {
            return ReportTitle.createReportTitle(node, version);
        }
        if (tag.equalsIgnoreCase("SUBREPORTOBJECT")) {
            return SubReportObject.createSubReportObject(node, version);
        }
        if (tag.equalsIgnoreCase("RTFOBJECT")) {
            return ReportRTFObject.createReportRTFObject(node, version);
        }
        if (tag.equalsIgnoreCase("COLUMNWRAP")) {
            return ColumnWrap.createColumnWrap(node, version);
        }
        if (tag.equalsIgnoreCase("REPORTCELL")) {
            return ReportCell.createCell(node, version);
        }
        if (tag.equalsIgnoreCase("TABLEOFCONTENTS")) {
            return TableOfContents.createTableOfContents(node, version);
        }
        if (tag.equalsIgnoreCase("RBCOLUMNHEADER")) {
            return RBColumnHeader.createRBColumnHeader(node, version);
        }
        if (tag.equalsIgnoreCase("CBCOLUMNHEADER")) {
            return CBColumnHeader.createCBColumnHeader(node, version);
        }
        if (tag.equalsIgnoreCase("CBCOLUMNFOOTER")) {
            return CBColumnFooter.createCBColumnFooter(node, version);
        }
        if (tag.equalsIgnoreCase("CBAGGRCOLHEADER")) {
            return CBAggrColHeader.createCBAggrColHeader(node, version);
        }
        if (tag.equalsIgnoreCase("CBAGGRCOLFOOTER")) {
            return CBAggrColFooter.createCBAggrColFooter(node, version);
        }
        return null;
    }

    public void writeSTL(DataOutput out) throws Exception {
        int i;
        out.writeDouble(this.getHeight());
        if (this.sectionStyle == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.writeCell(out, this.sectionStyle, false);
        }
        Vector vec = this.getColumnHeaders();
        out.writeInt(vec.size());
        for (i = 0; i < vec.size(); ++i) {
            this.writeCell(out, (ColumnHeader)vec.elementAt(i), false);
        }
        vec = this.getImagesAndLines();
        out.writeInt(vec.size());
        for (i = 0; i < vec.size(); ++i) {
            this.writeCell(out, (ReportCell)vec.elementAt(i), true);
        }
    }

    public void readSTL(DataInput in, int version) throws Exception {
        int i;
        double height;
        if (version >= 279) {
            height = in.readDouble();
            this.setHeight(height);
        }
        if (in.readBoolean()) {
            this.sectionStyle = this.createCell(in, version, false, false, null, "");
            this.addData(this.sectionStyle);
        }
        if (version == 261 || version == 262) {
            height = in.readDouble();
            this.setHeight(height);
        }
        int ct = in.readInt();
        for (i = 0; i < ct; ++i) {
            ColumnHeader ch = (ColumnHeader)this.createCell(in, version, false, false, null, "");
            if (this.sectionStyle != null) {
                ch.applyStyle(this.sectionStyle);
            }
            if (this.sectionStyle != null && this.sectionStyle.equals(ch)) continue;
            this.addData(ch);
        }
        ct = in.readInt();
        for (i = 0; i < ct; ++i) {
            this.addData(this.createCell(in, version, true, false, null, ""));
        }
    }

    public ReportCell[] cellsNoGL() {
        Vector<ReportCell> vec = new Vector<ReportCell>();
        for (int i = 0; i < this.cells.length; ++i) {
            if (this.cells[i] instanceof GuideLine) continue;
            vec.addElement(this.cells[i]);
        }
        ReportCell[] cellArray = new ReportCell[vec.size()];
        for (int i = 0; i < vec.size(); ++i) {
            cellArray[i] = (ReportCell)vec.elementAt(i);
        }
        return cellArray;
    }

    public ReportCell[] cellsNoGLWithSecuredMode() {
        Vector<ReportCell> vec = new Vector<ReportCell>();
        for (ReportCell cell : this.cells) {
            if (cell instanceof GuideLine || this.filterElementForSecurity(cell) == null) continue;
            vec.addElement(cell);
        }
        ReportCell[] cellArray = new ReportCell[vec.size()];
        for (int i = 0; i < vec.size(); ++i) {
            cellArray[i] = (ReportCell)vec.elementAt(i);
        }
        return cellArray;
    }

    public void shift(ReportElement elt, boolean isHorizontal, double change) {
        ReportElement.shift(elt, this.cellsNoGLWithSecuredMode(), isHorizontal, change);
    }

    public void shiftOnMove(ReportElement elt, boolean isHorizontal, double change) {
        ReportElement.shiftOnMove(elt, this.cellsNoGLWithSecuredMode(), isHorizontal, change);
    }

    public void resizeForCrossTabFixedField(Vector resizeItems, double ratioW, double ratioH, double startXD, double startYD) {
        ReportElement.resizeForCrossTabFixedField(resizeItems, this.cellsNoGLWithSecuredMode(), ratioW, ratioH, startXD, startYD);
    }

    public void shiftObjectsOnMove(ReportElement elt, boolean isHorizontal, double change) {
        ReportElement.shiftObjectsOnMove(elt, this.cellsNoGLWithSecuredMode(), isHorizontal, change);
    }

    public static ReportElement[] findElementstoRight(ReportElement t, ReportSection relt) {
        ReportElement[] rc = relt.getData();
        ReportElement[] temp = ReportElement.findElementsToRight(t, rc);
        return temp;
    }

    public static ReportElement[] findElementstoLeft(ReportElement t, ReportSection relt) {
        ReportElement[] rc = relt.getData();
        ReportElement[] temp = ReportElement.findElementsToLeft(t, rc);
        return temp;
    }

    public static ReportElement[] findElementsAbove(ReportElement t, ReportSection relt) {
        ReportElement[] rc = relt.getData();
        ReportElement[] temp = ReportElement.findElementsAbove(t, rc);
        return temp;
    }

    public static void resizeHorizontallyAndShift(ReportElement t, ReportSection relt, double heightChange) {
        ReportElement[] rc = relt.getData();
        ReportElement.resizeHorizontallyAndShift(t, rc, heightChange);
    }

    public static void resizeVerticallyAndShift(ReportElement t, ReportSection relt, double heightChange) {
        ReportElement[] rc = relt.getData();
        ReportElement.resizeVerticallyAndShift(t, rc, heightChange);
    }

    public void copyImage(ReportSection rs) {
        super.copy(rs);
        this.setRepeatOnEveryPage(rs.isRepeatOnEveryPage());
        this.setResetPageNumber(rs.isResetPageNumber());
        this.setNewExcelSheet(rs.isNewExcelSheet());
        this.setVisible(rs.isVisible());
        this.isModified = rs.isModified;
        for (int m = 0; m < rs.getCellCount(); ++m) {
            if (!(rs.cells[m] instanceof ReportImage)) continue;
            this.addData(rs.cells[m]);
        }
    }

    public void removeSubReportWithFileName(String filename) {
        if (this.cells != null && this.cells.length > 0) {
            Vector<ReportCell> newCells = new Vector<ReportCell>();
            for (int i = 0; i < this.cells.length; ++i) {
                if ((!(this.cells[i] instanceof SubReportObject) || ((SubReportObject)this.cells[i]).getFileName().equals(filename)) && this.cells[i] instanceof SubReportObject) continue;
                newCells.addElement(this.cells[i]);
            }
            ReportCell[] rcs = new ReportCell[newCells.size()];
            for (int i = 0; i < rcs.length; ++i) {
                rcs[i] = (ReportCell)newCells.elementAt(i);
            }
            this.setData(rcs);
        }
        if (this.sectionList != null) {
            for (int i = 0; i < this.sectionList.size(); ++i) {
                this.sectionList.elementAt(i).removeSubReportWithFileName(filename);
            }
        }
    }

    public void renameSubReportFileNames(String[] oldFileNames, String[] newFileNames) {
        if (this.cells != null && this.cells.length > 0 && oldFileNames != null && newFileNames != null && oldFileNames.length == newFileNames.length) {
            for (ReportCell cell : this.cells) {
                if (!(cell instanceof SubReportObject)) continue;
                for (int j = 0; j < oldFileNames.length; ++j) {
                    if (!oldFileNames[j].equals(((SubReportObject)cell).getFileName())) continue;
                    ((SubReportObject)cell).setFileName(newFileNames[j]);
                    ((SubReportObject)cell).setText(newFileNames[j]);
                    j = oldFileNames.length;
                }
            }
        }
        if (this.sectionList != null) {
            for (int i = 0; i < this.sectionList.size(); ++i) {
                this.sectionList.elementAt(i).renameSubReportFileNames(oldFileNames, newFileNames);
            }
        }
    }

    public void setSubReportParameterMap(String filename, String[] paramMap) {
        if (this.cells != null && this.cells.length > 0) {
            for (ReportCell cell : this.cells) {
                if (!(cell instanceof SubReportObject) || !((SubReportObject)cell).getFileName().equals(filename)) continue;
                ((SubReportObject)cell).setParameterMap(paramMap);
            }
        }
        if (this.sectionList != null) {
            for (int i = 0; i < this.sectionList.size(); ++i) {
                this.sectionList.elementAt(i).setSubReportParameterMap(filename, paramMap);
            }
        }
    }

    public void setChartParameterMap(String filename, String[] paramMap) {
        if (this.cells != null && this.cells.length > 0) {
            for (ReportCell cell : this.cells) {
                if (!(cell instanceof ReportChartObject) || ((ReportChartObject)cell).getText() == null || !((ReportChartObject)cell).getText().equalsIgnoreCase(filename)) continue;
                ((ReportChartObject)cell).setParameterMap(paramMap);
            }
        }
        if (this.sectionList != null) {
            for (int i = 0; i < this.sectionList.size(); ++i) {
                this.sectionList.elementAt(i).setChartParameterMap(filename, paramMap);
            }
        }
    }

    public SubReportObject[] getSubReports() {
        return this.getSubReports(true);
    }

    public boolean containsSubReport(SubReportObject robj) {
        SubReportObject[] array;
        for (SubReportObject element : array = this.getSubReports()) {
            if (!element.getID().equals(robj.getID())) continue;
            return true;
        }
        return false;
    }

    public SubReportObject[] getSubReports(boolean includeSubSections) {
        Vector<ReportCell> vecCells = new Vector<ReportCell>();
        for (ReportCell cell : this.cells) {
            if (!(cell instanceof SubReportObject)) continue;
            vecCells.addElement(cell);
        }
        if (this.sectionList != null && includeSubSections) {
            for (int i = 0; i < this.sectionList.size(); ++i) {
                Object[] sreports = this.sectionList.elementAt(i).getSubReports(false);
                QbUtil.addArrayToVector(vecCells, sreports);
            }
        }
        SubReportObject[] tmp = new SubReportObject[vecCells.size()];
        for (int i = 0; i < vecCells.size(); ++i) {
            tmp[i] = (SubReportObject)vecCells.elementAt(i);
        }
        return tmp;
    }

    public int getSectionCount() {
        return this.sectionList.size();
    }

    public ReportSection addSection() {
        String id = this.getID();
        if (this.sectionList.size() > 0) {
            int newSectionNumber = this.sectionList.size();
            for (int i = 0; i < this.sectionList.size(); ++i) {
                try {
                    String lastId = this.sectionList.elementAt(i).getID();
                    int i2 = Integer.parseInt(lastId.substring(id.length()));
                    if (i2 <= newSectionNumber) continue;
                    newSectionNumber = i2;
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            id = id + ++newSectionNumber;
        } else {
            id = id + "0";
        }
        ReportSection section = new ReportSection(id);
        this.sectionList.addElement(section);
        section.parentSection = this;
        return section;
    }

    public ReportSection insertSection(int index) throws Exception {
        String id = this.getID();
        if (this.sectionList.size() > 0) {
            int newSectionNumber = this.sectionList.size();
            for (int i = 0; i < this.sectionList.size(); ++i) {
                try {
                    String lastId = this.sectionList.elementAt(i).getID();
                    int i2 = Integer.parseInt(lastId.substring(id.length()));
                    if (i2 <= newSectionNumber) continue;
                    newSectionNumber = i2;
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            id = id + ++newSectionNumber;
        } else {
            id = id + "0";
        }
        ReportSection section = new ReportSection(id);
        this.sectionList.insertElementAt(section, index);
        section.parentSection = this;
        return section;
    }

    public int getSectionIndex(ReportSection section) {
        return this.sectionList.indexOf(section);
    }

    public ReportSection getSection(int index) throws Exception {
        return this.sectionList.elementAt(index);
    }

    public void removeSection(int index) throws Exception {
        this.sectionList.removeElementAt(index);
    }

    public void removeSection(ReportSection section) {
        this.sectionList.removeElement(section);
    }

    public ReportSection getParentSection() {
        return this.parentSection;
    }

    public void adjustHeaderFormulas(int count, Vector columns, Report report, ReportCell globalFormatTemplate, boolean addExtra) {
        int i;
        ReportCell[] cs = this.getData();
        if (cs == null) {
            return;
        }
        boolean containsFormula = false;
        int maxIndex = -1;
        for (i = cs.length - 1; i >= 0; --i) {
            String formula = cs[i].getFormula();
            if (formula == null) {
                formula = cs[i].getFormulaName();
            }
            if (formula == null || !formula.trim().toLowerCase().startsWith("getheader(") || !formula.trim().endsWith(")")) continue;
            containsFormula = true;
            formula = formula.trim().substring(10);
            if (!(formula = formula.substring(0, formula.length() - 1)).trim().toLowerCase().startsWith("col(")) continue;
            formula = formula.trim().substring(4);
            formula = formula.substring(0, formula.indexOf(41));
            try {
                int index = Integer.parseInt(formula);
                if (index > maxIndex) {
                    maxIndex = index;
                }
                if (index < count) continue;
                this.removeData(i);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (maxIndex < count - 1 && containsFormula && addExtra) {
            for (i = maxIndex + 1; i < count; ++i) {
                if (report.reportType == 2 && (!report.isShowRowAggregationGrandTotal() || report.colInfo[report.getColInfoIndex(i)].isColumnBreakValue() || report.placeColumnBreakValueVertically() && report.colInfo[report.getColInfoIndex(i)].isColumnBreakValue())) continue;
                ColumnHeader header = new ColumnHeader();
                if (globalFormatTemplate != null) {
                    header.applyTemplate(globalFormatTemplate);
                }
                Formula form = new Formula(null, "getHeader(COL(" + i + "))");
                try {
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(("getHeader(COL(" + i + "))").getBytes("UTF-8"));
                    InputStreamReader inputStreamReader = new InputStreamReader((InputStream)inputStream, "UTF-8");
                    NewFormulaParser parser = new NewFormulaParser(inputStreamReader);
                    form.setFormula(parser.parse(new Vector(), null, null, null));
                }
                catch (Exception inputStream) {
                    // empty catch block
                }
                header.setFormulaObj(form);
                double x = -1.0;
                boolean visible = true;
                try {
                    x = ((ReportColumn)columns.elementAt(i)).getX();
                    visible = report.colInfo[report.getColInfoIndex(i)].isVisible();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (x == -1.0) {
                    x = i;
                }
                header.setX(x);
                header.setY(this.getHeight() - 0.3);
                if (!visible) continue;
                this.addData(header);
            }
        }
        if (this.sectionList != null && this.sectionList.size() > 0) {
            for (i = 0; i < this.sectionList.size(); ++i) {
                this.sectionList.elementAt(i).adjustHeaderFormulas(count, columns, report, globalFormatTemplate, addExtra);
            }
        }
    }

    public void adjustFooterFormulas(int count, Vector columns, Report report, ReportCell[] formats, boolean addExtra) {
        int i;
        ReportCell[] cs = this.getData();
        if (cs == null) {
            return;
        }
        boolean containsFormula = false;
        int maxIndex = -1;
        for (i = cs.length - 1; i >= 0; --i) {
            int start;
            String formula = cs[i].getFormula();
            if (formula == null) {
                formula = cs[i].getFormulaName();
            }
            if (formula == null || (start = formula.trim().toLowerCase().indexOf("col(")) < 0) continue;
            containsFormula = true;
            formula = formula.trim().substring(start + 4);
            int index1 = formula.indexOf(41);
            int index2 = formula.indexOf(44);
            int indexx = 0;
            indexx = index1 > 0 && index2 > 0 ? (index1 < index2 ? index1 : index2) : (index1 > 0 ? index1 : index2);
            formula = formula.substring(0, indexx);
            try {
                int index = Integer.parseInt(formula);
                if (index > maxIndex) {
                    maxIndex = index;
                }
                if (index < count) continue;
                this.removeData(i);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (maxIndex < count - 1 && containsFormula && addExtra) {
            for (i = maxIndex + 1; i < count; ++i) {
                int colIdx = report.getColInfoIndex(i);
                if (colIdx >= report.colInfo.length || report.reportType == 2 && (!report.isShowRowAggregationGrandTotal() || report.colInfo[colIdx].isColumnBreakValue())) continue;
                ReportCell cell = new ReportCell();
                short aggregation = report.colInfo[colIdx].getAggregation();
                String agg = IAggregateConstants.AGGR[aggregation];
                Formula form = new Formula(null, agg + "(COL(" + i + "))");
                try {
                    ByteArrayInputStream inputStream = new ByteArrayInputStream((agg + "(COL(" + i + "))").getBytes("UTF-8"));
                    InputStreamReader inputStreamReader = new InputStreamReader((InputStream)inputStream, "UTF-8");
                    NewFormulaParser parser = new NewFormulaParser(inputStreamReader);
                    form.setFormula(parser.parse(new Vector(), null, null, null));
                }
                catch (Exception inputStream) {
                    // empty catch block
                }
                cell.setFormulaObj(form);
                if (formats != null) {
                    boolean applied = false;
                    for (int j = 0; j < formats.length && !applied; ++j) {
                        if (!FormatUtil.isFormatAppliabled(cell.getDataFormat(), formats[j].getDataFormat())) continue;
                        cell.applyTemplate(formats[j]);
                        applied = true;
                    }
                }
                double x = -1.0;
                boolean visible = true;
                try {
                    x = ((ReportColumn)columns.elementAt(i)).getX();
                    visible = report.colInfo[report.getColInfoIndex(i)].isVisible();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (x == -1.0) {
                    x = i;
                }
                cell.setX(x);
                cell.setY(this.getHeight() - 0.3);
                if (!visible) continue;
                this.addData(cell);
            }
        }
    }

    protected void adjustColumnIndex(int columnOffSet, int separatingIndex, Vector columns, ReportCell[] globalFormatTemplates, int newColSize) {
        int i;
        ReportCell[] cs;
        boolean isCrossTabFixedField = false;
        if (columns != null) {
            isCrossTabFixedField = ReportSection.isCrossTabFixedField(columns);
        }
        if ((cs = this.getData()) == null || columnOffSet == 0 || separatingIndex < 0 || columns == null) {
            return;
        }
        ReportCell columnHeaderSettings = null;
        ReportCell formulaSettings = null;
        if (globalFormatTemplates != null && globalFormatTemplates.length > 0) {
            formulaSettings = globalFormatTemplates[0];
        }
        if (globalFormatTemplates != null && globalFormatTemplates.length > 1) {
            columnHeaderSettings = globalFormatTemplates[1];
        }
        Vector<ReportCell> newCells = new Vector<ReportCell>();
        Vector cellRows = this.getCellForHTML();
        for (int r = 0; r < cellRows.size(); ++r) {
            cs = (ReportCell[])cellRows.elementAt(r);
            for (int i2 = cs.length - 1; i2 >= 0; --i2) {
                String formula = cs[i2].getFormula();
                boolean changeFormulaName = false;
                if (formula == null) {
                    formula = cs[i2].getFormulaName();
                    changeFormulaName = true;
                } else if (formula.equalsIgnoreCase(cs[i2].getFormulaName())) {
                    changeFormulaName = true;
                }
                if (formula != null) {
                    try {
                        double xOffSet = 0.0;
                        boolean first = true;
                        boolean delete = false;
                        String newformula = "";
                        int colindex = formula.toLowerCase().indexOf("col(");
                        int endindex = 0;
                        while (colindex > -1) {
                            if (!first) {
                                delete = false;
                            }
                            newformula = newformula + formula.substring(endindex, colindex + 4);
                            endindex = formula.indexOf(")", colindex);
                            String indexstring = formula.substring(colindex + 4, endindex);
                            int oldindex = Integer.parseInt(indexstring.trim());
                            if (oldindex >= separatingIndex && oldindex + columnOffSet >= 0) {
                                newformula = oldindex + columnOffSet < newColSize ? newformula + (oldindex + columnOffSet) : newformula + (newColSize - 1);
                                changeFormulaName = true;
                                xOffSet = first ? (columnOffSet > 0 ? (cs[i2] instanceof ColumnHeader && columnHeaderSettings != null ? columnHeaderSettings.getWidth() * (double)columnOffSet : formulaSettings.getWidth() * (double)columnOffSet) : ((ReportColumn)columns.elementAt(oldindex + columnOffSet)).getX() - ((ReportColumn)columns.elementAt(oldindex)).getX()) : 0.0;
                            } else {
                                if (first && oldindex < separatingIndex && oldindex >= separatingIndex + columnOffSet) {
                                    delete = true;
                                }
                                newformula = newformula + formula.substring(colindex + 4, endindex);
                            }
                            colindex = formula.toLowerCase().indexOf("col(", endindex);
                            first = false;
                        }
                        if (delete) continue;
                        newformula = newformula + formula.substring(endindex);
                        Formula form = new Formula(changeFormulaName ? null : cs[i2].getFormulaName(), newformula);
                        if (cs[i2].getFormulaObj() != null) {
                            form.setDatatype(cs[i2].getFormulaObj().getDatatype(null));
                        }
                        try {
                            ByteArrayInputStream inputStream = new ByteArrayInputStream(newformula.getBytes("UTF-8"));
                            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)inputStream, "UTF-8");
                            NewFormulaParser parser = new NewFormulaParser(inputStreamReader);
                            form.setFormula(parser.parse(new Vector(), null, null, null));
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        if (cs[i2].getX() + xOffSet < 0.0) {
                            xOffSet = 0.0;
                        }
                        cs[i2].setX(cs[i2].getX() + xOffSet);
                        cs[i2].setFormulaObj(form);
                        newCells.addElement(cs[i2]);
                    }
                    catch (Exception ex) {
                        newCells.addElement(cs[i2]);
                    }
                    continue;
                }
                newCells.addElement(cs[i2]);
            }
        }
        cs = new ReportCell[newCells.size()];
        for (i = 0; i < cs.length; ++i) {
            cs[i] = (ReportCell)newCells.elementAt(i);
        }
        this.setData(cs);
        if (!isCrossTabFixedField && this.sectionList != null && this.sectionList.size() > 0) {
            for (i = 0; i < this.sectionList.size(); ++i) {
                this.sectionList.elementAt(i).adjustColumnIndex(columnOffSet, separatingIndex, columns, globalFormatTemplates, newColSize);
            }
        }
    }

    static boolean isCrossTabFixedField(Vector columns) {
        for (int i = 0; i < columns.size(); ++i) {
            if (!(columns.elementAt(i) instanceof ColumnBreakColumn)) continue;
            return true;
        }
        return false;
    }

    public boolean isCrossTabFixedFieldHeader() {
        for (int i = 0; i < this.getCellCount(); ++i) {
            if (!(this.getData(i) instanceof CBColumnHeader) && !(this.getData(i) instanceof CBAggrColHeader)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setSnapToGrid(boolean snapToGrid, boolean metric, double stepSize) {
        super.setSnapToGrid(snapToGrid, metric, stepSize);
        if (this.cells == null) {
            return;
        }
        for (ReportCell cell : this.cells) {
            cell.setSnapToGrid(snapToGrid, metric, stepSize);
        }
        for (int i = 0; i < this.sectionList.size(); ++i) {
            ReportSection sec = this.sectionList.elementAt(i);
            sec.setSnapToGrid(snapToGrid, metric, stepSize);
        }
    }

    @Override
    public void setSnapToGrid(boolean snapToGrid, double stepSize, double cmStepSize) {
        super.setSnapToGrid(snapToGrid, stepSize, cmStepSize);
        if (this.cells == null) {
            return;
        }
        for (ReportCell cell : this.cells) {
            cell.setSnapToGrid(snapToGrid, stepSize, cmStepSize);
        }
        for (int i = 0; i < this.sectionList.size(); ++i) {
            ReportSection sec = this.sectionList.elementAt(i);
            sec.setSnapToGrid(snapToGrid, stepSize, cmStepSize);
        }
    }

    public void copyAllGuideLineElts(Report report, Report _report, ReportSection section) {
        int j;
        int i;
        if (report.getHGuideLines() != null) {
            for (i = 0; i < report.getHGuideLines().size(); ++i) {
                for (j = 0; j < this.getCells().length; ++j) {
                    if (this.cells[j] == _report.getHGuideLines().elementAt(i)) {
                        this.setData(report.getHGuideLines().elementAt(i), j);
                        continue;
                    }
                    report.getHGuideLines().elementAt(i).replace(this.cells[j], section.getCells()[j]);
                }
            }
        }
        if (report.getVGuideLines() != null) {
            for (i = 0; i < report.getVGuideLines().size(); ++i) {
                for (j = 0; j < this.getCells().length; ++j) {
                    if (this.cells[j] == _report.getVGuideLines().elementAt(i)) {
                        this.setData(report.getVGuideLines().elementAt(i), j);
                        continue;
                    }
                    report.getVGuideLines().elementAt(i).replace(this.cells[j], section.getCells()[j]);
                }
            }
        }
    }

    public boolean containsSection(ReportSection sec) {
        if (sec == this) {
            return true;
        }
        for (int i = 0; i < this.sectionList.size(); ++i) {
            ReportSection rs = this.sectionList.elementAt(i);
            if (sec != rs) continue;
            return true;
        }
        return false;
    }

    public void setFitGroupOnPage(Report report, boolean b) {
        Vector<ReportTable> tbls = report.getReportTables();
        if (tbls == null || tbls.size() <= 0 || tbls.elementAt(0) == null) {
            return;
        }
        ReportTable table = tbls.elementAt(0);
        for (int i = 0; i < table.countRowBreakHeader(); ++i) {
            ReportSection section = table.getRowBreakHeader(i);
            if (section != this) continue;
            report.colInfo[report.breakColIndex[i]].setFitGroupOnPage(b);
        }
    }

    @Override
    public void renameSecurityLevel(String oldName, String newName) {
        super.renameSecurityLevel(oldName, newName);
        for (ReportCell cell : this.cells) {
            cell.renameSecurityLevel(oldName, newName);
        }
        if (this.sectionList != null) {
            for (int i = 0; i < this.sectionList.size(); ++i) {
                this.sectionList.elementAt(i).renameSecurityLevel(oldName, newName);
            }
        }
    }

    public void setLocale(Locale l) {
        int i;
        for (i = 0; i < this.getCellCount(); ++i) {
            FormatUtil.setLocale(this.getData(i).getDataFormat(), l);
        }
        if (this.sectionList != null) {
            for (i = 0; i < this.sectionList.size(); ++i) {
                this.sectionList.elementAt(i).setLocale(l);
            }
        }
    }

    public void setPackedSubReportByteArray(FileInMemTable subFilesTable, Vector subReports) {
        if (this.cells != null) {
            for (ReportCell cell : this.cells) {
                if (!(cell instanceof SubReportObject)) continue;
                SubReportObject sro = (SubReportObject)cell;
                for (int j = 0; j < subReports.size(); ++j) {
                    if (!sro.getFileName(subFilesTable).equals(((SubReportObject)subReports.elementAt(j)).getFileName(subFilesTable))) continue;
                    sro.setByteArray(((SubReportObject)subReports.elementAt(j)).getByteArray());
                }
            }
        }
        if (this.sectionList != null) {
            for (int i = 0; i < this.sectionList.size(); ++i) {
                this.sectionList.elementAt(i).setPackedSubReportByteArray(subFilesTable, subReports);
            }
        }
    }

    public void loadStyle(Report report, ReportSection _section) {
        if (_section.sectionStyle != null) {
            this.sectionStyle = _section.sectionStyle;
            this.cells = new ReportCell[_section.getCellCount() + 1];
            this.cells[0] = this.sectionStyle;
            for (int i = 1; i < this.cells.length; ++i) {
                this.cells[i] = _section.getData(i - 1);
            }
        } else {
            this.cells = _section.getData();
        }
        this.height = _section.getHeight();
    }

    private Vector getImagesAndLines() {
        Vector<ReportCell> vec = new Vector<ReportCell>();
        for (ReportCell cell : this.cells) {
            if (cell instanceof GuideLine || cell instanceof ReportChartObject || !(cell instanceof ReportImage)) continue;
            vec.addElement(cell);
        }
        return vec;
    }

    private Vector getColumnHeaders() {
        Vector<ReportCell> vec = new Vector<ReportCell>();
        for (ReportCell cell : this.cells) {
            if (!(cell instanceof ColumnHeader)) continue;
            vec.addElement(cell);
        }
        return vec;
    }

    public void applyStyle(Vector setting, ReportSection section) {
        int i;
        for (i = 0; i < this.getCellCount(); ++i) {
            ReportCell cell = this.getData(i);
            if (cell instanceof ReportChartObject) {
                cell.applyStyle((ReportChartObject)setting.elementAt(1));
                continue;
            }
            if (cell instanceof ReportLine) {
                cell.applyStyle((ReportLine)setting.elementAt(12));
                continue;
            }
            if (cell instanceof ReportGrid) {
                cell.applyStyle((ReportGrid)setting.elementAt(13));
                continue;
            }
            if (cell instanceof ReportImage) {
                cell.applyStyle((ReportImage)setting.elementAt(2));
                continue;
            }
            if (cell instanceof ColumnHeader) {
                cell.applyStyle((ColumnHeader)setting.elementAt(14));
                continue;
            }
            if (cell instanceof ReportTitle) {
                cell.applyStyle((ReportTitle)setting.elementAt(15));
                continue;
            }
            if (cell.getFormula() == null) {
                cell.applyStyle((ReportCell)setting.elementAt(0));
                continue;
            }
            cell.applyStyle((ReportCell)setting.elementAt(3));
            cell.applyStyle((ReportCell)setting.elementAt(4));
            cell.applyStyle((ReportCell)setting.elementAt(5));
            cell.applyStyle((ReportCell)setting.elementAt(6));
        }
        for (i = 0; i < this.getCellCount(); ++i) {
            if (!(this.cells[i] instanceof ColumnHeader)) continue;
            this.cells[i].setX(this.cells[i].getWidth() * (double)i);
        }
        this.applyStyle(section);
    }

    private boolean isQuickDesignerCustomCell(ReportCell cell) {
        if (cell.getCustomID() == null) {
            return false;
        }
        return cell.getCustomID().equals(REPORT_FOOTER_ID) || cell.getCustomID().equals(GROUP_FOOTER_ID);
    }

    public void applyStyleForDHTMLViewer(ReportSection section) {
        int i;
        super.applyStyle(section);
        ReportCell tmpCell = null;
        for (i = 0; i < section.getCellCount(); ++i) {
            if (!section.getData(i).isVisible() || section.getData(i) instanceof ReportImage || this.isQuickDesignerCustomCell(section.getData(i))) continue;
            tmpCell = section.getData(i);
            break;
        }
        if (tmpCell != null) {
            for (i = 0; i < this.getCellCount(); ++i) {
                this.cells[i].applyStyle((ReportElement)tmpCell);
            }
        }
        for (i = 0; i < section.getCellCount(); ++i) {
            if (section.getData(i).isVisible() && section.getData(i) instanceof ReportImage) {
                this.addData(section.getData(i));
                continue;
            }
            if (!section.getData(i).isVisible() || !this.isQuickDesignerCustomCell(section.getData(i))) continue;
            ReportCell newCell = ReportCell.clone(section.getData(i));
            double x = this.getCustomCellXPosition(section.getData(i));
            if ((x -= newCell.getWidth()) < 0.0) {
                x = 0.0;
            }
            newCell.setX(x);
            this.addData(newCell);
        }
    }

    private double getCustomCellXPosition(ReportCell _cell) {
        if (_cell.getX() == 0.0) {
            return 0.0;
        }
        return this.leftMostCellX();
    }

    private double leftMostCellX() {
        ReportCell[] cells = this.getData();
        double leftMostX = Double.MAX_VALUE;
        for (ReportCell cell : cells) {
            if (cell instanceof ReportChartObject || cell instanceof ReportLine || !(cell.getX() < leftMostX)) continue;
            leftMostX = cell.getX();
        }
        if (leftMostX == Double.MAX_VALUE) {
            return 0.0;
        }
        return leftMostX;
    }

    public void applyStyle(ReportSection section) {
        if (section.getSectionStyle() != null) {
            for (int i = 0; i < this.getCellCount(); ++i) {
                this.cells[i].applyStyle(section.getSectionStyle());
                if (!(this.cells[i] instanceof ColumnHeader)) continue;
                this.cells[i].setX(this.cells[i].getWidth() * (double)i);
            }
        }
        Vector<ReportCell> temp = new Vector<ReportCell>();
        for (int i = 0; i < section.getCellCount(); ++i) {
            if (section.getData(i) instanceof ReportLine && !((ReportLine)section.getData(i)).isVertical()) {
                temp.addElement(section.getData(i));
                continue;
            }
            if (section.getData(i) instanceof ReportGrid) {
                temp.addElement(section.getData(i));
                continue;
            }
            if (section.getData(i) instanceof ReportChartObject || !(section.getData(i) instanceof ReportImage)) continue;
            temp.addElement(section.getData(i));
        }
        if (temp.size() > 0) {
            int i;
            ReportCell[] newCells = new ReportCell[this.getCellCount() + temp.size()];
            for (i = 0; i < this.getCellCount(); ++i) {
                newCells[i] = this.cells[i];
            }
            for (i = 0; i < temp.size(); ++i) {
                newCells[i + this.getCellCount()] = (ReportCell)temp.elementAt(i);
            }
            this.cells = newCells;
        }
        this.height = section.getHeight();
    }

    public void createReportTitle(String text) {
        for (int i = 0; i < this.getCellCount(); ++i) {
            if (!text.equals(this.cells[i].getText())) continue;
            ReportTitle title = new ReportTitle(text);
            title.copy(this.cells[i]);
            this.cells[i] = title;
        }
    }

    public boolean hasExtendVertLineOrGrid() {
        for (int i = 0; i < this.getCellCount(); ++i) {
            ReportLine l;
            if (!(this.cells[i] instanceof ReportLine ? (l = (ReportLine)this.cells[i]).isVertical() && l.getHeight() == -1.0 : this.cells[i] instanceof ReportGrid && this.cells[i].getHeight() == -1.0)) continue;
            return true;
        }
        return false;
    }

    public void deleteSubReportColData() {
        ReportCell[] cells;
        for (ReportCell cell : cells = this.getData()) {
            if (!(cell instanceof SubReportObject)) continue;
            ((SubReportObject)cell).refreshColData();
        }
        if (this.sectionList != null) {
            for (int i = 0; i < this.sectionList.size(); ++i) {
                this.sectionList.elementAt(i).deleteSubReportColData();
            }
        }
    }
}

