/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.ReportElements;

import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import quadbase.common.client.ServerMessage;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.FileInMemTable;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.QbUtil;
import quadbase.reportdesigner.ReportElements.CBAggrColHeader;
import quadbase.reportdesigner.ReportElements.CBAggrColumn;
import quadbase.reportdesigner.ReportElements.CBColumnHeader;
import quadbase.reportdesigner.ReportElements.ColumnBreakColumn;
import quadbase.reportdesigner.ReportElements.ColumnHeader;
import quadbase.reportdesigner.ReportElements.ColumnWrap;
import quadbase.reportdesigner.ReportElements.FormattedRow;
import quadbase.reportdesigner.ReportElements.FormattedRowKey;
import quadbase.reportdesigner.ReportElements.GuideLine;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportChartObject;
import quadbase.reportdesigner.ReportElements.ReportColumn;
import quadbase.reportdesigner.ReportElements.ReportDocument;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.ReportElements.ReportGrid;
import quadbase.reportdesigner.ReportElements.ReportImage;
import quadbase.reportdesigner.ReportElements.ReportLine;
import quadbase.reportdesigner.ReportElements.ReportRTFObject;
import quadbase.reportdesigner.ReportElements.ReportSection;
import quadbase.reportdesigner.ReportElements.ReportTableElement;
import quadbase.reportdesigner.ReportElements.ReportTreeTable;
import quadbase.reportdesigner.ReportElements.SubReportObject;
import quadbase.reportdesigner.report.AbstractReportSectionFactory;
import quadbase.reportdesigner.report.CrossTabColumnAttr;
import quadbase.reportdesigner.report.CrossTabTable;
import quadbase.reportdesigner.report.Formula;
import quadbase.reportdesigner.report.IndexNode;
import quadbase.reportdesigner.report.LoadXMLReportHelper;
import quadbase.reportdesigner.report.MultiDimData;
import quadbase.reportdesigner.report.NewFormulaParser;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.ReportMultiSectionTable;
import quadbase.reportdesigner.report.ReportSectionFactory;
import quadbase.reportdesigner.report.Script;
import quadbase.reportdesigner.util.IFormat;
import quadbase.reportdesigner.util.IReport;
import quadbase.reportdesigner.util.ISubReport;
import quadbase.reportdesigner.util.ImageURLFormat;
import quadbase.reportdesigner.util.TextURLFormat;
import quadbase.reportdesigner.util.internal.FormatUtil;

public class ReportTable
extends ReportTableElement
implements Serializable {
    private Vector<ReportColumn> columns = new Vector();
    private Vector<ReportElement> charts = new Vector();
    private Locale locale = null;
    private TimeZone timeZone = null;
    protected ReportSection header;
    protected ReportSection footer;
    private Vector<SubReportObject> subReports = new Vector();
    private Vector<ReportElement> rtfObjects = new Vector();
    public int[] indexArray;
    private IndexNode indexTree;
    private int index = 0;
    private int tableNumber = 0;
    private ReportColumn sectionStyle;
    public boolean[][] rowsWithMissingChart;
    public Hashtable<String, Object> aggrResult;
    protected ReportSection masterSection = null;
    private Hashtable<FormattedRowKey, FormattedRow> formattedRows = null;
    public static final String XMLTAG = "REPORTTABLE";
    private boolean isAggrTable = false;
    private int printOnNewPageRowCount = 0;
    private int hashCode = super.hashCode();
    protected AbstractReportSectionFactory reportSectionFactory;

    public ReportTable() {
        this.header = this.getReportSectionFactory().createSection(this);
        this.footer = this.getReportSectionFactory().createSection(this);
        this.setBgColor(null);
    }

    public ReportTable(Locale locale, TimeZone timeZone) {
        this();
        this.locale = locale;
        this.timeZone = timeZone;
    }

    public ReportTable(ReportTable _tbl) {
        this();
        super.copy(_tbl);
        this.charts = _tbl.charts;
        this.subReports = _tbl.subReports;
        this.rtfObjects = _tbl.rtfObjects;
        this.masterSection = _tbl.masterSection;
        this.locale = _tbl.locale;
        this.timeZone = _tbl.timeZone;
        this.tableNumber = _tbl.tableNumber;
        this.isAggrTable = _tbl.isAggrTable;
        this.rowsWithMissingChart = _tbl.rowsWithMissingChart;
        this.setSectionStyle(_tbl.sectionStyle);
        this.printOnNewPageRowCount = _tbl.printOnNewPageRowCount;
    }

    public AbstractReportSectionFactory getReportSectionFactory() {
        return new ReportSectionFactory();
    }

    public AbstractReportSectionFactory getReportSectionFactory(int version, boolean pack, FileInMemTable subFilesTable, String domainPath) {
        if (this.reportSectionFactory == null) {
            this.reportSectionFactory = new ReportSectionFactory(version, pack, subFilesTable, domainPath);
        }
        return this.reportSectionFactory;
    }

    public void copy(ReportTable _tbl) {
        super.copy(_tbl);
        this.locale = _tbl.locale;
        this.timeZone = _tbl.timeZone;
        int ct = _tbl.getColumnCount();
        ct = ct > this.getColumnCount() ? this.getColumnCount() : ct;
        for (int i = 0; i < ct; ++i) {
            this.columns.setElementAt(new ReportColumn(_tbl.getColumn(i)), i);
        }
        this.charts = _tbl.charts;
        this.subReports = _tbl.subReports;
        this.rtfObjects = _tbl.rtfObjects;
        this.setMasterSection(_tbl.getMasterSection());
        this.setHeader(_tbl.getHeader());
        this.setFooter(_tbl.getFooter());
        this.setTableNumber(_tbl.getTableNumber());
        this.isAggrTable = _tbl.isAggrTable;
        this.rowsWithMissingChart = _tbl.rowsWithMissingChart;
        this.setSectionStyle(_tbl.sectionStyle);
        this.printOnNewPageRowCount = _tbl.printOnNewPageRowCount;
    }

    public void loadTable(ReportTable _tbl) {
        this.loadTable(_tbl, true, -1, true, true);
    }

    public void loadTable(ReportTable _tbl, int separatingIndex) {
        this.loadTable(_tbl, true, separatingIndex, true, true);
    }

    public void loadTable(ReportTable _tbl, boolean applyFormula) {
        this.loadTable(_tbl, applyFormula, -1, true, true);
    }

    public void loadTable(ReportTable _tbl, boolean applyFormula, boolean copyRpt) {
        this.loadTable(_tbl, applyFormula, -1, true, copyRpt);
    }

    public void loadTable(ReportTable _tbl, boolean applyFormula, int separatingIndex, boolean generateCrossTabGrandTotalColumn) {
        this.loadTable(_tbl, applyFormula, separatingIndex, generateCrossTabGrandTotalColumn, true);
    }

    public void loadTable(ReportTable _tbl, boolean applyFormula, int separatingIndex, boolean generateCrossTabGrandTotalColumn, boolean copyRpt) {
        if (this instanceof ReportMultiSectionTable) {
            ((ReportMultiSectionTable)this).superloadTable(_tbl, applyFormula, separatingIndex, generateCrossTabGrandTotalColumn, copyRpt, true);
        } else {
            this.loadTable(_tbl, applyFormula, separatingIndex, generateCrossTabGrandTotalColumn, copyRpt, true);
        }
    }

    public void loadTable(ReportTable _tbl, boolean applyFormula, int separatingIndex, boolean generateCrossTabGrandTotalColumn, boolean copyRpt, boolean copyVisible) {
        if (this instanceof ReportMultiSectionTable) {
            ((ReportMultiSectionTable)this).superloadTable(_tbl, applyFormula, separatingIndex, generateCrossTabGrandTotalColumn, copyRpt, copyVisible, null);
        } else {
            this.loadTable(_tbl, applyFormula, separatingIndex, generateCrossTabGrandTotalColumn, copyRpt, copyVisible, null, -1);
        }
    }

    public void loadTable(ReportTable _tbl, boolean applyFormula, int separatingIndex, boolean generateCrossTabGrandTotalColumn, boolean copyRpt, boolean copyVisible, ReportCell[] globalFormatTemplates, int reportType) {
        super.copyTemplate(_tbl);
        this.locale = _tbl.locale;
        this.timeZone = _tbl.timeZone;
        if (!(_tbl instanceof ReportTreeTable)) {
            this.header.copy(_tbl.getHeader(), 0, -1, null, null, !copyRpt, false, true, applyFormula);
            this.footer.copy(_tbl.getFooter(), 0, -1, null, null, !copyRpt, false, true, applyFormula);
        }
        int len = this.getColumnCount() <= _tbl.getColumnCount() ? this.getColumnCount() : _tbl.getColumnCount();
        int realSeparatingIndex = separatingIndex + this.getColumnCount() - _tbl.getColumnCount();
        int columnCount = this.getColumnCount();
        int oldColumnCount = _tbl.getColumnCount();
        if (!generateCrossTabGrandTotalColumn) {
            ++columnCount;
            ++oldColumnCount;
        }
        if (separatingIndex >= 0 && realSeparatingIndex >= 0 && separatingIndex < oldColumnCount && realSeparatingIndex < columnCount) {
            int cnt_invisible = 0;
            for (int i = realSeparatingIndex; i < columnCount; ++i) {
                if (i >= this.getColumnCount()) continue;
                this.getColumn(i).copyTemplate(_tbl.getColumn(separatingIndex + i - realSeparatingIndex), applyFormula);
                if (realSeparatingIndex > separatingIndex) {
                    this.getColumn(i).setX(this.getColumn(i).getX() + (double)(realSeparatingIndex - separatingIndex) * this.getColumn(i).getWidth());
                    continue;
                }
                if (realSeparatingIndex >= separatingIndex) continue;
                if (this instanceof CrossTabTable) {
                    if (!this.getColumn(i).isVisible()) {
                        ++cnt_invisible;
                        continue;
                    }
                    this.getColumn(i).setX(_tbl.getColumn(i - cnt_invisible).getX());
                    continue;
                }
                this.getColumn(i).setX(_tbl.getColumn(i).getX());
            }
            int n = len = realSeparatingIndex < separatingIndex ? realSeparatingIndex : separatingIndex;
        }
        if (copyVisible) {
            for (int i = 0; i < len; ++i) {
                this.getColumn(i).copyTemplate(_tbl.getColumn(i), applyFormula);
            }
        } else {
            ReportColumn[] oldVCols = _tbl.getVisibleColumnList();
            ReportColumn[] newVCols = this.getVisibleColumnList();
            if (oldVCols != null && newVCols != null) {
                int vLen;
                int n = vLen = oldVCols.length > newVCols.length ? newVCols.length : oldVCols.length;
                if (this instanceof CrossTabTable && generateCrossTabGrandTotalColumn) {
                    --vLen;
                }
                for (int i = 0; i < vLen; ++i) {
                    newVCols[i].copyTemplate(oldVCols[i], applyFormula);
                }
                if (this instanceof CrossTabTable && generateCrossTabGrandTotalColumn) {
                    newVCols[newVCols.length - 1].copyTemplate(oldVCols[oldVCols.length - 1], applyFormula);
                }
            }
            ReportColumn[] oldICols = _tbl.getInvisibleColumnList();
            ReportColumn[] newICols = this.getInvisibleColumnList();
            if (oldICols != null && newICols != null) {
                int iLen = oldICols.length > newICols.length ? newICols.length : oldICols.length;
                for (int i = 0; i < iLen; ++i) {
                    newICols[i].copyTemplate(oldICols[i], applyFormula);
                }
            }
        }
        CrossTabColumnAttr colAttr = null;
        boolean isDesignMode = false;
        if (this instanceof CrossTabTable) {
            colAttr = ((CrossTabTable)this).getColumnAttributes();
            isDesignMode = ((CrossTabTable)this).isDesignMode();
        }
        int k = 0;
        int j = 0;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            double orgY;
            ReportColumn _cell = null;
            if (this.getColumn(i) instanceof ColumnBreakColumn) {
                double orgX = this.getColumn(i).getX();
                orgY = this.getColumn(i).getY();
                _cell = _tbl.getFirstColumnBreakColumn(((ColumnBreakColumn)this.getColumn(i)).getColBreakValueIndex());
                if (_cell != null) {
                    this.getColumn(i).copyTemplate(_cell, applyFormula);
                }
                this.getColumn(i).setX(orgX);
                this.getColumn(i).setY(orgY);
                this.getColumn(i).setVisible(colAttr == null || isDesignMode || !colAttr.isNullColumn(k));
                ++k;
                continue;
            }
            if (this.getColumn(i) instanceof CBAggrColumn) {
                double orgX = this.getColumn(i).getX();
                orgY = this.getColumn(i).getY();
                _cell = _tbl.getFirstCBAggrColumn(((CBAggrColumn)this.getColumn(i)).getColBreakLevel(), ((CBAggrColumn)this.getColumn(i)).getColBreakValueIndex());
                if (_cell != null) {
                    this.getColumn(i).copyTemplate(_cell, applyFormula);
                }
                this.getColumn(i).setX(orgX);
                this.getColumn(i).setY(orgY);
                continue;
            }
            int collen = _tbl.getColumnCount();
            if (this instanceof CrossTabTable && generateCrossTabGrandTotalColumn) {
                --collen;
            }
            while (j < collen) {
                if (_tbl.getColumn(j) instanceof ColumnBreakColumn || _tbl.getColumn(j) instanceof CBAggrColumn) {
                    ++j;
                    continue;
                }
                double orgX = this.getColumn(i).getX();
                double orgY2 = this.getColumn(i).getY();
                this.getColumn(i).copyTemplate(_tbl.getColumn(j));
                this.getColumn(i).setX(orgX);
                this.getColumn(i).setY(orgY2);
                ++j;
                break;
            }
            if (!(this instanceof CrossTabTable) || !generateCrossTabGrandTotalColumn) continue;
            this.getColumn(this.getColumnCount() - 1).copyTemplate(_tbl.getColumn(_tbl.getColumnCount() - 1), false, false);
        }
        if (separatingIndex >= 0 && realSeparatingIndex >= 0 && separatingIndex < oldColumnCount && realSeparatingIndex < columnCount) {
            double supposeXPos = 0.0;
            if (separatingIndex - 1 >= 0) {
                supposeXPos = _tbl.getColumn(separatingIndex - 1).getX() + _tbl.getColumn(separatingIndex - 1).getWidth();
            }
            for (int i = separatingIndex; i < realSeparatingIndex; ++i) {
                this.getColumn(i).setX(supposeXPos + (double)(i - separatingIndex) * this.getColumn(i).getWidth());
            }
        }
        this.charts = _tbl.charts;
        this.subReports = _tbl.subReports;
        this.rtfObjects = _tbl.rtfObjects;
        this.setMasterSection(_tbl.getMasterSection());
        this.setTableNumber(_tbl.getTableNumber());
        this.isAggrTable = _tbl.isAggrTable;
        this.rowsWithMissingChart = _tbl.rowsWithMissingChart;
        this.setSectionStyle(_tbl.sectionStyle);
        this.printOnNewPageRowCount = _tbl.printOnNewPageRowCount;
    }

    public int getFormatColumnIndex(MultiDimData mData, int index) {
        int breakRowIndex = this.getStartOfColumnBreakColumn();
        if (index <= breakRowIndex) {
            return index;
        }
        if (mData.getReport().colInfo[index].isColumnBreak()) {
            return breakRowIndex;
        }
        int count_non_breaks = 0;
        for (int i = index - 1; i > breakRowIndex; --i) {
            if (mData.getReport().colInfo[i].isColumnBreak()) continue;
            ++count_non_breaks;
        }
        int count_break_value = 0;
        for (int i = index - 1; i > breakRowIndex; --i) {
            if (!mData.getReport().colInfo[i].isColumnBreakValue()) continue;
            ++count_break_value;
        }
        if (!mData.getReport().isShowRowAggregationGrandTotal()) {
            return breakRowIndex + this.getColumnBreakColumnCount() - count_break_value + count_non_breaks;
        }
        return breakRowIndex + this.getColumnBreakColumnCount() + count_non_breaks;
    }

    public void setAggregationTable(boolean b) {
        this.isAggrTable = b;
    }

    public boolean isAggregationTable() {
        return this.isAggrTable;
    }

    public ColumnBreakColumn getFirstColumnBreakColumn(int colBkValIdx) {
        Vector<ReportColumn> colList = this.getColumns();
        for (int i = 0; i < colList.size(); ++i) {
            if (!(colList.elementAt(i) instanceof ColumnBreakColumn) || ((ColumnBreakColumn)colList.elementAt(i)).getColBreakValueIndex() != colBkValIdx) continue;
            return (ColumnBreakColumn)colList.elementAt(i);
        }
        return null;
    }

    public int getFixedFieldColumnBreakColumnCount() {
        Vector<ReportColumn> colList = this.getColumns();
        int ct = 0;
        for (int i = 0; i < colList.size(); ++i) {
            if (!(colList.elementAt(i) instanceof ColumnBreakColumn) || ((ColumnBreakColumn)colList.elementAt(i)).getColBreakValueIndex() != 0) continue;
            ++ct;
        }
        return ct;
    }

    public CBAggrColumn getFirstCBAggrColumn(int level, int colBkValIdx) {
        Vector<ReportColumn> colList = this.getColumns();
        for (int i = 0; i < colList.size(); ++i) {
            if (!(colList.elementAt(i) instanceof CBAggrColumn) || ((CBAggrColumn)colList.elementAt(i)).getColBreakLevel() != level || ((CBAggrColumn)colList.elementAt(i)).getColBreakValueIndex() != colBkValIdx) continue;
            return (CBAggrColumn)colList.elementAt(i);
        }
        return null;
    }

    public void copyTemplate(ReportTable _tbl) {
        this.copyTemplate(_tbl, false, false);
    }

    public void copyTemplate(ReportTable _tbl, boolean applyFormula) {
        this.copyTemplate(_tbl, applyFormula, false);
    }

    public void copyTemplate(ReportTable _tbl, boolean applyFormula, boolean copyEmptySection) {
        this.copyTemplate(_tbl, applyFormula, copyEmptySection, false);
    }

    public void copyTemplate(ReportTable _tbl, boolean applyFormula, boolean copyEmptySection, boolean copyGuideLine) {
        this.copyTemplate(_tbl, applyFormula, copyEmptySection, copyGuideLine, false);
    }

    public void copyTemplate(ReportTable _tbl, boolean applyFormula, boolean copyEmptySection, boolean copyGuideLine, boolean isApplyTemplateForDHTMLViewer) {
        super.copyTemplate(_tbl);
        this.locale = _tbl.locale;
        this.timeZone = _tbl.timeZone;
        if (!(_tbl instanceof ReportTreeTable)) {
            this.header.copyTemplate(_tbl.getHeader(), copyEmptySection);
            if (isApplyTemplateForDHTMLViewer) {
                this.footer.applyStyleForDHTMLViewer(_tbl.getFooter());
            } else {
                this.footer.copyTemplate(_tbl.getFooter(), copyEmptySection);
            }
        }
        if (ReportSection.isCrossTabFixedField(this.columns) && ReportSection.isCrossTabFixedField(_tbl.columns)) {
            int j = 0;
            block0: for (int i = 0; i < this.getColumnCount(); ++i) {
                ReportColumn tmpCol;
                if (this.getColumn(i) instanceof ColumnBreakColumn) {
                    tmpCol = _tbl.getFirstColumnBreakColumn(((ColumnBreakColumn)this.getColumn(i)).getColBreakValueIndex());
                    if (tmpCol == null) continue;
                    this.getColumn(i).applyStyle(tmpCol);
                    continue;
                }
                if (this.getColumn(i) instanceof CBAggrColumn) {
                    tmpCol = _tbl.getFirstCBAggrColumn(((CBAggrColumn)this.getColumn(i)).getColBreakLevel(), ((CBAggrColumn)this.getColumn(i)).getColBreakValueIndex());
                    if (tmpCol == null) continue;
                    this.getColumn(i).applyStyle(tmpCol);
                    continue;
                }
                while (j < _tbl.getColumnCount()) {
                    if (_tbl.getColumn(j) instanceof ColumnBreakColumn || _tbl.getColumn(j) instanceof CBAggrColumn) {
                        ++j;
                        continue;
                    }
                    this.getColumn(i).applyStyle(_tbl.getColumn(j));
                    ++j;
                    continue block0;
                }
            }
            int len = this.getColumnCount() <= _tbl.getColumnCount() ? this.getColumnCount() : _tbl.getColumnCount();
            for (int i = 0; i < len; ++i) {
                if (this.getColumnCount() == _tbl.getColumnCount()) {
                    this.getColumn(i).setX(_tbl.getColumn(i).getX());
                    this.getColumn(i).setY(_tbl.getColumn(i).getY());
                }
                if (copyGuideLine) continue;
                this.getColumn(i).setSnap((short)0);
                this.getColumn(i).setVSnap((short)0);
            }
        } else {
            int len = this.getColumnCount() <= _tbl.getColumnCount() ? this.getColumnCount() : _tbl.getColumnCount();
            for (int i = 0; i < len; ++i) {
                this.getColumn(i).copyTemplate(_tbl.getColumn(i), applyFormula, true, false);
                if (copyGuideLine) continue;
                this.getColumn(i).setSnap((short)0);
                this.getColumn(i).setVSnap((short)0);
            }
        }
        this.charts = copyGuideLine ? _tbl.charts : _tbl.getChartsNoGuideLine();
        this.rtfObjects = _tbl.rtfObjects;
        if (this.masterSection != null && _tbl.getMasterSection() != null) {
            this.masterSection.copyTemplate(_tbl.getMasterSection());
        }
        this.setTableNumber(_tbl.getTableNumber());
        this.isAggrTable = _tbl.isAggrTable;
        this.rowsWithMissingChart = _tbl.rowsWithMissingChart;
        this.printOnNewPageRowCount = _tbl.printOnNewPageRowCount;
    }

    public void applyStyleForFixedFieldTable(ReportTable _tbl, boolean copyScripts) {
        double orgH = this.height;
        super.applyTemplate(_tbl);
        this.setHeight(orgH);
        int j = 0;
        block0: for (int i = 0; i < this.getColumnCount(); ++i) {
            ReportColumn tmpCol;
            if (!this.getColumn(i).isVisible()) continue;
            if (this.getColumn(i) instanceof ColumnBreakColumn) {
                tmpCol = _tbl.getFirstColumnBreakColumn(((ColumnBreakColumn)this.getColumn(i)).getColBreakValueIndex());
                if (tmpCol == null) continue;
                this.getColumn(i).copyStyleWithScriptsButNotWH(tmpCol, copyScripts);
                continue;
            }
            if (this.getColumn(i) instanceof CBAggrColumn) {
                tmpCol = _tbl.getFirstCBAggrColumn(((CBAggrColumn)this.getColumn(i)).getColBreakLevel(), ((CBAggrColumn)this.getColumn(i)).getColBreakValueIndex());
                if (tmpCol == null) continue;
                this.getColumn(i).copyStyleWithScriptsButNotWH(tmpCol, copyScripts);
                continue;
            }
            while (j < _tbl.getColumnCount()) {
                if (_tbl.getColumn(j) instanceof ColumnBreakColumn || _tbl.getColumn(j) instanceof CBAggrColumn || !_tbl.getColumn(j).isVisible()) {
                    ++j;
                    continue;
                }
                this.getColumn(i).copyStyleWithScriptsButNotWH(_tbl.getColumn(j), copyScripts);
                ++j;
                continue block0;
            }
        }
    }

    public Vector<ReportColumn> getColumnsIgnoreRepeatColumn() {
        Vector<ReportColumn> newCols = new Vector<ReportColumn>();
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (this.getColumn(i) instanceof ColumnBreakColumn || this.getColumn(i) instanceof CBAggrColumn) continue;
            newCols.addElement(this.getColumn(i));
        }
        return newCols;
    }

    public void deepCopy(ReportTable _tbl) {
        ReportRTFObject[] rro;
        SubReportObject[] srs;
        super.deepCopy(_tbl);
        this.locale = _tbl.locale;
        this.timeZone = _tbl.timeZone;
        if (!(_tbl instanceof ReportTreeTable)) {
            this.header.deepCopy(_tbl.getHeader());
            this.footer.deepCopy(_tbl.getFooter());
        }
        int len = this.getColumnCount() <= _tbl.getColumnCount() ? this.getColumnCount() : _tbl.getColumnCount();
        for (int i = 0; i < len; ++i) {
            this.getColumn(i).deepCopy(_tbl.getColumn(i));
        }
        this.charts = new Vector();
        for (int j = 0; j < _tbl.getImageCount(); ++j) {
            ReportLine line;
            SubReportObject[] temp = _tbl.getImage(j);
            if (_tbl.getImage(j) instanceof ReportChartObject) {
                ReportChartObject chart = new ReportChartObject();
                chart.deepCopy((ReportChartObject)_tbl.getImage(j));
                this.charts.addElement(chart);
                continue;
            }
            if (temp instanceof ColumnWrap) {
                line = new ColumnWrap(temp.getX());
                ((ColumnWrap)line).deepCopy((ColumnWrap)temp);
                this.charts.addElement(line);
                continue;
            }
            if (temp instanceof GuideLine) {
                line = new GuideLine();
                ((GuideLine)line).deepCopy((GuideLine)temp);
                this.charts.addElement(line);
                continue;
            }
            if (temp instanceof ReportLine) {
                line = new ReportLine();
                line.deepCopy((ReportLine)temp);
                this.charts.addElement(line);
                continue;
            }
            if (_tbl.getImage(j) instanceof ReportGrid) {
                ReportGrid grid = new ReportGrid();
                grid.deepCopy((ReportGrid)_tbl.getImage(j));
                this.charts.addElement(grid);
                continue;
            }
            ReportImage image = new ReportImage();
            image.deepCopy(_tbl.getImage(j));
            this.charts.addElement(image);
        }
        this.subReports = new Vector();
        for (SubReportObject sr : srs = _tbl.getSubReports()) {
            SubReportObject s = new SubReportObject();
            s.deepCopy(sr);
            this.subReports.addElement(s);
        }
        this.rtfObjects = new Vector();
        for (ReportRTFObject element : rro = _tbl.getRTFObjects()) {
            ReportRTFObject s = new ReportRTFObject(null);
            s.deepCopy(element);
            this.rtfObjects.addElement(s);
        }
        if (_tbl.getMasterSection() != null) {
            ReportSection mSection = new ReportSection("MTR_SEC", "Master Section");
            mSection.deepCopy(_tbl.getMasterSection());
            this.setMasterSection(mSection);
        } else {
            this.setMasterSection(null);
        }
        this.indexArray = _tbl.indexArray;
        this.setTableNumber(_tbl.getTableNumber());
        this.isAggrTable = _tbl.isAggrTable;
        this.rowsWithMissingChart = _tbl.rowsWithMissingChart;
        this.setSectionStyle(_tbl.sectionStyle);
        this.printOnNewPageRowCount = _tbl.printOnNewPageRowCount;
    }

    public void positionCopy(ReportTable _tbl) {
        super.copy(_tbl);
        this.hashCode = _tbl.hashCode;
        this.locale = _tbl.locale;
        this.timeZone = _tbl.timeZone;
        if (!(_tbl instanceof ReportTreeTable)) {
            this.header = _tbl.getHeader();
            this.footer = _tbl.getFooter();
        }
        int len = _tbl.getColumnCount();
        for (int i = 0; i < len; ++i) {
            ReportColumn col = new ReportColumn();
            col.positionCopy(_tbl.getColumn(i));
            this.columns.addElement(col);
        }
        this.charts = new Vector();
        for (int j = 0; j < _tbl.getImageCount(); ++j) {
            ReportLine line;
            ReportImage temp = _tbl.getImage(j);
            if (_tbl.getImage(j) instanceof ReportChartObject) {
                ReportChartObject chart = new ReportChartObject();
                chart.deepCopy((ReportChartObject)_tbl.getImage(j));
                this.charts.addElement(chart);
                continue;
            }
            if (temp instanceof ColumnWrap) {
                line = new ColumnWrap(temp.getX());
                ((ColumnWrap)line).deepCopy((ColumnWrap)temp);
                this.charts.addElement(line);
                continue;
            }
            if (temp instanceof GuideLine) {
                line = new GuideLine();
                ((GuideLine)line).deepCopy((GuideLine)temp);
                this.charts.addElement(line);
                continue;
            }
            if (temp instanceof ReportLine) {
                line = new ReportLine();
                line.deepCopy((ReportLine)temp);
                this.charts.addElement(line);
                continue;
            }
            if (_tbl.getImage(j) instanceof ReportGrid) {
                ReportGrid grid = new ReportGrid();
                grid.deepCopy((ReportGrid)_tbl.getImage(j));
                this.charts.addElement(grid);
                continue;
            }
            ReportImage image = new ReportImage();
            image.deepCopy(_tbl.getImage(j));
            this.charts.addElement(image);
        }
        this.subReports = _tbl.subReports;
        this.rtfObjects = _tbl.rtfObjects;
        this.setMasterSection(_tbl.getMasterSection());
        this.indexArray = _tbl.indexArray;
        this.setTableNumber(_tbl.getTableNumber());
        this.rowsWithMissingChart = _tbl.rowsWithMissingChart;
        this.setSectionStyle(_tbl.sectionStyle);
        this.printOnNewPageRowCount = _tbl.printOnNewPageRowCount;
    }

    public void copyGuideLineElts(Report _report) {
        int j;
        int i;
        ReportTable _tbl = _report.getReportTables().elementAt(0);
        if (_report.getHGuideLines() != null) {
            for (i = 0; i < _report.getHGuideLines().size(); ++i) {
                for (j = 0; j < this.getColumnCount(); ++j) {
                    _report.getHGuideLines().elementAt(i).replace(this.getColumn(j), _tbl.getColumn(j));
                }
            }
        }
        if (_report.getVGuideLines() != null) {
            for (i = 0; i < _report.getVGuideLines().size(); ++i) {
                for (j = 0; j < this.getColumnCount(); ++j) {
                    _report.getVGuideLines().elementAt(i).replace(this.getColumn(j), _tbl.getColumn(j));
                }
            }
        }
    }

    public void copyAllGuideLineElts(Report report, Report _report, ReportTable _tbl) {
        int j;
        int i;
        if (report.getHGuideLines() != null) {
            for (i = 0; i < report.getHGuideLines().size(); ++i) {
                for (j = 0; j < this.getColumnCount(); ++j) {
                    report.getHGuideLines().elementAt(i).replace(this.getColumn(j), _tbl.getColumn(j));
                }
                for (j = 0; j < this.header.getCells().length; ++j) {
                    if (_tbl.header.getCells()[j] == _report.getHGuideLines().elementAt(i)) {
                        this.header.setData(report.getHGuideLines().elementAt(i), j);
                        continue;
                    }
                    report.getHGuideLines().elementAt(i).replace(this.header.getCells()[j], _tbl.header.getCells()[j]);
                }
                for (j = 0; j < this.footer.getCells().length; ++j) {
                    if (_tbl.footer.getCells()[j] == _report.getHGuideLines().elementAt(i)) {
                        this.footer.setData(report.getHGuideLines().elementAt(i), j);
                        continue;
                    }
                    report.getHGuideLines().elementAt(i).replace(this.footer.getCells()[j], _tbl.footer.getCells()[j]);
                }
            }
        }
        if (report.getVGuideLines() != null) {
            for (i = 0; i < report.getVGuideLines().size(); ++i) {
                for (j = 0; j < this.getColumnCount(); ++j) {
                    report.getVGuideLines().elementAt(i).replace(this.getColumn(j), _tbl.getColumn(j));
                }
                for (j = 0; j < this.header.getCells().length; ++j) {
                    report.getVGuideLines().elementAt(i).replace(this.header.getCells()[j], _tbl.header.getCells()[j]);
                }
                for (j = 0; j < this.footer.getCells().length; ++j) {
                    report.getVGuideLines().elementAt(i).replace(this.footer.getCells()[j], _tbl.footer.getCells()[j]);
                }
            }
        }
    }

    public void applyTemplate(ReportTable _tbl) {
        super.applyTemplate(_tbl);
        this.locale = _tbl.locale;
        this.timeZone = _tbl.timeZone;
        this.header.applyTemplate(_tbl.getHeader());
        this.footer.applyTemplate(_tbl.getFooter());
        this.setSectionStyle(_tbl.sectionStyle);
        int len = this.getColumnCount() <= _tbl.getColumnCount() ? this.getColumnCount() : _tbl.getColumnCount();
        for (int i = 0; i < len; ++i) {
            this.getColumn(i).applyTemplate(_tbl.getColumn(i));
        }
    }

    public void applySecurity(ReportTable _tbl) {
        int len = this.getColumnCount() <= _tbl.getColumnCount() ? this.getColumnCount() : _tbl.getColumnCount();
        for (int i = 0; i < len; ++i) {
            this.getColumn(i).applySecurity(_tbl.getColumn(i));
        }
    }

    public void formatColumn() {
        this.formatColumn(false);
    }

    public void formatColumn(boolean isFixedFieldCrossTab) {
        ReportCell[] cells = ReportTable.formatColumn(this.columns, isFixedFieldCrossTab);
        this.header.setData(cells);
    }

    private static int getColumnIndex(ReportColumn rcol, Vector<ReportColumn> cols) {
        for (int i = 0; i < cols.size(); ++i) {
            if (rcol != cols.elementAt(i)) continue;
            return i;
        }
        return -1;
    }

    static ReportCell[] formatColumn(Vector<ReportColumn> columnsList, boolean isFixedFieldCrossTab) {
        ReportElement[] tmpCols = new ReportColumn[columnsList.size()];
        for (int i = 0; i < tmpCols.length; ++i) {
            tmpCols[i] = columnsList.elementAt(i);
        }
        Vector<ReportElement[]> vecTbl = ReportElement.sortElement(tmpCols);
        double startX = -1.0;
        ReportElement[] columns = vecTbl.elementAt(0);
        ReportCell[] cells = new ReportCell[ReportTable.getVisibleColumnCount(columns)];
        int ct = 0;
        int numberOfInvisibleColumns = 0;
        double invisibleColOffset = 0.0;
        if (columns.length > 0) {
            invisibleColOffset = (double)cells.length * ((ReportColumn)columns[0]).getWidth();
        }
        for (ReportElement column2 : columns) {
            ReportColumn column = (ReportColumn)column2;
            if (column.isVisible()) {
                column.setX((double)ct * column.getWidth());
                String str = "getHeader(COL(" + ReportTable.getColumnIndex(column, columnsList) + "))";
                if (isFixedFieldCrossTab && column instanceof ColumnBreakColumn) {
                    if (startX == -1.0) {
                        startX = column.getX();
                    }
                    cells[ct] = new CBColumnHeader(((ColumnBreakColumn)column).getColBreakValueIndex());
                } else if (isFixedFieldCrossTab && column instanceof CBAggrColumn) {
                    if (startX == -1.0) {
                        startX = column.getX();
                    }
                    cells[ct] = new CBAggrColHeader(((CBAggrColumn)column).getColBreakLevel(), ((CBAggrColumn)column).getColBreakValueIndex());
                } else {
                    cells[ct] = new ColumnHeader();
                }
                Formula form = new Formula(null, str);
                try {
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(str.getBytes("UTF-8"));
                    InputStreamReader inputStreamReader = new InputStreamReader((InputStream)inputStream, "UTF-8");
                    NewFormulaParser parser = new NewFormulaParser(inputStreamReader);
                    form.setFormula(parser.parse(new Vector(), null, null, null));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                cells[ct].setFormulaObj(form);
                cells[ct].setX((double)ct * cells[ct].getWidth());
                ++ct;
                continue;
            }
            column.setX((double)numberOfInvisibleColumns * column.getWidth() + invisibleColOffset);
            ++numberOfInvisibleColumns;
        }
        for (int b = 1; b < vecTbl.size(); ++b) {
            ReportElement[] columns2 = vecTbl.elementAt(b);
            int vColCt = ReportTable.getVisibleColumnCount(columns2);
            int ct2 = 0;
            int ic2 = 0;
            double invisibleColOffset2 = 0.0;
            if (columns2.length > 0) {
                invisibleColOffset2 = (double)vColCt * ((ReportColumn)columns2[0]).getWidth();
            }
            for (ReportElement element : columns2) {
                ReportColumn getColumn = (ReportColumn)element;
                if (getColumn.isVisible()) {
                    getColumn.setX((double)ct2 * getColumn.getWidth() + startX);
                    ++ct2;
                    continue;
                }
                getColumn.setX((double)ic2 * getColumn.getWidth() + invisibleColOffset2 + startX);
                ++ic2;
            }
        }
        return cells;
    }

    static ReportCell[] cloneNewData(ReportCell[] cells) {
        ReportCell[] nCells = new ReportCell[cells.length];
        for (int j = 0; j < cells.length; ++j) {
            nCells[j] = ReportCell.clone(cells[j]);
        }
        return nCells;
    }

    @Override
    public void setID(String newID) {
        ReportElement tmp;
        int i;
        super.setID(newID);
        if (this.header.getID().equals("")) {
            this.header.setID(newID + "_HDR");
        }
        if (this.footer.getID().equals("")) {
            this.footer.setID(newID + "_FTR");
        }
        for (i = 0; i < this.columns.size(); ++i) {
            tmp = this.columns.elementAt(i);
            if (!tmp.getID().equals("")) continue;
            tmp.setID(newID, QbUtil.toArray(this.columns));
        }
        for (i = 0; i < this.charts.size(); ++i) {
            tmp = this.charts.elementAt(i);
            if (!tmp.getID().equals("")) continue;
            tmp.setID(newID, QbUtil.toArray(this.charts));
        }
        for (i = 0; i < this.subReports.size(); ++i) {
            tmp = this.subReports.elementAt(i);
            if (!tmp.getID().equals("")) continue;
            tmp.setID(newID, QbUtil.toArray(this.subReports));
        }
        if (this.formattedRows != null && this.formattedRows.size() > 0) {
            Object[] temp;
            for (Object element : temp = this.formattedRows.values().toArray()) {
                FormattedRow row = (FormattedRow)element;
                Vector<ReportElement> elements = row.getRowElements();
                if (elements == null) continue;
                for (int j = 0; j < elements.size(); ++j) {
                    ReportElement tmp2 = row.getReportElement(j);
                    if (!tmp2.getID().equals("")) continue;
                    tmp2.setID(newID, QbUtil.toArray(row.getRowElements()));
                }
            }
        }
    }

    public boolean customIDExists(String id) {
        int j;
        if (this.header.customIDExists(id)) {
            return true;
        }
        if (this.footer.customIDExists(id)) {
            return true;
        }
        for (j = 0; j < this.getColumns().size(); ++j) {
            if (this.getColumn(j).getCustomID() == null || !this.getColumn(j).getCustomID().equals(id)) continue;
            return true;
        }
        for (j = 0; j < this.charts.size(); ++j) {
            if (this.charts.elementAt(j).getCustomID() == null || !this.charts.elementAt(j).getCustomID().equals(id)) continue;
            return true;
        }
        for (j = 0; j < this.subReports.size(); ++j) {
            if (this.subReports.elementAt(j).getCustomID() == null || !this.subReports.elementAt(j).getCustomID().equals(id)) continue;
            return true;
        }
        for (j = 0; j < this.rtfObjects.size(); ++j) {
            if (this.rtfObjects.elementAt(j).getCustomID() == null || !this.rtfObjects.elementAt(j).getCustomID().equals(id)) continue;
            return true;
        }
        return false;
    }

    public boolean containsZIndex() {
        int j;
        if (this.header.containsZIndex()) {
            return true;
        }
        if (this.footer.containsZIndex()) {
            return true;
        }
        for (j = 0; j < this.getColumns().size(); ++j) {
            if (this.getColumn(j).getZ() <= 0) continue;
            return true;
        }
        for (j = 0; j < this.charts.size(); ++j) {
            if (this.charts.elementAt(j).getZ() <= 0) continue;
            return true;
        }
        for (j = 0; j < this.subReports.size(); ++j) {
            if (this.subReports.elementAt(j).getZ() <= 0) continue;
            return true;
        }
        for (j = 0; j < this.rtfObjects.size(); ++j) {
            if (this.rtfObjects.elementAt(j).getZ() <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean formulaReferenced(Formula formula) {
        if (this.header.formulaReferenced(formula)) {
            return true;
        }
        return this.footer.formulaReferenced(formula);
    }

    @Override
    public boolean scriptReferenced(Script script) {
        return this.scriptReferenced(script, false);
    }

    public boolean scriptReferenced(Script script, boolean checkTableOnly) {
        if (!checkTableOnly && this.header.scriptReferenced(script)) {
            return true;
        }
        if (!checkTableOnly && this.footer.scriptReferenced(script)) {
            return true;
        }
        for (int j = 0; j < this.getColumns().size(); ++j) {
            if (!this.getColumn(j).scriptReferenced(script)) continue;
            return true;
        }
        return this.getScriptObj() == script;
    }

    @Override
    public boolean securityScriptReferenced(Script script) {
        return this.securityScriptReferenced(script, false);
    }

    public boolean securityScriptReferenced(Script script, boolean checkTableOnly) {
        if (!checkTableOnly && this.header.securityScriptReferenced(script)) {
            return true;
        }
        if (!checkTableOnly && this.footer.securityScriptReferenced(script)) {
            return true;
        }
        for (int j = 0; j < this.getColumns().size(); ++j) {
            if (!this.getColumn(j).securityScriptReferenced(script)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void removeScriptReferenced(Script script) {
        this.removeScriptReferenced(script, false);
    }

    public void removeScriptReferenced(Script script, boolean checkTableOnly) {
        if (!checkTableOnly) {
            this.header.removeScriptReferenced(script);
        }
        if (!checkTableOnly) {
            this.footer.removeScriptReferenced(script);
        }
        for (int j = 0; j < this.getColumns().size(); ++j) {
            this.getColumn(j).removeScriptReferenced(script);
        }
        if (this.getScriptObj() == script) {
            this.setScriptObj(null);
            this.setScriptName(null);
            this.setScript(null);
        }
    }

    public void createFormulaObject(Report report) {
        this.header.createFormulaObject(report);
        this.footer.createFormulaObject(report);
    }

    public void createFormulaObjectFromName(Report report) {
        this.header.createFormulaObjectFromName(report);
        this.footer.createFormulaObjectFromName(report);
    }

    @Override
    public void createScriptObject(Vector<Script> scripts) {
        this.header.createScriptObject(scripts);
        for (int i = 0; i < this.getColumns().size(); ++i) {
            this.getColumn(i).createScriptObject(scripts);
        }
        this.footer.createScriptObject(scripts);
    }

    @Override
    public void createScriptObjectFromName(Vector<Script> scripts) {
        ReportElement[] elements;
        super.createScriptObjectFromName(scripts);
        this.header.createScriptObjectFromName(scripts);
        this.footer.createScriptObjectFromName(scripts);
        for (ReportElement element : elements = this.getAllTableElements()) {
            element.createScriptObjectFromName(scripts);
        }
    }

    public ReportColumn getColumnByID(String id) {
        for (int i = 0; i < this.columns.size(); ++i) {
            ReportColumn tmp = this.columns.elementAt(i);
            if (!tmp.getID().equals(id)) continue;
            return tmp;
        }
        return null;
    }

    public ReportElement getData(String id) {
        ReportElement tmp;
        int i;
        ReportCell cell = this.header.getData(id);
        if (cell != null) {
            return cell;
        }
        for (i = 0; i < this.columns.size(); ++i) {
            tmp = this.columns.elementAt(i);
            if (tmp.getID().equals(id)) {
                return tmp;
            }
            if (!tmp.getCustomID().equals(id)) continue;
            return tmp;
        }
        for (i = 0; i < this.charts.size(); ++i) {
            tmp = this.charts.elementAt(i);
            if (tmp.getID().equals(id)) {
                return tmp;
            }
            if (!tmp.getCustomID().equals(id)) continue;
            return tmp;
        }
        for (i = 0; i < this.subReports.size(); ++i) {
            tmp = this.subReports.elementAt(i);
            if (tmp.getID().equals(id)) {
                return tmp;
            }
            if (!tmp.getCustomID().equals(id)) continue;
            return tmp;
        }
        if (this.formattedRows != null && this.formattedRows.size() > 0) {
            Object[] temp;
            for (Object element : temp = this.formattedRows.values().toArray()) {
                FormattedRow row = (FormattedRow)element;
                for (int j = 0; j < row.getRowElements().size(); ++j) {
                    ReportElement tmp2 = row.getReportElement(j);
                    if (tmp2.getID().equals(id)) {
                        return tmp2;
                    }
                    if (!tmp2.getCustomID().equals(id)) continue;
                    return tmp2;
                }
            }
        }
        if ((cell = this.footer.getData(id)) != null) {
            return cell;
        }
        return null;
    }

    @Override
    public String[] getSecurityLevels() {
        ReportElement[] elements;
        int i;
        String[] temp;
        Vector<String> levels = new Vector<String>();
        for (String element : temp = super.getSecurityLevels()) {
            levels.addElement(element);
        }
        temp = this.header.getSecurityLevels();
        for (i = 0; i < temp.length; ++i) {
            if (levels.contains(temp[i])) continue;
            levels.addElement(temp[i]);
        }
        temp = this.footer.getSecurityLevels();
        for (i = 0; i < temp.length; ++i) {
            if (levels.contains(temp[i])) continue;
            levels.addElement(temp[i]);
        }
        for (ReportElement element : elements = this.getTableElements()) {
            temp = element.getSecurityLevels();
            for (int j = 0; j < temp.length; ++j) {
                if (levels.contains(temp[j])) continue;
                levels.addElement(temp[j]);
            }
        }
        String[] ls = new String[levels.size()];
        for (int i2 = 0; i2 < ls.length; ++i2) {
            ls[i2] = (String)levels.elementAt(i2);
        }
        return ls;
    }

    @Override
    public String[] getSecuredScripts() {
        ReportElement[] elements;
        int i;
        String[] temp;
        Vector<String> scripts = new Vector<String>();
        for (String element : temp = super.getSecuredScripts()) {
            scripts.addElement(element);
        }
        temp = this.header.getSecuredScripts();
        for (i = 0; i < temp.length; ++i) {
            if (scripts.contains(temp[i])) continue;
            scripts.addElement(temp[i]);
        }
        temp = this.footer.getSecuredScripts();
        for (i = 0; i < temp.length; ++i) {
            if (scripts.contains(temp[i])) continue;
            scripts.addElement(temp[i]);
        }
        for (ReportElement element : elements = this.getTableElements()) {
            temp = element.getSecuredScripts();
            for (int j = 0; j < temp.length; ++j) {
                if (scripts.contains(temp[j])) continue;
                scripts.addElement(temp[j]);
            }
        }
        String[] ls = new String[scripts.size()];
        for (int i2 = 0; i2 < ls.length; ++i2) {
            ls[i2] = (String)scripts.elementAt(i2);
        }
        return ls;
    }

    @Override
    public void setSecurityLevelProperties(String levelName, ReportElement level) {
        ReportElement[] elements;
        super.setSecurityLevelProperties(levelName, level);
        this.header.setSecurityLevelProperties(levelName, level);
        this.footer.setSecurityLevelProperties(levelName, level);
        for (ReportElement element : elements = this.getTableElements()) {
            element.setSecurityLevelProperties(levelName, level);
        }
    }

    public void setReportObjectForSubReports(String filename, ISubReport rptobject) {
        this.header.setReportObjectForSubReports(filename, rptobject);
        this.footer.setReportObjectForSubReports(filename, rptobject);
        for (int i = 0; i < this.subReports.size(); ++i) {
            SubReportObject sr;
            if (this.subReports.elementAt(i) == null || (sr = this.subReports.elementAt(i)).getFileName() == null || !sr.getFileName().equals(filename)) continue;
            sr.setSubReport(rptobject);
        }
    }

    public void updateSubReportFileName(String oldfilename, String newfilename) {
        this.header.updateSubReportFileName(oldfilename, newfilename);
        this.footer.updateSubReportFileName(oldfilename, newfilename);
        for (int i = 0; i < this.subReports.size(); ++i) {
            SubReportObject sr;
            if (this.subReports.elementAt(i) == null || (sr = this.subReports.elementAt(i)).getFileName() == null || !sr.getFileName().equals(oldfilename)) continue;
            sr.setFileName(newfilename);
        }
    }

    public void setHTMLParameters(String dirLocation, String url, String fileName) {
        int i;
        ReportTreeTable sTbl;
        this.header.setHTMLParameters(dirLocation, url, fileName);
        this.footer.setHTMLParameters(dirLocation, url, fileName);
        if (this instanceof ReportTreeTable && (sTbl = (ReportTreeTable)this).countSubTable() > 0) {
            sTbl.getSubTable(0).setHTMLParameters(dirLocation, url, fileName);
        }
        for (i = 0; i < this.charts.size(); ++i) {
            if (!(this.charts.elementAt(i) instanceof ReportChartObject)) continue;
            ReportChartObject cell = (ReportChartObject)this.charts.elementAt(i);
            cell.setHTMLParameters(dirLocation, url, fileName);
        }
        if (this.subReports != null) {
            for (i = 0; i < this.subReports.size(); ++i) {
                this.subReports.elementAt(i).setHTMLParameters(dirLocation, url, fileName);
            }
        }
    }

    public void setChartPath(String path) {
        int i;
        this.header.setChartPath(path);
        this.footer.setChartPath(path);
        for (i = 0; i < this.charts.size(); ++i) {
            String loc;
            if (!(this.charts.elementAt(i) instanceof ReportChartObject)) continue;
            ReportChartObject cell = (ReportChartObject)this.charts.elementAt(i);
            if (Report.applyChartPathToAllCharts && !cell.isReportDataUsed() || (loc = cell.getText()) == null || loc.trim().equals("")) continue;
            loc = loc.replace('\\', '/');
            if (!(path = path.replace('\\', '/')).endsWith("/")) {
                path = path + "/";
            }
            String fileName = QbUtil.getFileName(loc);
            cell.setText(path + fileName);
        }
        if (this.subReports != null) {
            for (i = 0; i < this.subReports.size(); ++i) {
                this.subReports.elementAt(i).setChartPath(path);
            }
        }
    }

    public void setSubReportPath(String path) {
        this.header.setSubReportPath(path);
        this.footer.setSubReportPath(path);
        for (int i = 0; i < this.subReports.size(); ++i) {
            SubReportObject cell;
            String loc;
            if (this.subReports.elementAt(i) == null || (loc = (cell = this.subReports.elementAt(i)).getFileName()) == null || loc.trim().equals("")) continue;
            loc = loc.replace('\\', '/');
            if (!(path = path.replace('\\', '/')).endsWith("/")) {
                path = path + "/";
            }
            String fileName = QbUtil.getFileName(loc);
            cell.setFileName(path + fileName);
        }
    }

    public void setImagePath(String path) {
        int i;
        this.header.setImagePath(path);
        this.footer.setImagePath(path);
        for (i = 0; i < this.charts.size(); ++i) {
            ReportImage cell;
            String loc;
            if (this.charts.elementAt(i) instanceof ReportChartObject || this.charts.elementAt(i) instanceof ReportGrid || this.charts.elementAt(i) instanceof ReportLine || (loc = (cell = (ReportImage)this.charts.elementAt(i)).getImageURL().toString()) == null || loc.trim().equals("")) continue;
            loc = loc.replace('\\', '/');
            if (!(path = path.replace('\\', '/')).endsWith("/")) {
                path = path + "/";
            }
            String fileName = QbUtil.getFileName(loc);
            try {
                if (IOUtil.isURL(path)) {
                    cell.setImageURL(new URL(path + fileName), true);
                    continue;
                }
                cell.setImagePath(path + fileName, true);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (this.subReports != null) {
            for (i = 0; i < this.subReports.size(); ++i) {
                this.subReports.elementAt(i).setImagePath(path);
            }
        }
    }

    public double getMinWidth() {
        double max_x = 0.0;
        double tmp_x = 0.0;
        max_x = this.header.getMinWidth();
        tmp_x = this.getBodyMinWidth();
        if (tmp_x > max_x) {
            max_x = tmp_x;
        }
        if ((tmp_x = this.footer.getMinWidth()) > max_x) {
            max_x = tmp_x;
        }
        return max_x;
    }

    public double getBodyMinWidth() {
        ReportElement tmp;
        int i;
        double max_x = 0.0;
        double tmp_x = 0.0;
        for (i = 0; i < this.columns.size(); ++i) {
            tmp = this.columns.elementAt(i);
            if (!tmp.isVisible() || !((tmp_x = tmp.getWidth() + tmp.getX()) > max_x)) continue;
            max_x = tmp_x;
        }
        for (i = 0; i < this.charts.size(); ++i) {
            tmp = this.charts.elementAt(i);
            if (tmp instanceof GuideLine || !((tmp_x = tmp.getWidth() + tmp.getX()) > max_x)) continue;
            max_x = tmp_x;
        }
        for (i = 0; i < this.subReports.size(); ++i) {
            tmp = this.subReports.elementAt(i);
            tmp_x = tmp.getWidth() + tmp.getX();
            if (!(tmp_x > max_x)) continue;
            max_x = tmp_x;
        }
        return max_x;
    }

    public double getMinHeight() {
        int i;
        double max_y = 0.0;
        double tmp_y = 0.0;
        for (i = 0; i < this.columns.size(); ++i) {
            ReportColumn tmp = this.columns.elementAt(i);
            if (!tmp.isVisible() || !((tmp_y = tmp.getHeight() + tmp.getY()) > max_y)) continue;
            max_y = tmp_y;
        }
        for (i = 0; i < this.charts.size(); ++i) {
            tmp_y = 0.0;
            if (!(this.charts.elementAt(i) instanceof ColumnWrap)) {
                if (this.charts.elementAt(i) instanceof ReportLine) {
                    ReportLine line = (ReportLine)this.charts.elementAt(i);
                    if (line.isVertical()) {
                        tmp_y = line.getHeight() + line.getY();
                    } else {
                        tmp_y = line.getHeight() + line.getY() - 0.02;
                        if (line.getLineStyle() == 2) {
                            tmp_y += 2.0 * (line.getHeight() - 0.02);
                        }
                    }
                } else if (this.charts.elementAt(i) instanceof ReportGrid) {
                    tmp_y = ((ReportGrid)this.charts.elementAt(i)).getHeight() + ((ReportGrid)this.charts.elementAt(i)).getY();
                }
            }
            if (!(tmp_y > max_y)) continue;
            max_y = tmp_y;
        }
        return max_y;
    }

    @Override
    public void resize(double xratio, double yratio) {
        int i;
        this.header.resize(xratio, yratio);
        for (i = 0; i < this.columns.size(); ++i) {
            this.columns.elementAt(i).resize(xratio, yratio);
        }
        for (i = 0; i < this.charts.size(); ++i) {
            this.charts.elementAt(i).resize(xratio, yratio);
        }
        this.footer.resize(xratio, yratio);
    }

    public void setGridLineLink(IReport report) {
        this.header.setGridLineLink(report);
        for (int i = 0; i < this.charts.size(); ++i) {
            ReportGrid grid;
            ReportElement tmp = this.charts.elementAt(i);
            if (tmp instanceof ReportLine) {
                ReportLine line = (ReportLine)tmp;
                if (line.getPreviousID() == null) continue;
                ReportLine line2 = (ReportLine)report.getData(line.getPreviousID());
                line.setPrevious(line2);
                if (line2 == null) continue;
                line2.setNext(line);
                continue;
            }
            if (!(tmp instanceof ReportGrid) || (grid = (ReportGrid)tmp).getPreviousID() == null) continue;
            ReportGrid grid2 = (ReportGrid)report.getData(grid.getPreviousID());
            grid.setPrevious(grid2);
            if (grid2 == null) continue;
            grid2.setNext(grid);
        }
        this.footer.setGridLineLink(report);
    }

    @Override
    public void setWidth(double width) {
        super.setWidth(width);
        this.header.setWidth(width);
        this.footer.setWidth(width);
    }

    public int[] findReportColumnIndex(double cx, double cy, int row) {
        Vector<Integer> index = new Vector<Integer>();
        for (int i = this.getColumnCount() - 1; i >= 0; --i) {
            if (this.getColumn(i).getFormattedCellAtRow(row) == null) {
                if (!this.getColumn(i).contains(cx, cy)) continue;
                index.addElement(i);
                continue;
            }
            if (!this.getColumn(i).getFormattedCellAtRow(row).contains(cx, cy)) continue;
            index.addElement(i);
        }
        if (index.size() == 0) {
            return null;
        }
        int[] indexArray = new int[index.size()];
        for (int i = 0; i < index.size(); ++i) {
            indexArray[i] = Integer.parseInt(((Integer)index.elementAt(i)).toString());
        }
        return indexArray;
    }

    public Hashtable<FormattedRowKey, FormattedRow> getFormattedRows() {
        return this.formattedRows;
    }

    public void setFormattedRows(Hashtable<FormattedRowKey, FormattedRow> formattedRows) {
        this.formattedRows = formattedRows;
    }

    public int getFormattedRowsCount() {
        if (this.formattedRows == null) {
            return 0;
        }
        return this.formattedRows.size();
    }

    public void addFormattedRow(int rowIndex, FormattedRow formattedRow) {
        Vector<ReportElement> elements;
        if (this.formattedRows == null) {
            this.formattedRows = new Hashtable();
        }
        if (!this.getID().equals("") && (elements = formattedRow.getRowElements()) != null && elements.size() > 0) {
            for (int i = 0; i < elements.size(); ++i) {
                ReportElement element = elements.elementAt(i);
                if (!element.getID().equals("")) continue;
                element.setID(this.getID(), QbUtil.toArray(elements));
            }
        }
        this.formattedRows.put(new FormattedRowKey(rowIndex, null), formattedRow);
    }

    public void setFormattedRow(int rowIndex, FormattedRow formattedRow) {
        this.addFormattedRow(rowIndex, formattedRow);
    }

    public void addFormattedRow(int row, Vector<Integer> tree, FormattedRow formattedRow) {
        int[] intArray = null;
        if (tree != null && tree.size() > 0) {
            intArray = QbUtil.convertVectorToIntArray(tree);
        }
        FormattedRowKey key = new FormattedRowKey(row, intArray);
        this.addFormattedRow(key, formattedRow);
    }

    public void addFormattedRow(FormattedRowKey rowKey, FormattedRow formattedRow) {
        if (this.formattedRows == null) {
            this.formattedRows = new Hashtable();
        }
        if (!this.getID().equals("")) {
            Vector<ReportElement> elements = formattedRow.getRowElements();
            for (int i = 0; elements != null && i < elements.size(); ++i) {
                ReportElement element = elements.elementAt(i);
                if (!element.getID().equals("")) continue;
                element.setID(this.getID(), QbUtil.toArray(elements));
            }
        }
        this.formattedRows.put(rowKey, formattedRow);
    }

    public void setFormattedRow(FormattedRowKey rowKey, FormattedRow formattedRow) {
        this.addFormattedRow(rowKey, formattedRow);
    }

    public FormattedRow getFormattedRow(int rowIndex, Vector<Integer> tree) {
        int[] intArray = null;
        if (tree != null && tree.size() > 0) {
            intArray = QbUtil.convertVectorToIntArray(tree);
        }
        FormattedRowKey key = new FormattedRowKey(rowIndex, intArray);
        return this.getFormattedRow(key);
    }

    public FormattedRow getFormattedRow(FormattedRowKey key) {
        if (this.formattedRows != null && this.formattedRows.containsKey(key)) {
            return this.formattedRows.get(key);
        }
        return null;
    }

    public boolean isFormattedRow(int rowIndex) {
        return this.isFormattedRow(new FormattedRowKey(rowIndex, null));
    }

    public boolean isFormattedRow(FormattedRowKey key) {
        if (this.formattedRows != null) {
            return this.formattedRows.containsKey(key);
        }
        return false;
    }

    public void removeFormattedRow(int rowIndex) {
        this.removeFormattedRow(new FormattedRowKey(rowIndex, null));
    }

    public void removeFormattedRow(FormattedRowKey key) {
        if (this.formattedRows != null && this.formattedRows.containsKey(key)) {
            this.formattedRows.remove(key);
        }
    }

    public void removeAllFormattedRows() {
        this.formattedRows = null;
    }

    public int[] findRowElementIndex(double cx, double cy, int rowIndex) {
        if (rowIndex >= 0) {
            FormattedRowKey key = new FormattedRowKey(rowIndex, null);
            return this.findRowElementIndex(cx, cy, key);
        }
        return null;
    }

    public ReportElement getRowElement(int rowIndex, int elementIndex) {
        if (elementIndex < 0 || rowIndex < 0) {
            return null;
        }
        FormattedRowKey key = new FormattedRowKey(rowIndex, null);
        return this.getRowElement(key, elementIndex);
    }

    public int[] findRowElementIndex(double cx, double cy, FormattedRowKey key) {
        FormattedRow row;
        Vector<ReportElement> elements;
        Vector<Integer> index = new Vector<Integer>();
        if (this.formattedRows != null && this.formattedRows.containsKey(key) && (elements = (row = this.getFormattedRow(key)).getRowElements()) != null && elements.size() > 0) {
            for (int i = 0; i < elements.size(); ++i) {
                ReportElement elt = elements.elementAt(i);
                if (!elt.contains(cx, cy)) continue;
                index.addElement(i);
            }
        }
        if (index.size() == 0) {
            return null;
        }
        int[] indexArray = new int[index.size()];
        for (int i = 0; i < index.size(); ++i) {
            indexArray[i] = Integer.parseInt(((Integer)index.elementAt(i)).toString());
        }
        return indexArray;
    }

    public ReportElement getRowElement(FormattedRowKey key, int elementIndex) {
        FormattedRow row;
        Vector<ReportElement> elements;
        if (key == null || elementIndex < 0) {
            return null;
        }
        if (this.formattedRows != null && this.formattedRows.containsKey(key) && (elements = (row = this.getFormattedRow(key)).getRowElements()) != null && elements.size() > 0) {
            return elements.elementAt(elementIndex);
        }
        return null;
    }

    @Deprecated
    public void addReportCellToRow(int rowIndex, ReportCell cell) {
        FormattedRowKey key = new FormattedRowKey(rowIndex, null);
        this.addReportCellToRow(key, cell);
    }

    public void addReportCellToRow(int rowIndex, Vector<Integer> tree, ReportCell cell) {
        int[] intArray = QbUtil.convertVectorToIntArray(tree);
        FormattedRowKey key = new FormattedRowKey(rowIndex, intArray);
        this.addReportCellToRow(key, cell);
    }

    public void addReportCellToRow(int rowIndex, int[] tree, ReportCell cell) {
        FormattedRowKey key = new FormattedRowKey(rowIndex, tree);
        this.addReportCellToRow(key, cell);
    }

    private void addReportCellToRow(FormattedRowKey key, ReportCell cell) {
        FormattedRow row = null;
        if (this.isFormattedRow(key)) {
            row = this.getFormattedRow(key);
            if (row == null) {
                row = new FormattedRow(this.getHeight(), null);
            }
            row.addElement(cell);
        } else {
            row = new FormattedRow(this.getHeight(), null);
            row.addElement(cell);
        }
        this.addFormattedRow(key, row);
    }

    public void setHeightOfRow(int rowIndex, double height) {
        FormattedRowKey key = new FormattedRowKey(rowIndex, null);
        this.setHeightOfRow(key, height);
    }

    public void setHeightOfRow(int rowIndex, Vector<Integer> tree, double height) {
        int[] intArray = QbUtil.convertVectorToIntArray(tree);
        FormattedRowKey key = new FormattedRowKey(rowIndex, intArray);
        this.setHeightOfRow(key, height);
    }

    public void setHeightOfRow(int rowIndex, int[] tree, double height) {
        FormattedRowKey key = new FormattedRowKey(rowIndex, tree);
        this.setHeightOfRow(key, height);
    }

    public void setHeightOfRow(FormattedRowKey key, double height) {
        FormattedRow row = null;
        if (this.isFormattedRow(key)) {
            row = this.getFormattedRow(key);
            if (row == null) {
                row = new FormattedRow(height, null);
            } else {
                row.setRowHeight(height);
            }
        } else {
            row = new FormattedRow(height, null);
        }
        this.addFormattedRow(key, row);
    }

    public ReportImage[] getAllReportImages() {
        Vector images = new Vector();
        QbUtil.addArrayToVector(images, this.getSectionReportImages());
        QbUtil.addArrayToVector(images, this.getImage());
        ReportImage[] tmp = new ReportImage[images.size()];
        for (int i = 0; i < images.size(); ++i) {
            tmp[i] = (ReportImage)images.elementAt(i);
        }
        return tmp;
    }

    protected ReportImage[] getSectionReportImages() {
        Vector images = new Vector();
        QbUtil.addArrayToVector(images, this.header.getReportImages());
        QbUtil.addArrayToVector(images, this.footer.getReportImages());
        return images.toArray(new ReportImage[images.size()]);
    }

    public ReportChartObject[] getAllReportChartObjects() {
        Vector charts = new Vector();
        QbUtil.addArrayToVector(charts, this.getSectionReportChartObjects());
        QbUtil.addArrayToVector(charts, this.getReportChartObjects());
        ReportChartObject[] tmp = new ReportChartObject[charts.size()];
        for (int i = 0; i < charts.size(); ++i) {
            tmp[i] = (ReportChartObject)charts.elementAt(i);
        }
        return tmp;
    }

    public ReportChartObject[] getSectionReportChartObjects() {
        Vector charts = new Vector();
        QbUtil.addArrayToVector(charts, this.header.getReportChartObjects());
        QbUtil.addArrayToVector(charts, this.footer.getReportChartObjects());
        ReportChartObject[] tmp = new ReportChartObject[charts.size()];
        for (int i = 0; i < charts.size(); ++i) {
            tmp[i] = (ReportChartObject)charts.elementAt(i);
        }
        return tmp;
    }

    public ReportChartObject[] getReportChartObjects() {
        Vector<ReportElement> vec = new Vector<ReportElement>();
        for (int i = 0; i < this.charts.size(); ++i) {
            if (!(this.charts.elementAt(i) instanceof ReportChartObject)) continue;
            vec.addElement(this.charts.elementAt(i));
        }
        ReportChartObject[] tmp = new ReportChartObject[vec.size()];
        for (int i = 0; i < vec.size(); ++i) {
            tmp[i] = (ReportChartObject)vec.elementAt(i);
        }
        return tmp;
    }

    public int getImageCount() {
        return this.charts.size();
    }

    public ReportImage getImage(int idx) {
        return (ReportImage)this.charts.elementAt(idx);
    }

    public ReportImage[] getImage() {
        int size = this.getImageCount();
        ReportImage[] temp = new ReportImage[size];
        for (int i = 0; i < size; ++i) {
            temp[i] = (ReportImage)this.charts.elementAt(i);
        }
        return temp;
    }

    public void addImage(ReportImage cht) {
        if (!this.getID().equals("") && cht.getID().equals("")) {
            cht.setID(this.getID(), QbUtil.toArray(this.charts));
        }
        this.charts.addElement(cht);
    }

    public void addImage(int idx, ReportImage cht) {
        if (!this.getID().equals("") && cht.getID().equals("")) {
            cht.setID(this.getID(), QbUtil.toArray(this.charts));
        }
        this.charts.insertElementAt(cht, idx);
    }

    public void removeImage(int idx) {
        this.charts.removeElementAt(idx);
    }

    public int indexOf(ReportImage cht) {
        for (int i = 0; i < this.charts.size(); ++i) {
            if (!this.getImage(i).equals(cht)) continue;
            return i;
        }
        return -1;
    }

    public int update(ReportImage cht) {
        for (int i = 0; i < this.charts.size(); ++i) {
            if (!this.getImage(i).getID().equals(cht.getID())) continue;
            this.charts.setElementAt(cht, i);
            return i;
        }
        return -1;
    }

    public void removeImage(ReportImage cht) {
        int cellIndex = this.indexOf(cht);
        if (cellIndex < 0) {
            return;
        }
        this.removeImage(cellIndex);
    }

    public void removeColumnWrap(ColumnWrap col) {
        this.header.removeData(col);
        this.removeImage(col);
        this.footer.removeData(col);
    }

    public int[] findImageIndex(double cx, double cy) {
        Vector<Integer> index = new Vector<Integer>();
        for (int i = this.getImageCount() - 1; i >= 0; --i) {
            if (!this.getImage(i).contains(cx, cy)) continue;
            index.addElement(i);
        }
        if (index.size() == 0) {
            return null;
        }
        int[] indexArray = new int[index.size()];
        for (int i = 0; i < index.size(); ++i) {
            indexArray[i] = Integer.parseInt(((Integer)index.elementAt(i)).toString());
        }
        return indexArray;
    }

    public ReportImage[] getSortedImages() {
        return (ReportImage[])ReportTable.sortElement(this.getImages(), 1, true);
    }

    private ReportImage[] getImages() {
        ReportImage[] tmp = new ReportImage[this.charts.size()];
        for (int i = 0; i < this.charts.size(); ++i) {
            tmp[i] = (ReportImage)this.charts.elementAt(i);
        }
        return tmp;
    }

    public void addSubReport(SubReportObject sreport) {
        if (!this.getID().equals("") && sreport.getID().equals("")) {
            sreport.setID(this.getID(), QbUtil.toArray(this.subReports));
        }
        this.subReports.addElement(sreport);
    }

    public SubReportObject[] getSortedSubReports() {
        return (SubReportObject[])ReportTable.sortElement(this.getSubReports(), 1, true);
    }

    public void removeAllSubReports() {
        this.subReports.removeAllElements();
    }

    public void removeSubReportsReference() {
        this.subReports = new Vector();
    }

    public int[] findSubReportIndex(double cx, double cy) {
        Vector<Integer> index = new Vector<Integer>();
        for (int i = this.getSubReportCount() - 1; i >= 0; --i) {
            if (!this.getSubReport(i).contains(cx, cy)) continue;
            index.addElement(i);
        }
        if (index.size() == 0) {
            return null;
        }
        int[] indexArray = new int[index.size()];
        for (int i = 0; i < index.size(); ++i) {
            indexArray[i] = Integer.parseInt(((Integer)index.elementAt(i)).toString());
        }
        return indexArray;
    }

    private int indexOfSubReport(SubReportObject cht) {
        for (int i = 0; i < this.subReports.size(); ++i) {
            if (!this.getSubReport(i).equals(cht)) continue;
            return i;
        }
        return -1;
    }

    public void removeSubReport(SubReportObject cht) {
        int cellIndex = this.indexOfSubReport(cht);
        if (cellIndex < 0) {
            return;
        }
        this.removeSubReport(cellIndex);
    }

    public void removeSubReportWithFileName(String filename) {
        if (this.subReports == null) {
            return;
        }
        for (int i = this.subReports.size() - 1; i >= 0; --i) {
            if (!this.subReports.elementAt(i).getFileName().equals(filename)) continue;
            this.subReports.removeElementAt(i);
        }
    }

    public void removeSubReport(int index) {
        this.subReports.removeElementAt(index);
    }

    public SubReportObject getSubReport(int index) {
        if (index < 0 || index >= this.subReports.size()) {
            return null;
        }
        return this.subReports.elementAt(index);
    }

    public int getSubReportCount() {
        return this.subReports.size();
    }

    private SubReportObject[] getSubReports() {
        SubReportObject[] tmp = new SubReportObject[this.subReports.size()];
        for (int i = 0; i < this.subReports.size(); ++i) {
            tmp[i] = this.subReports.elementAt(i);
        }
        return tmp;
    }

    public SubReportObject[] getAllSubReports() {
        Vector sreports = new Vector();
        QbUtil.addArrayToVector(sreports, this.getSectionSubReports());
        QbUtil.addArrayToVector(sreports, this.getSubReports());
        SubReportObject[] tmp = new SubReportObject[sreports.size()];
        for (int i = 0; i < sreports.size(); ++i) {
            tmp[i] = (SubReportObject)sreports.elementAt(i);
        }
        return tmp;
    }

    protected SubReportObject[] getSectionSubReports() {
        Vector sreports = new Vector();
        QbUtil.addArrayToVector(sreports, this.header.getSubReports());
        QbUtil.addArrayToVector(sreports, this.footer.getSubReports());
        SubReportObject[] tmp = new SubReportObject[sreports.size()];
        for (int i = 0; i < sreports.size(); ++i) {
            tmp[i] = (SubReportObject)sreports.elementAt(i);
        }
        return tmp;
    }

    public void renameSubReportFileNames(String[] oldFileNames, String[] newFileNames) {
        if (this.subReports == null || oldFileNames == null || newFileNames == null || oldFileNames.length != newFileNames.length) {
            return;
        }
        for (int i = 0; i < this.subReports.size(); ++i) {
            for (int j = 0; j < oldFileNames.length; ++j) {
                if (!oldFileNames[j].equals(this.subReports.elementAt(i).getFileName())) continue;
                this.subReports.elementAt(i).setFileName(newFileNames[j]);
                this.subReports.elementAt(i).setText(newFileNames[j]);
                j = oldFileNames.length;
            }
        }
    }

    public void setSubReportParameterMap(String filename, String[] paramMap) {
        this.header.setSubReportParameterMap(filename, paramMap);
        this.footer.setSubReportParameterMap(filename, paramMap);
        if (this.subReports == null) {
            return;
        }
        for (int i = this.subReports.size() - 1; i >= 0; --i) {
            if (!this.subReports.elementAt(i).getFileName().equals(filename)) continue;
            this.subReports.elementAt(i).setParameterMap(paramMap);
        }
    }

    public void setChartParameterMap(String filename, String[] paramMap) {
        this.header.setChartParameterMap(filename, paramMap);
        this.footer.setChartParameterMap(filename, paramMap);
        if (this.charts == null) {
            return;
        }
        for (int i = this.charts.size() - 1; i >= 0; --i) {
            if (!(this.charts.elementAt(i) instanceof ReportChartObject) || ((ReportChartObject)this.charts.elementAt(i)).getText() == null || !((ReportChartObject)this.charts.elementAt(i)).getText().equalsIgnoreCase(filename)) continue;
            ((ReportChartObject)this.charts.elementAt(i)).setParameterMap(paramMap);
        }
    }

    public void setMasterSection(ReportSection mSection) {
        this.masterSection = mSection;
    }

    public ReportSection getMasterSection() {
        return this.masterSection;
    }

    public ReportSection findMasterSection(double x, double y) {
        if (this.masterSection != null && this.masterSection.isVisible() && this.masterSection.contains(x, y)) {
            return this.masterSection;
        }
        return null;
    }

    public Vector<ReportColumn> getColumns() {
        return this.columns;
    }

    void setColumns(Vector<ReportColumn> newColumns) {
        this.columns = newColumns;
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public boolean isValid() {
        for (int i = 0; i < this.columns.size(); ++i) {
            if (this.getColumn(i).isValid()) continue;
            return false;
        }
        return true;
    }

    public ReportColumn getColumn(int idx) {
        if (idx >= 0 && idx < this.columns.size()) {
            return this.columns.elementAt(idx);
        }
        return null;
    }

    public boolean hasColumn(ReportElement elt) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (this.getColumn(i) != elt) continue;
            return true;
        }
        return false;
    }

    public int getColumnIndex(ReportElement elt) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (!this.getColumn(i).getID().equals(elt.getID())) continue;
            return i;
        }
        return -1;
    }

    public ReportColumn[] getColumn() {
        int size = this.getColumnCount();
        ReportColumn[] temp = new ReportColumn[size];
        for (int i = 0; i < size; ++i) {
            temp[i] = this.columns.elementAt(i);
        }
        return temp;
    }

    public void addColumn(ReportColumn col) {
        if (!this.getID().equals("") && col.getID().equals("")) {
            col.setID(this.getID(), QbUtil.toArray(this.columns));
        }
        this.columns.addElement(col);
    }

    public void addColumn(int idx, ReportColumn col) {
        if (!this.getID().equals("") && col.getID().equals("")) {
            col.setID(this.getID(), QbUtil.toArray(this.columns));
        }
        this.columns.insertElementAt(col, idx);
    }

    public void removeColumn(int idx) {
        this.columns.removeElementAt(idx);
    }

    public boolean[] getVisibleColumns() {
        if (this.getColumnCount() == 0) {
            return null;
        }
        boolean[] visible = new boolean[this.getColumnCount()];
        for (int i = 0; i < this.getColumnCount(); ++i) {
            visible[i] = this.getColumn(i).isVisible();
        }
        return visible;
    }

    public int getVisibleColumnCount() {
        return ReportTable.getVisibleColumnCount(this.columns);
    }

    private static int getVisibleColumnCount(Vector<ReportColumn> columns) {
        int ct = 0;
        for (int i = 0; i < columns.size(); ++i) {
            if (!columns.elementAt(i).isVisible()) continue;
            ++ct;
        }
        return ct;
    }

    private static int getVisibleColumnCount(ReportElement[] columns) {
        int ct = 0;
        for (ReportElement column2 : columns) {
            if (!column2.isVisible()) continue;
            ++ct;
        }
        return ct;
    }

    public ReportColumn[] getInvisibleColumnList() {
        int ct = this.getColumnCount() - this.getVisibleColumnCount();
        ReportColumn[] cols = new ReportColumn[ct];
        int ct2 = 0;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (this.getColumn(i).isVisible()) continue;
            cols[ct2++] = this.getColumn(i);
        }
        return cols;
    }

    public ReportColumn[] getVisibleColumnList() {
        ReportColumn[] cols = new ReportColumn[this.getVisibleColumnCount()];
        int ct2 = 0;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (!this.getColumn(i).isVisible() || ct2 >= cols.length) continue;
            cols[ct2++] = this.getColumn(i);
        }
        return cols;
    }

    public ReportColumn[] getSortedVisibleColumns() {
        if (this.getColumnCount() == 0) {
            return null;
        }
        return (ReportColumn[])ReportTable.sortElement(this.getVisibleColumnList(), 1, true);
    }

    public ReportElement[] getXSortedVisibleElements() {
        if (this.getColumnCount() == 0) {
            return null;
        }
        ReportColumn[] col = this.getVisibleColumnList();
        int length = col.length + this.getImageCount() + this.getSubReportCount() + this.getRTFObjectCount();
        if (this.masterSection != null) {
            ++length;
        }
        ReportElement[] elt = new ReportElement[length];
        for (int i = 0; i < elt.length; ++i) {
            elt[i] = i < col.length ? col[i] : (i < col.length + this.getImageCount() ? this.getImage(i - col.length) : (i < col.length + this.getImageCount() + this.getRTFObjectCount() ? this.getRTFObject(i - col.length - this.getImageCount()) : (i < elt.length - 1 || this.masterSection == null ? this.getSubReport(i - col.length - this.getImageCount() - this.getRTFObjectCount()) : this.masterSection)));
        }
        return ReportTable.sortElement(elt, 1, true);
    }

    public ReportElement[] getYSortedVisibleElements() {
        if (this.getColumnCount() == 0) {
            return null;
        }
        ReportColumn[] col = this.getVisibleColumnList();
        int length = col.length + this.getImageCount() + this.getSubReportCount() + this.getRTFObjectCount();
        if (this.masterSection != null) {
            ++length;
        }
        ReportElement[] elt = new ReportElement[length];
        for (int i = 0; i < elt.length; ++i) {
            elt[i] = i < col.length ? col[i] : (i < col.length + this.getImageCount() ? this.getImage(i - col.length) : (i < col.length + this.getImageCount() + this.getRTFObjectCount() ? this.getRTFObject(i - col.length - this.getImageCount()) : (i < elt.length - 1 || this.masterSection == null ? this.getSubReport(i - col.length - this.getImageCount() - this.getRTFObjectCount()) : this.masterSection)));
        }
        return ReportTable.sortElement(elt, 0, true);
    }

    public ReportElement[] getZSortedVisibleElements() {
        if (this.getColumnCount() == 0) {
            return null;
        }
        ReportColumn[] col = this.getVisibleColumnList();
        int length = col.length + this.getImageCount() + this.getSubReportCount() + this.getRTFObjectCount();
        if (this.masterSection != null) {
            ++length;
        }
        ReportElement[] elt = new ReportElement[length];
        for (int i = 0; i < elt.length; ++i) {
            elt[i] = i < col.length ? col[i] : (i < col.length + this.getImageCount() ? this.getImage(i - col.length) : (i < col.length + this.getImageCount() + this.getRTFObjectCount() ? this.getRTFObject(i - col.length - this.getImageCount()) : (i < elt.length - 1 || this.masterSection == null ? this.getSubReport(i - col.length - this.getImageCount() - this.getRTFObjectCount()) : this.masterSection)));
        }
        return ReportTable.sortElement(elt, 2, true);
    }

    @Override
    public Vector<Color> getAllColors(Vector<Color> colors) {
        colors = super.getAllColors(colors);
        ReportElement[] elts = this.getTableElementsNoGL();
        colors = this.header.getAllColors(colors);
        colors = this.footer.getAllColors(colors);
        for (ReportElement elt : elts) {
            colors = elt.getAllColors(colors);
        }
        return colors;
    }

    public ReportElement[] getTableElementsNoGL() {
        ReportElement[] old = this.getTableElements();
        Vector<ReportElement> vec = new Vector<ReportElement>();
        for (int i = 0; i < old.length; ++i) {
            if (old[i] instanceof GuideLine) continue;
            vec.addElement(old[i]);
        }
        ReportElement[] elts = new ReportElement[vec.size()];
        for (int i = 0; i < vec.size(); ++i) {
            elts[i] = (ReportElement)vec.elementAt(i);
        }
        return elts;
    }

    public ReportElement[] getTableElementsNoGLWithSecuredMode() {
        ReportElement[] old = this.getTableElements();
        Vector<ReportElement> vec = new Vector<ReportElement>();
        for (ReportElement element : old) {
            if (element instanceof GuideLine || this.filterElementForSecurity(element) == null) continue;
            vec.addElement(element);
        }
        ReportElement[] elts = new ReportElement[vec.size()];
        for (int i = 0; i < vec.size(); ++i) {
            elts[i] = (ReportElement)vec.elementAt(i);
        }
        return elts;
    }

    public ReportElement[] getAllTableElements() {
        int length = this.getColumnCount() + this.getImageCount() + this.getSubReportCount() + this.getRTFObjectCount();
        if (this.masterSection != null) {
            ++length;
        }
        ReportElement[] elt = new ReportElement[length];
        for (int i = 0; i < elt.length; ++i) {
            elt[i] = i < this.getColumnCount() ? this.getColumn(i) : (i < this.getColumnCount() + this.getImageCount() ? this.getImage(i - this.getColumnCount()) : (i < this.getColumnCount() + this.getImageCount() + this.getRTFObjectCount() ? this.getRTFObject(i - this.getColumnCount() - this.getImageCount()) : (i < elt.length - 1 || this.masterSection == null ? this.getSubReport(i - this.getColumnCount() - this.getImageCount() - this.getRTFObjectCount()) : this.masterSection)));
        }
        return elt;
    }

    public ReportElement[] getTableElements() {
        return this.getTableElements(true);
    }

    public ReportElement[] getTableElements(boolean applyToVisibleColOnly) {
        return this.getTableElements(applyToVisibleColOnly, false);
    }

    public ReportElement[] getTableElements(boolean applyToVisibleColOnly, boolean sortColumns) {
        ReportElement[] col = null;
        if (applyToVisibleColOnly) {
            col = sortColumns ? this.getSortedVisibleColumns() : this.getVisibleColumnList();
        } else {
            col = new ReportColumn[this.columns.size()];
            for (int i = 0; i < col.length; ++i) {
                col[i] = this.getColumn(i);
            }
            col = (ReportColumn[])ReportTable.sortElement(col, 1, true);
        }
        int length = col.length + this.getImageCount() + this.getSubReportCount() + this.getRTFObjectCount();
        if (this.masterSection != null) {
            ++length;
        }
        ReportElement[] elt = new ReportElement[length];
        for (int i = 0; i < elt.length; ++i) {
            elt[i] = i < col.length ? col[i] : (i < col.length + this.getImageCount() ? this.getImage(i - col.length) : (i < col.length + this.getImageCount() + this.getRTFObjectCount() ? this.getRTFObject(i - col.length - this.getImageCount()) : (i < elt.length - 1 || this.masterSection == null ? this.getSubReport(i - col.length - this.getImageCount() - this.getRTFObjectCount()) : this.masterSection)));
        }
        return elt;
    }

    public ReportElement[] getTableElements(int rowId) {
        return this.getTableElements(new FormattedRowKey(rowId, null));
    }

    public ReportElement[] getTableElements(FormattedRowKey key) {
        if (!this.isFormattedRow(key)) {
            return this.getTableElements();
        }
        FormattedRow row = this.getFormattedRow(key);
        Vector<ReportElement> elements = row.getRowElements();
        ReportColumn[] col = this.getVisibleColumnList();
        int length = col.length + elements.size() + this.getImageCount() + this.getSubReportCount() + this.getRTFObjectCount();
        if (this.masterSection != null) {
            ++length;
        }
        ReportElement[] elt = new ReportElement[length];
        for (int i = 0; i < elt.length; ++i) {
            elt[i] = i < col.length ? col[i] : (i < col.length + elements.size() ? elements.elementAt(i - col.length) : (i < col.length + elements.size() + this.getImageCount() ? this.getImage(i - col.length - elements.size()) : (i < col.length + elements.size() + this.getImageCount() + this.getRTFObjectCount() ? this.getRTFObject(i - col.length - elements.size() - this.getImageCount()) : (i < elt.length - 1 || this.masterSection == null ? this.getSubReport(i - col.length - elements.size() - this.getImageCount() - this.getRTFObjectCount()) : this.masterSection))));
        }
        return elt;
    }

    public boolean hasVisibleElements() {
        if (this.getVisibleColumnCount() > 0) {
            return true;
        }
        for (int i = 0; i < this.getImageCount(); ++i) {
            ReportImage img = this.getImage(i);
            if (!(img instanceof ReportLine) && !(img instanceof ReportGrid)) continue;
            return true;
        }
        return false;
    }

    public void setDrillDownData(int columnIndex, Object data) {
        try {
            ReportColumn column = this.getColumn(columnIndex);
            column.setDrillDownData(data);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void shift(ReportElement elt, boolean isHorizontal, double change) {
        ReportElement[] temp = this.getTableElementsNoGLWithSecuredMode();
        ReportElement.shift(elt, temp, isHorizontal, change);
    }

    public void shiftOnMove(ReportElement elt, boolean isHorizontal, double change) {
        ReportElement[] temp = this.getTableElementsNoGLWithSecuredMode();
        ReportElement.shiftOnMove(elt, temp, isHorizontal, change);
    }

    public void resizeForCrossTabFixedField(Vector<ReportElement> resizeItems, double ratioW, double ratioH, double startXD, double startYD) {
        ReportElement[] temp = this.getTableElementsNoGLWithSecuredMode();
        ReportElement.resizeForCrossTabFixedField(resizeItems, temp, ratioW, ratioH, startXD, startYD);
    }

    public void shiftObjectsOnMove(ReportElement elt, boolean isHorizontal, double change) {
        ReportElement[] temp = this.getTableElementsNoGLWithSecuredMode();
        ReportElement.shiftObjectsOnMove(elt, temp, isHorizontal, change);
    }

    public Vector<ReportElement[]> getColumnsForHTML() {
        ReportElement[] elts = new ReportElement[this.columns.size()];
        for (int i = 0; i < this.columns.size(); ++i) {
            elts[i] = this.getColumn(i);
        }
        return ReportTable.sortElement(elts);
    }

    public int getRowCount() {
        if (this.getColumnCount() == 0) {
            return 0;
        }
        return this.getColumn(0).getDataCount();
    }

    public ReportSection getHeader() {
        return this.header;
    }

    public void setHeader(ReportSection header) {
        this.header = header;
    }

    public ReportSection getFooter() {
        return this.footer;
    }

    public void setFooter(ReportSection cells) {
        this.footer = cells;
    }

    public int countRowBreakHeader() {
        return 0;
    }

    public ReportSection getRowBreakHeader(int breakLevel) {
        return null;
    }

    public int countRowBreakFooter() {
        return 0;
    }

    public ReportSection getRowBreakFooter(int breakLevel) {
        return null;
    }

    public int getStartOfColumnBreakColumn() {
        return -1;
    }

    public int getEndOfColumnBreakColumn() {
        return -1;
    }

    public int getColumnBreakColumnCount() {
        return 0;
    }

    @Override
    public void setBorderThickness(int border) {
        super.setBorderThickness(border);
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.getColumn(i).setBorderThickness(border);
        }
    }

    @Override
    @Deprecated
    public void setBorder(int border) {
        this.setBorderThickness(border);
    }

    @Override
    public void setBorderColor(Color color) {
        super.setBorderColor(color);
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.getColumn(i).setBorderColor(color);
        }
    }

    public void formatTable() throws Exception {
    }

    public Object getValue(ReportCell cell, int page, int section, int totalPages, int totalSections, Report r) {
        return this.getValue(cell, page, section, totalPages, totalSections, r, null, null);
    }

    public Object getValue(ReportCell cell, int page, int section, int totalPages, int totalSections, Report r, Vector preAggCol, Vector resultCol) {
        ReportElement securityLevel = cell.getSecurityLevel(r.getPreviewSecurityLevel());
        if (securityLevel != null) {
            ReportCell c = new ReportCell();
            c.copy(securityLevel);
            securityLevel = c;
        }
        cell.switchSecurityProperties(securityLevel);
        try {
            Object dataobj;
            if (cell.getFormulaName() != null || cell.getFormulaObj() != null || cell.getFormula() != null) {
                dataobj = null;
                if (cell.getFormulaObj() == null) {
                    if (cell.getFormulaName() != null) {
                        cell.createFormulaObjectFromName(r);
                    }
                    if (cell.getFormula() != null) {
                        cell.createFormulaObjectFromText(r);
                    }
                }
                if ((dataobj = cell.getFormulaObj().getValue(this, -1, page, section, totalPages, totalSections, r, cell, null, true, preAggCol, resultCol)) instanceof ReportImage) {
                    ReportImage img = new ReportImage();
                    img.copy((ReportImage)dataobj);
                    img.copy(cell);
                    ReportImage reportImage = img;
                    return reportImage;
                }
                Object object = dataobj;
                return object;
            }
            dataobj = cell.getText();
            return dataobj;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(IOUtil.getStackTrace(ex));
        }
        catch (Error err) {
            err.printStackTrace();
            throw new IllegalArgumentException();
        }
        finally {
            cell.switchSecurityProperties(securityLevel);
        }
    }

    public ReportCell formatCell(ReportCell cell, Report r) {
        return this.formatCell(cell, 1, 1, 1, 1, r, false);
    }

    public ReportCell formatCell(ReportCell cell, Report r, boolean designMode) {
        return this.formatCell(cell, 1, 1, 1, 1, r, designMode);
    }

    public ReportCell formatCell(ReportCell cell, int page, int section, int totalPages, int totalSections, Report r) {
        return this.formatCell(cell, page, section, totalPages, totalSections, r, false);
    }

    public ReportCell formatCell(ReportCell cell, int page, int section, int totalPages, int totalSections, Report r, boolean designMode) {
        return this.formatCell(cell, -1, page, section, totalPages, totalSections, r, designMode);
    }

    public ReportCell formatCell(ReportCell cell, int index, int page, int section, int totalPages, int totalSections, Report r, boolean designMode) {
        return this.formatCell(cell, index, page, section, totalPages, totalSections, r, designMode, null, null);
    }

    /*
     * Exception decompiling
     */
    public ReportCell formatCell(ReportCell cell, int index, int page, int section, int totalPages, int totalSections, Report r, boolean designMode, Vector preAggCol, Vector resultCol) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [11[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ReportCell formatCell(ReportColumn col, int idx, Report r) {
        return this.formatCell(col, idx, 1, 1, 1, 1, idx, r, false);
    }

    public ReportCell formatCell(ReportColumn col, int idx, Report r, boolean designMode) {
        return this.formatCell(col, idx, 1, 1, 1, 1, idx, r, designMode);
    }

    public ReportCell formatCell(ReportColumn col, int dataidx, int displayidx, Report r) {
        return this.formatCell(col, dataidx, 1, 1, 1, 1, displayidx, r, false);
    }

    public ReportCell formatCell(ReportColumn col, int dataidx, int displayidx, Report r, boolean designMode) {
        return this.formatCell(col, dataidx, 1, 1, 1, 1, displayidx, r, designMode);
    }

    public ReportCell formatCell(ReportColumn col, int dataidx, int page, int section, int totalPages, int totalSections, Report r) {
        return this.formatCell(col, dataidx, page, section, totalPages, totalSections, dataidx, r, false);
    }

    public ReportCell formatCell(ReportColumn col, int dataidx, int page, int section, int totalPages, int totalSections, Report r, boolean designMode) {
        return this.formatCell(col, dataidx, page, section, totalPages, totalSections, dataidx, r, designMode);
    }

    public ReportCell formatCell(ReportColumn col, int dataidx, int page, int section, int totalPages, int totalSections, int displayidx, Report r) {
        return this.formatCell(col, dataidx, page, section, totalPages, totalSections, displayidx, r, false);
    }

    public ReportCell formatCell(ReportColumn col, int dataidx, int page, int section, int totalPages, int totalSections, int displayidx, Report r, boolean designMode) {
        ReportElement securityLevel = null;
        if (!designMode) {
            securityLevel = col.getSecurityLevel(r.getPreviewSecurityLevel());
            if (securityLevel != null) {
                ReportCell c = new ReportCell();
                c.copy(securityLevel);
                securityLevel = c;
            }
            col.switchSecurityProperties(securityLevel);
        }
        try {
            IFormat cellFormat = col.getDataFormat();
            int colInfoIndex = r.getColInfoIndex(col);
            if (colInfoIndex >= 0 && colInfoIndex < r.colInfo.length) {
                int sqlType = r.getSQLType(colInfoIndex);
                IFormat format = FormatUtil.getDefaultFormat(DataType.mapType(sqlType), this.locale, this.timeZone);
                if (cellFormat == null || !FormatUtil.isFormatAppliabled(cellFormat, format)) {
                    cellFormat = format = FormatUtil.createFormat(DataType.mapType(sqlType), this.locale, this.timeZone);
                    col.setDataFormat(format);
                }
                if (r.colInfo[colInfoIndex].getFormulaObj() != null && !r.colInfo[colInfoIndex].getFormulaObj().calculated) {
                    col.replaceData(r.colInfo[colInfoIndex].getFormulaObj().getValue(this, dataidx, page, section, totalPages, totalSections, r, null, null, true), dataidx);
                }
            }
            ReportElement elt = col.getFormatCell(dataidx, displayidx, this.tableNumber, designMode);
            ReportCell cell = (ReportCell)elt;
            cell.setColumn(col);
            if (designMode || cell.getScriptObj() == null && cell.getScriptName() == null) {
                ReportCell newCell;
                ReportCell reportCell = newCell = ReportCell.clone(cell);
                return reportCell;
            }
            if (col.getScriptObj() == null) {
                for (int j = 0; j < r.scripts.size(); ++j) {
                    Script script = r.scripts.elementAt(j);
                    if (script.getName() == null || !script.getName().equals(col.getScriptName())) continue;
                    col.setScriptObj(script);
                    break;
                }
            }
            Object dataObj = col.getData(dataidx);
            ReportCell newCell = ReportCell.clone(cell);
            try {
                newCell = col.getScriptObj().applyScript(this, dataidx, page, section, totalPages, totalSections, r, cell, dataObj, cell.getDataFormat());
                Object scrVal = newCell.getScriptedValue();
                if (scrVal != null) {
                    if (scrVal.equals("Q#B#S#V#S#T#N")) {
                        scrVal = null;
                    }
                    col.insertScriptedDataAt(scrVal, dataidx);
                    newCell.setText(cellFormat.format(scrVal));
                } else if (col.hasScriptedData(dataidx)) {
                    newCell.setScriptedValue(col.getScriptedData(dataidx));
                    newCell.setText(cellFormat.format(scrVal));
                }
                if (cellFormat instanceof ImageURLFormat) {
                    URL url;
                    ReportImage img;
                    block31: {
                        img = new ReportImage();
                        img.copy(newCell);
                        img.setDataFormat(cellFormat);
                        String path = (String)(scrVal != null ? scrVal.toString() : dataObj);
                        url = null;
                        try {
                            url = new URL(path);
                        }
                        catch (MalformedURLException ex) {
                            if (!ServerMessage.isWebApp) break block31;
                            try {
                                url = new URL(ServerMessage.getServerInfo() + ServerMessage.getContext() + path);
                            }
                            catch (MalformedURLException malformedURLException) {
                                // empty catch block
                            }
                        }
                    }
                    if (url != null) {
                        img.setImageURL(url, false);
                        newCell = img;
                    }
                }
                if (cellFormat instanceof TextURLFormat) {
                    ReportDocument doc = new ReportDocument();
                    doc.copy(newCell);
                    try {
                        doc.setDataFormat(cellFormat);
                        doc.setRelativePath((String)(scrVal != null ? scrVal.toString() : dataObj));
                        doc.setText();
                        newCell = doc;
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (designMode && newCell.getBorderThickness() == 1) {
                newCell.setBorderThickness(newCell.getBorderThickness() + 1);
            }
            ReportCell reportCell = newCell;
            return reportCell;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IllegalArgumentException(IOUtil.getStackTrace(ex));
        }
        catch (Error err) {
            throw new IllegalArgumentException();
        }
        finally {
            col.switchSecurityProperties(securityLevel);
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        this.write(out, false);
    }

    public void write(DataOutput out, boolean pack) throws IOException {
        int i;
        out.writeInt(this.columns.size());
        for (int i2 = 0; i2 < this.columns.size(); ++i2) {
            ReportColumn col = this.getColumn(i2);
            if (col instanceof CBAggrColumn) {
                out.writeInt(18);
                ((CBAggrColumn)this.getColumn(i2)).write(out);
                continue;
            }
            if (col instanceof ColumnBreakColumn) {
                out.writeInt(19);
                ((ColumnBreakColumn)this.getColumn(i2)).write(out);
                continue;
            }
            out.writeInt(17);
            this.getColumn(i2).write(out);
        }
        ReportTable table = this;
        if (this instanceof ReportMultiSectionTable) {
            table = ((ReportMultiSectionTable)this).getFirstTable();
        }
        if (table == null || table.sectionStyle == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            table.sectionStyle.write(out);
        }
        out.writeInt(this.charts.size());
        for (i = 0; i < this.charts.size(); ++i) {
            ReportImage img = this.getImage(i);
            if (img instanceof GuideLine) {
                out.writeInt(9);
                ((GuideLine)img).write(out);
                continue;
            }
            if (img instanceof ReportChartObject) {
                out.writeInt(1);
                ((ReportChartObject)img).write(out, pack);
                continue;
            }
            if (img instanceof ColumnWrap) {
                out.writeInt(4);
                ((ColumnWrap)img).write(out);
                continue;
            }
            if (img instanceof ReportLine) {
                out.writeInt(2);
                ((ReportLine)img).write(out);
                continue;
            }
            if (img instanceof ReportGrid) {
                out.writeInt(3);
                ((ReportGrid)img).write(out);
                continue;
            }
            out.writeInt(0);
            img.write(out, pack);
        }
        out.writeInt(this.subReports.size());
        for (i = 0; i < this.subReports.size(); ++i) {
            this.subReports.elementAt(i).write(out);
        }
        out.writeInt(this.rtfObjects.size());
        for (i = 0; i < this.rtfObjects.size(); ++i) {
            ((ReportRTFObject)this.rtfObjects.elementAt(i)).write(out);
        }
        if (this.masterSection != null) {
            out.writeBoolean(true);
            this.masterSection.write(out, pack);
        } else {
            out.writeBoolean(false);
        }
        out.writeBoolean(false);
        out.writeInt(this.printOnNewPageRowCount);
        this.header.write(out, pack);
        this.footer.write(out, pack);
        super.write(out);
    }

    @Override
    public void writeXML(Writer out, boolean writeElementTag) throws IOException {
        int i;
        if (writeElementTag) {
            out.write("<REPORTTABLE>\n");
        }
        for (i = 0; i < this.columns.size(); ++i) {
            ReportColumn col = this.getColumn(i);
            if (col instanceof ColumnBreakColumn) {
                ((ColumnBreakColumn)col).writeXML(out, true);
                continue;
            }
            if (col instanceof CBAggrColumn) {
                ((CBAggrColumn)col).writeXML(out, true);
                continue;
            }
            col.writeXML(out, true);
        }
        if (this.sectionStyle != null) {
            out.write("<REPORTTABLE_STYLE>\n");
            this.sectionStyle.writeXML(out, true);
            out.write("</REPORTTABLE_STYLE>\n");
        }
        for (i = 0; i < this.charts.size(); ++i) {
            ReportImage img = this.getImage(i);
            if (img instanceof GuideLine) {
                ((GuideLine)img).writeXML(out, true);
                continue;
            }
            if (img instanceof ReportChartObject) {
                ((ReportChartObject)img).writeXML(out, true);
                continue;
            }
            if (img instanceof ColumnWrap) {
                ((ColumnWrap)img).writeXML(out, true);
                continue;
            }
            if (img instanceof ReportLine) {
                ((ReportLine)img).writeXML(out, true);
                continue;
            }
            if (img instanceof ReportGrid) {
                ((ReportGrid)img).writeXML(out, true);
                continue;
            }
            img.writeXML(out, true);
        }
        for (i = 0; i < this.subReports.size(); ++i) {
            this.subReports.elementAt(i).writeXML(out, true);
        }
        for (i = 0; i < this.rtfObjects.size(); ++i) {
            ((ReportRTFObject)this.rtfObjects.elementAt(i)).writeXML(out, true);
        }
        if (this.masterSection != null) {
            this.masterSection.writeXML(out, true);
        }
        out.write("<PRINTONNEWPAGEROWCOUNT>" + this.printOnNewPageRowCount + "</PRINTONNEWPAGEROWCOUNT>\n");
        out.write("<REPORTTABLE_TABLEHEADER>\n");
        this.header.writeXML(out, true);
        out.write("</REPORTTABLE_TABLEHEADER>\n");
        out.write("<REPORTTABLE_TABLEFOOTER>\n");
        this.footer.writeXML(out, true);
        out.write("</REPORTTABLE_TABLEFOOTER>\n");
        super.writeXML(out, false);
        if (writeElementTag) {
            out.write("</REPORTTABLE>\n");
        }
    }

    public static ReportTable createTable(Node node, int version) throws Exception {
        if (!node.getNodeName().equalsIgnoreCase(XMLTAG)) {
            throw new Exception("'REPORTTABLE' element expected, but found '" + node.getNodeName() + "' element.");
        }
        ReportTable tbl = new ReportTable();
        tbl.readXML(node, version);
        return tbl;
    }

    @Override
    public void readXML(Node node, int version) throws Exception {
        boolean check2 = false;
        boolean check1 = false;
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            NodeList nl;
            Node child = nodeList.item(i);
            if (child.getNodeName().equalsIgnoreCase("PRINTONNEWPAGEROWCOUNT")) {
                this.printOnNewPageRowCount = Integer.parseInt(LoadXMLReportHelper.readText(child));
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTTABLE_TABLEHEADER")) {
                nl = child.getChildNodes();
                for (int j = 0; j < nl.getLength(); ++j) {
                    if (!nl.item(j).getNodeName().equalsIgnoreCase("REPORTSECTION")) continue;
                    this.setHeader(ReportSection.createSection(nl.item(j), version));
                    check1 = true;
                    j = nl.getLength();
                }
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTTABLE_TABLEFOOTER")) {
                nl = child.getChildNodes();
                for (int j = 0; j < nl.getLength(); ++j) {
                    if (!nl.item(j).getNodeName().equalsIgnoreCase("REPORTSECTION")) continue;
                    this.setFooter(ReportSection.createSection(nl.item(j), version));
                    check2 = true;
                    j = nl.getLength();
                }
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTTABLE_STYLE")) {
                this.sectionStyle = ReportColumn.createColumn(child.getChildNodes().item(0), version);
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("COLUMNBREAKCOLUMN")) {
                this.addColumn(ColumnBreakColumn.createColumnBreakColumn(child, version));
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("CBAGGRCOLUMN")) {
                this.addColumn(CBAggrColumn.createCBAggrColumn(child, version));
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTCOLUMN")) {
                this.addColumn(ReportColumn.createColumn(child, version));
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTIMAGE")) {
                this.addImage(ReportImage.createImage(child, version));
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTCHARTOBJECT")) {
                this.addImage(ReportChartObject.createChartObject(child, version));
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTLINE")) {
                this.addImage(ReportLine.createLine(child, version));
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("GUIDELINE")) {
                this.addImage(GuideLine.createGuideLine(child, version));
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTGRID")) {
                this.addImage(ReportGrid.createGrid(child, version));
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("COLUMNWRAP")) {
                this.addImage(ColumnWrap.createColumnWrap(child, version));
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("SUBREPORTOBJECT")) {
                this.addSubReport(SubReportObject.createSubReportObject(child, version));
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("RTFOBJECT")) {
                this.addRTFObject(ReportRTFObject.createReportRTFObject(child, version));
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTSECTION")) {
                this.masterSection = ReportSection.createSection(child, version);
                continue;
            }
            if (!child.getNodeName().equalsIgnoreCase("REPORTTABLE_FORMATTEDROWENTRY")) continue;
            NodeList entryList = child.getChildNodes();
            FormattedRowKey key = null;
            FormattedRow row = null;
            for (int j = 0; j < entryList.getLength(); ++j) {
                Node entry = entryList.item(j);
                if (entry.getNodeName().equalsIgnoreCase("FORMATTEDROWKEY")) {
                    key = FormattedRowKey.createFormattedRowKey(entry, version);
                    continue;
                }
                if (!entry.getNodeName().equalsIgnoreCase("FORMATTEDROW")) continue;
                row = FormattedRow.createFormattedRow(entry, version);
            }
            if (this.formattedRows == null) {
                this.formattedRows = new Hashtable();
            }
            if (key == null || row == null) continue;
            this.addFormattedRow(key, row);
        }
        if (!check1 || !check2) {
            throw new Exception("Invalid 'REPORTTABLE' element. Missing 'TABLEHEADER' or 'TABLEFOOTER' elements.");
        }
        super.readXML(node, version);
        this.formattedRows = null;
    }

    public static ReportTable createTable(DataInput in, int version) throws Exception {
        return ReportTable.createTable(in, version, false, false, null, "");
    }

    public static ReportTable createTable(DataInput in, int version, boolean pack, boolean fromReportDesigner, FileInMemTable subFilesTable, String domainPath) throws Exception {
        ReportTable tbl = new ReportTable();
        tbl.read(in, version, pack, fromReportDesigner, subFilesTable, domainPath);
        return tbl;
    }

    @Override
    public void read(DataInput in, int version) throws Exception {
        this.read(in, version, false, false, null, "");
    }

    public void read(DataInput in, int version, boolean pack, boolean fromReportDesigner, FileInMemTable subFilesTable, String domainPath) throws Exception {
        int type;
        int i;
        int len = in.readInt();
        for (i = 0; i < len; ++i) {
            if (version >= 271) {
                type = in.readInt();
                if (type == 18) {
                    this.addColumn(CBAggrColumn.createCBAggrColumn(in, version));
                    continue;
                }
                if (type == 19) {
                    this.addColumn(ColumnBreakColumn.createColumnBreakColumn(in, version));
                    continue;
                }
                this.addColumn(ReportColumn.createColumn(in, version));
                continue;
            }
            this.addColumn(ReportColumn.createColumn(in, version));
        }
        if (version >= 205) {
            if (in.readBoolean()) {
                this.sectionStyle = ReportColumn.createColumn(in, version);
            }
            for (i = 0; i < this.columns.size(); ++i) {
                if (!this.isSectionStyle(this.columns.elementAt(i))) continue;
                this.sectionStyle = this.columns.elementAt(i);
            }
        }
        if (version >= 7) {
            len = in.readInt();
            for (i = 0; i < len; ++i) {
                if (version < 10) {
                    this.addImage(ReportChartObject.createChartObject(in, version, pack, subFilesTable, domainPath));
                    continue;
                }
                if (version >= 10 && version <= 13) {
                    if (in.readInt() == 1) {
                        this.addImage(ReportChartObject.createChartObject(in, version, pack, subFilesTable, domainPath));
                        continue;
                    }
                    this.addImage(ReportImage.createImage(in, version, pack, subFilesTable));
                    continue;
                }
                if (version < 14) continue;
                type = in.readInt();
                if (type == 0) {
                    this.addImage(ReportImage.createImage(in, version, pack, subFilesTable));
                }
                if (type == 1) {
                    this.addImage(ReportChartObject.createChartObject(in, version, pack, subFilesTable, domainPath));
                }
                if (type == 2) {
                    this.addImage(ReportLine.createLine(in, version));
                }
                if (type == 3) {
                    this.addImage(ReportGrid.createGrid(in, version));
                }
                if (type == 4) {
                    this.addImage(ColumnWrap.createColumnWrap(in, version));
                }
                if (type != 9 || (version < 144 || version >= 160) && version < 162) continue;
                this.addImage(GuideLine.createGuideLine(in, version));
            }
        }
        if (version > 22) {
            len = in.readInt();
            for (i = 0; i < len; ++i) {
                this.addSubReport(SubReportObject.createSubReportObject(in, version, pack, fromReportDesigner, subFilesTable, false, domainPath, true));
            }
        }
        if (version > 48) {
            len = in.readInt();
            for (i = 0; i < len; ++i) {
                this.addRTFObject(ReportRTFObject.createReportRTFObject(in, version));
            }
        }
        if (version >= 28) {
            boolean exists = in.readBoolean();
            if (exists) {
                AbstractReportSectionFactory reportSectionFactory = this.getReportSectionFactory(version, pack, subFilesTable, domainPath);
                this.masterSection = reportSectionFactory.createSection(in, fromReportDesigner);
            } else {
                this.masterSection = null;
            }
        }
        if (version >= 37) {
            boolean hasFormattedRows = in.readBoolean();
            if (hasFormattedRows) {
                int count = in.readInt();
                if (this.formattedRows == null && count > 0) {
                    this.formattedRows = new Hashtable();
                }
                for (int i2 = 0; i2 < count; ++i2) {
                    FormattedRowKey key = FormattedRowKey.createFormattedRowKey(in, version);
                    FormattedRow row = FormattedRow.createFormattedRow(in, version);
                    this.addFormattedRow(key, row);
                }
            } else {
                this.formattedRows = null;
            }
        }
        if (version >= 283) {
            this.printOnNewPageRowCount = in.readInt();
        }
        this.createHeaderAndFooter(in, version, pack, fromReportDesigner, subFilesTable, domainPath);
        super.read(in, version);
        this.formattedRows = null;
    }

    protected void createHeaderAndFooter(DataInput in, int version, boolean pack, boolean fromReportDesigner, FileInMemTable subFilesTable, String domainPath) throws Exception {
        AbstractReportSectionFactory reportSectionFactory = this.getReportSectionFactory(version, pack, subFilesTable, domainPath);
        this.setHeader(reportSectionFactory.createSection(in, fromReportDesigner));
        this.setFooter(reportSectionFactory.createSection(in, fromReportDesigner));
    }

    public void writeSTL(DataOutput out) throws Exception {
        ReportTable table = this;
        if (this instanceof ReportMultiSectionTable) {
            table = ((ReportMultiSectionTable)this).getFirstTable();
        }
        if (table.sectionStyle == null || !table.sectionStyle.isVisible()) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            table.sectionStyle.write(out);
        }
        out.writeInt(table.getColumnCount());
        for (int i = 0; i < table.getColumnCount(); ++i) {
            table.getColumn(i).write(out);
        }
        Vector vec = this.getImagesAndLines();
        out.writeInt(vec.size());
        for (int i = 0; i < vec.size(); ++i) {
            ReportImage img = (ReportImage)vec.elementAt(i);
            if (img instanceof ReportLine) {
                out.writeInt(2);
                ((ReportLine)img).write(out);
                continue;
            }
            if (img instanceof ReportGrid) {
                out.writeInt(3);
                ((ReportGrid)img).write(out);
                continue;
            }
            out.writeInt(0);
            img.write(out);
        }
        this.header.writeSTL(out);
        this.footer.writeSTL(out);
    }

    public void readSTL(DataInput in, int version) throws Exception {
        int i;
        if (in.readBoolean()) {
            this.sectionStyle = ReportColumn.createColumn(in, version);
            this.addColumn(this.sectionStyle);
        }
        int len = in.readInt();
        for (i = 0; i < len; ++i) {
            ReportColumn col = ReportColumn.createColumn(in, version);
            if (this.sectionStyle != null) {
                col.applyStyle(this.sectionStyle);
            }
            this.addColumn(col);
        }
        len = in.readInt();
        for (i = 0; i < len; ++i) {
            int type = in.readInt();
            if (type == 0) {
                this.addImage(ReportImage.createImage(in, version));
            }
            if (type == 2) {
                this.addImage(ReportLine.createLine(in, version));
            }
            if (type != 3) continue;
            this.addImage(ReportGrid.createGrid(in, version));
        }
        ReportSection sect = new ReportSection();
        sect.readSTL(in, version);
        this.setHeader(sect);
        sect = new ReportSection();
        sect.readSTL(in, version);
        this.setFooter(sect);
    }

    private Vector getImagesAndLines() {
        Vector<ReportImage> vec = new Vector<ReportImage>();
        for (int i = 0; i < this.charts.size(); ++i) {
            ReportImage image = (ReportImage)this.charts.elementAt(i);
            if (image instanceof GuideLine || image instanceof ReportChartObject) continue;
            vec.addElement(image);
        }
        return vec;
    }

    public static ReportElement[] findElementstoRight(ReportElement r, ReportTable elt) {
        ReportElement[] rc = elt.getTableElements();
        return ReportElement.findElementsToRight(r, rc);
    }

    public static ReportElement[] findElementstoLeft(ReportElement r, ReportTable elt) {
        ReportElement[] rc = elt.getTableElements();
        return ReportElement.findElementsToLeft(r, rc);
    }

    public static ReportElement[] findElementsAbove(ReportElement r, ReportTable elt) {
        ReportElement[] rc = elt.getTableElements();
        return ReportElement.findElementsAbove(r, rc);
    }

    public static void resizeVerticallyAndShift(ReportElement r, ReportTable elt, double heightChange) {
        ReportElement[] rc = elt.getTableElements();
        ReportElement.resizeVerticallyAndShift(r, rc, heightChange);
    }

    public void createIndexArray(int colIndex, boolean isAsc, Report report, int level) {
        int[] breakColIndex = report.breakColIndex;
        int type = report.getReportType();
        boolean aggCol = report.colInfo[colIndex].isAggregatedColumn();
        if (this instanceof ReportTreeTable) {
            if (breakColIndex[level] == colIndex || aggCol || type == 3 && report.colInfo[colIndex].isMaster() || type == 2 && level == breakColIndex.length - 2) {
                this.indexArray = ((ReportTreeTable)this).sort(colIndex, isAsc);
            } else {
                Vector<ReportTable> subTables = ((ReportTreeTable)this).getSubTable();
                for (int i = 0; i < subTables.size(); ++i) {
                    ReportTable tbl = subTables.elementAt(i);
                    tbl.createIndexArray(colIndex, isAsc, report, level + 1);
                }
            }
        } else {
            this.indexArray = this.columns.elementAt(colIndex).sort(isAsc);
        }
    }

    public void createIndexArray(int[] colIndex, int idx, boolean[] isAsc, Report report, int level) {
        int[] breakColIndex = report.breakColIndex;
        int type = report.getReportType();
        boolean aggCol = report.colInfo[colIndex[idx]].isAggregatedColumn();
        if (this instanceof ReportTreeTable) {
            if (breakColIndex[level] == colIndex[idx] || aggCol || type == 3 && report.colInfo[colIndex[idx]].isMaster() || type == 2 && level == breakColIndex.length - 2) {
                this.indexArray = ((ReportTreeTable)this).sort(colIndex[idx], isAsc[idx]);
                if (idx < colIndex.length - 1) {
                    Vector<ReportTable> subTables = ((ReportTreeTable)this).getSubTable();
                    for (int i = 0; i < subTables.size(); ++i) {
                        ReportTable tbl = subTables.elementAt(i);
                        tbl.createIndexArray(colIndex, idx + 1, isAsc, report, level + 1);
                    }
                }
            } else {
                Vector<ReportTable> subTables = ((ReportTreeTable)this).getSubTable();
                for (int i = 0; i < subTables.size(); ++i) {
                    ReportTable tbl = subTables.elementAt(i);
                    tbl.createIndexArray(colIndex, idx, isAsc, report, level + 1);
                }
            }
        } else {
            int[] idxArray = this.columns.elementAt(colIndex[idx]).sort(isAsc[idx]);
            this.indexTree = new IndexNode(idxArray);
            this.buildIndexTree(colIndex, idx, isAsc, report, this.indexTree);
            this.indexArray = new int[idxArray.length];
            this.index = 0;
            this.buildIndexArrayFromIndexTree(this.indexTree);
        }
    }

    public void buildIndexTree(int[] colIndex, int idx, boolean[] isAsc, Report report, IndexNode indexNode) {
        while (idx < colIndex.length - 1) {
            indexNode.generateChildIndexNode(this.columns.elementAt(colIndex[idx]).getData());
            ++idx;
            for (int i = 0; i < indexNode.getChildren().size(); ++i) {
                IndexNode child = (IndexNode)indexNode.getChildren().elementAt(i);
                ReportColumn column = this.columns.elementAt(colIndex[idx]);
                int[] idxArray = column.sort(isAsc[idx], child.getIndexArray());
                child.setIndexArray(idxArray);
                this.buildIndexTree(colIndex, idx, isAsc, report, child);
            }
        }
    }

    public void buildIndexArrayFromIndexTree(IndexNode indexNode) {
        if (indexNode.getChildren() == null) {
            for (int i = 0; indexNode.getIndexArray() != null && i < indexNode.getIndexArray().length; ++i) {
                if (this.index < this.indexArray.length) {
                    this.indexArray[this.index] = indexNode.getIndexArray()[i];
                }
                ++this.index;
            }
        } else {
            for (int i = 0; i < indexNode.getChildren().size(); ++i) {
                this.buildIndexArrayFromIndexTree((IndexNode)indexNode.getChildren().elementAt(i));
            }
        }
    }

    public void copySortingInfo(ReportTable _tbl, int level, boolean isMasterDetails, Report report) {
        if (_tbl instanceof ReportTreeTable) {
            if (_tbl.indexArray != null) {
                this.indexArray = _tbl.indexArray;
            }
            Vector<ReportTable> _subTables = ((ReportTreeTable)_tbl).getSubTable();
            Vector<ReportTable> subTables = ((ReportTreeTable)this).getSubTable();
            for (int i = 0; i < _subTables.size(); ++i) {
                subTables.elementAt(i).copySortingInfo(_subTables.elementAt(i), level + 1, isMasterDetails, report);
            }
            int idx = 0;
            if (this.indexArray != null) {
                idx = this.indexArray[0];
            }
            ReportTable tbl = subTables.elementAt(idx);
            while (tbl instanceof ReportTreeTable) {
                idx = 0;
                if (tbl.indexArray != null) {
                    idx = tbl.indexArray[0];
                }
                tbl = ((ReportTreeTable)tbl).getSubTable().elementAt(idx);
            }
            ReportTable oldtbl = subTables.elementAt(0);
            while (oldtbl instanceof ReportTreeTable) {
                oldtbl = ((ReportTreeTable)oldtbl).getSubTable().elementAt(0);
            }
            ReportColumn column = tbl.getColumn(report.breakColIndex[level]);
            ReportColumn col = oldtbl.getColumn(report.breakColIndex[level]);
            idx = 0;
            if (tbl.indexArray != null) {
                idx = tbl.indexArray[0];
            }
            Object obj = col.getData(0);
            col.setData(0, "");
            column.setData(idx, obj);
        } else if (_tbl.indexArray != null) {
            this.indexArray = _tbl.indexArray;
            ReportColumn column = this.getColumn(report.breakColIndex[level]);
            Object obj = column.getData(0);
            boolean isRepeatBreakField = false;
            if (report.getReportType() == 1) {
                isRepeatBreakField = report.colInfo[report.breakColIndex[level]].isRepeatBreakField();
            }
            if (!isMasterDetails && !isRepeatBreakField) {
                column.setData(0, "");
            }
            column.setData(this.indexArray[0], obj);
        }
    }

    public void addRTFObject(ReportRTFObject rObj) {
        if (!this.getID().equals("") && rObj.getID().equals("")) {
            rObj.setID(this.getID(), QbUtil.toArray(this.rtfObjects));
        }
        this.rtfObjects.addElement(rObj);
    }

    public ReportRTFObject[] getSortedRTFObjects() {
        return (ReportRTFObject[])ReportTable.sortElement(this.getRTFObjects(), 1, true);
    }

    private int indexOfRTFObject(ReportRTFObject cht) {
        for (int i = 0; i < this.rtfObjects.size(); ++i) {
            if (!this.getRTFObject(i).equals(cht)) continue;
            return i;
        }
        return -1;
    }

    public void removeRTFObject(ReportRTFObject cht) {
        int cellIndex = this.indexOfRTFObject(cht);
        if (cellIndex < 0) {
            return;
        }
        this.removeRTFObject(cellIndex);
    }

    public void removeRTFObject(int index) {
        this.rtfObjects.removeElementAt(index);
    }

    public ReportRTFObject getRTFObject(int index) {
        if (index < 0 || index >= this.rtfObjects.size()) {
            return null;
        }
        return (ReportRTFObject)this.rtfObjects.elementAt(index);
    }

    public int getRTFObjectCount() {
        return this.rtfObjects.size();
    }

    private ReportRTFObject[] getRTFObjects() {
        ReportRTFObject[] tmp = new ReportRTFObject[this.rtfObjects.size()];
        for (int i = 0; i < this.rtfObjects.size(); ++i) {
            tmp[i] = (ReportRTFObject)this.rtfObjects.elementAt(i);
        }
        return tmp;
    }

    public int[] findRTFObjectIndex(double cx, double cy) {
        Vector<Integer> index = new Vector<Integer>();
        for (int i = this.getRTFObjectCount() - 1; i >= 0; --i) {
            if (!this.getRTFObject(i).contains(cx, cy)) continue;
            index.addElement(i);
        }
        if (index.size() == 0) {
            return null;
        }
        int[] indexArray = new int[index.size()];
        for (int i = 0; i < index.size(); ++i) {
            indexArray[i] = Integer.parseInt(((Integer)index.elementAt(i)).toString());
        }
        return indexArray;
    }

    public void setTableNumber(int number) {
        this.tableNumber = number;
    }

    public int getTableNumber() {
        return this.tableNumber;
    }

    public void setSectionStyle(ReportColumn column) {
        this.sectionStyle = column;
    }

    public ReportColumn getSectionStyle() {
        return this.sectionStyle;
    }

    public boolean hasSectionStyle() {
        return this.sectionStyle != null;
    }

    public boolean isSectionStyle(ReportColumn column) {
        return this.sectionStyle != null && this.sectionStyle.getID().equals(column.getID());
    }

    public void recalculateFormulaColumnValue(Report report) {
        for (int j = 0; j < this.getColumnCount(); ++j) {
            for (int i = 0; i < report.colInfo.length; ++i) {
                if (report.colInfo[i].getFormulaObj() == null || report.getColInfoIndex(j) != i) continue;
                this.getColumn(j).recalculateFormulaColumnValue(report, i, this);
            }
        }
    }

    public void adjustColumnXPos(ReportTable _tbl, int separatingIndex, Report report) {
        if (!report.isCrossTabFixedField()) {
            this.adjustColumnXPosOLD(separatingIndex, report);
            return;
        }
        Vector<ReportElement[]> vecTbl = ReportElement.sortElement(this.getColumn(), false);
        Vector<ReportElement[]> _vecTbl = ReportElement.sortElement(_tbl.getColumn(), false);
        for (int b = 0; b < vecTbl.size(); ++b) {
            int k;
            ReportElement[] elts = vecTbl.elementAt(b);
            for (k = 0; k < elts.length && !(elts[k] instanceof ColumnBreakColumn) && !(elts[k] instanceof CBAggrColumn); ++k) {
            }
            if (k >= elts.length) {
                return;
            }
            if (b < _vecTbl.size()) {
                ReportTable.adjustColumnXPosForFixedFieldCrossTab(_vecTbl.elementAt(b), elts, k);
                continue;
            }
            this.adjustColumnXPos(elts);
        }
    }

    private static void adjustColumnXPosForFixedFieldCrossTab(ReportElement[] oCells, ReportElement[] rCells, int stIdx) {
        double offset = 0.0;
        ReportElement curCell = null;
        ReportElement prevCell = null;
        int i = 0;
        for (i = stIdx; i < rCells.length; ++i) {
            curCell = rCells[i];
            if (curCell == null || !curCell.isVisible()) continue;
            if (!(curCell instanceof CBAggrColumn) && !(curCell instanceof ColumnBreakColumn)) break;
            if (prevCell != null) {
                curCell.setX(prevCell.getX() + prevCell.getWidth());
            } else {
                ReportElement tmpCell = ReportTable.getFirstCell(oCells);
                if (tmpCell != null) {
                    curCell.setX(tmpCell.getX());
                } else {
                    System.out.println("ReportSection WARNING: cannot find first cell");
                }
            }
            offset += curCell.getWidth();
            prevCell = curCell;
        }
        for (int j = stIdx; j < oCells.length; ++j) {
            curCell = oCells[j];
            if (curCell == null || !curCell.isVisible()) continue;
            if (curCell instanceof CBAggrColumn || curCell instanceof ColumnBreakColumn) {
                offset -= curCell.getWidth();
                continue;
            }
            if (i < rCells.length) {
                if (prevCell != null && curCell.getX() + offset < prevCell.getX() + prevCell.getWidth()) {
                    offset = offset + (prevCell.getX() + prevCell.getWidth()) - (curCell.getX() + offset);
                }
                rCells[i].setX(curCell.getX() + offset);
            }
            ++i;
        }
    }

    private static ReportElement getFirstCell(ReportElement[] oCells) {
        for (ReportElement oCell : oCells) {
            if (!(oCell instanceof ColumnBreakColumn) && !(oCell instanceof CBAggrColumn)) continue;
            return oCell;
        }
        return null;
    }

    private void adjustColumnXPos(ReportElement[] elts) {
        int j;
        int k;
        for (k = 0; k < elts.length && !(elts[k] instanceof ColumnBreakColumn) && !(elts[k] instanceof CBAggrColumn); ++k) {
        }
        if (k >= elts.length) {
            return;
        }
        ReportElement[] newElts = new ReportElement[elts.length];
        for (int j2 = 0; j2 < k; ++j2) {
            newElts[j2] = elts[j2];
        }
        Vector<ReportElement> regCells = new Vector<ReportElement>();
        int idx = k;
        for (j = k; j < elts.length; ++j) {
            if (elts[j] instanceof ColumnBreakColumn || elts[j] instanceof CBAggrColumn) {
                newElts[idx] = elts[j];
                ++idx;
                continue;
            }
            regCells.addElement(elts[j]);
        }
        for (j = 0; j < regCells.size(); ++j) {
            newElts[idx] = (ReportElement)regCells.elementAt(j);
            ++idx;
        }
        ReportElement column = null;
        ReportElement prevCol = null;
        for (int i = k; i < newElts.length; ++i) {
            column = newElts[i];
            if (column == null || !column.isVisible()) continue;
            if (prevCol != null) {
                column.setX(prevCol.getX() + prevCol.getWidth());
            }
            if (prevCol == null) {
                prevCol = column;
                continue;
            }
            if (!(prevCol.getX() < column.getX())) continue;
            prevCol = column;
        }
    }

    private void adjustColumnXPosOLD(int separatingIndex, Report report) {
        if (separatingIndex < 0) {
            return;
        }
        ReportColumn column = null;
        ReportColumn prevCol = null;
        if (this.getColumnCount() > separatingIndex) {
            for (int i = 0; i < this.getColumnCount(); ++i) {
                column = this.getColumn(i);
                if (column == null || !column.isVisible()) continue;
                if (prevCol != null && i >= separatingIndex && report.colInfo[report.getColInfoIndex(column)].getMapping() > -1) {
                    column.setX(prevCol.getX() + prevCol.getWidth());
                }
                if (prevCol == null) {
                    prevCol = column;
                    continue;
                }
                if (!(prevCol.getX() < column.getX())) continue;
                prevCol = column;
            }
        } else {
            for (int i = 0; i < this.getColumnCount(); ++i) {
                column = this.getColumn(i);
                if (column == null || !column.isVisible()) continue;
                if (prevCol != null && report.colInfo[report.getColInfoIndex(column)].getMapping() > -1) {
                    column.setX(prevCol.getX() + prevCol.getWidth());
                }
                if (prevCol == null) {
                    prevCol = column;
                    continue;
                }
                if (!(prevCol.getX() < column.getX())) continue;
                prevCol = column;
            }
        }
    }

    public void applyGlobalFormatToColumns(ReportColumn[] formats) {
        if (formats == null) {
            return;
        }
        for (int i = 0; i < this.getColumnCount(); ++i) {
            ReportColumn column = this.getColumn(i);
            if (column == null) continue;
            boolean applied = false;
            for (int j = 0; j < formats.length && !applied; ++j) {
                if (FormatUtil.isFormatAppliabled(column.getDataFormat(), formats[j].getDataFormat())) {
                    double x = column.getX();
                    double y = column.getY();
                    boolean visible = column.isVisible();
                    column.applyTemplate(formats[j], true, true, false);
                    column.setVisible(visible);
                    column.setX(x);
                    column.setY(y);
                    applied = true;
                }
                if (j != 0) continue;
                column.setBgColor2(formats[0].getBgColor2());
                column.setAlternateRow(formats[0].getAlternateRow());
            }
        }
    }

    public void deleteChart(int rowIndex, ReportElement chart) {
        if (this.rowsWithMissingChart == null) {
            int row = this.getColumn(0).getDataCount();
            this.rowsWithMissingChart = new boolean[row][this.charts.size()];
        }
        for (int i = 0; i < this.charts.size(); ++i) {
            if (this.charts.elementAt(i) != chart) continue;
            this.rowsWithMissingChart[rowIndex][i] = true;
            break;
        }
    }

    public boolean drawChart(int rowIndex, int chartIndex) {
        if (this.rowsWithMissingChart == null) {
            return true;
        }
        if (rowIndex >= this.rowsWithMissingChart.length || chartIndex >= this.rowsWithMissingChart[0].length) {
            return true;
        }
        return !this.rowsWithMissingChart[rowIndex][chartIndex];
    }

    @Override
    public void setSnapToGrid(boolean snapToGrid, double stepSize, double cmStepSize) {
        int j;
        this.header.setSnapToGrid(snapToGrid, stepSize, cmStepSize);
        this.footer.setSnapToGrid(snapToGrid, stepSize, cmStepSize);
        if (this.masterSection != null) {
            this.masterSection.setSnapToGrid(snapToGrid, stepSize, cmStepSize);
        }
        for (j = 0; j < this.getColumns().size(); ++j) {
            this.getColumn(j).setSnapToGrid(snapToGrid, stepSize, cmStepSize);
        }
        for (j = 0; j < this.getImageCount(); ++j) {
            this.getImage(j).setSnapToGrid(snapToGrid, stepSize, cmStepSize);
        }
        for (j = 0; j < this.subReports.size(); ++j) {
            this.subReports.elementAt(j).setSnapToGrid(snapToGrid, stepSize, cmStepSize);
        }
        for (j = 0; j < this.rtfObjects.size(); ++j) {
            ((ReportRTFObject)this.rtfObjects.elementAt(j)).setSnapToGrid(snapToGrid, stepSize, cmStepSize);
        }
    }

    @Override
    public void setSnapToGrid(boolean snapToGrid, boolean metric, double stepSize) {
        int j;
        this.header.setSnapToGrid(snapToGrid, metric, stepSize);
        this.footer.setSnapToGrid(snapToGrid, metric, stepSize);
        if (this.masterSection != null) {
            this.masterSection.setSnapToGrid(snapToGrid, metric, stepSize);
        }
        for (j = 0; j < this.getColumns().size(); ++j) {
            this.getColumn(j).setSnapToGrid(snapToGrid, metric, stepSize);
        }
        for (j = 0; j < this.getImageCount(); ++j) {
            this.getImage(j).setSnapToGrid(snapToGrid, metric, stepSize);
        }
        for (j = 0; j < this.subReports.size(); ++j) {
            this.subReports.elementAt(j).setSnapToGrid(snapToGrid, metric, stepSize);
        }
        for (j = 0; j < this.rtfObjects.size(); ++j) {
            ((ReportRTFObject)this.rtfObjects.elementAt(j)).setSnapToGrid(snapToGrid, metric, stepSize);
        }
    }

    public Object getAggrValue(String key) {
        if (this.aggrResult == null) {
            return null;
        }
        return this.aggrResult.get(key);
    }

    public void addAggrValue(String key, Object object) {
        if (key != null && (key.startsWith("6 ") || key.startsWith("7 "))) {
            return;
        }
        if (this.aggrResult == null) {
            this.aggrResult = new Hashtable();
        }
        this.aggrResult.put(key, object);
    }

    public boolean hasSubTable(ReportTable table) {
        return this.equals(table);
    }

    public ReportTable getParentTableWithCell(String id, ReportTable table) {
        ReportCell obj = this.header.getData(id);
        if (obj == null) {
            obj = this.footer.getData(id);
        }
        if (obj != null && this.hasSubTable(table)) {
            return this;
        }
        return null;
    }

    public ReportTable getParentTable(ReportTable table) {
        if (this.hasSubTable(table)) {
            return this;
        }
        return null;
    }

    public int getColumnIndex(ReportColumn rpc) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (!this.getColumn(i).getID().equals(rpc.getID())) continue;
            return i;
        }
        return -1;
    }

    private Vector<ReportElement[]> getReportCellForHTML(ReportCell[] areportcell) {
        Vector<ReportElement[]> vector = new Vector<ReportElement[]>();
        areportcell = (ReportCell[])ReportTable.sortElement(areportcell, 0, true);
        int i = 0;
        int j = 0;
        while (j < areportcell.length) {
            double d = this.getHeight(areportcell[i]) + areportcell[i].getY();
            for (int k = i; k < areportcell.length && !(areportcell[k].getY() >= d); ++k) {
                ++j;
            }
            if (j > i) {
                ReportElement[] areportcell1 = new ReportCell[j - i];
                for (int l = 0; l < areportcell1.length; ++l) {
                    areportcell1[l] = areportcell[i + l];
                }
                vector.addElement(ReportTable.sortElement(areportcell1, 1, true));
            }
            i = j;
        }
        return vector;
    }

    public Vector<ReportElement[]> getSubReportForHTML() {
        ReportCell[] obj = new SubReportObject[this.subReports.size()];
        for (int i = 0; i < obj.length; ++i) {
            obj[i] = this.subReports.elementAt(i);
        }
        return this.getReportCellForHTML(obj);
    }

    private double getHeight(ReportCell cell) {
        if (cell.getHeight() >= 0.0) {
            return cell.getHeight();
        }
        return this.getHeight();
    }

    @Override
    public void renameSecurityLevel(String oldName, String newName) {
        ReportElement[] elements;
        super.renameSecurityLevel(oldName, newName);
        this.header.renameSecurityLevel(oldName, newName);
        this.footer.renameSecurityLevel(oldName, newName);
        for (ReportElement element : elements = this.getTableElements()) {
            element.renameSecurityLevel(oldName, newName);
        }
    }

    public Vector getChartsNoGuideLine() {
        if (this.charts == null) {
            return null;
        }
        Vector<ReportElement> temp = new Vector<ReportElement>();
        for (int i = 0; i < this.charts.size(); ++i) {
            if (this.charts.elementAt(i) instanceof GuideLine) continue;
            this.charts.elementAt(i).setSnap((short)0);
            this.charts.elementAt(i).setVSnap((short)0);
            temp.addElement(this.charts.elementAt(i));
        }
        return temp;
    }

    public boolean hasResizeToFitElement() {
        ReportElement[] cols = this.getColumn();
        if (this.hasResizeToFitElement(cols)) {
            return true;
        }
        if (this.hasResizeToFitElement(this.getHeader().getData())) {
            return true;
        }
        if (this.hasResizeToFitElement(this.getFooter().getData())) {
            return true;
        }
        return this.isResizeToFitContent();
    }

    boolean hasResizeToFitElement(ReportElement[] elts) {
        if (elts == null) {
            return false;
        }
        for (ReportElement elt : elts) {
            if (!elt.isResizeToFitContent()) continue;
            return true;
        }
        return false;
    }

    public boolean hasDualColorOnColumnChange() {
        ReportColumn[] c;
        for (ReportColumn element : c = this.getColumn()) {
            int[] colIndex = element.getDualColorColInfoIndex();
            if (colIndex == null || colIndex.length == 0) continue;
            return true;
        }
        return false;
    }

    public void setLocale(Locale l) {
        this.header.setLocale(l);
        for (int j = 0; j < this.getColumnCount(); ++j) {
            FormatUtil.setLocale(this.getColumn(j).getDataFormat(), l);
        }
        this.footer.setLocale(l);
    }

    public Object getFirstColumnValue(int index) {
        int i = 0;
        if (this.indexArray != null) {
            i = this.indexArray[0];
        }
        return this.getColumn(index).getData(i);
    }

    public Object getFirstColumnScriptedValue(int index) {
        int i = 0;
        if (this.indexArray != null) {
            i = this.indexArray[0];
        }
        if (this.getColumn(index).hasScriptedData(i)) {
            return this.getColumn(index).getScriptedData(i);
        }
        return this.getColumn(index).getData(i);
    }

    public void setPackedSubReportByteArray(FileInMemTable subFilesTable, Vector vec) {
        this.header.setPackedSubReportByteArray(subFilesTable, vec);
        for (int i = 0; this.subReports != null && i < this.subReports.size(); ++i) {
            SubReportObject src = this.subReports.elementAt(i);
            for (int j = 0; j < vec.size(); ++j) {
                if (!src.getFileName().equals(((SubReportObject)vec.elementAt(j)).getFileName(subFilesTable))) continue;
                src.setByteArray(((SubReportObject)vec.elementAt(j)).getByteArray());
            }
        }
        this.footer.setPackedSubReportByteArray(subFilesTable, vec);
    }

    public double getColumnWidths() {
        return (double)ReportElement.findMaxXr(this.getVisibleColumnList()) / (double)QbUtil.toPixel(1.0);
    }

    public void loadStyle(Report report, ReportTable table) {
        this.header.loadStyle(report, table.getHeader());
        this.footer.loadStyle(report, table.getFooter());
        if (table.getSectionStyle() != null) {
            this.sectionStyle = table.getSectionStyle();
            for (int i = 0; i < this.columns.size(); ++i) {
                if (this.isSectionStyle(this.columns.elementAt(i))) {
                    this.columns.setElementAt(this.sectionStyle, i);
                    this.columns.elementAt(i).setVisible(true);
                    continue;
                }
                this.columns.elementAt(i).applyStyle(this.sectionStyle);
            }
        }
        this.charts = table.charts;
    }

    public void applyStyle(ReportTable table) {
        int i;
        this.header.applyStyle(table.getHeader());
        this.footer.applyStyle(table.getFooter());
        if (table.getSectionStyle() != null) {
            for (i = 0; i < this.getColumnCount(); ++i) {
                this.getColumn(i).applyStyle(table.getSectionStyle());
            }
        }
        for (i = 0; i < table.getImageCount(); ++i) {
            if (table.getImage(i) instanceof ReportLine && !((ReportLine)table.getImage(i)).isVertical()) {
                this.charts.addElement(table.getImage(i));
                continue;
            }
            if (table.getImage(i) instanceof ReportGrid) {
                this.charts.addElement(table.getImage(i));
                continue;
            }
            if (table.getImage(i) instanceof ReportChartObject || table.getImage(i) == null) continue;
            this.charts.addElement(table.getImage(i));
        }
    }

    public void applyStyle(Vector setting, ReportTable table) {
        int i;
        int i2;
        this.header.applyStyle(setting, table.getHeader());
        this.footer.applyStyle(setting, table.getFooter());
        for (i2 = 0; i2 < this.getColumnCount(); ++i2) {
            ReportColumn col = this.getColumn(i2);
            int formatType = col.getDataFormat().getFormatType();
            if (formatType == 5 || formatType == 7 || formatType == 8) {
                col.applyStyle((ReportColumn)setting.elementAt(7));
                continue;
            }
            if (formatType == 0) {
                col.applyStyle((ReportColumn)setting.elementAt(8));
                continue;
            }
            if (formatType == 1 || formatType == 2) {
                col.applyStyle((ReportColumn)setting.elementAt(9));
                continue;
            }
            if (formatType == 3 || formatType == 4) {
                col.applyStyle((ReportColumn)setting.elementAt(10));
                continue;
            }
            if (formatType != 6) continue;
            col.applyStyle((ReportColumn)setting.elementAt(11));
        }
        if (table.getSectionStyle() != null) {
            for (i2 = 0; i2 < this.getColumnCount(); ++i2) {
                this.getColumn(i2).applyStyle(table.getSectionStyle());
            }
        }
        ReportColumn[] cols = this.getVisibleColumnList();
        for (i = 0; i < this.getVisibleColumnCount(); ++i) {
            cols[i].setX(cols[i].getWidth() * (double)i);
        }
        for (i = 0; i < table.getImageCount(); ++i) {
            if (table.getImage(i) instanceof ReportLine && !((ReportLine)table.getImage(i)).isVertical()) {
                this.charts.addElement(table.getImage(i));
                continue;
            }
            if (table.getImage(i) instanceof ReportGrid) {
                this.charts.addElement(table.getImage(i));
                continue;
            }
            if (table.getImage(i) instanceof ReportChartObject || table.getImage(i) == null) continue;
            this.charts.addElement(table.getImage(i));
        }
    }

    public boolean contains(ReportElement e) {
        return this.columns.contains(e) || this.charts.contains(e) || this.subReports.contains(e) || this.rtfObjects.contains(e);
    }

    public void deleteSubReportColData() {
        this.header.deleteSubReportColData();
        this.footer.deleteSubReportColData();
        for (int i = 0; i < this.subReports.size(); ++i) {
            if (this.subReports.elementAt(i) == null) continue;
            SubReportObject sr = this.subReports.elementAt(i);
            sr.refreshColData();
        }
    }

    public void setPrintOnNewPageRowCount(int i) {
        this.printOnNewPageRowCount = i;
    }

    public int getPrintOnNewPageRowCount() {
        return this.printOnNewPageRowCount;
    }

    public boolean isPrintOnNewPage(int rowCount) {
        if (!super.isPrintOnNewPage()) {
            return false;
        }
        if (this.printOnNewPageRowCount == 0) {
            return false;
        }
        return rowCount >= this.printOnNewPageRowCount;
    }

    public void cleanup() {
        try {
            this.finalize();
        }
        catch (Throwable ex) {
            throw new IllegalArgumentException(IOUtil.getStackTrace(ex));
        }
    }

    protected void finalize() throws Throwable {
        try {
            for (int i = 0; i < this.getColumnCount(); ++i) {
                if (this.getColumn(i) == null) continue;
                this.getColumn(i).finalize();
            }
        }
        finally {
            super.finalize();
        }
    }

    public void releaseDiskBuffer() {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (this.getColumn(i) == null) continue;
            this.getColumn(i).releaseDiskBuffer();
        }
    }

    public boolean equals(ReportTable reportTable) {
        return this.hashCode == reportTable.hashCode;
    }

    public int hashCode() {
        return this.hashCode;
    }
}

