/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.ReportElements;

import java.awt.Color;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Vector;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.XMLUtil;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.report.LoadXMLReportHelper;
import quadbase.reportdesigner.report.Script;

public abstract class ReportTableElement
extends ReportElement
implements Serializable {
    private String background = "";
    private int cellPadding = 0;
    private int cellSpacing = 0;
    private boolean printOnNewPage;
    private boolean skipFirstValue = false;
    private boolean skipFirstGroupValue = false;
    private boolean hasHTMLTableBorder = false;
    private int htmlTableBorderThickness = 0;
    private Color htmlTableBorderColor = Color.black;
    private boolean designerSecuredMode = false;

    public ReportTableElement() {
    }

    public ReportTableElement(String text) {
        super(text);
    }

    public void copy(ReportTableElement _tbl) {
        super.copy(_tbl);
        this.setBackground(_tbl.getBackground());
        this.setCellPadding(_tbl.getCellPadding());
        this.setCellSpacing(_tbl.getCellSpacing());
        this.setPrintOnNewPage(_tbl.isPrintOnNewPage());
        this.setSkipFirstValue(_tbl.isSkipFirstValue());
        this.setSkipFirstGroupValue(_tbl.isSkipFirstGroupValue());
        this.setVisible(_tbl.isVisible());
        this.setHTMLTableBorder(_tbl.hasHTMLTableBorder());
        this.setHTMLTableBorderThickness(_tbl.getHTMLTableBorderThickness());
        this.setHTMLTableBorderColor(_tbl.getHTMLTableBorderColor());
    }

    public void deepCopy(ReportTableElement _tbl) {
        super.deepCopy(_tbl);
        this.setBackground(_tbl.getBackground());
        this.setCellPadding(_tbl.getCellPadding());
        this.setCellSpacing(_tbl.getCellSpacing());
        this.setPrintOnNewPage(_tbl.isPrintOnNewPage());
        this.setSkipFirstValue(_tbl.isSkipFirstValue());
        this.setSkipFirstGroupValue(_tbl.isSkipFirstGroupValue());
        this.setVisible(_tbl.isVisible());
        this.setHTMLTableBorder(_tbl.hasHTMLTableBorder());
        this.setHTMLTableBorderThickness(_tbl.getHTMLTableBorderThickness());
        this.setHTMLTableBorderColor(_tbl.getHTMLTableBorderColor());
    }

    public void copyTemplate(ReportTableElement _tbl) {
        this.copy(_tbl);
    }

    public void applyTemplate(ReportTableElement _tbl) {
        super.applyTemplate(_tbl);
        this.setBackground(_tbl.getBackground());
        this.setCellPadding(_tbl.getCellPadding());
        this.setCellSpacing(_tbl.getCellSpacing());
        this.setPrintOnNewPage(_tbl.isPrintOnNewPage());
        this.setSkipFirstValue(_tbl.isSkipFirstValue());
        this.setSkipFirstGroupValue(_tbl.isSkipFirstGroupValue());
        this.setVisible(_tbl.isVisible());
        this.setHTMLTableBorder(_tbl.hasHTMLTableBorder());
        this.setHTMLTableBorderThickness(_tbl.getHTMLTableBorderThickness());
        this.setHTMLTableBorderColor(_tbl.getHTMLTableBorderColor());
    }

    public String getBackground() {
        return this.background;
    }

    public void setBackground(String bg) {
        if (bg == null) {
            bg = "";
        }
        this.background = bg;
    }

    public int getCellPadding() {
        return this.cellPadding;
    }

    public void setCellPadding(int newCellPadding) {
        this.cellPadding = newCellPadding;
    }

    public int getCellSpacing() {
        return this.cellSpacing;
    }

    public void setCellSpacing(int newCellSpacing) {
        this.cellSpacing = newCellSpacing;
    }

    public boolean isPrintOnNewPage() {
        return this.printOnNewPage;
    }

    public void setPrintOnNewPage(boolean state) {
        this.printOnNewPage = state;
    }

    public boolean isSkipFirstValue() {
        return this.skipFirstValue;
    }

    public void setSkipFirstValue(boolean state) {
        this.skipFirstValue = state;
        if (this.isSkipFirstGroupValue()) {
            this.skipFirstValue = true;
        }
    }

    public boolean isSkipFirstGroupValue() {
        return this.skipFirstGroupValue;
    }

    public void setSkipFirstGroupValue(boolean state) {
        this.skipFirstGroupValue = state;
        if (state) {
            this.setSkipFirstValue(true);
        }
    }

    public boolean hasHTMLTableBorder() {
        return this.hasHTMLTableBorder;
    }

    public void setHTMLTableBorder(boolean state) {
        this.hasHTMLTableBorder = state;
    }

    public int getHTMLTableBorderThickness() {
        return this.htmlTableBorderThickness;
    }

    public void setHTMLTableBorderThickness(int border) {
        this.htmlTableBorderThickness = border;
    }

    public Color getHTMLTableBorderColor() {
        return this.htmlTableBorderColor == null ? Color.black : this.htmlTableBorderColor;
    }

    public void setHTMLTableBorderColor(Color color) {
        this.htmlTableBorderColor = color;
    }

    public void setHTMLTableBorder(int border, Color color) {
        if (border > 0 && color != null) {
            this.setHTMLTableBorder(true);
            this.setHTMLTableBorderThickness(border);
            this.setHTMLTableBorderColor(color);
        } else {
            this.setHTMLTableBorder(false);
            this.setHTMLTableBorderThickness(0);
            this.setHTMLTableBorderColor(Color.black);
        }
    }

    public ReportCell getHTMLTableBorderObject() {
        if (this.hasHTMLTableBorder()) {
            ReportCell cell = new ReportCell();
            int border = this.getHTMLTableBorderThickness();
            Color color = this.getHTMLTableBorderColor();
            cell.setBorderColor(color);
            cell.setBorderThickness(border);
            if (color == null || border <= 0) {
                return null;
            }
            return cell;
        }
        return null;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        IOUtil.writeStr(out, this.background);
        out.writeInt(this.cellPadding);
        out.writeInt(this.cellSpacing);
        out.writeBoolean(this.isPrintOnNewPage());
        out.writeBoolean(this.isSkipFirstValue());
        out.writeBoolean(this.isSkipFirstGroupValue());
        out.writeBoolean(this.hasHTMLTableBorder);
        if (this.hasHTMLTableBorder()) {
            out.writeInt(this.htmlTableBorderThickness);
            IOUtil.writeColor(out, this.getHTMLTableBorderColor());
        }
    }

    @Override
    public void writeXML(Writer out, boolean writeElementTag) throws IOException {
        if (writeElementTag) {
            out.write("<REPORTTABLEELEMENT>\n");
        }
        super.writeXML(out, false);
        if (this.background != null) {
            out.write("<REPORTTABLEELEMENT_BACKGROUND>" + XMLUtil.encodeCDATA(this.background) + "</REPORTTABLEELEMENT_BACKGROUND>\n");
        }
        out.write("<REPORTTABLEELEMENT_CELLPADDING>" + this.cellPadding + "</REPORTTABLEELEMENT_CELLPADDING>\n");
        out.write("<REPORTTABLEELEMENT_CELLSPACING>" + this.cellSpacing + "</REPORTTABLEELEMENT_CELLSPACING>\n");
        out.write("<REPORTTABLEELEMENT_PRINT_ON_NEW_PAGE>" + this.isPrintOnNewPage() + "</REPORTTABLEELEMENT_PRINT_ON_NEW_PAGE>\n");
        out.write("<REPORTTABLEELEMENT_SKIPFIRSTVALUE>" + this.isSkipFirstValue() + "</REPORTTABLEELEMENT_SKIPFIRSTVALUE>\n");
        out.write("<REPORTTABLEELEMENT_SKIPFIRSTGROUPVALUE>" + this.isSkipFirstGroupValue() + "</REPORTTABLEELEMENT_SKIPFIRSTGROUPVALUE>\n");
        out.write("<REPORTTABLEELEMENT_HASHTMLTABLEBORDER>" + this.hasHTMLTableBorder() + "</REPORTTABLEELEMENT_HASHTMLTABLEBORDER>\n");
        out.write("<REPORTTABLEELEMENT_HTMLTABLEBORDERTHICKNESS>" + this.htmlTableBorderThickness + "</REPORTTABLEELEMENT_HTMLTABLEBORDERTHICKNESS>\n");
        out.write("<REPORTTABLEELEMENT_HTMLTABLEBORDERCOLOR>" + this.getHTMLTableBorderColor().getRGB() + "</REPORTTABLEELEMENT_HTMLTABLEBORDERCOLOR>\n");
        if (writeElementTag) {
            out.write("</REPORTTABLEELEMENT>\n");
        }
    }

    @Override
    public void readXML(Node node, int version) throws Exception {
        super.readXML(node, version);
        boolean check3 = false;
        boolean check2 = false;
        boolean check1 = false;
        boolean check4 = version < 51;
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node child = nodeList.item(i);
            if (child.getNodeName().equalsIgnoreCase("REPORTTABLEELEMENT_BACKGROUND")) {
                this.setBackground(LoadXMLReportHelper.readCDATA(child));
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTTABLEELEMENT_CELLPADDING")) {
                this.setCellPadding(Integer.parseInt(LoadXMLReportHelper.readText(child)));
                check1 = true;
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTTABLEELEMENT_CELLSPACING")) {
                this.setCellSpacing(Integer.parseInt(LoadXMLReportHelper.readText(child)));
                check2 = true;
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTTABLEELEMENT_PRINT_ON_NEW_PAGE")) {
                this.setPrintOnNewPage(LoadXMLReportHelper.parseBoolean(LoadXMLReportHelper.readText(child)));
                check3 = true;
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTTABLEELEMENT_SKIPFIRSTVALUE")) {
                this.setSkipFirstValue(LoadXMLReportHelper.parseBoolean(LoadXMLReportHelper.readText(child)));
                check4 = true;
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTTABLEELEMENT_SKIPFIRSTGROUPVALUE")) {
                this.setSkipFirstGroupValue(LoadXMLReportHelper.parseBoolean(LoadXMLReportHelper.readText(child)));
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTTABLEELEMENT_VISIBLE")) {
                if (version >= 138) continue;
                this.setVisible(LoadXMLReportHelper.parseBoolean(LoadXMLReportHelper.readText(child)));
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTTABLEELEMENT_HASHTMLTABLEBORDER")) {
                this.setHTMLTableBorder(LoadXMLReportHelper.parseBoolean(LoadXMLReportHelper.readText(child)));
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("REPORTTABLEELEMENT_HTMLTABLEBORDERTHICKNESS")) {
                this.setHTMLTableBorderThickness(Integer.parseInt(LoadXMLReportHelper.readText(child)));
                continue;
            }
            if (!child.getNodeName().equalsIgnoreCase("REPORTTABLEELEMENT_HTMLTABLEBORDERCOLOR")) continue;
            this.setHTMLTableBorderColor(new Color(Integer.parseInt(LoadXMLReportHelper.readText(child))));
        }
        if (!(check1 && check2 && check3 && check4)) {
            throw new Exception("Missing 'REPORTTABLEELEMENT' attributes.");
        }
    }

    @Override
    public void read(DataInput in, int version) throws Exception {
        super.read(in, version);
        this.setBackground(IOUtil.readStr(in));
        this.setCellPadding(in.readInt());
        this.setCellSpacing(in.readInt());
        if (version >= 5) {
            this.setPrintOnNewPage(in.readBoolean());
        }
        if (version >= 51) {
            this.setSkipFirstValue(in.readBoolean());
        }
        if (version >= 170) {
            this.setSkipFirstGroupValue(in.readBoolean());
        }
        if (version >= 101 && version < 138) {
            this.setVisible(in.readBoolean());
        }
        if (version >= 139 || version >= 109 && version <= 127) {
            boolean state = in.readBoolean();
            this.setHTMLTableBorder(state);
            if (state) {
                this.setHTMLTableBorderThickness(in.readInt());
                this.setHTMLTableBorderColor(IOUtil.readColor(in));
            }
        }
    }

    @Override
    public void createScriptObjectFromName(Vector<Script> scripts) {
        if (this.getScriptName() != null) {
            for (int i = 0; i < scripts.size(); ++i) {
                Script s = scripts.elementAt(i);
                if (!this.getScriptName().equals(s.getName())) continue;
                this.setScriptObj(s);
                break;
            }
        }
    }

    public void setDesignerSecuredMode(boolean b) {
        this.designerSecuredMode = b;
    }

    protected ReportElement filterElementForSecurity(ReportElement elt) {
        if (this.designerSecuredMode && elt.isSecurityLevelDefined()) {
            return null;
        }
        return elt;
    }
}

