/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.ReportElements;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Writer;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import quadbase.common.util.internal.FontTable;
import quadbase.common.util.internal.QbUtil;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.report.LoadXMLReportHelper;

public class ReportTitle
extends ReportCell {
    public boolean autoResize = false;
    public int position = 0;
    public static final int OFF = 0;
    public static final int LEFT = 1;
    public static final int CENTER = 2;
    public static final int RIGHT = 3;
    static String XMLTAG = "REPORT_TITLE";

    public ReportTitle() {
    }

    public ReportTitle(String text) {
        super(text);
        this.setFont(FontTable.newFont("Dialog", 0, QbUtil.getAdjustedFont(19, true)));
    }

    public void copy(ReportTitle title) {
        super.copy(title);
        this.autoResize = title.autoResize;
        this.position = title.position;
    }

    public void deepCopy(ReportTitle title) {
        super.deepCopy(title);
        this.autoResize = title.autoResize;
        this.position = title.position;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeBoolean(this.autoResize);
        out.writeInt(this.position);
        super.write(out);
    }

    @Override
    public void writeXML(Writer out, boolean writeElementTag) throws IOException {
        if (writeElementTag) {
            out.write("<" + XMLTAG + ">\n");
        }
        out.write("<REPORTTITLE_AUTO_RESIZE>" + this.autoResize + "</REPORTTITLE_AUTO_RESIZE>\n");
        out.write("<REPORTTITLE_POSITION>" + this.position + "</REPORTTITLE_POSITION>\n");
        super.writeXML(out, false);
        if (writeElementTag) {
            out.write("</" + XMLTAG + ">\n");
        }
    }

    @Override
    public void read(DataInput in, int version) throws Exception {
        this.autoResize = in.readBoolean();
        this.position = in.readInt();
        super.read(in, version);
    }

    @Override
    public void readXML(Node node, int version) throws Exception {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node child = nodeList.item(i);
            if (child.getNodeName().equalsIgnoreCase("REPORTTITLE_AUTO_RESIZE")) {
                this.autoResize = LoadXMLReportHelper.parseBoolean(LoadXMLReportHelper.readText(child));
                continue;
            }
            if (!child.getNodeName().equalsIgnoreCase("REPORTTITLE_POSITION")) continue;
            this.position = Integer.parseInt(LoadXMLReportHelper.readText(child));
        }
        super.readXML(node, version);
    }

    public static ReportTitle createReportTitle(Node node, int version) throws Exception {
        if (!node.getNodeName().equalsIgnoreCase(XMLTAG)) {
            throw new Exception("'" + XMLTAG + "' element expected, but found '" + node.getNodeName() + "' element.");
        }
        ReportTitle title = new ReportTitle();
        title.readXML(node, version);
        return title;
    }

    public static ReportTitle createReportTitle(DataInput in, int version) throws Exception {
        ReportTitle title = new ReportTitle();
        title.read(in, version);
        return title;
    }
}

