/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.ReportElements;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import java.util.Vector;
import org.w3c.dom.Node;
import quadbase.common.util.internal.FileInMemTable;
import quadbase.common.util.internal.IDataSet;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.QbUtil;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportColumn;
import quadbase.reportdesigner.ReportElements.ReportImage;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.Script;
import quadbase.reportdesigner.util.internal.BooleanCompare;
import quadbase.reportdesigner.util.internal.DateCompare;
import quadbase.reportdesigner.util.internal.ICompareObject;
import quadbase.reportdesigner.util.internal.NumberCompare;
import quadbase.reportdesigner.util.internal.SortObject;
import quadbase.reportdesigner.util.internal.StringCompare;

public class ReportTreeTable
extends ReportTable
implements Serializable {
    private Vector<ReportTable> subTables = new Vector();
    public static final String XMLTAG = "REPORTTREETABLE";
    private ReportTable firstTable = null;

    public ReportTreeTable() {
    }

    public ReportTreeTable(Locale locale, TimeZone timeZone) {
        super(locale, timeZone);
    }

    public ReportTreeTable(ReportTable _tbl) {
        super(_tbl);
    }

    public ReportTreeTable(ReportTable _tbl, int nCol, Properties treeProp) {
        this(_tbl);
        IDataSet[] dataSetTree = (IDataSet[])treeProp.get("DataSetTreeArray");
        for (int i = 0; i < nCol; ++i) {
            String name;
            String string = name = i < _tbl.getColumnCount() ? _tbl.getColumn(i).getText() : "";
            if (dataSetTree != null && dataSetTree[i] != null) {
                treeProp.put("DataSetTree", dataSetTree[i]);
            }
            this.addColumn(new ReportColumn(name, nCol, true, treeProp));
        }
    }

    @Override
    public void copyTemplate(ReportTable _tbl) {
        super.copyTemplate(_tbl);
        if (_tbl instanceof ReportTreeTable) {
            ReportTreeTable tree = (ReportTreeTable)_tbl;
            int len = this.countSubTable() <= tree.countSubTable() ? this.countSubTable() : tree.countSubTable();
            for (int i = 0; i < len; ++i) {
                this.getSubTable(i).copyTemplate(tree.getSubTable(i));
            }
        }
    }

    @Override
    public void copyTemplate(ReportTable _tbl, boolean applyScript) {
        super.copyTemplate(_tbl, applyScript);
        if (_tbl instanceof ReportTreeTable) {
            ReportTreeTable tree = (ReportTreeTable)_tbl;
            int len = this.countSubTable() <= tree.countSubTable() ? this.countSubTable() : tree.countSubTable();
            for (int i = 0; i < len; ++i) {
                this.getSubTable(i).copyTemplate(tree.getSubTable(i), applyScript);
            }
        }
    }

    @Override
    public void applyTemplate(ReportTable _tbl) {
        super.applyTemplate(_tbl);
        if (_tbl instanceof ReportTreeTable) {
            ReportTreeTable tree = (ReportTreeTable)_tbl;
            int len = this.countSubTable() <= tree.countSubTable() ? this.countSubTable() : tree.countSubTable();
            for (int i = 0; i < len; ++i) {
                this.getSubTable(i).applyTemplate(tree.getSubTable(i));
            }
        }
    }

    public Vector<ReportTable> getSubTable() {
        return this.subTables;
    }

    @Override
    public void applySecurity(ReportTable _tbl) {
        super.applySecurity(_tbl);
    }

    public ReportTable getSubTable(int i) {
        ReportTable _tbl = this.subTables.elementAt(i);
        _tbl.applySecurity(this);
        return _tbl;
    }

    public int countSubTable() {
        return this.subTables.size();
    }

    public void addSubTable(ReportTable table) {
        if (this.subTables.size() > 0) {
            table.removeSubReportsReference();
        }
        this.subTables.addElement(table);
    }

    public ReportTable getAggregationTable() {
        for (int i = 0; i < this.subTables.size(); ++i) {
            if (!this.subTables.elementAt(i).isAggregationTable()) continue;
            return this.subTables.elementAt(i);
        }
        return null;
    }

    @Override
    public int getRowCount() {
        int count = 0;
        for (int i = 0; i < this.countSubTable(); ++i) {
            count += this.getSubTable(i).getRowCount();
        }
        return count;
    }

    public ReportTable getFirstTable() {
        if (this.firstTable != null) {
            return this.firstTable;
        }
        this.firstTable = this;
        while (this.firstTable instanceof ReportTreeTable) {
            if (((ReportTreeTable)this.firstTable).countSubTable() == 0) {
                this.firstTable = null;
                return this.firstTable;
            }
            this.firstTable = ((ReportTreeTable)this.firstTable).getSubTable(0);
        }
        return this.firstTable;
    }

    public void reformat() {
        this.subTables = new Vector();
        this.firstTable = null;
    }

    @Override
    public void write(DataOutput out, boolean pack) throws IOException {
        super.write(out, pack);
        out.writeInt(0);
    }

    @Override
    public void writeXML(Writer out, boolean writeElementTag) throws IOException {
        if (writeElementTag) {
            out.write("<REPORTTREETABLE>\n");
        }
        super.writeXML(out, false);
        if (writeElementTag) {
            out.write("</REPORTTREETABLE>\n");
        }
    }

    public static ReportTreeTable createTreeTable(Node node, int version) throws Exception {
        if (!node.getNodeName().equalsIgnoreCase(XMLTAG)) {
            throw new Exception("'REPORTTREETABLE' element expected, but found '" + node.getNodeName() + "' element.");
        }
        ReportTreeTable tbl = new ReportTreeTable();
        tbl.readXML(node, version);
        return tbl;
    }

    @Override
    public void readXML(Node node, int version) throws Exception {
        super.readXML(node, version);
    }

    public static ReportTreeTable createTreeTable(DataInput in, int version, boolean pack, boolean fromReportDesigner, FileInMemTable subFilesTable, String domainPath) throws Exception {
        ReportTreeTable tbl = new ReportTreeTable();
        tbl.read(in, version, pack, fromReportDesigner, subFilesTable, domainPath);
        return tbl;
    }

    @Override
    public void read(DataInput in, int version, boolean pack, boolean fromReportDesigner, FileInMemTable subFilesTable, String domainPath) throws Exception {
        super.read(in, version, pack, fromReportDesigner, subFilesTable, domainPath);
        int len = in.readInt();
        for (int i = 0; i < len; ++i) {
            if (in.readBoolean()) {
                ReportTreeTable.createTreeTable(in, version, pack, fromReportDesigner, subFilesTable, domainPath);
                continue;
            }
            ReportTable.createTable(in, version, pack, fromReportDesigner, subFilesTable, domainPath);
        }
    }

    @Override
    public void setDrillDownData(int columnIndex, Object data) {
        for (int i = 0; i < this.countSubTable(); ++i) {
            this.getSubTable(i).setDrillDownData(columnIndex, data);
        }
    }

    public int[] sort(int colIndex, boolean isAsc) {
        Vector<ReportTable> subTables = this.getSubTable();
        int len = subTables.size();
        ICompareObject[] objects = new ICompareObject[len];
        for (int i = 0; i < len; ++i) {
            int idx;
            ReportTable tbl = subTables.elementAt(i);
            while (tbl instanceof ReportTreeTable) {
                idx = tbl.indexArray != null ? tbl.indexArray[0] : 0;
                tbl = ((ReportTreeTable)tbl).getSubTable().elementAt(idx);
            }
            idx = tbl.indexArray != null ? tbl.indexArray[0] : 0;
            Object object = tbl.getColumn(colIndex).getData(idx);
            if (object == null || object.toString() != null && object.toString().equals("  Null  ")) {
                objects[i] = new StringCompare(null, i);
                continue;
            }
            if (object instanceof Boolean) {
                objects[i] = new BooleanCompare((Boolean)object, i);
                continue;
            }
            if (object instanceof Number) {
                objects[i] = new NumberCompare((Number)object, i);
                continue;
            }
            if (object instanceof String) {
                objects[i] = new StringCompare((String)object, i);
                continue;
            }
            if (!(object instanceof Date)) continue;
            objects[i] = new DateCompare((Date)object, i);
        }
        int[] indexArray = SortObject.sortIndex(objects, isAsc);
        return indexArray;
    }

    public void setTopNTable(int[] sortedIndex) {
        Vector<ReportTable> newSubTables = new Vector<ReportTable>();
        for (int element : sortedIndex) {
            newSubTables.addElement(this.subTables.elementAt(element));
        }
        this.subTables = newSubTables;
    }

    @Override
    public void recalculateFormulaColumnValue(Report report) {
        for (int i = 0; i < this.getSubTable().size(); ++i) {
            this.getSubTable(i).recalculateFormulaColumnValue(report);
        }
    }

    @Override
    public boolean scriptReferenced(Script script) {
        if (this.header.scriptReferenced(script)) {
            return true;
        }
        if (this.footer.scriptReferenced(script)) {
            return true;
        }
        for (int j = 0; j < this.getSubTable().size(); ++j) {
            ReportTable table = this.getSubTable(j);
            if (!table.scriptReferenced(script)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ReportTable getParentTableWithCell(String id, ReportTable table) {
        ReportCell obj = this.header.getData(id);
        if (obj == null) {
            obj = this.footer.getData(id);
        }
        if (obj != null && this.hasSubTable(table)) {
            return this;
        }
        for (int i = 0; i < this.subTables.size(); ++i) {
            ReportTable tbl = this.subTables.elementAt(i);
            if (tbl.getParentTableWithCell(id, table) == null) continue;
            return tbl.getParentTableWithCell(id, table);
        }
        return null;
    }

    @Override
    public ReportTable getParentTable(ReportTable table) {
        int i;
        for (i = 0; i < this.subTables.size(); ++i) {
            if (this.subTables.elementAt(i) != table) continue;
            return this;
        }
        for (i = 0; i < this.subTables.size(); ++i) {
            ReportTable tbl = this.subTables.elementAt(i);
            ReportTable parent = tbl.getParentTable(table);
            if (parent == null) continue;
            return parent;
        }
        return null;
    }

    @Override
    public boolean hasSubTable(ReportTable table) {
        if (this.equals(table)) {
            return true;
        }
        for (int i = 0; i < this.subTables.size(); ++i) {
            ReportTable tbl = this.subTables.elementAt(i);
            if (!tbl.hasSubTable(table)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getColumnIndex(ReportColumn rpc) {
        if (this.getFirstTable() != null) {
            for (int i = 0; i < this.firstTable.getColumnCount(); ++i) {
                if (!this.firstTable.getColumn(i).getID().equals(rpc.getID())) continue;
                return i;
            }
        }
        return super.getColumnIndex(rpc);
    }

    public void setTableID() {
        for (int i = 0; i < this.getSubTable().size(); ++i) {
            ReportTable table = this.getSubTable().elementAt(i);
            if (!this.getID().equals("") && !this.getID().equals("TBL0")) continue;
            table.setID(this.getID() + "_" + i);
            if (!(table instanceof ReportTreeTable)) continue;
            ((ReportTreeTable)table).setTableID();
        }
    }

    @Override
    public Object getFirstColumnValue(int index) {
        int i = 0;
        if (this.indexArray != null) {
            i = this.indexArray[0];
        }
        return this.getSubTable().elementAt(i).getFirstColumnValue(index);
    }

    @Override
    public Object getFirstColumnScriptedValue(int index) {
        int i = 0;
        if (this.indexArray != null) {
            i = this.indexArray[0];
        }
        return this.getSubTable().elementAt(i).getFirstColumnScriptedValue(index);
    }

    @Override
    public double getColumnWidths() {
        if (this.getSubTable() != null && this.getSubTable().size() > 0) {
            return this.getSubTable().elementAt(0).getColumnWidths();
        }
        return super.getColumnWidths();
    }

    @Override
    public void cleanup() {
        try {
            this.finalize();
        }
        catch (Throwable ex) {
            throw new IllegalArgumentException(IOUtil.getStackTrace(ex));
        }
    }

    @Override
    protected void finalize() throws Throwable {
        try {
            for (int i = 0; i < this.countSubTable(); ++i) {
                ReportTable _tbl = this.subTables.elementAt(i);
                if (_tbl == null) continue;
                if (_tbl instanceof ReportTreeTable) {
                    ((ReportTreeTable)_tbl).finalize();
                    continue;
                }
                _tbl.finalize();
            }
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public void releaseDiskBuffer() {
        for (int i = 0; i < this.countSubTable(); ++i) {
            ReportTable _tbl = this.subTables.elementAt(i);
            if (_tbl == null) continue;
            if (_tbl instanceof ReportTreeTable) {
                ((ReportTreeTable)_tbl).releaseDiskBuffer();
                continue;
            }
            _tbl.releaseDiskBuffer();
        }
    }

    @Override
    protected ReportImage[] getSectionReportImages() {
        Vector images = new Vector();
        QbUtil.addArrayToVector(images, super.getSectionReportImages());
        for (int i = 0; i < this.countSubTable(); ++i) {
            QbUtil.addArrayToVector(images, this.getSubTable(i).getSectionReportImages());
        }
        return images.toArray(new ReportImage[images.size()]);
    }
}

