/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.ReportElements;

import java.applet.Applet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import quadbase.common.client.FileInfo;
import quadbase.common.client.ServerMessage;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryInParam;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.paramquery.QueryMultiValueInParam;
import quadbase.common.paramquery.QueryParser;
import quadbase.common.util.IQueryFileInfo;
import quadbase.common.util.IQueryInParam;
import quadbase.common.util.IQueryMultiValueInParam;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.DeleteFile;
import quadbase.common.util.internal.FileInMemTable;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbDebug;
import quadbase.common.util.internal.QbUtil;
import quadbase.common.util.internal.VersioningDataOutput;
import quadbase.common.util.internal.XMLUtil;
import quadbase.reportdesigner.ReportAPI.QbReport;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.report.ColData;
import quadbase.reportdesigner.report.DBAccess;
import quadbase.reportdesigner.report.Formula;
import quadbase.reportdesigner.report.LoadReport;
import quadbase.reportdesigner.report.LoadXMLReportHelper;
import quadbase.reportdesigner.report.NewFormulaParser;
import quadbase.reportdesigner.report.Parameter;
import quadbase.reportdesigner.report.ReadDataFile;
import quadbase.reportdesigner.report.ReloadReport;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.SaveReport;
import quadbase.reportdesigner.report.WriteDataFile;
import quadbase.reportdesigner.util.IReport;
import quadbase.reportdesigner.util.ISubReport;

public class SubReportObject
extends ReportCell
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger(SubReportObject.class.getName());
    public static final String SUBREPORT_DIR = "SubReport/";
    private String filename = "";
    private String paramShareReportID = "";
    private ISubReport subReport = null;
    private String domainPath = "";
    public static final String XMLTAG = "SUBREPORTOBJECT";
    private boolean useAbsolutePath = false;
    private byte[] subreportData = null;
    private String[] parameterMap = null;
    private Hashtable<Object, Object> reportCache = new Hashtable();
    private Hashtable diskCache = new Hashtable();
    private int CACHE_SIZE = 51;
    private String chartPath = null;
    private String imagePath = null;
    private byte[] bytearray;
    private String saveDir = null;
    private String saveURL = null;
    private boolean resizeWidth = false;
    private Vector<ColData[]> colDataVec = new Vector();
    private Hashtable valueRowMapping = new Hashtable();
    private String customerQuery = null;

    public SubReportObject(String parentFile) {
        this(parentFile, null);
    }

    public SubReportObject(String parentFile, String id) {
        this(parentFile, id, null, null);
    }

    public SubReportObject(String parentFile, String id, String domainPath, FileInMemTable subFilesTable) {
        boolean useXML = false;
        boolean usePAK = false;
        if (parentFile == null) {
            parentFile = "";
        }
        if (domainPath != null) {
            this.domainPath = domainPath;
        }
        String newFile = parentFile;
        newFile = newFile.substring(newFile.lastIndexOf(92) + 1);
        if ((newFile = newFile.substring(newFile.lastIndexOf(47) + 1)).toUpperCase().endsWith(".RPT")) {
            newFile = newFile.substring(0, newFile.length() - 4);
        } else if (newFile.toUpperCase().endsWith(".XML")) {
            newFile = newFile.substring(0, newFile.length() - 4);
            useXML = true;
        } else if (newFile.toUpperCase().endsWith(".PAK")) {
            newFile = newFile.substring(0, newFile.length() - 4);
            usePAK = true;
        }
        newFile = newFile.replace(' ', '_');
        newFile = SUBREPORT_DIR + newFile;
        Applet applet = ServerMessage.getApplet();
        newFile = this.useAbsolutePath ? (ServerMessage.useServer || !ServerMessage.isLoadBalancer || applet == null ? IOUtil.getWorkingDirectory() + File.separator + newFile + "_sub" : IOUtil.getCodeBase(applet) + newFile + "_sub") : newFile + "_sub";
        int ct = 0;
        String tmp = domainPath == null ? newFile : domainPath + newFile;
        String fName = tmp + (usePAK ? ".pak" : (useXML ? ".xml" : ".rpt"));
        if (usePAK && subFilesTable != null) {
            try {
                while (Report.fileExists(subFilesTable, fName)) {
                    fName = tmp + "_" + ct++ + (usePAK ? ".pak" : (useXML ? ".xml" : ".rpt"));
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.FINEST, "SubReport - File in memory exist check - Failed: ", e);
            }
        } else {
            try {
                while (new FileInfo(fName).exists()) {
                    fName = tmp + "_" + ct++ + (usePAK ? ".pak" : (useXML ? ".xml" : ".rpt"));
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.FINEST, "SubReport - File exist check - Failed: ", e);
            }
        }
        this.filename = fName;
        this.paramShareReportID = id == null ? this.filename + System.currentTimeMillis() : id;
        this.setText(this.getFileName());
        this.setResizeToFitContent(true);
        this.setResizeWidth(true);
    }

    public SubReportObject() {
    }

    public void copy(SubReportObject _cell) {
        super.copy(_cell);
        this.filename = _cell.filename;
        this.domainPath = _cell.domainPath;
        this.paramShareReportID = _cell.getParamShareReportID();
        this.setByteArray(_cell.getByteArray());
        if (_cell.subReport != null) {
            try {
                Class<?> subReportClass = Class.forName("quadbase.reportdesigner.ReportAPI.SubReport");
                Constructor<?> subReportConstructor = subReportClass.getConstructor(Class.forName("quadbase.reportdesigner.report.Report"));
                this.subReport = (ISubReport)subReportConstructor.newInstance(_cell.subReport.getReportInfo());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setParameterMap(_cell.getParameterMap());
        this.CACHE_SIZE = _cell.CACHE_SIZE;
        this.reportCache = _cell.reportCache;
        this.diskCache = _cell.diskCache;
        this.colDataVec = _cell.colDataVec;
        this.valueRowMapping = _cell.valueRowMapping;
        this.customerQuery = _cell.customerQuery;
        this.chartPath = _cell.chartPath;
        this.imagePath = _cell.imagePath;
        this.setResizeWidth(_cell.isResizeWidth());
    }

    public void deepCopy(SubReportObject _cell) {
        super.deepCopy(_cell);
        this.filename = _cell.filename;
        this.domainPath = _cell.domainPath;
        this.paramShareReportID = _cell.getParamShareReportID();
        this.setByteArray(_cell.getByteArray());
        if (_cell.subReport != null) {
            try {
                Class<?> subReportClass = Class.forName("quadbase.reportdesigner.ReportAPI.SubReport");
                Constructor<?> subReportConstructor = subReportClass.getConstructor(Class.forName("quadbase.reportdesigner.report.Report"));
                this.subReport = (ISubReport)subReportConstructor.newInstance(_cell.subReport.getReportInfo());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setParameterMap(_cell.getParameterMap());
        this.CACHE_SIZE = _cell.CACHE_SIZE;
        this.reportCache = _cell.reportCache;
        this.diskCache = _cell.diskCache;
        this.colDataVec = _cell.colDataVec;
        this.valueRowMapping = _cell.valueRowMapping;
        this.customerQuery = _cell.customerQuery;
        this.chartPath = _cell.chartPath;
        this.imagePath = _cell.imagePath;
        this.setResizeWidth(_cell.isResizeWidth());
    }

    public boolean equals(SubReportObject _cell) {
        if (_cell == null) {
            return false;
        }
        if (_cell == this) {
            return true;
        }
        if (!super.equals(_cell)) {
            return false;
        }
        if (this.filename != null && _cell.filename != null ? !this.filename.equals(_cell.filename) : this.filename != null || _cell.filename != null) {
            return false;
        }
        if (this.chartPath != null && _cell.chartPath != null ? !this.chartPath.equals(_cell.chartPath) : this.chartPath != null || _cell.chartPath != null) {
            return false;
        }
        return !(this.imagePath != null && _cell.imagePath != null ? !this.imagePath.equals(_cell.imagePath) : this.imagePath != null || _cell.imagePath != null);
    }

    public String getFileName() {
        return this.getFileName(null);
    }

    public String getFileName(FileInMemTable subFilesTable) {
        if (this.domainPath != null) {
            String file = this.filename.replaceAll("\\\\", "/");
            file = file.toLowerCase().indexOf("subreport/") > -1 ? this.filename.substring(file.toLowerCase().lastIndexOf("subreport/")) : this.filename.substring(file.lastIndexOf(47) + 1);
            return this.domainPath + file;
        }
        try {
            String filename2;
            if (subFilesTable != null) {
                String filename22;
                if (!Report.fileExistsInMemoryTable(subFilesTable, this.filename) && (filename22 = this.filename.replaceAll("\\\\", "/")).indexOf("/SubReport/") > -1) {
                    return filename22.substring(filename22.lastIndexOf("/SubReport/") + 1);
                }
            } else if (!new FileInfo(this.filename).exists() && (filename2 = this.filename.replaceAll("\\\\", "/")).indexOf("/SubReport/") > -1) {
                return filename2.substring(filename2.lastIndexOf("/SubReport/") + 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.filename;
    }

    public void setFileName(String fn) {
        this.filename = this.domainPath != null && !this.domainPath.equals("") && fn.startsWith(this.domainPath) ? fn.substring(this.domainPath.length()) : fn;
    }

    public String getParamShareReportID() {
        if (this.paramShareReportID != null && !this.paramShareReportID.trim().equals("")) {
            return this.paramShareReportID;
        }
        return SUBREPORT_DIR + QbUtil.getFileName(this.filename);
    }

    public void setParamShareReportID(String id) {
        this.paramShareReportID = id;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        if (out instanceof VersioningDataOutput) {
            this.write(((VersioningDataOutput)out).getSubFilesTables(), out);
        } else {
            this.write(null, out);
        }
    }

    public void write(FileInMemTable subFilesTable, DataOutput out) throws IOException {
        block9: {
            super.write(out);
            IOUtil.writeStr(out, this.filename);
            IOUtil.writeStr(out, this.paramShareReportID);
            out.writeBoolean(this.resizeWidth);
            if (this.bytearray == null) {
                try {
                    if (Report.fileExists(subFilesTable, this.filename)) {
                        ByteArrayOutputStream bytestream = new ByteArrayOutputStream(2048);
                        ReadDataFile readfile = new ReadDataFile();
                        String fname = LoadReport.generateFullName(this.filename);
                        DataInputStream in = readfile.getInputStream(subFilesTable, fname);
                        out.writeBoolean(true);
                        int c = in.read();
                        while (c != -1) {
                            bytestream.write(c);
                            c = in.read();
                        }
                        in.close();
                        bytestream.close();
                        byte[] barray = bytestream.toByteArray();
                        out.writeInt(barray.length);
                        out.write(barray);
                        break block9;
                    }
                    out.writeBoolean(false);
                }
                catch (Exception ex) {
                    out.writeBoolean(false);
                }
            } else {
                out.writeBoolean(true);
                out.writeInt(this.getByteArray().length);
                out.write(this.getByteArray());
            }
        }
        if (this.parameterMap == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeInt(this.parameterMap.length);
            for (String element : this.parameterMap) {
                IOUtil.writeStr(out, element);
            }
        }
    }

    public void writeByteArray(DataOutput out, FileInMemTable subFilesTable) throws IOException {
        super.write(out);
        IOUtil.writeStr(out, this.filename);
        IOUtil.writeStr(out, this.paramShareReportID);
        out.writeBoolean(this.resizeWidth);
        if (this.bytearray == null) {
            ByteArrayOutputStream bytestream = new ByteArrayOutputStream(2048);
            ReadDataFile readfile = new ReadDataFile();
            String fname = LoadReport.generateFullName(this.getFileName());
            String pakFileName = SaveReport.getPakFileName(fname);
            boolean pakExists = false;
            try {
                if (Report.fileExists(subFilesTable, pakFileName)) {
                    pakExists = true;
                    fname = pakFileName;
                }
                DataInputStream in = readfile.getInputStream(subFilesTable, fname);
                out.writeBoolean(true);
                int c = in.read();
                while (c != -1) {
                    bytestream.write(c);
                    c = in.read();
                }
                in.close();
                bytestream.close();
                byte[] barray = bytestream.toByteArray();
                out.writeInt(barray.length);
                out.write(barray);
                this.setByteArray(barray);
                if (pakExists) {
                    new DeleteFile(pakFileName).delete();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                out.writeBoolean(false);
            }
        } else {
            out.writeBoolean(true);
            out.writeInt(this.getByteArray().length);
            out.write(this.getByteArray());
        }
        if (this.parameterMap == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeInt(this.parameterMap.length);
            for (String element : this.parameterMap) {
                IOUtil.writeStr(out, element);
            }
        }
    }

    @Override
    public void writeXML(Writer out, boolean writeElementTag) throws IOException {
        if (writeElementTag) {
            out.write("<SUBREPORTOBJECT>\n");
        }
        super.writeXML(out, false);
        out.write("<SUBREPORT_FILENAME>" + XMLUtil.encodeCDATA(this.filename) + "</SUBREPORT_FILENAME>\n");
        out.write("<SUBREPORT_PARAMSHAREREPORTID>" + XMLUtil.encodeCDATA(this.paramShareReportID) + "</SUBREPORT_PARAMSHAREREPORTID>\n");
        out.write("<SUBREPORT_RESIZEWIDTH>" + this.resizeWidth + "</SUBREPORT_RESIZEWIDTH>");
        if (this.parameterMap != null) {
            for (String element : this.parameterMap) {
                if (element == null) continue;
                out.write("<PARAMETERMAP>" + element + "</PARAMETERMAP>");
            }
        }
        if (writeElementTag) {
            out.write("</SUBREPORTOBJECT>\n");
        }
    }

    public static SubReportObject createSubReportObject(Node node, int version) throws Exception {
        if (!node.getNodeName().equalsIgnoreCase(XMLTAG)) {
            throw new Exception("'SUBREPORTOBJECT' element expected, but found '" + node.getNodeName() + "' element.");
        }
        SubReportObject cell = new SubReportObject();
        cell.readXML(node, version);
        return cell;
    }

    @Override
    public void readXML(Node node, int version) throws Exception {
        int i;
        super.readXML(node, version);
        this.filename = null;
        Vector<String> params = new Vector<String>();
        NodeList nodeList = node.getChildNodes();
        for (i = 0; i < nodeList.getLength(); ++i) {
            Node child = nodeList.item(i);
            if (child.getNodeName().equalsIgnoreCase("SUBREPORT_FILENAME")) {
                this.filename = LoadXMLReportHelper.readCDATA(child);
            }
            if (child.getNodeName().equalsIgnoreCase("SUBREPORT_PARAMSHAREREPORTID")) {
                this.paramShareReportID = LoadXMLReportHelper.readCDATA(child);
            }
            if (child.getNodeName().equalsIgnoreCase("SUBREPORT_RESIZEWIDTH")) {
                this.resizeWidth = LoadXMLReportHelper.parseBoolean(LoadXMLReportHelper.readText(child));
            }
            if (!child.getNodeName().equalsIgnoreCase("PARAMETERMAP")) continue;
            params.addElement(LoadXMLReportHelper.readText(child));
        }
        if (this.filename == null) {
            throw new Exception("Invalid 'SUBREPORTOBJECT' element. Missing 'SUBREPORT_FILENAME' attribute.");
        }
        if (params.size() > 0) {
            this.parameterMap = new String[params.size()];
            for (i = 0; i < this.parameterMap.length; ++i) {
                this.parameterMap[i] = (String)params.elementAt(i);
            }
        }
    }

    public static SubReportObject createSubReportObject(DataInput in, int version) throws Exception {
        return SubReportObject.createSubReportObject(in, version, false, false, null);
    }

    public static SubReportObject createSubReportObject(DataInput in, int version, boolean pack, boolean fromReportDesigner, FileInMemTable subFilesTable) throws Exception {
        return SubReportObject.createSubReportObject(in, version, pack, fromReportDesigner, subFilesTable, false);
    }

    public static SubReportObject createSubReportObject(DataInput in, int version, boolean pack, boolean fromReportDesigner, FileInMemTable subFilesTable, boolean writeToFileSystem) throws Exception {
        return SubReportObject.createSubReportObject(in, version, pack, fromReportDesigner, subFilesTable, writeToFileSystem, "");
    }

    public static SubReportObject createSubReportObject(DataInput in, int version, boolean pack, boolean fromReportDesigner, FileInMemTable subFilesTable, boolean writeToFileSystem, String domainPath) throws Exception {
        return SubReportObject.createSubReportObject(in, version, pack, fromReportDesigner, subFilesTable, writeToFileSystem, domainPath, false);
    }

    public static SubReportObject createSubReportObject(DataInput in, int version, boolean pack, boolean fromReportDesigner, FileInMemTable subFilesTable, boolean writeToFileSystem, String domainPath, boolean loadNewOnly) throws Exception {
        SubReportObject cell = new SubReportObject();
        cell.domainPath = domainPath;
        if (!pack) {
            cell.read(in, version);
        } else {
            cell.readByteArray(in, version, fromReportDesigner, subFilesTable, writeToFileSystem, loadNewOnly);
        }
        return cell;
    }

    public void readByteArray(DataInput in, int version, boolean fromReportDesigner, FileInMemTable subFilesTable, boolean write) throws Exception {
        this.readByteArray(in, version, fromReportDesigner, subFilesTable, write, false);
    }

    public void readByteArray(DataInput in, int version, boolean fromReportDesigner, FileInMemTable subFilesTable, boolean writeToFileSystem, boolean loadNewOnly) throws Exception {
        boolean hasMap;
        boolean hasByteArray;
        super.read(in, version);
        this.filename = SaveReport.getPakFileName(IOUtil.readStr(in));
        this.paramShareReportID = version >= 182 ? IOUtil.readStr(in) : this.filename;
        if (version >= 181) {
            this.resizeWidth = in.readBoolean();
        }
        if (hasByteArray = in.readBoolean()) {
            int count = in.readInt();
            byte[] barray = new byte[count];
            in.readFully(barray, 0, count);
            if (fromReportDesigner && writeToFileSystem) {
                WriteDataFile wdfile = new WriteDataFile();
                wdfile.output(subFilesTable, barray, this.getFileName(subFilesTable));
            } else {
                this.setByteArray(barray);
            }
            this.setText(this.getFileName(subFilesTable));
        }
        if (version > 34 && (hasMap = in.readBoolean())) {
            int count = in.readInt();
            this.parameterMap = new String[count];
            for (int i = 0; i < count; ++i) {
                this.parameterMap[i] = IOUtil.readStr(in);
            }
        }
    }

    @Override
    public void read(DataInput in, int version) throws Exception {
        boolean hasMap;
        int count;
        boolean hasByteArray;
        super.read(in, version);
        this.filename = IOUtil.readStr(in);
        this.paramShareReportID = version >= 182 ? IOUtil.readStr(in) : this.filename;
        if (version >= 181) {
            this.resizeWidth = in.readBoolean();
        }
        if (version >= 141 && (hasByteArray = in.readBoolean())) {
            count = in.readInt();
            byte[] barray = new byte[count];
            in.readFully(barray, 0, count);
            this.setText(this.getFileName());
        }
        if (version > 34 && (hasMap = in.readBoolean())) {
            count = in.readInt();
            this.parameterMap = new String[count];
            for (int i = 0; i < count; ++i) {
                this.parameterMap[i] = IOUtil.readStr(in);
            }
        }
    }

    public SubReportObject(ISubReport sr) {
        this.subReport = sr;
    }

    public ISubReport getSubReport() throws Exception {
        return this.getSubReport(null);
    }

    public ISubReport getSubReport(IReport qbreport) throws Exception {
        boolean isEnterpriseServer = false;
        boolean useBackupData = false;
        boolean optimizeMemory = false;
        try {
            Class<?> qbReportClass = Class.forName("quadbase.reportdesigner.ReportAPI.QbReport");
            Method isForExportOnlyMethod = qbReportClass.getMethod("isForExportOnly", new Class[0]);
            optimizeMemory = (Boolean)isForExportOnlyMethod.invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.getSubReport(isEnterpriseServer, optimizeMemory, useBackupData, qbreport);
    }

    @Deprecated
    public ISubReport getSubReport(boolean isEnterpriseServer, boolean optimizeMemory, boolean useBackupData) throws Exception {
        return this.getSubReport(isEnterpriseServer, optimizeMemory, useBackupData, null);
    }

    public ISubReport getSubReport(boolean isEnterpriseServer, boolean optimizeMemory, boolean useBackupData, IReport ireport) throws Exception {
        if (this.subReport != null) {
            return this.subReport;
        }
        QbReport qbReport = (QbReport)ireport;
        if (this.bytearray != null) {
            try {
                LoadReport loadReport = new LoadReport(false, optimizeMemory);
                if (ireport != null) {
                    loadReport.setSubFilesTable(ireport.getReportInfo().getSubFilesTable());
                }
                loadReport.setRelativeDomainPath(this.domainPath);
                loadReport.setBackupDataUsed(useBackupData);
                Report r = loadReport.loadReport(new DataInputStream(new ByteArrayInputStream(this.bytearray)), null, isEnterpriseServer);
                Class<?> subReportClass = Class.forName("quadbase.reportdesigner.ReportAPI.SubReport");
                Constructor<?> subReportConstructor = subReportClass.getConstructor(Class.forName("quadbase.reportdesigner.report.Report"));
                Class<?> qbReportClass = Class.forName("quadbase.reportdesigner.ReportAPI.QbReport");
                this.subReport = (ISubReport)subReportConstructor.newInstance(r);
                if (ireport != null && ireport.getClass().getName().equals("quadbase.reportdesigner.ReportAPI.QbReport")) {
                    Method setReportObjectForSubReports = qbReportClass.getMethod("setReportObjectForSubReports", Class.forName("java.lang.String"), ISubReport.class);
                    setReportObjectForSubReports.invoke((Object)ireport, this.getFileName(), this.subReport);
                }
                QbReport qbSubReport = (QbReport)((Object)this.subReport);
                qbSubReport.report.domainPath = this.domainPath;
                qbSubReport.setFileName(this.filename);
                if (qbReport != null) {
                    qbSubReport.setPromptForParamValues(qbReport.isPromptForParamValues());
                }
                return this.subReport;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }
        try {
            Class<?> qbReportClass = Class.forName("quadbase.reportdesigner.ReportAPI.QbReport");
            Constructor<?> qbReportConstructor = qbReportClass.getConstructor(Class.forName("java.lang.Object"), Class.forName("java.lang.String"), Class.forName("java.util.Properties"));
            Method getReportInfoMethod = qbReportClass.getMethod("getReportInfo", new Class[0]);
            Properties props = new Properties();
            props.put("enterprise server", isEnterpriseServer ? "true" : "false");
            props.put("optimize memory", optimizeMemory ? "true" : "false");
            props.put("multi-page export", "false");
            props.put("use backup data", useBackupData ? "true" : "false");
            if (this.domainPath != null) {
                props.put("relative domain path", this.domainPath);
            }
            Object qbReportInstance = qbReportConstructor.newInstance(ServerMessage.getParent(), this.getFileName(), props);
            Report r = (Report)getReportInfoMethod.invoke(qbReportInstance, new Object[0]);
            Class<?> subReportClass = Class.forName("quadbase.reportdesigner.ReportAPI.SubReport");
            Constructor<?> subReportConstructor = subReportClass.getConstructor(Class.forName("quadbase.reportdesigner.report.Report"));
            this.subReport = (ISubReport)subReportConstructor.newInstance(r);
            QbReport qbSubReport = (QbReport)((Object)this.subReport);
            if (ireport != null && ireport instanceof QbReport) {
                Method setReportObjectForSubReports = qbReportClass.getMethod("setReportObjectForSubReports", Class.forName("java.lang.String"), ISubReport.class);
                setReportObjectForSubReports.invoke((Object)ireport, this.filename, this.subReport);
                if (qbReport.getSubReportPath() != null) {
                    qbSubReport.setSubReportPath(qbReport.getSubReportPath());
                }
                if (qbReport.getDrillDownPath() != null) {
                    qbSubReport.setDrillDownPath(qbReport.getDrillDownPath());
                }
                if (qbReport.getChartPath() != null) {
                    qbSubReport.setChartPath(qbReport.getChartPath());
                }
                if (qbReport.getImagePath() != null) {
                    qbSubReport.setImagePath(qbReport.getImagePath());
                }
                qbSubReport.setPromptForParamValues(qbReport.isPromptForParamValues());
            }
            if (this.filename != null) {
                qbSubReport.setFileName(this.filename);
            }
            qbSubReport.report.domainPath = this.domainPath;
            return this.subReport;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public boolean hasUsableReport() {
        return this.subReport != null;
    }

    public void setParameterMap(String[] p) {
        this.parameterMap = p;
    }

    public String[] getParameterMap() {
        return this.parameterMap;
    }

    public Report loadReport(Report mainreport, ReportTable tbl) throws Exception {
        return this.loadReport(mainreport, tbl, false);
    }

    public Report loadReport(Report mainreport, ReportTable tbl, boolean useDefaultParamValue) throws Exception {
        String fileName;
        if (this.reportCache.get("temporarySpecialParameterizedReport") != null) {
            if (this.isColDataPopulated()) {
                return this.reloadReportWithParameters((Report)this.reportCache.get("temporarySpecialParameterizedReport"), mainreport, tbl);
            }
            return this.reloadReportWithParameters_std((Report)this.reportCache.get("temporarySpecialParameterizedReport"), mainreport, tbl);
        }
        LoadReport lr = new LoadReport();
        lr.setSubFilesTable(mainreport.getSubFilesTable());
        this.filename = fileName = mainreport.getFileName() != null && SaveReport.isRPTFile(mainreport.getFileName()) ? SaveReport.getRptFileName(this.getFileName()) : this.getFileName();
        if (this.bytearray != null) {
            lr.loadDataHeaderOnly(new DataInputStream(new ByteArrayInputStream(this.bytearray)));
        } else {
            lr.loadDataHeaderOnly(fileName);
        }
        if (mainreport.limitSubReportQueryExecution && this.linkedParameterCount() > 0 && mainreport.dbInfo != null && mainreport.dbInfo.equalsIgnoreQuery(lr.getDBInfo()) && !this.isColDataPopulated()) {
            Report subreport;
            LoadReport loadReport = new LoadReport();
            loadReport.setSubFilesTable(mainreport.getSubFilesTable());
            loadReport.setRelativeDomainPath(this.domainPath);
            if (this.bytearray != null) {
                subreport = loadReport.loadReport(new DataInputStream(new ByteArrayInputStream(this.bytearray)), null);
            } else {
                loadReport.setBackupDataUsed(true);
                subreport = loadReport.loadReportFromFile(fileName);
            }
            subreport.sourceData = subreport.getOriginalSourceData();
            ColData[] newColData = this.fetchColData(mainreport, subreport, tbl);
            if (newColData != null) {
                this.colDataVec.addElement(newColData);
                this.reportCache.put("temporarySpecialParameterizedReport", subreport);
                return this.reloadReportWithParameters(subreport, mainreport, tbl);
            }
        }
        QbDebug.println(0, "use loadReport_std!!!!!!!!!!!!!!!");
        return this.loadReport_std(mainreport, tbl, useDefaultParamValue);
    }

    private ColData[] fetchColData(Report mainreport, Report subreport, ReportTable tbl) {
        try {
            this.setSubReportParameterValues(subreport, mainreport, tbl, false);
            DBInfoBasic newDBInfo = null;
            Vector parameters = new Vector();
            newDBInfo = this.customerQuery != null ? this.constructNewDBInfo(subreport.dbInfo, this.customerQuery, parameters) : this.constructNewDBInfo(mainreport.dbInfo, subreport.dbInfo, parameters);
            ColData[] cData = DBAccess.retrieveResult(parameters, newDBInfo, false, false, null, null, null, false);
            if (cData == null || cData[0] == null || cData[0].getSize() == 0) {
                return null;
            }
            if (this.linkedParameterCount() == 0) {
                return cData;
            }
            Vector<Object> currentValues = new Vector<Object>();
            for (int j = 0; j < this.linkedParameterCount(); ++j) {
                currentValues.addElement(cData[j].getData(0));
            }
            int startIndex = 0;
            boolean different = false;
            for (int i = 1; i < cData[0].getSize(); ++i) {
                int j;
                Vector<Object> temp = new Vector<Object>();
                for (j = 0; j < this.linkedParameterCount(); ++j) {
                    temp.addElement(cData[j].getData(i));
                }
                for (j = 0; j < this.linkedParameterCount(); ++j) {
                    if (currentValues.elementAt(j).equals(temp.elementAt(j))) continue;
                    different = true;
                }
                if (!different) continue;
                this.valueRowMapping.put(currentValues, new int[]{startIndex, i - 1});
                currentValues = new Vector();
                for (int k = 0; k < temp.size(); ++k) {
                    currentValues.addElement(temp.elementAt(k));
                }
                startIndex = i;
                different = false;
            }
            this.valueRowMapping.put(currentValues, new int[]{startIndex, cData[0].getSize() - 1});
            return cData;
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, ex.getMessage());
            QbDebug.println(0, ex);
            return null;
        }
    }

    private DBInfoBasic constructNewDBInfo(DBInfoBasic dbInfo, String query, Vector parameters) {
        if (!(dbInfo instanceof QueryFileInfo) || this.parameterMap == null) {
            return dbInfo;
        }
        DBInfoBasic newDbInfo = new DBInfoBasic(dbInfo);
        newDbInfo.setQuery(query);
        QueryInParam[] pArray = ((QueryFileInfo)dbInfo).getInSet().getParameter();
        for (int i = 0; i < pArray.length; ++i) {
            if (i >= this.parameterMap.length || this.parameterMap[i] != null) continue;
            QueryInParam p = new QueryInParam(pArray[i], query);
            p.setValue(pArray[i].getValue());
            parameters.addElement(p);
        }
        if (parameters.size() > 0) {
            QueryInParam[] qip = new QueryInParam[parameters.size()];
            for (int i = 0; i < parameters.size(); ++i) {
                qip[i] = (QueryInParam)parameters.elementAt(i);
            }
            QueryInParamSet inSet = new QueryInParamSet(qip, query);
            dbInfo = new QueryFileInfo(null, 0, dbInfo, inSet);
            parameters.clear();
            parameters.addElement(inSet);
        }
        return newDbInfo;
    }

    private DBInfoBasic constructNewDBInfo(DBInfoBasic dbInfo_main, DBInfoBasic dbInfo_sub, Vector parameters) throws Exception {
        String query_sub;
        if (!(dbInfo_sub instanceof QueryFileInfo) || this.parameterMap == null) {
            return dbInfo_sub;
        }
        DBInfoBasic dbInfo = new DBInfoBasic(dbInfo_sub);
        String query_main = dbInfo_main.getQuery();
        String query_new = query_sub = dbInfo_sub.getQuery();
        QueryInParam[] pArray = ((QueryFileInfo)dbInfo_sub).getInSet().getParameter();
        String[] linkedParamNames = new String[this.linkedParameterCount()];
        int count = 0;
        for (int i = 0; i < pArray.length; ++i) {
            if (i >= this.parameterMap.length) continue;
            if (this.parameterMap[i] == null) {
                QueryInParam p = new QueryInParam(pArray[i], query_sub);
                p.setValue(pArray[i].getValue());
                parameters.addElement(p);
                continue;
            }
            linkedParamNames[count++] = pArray[i].getParamName();
        }
        String[] linkedColumnNames = new String[count];
        for (int i = 0; i < linkedColumnNames.length; ++i) {
            QueryInParam[] temp = QueryParser.getTableAndColumnName(query_new, linkedParamNames[i]);
            if (temp == null || temp.size() <= 0) continue;
            linkedColumnNames[i] = (String)temp.elementAt(0);
        }
        query_new = QueryParser.addSelectField(query_new, linkedColumnNames);
        if (dbInfo_main instanceof QueryFileInfo) {
            QueryInParam[] mainParams;
            for (QueryInParam mainParam : mainParams = ((QueryFileInfo)dbInfo_main).getInSet().getParameter()) {
                QueryInParam p = new QueryInParam(mainParam, query_main);
                p.setValue(mainParam.getValue());
                parameters.addElement(p);
            }
        }
        query_new = QueryParser.substituteParameterInWhereClause(query_new, linkedColumnNames, linkedParamNames, query_main);
        query_new = QueryParser.addGroupBy(query_new, linkedColumnNames);
        query_new = QueryParser.addOrderBy(query_new, linkedColumnNames);
        QbDebug.println(0, "query===============================================");
        QbDebug.println(0, query_new);
        QbDebug.println(0, "***************************************************");
        if (parameters.size() > 0) {
            QueryInParam[] qip = new QueryInParam[parameters.size()];
            for (int i = 0; i < parameters.size(); ++i) {
                qip[i] = (QueryInParam)parameters.elementAt(i);
            }
            QueryInParamSet inSet = new QueryInParamSet(qip, query_new);
            dbInfo = new QueryFileInfo(null, 0, dbInfo, inSet);
            parameters.clear();
            parameters.addElement(inSet);
        }
        dbInfo.setQuery(query_new);
        return dbInfo;
    }

    public Report reloadReportWithParameters(Report subreport, Report mainreport, ReportTable tbl) throws Exception {
        subreport.setDHTMLViewerUsed(mainreport.isDHTMLViewerUsed());
        if (!this.isColDataPopulated()) {
            return this.reloadReportWithParameters_std(subreport, mainreport, tbl);
        }
        Vector<Object> values = new Vector<Object>();
        if (this.parameterMap != null) {
            for (String element : this.parameterMap) {
                if (element == null) continue;
                try {
                    int index = this.getColumnIndex(tbl, element);
                    String form = "COL(" + index + ")";
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(form.getBytes("UTF-8"));
                    InputStreamReader inputStreamReader = new InputStreamReader((InputStream)inputStream, "UTF-8");
                    Formula formula = new Formula("IVAN", form);
                    NewFormulaParser parser = new NewFormulaParser(inputStreamReader);
                    formula.setFormula(parser.parse(mainreport.formulas, mainreport.getQueryParameters(), mainreport.getFormulaParameters(), "IVAN"));
                    values.addElement(formula.getValue(tbl, 0, 1, 1, 1, 1, mainreport, new ReportCell(), new Object()));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        ColData[] subColData = this.getColData(subreport.colData, values);
        subreport = subreport.setNewData(subColData);
        subreport.setPreviewSecurityLevel(mainreport.getPreviewSecurityLevel());
        if (this.chartPath != null) {
            subreport.setChartPath(this.chartPath);
        }
        if (this.imagePath != null) {
            subreport.setImagePath(this.imagePath);
        }
        return subreport;
    }

    ColData[] getColData(ColData[] tempColData, Vector values) {
        for (ColData element : tempColData) {
            element.getDataSet().removeAllElements();
        }
        int startIndex = 0;
        int endIndex = 0;
        ColData[] colData = this.colDataVec.elementAt(0);
        if (colData != null && colData[0] != null) {
            endIndex = colData[0].getSize();
        }
        if (this.valueRowMapping != null && this.valueRowMapping.size() > 0) {
            startIndex = ((int[])this.valueRowMapping.get(values))[0];
            endIndex = ((int[])this.valueRowMapping.get(values))[1];
        }
        for (int i = 0; i <= endIndex - startIndex; ++i) {
            for (int j = 0; j < tempColData.length; ++j) {
                Object object = colData[this.linkedParameterCount() + j].getData(i + startIndex);
                try {
                    tempColData[j].add(object);
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return tempColData;
    }

    public Report loadReport_std(Report mainreport, ReportTable tbl, boolean useDefaultParamValue) throws Exception {
        boolean hasParam;
        if (this.reportCache.get("temporarySpecialParameterizedReport") != null) {
            return this.reloadReportWithParameters_std((Report)this.reportCache.get("temporarySpecialParameterizedReport"), mainreport, tbl);
        }
        LoadReport loadReport = new LoadReport();
        loadReport.setSubFilesTable(mainreport.getSubFilesTable());
        loadReport.useDefaults = useDefaultParamValue;
        loadReport.setBackupDataUsed(true);
        loadReport.setRelativeDomainPath(this.domainPath);
        Report r = null;
        if (mainreport.getSubFilesTable().containsKey(this.getFileName())) {
            byte[] bytes = mainreport.getSubFilesTable().get(this.getFileName());
            this.bytearray = bytes;
            r = loadReport.loadReport(new DataInputStream(new ByteArrayInputStream(bytes)), null);
        } else {
            r = this.bytearray != null ? loadReport.loadReport(new DataInputStream(new ByteArrayInputStream(this.bytearray)), null) : loadReport.loadReportFromFile(this.getFileName());
        }
        boolean bl = hasParam = r.dbInfo instanceof IQueryFileInfo || r.getFormulaParameters() != null && r.getFormulaParameters().size() != 0;
        if (!hasParam) {
            loadReport = new LoadReport();
            loadReport.setSubFilesTable(mainreport.getSubFilesTable());
            loadReport.useDefaults = useDefaultParamValue;
            loadReport.setBackupDataUsed(mainreport.useBackupData);
            loadReport.setRelativeDomainPath(this.domainPath);
            if (this.bytearray != null) {
                r = loadReport.loadReport(new DataInputStream(new ByteArrayInputStream(this.bytearray)), null);
            } else if (this.bytearray == null) {
                r = loadReport.loadReportFromFile(this.getFileName());
            }
            String key = "<QB>No Parameter<QB>";
            if (Report.useSubReportCache()) {
                this.reportCache.put(key, r);
                this.reportCache.put("lastInsertedKey", key);
            }
        }
        r.setPreviewSecurityLevel(mainreport.getPreviewSecurityLevel());
        if (this.chartPath != null) {
            r.setChartPath(this.chartPath);
        }
        if (this.imagePath != null) {
            r.setImagePath(this.imagePath);
        }
        r.setDHTMLViewerUsed(mainreport.isDHTMLViewerUsed());
        this.reportCache.put("temporarySpecialParameterizedReport", r);
        if (hasParam && !mainreport.useBackupData) {
            r.sourceData = r.getOriginalSourceData();
            r = this.reloadReportWithParameters_std((Report)this.reportCache.get("temporarySpecialParameterizedReport"), mainreport, tbl);
        }
        return r;
    }

    private Object setSubReportParameterValues(Report subreport, Report mainreport, ReportTable tbl, boolean checkParameterMap) throws Exception {
        QueryInParam[] masterParams;
        IQueryInParam[] securityParams;
        Vector<Parameter> formulaParam;
        Vector<Object> key = null;
        if (subreport.dbInfo instanceof QueryFileInfo) {
            Vector<Parameter> queryParam = subreport.getQueryParameters();
            QueryFileInfo qfInfo = (QueryFileInfo)subreport.dbInfo;
            QueryInParam[] pArray = qfInfo.getInSet().getParameter();
            key = new Vector();
            for (int i = 0; i < pArray.length; ++i) {
                Parameter[] subQueryParam;
                Parameter parameter = queryParam.elementAt(i);
                if (checkParameterMap && this.parameterMap != null && i < this.parameterMap.length && this.parameterMap[i] != null) {
                    Object value = null;
                    try {
                        int index = this.getColumnIndex(tbl, this.parameterMap[i]);
                        String form = "COL(" + index + ")";
                        ByteArrayInputStream inputStream = new ByteArrayInputStream(form.getBytes("UTF-8"));
                        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)inputStream, "UTF-8");
                        Formula formula = new Formula("IVAN", form);
                        NewFormulaParser parser = new NewFormulaParser(inputStreamReader);
                        formula.setFormula(parser.parse(mainreport.formulas, mainreport.getQueryParameters(), mainreport.getFormulaParameters(), "IVAN"));
                        value = formula.getValue(tbl, 0, 1, 1, 1, 1, mainreport, new ReportCell(), new Object());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    if (value != null) {
                        pArray[i].setValue(value);
                    }
                } else if (!parameter.isShared()) {
                    if (mainreport.subQueryParamTable != null) {
                        subQueryParam = mainreport.subQueryParamTable.get(this.getParamShareReportID());
                        Parameter subParam = null;
                        for (int j = 0; subQueryParam != null && j < subQueryParam.length; ++j) {
                            if (!subQueryParam[j].getName().equals(parameter.getName())) continue;
                            subParam = subQueryParam[j];
                        }
                        if (subParam != null) {
                            if (pArray[i] instanceof IQueryMultiValueInParam && subParam.isMultiValueParam()) {
                                Vector values = subParam.getValues();
                                if (values != null && values.size() > 0) {
                                    ((IQueryMultiValueInParam)((Object)pArray[i])).setValues(values);
                                }
                            } else {
                                Object value = subParam.getValue();
                                if (value != null) {
                                    pArray[i].setValue(value);
                                }
                            }
                        }
                    }
                } else if (parameter.getSharedReportName().equals("MAIN_REPORT")) {
                    Vector<Parameter> queryParamVec = mainreport.getQueryParameters();
                    for (int j = 0; j < queryParamVec.size(); ++j) {
                        Parameter param = queryParamVec.elementAt(j);
                        if (!parameter.getSharedParamName().equals(param.getName())) continue;
                        if (pArray[i] instanceof IQueryMultiValueInParam && param.isMultiValueParam()) {
                            Vector values = param.getValues();
                            if (values == null || values.size() <= 0) continue;
                            ((IQueryMultiValueInParam)((Object)pArray[i])).setValues(values);
                            continue;
                        }
                        Object value = param.getValue();
                        if (value == null) continue;
                        pArray[i].setValue(value);
                    }
                } else if (mainreport.subQueryParamTable != null) {
                    subQueryParam = mainreport.subQueryParamTable.get(parameter.getSharedReportName());
                    Parameter subParam = null;
                    for (int j = 0; subQueryParam != null && j < subQueryParam.length; ++j) {
                        if (!subQueryParam[j].getName().equals(parameter.getSharedParamName())) continue;
                        subParam = subQueryParam[j];
                    }
                    if (subParam != null) {
                        if (pArray[i] instanceof IQueryMultiValueInParam && subParam.isMultiValueParam()) {
                            Vector values = subParam.getValues();
                            if (values != null && values.size() > 0) {
                                ((IQueryMultiValueInParam)((Object)pArray[i])).setValues(values);
                            }
                        } else {
                            Object value = subParam.getValue();
                            if (value != null) {
                                pArray[i].setValue(value);
                            }
                        }
                    }
                }
                if (pArray[i] instanceof IQueryMultiValueInParam) {
                    Vector<Object> vec = ((IQueryMultiValueInParam)((Object)pArray[i])).getValues();
                    for (int j = 0; vec != null && j < vec.size(); ++j) {
                        key.addElement(vec.elementAt(j));
                    }
                    continue;
                }
                key.addElement(pArray[i].getValue());
            }
        }
        if ((formulaParam = subreport.getFormulaParameters()) != null && formulaParam.size() > 0) {
            if (key == null) {
                key = new Vector<Object>();
            }
            for (int i = 0; i < formulaParam.size(); ++i) {
                Parameter parameter = formulaParam.elementAt(i);
                if (!parameter.isShared()) {
                    if (mainreport.subFormulaParamTable == null) continue;
                    Parameter[] subFormulaParam = mainreport.subFormulaParamTable.get(this.getParamShareReportID());
                    Parameter subParam = null;
                    for (int j = 0; subFormulaParam != null && j < subFormulaParam.length; ++j) {
                        if (!subFormulaParam[j].getName().equals(parameter.getName())) continue;
                        subParam = subFormulaParam[j];
                    }
                    if (subParam == null) continue;
                    if (parameter.isMultiValueParam() && subParam.isMultiValueParam()) {
                        Vector values = subParam.getValues();
                        if (values == null || values.size() <= 0) continue;
                        parameter.setValues(values);
                        continue;
                    }
                    Object value = subParam.getValue();
                    if (value == null) continue;
                    parameter.setValue(value);
                    continue;
                }
                if (parameter.getSharedReportName().equals("MAIN_REPORT")) {
                    Vector<Parameter> formulaParamVec = mainreport.getFormulaParameters();
                    for (int j = 0; j < formulaParamVec.size(); ++j) {
                        Parameter param = formulaParamVec.elementAt(j);
                        if (!parameter.getSharedParamName().equals(param.getName())) continue;
                        if (parameter.isMultiValueParam() && param.isMultiValueParam()) {
                            Vector values = param.getValues();
                            if (values != null && values.size() > 0) {
                                parameter.setValues(values);
                            }
                            for (int k = 0; k < values.size(); ++k) {
                                key.addElement(values.elementAt(k));
                            }
                            continue;
                        }
                        Object value = param.getValue();
                        if (value != null) {
                            parameter.setValue(value);
                        }
                        key.addElement(value);
                    }
                    continue;
                }
                if (mainreport.subFormulaParamTable == null) continue;
                Parameter[] subFormulaParam = mainreport.subFormulaParamTable.get(parameter.getSharedReportName());
                Parameter subParam = null;
                for (int j = 0; subFormulaParam != null && j < subFormulaParam.length; ++j) {
                    if (!subFormulaParam[j].getName().equals(parameter.getSharedParamName())) continue;
                    subParam = subFormulaParam[j];
                }
                if (subParam == null) continue;
                if (parameter.isMultiValueParam() && subParam.isMultiValueParam()) {
                    Vector values = subParam.getValues();
                    if (values == null || values.size() <= 0) continue;
                    parameter.setValues(values);
                    continue;
                }
                Object value = subParam.getValue();
                if (value == null) continue;
                parameter.setValue(value);
            }
        }
        if (subreport.getSecurityQueryParameterMap() != null && mainreport.getPreviewSecurityLevel() != null && subreport.dbInfo instanceof QueryFileInfo && (securityParams = QueryParser.verifyParameters(masterParams = ((QueryFileInfo)subreport.dbInfo).getInSet().getParameter(), (IQueryInParam[])subreport.getSecurityQueryParameterMap().get(mainreport.getPreviewSecurityLevel()))) != null) {
            if (key == null) {
                key = new Vector();
            }
            boolean different = false;
            for (int j = 0; j < masterParams.length; ++j) {
                Vector<Object> sourceObj;
                if (masterParams[j] instanceof QueryMultiValueInParam) {
                    sourceObj = ((QueryMultiValueInParam)securityParams[j]).getValues();
                    if (!different) {
                        Vector<Object> destObj = ((QueryMultiValueInParam)masterParams[j]).getValues();
                        if (sourceObj != null && destObj != null) {
                            if (!((Object)sourceObj).equals(destObj)) {
                                different = true;
                            }
                        } else if (sourceObj != null || destObj != null) {
                            different = true;
                        }
                    }
                    ((QueryMultiValueInParam)masterParams[j]).setValues(sourceObj);
                    for (int k = 0; k < sourceObj.size(); ++k) {
                        key.addElement(sourceObj.elementAt(k));
                    }
                    continue;
                }
                sourceObj = securityParams[j].getValue();
                if (!different) {
                    Object destObj = masterParams[j].getValue();
                    if (sourceObj != null && destObj != null) {
                        if (!((Object)sourceObj).equals(destObj)) {
                            different = true;
                        }
                    } else if (sourceObj != null || destObj != null) {
                        different = true;
                    }
                }
                masterParams[j].setValue(sourceObj);
                key.addElement(sourceObj);
            }
        }
        return key;
    }

    public Report reloadReportWithParameters_std(Report subreport, Report mainreport, ReportTable tbl) throws Exception {
        subreport.setDHTMLViewerUsed(mainreport.isDHTMLViewerUsed());
        Object key = this.setSubReportParameterValues(subreport, mainreport, tbl, true);
        if (key != null) {
            Object fileName;
            boolean found = false;
            Object ref = this.reportCache.get(key);
            if (Report.useSubReportCache()) {
                if (ref != null) {
                    ((Report)ref).getQueryParameters();
                    return (Report)ref;
                }
                fileName = this.diskCache.get(key);
                if (fileName != null) {
                    if (new FileInfo((String)fileName).exists()) {
                        ColData[] colData = new LoadReport().loadColData((String)fileName);
                        subreport = subreport.setNewData(colData);
                        found = true;
                    } else {
                        this.diskCache.clear();
                    }
                }
            }
            if (!found) {
                try {
                    Report temp = ReloadReport.reloadData(new Report(subreport), false);
                    if (temp != null) {
                        subreport = temp;
                    }
                }
                catch (Exception ex) {
                    subreport.getReportTables().elementAt(0).setVisible(false);
                    this.setHeight(0.0);
                    mainreport.setInitializeReportError(LanguageEncoder.getText("Subreport datasource not found!") + "\n" + IOUtil.getStackTrace(ex));
                }
            }
            subreport.setPreviewSecurityLevel(mainreport.getPreviewSecurityLevel());
            if (this.chartPath != null) {
                subreport.setChartPath(this.chartPath);
            }
            if (this.imagePath != null) {
                subreport.setImagePath(this.imagePath);
            }
            if (Report.useSubReportCache()) {
                Object lastInsertedKey;
                if (this.reportCache.size() > this.CACHE_SIZE && (lastInsertedKey = this.reportCache.get("lastInsertedKey")) != null) {
                    this.reportCache.remove(lastInsertedKey);
                }
                this.reportCache.put(key, subreport);
                this.reportCache.put("lastInsertedKey", key);
                if (this.reportCache.size() > this.CACHE_SIZE && this.diskCache.get(key) == null) {
                    try {
                        fileName = this.filename + this.diskCache.size() + ".cd";
                        new SaveReport().saveColData(subreport.colData, (String)fileName);
                        this.diskCache.put(key, fileName);
                    }
                    catch (Exception exception) {}
                }
            }
        } else {
            subreport.setPreviewSecurityLevel(mainreport.getPreviewSecurityLevel());
            if (this.chartPath != null) {
                subreport.setChartPath(this.chartPath);
            }
            if (this.imagePath != null) {
                subreport.setImagePath(this.imagePath);
            }
        }
        return subreport;
    }

    public void setBytes(byte[] barray) throws Exception {
        this.subreportData = barray;
        if (this.subreportData == null) {
            this.subReport = null;
        } else {
            Class<?> qbReportClass = Class.forName("quadbase.reportdesigner.ReportAPI.QbReport");
            Constructor<?> qbReportConstructor = qbReportClass.getConstructor(Class.forName("java.lang.Object"), Array.newInstance(Byte.TYPE, 0).getClass());
            Method getReportInfoMethod = qbReportClass.getMethod("getReportInfo", new Class[0]);
            Object qbReportInstance = qbReportConstructor.newInstance(ServerMessage.getParent(), this.subreportData);
            Report r = (Report)getReportInfoMethod.invoke(qbReportInstance, new Object[0]);
            Class<?> subReportClass = Class.forName("quadbase.reportdesigner.ReportAPI.SubReport");
            Constructor<?> subReportConstructor = subReportClass.getConstructor(Class.forName("quadbase.reportdesigner.report.Report"));
            this.subReport = (ISubReport)subReportConstructor.newInstance(r);
        }
    }

    public byte[] getBytes() throws Exception {
        if (this.subreportData != null) {
            return this.subreportData;
        }
        ISubReport sreport = this.getSubReport();
        if (sreport != null) {
            Report sr = sreport.getReportInfo();
            ByteArrayOutputStream fstream = new ByteArrayOutputStream(2048);
            sr.export(1, fstream, null);
            fstream.close();
            return fstream.toByteArray();
        }
        return null;
    }

    public void clearReportCache() {
        this.clearReportCache(1.0);
    }

    public void clearReportCache(double percent) {
        Enumeration<Object> enum1 = this.reportCache.keys();
        int top = (int)Math.ceil(percent * (double)this.reportCache.size());
        for (int count = 0; enum1.hasMoreElements() && count < top; ++count) {
            this.reportCache.remove(enum1.nextElement());
        }
    }

    public int getCacheSize() {
        return this.CACHE_SIZE;
    }

    public void setCacheSize(int size) {
        if (size < 1) {
            size = 1;
        }
        this.CACHE_SIZE = size;
        Enumeration<Object> enum1 = this.reportCache.keys();
        for (int difference = this.CACHE_SIZE - size; difference > 0 && enum1.hasMoreElements(); --difference) {
            this.reportCache.remove(enum1.nextElement());
        }
    }

    public void setHTMLParameters(String dirLocation, String url, String fileName) {
        this.saveDir = dirLocation;
        this.saveURL = url;
        if (this.saveURL == null || this.saveDir == null) {
            return;
        }
        if (!this.saveDir.endsWith("/") && !this.saveDir.endsWith("\\")) {
            this.saveDir = this.saveDir + File.separator;
        }
        if (!this.saveURL.endsWith("/")) {
            this.saveURL = this.saveURL + "/";
        }
    }

    @Deprecated
    public void setChartPath(String path) {
        this.chartPath = path;
    }

    @Deprecated
    public void setImagePath(String path) {
        this.imagePath = path;
    }

    @Deprecated
    public String getChartPath() {
        return this.chartPath;
    }

    @Deprecated
    public String getImagePath() {
        return this.imagePath;
    }

    public void setByteArray(byte[] barray) {
        this.bytearray = barray;
    }

    public byte[] getByteArray() {
        return this.bytearray;
    }

    public void setSubReport(ISubReport report) {
        this.subReport = report;
        this.setParamShareReportID(this.filename);
    }

    @Override
    public String getText() {
        return this.getText(null);
    }

    public String getText(FileInMemTable subFilesTable) {
        if (this.getFileName(subFilesTable) != null) {
            return this.getFileName(subFilesTable);
        }
        return super.getText();
    }

    public boolean isResizeWidth() {
        return this.resizeWidth;
    }

    public void setResizeWidth(boolean b) {
        this.resizeWidth = b;
    }

    private int getColumnIndex(ReportTable table, String id) {
        for (int i = 0; i < table.getColumnCount(); ++i) {
            if (!id.equals(table.getColumn(i).getID())) continue;
            return i;
        }
        return -1;
    }

    public ISubReport getCachedSubReport() {
        return this.subReport;
    }

    public void deleteSubReportColDataFiles() {
        try {
            int i = 0;
            boolean exists = true;
            while (exists) {
                String s = this.filename + i + ".cd";
                if (new FileInfo(s).exists()) {
                    new DeleteFile(s).delete();
                    exists = true;
                    ++i;
                    continue;
                }
                exists = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int linkedParameterCount() {
        if (this.parameterMap == null) {
            return 0;
        }
        int count = 0;
        for (String element : this.parameterMap) {
            if (element == null) continue;
            ++count;
        }
        return count;
    }

    public void refreshColData() {
        this.colDataVec = new Vector();
        this.reportCache.remove("temporarySpecialParameterizedReport");
    }

    public boolean isColDataPopulated() {
        if (this.colDataVec == null) {
            return false;
        }
        if (this.colDataVec.size() == 0) {
            return false;
        }
        return this.colDataVec.get(0) != null;
    }

    public void setDomainPath(String path) {
        this.domainPath = path;
    }

    public void setDomainAndCheckForUniqueFileName(String path) {
        this.domainPath = path;
        String newFile = "";
        if (this.domainPath != null) {
            String file = this.filename.replaceAll("\\\\", "/");
            file = file.toLowerCase().indexOf("subreport/") > -1 ? this.filename.substring(file.toLowerCase().lastIndexOf("subreport/")) : this.filename.substring(file.lastIndexOf(47) + 1);
            newFile = this.domainPath + file;
        } else {
            try {
                String filename2;
                newFile = !new FileInfo(this.filename).exists() ? ((filename2 = this.filename.replaceAll("\\\\", "/")).indexOf("/SubReport/") > -1 ? filename2.substring(filename2.lastIndexOf("/SubReport/") + 1) : this.filename) : this.filename;
            }
            catch (Exception e) {
                newFile = this.filename;
            }
        }
        boolean useXML = newFile.toLowerCase().endsWith(".xml");
        String tmp = newFile = newFile.substring(0, newFile.length() - 4);
        int ct = 0;
        try {
            while (new FileInfo(newFile + ".rpt").exists() || useXML && new FileInfo(newFile + ".xml").exists()) {
                newFile = tmp + "_" + ct++;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.filename = !useXML ? newFile + ".rpt" : newFile + ".xml";
        this.setText(this.getFileName());
    }

    public String getDomainPath() {
        return this.domainPath;
    }

    public void setCustomerQueryForLinkedSubReport(String query) {
        this.customerQuery = query;
    }

    public String getCustomerQueryForLinkedSubReport() {
        return this.customerQuery;
    }
}

