/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.ReportElements;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Vector;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.QbUtil;
import quadbase.reportdesigner.ReportElements.Bookmark;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.ReportElements.ReportLine;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.ReportElements.ReportTreeTable;
import quadbase.reportdesigner.report.LoadXMLReportHelper;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.ReportGraphics;

public class TableOfContents
extends ReportCell
implements Serializable {
    private Report report;
    public static final String XMLTAG = "TABLEOFCONTENTS";
    private boolean useGroups = true;
    private ReportElement[] elts;
    private boolean[] useTopLevel;
    private boolean showNumbering = true;
    private short numberingStyle = 0;
    public static final short DECIMAL = 0;
    public static final short OUTLINE = 1;
    public static final short BULLETED = 2;
    public static final String[] NUMBERFORMAT = new String[]{"1", "1.", "1)", "1.)"};
    public static final String[] STYLEFORMAT = new String[]{"1 2 3", "A B C", "a b c", "I II III", "i ii iii"};
    private short[] selectedNumberFormat;
    private short[] selectedNumberStyle;
    private int[] startAt;
    public static int numeric = 0;
    public static int upper_alphabet = 1;
    public static int lower_alphabet = 2;
    public static int upper_roman = 3;
    public static int lower_roman = 4;
    public static String[] numericArray;
    public static String[] upperAlphabet;
    public static String[] lowerAlphabet;
    public static String[] upperRoman;
    public static String[] lowerRoman;
    public static int max;
    private int indent = 4;
    private boolean showPageNumber = true;
    private boolean showSpacer = true;
    private short spacerStyle = 0;
    public static final short DASH = 0;
    public static final short SOLID = 1;
    private short layout = 0;
    public static final short LEFTTORIGHT = 0;
    public static final short RIGHTTOLEFT = 1;
    private Vector<Bookmark> bookmarks;
    private Vector<Integer> treeStructure;
    private int levels = 1;
    private boolean enabled = true;
    private boolean modified = true;

    public TableOfContents() {
        super("Table Of Contents");
        this.setResizeToFitContent(true);
        this.populateSequences();
    }

    public TableOfContents(Report report) {
        super("Table Of Contents");
        this.setResizeToFitContent(true);
        this.report = report;
        this.setWidth(6.0);
        this.setHeight(2.0);
        this.populateSequences();
    }

    public void generatesBookmarks(Report report) {
        this.report = report;
        this.bookmarks = new Vector();
        this.setupLevels();
        if (this.useGroups) {
            ReportTable table = report.getReportTables().elementAt(0);
            if (this.treeStructure == null) {
                this.treeStructure = new Vector();
            }
            this.generatesBookmarks(table, 0);
        }
    }

    public Bookmark addBookmark(String title) {
        if (this.bookmarks == null) {
            this.bookmarks = new Vector();
        }
        for (int i = 0; i < this.bookmarks.size(); ++i) {
            Bookmark entry = this.bookmarks.elementAt(i);
            if (!entry.getTitle().equals(title)) continue;
            return entry;
        }
        Vector<Integer> vec = new Vector<Integer>();
        vec.addElement(this.bookmarks.size());
        Bookmark newEntry = new Bookmark(title, vec);
        if (!this.useGroups) {
            this.bookmarks.addElement(newEntry);
        }
        return newEntry;
    }

    private void generatesBookmarks(ReportTable table, int level) {
        if (table instanceof ReportTreeTable && level < this.levels) {
            Vector<ReportTable> subTables = ((ReportTreeTable)table).getSubTable();
            int[] indexArray = table.indexArray;
            for (int i = 0; i < subTables.size(); ++i) {
                this.treeStructure.addElement(i);
                table = indexArray != null ? subTables.elementAt(indexArray[i]) : subTables.elementAt(i);
                Object object = table.getFirstColumnValue(this.report.breakColIndex[level]);
                String title = "";
                if (object != null) {
                    title = object.toString();
                }
                Bookmark entry = new Bookmark(title, this.treeStructure);
                this.bookmarks.addElement(entry);
                this.generatesBookmarks(table, level + 1);
            }
        }
        if (this.treeStructure.size() > 1) {
            this.treeStructure.removeElementAt(this.treeStructure.size() - 1);
        } else {
            this.treeStructure.removeAllElements();
        }
    }

    public void setUseGroups(boolean useGroups) {
        this.useGroups = useGroups;
        this.setupLevels();
    }

    public boolean isUseGroups() {
        return this.useGroups;
    }

    public boolean isShowNumbering() {
        return this.showNumbering;
    }

    public void setShowNumbering(boolean showNumbering) {
        this.showNumbering = showNumbering;
    }

    public short getNumberingStyle() {
        return this.numberingStyle;
    }

    public void setNumberingStyle(short numberingStyle) {
        this.numberingStyle = numberingStyle;
        if (numberingStyle == 0) {
            if (this.selectedNumberFormat == null) {
                this.selectedNumberFormat = new short[1];
            }
            if (this.selectedNumberStyle == null) {
                this.selectedNumberStyle = new short[1];
            }
            if (this.startAt == null) {
                this.startAt = new int[1];
                this.startAt[0] = 1;
            }
        } else if (numberingStyle == 1) {
            int i;
            if (this.selectedNumberFormat == null) {
                this.selectedNumberFormat = new short[this.levels];
            }
            if (this.selectedNumberStyle == null) {
                this.selectedNumberStyle = new short[this.levels];
            }
            if (this.startAt == null) {
                this.startAt = new int[this.levels];
                for (int i2 = 0; i2 < this.levels; ++i2) {
                    this.startAt[i2] = 1;
                }
            }
            if (this.selectedNumberFormat.length != this.levels) {
                short[] temp = new short[this.levels];
                for (i = 0; i < this.levels; ++i) {
                    if (i >= this.selectedNumberFormat.length) continue;
                    temp[i] = this.selectedNumberFormat[i];
                }
                this.selectedNumberFormat = temp;
            }
            if (this.selectedNumberStyle.length != this.levels) {
                short[] temp = new short[this.levels];
                for (i = 0; i < this.levels; ++i) {
                    if (i >= this.selectedNumberStyle.length) continue;
                    temp[i] = this.selectedNumberStyle[i];
                }
                this.selectedNumberStyle = temp;
            }
            if (this.startAt.length != this.levels) {
                int[] temp = new int[this.levels];
                for (i = 0; i < this.levels; ++i) {
                    temp[i] = i < this.startAt.length ? this.startAt[i] : 1;
                }
                this.startAt = temp;
            }
        }
    }

    public int getIndent() {
        return this.indent;
    }

    public void setIndent(int indent) {
        this.indent = indent;
    }

    public boolean isShowPageNumber() {
        return this.showPageNumber;
    }

    public void setShowPageNumber(boolean b) {
        this.showPageNumber = b;
    }

    public boolean isShowSpacer() {
        return this.showSpacer;
    }

    public void setShowSpacer(boolean b) {
        this.showSpacer = b;
    }

    public short getSpacerStyle() {
        return this.spacerStyle;
    }

    public void setSpacerStyle(short s) {
        this.spacerStyle = s;
    }

    public short getLayout() {
        return this.layout;
    }

    public void setLayout(short s) {
        this.layout = s;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean b) {
        this.enabled = b;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean b) {
        this.modified = b;
    }

    public int getLevels() {
        return this.levels;
    }

    public void setLevels(int levels) {
        this.levels = levels;
    }

    public void setElts(ReportElement[] elts) {
        this.elts = elts;
    }

    public ReportElement[] getElts() {
        return this.elts;
    }

    public void setUseTopLevel(boolean[] b) {
        this.useTopLevel = b;
    }

    public boolean[] isUseTopLevel() {
        return this.useTopLevel;
    }

    public void setSelectedNumberFormat(short[] s) {
        this.selectedNumberFormat = s;
    }

    public short[] getSelectedNumberFormat() {
        return this.selectedNumberFormat;
    }

    public void setSelectedNumberStyle(short[] s) {
        this.selectedNumberStyle = s;
    }

    public short[] getSelectedNumberStyle() {
        return this.selectedNumberStyle;
    }

    public void setStartAt(int[] s) {
        this.startAt = s;
    }

    public int[] getStartAt() {
        return this.startAt;
    }

    public Font getFont(int index) {
        if (this.elts == null || index >= this.elts.length) {
            return null;
        }
        return this.elts[index].getFont();
    }

    public void setFont(int index, Font font) {
        if (this.elts == null || index >= this.elts.length) {
            return;
        }
        this.elts[index].setFont(font);
    }

    public boolean isUnderline(int index) {
        if (this.elts == null || index >= this.elts.length) {
            return false;
        }
        return this.elts[index].isUnderline();
    }

    public void setUnderline(int index, boolean underline) {
        if (this.elts == null || index >= this.elts.length) {
            return;
        }
        this.elts[index].setUnderline(underline);
    }

    public Color getFontColor(int index) {
        if (this.elts == null || index >= this.elts.length) {
            return null;
        }
        return this.elts[index].getFontColor();
    }

    public void setFontColor(int index, Color color) {
        if (this.elts == null || index >= this.elts.length) {
            return;
        }
        this.elts[index].setFontColor(color);
    }

    public boolean isUseTopLevel(int index) {
        if (this.useTopLevel == null || index >= this.useTopLevel.length) {
            return false;
        }
        return this.useTopLevel[index];
    }

    public void setUseTopLevel(int index, boolean b) {
        if (this.useTopLevel == null || index >= this.useTopLevel.length) {
            return;
        }
        this.useTopLevel[index] = b;
    }

    public short getSelectedNumberFormat(int index) {
        if (this.selectedNumberFormat == null || index >= this.selectedNumberFormat.length) {
            return -1;
        }
        return this.selectedNumberFormat[index];
    }

    public void setSelectedNumberFormat(int index, short s) {
        if (this.selectedNumberFormat == null || index >= this.selectedNumberFormat.length) {
            return;
        }
        this.selectedNumberFormat[index] = s;
    }

    public short getSelectedNumberStyle(int index) {
        if (this.selectedNumberStyle == null || index >= this.selectedNumberStyle.length) {
            return -1;
        }
        return this.selectedNumberStyle[index];
    }

    public void setSelectedNumberStyle(int index, short s) {
        if (this.selectedNumberStyle == null || index >= this.selectedNumberStyle.length) {
            return;
        }
        this.selectedNumberStyle[index] = s;
    }

    public int getStartAt(int index) {
        if (this.startAt == null || index >= this.startAt.length) {
            return 1;
        }
        return this.startAt[index];
    }

    public void setStartAt(int index, int s) {
        if (this.startAt == null || index >= this.startAt.length) {
            return;
        }
        this.startAt[index] = s;
    }

    public void setStartAt(int index, String s) {
        block6: {
            block9: {
                block8: {
                    block7: {
                        block5: {
                            if (this.startAt == null || index >= this.startAt.length) {
                                return;
                            }
                            if (this.selectedNumberStyle[index] != numeric) break block5;
                            this.startAt[index] = Integer.parseInt(s);
                            break block6;
                        }
                        if (this.selectedNumberStyle[index] != upper_alphabet) break block7;
                        for (int i = 1; i < upperAlphabet.length; ++i) {
                            if (upperAlphabet[i] != s) continue;
                            this.startAt[index] = i;
                            return;
                        }
                        break block6;
                    }
                    if (this.selectedNumberStyle[index] != lower_alphabet) break block8;
                    for (int i = 1; i < lowerAlphabet.length; ++i) {
                        if (lowerAlphabet[i] != s) continue;
                        this.startAt[index] = i;
                        return;
                    }
                    break block6;
                }
                if (this.selectedNumberStyle[index] != upper_roman) break block9;
                for (int i = 1; i < upperAlphabet.length; ++i) {
                    if (upperRoman[i] != s) continue;
                    this.startAt[index] = i;
                    return;
                }
                break block6;
            }
            if (this.selectedNumberStyle[index] != lower_roman) break block6;
            for (int i = 1; i < lowerAlphabet.length; ++i) {
                if (lowerRoman[i] != s) continue;
                this.startAt[index] = i;
                return;
            }
        }
    }

    public Vector<Bookmark> getBookmarks() {
        return this.bookmarks;
    }

    public void setBookmarks(Vector<Bookmark> b) {
        this.bookmarks = b;
    }

    public void setReport(Report report) {
        this.report = report;
    }

    public Report getReport() {
        return this.report;
    }

    public void populateSequences() {
        numericArray = new String[max];
        upperAlphabet = new String[max];
        lowerAlphabet = new String[max];
        upperRoman = new String[max];
        lowerRoman = new String[max];
        for (int i = 1; i < max; ++i) {
            TableOfContents.numericArray[i] = i + "";
            TableOfContents.upperAlphabet[i] = this.getUpperCaseAlphabet(i);
            TableOfContents.lowerAlphabet[i] = this.getLowerCaseAlphabet(i);
            TableOfContents.upperRoman[i] = this.getRomanNumber(i).toUpperCase();
            TableOfContents.lowerRoman[i] = this.getRomanNumber(i).toLowerCase();
        }
    }

    public String formatNumber(int style, int number) {
        if (style == upper_alphabet) {
            return this.getUpperCaseAlphabet(number);
        }
        if (style == lower_alphabet) {
            return this.getLowerCaseAlphabet(number);
        }
        if (style == upper_roman) {
            return this.getRomanNumber(number).toUpperCase();
        }
        if (style == lower_roman) {
            return this.getRomanNumber(number).toLowerCase();
        }
        return number + "";
    }

    public String getRomanNumber(int i) {
        if (i < 4000) {
            int digit;
            String roman = "";
            if (i > 999) {
                digit = (int)Math.floor(i / 1000);
                roman = this.getThousand(digit);
                i -= digit * 1000;
            }
            if (i > 99) {
                digit = (int)Math.floor(i / 100);
                roman = roman + this.getHundred(digit);
                i -= digit * 100;
            }
            if (i > 9) {
                digit = (int)Math.floor(i / 10);
                roman = roman + this.getTen(digit);
                i -= digit * 10;
            }
            if (i > 0) {
                roman = roman + this.getSingle(i);
            }
            return roman;
        }
        return null;
    }

    public String getThousand(int i) {
        switch (i) {
            case 1: {
                return "M";
            }
            case 2: {
                return "MM";
            }
            case 3: {
                return "MMM";
            }
        }
        return "";
    }

    public String getHundred(int i) {
        switch (i) {
            case 1: {
                return "C";
            }
            case 2: {
                return "CC";
            }
            case 3: {
                return "CCC";
            }
            case 4: {
                return "CD";
            }
            case 5: {
                return "D";
            }
            case 6: {
                return "DC";
            }
            case 7: {
                return "DCC";
            }
            case 8: {
                return "DCCC";
            }
            case 9: {
                return "CM";
            }
        }
        return "";
    }

    public String getTen(int i) {
        switch (i) {
            case 1: {
                return "X";
            }
            case 2: {
                return "XX";
            }
            case 3: {
                return "XXX";
            }
            case 5: {
                return "L";
            }
            case 4: 
            case 6: {
                return "LX";
            }
            case 7: {
                return "LXX";
            }
            case 8: {
                return "LXXX";
            }
            case 9: {
                return "XC";
            }
        }
        return "";
    }

    public String getSingle(int i) {
        switch (i) {
            case 1: {
                return "I";
            }
            case 2: {
                return "II";
            }
            case 3: {
                return "III";
            }
            case 4: {
                return "IV";
            }
            case 5: {
                return "V";
            }
            case 6: {
                return "VI";
            }
            case 7: {
                return "VII";
            }
            case 8: {
                return "VIII";
            }
            case 9: {
                return "IX";
            }
        }
        return "";
    }

    public String getUpperCaseAlphabet(int i) {
        int repeat = (int)Math.floor(--i / 26);
        int mod = i % 26;
        char c = Character.valueOf((char)(65 + mod)).charValue();
        String s = c + "";
        for (int j = 0; j < repeat; ++j) {
            s = s + c;
        }
        return s;
    }

    public String getLowerCaseAlphabet(int i) {
        int repeat = (int)Math.floor(--i / 26);
        int mod = i % 26;
        char c = Character.valueOf((char)(97 + mod)).charValue();
        String s = c + "";
        for (int j = 0; j < repeat; ++j) {
            s = s + c;
        }
        return s;
    }

    public void copy(TableOfContents toc) {
        super.copy(toc);
        this.setUseGroups(toc.isUseGroups());
        this.setElts(toc.getElts());
        this.setUseTopLevel(toc.isUseTopLevel());
        this.setShowNumbering(toc.isShowNumbering());
        this.setNumberingStyle(toc.getNumberingStyle());
        this.setSelectedNumberFormat(toc.getSelectedNumberFormat());
        this.setSelectedNumberStyle(toc.getSelectedNumberStyle());
        this.setStartAt(toc.getStartAt());
        this.setIndent(toc.getIndent());
        this.setShowPageNumber(toc.isShowPageNumber());
        this.setShowSpacer(toc.isShowSpacer());
        this.setSpacerStyle(toc.getSpacerStyle());
        this.setLayout(toc.getLayout());
        this.setBookmarks(toc.getBookmarks());
        this.setLevels(toc.getLevels());
        this.setEnabled(toc.isEnabled());
        this.setModified(toc.isModified());
        this.setReport(toc.getReport());
    }

    @Override
    public void write(DataOutput out) throws IOException {
        int i;
        super.write(out);
        out.writeBoolean(this.useGroups);
        out.writeInt(this.levels);
        for (i = 0; i < this.levels; ++i) {
            this.elts[i].write(out);
            out.writeBoolean(this.useTopLevel[i]);
        }
        out.writeBoolean(this.showNumbering);
        out.writeShort(this.numberingStyle);
        out.writeInt(this.selectedNumberFormat.length);
        for (i = 0; i < this.selectedNumberFormat.length; ++i) {
            out.writeShort(this.selectedNumberFormat[i]);
            out.writeShort(this.selectedNumberStyle[i]);
            out.writeInt(this.startAt[i]);
        }
        out.writeInt(this.indent);
        out.writeBoolean(this.showPageNumber);
        out.writeBoolean(this.showSpacer);
        out.writeShort(this.spacerStyle);
        out.writeShort(this.layout);
        out.writeBoolean(this.enabled);
    }

    @Override
    public void read(DataInput in, int version) throws Exception {
        super.read(in, version);
        this.useGroups = in.readBoolean();
        this.levels = in.readInt();
        this.elts = new ReportElement[this.levels];
        this.useTopLevel = new boolean[this.levels];
        for (int i = 0; i < this.levels; ++i) {
            this.elts[i] = new ReportCell();
            this.elts[i].read(in, version);
            this.useTopLevel[i] = in.readBoolean();
        }
        this.showNumbering = in.readBoolean();
        this.numberingStyle = in.readShort();
        int len = in.readInt();
        this.selectedNumberFormat = new short[len];
        this.selectedNumberStyle = new short[len];
        this.startAt = new int[len];
        for (int i = 0; i < len; ++i) {
            this.selectedNumberFormat[i] = in.readShort();
            this.selectedNumberStyle[i] = in.readShort();
            this.startAt[i] = in.readInt();
        }
        this.indent = in.readInt();
        this.showPageNumber = in.readBoolean();
        this.showSpacer = in.readBoolean();
        this.spacerStyle = in.readShort();
        this.layout = in.readShort();
        this.enabled = in.readBoolean();
    }

    @Override
    public void writeXML(Writer out, boolean writeElementTag) throws IOException {
        int i;
        if (writeElementTag) {
            out.write("<TABLEOFCONTENTS>\n");
        }
        super.writeXML(out, false);
        out.write("<TOC_USEGROUP>" + this.useGroups + "</TOC_USEGROUP>\n");
        out.write("<TOC_LEVELS>" + this.levels + "</TOC_LEVELS>\n");
        for (i = 0; i < this.levels; ++i) {
            out.write("<TOC_FONT>");
            this.elts[i].writeXML(out, false);
            out.write("</TOC_FONT>\n");
            out.write("<TOC_USETOPLEVEL>" + this.useTopLevel[i] + "</TOC_USETOPLEVEL>\n");
        }
        out.write("<TOC_SHOWNUMBERING>" + this.showNumbering + "</TOC_SHOWNUMBERING>\n");
        out.write("<TOC_NUMBERINGSTYLE>" + this.numberingStyle + "</TOC_NUMBERINGSTYLE>\n");
        for (i = 0; i < this.selectedNumberFormat.length; ++i) {
            out.write("<TOC_SELECTEDNUMBERFORMAT>" + this.selectedNumberFormat[i] + "</TOC_SELECTEDNUMBERFORMAT>\n");
            out.write("<TOC_SELECTEDNUMBERSTYLE>" + this.selectedNumberStyle[i] + "</TOC_SELECTEDNUMBERSTYLE>\n");
            out.write("<TOC_STARTAT>" + this.startAt[i] + "</TOC_STARTAT>\n");
        }
        out.write("<TOC_INDENT>" + this.indent + "</TOC_INDENT>\n");
        out.write("<TOC_SHOWPAGENUMBER>" + this.showPageNumber + "</TOC_SHOWPAGENUMBER>\n");
        out.write("<TOC_SHOWSPACER>" + this.showSpacer + "</TOC_SHOWSPACER>\n");
        out.write("<TOC_SPACERSTYLE>" + this.spacerStyle + "</TOC_SPACERSTYLE>\n");
        out.write("<TOC_LAYOUT>" + this.layout + "</TOC_LAYOUT>\n");
        out.write("<TOC_ENABLED>" + this.enabled + "</TOC_ENABLED>\n");
        if (writeElementTag) {
            out.write("</TABLEOFCONTENTS>\n");
        }
    }

    @Override
    public void readXML(Node node, int version) throws Exception {
        int i;
        super.readXML(node, version);
        NodeList nodeList = node.getChildNodes();
        Vector<ReportCell> vec = new Vector<ReportCell>();
        Vector<String> vec2 = new Vector<String>();
        Vector<String> vec3 = new Vector<String>();
        Vector<String> vec4 = new Vector<String>();
        Vector<String> vec5 = new Vector<String>();
        for (i = 0; i < nodeList.getLength(); ++i) {
            String s;
            Node child = nodeList.item(i);
            if (child.getNodeName().equalsIgnoreCase("TOC_USEGROUP")) {
                this.useGroups = LoadXMLReportHelper.parseBoolean(LoadXMLReportHelper.readText(child));
            }
            if (child.getNodeName().equalsIgnoreCase("TOC_LEVELS")) {
                this.levels = Integer.parseInt(LoadXMLReportHelper.readText(child));
            }
            if (child.getNodeName().equalsIgnoreCase("TOC_FONT")) {
                ReportCell elt = new ReportCell();
                ((ReportElement)elt).readXML(child, version);
                vec.addElement(elt);
            }
            if (child.getNodeName().equalsIgnoreCase("TOC_USETOPLEVEL")) {
                s = LoadXMLReportHelper.readText(child);
                vec2.addElement(s);
            }
            if (child.getNodeName().equalsIgnoreCase("TOC_SHOWNUMBERING")) {
                this.showNumbering = LoadXMLReportHelper.parseBoolean(LoadXMLReportHelper.readText(child));
            }
            if (child.getNodeName().equalsIgnoreCase("TOC_NUMBERINGSTYLE")) {
                this.numberingStyle = (short)Integer.parseInt(LoadXMLReportHelper.readText(child));
            }
            if (child.getNodeName().equalsIgnoreCase("TOC_SELECTEDNUMBERFORMAT")) {
                s = LoadXMLReportHelper.readText(child);
                vec3.addElement(s);
            }
            if (child.getNodeName().equalsIgnoreCase("TOC_SELECTEDNUMBERSTYLE")) {
                s = LoadXMLReportHelper.readText(child);
                vec4.addElement(s);
            }
            if (child.getNodeName().equalsIgnoreCase("TOC_STARTAT")) {
                s = LoadXMLReportHelper.readText(child);
                vec5.addElement(s);
            }
            if (child.getNodeName().equalsIgnoreCase("TOC_INDENT")) {
                this.indent = Integer.parseInt(LoadXMLReportHelper.readText(child));
            }
            if (child.getNodeName().equalsIgnoreCase("TOC_SHOWPAGENUMBER")) {
                this.showPageNumber = LoadXMLReportHelper.parseBoolean(LoadXMLReportHelper.readText(child));
            }
            if (child.getNodeName().equalsIgnoreCase("TOC_SHOWSPACER")) {
                this.showSpacer = LoadXMLReportHelper.parseBoolean(LoadXMLReportHelper.readText(child));
            }
            if (child.getNodeName().equalsIgnoreCase("TOC_SPACERSTYLE")) {
                this.spacerStyle = (short)Integer.parseInt(LoadXMLReportHelper.readText(child));
            }
            if (child.getNodeName().equalsIgnoreCase("TOC_LAYOUT")) {
                this.layout = (short)Integer.parseInt(LoadXMLReportHelper.readText(child));
            }
            if (!child.getNodeName().equalsIgnoreCase("TOC_ENABLED")) continue;
            this.enabled = LoadXMLReportHelper.parseBoolean(LoadXMLReportHelper.readText(child));
        }
        this.elts = new ReportElement[vec.size()];
        for (i = 0; i < vec.size(); ++i) {
            this.elts[i] = (ReportElement)vec.elementAt(i);
        }
        this.useTopLevel = new boolean[vec2.size()];
        for (i = 0; i < vec2.size(); ++i) {
            this.useTopLevel[i] = LoadXMLReportHelper.parseBoolean((String)vec2.elementAt(i));
        }
        this.selectedNumberFormat = new short[vec3.size()];
        for (i = 0; i < vec3.size(); ++i) {
            this.selectedNumberFormat[i] = (short)Integer.parseInt((String)vec3.elementAt(i));
        }
        this.selectedNumberStyle = new short[vec4.size()];
        for (i = 0; i < vec4.size(); ++i) {
            this.selectedNumberStyle[i] = (short)Integer.parseInt((String)vec4.elementAt(i));
        }
        this.startAt = new int[vec5.size()];
        for (i = 0; i < vec5.size(); ++i) {
            this.startAt[i] = Integer.parseInt((String)vec5.elementAt(i));
        }
    }

    public static TableOfContents createTableOfContents(DataInput in, int version) throws Exception {
        TableOfContents toc = new TableOfContents();
        toc.read(in, version);
        return toc;
    }

    public static TableOfContents createTableOfContents(Node node, int version) throws Exception {
        if (!node.getNodeName().equalsIgnoreCase(XMLTAG)) {
            throw new Exception("'TABLEOFCONTENTS' element expected, but found '" + node.getNodeName() + "' element.");
        }
        TableOfContents toc = new TableOfContents();
        toc.readXML(node, version);
        return toc;
    }

    public void setupLevels() {
        int oldLevels = this.levels;
        if (this.useGroups) {
            if (this.report != null && this.report.breakColIndex != null) {
                this.levels = this.report.breakColIndex.length;
                if (this.report.getReportType() == 2) {
                    this.levels = this.levels - this.report.getColumnBreakCount() - 1;
                }
                if (this.report.getReportType() == 1 && this.report.isAggregationOn()) {
                    --this.levels;
                }
            }
        } else {
            this.levels = 1;
        }
        if (this.elts == null) {
            this.elts = new ReportElement[this.levels];
            for (int i = 0; i < this.levels; ++i) {
                this.elts[i] = new ReportCell();
            }
        }
        if (this.useTopLevel == null) {
            this.useTopLevel = new boolean[this.levels];
        }
        if (oldLevels != this.levels) {
            ReportElement[] temp = new ReportElement[this.levels];
            for (int i = 0; i < this.levels; ++i) {
                temp[i] = i < oldLevels ? this.elts[i] : new ReportCell();
            }
            this.elts = temp;
            boolean[] temp2 = new boolean[this.levels];
            for (int i = 0; i < this.levels; ++i) {
                if (i >= oldLevels) continue;
                temp2[i] = this.useTopLevel[i];
            }
            this.useTopLevel = temp2;
        }
        this.setNumberingStyle(this.numberingStyle);
    }

    public double getIndentInInches(Bookmark entry) {
        return this.getIndentInInches(entry, null);
    }

    public double getIndentInInches(Bookmark entry, ReportGraphics rg) {
        if (this.indent > 0) {
            int ct = this.indent * entry.getLevel();
            int level = entry.getLevel();
            ReportElement elt = null;
            elt = this.useTopLevel[level] ? this.elts[0] : this.elts[level];
            Font font = elt.getRefFontToDraw(this.report.isAdjustFont());
            FontMetrics fm = IOUtil.getOffScreenGraphics().getFontMetrics(font);
            if (rg != null) {
                font = rg.resizeFont(elt.getRefFontToDraw(this.report.isAdjustFont()), " ");
                fm = rg.getFontMetrics(font);
            }
            double width = QbUtil.toInch(fm.charWidth(' '));
            return (double)ct * width;
        }
        return 0.0;
    }

    public int getEntryHeight(Bookmark entry) {
        int level = entry.getLevel();
        ReportElement elt = null;
        elt = this.useTopLevel[level] ? this.elts[0] : this.elts[level];
        FontMetrics fm = IOUtil.getOffScreenGraphics().getFontMetrics(elt.getFont());
        int charH = fm.getHeight();
        return charH;
    }

    public double getEntryHeight(Bookmark entry, double maxWidth) {
        return this.getEntryHeight(entry, maxWidth, null);
    }

    public double getEntryHeight(Bookmark entry, double maxWidth, ReportGraphics rg) {
        int level = entry.getLevel();
        ReportElement elt = null;
        elt = this.useTopLevel[level] ? this.elts[0] : this.elts[level];
        Font font = elt.getRefFontToDraw(this.report.isAdjustFont());
        FontMetrics fm = IOUtil.getOffScreenGraphics().getFontMetrics(font);
        if (rg != null) {
            font = rg.resizeFont(elt.getRefFontToDraw(this.report.isAdjustFont()), entry.getTitle());
            fm = rg.getFontMetrics(font);
        }
        double ratio = (double)font.getSize() / (double)elt.getFont().getSize();
        double width = QbUtil.toInch(fm.stringWidth(entry.getTitle()));
        int ct = (int)Math.ceil(width / maxWidth);
        int charH = fm.getHeight();
        double height = (QbUtil.toInch(charH) + 0.05) * ratio;
        return height * (double)ct;
    }

    public ReportCell getFormattedNumbering(Bookmark entry) {
        return this.getFormattedNumbering(entry, null);
    }

    public ReportCell getFormattedNumbering(Bookmark entry, ReportGraphics rg) {
        int start;
        int[] tree;
        if (this.numberingStyle == 2) {
            return null;
        }
        int level = entry.getLevel();
        ReportElement elt = null;
        elt = this.useTopLevel[level] ? this.elts[0] : this.elts[level];
        String numbering = "";
        if (this.numberingStyle == 0) {
            tree = entry.getTree();
            start = this.startAt[0];
            if (this.selectedNumberFormat[0] == 0) {
                for (int element : tree) {
                    numbering = numbering + (element + start);
                }
            } else if (this.selectedNumberFormat[0] == 1) {
                for (int element : tree) {
                    numbering = numbering + (element + start) + ".";
                }
            } else if (this.selectedNumberFormat[0] == 2) {
                for (int element : tree) {
                    numbering = numbering + (element + start);
                }
                numbering = numbering + ")";
            } else if (this.selectedNumberFormat[0] == 3) {
                for (int element : tree) {
                    numbering = numbering + (element + start) + ".";
                }
                numbering = numbering + ")";
            }
        } else if (this.numberingStyle == 1) {
            tree = entry.getTree();
            start = this.startAt[level];
            short style = this.selectedNumberStyle[level];
            if (this.selectedNumberFormat[level] == 0) {
                numbering = this.formatNumber(style, tree[level] + start);
            } else if (this.selectedNumberFormat[level] == 1) {
                numbering = this.formatNumber(style, tree[level] + start) + ".";
            } else if (this.selectedNumberFormat[level] == 2) {
                numbering = this.formatNumber(style, tree[level] + start) + ")";
            } else if (this.selectedNumberFormat[level] == 3) {
                numbering = this.formatNumber(style, tree[level] + start) + ".)";
            }
        }
        ReportCell cell = new ReportCell(numbering);
        cell.applyTemplate(elt);
        cell.setEntry(entry);
        Font font = elt.getRefFontToDraw(this.report.isAdjustFont());
        FontMetrics fm = IOUtil.getOffScreenGraphics().getFontMetrics(font);
        if (rg != null) {
            font = rg.resizeFont(elt.getRefFontToDraw(this.report.isAdjustFont()), numbering);
            fm = rg.getFontMetrics(font);
        }
        double ratio = (double)font.getSize() / (double)elt.getFont().getSize();
        double width = QbUtil.toInch(fm.stringWidth(numbering + "b")) + 0.05;
        int charH = fm.getHeight();
        double height = QbUtil.toInch(charH) * ratio;
        cell.setWidth(width);
        cell.setHeight(height);
        cell.setAlign((short)1);
        return cell;
    }

    public ReportCell getFormattedTitle(Bookmark entry, double maxWidth) {
        return this.getFormattedTitle(entry, maxWidth, null);
    }

    public ReportCell getFormattedTitle(Bookmark entry, double maxWidth, ReportGraphics rg) {
        int level = entry.getLevel();
        ReportElement elt = null;
        elt = this.useTopLevel[level] ? this.elts[0] : this.elts[level];
        ReportCell cell = new ReportCell(entry.getTitle());
        cell.applyTemplate(elt);
        cell.setEntry(entry);
        Font font = elt.getRefFontToDraw(this.report.isAdjustFont());
        FontMetrics fm = IOUtil.getOffScreenGraphics().getFontMetrics(font);
        if (rg != null) {
            font = rg.resizeFont(elt.getRefFontToDraw(this.report.isAdjustFont()), entry.getTitle());
            fm = rg.getFontMetrics(font);
        }
        double ratio = (double)font.getSize() / (double)elt.getFont().getSize();
        double width = QbUtil.toInch(fm.stringWidth(entry.getTitle() + "b")) + 0.05;
        int charH = fm.getMaxAscent() + fm.getMaxDescent();
        double height = QbUtil.toInch(charH) * ratio;
        if (width < maxWidth) {
            cell.setWidth(width);
            cell.setHeight(height);
        } else {
            cell.setWidth(maxWidth);
            int ct = (int)Math.ceil(width / maxWidth);
            cell.setHeight(height * (double)ct);
        }
        cell.setAlign((short)1);
        return cell;
    }

    public ReportCell getSpacer(double width, double height, Bookmark entry) {
        return this.getSpacer(width, height, entry, null);
    }

    public ReportCell getSpacer(double width, double height, Bookmark entry, ReportGraphics rg) {
        int level = entry.getLevel();
        ReportElement elt = null;
        elt = this.useTopLevel[level] ? this.elts[0] : this.elts[level];
        Font font = elt.getRefFontToDraw(this.report.isAdjustFont());
        if (rg != null) {
            font = rg.resizeFont(elt.getRefFontToDraw(this.report.isAdjustFont()), entry.getTitle());
        }
        double ratio = (double)font.getSize() / (double)elt.getFont().getSize();
        ReportLine line = new ReportLine(false);
        if (this.spacerStyle == 0) {
            line.setLineStyle(3);
        } else if (this.spacerStyle == 1) {
            line.setLineStyle(1);
        }
        line.setWidth(width);
        line.setY(height / ratio);
        line.setBgColor(elt.getFontColor());
        return line;
    }

    public ReportCell getFormattedPageNumber(Bookmark entry) {
        return this.getFormattedPageNumber(entry, null);
    }

    public void setCellHeight(ReportCell cell, double entryHeight, Bookmark entry) {
        int level = entry.getLevel();
        ReportElement elt = null;
        elt = this.useTopLevel[level] ? this.elts[0] : this.elts[level];
        Font font = elt.getRefFontToDraw(this.report.isAdjustFont());
        double ratio = (double)font.getSize() / (double)elt.getFont().getSize();
        cell.setHeight(entryHeight / ratio);
    }

    public ReportCell getFormattedPageNumber(Bookmark entry, ReportGraphics rg) {
        int level = entry.getLevel();
        ReportElement elt = null;
        elt = this.useTopLevel[level] ? this.elts[0] : this.elts[level];
        ReportCell cell = new ReportCell(entry.getPageNumber() + "");
        cell.applyTemplate(elt);
        cell.setEntry(entry);
        Font font = elt.getRefFontToDraw(this.report.isAdjustFont());
        FontMetrics fm = IOUtil.getOffScreenGraphics().getFontMetrics(font);
        if (rg != null) {
            font = rg.resizeFont(elt.getRefFontToDraw(this.report.isAdjustFont()), entry.getPageNumber() + "");
            fm = rg.getFontMetrics(font);
        }
        double width = QbUtil.toInch(fm.stringWidth(entry.getPageNumber() + "b")) + 0.05;
        cell.setWidth(width);
        cell.setAlign((short)2);
        return cell;
    }

    public Bookmark getEntryByTree(Vector<Integer> treeVec) {
        if (this.bookmarks == null || treeVec == null) {
            return null;
        }
        for (int i = 0; i < this.bookmarks.size(); ++i) {
            Bookmark entry = this.bookmarks.elementAt(i);
            if (entry == null || entry.getTree() == null) {
                return null;
            }
            boolean ok = false;
            if (treeVec.size() == entry.getTree().length) {
                ok = true;
            }
            for (int j = 0; ok && j < treeVec.size(); ++j) {
                if (treeVec.elementAt(j) == entry.getTree()[j]) continue;
                ok = false;
            }
            if (!ok) continue;
            return entry;
        }
        return null;
    }

    static {
        max = 99;
    }
}

