/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.ReportViewer;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import quadbase.common.client.ReadURL;
import quadbase.reportdesigner.ReportViewer.CDialog;

public class CBrowseDialog
extends CDialog
implements ActionListener {
    private List fileList;
    private String currentDir;
    private Button goUp;
    private Button ok;
    private Button cancel;
    private TextField dirField;
    private String selectedFile = null;
    private String[] validExtension;
    private static String separator = System.getProperty("file.separator");
    public static String GO_UP = ".." + System.getProperty("file.separator");

    public CBrowseDialog(Object frame, String currentDir) {
        this(frame, currentDir, null);
    }

    public CBrowseDialog(Object frame, String currentDir, String[] ext) {
        super(frame, "Browse Dialog", true);
        if (ext == null) {
            this.validExtension = new String[1];
            this.validExtension[0] = "*";
        } else {
            this.validExtension = ext;
        }
        this.currentDir = currentDir == null ? "" : currentDir;
        this.fileList = new List();
        this.fileList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1) {
                    CBrowseDialog.this.listClickedOnce();
                } else {
                    CBrowseDialog.this.listClickedTwice();
                }
            }
        });
        this.init();
        this.setPosition();
    }

    void setPosition() {
        this.pack();
        Dimension dim = this.getPreferredSize();
        dim.width = dim.width * 3 / 2;
        dim.height = dim.height * 3 / 2;
        this.setSize(dim);
        this.setLocationRelativeTo(this.getParent());
    }

    void init() {
        this.setLayout(new BorderLayout());
        this.dirField = new TextField(this.currentDir);
        this.dirField.addActionListener(this);
        Panel goUpPanel = new Panel();
        goUpPanel.setBackground(Color.lightGray);
        goUpPanel.setLayout(new BorderLayout());
        this.goUp = new Button("Go Up");
        goUpPanel.add("Center", this.goUp);
        this.goUp.addActionListener(this);
        Panel buttonPanel = new Panel();
        buttonPanel.setLayout(new FlowLayout(2));
        buttonPanel.setBackground(Color.lightGray);
        this.ok = new Button("Ok");
        this.cancel = new Button("Cancel");
        buttonPanel.add(this.ok);
        buttonPanel.add(this.cancel);
        this.ok.addActionListener(this);
        this.cancel.addActionListener(this);
        goUpPanel.add("South", buttonPanel);
        this.getFileList(this.currentDir, this.validExtension);
        this.setSeparator();
        this.add("North", this.dirField);
        this.add("Center", this.fileList);
        this.add("South", goUpPanel);
    }

    private void setSeparator() {
        if (this.fileList.getItemCount() > 0) {
            int len = this.fileList.getItem(0).length() - 1;
            if (len < 0) {
                return;
            }
            String tmp = this.fileList.getItem(0).substring(len);
            if (tmp.equals("/") || tmp.equals("\\")) {
                separator = tmp;
                GO_UP = ".." + separator;
                if (!this.fileList.getItem(0).equals(GO_UP)) {
                    this.goUp.setEnabled(false);
                } else {
                    this.goUp.setEnabled(true);
                }
            }
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.fileList.validate();
    }

    private String getParent(String curDir) {
        int sep2;
        int sep1;
        String temp = null;
        temp = curDir.trim().equals("") || curDir.trim().endsWith(GO_UP) ? curDir + GO_UP : ((sep1 = curDir.lastIndexOf(separator, (sep2 = curDir.lastIndexOf(separator)) - 1)) == -1 ? "" : curDir.substring(0, sep1 + 1));
        return temp;
    }

    private void goUpOneLevel() {
        this.setNewList(this.getParent(this.currentDir), true);
    }

    public String getSelectedFile() {
        return this.selectedFile;
    }

    public void removeAllFileList() {
        if (this.fileList == null) {
            return;
        }
        if (this.fileList.countItems() > 0) {
            this.fileList.select(0);
        }
        for (int i = this.fileList.countItems() - 1; i >= 0; --i) {
            this.fileList.remove(i);
        }
    }

    public void listClickedOnce() {
        String file = this.fileList.getSelectedItem();
        if (file == null) {
            return;
        }
        String temp = file.equals(GO_UP) ? this.getParent(this.currentDir) : (this.currentDir.equals("") || this.currentDir.endsWith(separator) ? this.currentDir + file : this.currentDir + separator + file);
        this.dirField.setText(temp);
    }

    public void listClickedTwice() {
        String file = this.fileList.getSelectedItem();
        if (file == null) {
            return;
        }
        if (file.equals(GO_UP)) {
            this.goUpOneLevel();
            return;
        }
        String temp = this.currentDir.equals("") || this.currentDir.endsWith(separator) ? this.currentDir + file : this.currentDir + separator + file;
        if (!file.endsWith(separator)) {
            this.dirField.setText(temp);
            this.selectedFile = this.dirField.getText();
            this.setVisible(false);
            this.dispose();
        } else {
            this.setNewList(temp, true);
        }
    }

    private void setNewList(String temp, boolean setText) {
        if (!this.getFileList(temp, this.validExtension)) {
            return;
        }
        this.currentDir = temp;
        if (setText) {
            this.dirField.setText(temp);
        }
        this.fileList.validate();
    }

    private boolean getFileList(String dirName, String[] validExtension) {
        String[] filenameList = null;
        try {
            filenameList = ReadURL.getFilename(dirName, validExtension);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        if (filenameList == null || filenameList.length == 0) {
            return false;
        }
        this.removeAllFileList();
        for (String element : filenameList) {
            this.fileList.add(element);
        }
        if (this.fileList.getItemCount() > 0 && !this.fileList.getItem(0).equals(GO_UP)) {
            this.goUp.setEnabled(false);
        } else {
            this.goUp.setEnabled(true);
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object target = e.getSource();
        if (target == this.cancel) {
            this.selectedFile = null;
            this.setVisible(false);
            this.dispose();
        } else if (target == this.goUp) {
            this.goUpOneLevel();
        } else if (target == this.ok) {
            this.selectedFile = this.dirField.getText();
            this.setVisible(false);
            this.dispose();
        } else if (target == this.dirField) {
            this.setNewList(this.dirField.getText(), false);
        }
    }

    public String getCurrentDirectory() {
        return this.currentDir;
    }
}

