/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.ReportViewer;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Panel;
import quadbase.common.util.internal.QbUtil;

public class CRuler
extends Panel {
    public static final int SIZE = 19;
    private boolean isVertical;
    private boolean isMetric;
    private int MAXLENGTH;
    private int pageLength;
    private double zoomFactor;

    public CRuler(boolean v, boolean m, int l, int pl, double zf) throws IllegalArgumentException {
        this.isVertical = v;
        this.isMetric = m;
        this.MAXLENGTH = l;
        this.pageLength = pl;
        this.zoomFactor = zf;
        if (this.pageLength > this.MAXLENGTH) {
            throw new IllegalArgumentException("Max lenght must be greater than page length.");
        }
    }

    public void update(boolean v, boolean m, int l, int pl, double zf) throws IllegalArgumentException {
        this.isVertical = v;
        this.isMetric = m;
        this.MAXLENGTH = l;
        this.pageLength = pl;
        this.zoomFactor = zf;
        if (this.pageLength > this.MAXLENGTH) {
            throw new IllegalArgumentException("Max lenght must be greater than page length.");
        }
    }

    public void setZoomFactor(double z) {
        if (z == this.zoomFactor) {
            return;
        }
        this.zoomFactor = z < 0.2 ? 0.2 : z;
    }

    void setMaxLength(int ml) {
        this.MAXLENGTH = ml;
    }

    public void setIsMetric(boolean isMetric) {
        this.isMetric = isMetric;
        this.repaint();
    }

    public boolean isMetric() {
        return this.isMetric;
    }

    public void paintComponent(Graphics g) {
        String text;
        int increment = 2;
        increment = !this.isMetric ? (this.zoomFactor < 0.5 ? 20 : (this.zoomFactor < 0.75 ? 5 : 2)) : (this.zoomFactor < 0.5 ? 40 : (this.zoomFactor < 0.75 ? 20 : 5));
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(Color.gray);
        if (!this.isVertical) {
            g2.fillRect(0, 0, this.MAXLENGTH, 19);
        } else {
            g2.fillRect(0, 0, 19, this.MAXLENGTH);
        }
        g2.setColor(Color.white);
        if (!this.isVertical) {
            g2.fillRect(50, 0, (int)((double)this.pageLength * this.zoomFactor), 19);
        } else {
            g2.fillRect(0, 50, 19, (int)((double)this.pageLength * this.zoomFactor));
        }
        g2.setFont(new Font("SansSerif", 0, 10));
        g2.setColor(Color.black);
        String string = text = this.isMetric ? "cm" : "in";
        if (!this.isVertical) {
            g2.drawString(text, 52, 8);
        } else {
            g2.drawString(text, 1, 59);
        }
        text = null;
        int tickLength = 2;
        double multipler = 1.0;
        if (this.isMetric) {
            multipler = 2.54;
        }
        int end = (int)Math.ceil((double)this.pageLength / (double)QbUtil.toPixel(1.0) * multipler * 20.0);
        for (double i = 1.0; i < (double)end; i += 1.0) {
            int x = 0;
            x = 50 + QbUtil.toPixel(i / 20.0 / multipler * this.zoomFactor);
            if (i % (double)increment != 0.0) continue;
            if (i % 20.0 != 0.0) {
                tickLength = 2;
                text = null;
                if (!this.isVertical) {
                    g2.drawLine(x, 18, x, 19 - tickLength - 1);
                    continue;
                }
                g2.drawLine(18, x, 19 - tickLength - 1, x);
                continue;
            }
            tickLength = 4;
            text = Integer.toString((int)i / 20);
            if (!this.isVertical) {
                g2.drawString(text, x - 3, 8);
                g2.drawLine(x, 18, x, 19 - tickLength - 1);
                continue;
            }
            g2.drawString(text, 1, x + 3);
            g2.drawLine(18, x, 19 - tickLength - 1, x);
        }
    }
}

